c     
c-------------------------------------------------------------------------------
c
c                    Program NEWBORDER, Version 1.00
c                   --------------------------------
c
c    Calculating:
c    ------------
c
c    Conventional (Hilbert space) bond orders and valences
c    (I. Mayer, Chem. Phys. Lett. 97, 270, 1983....)
c    by using a new -- but fully equivalent -- formalism in the 
c    ROHF case and an improved one in correlated ones
C    (I. Mayer, to be published)
c    for a wave function obtained in a "Gaussian" calculation.     
c   
c    This program SHOULD NOT BE USED for UHF or unrestricted DFT
C    calculations; in these case use the original BORDER program
c    or program BO-SPIN-2.
c
c    Cite this program as:
c   ---------------------
c  I. Mayer, Program "NEWBORDER", Version 1.00, Budapest, 2012
c
c-------------------------------------------------------------------------------
C  The program has been written by using parts of the pprogram APOST by
c  I. Mayer and A. Hamza, Budapest, 2000-2003.
c      
c
c                     
c          e-mails: mayer@chemres.hu, mayer.istvan@ttk.mta.hu
c
c ------------------------------------------------------------------------
c
c

      implicit real*8(a-h,o-z)
      common iop(45)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      
      parameter (nmax=500)
      parameter (maxat=20)
      parameter (maxat1=101)
      parameter (maxp=2000)
      common /lim/ llim(nmax),iulim(nmax)
      dimension ibe(20)
c     dimension sam(nmax,nmax)
      dimension h(nmax,nmax)
      dimension pmul(maxat)
      common /c/ps(nmax,nmax),p(nmax,nmax)
      common /opensh/ cb(nmax,nmax)   
      dimension clin(nmax**2)
      equivalence (clin(1),cb(1,1))
      common /pointer/na(maxat)     
      common /hold/ihold(nmax),illim(nmax)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(nmax,nmax),t(nmax,nmax)
c    $ ,            sat(nmax,nmax,maxat)
      common /ia/iznuc(maxat),kop,megall
      common /achi/achi(maxat,maxat)

      common /map/imap(maxp),imap2(maxp),ireadp
      common /qat/qat(maxat)
      common /ovpop/op(maxat,maxat),totq

      dimension mocal(4)
      Dimension mend(92)
      data mend/4h  H ,4h He ,4h Li ,4h Be ,4h  B ,4h  C ,4h  N ,4h  O ,
     $ 4h  F ,4h Ne ,4h Na ,4h Mg ,4h Al ,4h Si ,4h  P ,4h  S ,4h Cl ,
     $ 4h Ar ,4h  K ,4h Ca ,4h Sc ,4h Ti ,4h  V ,4h Cr ,4h Mn ,4h Fe ,
     $ 4h Co ,4h Ni ,4h Cu ,4h Zn ,4h Ga ,4h Ge ,4h As ,4h Se ,4h Br ,
     $ 4h Kr ,4h Rb ,4h Sr ,4h  Y ,4h Zr ,4h Nb ,4h Mo ,4h Tc ,4h Ru ,
     $ 4h Rh ,4h Pd ,4h Ag ,4h Cd ,4h In ,4h Sn ,4h Sb ,4h Te ,4h  I ,
     $ 4h Xe ,4h Cs ,4h Ba ,4h La ,4h Ce ,4h Pr ,4h Nd ,4h Pm ,4h Sn ,
     $ 4h Eu ,4h Gd ,4h Tb ,4h Dy ,4h Ho ,4h Er ,4h Tm ,4h Yb ,4h Lu , 
     $ 4h Hf ,4h Ta ,4h  W ,4h Re ,4h Os ,4h Ir ,4h Pt ,4h Au ,4h Hg ,
     $ 4h Tl ,4h Pb ,4h Bi ,4h Po ,4h At ,4h Rn ,4h Fr ,4h Ra ,4h Ac ,
     $ 4h Th ,4h Pa ,4h  U  /
    


      data itot  /4hTota/
c     data ispin  /'Spin'/
      data irohf1 /4h  RO/
      data irohf2 /4hHF  /
      data mocal /4hAlph,4ha MO,4h coe,4hffic/

      

      call kiir
      call start
 

      
      m=igr

      call getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      if(nat.ne.natoms) stop 7584
      if(m.ne.nbas) stop 7585
      
      call getsome(nmax,nbas,natoms,h)

c     print *,' Calling denstest'
c     call flush
c     call denstest
      
      call inpint(natoms,llim,iulim)
c     call numint
c     if(ireadp.eq.1) call ordersat(nmax,nbas,natoms,h)
  
       tc1=0.d0
       do kat=1,nat
       qat(kat)=0.d0
       enddo

       do mu=1,igr
       kat=ihold(mu)
       x=0.d0
       do itau=1,igr
       x=x+p(mu,itau)*s(itau,mu)
       enddo
       qat(kat)=qat(kat)+x
       tc1=tc1+x
       enddo

       print *,' '
       print *,' '
       print *,' Mulliken populations'
       print *,'---------------------'
       do i=1,nat
       print 61,i,qat(i)
  61   format(i5,f15.10)
       enddo
       print *,'---------------------'
       print 62, tc1
  62   format(' SUM= ',f14.7)
       print *,' '

       
c      if(iuhf.ne.0)kop=1


      call border(P,ps,S,llim,iulim,natoms,nbas)
      stop
      end

      subroutine getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      implicit real*8(a-h,o-z)
      dimension llim(nmax),iulim(nmax),na(maxat)
      NATOMS=0
      NBAS=0
      DO 3 I=1,nmax
      IF(iulim(I).GT.0) NATOMS=I
  3   NBAS=iulim(natoms)
       if(natoms.gt.maxat)then
      write(*,*)'   TOO MANY ATOMS, STOP'
      stop
       endif
      if(natoms.eq.1) then
      write(*,*)'  ONLY ONE ATOM'
      stop  
      endif
      nnn=0
      do 4 i=1,natoms
      na(i)=iulim(i)-llim(i)+1
  4   nnn=nnn+na(i)
      if(nnn.ne.nbas)stop 1212
      nnab=(natoms*(natoms-1))/2
      if(nnab*2.ne.natoms*(natoms-1))stop 1213

      print *,'   '
      write(*,*)natoms,' ATOMS, ',nnab,' ATOMIC PAIRS'
      
      end

      subroutine getsome(ndeckl,nbas,natoms,h)
      implicit real*8(a-h,o-z)
      parameter (maxat=20)
      parameter (nmax=500) 
      parameter (maxp=2000)
      common /stv/ s(nmax,nmax),t(nmax,nmax)
c    $ ,  vv(nmax,nmax,maxat)   
      common /c/ps(nmax,nmax),p(nmax,nmax)
      dimension h(nmax,nmax)
      common /map/imap(maxp),imap2(maxp),ireadp
      m=nbas
       do 121 j=1,m
       jj=imap(j)
       do 121 i=1,m
        ii=imap(i)
  121  h(jj,ii)=s(j,i)
       do 131 i=1,m
       do 131 j=1,m
  131  s(j,i)=h(j,i)
       
       return
       end

      subroutine pm(c,nocc,m,p,ndeckl)  
      implicit real*8(a-h,o-z)
      dimension c(ndeckl,ndeckl),p(ndeckl,ndeckl)
       do 1 i=1,m
       do 1 j=1,m
       x=0.d0
       do 2 k=1,nocc
  2     x=x+c(i,k)*c(j,k)
  1    p(i,j)=2.d0*x

  61  format(1x,8f9.7)

       return
       end

      subroutine inpint(natoms,llim,iulim)
      IMPLICIT REAL*8 (A-H,O-Z)
      
      parameter (maxat=20)
      parameter (nmax=500)
c     dimension g(mgmax)
      dimension llim(nmax),iulim(nmax)
      common /pointer/na(maxat)     
      common /hold/ihold(nmax),illim(nmax)
      common /nat/ nat,igr,ifg,idum3(4)
      common iop(45)
     
      do i=1,natoms
      do mu=llim(i),iulim(i)
      ihold(mu)=i
      enddo
      enddo
   61 format(20i2)

      do i=1,natoms
      illim(i)=llim(i)
      enddo

c     call gamgen
c     do i=1,Natoms
c     call shellat(i,igr,natoms)
c     if(iop(7).ne.0)call unconat(i)
c     enddo
      
      return      
      end


      SUBROUTINE MPRINT(H,N,ndim)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION H(NDIM,NDIM)
      parameter (maxat=20)
      common /ia/ia(maxat),kkk,idummy

      Dimension mend(92)
      data mend/4h  H ,4h He ,4h Li ,4h Be ,4h  B ,4h  C ,4h  N ,4h  O ,
     $ 4h  F ,4h Ne ,4h Na ,4h Mg ,4h Al ,4h Si ,4h  P ,4h  S ,4h Cl ,
     $ 4h Ar ,4h  K ,4h Ca ,4h Sc ,4h Ti ,4h  V ,4h Cr ,4h Mn ,4h Fe ,
     $ 4h Co ,4h Ni ,4h Cu ,4h Zn ,4h Ga ,4h Ge ,4h As ,4h Se ,4h Br ,
     $ 4h Kr ,4h Rb ,4h Sr ,4h  Y ,4h Zr ,4h Nb ,4h Mo ,4h Tc ,4h Ru ,
     $ 4h Rh ,4h Pd ,4h Ag ,4h Cd ,4h In ,4h Sn ,4h Sb ,4h Te ,4h  I ,
     $ 4h Xe ,4h Cs ,4h Ba ,4h La ,4h Ce ,4h Pr ,4h Nd ,4h Pm ,4h Sn ,
     $ 4h Eu ,4h Gd ,4h Tb ,4h Dy ,4h Ho ,4h Er ,4h Tm ,4h Yb ,4h Lu , 
     $ 4h Hf ,4h Ta ,4h  W ,4h Re ,4h Os ,4h Ir ,4h Pt ,4h Au ,4h Hg ,
     $ 4h Tl ,4h Pb ,4h Bi ,4h Po ,4h At ,4h Rn ,4h Fr ,4h Ra ,4h Ac ,
     $ 4h Th ,4h Pa ,4h  U  /
    
    
    
      K=8 
   65 FORMAT(1H0,40X,A4/)
      NMIN=1
      NMAX=MIN0(N,K)
   62 FORMAT(1X,I3,A4,8F9.4)
   1  PRINT 61, (I, mend(ia(i)),I=NMIN,NMAX)
   61 FORMAT(10X,8(1X,I3,A4,1X))
      PRINT 64
   64 FORMAT(1X)
      DO 2 I=1,N
      PRINT 62,I,mend(ia(i)),(H(I,J),J=NMIN,NMAX)
   2  CONTINUE
      NMIN=NMIN+8
      K=K+8
      NMAX=MIN0(N,K)
      IF(NMAX.GE.NMIN) GOTO 71
      RETURN
   71 PRINT 63
   63 FORMAT(1X///)
      GO TO 1
      END

      subroutine kiir
      implicit real*8(a-h,o-z)
      write(*,6670)
      write(*,6661)
 6661 format(/20x,'Program NEWBORDER, Version 1.00')
      write(*,6662)
 6662 format(20x,28(1h-),/)
      write(*,6663)
      write(*,6660)
 6663 format(3x,'Calculating:')
 6660 format(3x,'------------',/)
      write(*,6664)
 6664 format(5x,2h  ,' Conventional (Hilbert space) bond orders and'
     $ , ' valences'/'        (I. Mayer, Chem. Phys.'
     $,'Lett. 97, 270, 1983....)')
      write(*,6665)
 6665 format(5x,2h  ,' by using a new - but equivalent - formalism for',
     $' ROHF case' )
      write(*,6545)
 6545 format(5x,2h  ,' and an improved one for correlated systems.',/,
     $  '        (I.Mayer, to be published)',/) 
 6666 format(3x,'for a wave function obtained in a Gaussian ',
     $ 'calculation (G92, G94, G98, ...?)',//)
      write(*,6667)
      write(*,6668)
      write(*,6669)
 6667 format(2x,' Cite this program as:')
 6668 format(2x,' ---------------------')
 6669 format('   I. Mayer, Program "NEWBORDER", Version 1.00,'
     $ ,' Budapest, 2012.',/)
 6670 format(1x,79(1h-))
      write(*,6670)
      end


      
      
      subroutine denstest
      implicit real*8(a-h,o-z)
      common iop(45)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      
      parameter (nmax=500)
      parameter (maxat=20)
      parameter (maxat1=101)
      parameter (maxp=2000)
      common /lim/ llim(nmax),iulim(nmax)
      dimension ibe(20)
c     dimension sam(nmax,nmax)
      dimension h(nmax,nmax)
      dimension pmul(maxat)
      common /c/ps(nmax,nmax),p(nmax,nmax)
      common /opensh/ cb(nmax,nmax)   
      dimension clin(nmax**2)
      equivalence (clin(1),cb(1,1))
      common /pointer/na(maxat)     
      common /hold/ihold(nmax),illim(nmax)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(nmax,nmax),t(nmax,nmax)
c    $      ,       sat(nmax,nmax,maxat)
      common /ia/iznuc(maxat),kop,megall
      common /achi/achi(maxat,maxat)

      common /map/imap(maxp),imap2(maxp),ireadp
      common /ovpop/op(maxat,maxat),totq

      dimension mocal(4)
    




      data itot  /4hTota/
c     data ispin  /'Spin'/
      data irohf1 /4h  RO/
      data irohf2 /4hHF  /
      data mocal /4hAlph,4ha MO,4h coe,4hffic/
      
c     print *,' Total:'
c     write(*,6145)itot
c6145 format(20a4)
c     call flush

      
      m=igr
      nbas=igr

c     call getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
c     if(nat.ne.natoms) stop 7584
c     if(m.ne.nbas) stop 7585
      
c     call getsome(nmax,nbas,natoms,h)

c     print *,' Checking the number of electrons'
       tc1=0.d0
       do mu=1,igr
c      kat=ihold(mu)
       x=0.d0
       do itau=1,igr
       x=x+p(mu,itau)*s(itau,mu)
       enddo
c      qat(kat,2)=qat(kat,2)+x
       tc1=tc1+x
       enddo

c      print *,'when calc',(qat(i,2),i=1,natoms)

c            print *,tc1,nalf,nb,nalf+nb
       if(dabs(tc1-dfloat(nalf+nb)).gt.0.1d0)then
      print *,' '
      Print *,' WRONG DENSITY  (Trace of DS=', tc1,')'
      rewind 15
      ntriang=(igr*(igr+1))/2
c     print *,' Ntriang',ntriang
      ndens=-1
 200  read(15,150,end=211)(ibe(i),i=1,4)
 150  format(20a4) 
      if(ibe(1).eq.itot)ndens=ndens+1
      goto 200
 211  rewind 15
 212  read(15,150,end=1711)(ibe(i),i=1,4)
      if(ibe(3).eq.irohf1.and.ibe(4).eq.irohf2)then 
      print *,' '
      Print *,' ROHF case'
      goto 2000
      else
      goto 212
      endif
 1711 print *, 'Different data order. Rereading the',  
     $   ndens,'-d/th density of the checkpoint file'   
      ncou=-1
      rewind 15
 220  read(15,150)(ibe(i),i=1,4)
      if(ibe(1).eq.itot)ncou=ncou+1
      if(ncou.eq.ndens) then
      read(15,*)(clin(i),i=1,ntriang)
c     print *, (clin(i),i=1,ntriang)
      goto 230
      else
      endif        
      goto 220

c211  rewind 15
c     ncou=-1
c     rewind 15
c220  read(15,150)(ibe(i),i=1,4)
c     if(ibe(1).eq.itot)ncou=ncou+1
c     if(ncou.eq.ndens) then
c     read(15,*)(clin(i),i=1,ntriang)
c     print *, (clin(i),i=1,ntriang)
c     goto 230
c     else
c     endif        
c     goto 220

 230   ncou=1
      do j=1,i
      do i=j,igr
      p(i,j)=clin(ncou)
      p(j,i)=clin(ncou)
      ncou=ncou+1
      enddo
      enddo
      
      else
      endif


       tc1=0.d0
       do mu=1,igr
c      kat=ihold(mu)
       x=0.d0
       do itau=1,igr
       x=x+p(mu,itau)*s(itau,mu)
       enddo
c      qat(kat,2)=qat(kat,2)+x
       tc1=tc1+x
       enddo

c      print *,'when calc',(qat(i,2),i=1,natoms)

c              print *,tc1,nalf,nb,nalf+nb
       if(dabs(tc1-dfloat(nalf+nb)).gt.0.1d0)then
      Print *,' *** ', tc1
      print *,' WRONG DENSITY.  STOP. '
      STOP
      endif

      
c     do i=1,igr
c     print *,(p(i,j),j=1,i)
c     enddo
       
c     call pm(c,nocc,nbas,p,nmax)
c     print *,'after calling PM'
c     do i=1,igr
c     print 6230,(p(i,j),j=1,i)
c     enddo
c6230 format(5f10.5)    

c       tc1=0.d0
c       do mu=1,igr
c       kat=ihold(mu)
c       x=0.d0
c       do itau=1,igr
c       x=x+p(mu,itau)*s(itau,mu)
c       enddo
c       qat(kat,2)=qat(kat,2)+x
c       tc1=tc1+x
c       enddo
cc      print *,'before calling border',(qat(i,2),i=1,natoms)

 1510  return    
  
       
       

 2000 print *,'Density and spin-density will be re-built by using' 
     $ ,  ' the MO-s'


       rewind 15
 146  read(15,150,end=1000)(ibe(i),i=1,4)

      if(ibe(1).eq.mocal(1).and.ibe(2).eq.mocal(2).
     $ and.ibe(3).eq.mocal(3).and.ibe(4).eq.mocal(4)) then
      read(15,*,err=2003)((cb(i,j),i=1,nbas),j=1,nbas)
 2003 continue    
      else 
      goto 146
      endif
        
      do mu=1,igr
      do nu=1,mu
      x=0.d0
      do i=1,nb
      x=x+cb(mu,i)*cb(nu,i)
      enddo
      p(mu,nu)=2.d0*x
      x=0.d0
      do i=nb+1,nalf
      x=x+cb(mu,i)*cb(nu,i)
      enddo
      p(mu,nu)=p(mu,nu)+x
      p(nu,mu)=p(mu,nu)
      ps(mu,nu)=x
      ps(nu,mu)=x
      enddo
      enddo
      
      T1=0.d0
      T2=0.d0
c     print *,t1,t2,igr
      do mu=1,igr
      do nu=1,igr
      t1=t1+p(mu,nu)*s(nu,mu)
      t2=t2+ps(mu,nu)*s(nu,mu)
      enddo
      enddo
c     print *, 'T1,T2', t1,t2,nalf+nb,nalf-nb
      print *,' '
      if(dabs(t1-dfloat(nalf+nb)).lt.0.01d0.and.
     $  dabs(t2-dfloat(nalf-nb)).lt.0.01d0)then
      print *, 'Now correct density and spin density  (Traces=', 
     $    t1,t2,')'
      else 
      print *, 'Irrecoverable case', t1,t2
      stop
      endif
      
      goto 1510




 
        
      stop  
 1000 stop 1000     
      end 

              
      subroutine border(P,ps,S,llim,iulim,natoms,nbas)
      implicit real*8(a-h,o-z)
      parameter (nmax=500,maxat=20)
      dimension p(nmax,nmax),ps(nmax,nmax),s(nmax,nmax),sp12(nmax,nmax)
      dimension st(nmax,nmax),sm12(nmax,nmax),s23(nmax),s23m(nmax)
      dimension rindex(maxat,maxat),temp(nmax,nmax)
      dimension tindex(maxat),diag(maxat),llim(nmax),iulim(nmax)
      common /qat/qat(maxat)
      common /ia/iz(maxat),kop,megall
      Dimension mend(92)
      dimension kiir1(4),kiir2(4) 
      data mend/4h  H ,4h He ,4h Li ,4h Be ,4h  B ,4h  C ,4h  N ,4h  O ,
     $ 4h  F ,4h Ne ,4h Na ,4h Mg ,4h Al ,4h Si ,4h  P ,4h  S ,4h Cl ,
     $ 4h Ar ,4h  K ,4h Ca ,4h Sc ,4h Ti ,4h  V ,4h Cr ,4h Mn ,4h Fe ,
     $ 4h Co ,4h Ni ,4h Cu ,4h Zn ,4h Ga ,4h Ge ,4h As ,4h Se ,4h Br ,
     $ 4h Kr ,4h Rb ,4h Sr ,4h  Y ,4h Zr ,4h Nb ,4h Mo ,4h Tc ,4h Ru ,
     $ 4h Rh ,4h Pd ,4h Ag ,4h Cd ,4h In ,4h Sn ,4h Sb ,4h Te ,4h  I ,
     $ 4h Xe ,4h Cs ,4h Ba ,4h La ,4h Ce ,4h Pr ,4h Nd ,4h Pm ,4h Sn ,
     $ 4h Eu ,4h Gd ,4h Tb ,4h Dy ,4h Ho ,4h Er ,4h Tm ,4h Yb ,4h Lu , 
     $ 4h Hf ,4h Ta ,4h  W ,4h Re ,4h Os ,4h Ir ,4h Pt ,4h Au ,4h Hg ,
     $ 4h Tl ,4h Pb ,4h Bi ,4h Po ,4h At ,4h Rn ,4h Fr ,4h Ra ,4h Ac ,
     $ 4h Th ,4h Pa ,4h  U  /
    
    
       data kiir1/4h  AT,4hOM  ,4hVALE,4hNCE /
       data kiir2/4h ATO,4hM   ,4hVALE,4hNCE /
c
      do i=1,nbas
      do j=1,nbas
      x=0.d0
      do k=1,nbas
      x=x+p(i,k)*s(k,j)
      enddo
      ps(i,j)=x
      enddo
      enddo
      do iat=1,natoms
      do jat=iat,natoms
      x=0.d0
      do i=llim(iat),iulim(iat)
      do j=llim(jat),iulim(jat)
      x=x+ps(i,j)*ps(j,i)
      enddo
      enddo
      rindex(iat,jat)=x 
      rindex(jat,iat)=x 
      enddo
      enddo


      do i=1,natoms
      diag(i)=2.d0*qat(i)-rindex(i,i)
      rindex(i,i)=0.d0
      enddo

      do i=1,nbas
      do j=1,nbas
      x=2.d0*ps(i,j)
      do k=1,nbas
      x=x-ps(i,k)*ps(k,j)
      enddo
      p(i,j)=x
      enddo
      enddo
 
      x=0.d0
      do i=1,nbas
      x=x+p(i,i)
      enddo
c In P now the matrix uS=2DS-(DS)^2

      Print 617,x
 617  format(' Number of effectively unpaired electrons=',f10.6)  


c      copying the overlap matrix
       do i=1,nbas
       do j=1,nbas
       st(i,j)=s(i,j)
       enddo
       enddo


c Lowdin-orthogonalization of the basis
      
      call sdiag(st,nmax,s23,nbas)
      do i=1,nbas
      x=dsqrt(s23(i))
      s23(i)=x
      s23m(i)=1.d0/x
      enddo
c     print *, (s23(i),i=1,nbas)

      do i=1,nbas
      do j=1,nbas
      x=0.d0
      y=0.d0
      do k=1,nbas
      x=x+st(i,k)*s23(k)*st(j,k)
      y=y+st(i,k)*s23m(k)*st(j,k)
      enddo
      sp12(i,j)=x
      sm12(i,j)=y
      enddo
      enddo

c Calculating matrix u in the orthogonalized basis
      
      do i=1,nbas
      do j=1,nbas
      x=0.d0
      do k=1,nbas
      x=x+sp12(i,k)*p(k,j)
      enddo
      temp(i,j)=x
      enddo
      enddo

      do i=1,nbas
      do j=1,nbas
      x=0.d0
      do k=1,nbas
      x=x+temp(i,k)*sm12(k,j)
      enddo
      p(i,j)=x
      enddo
      enddo

      x=0.d0
      difi=0.d0
      do i=1,nbas
      do j=1,nbas
      difi=dmax1(difi,dabs(p(i,j)-p(j,i)))
      enddo
      x=x+p(i,i)
      enddo

      print *,' '
      print *,' '
      print *,' Hermiticity control=',difi
      print *,' '
      print *,' Trace=',x


c  Diagonalizing matrix u in the orthonormalized basis and calculate
c  its square root


      call sdiag(p,nmax,s23,nbas)
c     print *,' eigenvalues'
c     print *, (s23(i),i=1,nbas)
      do i=1,nbas
      if(s23(i).lt.1.d-7)s23(i)=0.d0
      s23(i)=dsqrt(s23(i))
      enddo
c     print *,'square roots of eigenvalues'
c     print *, (s23(i),i=1,nbas)

      do i=1,nbas
      do j=1,nbas
      x=0.d0
      y=0.d0
      do k=1,nbas
      x=x+p(i,k)*s23(k)*p(j,k)
      enddo
      temp(i,j)=x
      enddo
      enddo

      do i=1,nbas
      do j=1,nbas
      p(i,j)=temp(i,j)
      enddo
      enddo

C  Back-transformation

      do i=1,nbas
      do j=1,nbas
      x=0.d0
      do k=1,nbas
      x=x+sm12(i,k)*p(k,j)
      enddo
      temp(i,j)=x
      enddo
      enddo

      do i=1,nbas
      do j=1,nbas
      x=0.d0
      do k=1,nbas
      x=x+temp(i,k)*sp12(k,j)
      enddo
      p(i,j)=x
      enddo
      enddo






      do i=1,natoms-1
      do j=i+1,natoms
      x=0.d0
      do mu=llim(i),iulim(i)
      do nu=llim(j),iulim(j)
      x=x+p(mu,nu)*p(nu,mu)
      enddo
      enddo
      rindex(i,j)=rindex(i,j)+x
      rindex(j,i)=rindex(i,j)
      enddo
      enddo


      WRITE(*,6342)
 6342 FORMAT(1x,/11X,'   BOND ORDER MATRIX'//)
      CALL Mprint(rindex,NATOMS,maxat)

      do i=1,natoms
      x=0.d0
      do j=1,natoms
      if(i.ne.j)x=x+rindex(i,j)
      enddo
      rindex(i,i)=x      
      enddo

      kmin1=min0(natoms,5)-1
      WRITE(*,611)
      write(*,123)(kiir1(j),j=1,4),((kiir2(j),j=1,4),i=1,kmin1)
      write(*,640) (I,mend(iz(i)),diag(I),I=1,NATOMS)
      print  621
      write(*,640) (I,mend(iz(i)),rindex(I,I),I=1,NATOMS)
      print 612
      print *,' (In the closed shell RHF case should be zero)'
      print *,' '
      do i=1,i
      diag(i)=diag(i)-rindex(i,i)
      enddo
      write(*,640) (I,mend(iz(i)),diag(I),I=1,NATOMS)
 640  format(20(I3,A4,F8.5,4(I3,A4,1X,f8.5)/))
 611  FORMAT(//11X,'TOTAL VALENCES'/)
 621  FORMAT(//11X,'VALENCES USED IN BONDS (SUM OF BOND ORDERS)'/)
 612  FORMAT(//11X,'FREE VALENCES',/)
 123  format(20A4)  


c     print *,' '
c     print 61, (tindex(i),i=1,natoms)
 61   format(1x,6f10.5)

      return
      end




      subroutine input  
      IMPLICIT REAL*8(A-H,O-Z)
      parameter (nmax=500)
      PARAMETER (maxp=2000,maxg=1000,maxc=26,maxat=20) 
      common iop(45)
c     common /fnutab/f(2505,13)
c     common /intertab/d1,d2,d3,d4
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      common /nat/ nat,nbasis,ifg,nocc,nalf,nb,iuhf
      common /c/ c(nmax,nmax),p(nmax,nmax)
      dimension clin(nmax**2)
      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/ coeff(maxg,maxc) 
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)     
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /opensh/ cb(nmax,nmax)   
      equivalence (clin(1),cb(1,1))
      common/map/imap(maxp),imap2(maxp),ireadp
      common /b/ expsh(maxp),c1(maxp),c2(maxp),cdummy(240),x(maxp),
     $  y(maxp),z(maxp),jan(80),ishella(maxp),mnsh(maxp),ishellt(maxp),
     $  iaos(maxg),iaon(20), ncshell,maxl
      common /ia/iznuc(maxat),kop,megall
      dimension msc(maxg),nsh(maxp),cc(7)
      dimension methodb(2),mdeco(1)  
      dimension ibe(20),methodu(2),methodr(2),numat(4),numel(4),
     $ numa(4),numb(4),numbf(4),numcs(4),nhang(4),ndegr(4),numps(6),
     $ numet(3),iatnm(3),nucch(4),icart(4),ishty(3),npons(6),mstat(4),
     $ nprex(4),ncncf(4),nspcf(4),ncosh(4),mocal(4),mocbe(4)
      dimension d1(2504,13),d2(2503,13),d3(2502,13),d4(2501,13)
      dimension mssh(maxg),iatsh(nmax),iatc(nmax)
      character*1 iii(8)
      equivalence (iii(1),ibe(1))
      data dc12 /2.449489743d0/
      data dc11 /1.095445115d0/
      data dc21 /0.866025403d0/
      data dc41 /0.790569415d0/
      data dc42 /1.060660172d0/
      

      data mdeco/4hDEC./
      data methodr/4h  RH,4hF   /
      data methodu/4h  UH,4hF   /
c     data methodb/4h  RB,4h3LYP/
      data numat /4hNumb,4her o,4hf at,4homs /
      data numel/4hNumb,4her o,4hf el,4hectr/
      data numa /4hNumb,4her o,4hf al,4hpha /
      data numb /4hNumb,4her o,4hf be,4hta e/
      data numbf /4hNumb,4her o,4hf ba,4hsis /
      data numcs /4hNumb,4her o,4hf co,4hntra/
      data nhang /4hHigh,4hest ,4hangu,4hlar /
      data ndegr /4hLarg,4hest ,4hdegr,4hee o/
      data numps /4hNumb,4her o,4hf pr,4himit,4hive ,4hshel/
      data numet /4hSCF ,4hEner,4hgy  /
      data iatnm /4hAtom,4hic n,4humbe/
      data nucch /4hNucl,4hear ,4hchar,4hges /
      data icart /4hCurr,4hent ,4hcart,4hesia/
      data ishty /4hShel,4hl ty,4hpes /
      data npons /4hNumb,4her o,4hf pr,4himit,4hives,4h per/
      data mstat /4hShel,4hl to,4h ato,4hm ma/
      data nprex /4hPrim,4hitiv,4he ex,4hpone/
      data ncncf /4hCont,4hract,4hion ,4hcoef/
      data nspcf /4hP(S=,4hP) C,4hontr,4hacti/
      data ncosh /4hCoor,4hdina,4htes ,4hof e/
      data mocal /4hAlph,4ha MO,4h coe,4hffic/
      data mocbe /4hBeta,4h MO ,4hcoef,4hfici/


      data itot  /4hTota/
      data itot2 /4hl SC/
      data itot3 /4hF De/ 
      data ispin  /4hSpin/

      open (14,file='Test.FChk')
      open (15,file='Tmp')
      
c      megall=0 
        
      i=0
  1   read(14,150,end=100)ibe
      i=i+1
      write(15,150)ibe
      goto 1
 9999 print *,' The required input file (Test.FChk) is missing. STOP'      
      stop 9999
 100  if(i.le.5)goto 9999
       rewind 15
      read(15,150)ibe
      write(*,150)ibe
      if(ibe(1).eq.mdeco(1)) megall=1
c      print *,"megall=",megall
      print *,'   '
      read(15,150)ibe
 150  format(20a4) 
      iuhf=0
      irhf=0
      ienerg=0
c     if(ibe(3).eq.methodr(1).and.ibe(4).eq.methodr(2))irhf=1
      if(ibe(3).eq.methodr(1).and.ibe(4).eq.methodr(2))then
         irhf=1
         ienerg=1
      endif 
c     if(ibe(3).eq.methodu(1).and.ibe(4).eq.methodu(2))iuhf=1
      if(ibe(3).eq.methodu(1).and.ibe(4).eq.methodu(2))then
         iuhf=1
         ienerg=1
      endif
      if(ienerg.eq.0) then
      write(*,6721)
 6721 format(//,10x,'The calculation was other than plain RHF/UHF ',
     $ //, ' (In the DFT case the single determinant built up of',
     $ ' the Kohn-Sham orbitals',/,' will be used.)',//)
      endif
      if(iii(3).eq.'R') irhf=1
      if(iii(3).eq.'U') iuhf=1
c     if(iuhf.eq.1) then
c     write(*,*)'  The UHF wave function is used for',
c    $             ' calculations'
c     endif
c     if(iuhf.eq.0.and.ienerg.eq.1)then
c     write(*,*)'  The Kohn-Sham orbitals are used for',
c    $             ' calculations'
c     endif
c     if(iuhf.eq.0.and.irhf.eq.0)then
c     write(*,*)'  The program presently is applicable for the RHF',
c    $  ' and UHF cases only --- STOP'
c     stop 
c     endif
       rewind 15
 126    read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.numat(1).and.ibe(2).eq.numat(2).
     $ and.ibe(3).eq.numat(3).and.ibe(4).eq.numat(4)) then
      backspace 15
      read(15,151)nat
 151  format(55x,i6)   
      else 
      goto 126
      endif
       rewind 15
 127  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.numel(1).and.ibe(2).eq.numel(2).
     $ and.ibe(3).eq.numel(3).and.ibe(4).eq.numel(4)) then
      backspace 15
c nelectr   =the number of electrons in the system
      read(15,151)nelectr
      else 
      goto 127
      endif
       rewind 15
 128  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.numa(1).and.ibe(2).eq.numa(2).
     $ and.ibe(3).eq.numa(3).and.ibe(4).eq.numa(4)) then
      backspace 15
c      nalf      =number of alpha electrons
      read(15,151)nalf   
      else 
      goto 128
      endif
       rewind 15
 129  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.numb(1).and.ibe(2).eq.numb(2).
     $ and.ibe(3).eq.numb(3).and.ibe(4).eq.numb(4)) then
      backspace 15
c      nb        =number of beta electrons
      read(15,151)nb
      else 
      goto 129
      endif
      kop=0
      if(nalf.ne.nb)kop=1
       rewind 15
 130  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.numbf(1).and.ibe(2).eq.numbf(2).
     $ and.ibe(3).eq.numbf(3).and.ibe(4).eq.numbf(4)) then
      backspace 15
c      nbasis    =number of basis funcions
      read(15,151)nbasis
      else 
      goto 130
      endif
       rewind 15
 131  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.numcs(1).and.ibe(2).eq.numcs(2).
     $ and.ibe(3).eq.numcs(3).and.ibe(4).eq.numcs(4)) then
      backspace 15
c      ncshell   =number of contracted shells
      read(15,151)ncshell
      else 
      goto 131
      endif
       rewind 15
 132  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.nhang(1).and.ibe(2).eq.nhang(2).
     $ and.ibe(3).eq.nhang(3).and.ibe(4).eq.nhang(4)) then
      backspace 15
      read(15,151)maxl
      else 
      goto 132
      endif
       rewind 15
 133  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.ndegr(1).and.ibe(2).eq.ndegr(2).
     $ and.ibe(3).eq.ndegr(3).and.ibe(4).eq.ndegr(4)) then
      backspace 15
      read(15,151)maxk
      else 
      goto 133
      endif
       rewind 15
 134  read(15,150,end=1000)(ibe(i),i=1,6)
      if(ibe(1).eq.numps(1).and.ibe(2).eq.numps(2).
     $ and.ibe(3).eq.numps(3).and.ibe(4).eq.numps(4).
     $ and.ibe(5).eq.numps(5).and.ibe(6).eq.numps(6)) then
      backspace 15
c      npshell   =number of primitive shells
      read(15,151)npshell
c     print *,'Number of primitive shells:',npshell
      else 
      goto 134
      endif
       rewind 15
 135  read(15,150,end=1000)(ibe(i),i=1,3)
      if(ibe(1).eq.numet(1).and.ibe(2).eq.numet(2).
     $ and.ibe(3).eq.numet(3)) then
      backspace 15
      read(15,152)escf   
 152  format(45x,d30.10)
      else 
      goto 135
      endif
       rewind 15
 136  read(15,150,end=1000)(ibe(i),i=1,3)
      if(ibe(1).eq.iatnm(1).and.ibe(2).eq.iatnm(2).
     $  and.ibe(3).eq.iatnm(3)) then
c      iznuc     =atomic numbers
      read(15,*)(iznuc(i),i=1,nat)   
      else 
      goto 136
      endif
       rewind 15
 137  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.nucch(1).and.ibe(2).eq.nucch(2).
     $ and.ibe(3).eq.nucch(3).and.ibe(4).eq.nucch(4)) then
c      zn        =nuclear charges
      read(15,*)(zn(i),i=1,nat)
 153  format(10f5.2)
      else 
      goto 137
      endif
       rewind 15
 138  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.icart(1).and.ibe(2).eq.icart(2).
     $ and.ibe(3).eq.icart(3).and.ibe(4).eq.icart(4)) then
c      coord     =Cartesian coordinates
      read(15,*)(coord(1,i),coord(2,i),coord(3,i),i=1,nat)
      else 
      goto 138
      endif
       rewind 15
 139  read(15,150,end=1000)(ibe(i),i=1,3)
      if(ibe(1).eq.ishty(1).and.ibe(2).eq.ishty(2).
     $ and.ibe(3).eq.ishty(3)) then
c      mssh      =shell types (S=0; P=1; D=2; F=3; SP=-1; 5D=-2; 7F=-3)
      read(15,*)(mssh(i),i=1,ncshell)
      else 
      goto 139
      endif
       rewind 15
 140  read(15,150,end=1000)(ibe(i),i=1,6)
      if(ibe(1).eq.npons(1).and.ibe(2).eq.npons(2).
     $ and.ibe(3).eq.npons(3).and.ibe(4).eq.npons(4).
     $ and.ibe(5).eq.npons(5).and.ibe(6).eq.npons(6)) then
c      mnsh      =number of primitives/shell
      read(15,*)(mnsh(i),i=1,ncshell)
 154  format(10i3)
      else 
      goto 140
      endif
       rewind 15
 141  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.mstat(1).and.ibe(2).eq.mstat(2).     
     $ and.ibe(3).eq.mstat(3).and.ibe(4).eq.mstat(4)) then
c      iatsh     =shell to atom map
      read(15,*)(iatsh(i),i=1,ncshell)
      else 
      goto 141
      endif
       rewind 15
 142  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.nprex(1).and.ibe(2).eq.nprex(2).
     $ and.ibe(3).eq.nprex(3).and.ibe(4).eq.nprex(4)) then
      read(15,*)(expsh(i),i=1,npshell)
      else 
      goto 142
      endif
       rewind 15
 143  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.ncncf(1).and.ibe(2).eq.ncncf(2).
     $ and.ibe(3).eq.ncncf(3).and.ibe(4).eq.ncncf(4)) then
      read(15,*)(c1(i),i=1,npshell)
      else 
      goto 143
      endif

      do 1012 ii=1,ncshell
       if(mssh(ii).eq.-1) goto 1123
 1012 continue
      goto 122 
 1123  rewind 15
 144  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.nspcf(1).and.ibe(2).eq.nspcf(2).
     $ and.ibe(3).eq.nspcf(3).and.ibe(4).eq.nspcf(4)) then
      read(15,*)(c2(i),i=1,npshell)
      else 
      goto 144
      endif

 122   rewind 15
 145  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.ncosh(1).and.ibe(2).eq.ncosh(2).
     $ and.ibe(3).eq.ncosh(3).and.ibe(4).eq.ncosh(4)) then
      read(15,111)(x(i),y(i),z(i),i=1,ncshell)
      else 
      goto 145
      endif
       rewind 15
 146  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.mocal(1).and.ibe(2).eq.mocal(2).
     $ and.ibe(3).eq.mocal(3).and.ibe(4).eq.mocal(4)) then
      read(15,*,err=2003)((c(i,j),i=1,nbasis),j=1,nbasis)
 2003 continue    
      else 
      goto 146
      endif
       rewind 15
      if(iuhf.eq.1) then
 147  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.mocbe(1).and.ibe(2).eq.mocbe(2).
     $ and.ibe(3).eq.mocbe(3).and.ibe(4).eq.mocbe(4)) then
      print *,' This program should not be used for UHF or',
     $' unrestricted DFT calculations!'
      print *,' (Use the original program BORDER -- or BO-SPIN-2 -- '
     $ , 'instead.)'
      print *,' '
      STOP 7777
      read(15,*,err=2013)((cb(i,j),i=1,nbasis),j=1,nbasis)
 2013 continue     
      else 
      goto 147
      endif

      endif



      rewind 15
      ntriang=(nbasis*(nbasis+1))/2
      ndens=-1
 200  read(15,150,end=211)(ibe(i),i=1,4)
      if(ibe(1).eq.itot)ndens=ndens+1
      goto 200
c211  print *, 'Ndens',ndens   
 211  if(ndens.ne.1)then
      print *, 'Using the ',ndens,'-d/th density in the checkpoint file'   
      endif
c     print *, ' '
c     print *,'Number of primitive shells',npshell
      ncou=-1
      rewind 15
 220  read(15,150)(ibe(i),i=1,4)
      if(ibe(1).eq.itot)ncou=ncou+1
      if(ncou.eq.ndens) then
              
      if(ienerg.ne.1.and.ndens.eq.1) then
      print 6432
 6432 format(' There is only a single density in',
     $ ' the checkpoint file - it is used.')  
      if(ibe(2).eq.itot2.and.ibe(3).eq.itot3) print 6433
 6433 format(' (Only the SCF density ?)')     
      print *, ' '
      print *, ' '
      endif
      read(15,*)(clin(i),i=1,ntriang)
c     print*,(clin(i),i=1,ntriang)
      goto 230
      else
      endif        
      goto 220

 230  ncou=1
c230  do i=1,nbasis
      do i=1,nbasis
      do j=1,i
      p(i,j)=clin(ncou)
      p(j,i)=clin(ncou)
      ncou=ncou+1
      enddo
      enddo
      

      print *, ' '
      print *,'Number of primitive shells:',npshell

c     rewind 15
c     nsdens=0
c300  read(15,150,end=311)(ibe(i),i=1,4)
c     if(ibe(1).eq.ispin)nsdens=nsdens+1
c     goto 300
c     print *, 'nsdens',nsdens   
c311  if(nsdens.eq.0)goto 400
c     if(nsdens.ne.1)then
c     print *,'Using the',nsdens,'d/th s.density in the checkpoint file'   
c     endif
c     
c     ncou=0 
c     rewind 15
c320  read(15,150)(ibe(i),i=1,4)
c     if(ibe(1).eq.ispin)ncou=ncou+1
c     if(ncou.eq.nsdens) then
c     read(15,*)(clin(i),i=1,ntriang)
c     goto 330
c     else
c     endif        
c     goto 320

c330  ncou=1
c230  do i=1,nbasis
c     do i=1,nbasis
c     do j=1,i
c     c(i,j)=clin(ncou)
c     c(j,i)=clin(ncou)
c     ncou=ncou+1
c     enddo
c     enddo
      

c400  continue
c      nocc      =number of occupied orbitals
      
      nocc=nelectr/2

      ishella(1)=1
      ishellt(1)=iabs(mssh(1))
      do i=2,ncshell
       ishella(i)=ishella(i-1)+mnsh(i-1)
      ishellt(i)=iabs(mssh(i))
      enddo
      
      iaos(1)=1
      do i=2,ncshell
      nn=1
      if(mssh(i-1).eq.1)nn=3
      if(mssh(i-1).eq.-1)nn=4
      if(mssh(i-1).eq.2)nn=6
      if(mssh(i-1).eq.-2)nn=5
      if(mssh(i-1).eq.3)nn=10
      if(mssh(i-1).eq.-3)nn=7
c     if(mssh(i-1).eq.4)nn=15
c     if(mssh(i-1).eq.-4)nn=9
       
       iaos(i)=iaos(i-1)+nn
      
      enddo
      if(mssh(1).eq.1)then
      print *,' The first shell in the system must not be a pure p one'
      print *,'          PROGRAM STOPS'
      stop 4358
      endif
      do i=1,ncshell
      if(mssh(i).eq.1)iaos(i)=iaos(i)-1    
      enddo

      iaos(ncshell+1)=nbasis+1
      ic=1
      ireadsp=0

c      ncont(i)  =number of contractions in the i'th contracted shell


c      if(iabs(maxl).gt.2)then
c      print *,' The present version of the program does not handle ',
c     $ 'F (G...) orbitals'
c      print *,'          PROGRAM STOPS'
c      stop 4359

c      endif 
  
      if(iabs(maxl).ge.2)IOP(7)=1
      if(iabs(maxl).gt.2)IOP(7)=2

      do 420 i=1,ncshell
      ms=mssh(i)
      if(ms.eq.-1)ireadsp=1
      ccc=mnsh(i)
      ia=iatsh(i)
      if(ms.eq.0) then
      nsh(i)=1
      msc(ic)=ms
      ncont(ic)=ccc 
      iatc(ic)=ia
      ic=ic+1
      goto 420
      endif
      if(ms.eq.1)then
      nsh(i)=3
      msc(ic)=1
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=1
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=1
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia
      ic=ic+3
      goto 420
      endif
      if(ms.eq.2)then
      nsh(i)=6
      msc(ic)=2
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=2
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=2
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=2
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      msc(ic+4)=2
      ncont(ic+4)=ccc 
      iatc(ic+4)=ia

      msc(ic+5)=2
      ncont(ic+5)=ccc 
      iatc(ic+5)=ia
      ic=ic+6
      goto 420
      endif
      if(ms.eq.-1)then
      nsh(i)=4
      msc(ic)=0
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=1
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=1
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=1
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      ic=ic+4
      goto 420
      endif
      if(ms.eq.-2)then
      nsh(i)=5
      msc(ic)=-2
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=-2
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=-2
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=-2
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      msc(ic+4)=-2
      ncont(ic+4)=ccc 
      iatc(ic+4)=ia

      ic=ic+5
      goto 420
      endif

      if(ms.eq.3)then
      nsh(i)=10
      msc(ic)=3
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=3
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=3
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=3
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      msc(ic+4)=3
      ncont(ic+4)=ccc 
      iatc(ic+4)=ia

      msc(ic+5)=3
      ncont(ic+5)=ccc 
      iatc(ic+5)=ia

      msc(ic+6)=3
      ncont(ic+6)=ccc 
      iatc(ic+6)=ia

      msc(ic+7)=3
      ncont(ic+7)=ccc 
      iatc(ic+7)=ia

      msc(ic+8)=3
      ncont(ic+8)=ccc 
      iatc(ic+8)=ia

      msc(ic+9)=3
      ncont(ic+9)=ccc 
      iatc(ic+9)=ia
      ic=ic+10
      goto 420
      endif

      if(ms.eq.-3)then
      nsh(i)=7
      msc(ic)=-3
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=-3
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=-3
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=-3
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      msc(ic+4)=-3
      ncont(ic+4)=ccc 
      iatc(ic+4)=ia

      msc(ic+5)=-3
      ncont(ic+5)=ccc 
      iatc(ic+5)=ia

      msc(ic+6)=-3
      ncont(ic+6)=ccc 
      iatc(ic+6)=ia

      ic=ic+7
      goto 420
      endif

      write(*,*)' Unknown orbital type - STOP'
      stop
 420  continue
      ic=ic-1  
      if(ic.ne.nbasis) stop 968

      ipr=1
       inovel=0
      do 123 i=1,nbasis
      lim=ncont(i)
      ncia=ncont(i)
      if(msc(i).eq.-2) then
         if(inovel.eq.0) then
         lim=lim+ncia
         endif
       inovel=inovel+1
       if(inovel.eq.5)inovel=0
      endif
      if(msc(i).eq.-3) then
         if(inovel.eq.0) then
         lim=lim+3*ncia
         endif
       inovel=inovel+1
       if(inovel.eq.7)inovel=0
      endif
      do 123 j=1,lim
      iat(ipr)=iatc(i)
      ipr=ipr+1
 123  continue   
      ipr=ipr-1
 
      ifill(1)=1
      ifiul(1)=ncont(1)
      if(msc(1).eq.-2.or.msc(1).eq.-3)then
        print *,"The first shell must not be a pure D or F one!"
        stop
      endif
      inovel=0 
      do 423 i=2,nbasis
      if(msc(i).eq.-2) then
         iop(8)=1
         if(inovel.le.2) then
           ifill(i)=ifiul(i-1)+1
           ifiul(i)=ifill(i)+ncont(i)-1
           goto 441
         endif
         if(inovel.eq.3) then
           ifill(i)=ifiul(i-1)+1
           ifiul(i)=ifill(i)+2*ncont(i)-1
           goto 441
         endif
         if(inovel.eq.4) then
           ifill(i)=ifill(i-1)
           ifiul(i)=ifill(i)+3*ncont(i)-1 
           goto 441
         endif
 441   inovel=inovel+1
         if(inovel.eq.5)inovel=0
      goto 423
      endif
      if(msc(i).eq.-3) then 

        if(inovel.eq.0.or.inovel.eq.2.or.inovel.eq.4) then
          ifill(i)=ifiul(i-1)+1
          ifiul(i)=ifill(i)+3*ncont(i)-1
          goto 442
        endif
        if(inovel.eq.1.or.inovel.eq.3.or.inovel.eq.5) then
          ifill(i)=ifill(i-1)+1
          ifiul(i)=ifill(i)+2*ncont(i)-1
          goto 442
        endif
        if(inovel.eq.6) then
          ifill(i)=ifiul(i-1)+1
          ifiul(i)=ifill(i)+ncont(i)-1
          goto 442
        endif
 442     inovel=inovel+1
         if(inovel.eq.7) inovel=0
      goto 423 
      endif
      ifill(i)=ifiul(i-1)+1
      ifiul(i)=ifill(i)+ncont(i)-1
 423  continue   
      if(ifiul(nbasis).ne.ipr)stop 7865 

     
      iexp=1
      ipr=1
      do 124 i=1,ncshell
      if(mssh(i).eq.0)then
      do 427 ll=1,mnsh(i)
      do 425 j=1,nsh(i)  
      expp(ipr)=expsh(iexp)
 425  ipr=ipr+1
      iexp=iexp+1
 427  continue 
      goto 124
      endif

      if(mssh(i).eq.1.or.mssh(i).eq.-1.or.mssh(i).eq.2.or.
     $   mssh(i).eq.3)then

       isr=ipr
      do 1778 kk=1,mnsh(i)
      expa=expsh(iexp)
      do 1777 j=1,nsh(i)
 1777 expp(isr+(j-1)*mnsh(i))=expa
      isr=isr+1
      iexp=iexp+1
 1778  continue
      ipr=ipr+nsh(i)*mnsh(i)
      goto 124
      endif

      if(mssh(i).eq.-2) then    
       isr=ipr
       inovel=0
      do 2778 kk=1,mnsh(i)
      expa=expsh(iexp)
      lim=nsh(i)+1
         if(inovel.eq.0) then
c         lim=lim+1
         endif
       inovel=inovel+1
       if(inovel.eq.5)inovel=0
      do 2777 j=1,lim   
 2777 expp(isr+(j-1)*mnsh(i))=expa
      isr=isr+1   
      iexp=iexp+1
 2778  continue
      ipr=ipr+lim*mnsh(i)
      goto 124
      endif

      if(mssh(i).eq.-3) then    
       isr=ipr
       inovel=0
      do 3778 kk=1,mnsh(i)
      expa=expsh(iexp)
      lim=nsh(i)+3
         if(inovel.eq.0) then
c         lim=lim+3
         endif
       inovel=inovel+1
       if(inovel.eq.7)inovel=0
      do 3777 j=1,lim   
 3777 expp(isr+(j-1)*mnsh(i))=expa
      isr=isr+1   
      iexp=iexp+1
 3778  continue
      ipr=ipr+lim*mnsh(i)
      goto 124
      endif

      stop 2222
 124  continue
      ipr=ipr-1


      do 77 i=1,nat
      ivan=0
      do 78 k=1,nbasis
      if(iatc(k).eq.i) then
       if(ivan.eq.0)llim(i)=k
       ivan=1
      endif
      if(ivan.eq.1.and.iatc(k).ne.i)then
       iulim(i)=k-1
       ivan=0
      endif
   78 continue
   77 continue
      iulim(nat)=nbasis

      kk=1
      jj=1
      ipr=1
      do 224 i=1,ncshell
      mmm=mnsh(i)
      if(mssh(i).eq.0)then
      do 225 ll=1,mnsh(i)
      coeff(kk,ll)=c1(jj)
 225  jj=jj+1
      kk=kk+1
      ipr=ipr+mmm 
      goto 224
      endif

      if(mssh(i).eq.1)then
      do 223 ll=1,mnsh(i)
      mmm=mnsh(i)
      coeff(kk,ll)=c1(jj)
      coeff(kk+1,ll)=c1(jj)
      coeff(kk+2,ll)=c1(jj)
      n(ipr+ll-1)=1
      l(ipr+mmm+ll-1)=1
      m(ipr+2*mmm+ll-1)=1
 223  jj=jj+1
      kk=kk+3
      ipr=ipr+3*mmm
      goto 224
      endif

      if(mssh(i).eq.2)then
      do 323 ll=1,mnsh(i)
      mmm=mnsh(i)
      coeff(kk,ll)=c1(jj)
      coeff(kk+1,ll)=c1(jj)
      coeff(kk+2,ll)=c1(jj)
      coeff(kk+3,ll)=c1(jj)
      coeff(kk+4,ll)=c1(jj)
      coeff(kk+5,ll)=c1(jj)
      n(ipr+ll-1)=2
      l(ipr+mmm+ll-1)=2
      m(ipr+2*mmm+ll-1)=2
      n(ipr+3*mmm+ll-1)=1
      l(ipr+3*mmm+ll-1)=1
      n(ipr+4*mmm+ll-1)=1
      m(ipr+4*mmm+ll-1)=1
      l(ipr+5*mmm+ll-1)=1
      m(ipr+5*mmm+ll-1)=1
 323  jj=jj+1
      kk=kk+6
      ipr=ipr+6*mmm
      goto 224
      endif

      if(mssh(i).eq.3)then
      do 523 ll=1,mnsh(i)
      mmm=mnsh(i)
      coeff(kk,ll)=c1(jj)
      coeff(kk+1,ll)=c1(jj)
      coeff(kk+2,ll)=c1(jj)
      coeff(kk+3,ll)=c1(jj)
      coeff(kk+4,ll)=c1(jj)
      coeff(kk+5,ll)=c1(jj)
      coeff(kk+6,ll)=c1(jj)
      coeff(kk+7,ll)=c1(jj)
      coeff(kk+8,ll)=c1(jj)
      coeff(kk+9,ll)=c1(jj)
      n(ipr+ll-1)=3
      l(ipr+mmm+ll-1)=3
      m(ipr+2*mmm+ll-1)=3
      n(ipr+3*mmm+ll-1)=1
      l(ipr+3*mmm+ll-1)=2
      n(ipr+4*mmm+ll-1)=2
      l(ipr+4*mmm+ll-1)=1
      n(ipr+5*mmm+ll-1)=2
      m(ipr+5*mmm+ll-1)=1
      n(ipr+6*mmm+ll-1)=1
      m(ipr+6*mmm+ll-1)=2
      l(ipr+7*mmm+ll-1)=1
      m(ipr+7*mmm+ll-1)=2
      l(ipr+8*mmm+ll-1)=2
      m(ipr+8*mmm+ll-1)=1
      n(ipr+9*mmm+ll-1)=1
      l(ipr+9*mmm+ll-1)=1 
      m(ipr+9*mmm+ll-1)=1
 523  jj=jj+1
      kk=kk+10
      ipr=ipr+10*mmm
      goto 224
      endif

      if(mssh(i).eq.-1)then
      do 226 ll=1,mnsh(i)
      mmm=mnsh(i)
      coeff(kk,ll)=c1(jj)
      n(ipr+mmm+ll-1)=1
      l(ipr+2*mmm+ll-1)=1
      m(ipr+3*mmm+ll-1)=1
      coeff(kk+1,ll)=c2(jj)
      coeff(kk+2,ll)=c2(jj)
      coeff(kk+3,ll)=c2(jj)
 226  jj=jj+1
      kk=kk+4
      ipr=ipr+4*mmm
      goto 224
      endif

      if(mssh(i).eq.-2) then
       do 326 ll=1,mnsh(i)
       mmm=mnsh(i)
         coeff(kk,ll)=c1(jj)
         n(ipr+ll-1)=1
         m(ipr+ll-1)=1

         coeff(kk+1,ll)=c1(jj)
         l(ipr+mmm+ll-1)=1
         m(ipr+mmm+ll-1)=1

         coeff(kk+2,ll)=c1(jj)
         n(ipr+2*mmm+ll-1)=1
         l(ipr+2*mmm+ll-1)=1


         coeff(kk+3,ll)=c1(jj)
         coeff(kk+3,ll+mmm)=-c1(jj) 
         n(ipr+3*mmm+ll-1)=2

         coeff(kk+4,ll)=-c1(jj)/dsqrt(3.d0)
         coeff(kk+4,ll+mmm)=-c1(jj)/dsqrt(3.d0)
         coeff(kk+4,ll+2*mmm)=2.d0*c1(jj)/dsqrt(3.d0)
         l(ipr+4*mmm+ll-1)=2
         m(ipr+5*mmm+ll-1)=2

 326  jj=jj+1
      kk=kk+5
      ipr=ipr+6*mmm
      goto 224
       endif   

      if(mssh(i).eq.-3) then
       do 426 ll=1,mnsh(i)
       mmm=mnsh(i)
       coeff(kk,ll)=dc11*c1(jj)
       coeff(kk,ll+1)=-dc12/4.d0*c1(jj)
       coeff(kk,ll+2)=-dc11/4.d0*c1(jj)

       coeff(kk+1,ll)=dc41*c1(jj)
       coeff(kk+1,ll+1)=-dc42*c1(jj)

       coeff(kk+2,ll)=dc11*c1(jj)
       coeff(kk+2,ll+1)=-dc11/4.d0*c1(jj)
       coeff(kk+2,ll+2)=-dc12/4.d0*c1(jj)

       coeff(kk+3,ll)=dc42*c1(jj)
       coeff(kk+3,ll+1)=-dc41*c1(jj)

       coeff(kk+4,ll)=c1(jj)*dsqrt(5.d0)
       coeff(kk+4,ll+1)=-3.d0/2.d0*c1(jj)
       coeff(kk+4,ll+2)=-3.d0/2.d0*c1(jj)

       coeff(kk+5,ll)=-dc21*c1(jj)
       coeff(kk+5,ll+1)=dc21*c1(jj)

       coeff(kk+6,ll)=c1(jj)

      n(ipr+ll-1)=1
      m(ipr+ll-1)=2

      n(ipr+mmm+ll-1)=3

      n(ipr+2*mmm+ll-1)=1
      l(ipr+2*mmm+ll-1)=2

      l(ipr+3*mmm+ll-1)=1
      m(ipr+3*mmm+ll-1)=2

      n(ipr+4*mmm+ll-1)=2
      l(ipr+4*mmm+ll-1)=1

      l(ipr+5*mmm+ll-1)=3

      m(ipr+6*mmm+ll-1)=3

      l(ipr+7*mmm+ll-1)=2
      m(ipr+7*mmm+ll-1)=1

      n(ipr+8*mmm+ll-1)=2
      m(ipr+8*mmm+ll-1)=1

      n(ipr+9*mmm+ll-1)=1
      l(ipr+9*mmm+ll-1)=1 
      m(ipr+9*mmm+ll-1)=1

 426  jj=jj+1
      kk=kk+7
      ipr=ipr+10*mmm
      goto 224
      endif   

       stop 400
 224  continue
      
      ipr=ipr-1

 111  format(5E16.8)

      do j=1,nbasis
      imap(j)=j
      imap2(j)=j
      enddo

      isajat=0
c     isajat=1

      if(isajat.eq.1)then

      
      ktt=0
       do 13 j=1,nbasis
       i=1
 12    if(msc(i).eq.-2) then
c       print *,"msc",i,msc(i)
          cc(1)=c(i+1,j)
          cc(2)=c(i+2,j)
          cc(3)=c(i+4,j)
          cc(4)=c(i+3,j)
          cc(5)=c(i,j)
          do 14 k=1,5
 14       c(i+k-1,j)=cc(k)
          i=i+5
          if(i.gt.nbasis)goto 13	
          go to 12
          else
c       print *,"msc",i,msc(i)
          i=i+1
          if(i.gt.nbasis)goto 13	
          goto 12
           endif
  13      continue        

         endif

         if(isajat.eq.0)then
         do 213 j=1,ncshell
         if(mssh(j).eq.-2)then
         i=iaos(j)-1
         imap(i+1)=i+2
         imap(i+2)=i+3
         imap(i+3)=i+5
         imap(i+4)=i+4
         imap(i+5)=i+1
          endif
         continue
 213  continue
           endif

         ireadp=1
c          ireadp=0
         
         if(ireadp.eq.1)then
c                print *, '    IREADP'
         do 313 j=1,ncshell
         if(mssh(j).eq.-2)then
         i=iaos(j)-1
         imap2(i+1)=i+2
         imap2(i+2)=i+3
         imap2(i+3)=i+5
         imap2(i+4)=i+4
         imap2(i+5)=i+1
          endif
         continue
 313  continue
c        print 613, (imap2(I),I=1,NBASIS)
 613    format(25i3)
         endif

         if(isajat.eq.1)then
      ktt=0
       do 113 j=1,nbasis
       i=1
 112   if(msc(i).eq.-3) then
c       print 6148
 6148  format(' **** Code has not been tested for 7 F orbitals. Check '
     *   , ' populations! ****')      
c       print *,"msc",i,msc(i)
          cc(1)=c(i+1,j)
          cc(2)=c(i+5,j)
          cc(3)=c(i+2,j)
          cc(4)=c(i+6,j)
          cc(5)=c(i,j)
          cc(6)=c(i+3,j)
          cc(7)=c(i+4,j)
          do 114 k=1,7
 114      c(i+k-1,j)=cc(k)
          i=i+7
          if(i.gt.nbasis)goto 113	
          go to 112
          else
c       print *,"msc",i,msc(i)
          i=i+1
          if(i.gt.nbasis)goto 113	
          goto 112
           endif
 113      continue        

           endif

         if(isajat.eq.0)then
         do 713 j=1,ncshell
         if(mssh(j).eq.-3)then
         i=iaos(j)-1
         imap(i+1)=i+2
         imap(i+2)=i+6
         imap(i+3)=i+3
         imap(i+4)=i+7
         imap(i+5)=i+1
         imap(i+6)=i+4
         imap(i+7)=i+5
          endif
         continue
 713  continue
           endif

         ireadp=1
c          ireadp=0
         
         if(ireadp.eq.1)then
c                print *, '    IREADP'
         do 773 j=1,ncshell
         if(mssh(j).eq.-3)then
         i=iaos(j)-1
         imap2(i+1)=i+2
         imap2(i+2)=i+6
         imap2(i+3)=i+3
         imap2(i+4)=i+7
         imap2(i+5)=i+1
         imap2(i+6)=i+4
         imap2(i+7)=i+5
          endif
         continue
 773  continue
c        print 613, (imap2(I),I=1,NBASIS)
         endif

           
      print *,'nocc:',nocc,'    nalpha:',nalf,'    nbeta:',nb
      print *,' '
      if(ienerg.eq.1) then
      print *,' E(SCF)=',escf
      else
      print *,' E(SCF/DFT)=',escf
      endif 
      print *,' '

 61   format(3D20.10)
 65   format(20i4)
 666  format(10f8.5)
       ifg=ipr
 617  format(45i2)
 618  format(4i4)

      kt=0
      do 15 i=1,ipr
      if(msc(i).ne.-2) goto 15   
      kt=kt+1
      if(kt.eq.4) ncont(i)=2*ncont(i)
      if(kt.eq.5) then 
        ncont(i)=3*ncont(i)
        kt=0
      endif 
 15   continue

      kt=0
      do 16 i=1,ipr
      if(msc(i).ne.-3) goto 16   
      kt=kt+1
      if(kt.eq.1.or.kt.eq.3.or.kt.eq.5) ncont(i)=3*ncont(i)
      if(kt.eq.2.or.kt.eq.4.or.kt.eq.6) ncont(i)=2*ncont(i)
      if(kt.eq.7) kt=0
 16   continue
      
      i=1
       do 712 ii=1,ncshell
      if(mssh(ii).eq.1) then
       do  k=1,mnsh(ii)
      c2(i)=c1(i)
      c1(i)=0.d0
       i=i+1
       enddo
       else
       i=i+mnsh(ii)
      endif
 712   continue

       ii=1
       do 711 i=1,ncshell
      msi=iabs(mssh(i))
       do j=1,mnsh(i)
      if(msi.le.1) c1(ii)=c1(ii)*anorm(0,0,0,expsh(ii))
      if(msi.eq.1) c2(ii)=c2(ii)*anorm(1,0,0,expsh(ii))
      if(msi.eq.2) c1(ii)=c1(ii)*anorm(2,0,0,expsh(ii))
       ii=ii+1
       enddo
 711   continue
c     print *,'    Nbasis=',nbasis
      return
 1000 stop 1000
      end
 

C
C
C
      subroutine start
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (PI=3.141592653589793D0)
      PARAMETER (maxp=2000,maxg=1000,maxc=26,maxat=20) 
      parameter (mgmax=10 000 000)
      parameter (nmax=500)
      common /stv/ sp(nmax,nmax),tt(nmax,nmax)
c    $     ,       vv(nmax,nmax,maxat)
      common /nat/ nat,igr,ifg,idum(4)
      common /fnutab/f(2505,13)
      common /intertab/d1,d2,d3,d4

      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /pr/iprint
      dimension d1(2504,13),d2(2503,13),d3(2502,13),d4(2501,13)
c      data bohr/0.52917715D+00/
c      data bohr/0.52917706D+00/


      PQ(iata,jatb,ipr,jpr,kcart)
     $ =(expp(ipr)*coord(kcart,iata)+
     $      expp(jpr)*coord(kcart,jatb))/(expp(ipr)+expp(jpr))
   
      call init
      call input


      print *,"Number of atoms:",nat
      print *,"Number of primitives:",ifg
      print *,"Number of basis functions:",igr

c the renormalization of contraction coefficients
         
       do 700 i=1,igr
       do 701 ic=1,ncont(i)
      ipr=ifill(i)+ic-1
      qi=anorm(n(ipr),l(ipr),m(ipr),expp(ipr))
      coeff(i,ic)=coeff(i,ic)*qi 
 701   continue
 700   continue


       do 400 i=1,igr
         if(ncont(i).eq.1) goto 444
        finorm=0.d0
       do 401 ic=1,ncont(i)
      ipr=ifill(i)+ic-1
        do 403 jc=1,ncont(i)
       jpr=ifill(i)+jc-1         
        finorm=finorm+
     $  coeff(i,ic)*S(n(ipr),l(ipr),m(ipr),n(jpr),l(jpr),m(jpr),
     $  expp(ipr),expp(jpr),0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0)*
     $  coeff(i,jc)
 403    continue
 401   continue
       do 404 ic=1,ncont(i)
 404       coeff(i,ic)=coeff(i,ic)/dsqrt(finorm)
 444   do 445 ic=1,ncont(i)
 445   continue       
 400   continue

      
       do 600 iatt=1,nat
      ncsi=iulim(iatt)-llim(iatt)+1
       do 601 jatt=1,nat
      ncsj =iulim(jatt)-llim(jatt)+1
       do 602 i=1,ncsi 
      igr=llim(iatt)+i-1 
      ngri=ifiul(igr)-ifill(igr)+1
       il=1
       if(iatt.eq.jatt)il=i
       do 603 j=il,ncsj
      atfed1=0.d0
      enkin1=0.d0
      jgr=llim(jatt)+j-1 
      ngrj=ifiul(jgr)-ifill(jgr)+1
       do 604 ki=1,ngri
      ipr=ifill(igr)+ki-1
       do 605 kj=1,ngrj
      jpr=ifill(jgr)+kj-1
      PAX=(coord(1,jatt)-coord(1,iatt))*expp(jpr)/
     $     (expp(ipr)+expp(jpr))        
      PBX=(coord(1,iatt)-coord(1,jatt))*expp(ipr)/
     $     (expp(jpr)+expp(ipr))        
      PAY=(coord(2,jatt)-coord(2,iatt))*expp(jpr)/
     $     (expp(ipr)+expp(jpr))        
      PBY=(coord(2,iatt)-coord(2,jatt))*expp(ipr)/
     $     (expp(jpr)+expp(ipr))        
      PAZ=(coord(3,jatt)-coord(3,iatt))*expp(jpr)/
     $     (expp(ipr)+expp(jpr))        
      PBZ=(coord(3,iatt)-coord(3,jatt))*expp(ipr)/
     $     (expp(jpr)+expp(ipr))        
      atfed=S(n(ipr),l(ipr),m(ipr),n(jpr),l(jpr),m(jpr),expp(ipr),
     $ expp(jpr),ab2(iatt,jatt),PAX,PBX,PAY,PBY,PAZ,PBZ)
      atfed1=atfed1+coeff(igr,ki)*atfed*coeff(jgr,kj)

c computation of the kinetic energy

      enkin=T(n(ipr),l(ipr),m(ipr),n(jpr),l(jpr),m(jpr),expp(ipr),
     $ expp(jpr),ab2(iatt,jatt),PAX,PBX,PAY,PBY,PAZ,PBZ)
      enkin1=enkin1+coeff(igr,ki)*enkin*coeff(jgr,kj)  
  605  continue 
  604  continue 
       sp(igr,jgr)=atfed1 
       sp(jgr,igr)=atfed1 
c      tt(igr,jgr)=enkin1
c      tt(jgr,igr)=enkin1 
  603  continue    
  602  continue    
  601  continue    
  600  continue    


c       do 802 katt=1,nat
c       do 800 ig=1,igr
c     ngri=ifiul(ig)-ifill(ig)+1
c       do 801 jg=ig,igr
c     ngrj=ifiul(jg)-ifill(jg)+1
c       enuc=0.d0
c       do 803 i=1,ngri
c       do 804 j=1,ngrj
c     ik=i+ifill(ig)-1
c     jk=j+ifill(jg)-1
c     enuc=enuc+coeff(ig,i)*vcore(ik,jk,katt)*coeff(jg,j)
c804    continue
c803    continue  
c     vv(ig,jg,katt)=enuc
c     vv(jg,ig,katt)=enuc 
c801    continue
c800    continue        
c802    continue

 3000 return       
      end 

       function Vcore(iafg,ibfg,katt)
      implicit real*8(a-h,o-z)
      PARAMETER (maxp=2000,maxg=1000,maxc=26,maxat=20)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      parameter (nmax=500)
      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)

      iatt=iat(iafg)
      jatt=iat(ibfg)        
      diff=0.d0  
   
      PAX=(coord(1,jatt)-coord(1,iatt))*expp(ibfg)/
     $     (expp(iafg)+expp(ibfg))   
      PBX=(coord(1,iatt)-coord(1,jatt))*expp(iafg)/
     $     (expp(ibfg)+expp(iafg))   
      PCX=PAX+coord(1,iatt)-coord(1,katt)        
      PAY=(coord(2,jatt)-coord(2,iatt))*expp(ibfg)/
     $     (expp(iafg)+expp(ibfg))   
      PBY=(coord(2,iatt)-coord(2,jatt))*expp(iafg)/
     $     (expp(ibfg)+expp(iafg))   
      PCY=PAY+coord(2,iatt)-coord(2,katt)        
      PAZ=(coord(3,jatt)-coord(3,iatt))*expp(ibfg)/
     $     (expp(iafg)+expp(ibfg))   
      PBZ=(coord(3,iatt)-coord(3,jatt))*expp(iafg)/
     $     (expp(ibfg)+expp(iafg))   
      PCZ=PAZ+coord(3,iatt)-coord(3,katt)        
     
      do kk=1,3
        diff=diff+
     $    ((expp(iafg)*coord(kk,iatt)+expp(ibfg)*coord(kk,jatt))
     $    /(expp(iafg)+expp(ibfg))-coord(kk,katt))**2   
      enddo
      pc2=diff
 
      vcore=V(n(iafg),l(iafg),m(iafg),n(ibfg),l(ibfg),m(ibfg),
     $       expp(iafg),expp(ibfg),ab2(iatt,jatt),pc2,
     $       PAX,PAY,PAZ,PBX,PBY,PBZ,PCX,PCY,PCZ)*(-zn(katt))
      return 
      end

      function AB2(iata,jatb)
      implicit real*8(a-h,o-z)
      PARAMETER (maxp=2000,maxg=1000,maxc=26,maxat=20)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      diff=0.d0
      do k=1,3
        diff=diff+(coord(k,iata)-coord(k,jatb))**2
      enddo
      AB2=diff
      return
      end

      subroutine init
      implicit real*8(a-h,o-z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
c     common /fnutab/f(2505,13)
c     common /intertab/d1,d2,d3,d4
c     dimension d1(2504,13),d2(2503,13),d3(2502,13),d4(2501,13)
      COMMON/C40/CFILL(80),tol,rp2
      call fmtset
      call binom
      pisqh=dsqrt(datan(1.d0)*4.d0)/2.d0    
      return
      end 

      subroutine binom
      implicit real*8(a-h,o-z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
          
      do 1 k=1,30
      bin(k,1)=1.d0
      bin(k,2)=k
  1   bin(k,k+1)=1.d0
      do 2 k=2,30
      do 2 j=2,k
  2   bin(k,j)=bin(k-1,j-1)+bin(k-1,j)

      bifac(1)=1.d0
      do 7 i=3,23,2
      bifac(i)=bifac(i-2)*dfloat(i-2)
  7   continue
      
      fact(1)=1.d0
      do 8 i=2,31
  8   fact(i)=fact(i-1)*dfloat(i-1)
          
      return
      end

      function fi(i,n1,n2,a,b)
      implicit real*8(a-h,o-z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      fi=0.d0
      if(i.gt.n1+n2)return
      if(n1.eq.0.or.n2.eq.0)goto 100
      t=0.d0
      lim=min(i,n1)
      llim=max(0,i-n2)
      do 1 k=llim,lim
  1   t=t+bin(n1,k+1)*a**(n1-k)*bin(n2,i-k+1)*B**(n2-i+k)
      fi=t
      return
 100  if(n1.eq.0.and.n2.eq.0.and.i.ne.0) return
      if(n1.eq.0.and.n2.eq.0.and.i.eq.0) then
      fi=1.d0
      return
      endif
      if(n1.eq.0.and.i.le.n2) fi=bin(n2,i+1)*b**(n2-i)
      if(n2.eq.0.and.i.le.n1) fi=bin(n1,i+1)*a**(n1-i)
       return
      end

      subroutine FMTSET
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/C40/FMZERO(40),GA(40),tol,rpitwo
C*
      DATA HALF/0.5D0/,ONE/1.0D0/,TWO/2.0D0/,TENM9/1.0D-9/
      DATA PI/3.14159265358979D0/,TEN/10.0D0/
C*
C*
C     SET VALUES IN GA AND FMZERO.
      TOL=HALF
      GA(1)=DSQRT(PI)
      RPITWO=GA(1)*HALF
      DO 200 I=2,40
      GA(I)=GA(I-1)*TOL
  200 TOL=TOL+ONE
      TOL=ONE
      FMZERO(1)=ONE
      DO 210 I=2,40
      TOL=TOL+TWO
  210 FMZERO(I)=ONE/TOL
      TOL=TENM9
C     DON'T WORRY ABOUT CHANGING THE CUT-OFFS - GAMGEN IS ONLY CALLED
C     ONCE AT THE VERY START OF THE CALCULATION.
c     IF(KOP1.NE.0)CUT0S=TEN**(-2*KOP1)
c     IF(KOP2.NE.0)TOL=TEN**(-6-KOP2)
      RETURN
      END

      subroutine FMT(T,M,f)
C*
C     ----------------
C     QCPE GAUSSIAN 76
C     U OF T VERSION
C     NOVEMBER 1978
C     ----------------
C*
      IMPLICIT REAL*8 (A-H,O-Z)
C*
      COMMON/C40/FMZERO(40),GA(40),tol,rpitwo
      dimension f(40)
C*
      DATA ZERO/0.0D0/,HALF/0.5D0/,ONE/1.0D0/,TWO/2.0D0/
c     DATA PI/3.14159265358979D0/,TEN/10.0D0/
      DATA CUT0S/0.0D0/,CUTSM/10.0D0/,CUTML/42.0D0/
 
C*
 1000 FORMAT('0FAILURE IN FMTGEN FOR T =',1PD16.8,'  $$ STOP $$')
C*
C     TEST FOR TYPE OF ALGORITHM.
      DT=DABS(T)
      IF(DT.GT.CUT0S)GO TO 20
C     ARGUMENT OF ZERO.
      do 10 i=1,m
   10 F(i)=FMZERO(i)
      RETURN
C     TEST FOR EVALUATION OF THE EXPONENTIAL.
   20 MM1=M-1
      TEXP=ZERO
      IF(DT.GE.CUTML)GO TO 100
      TEXP=DEXP(-T)
      IF(DT.GE.CUTSM)GO TO 50
C     0.0 < T < 10.0.
      A=DFLOAT(MM1)+HALF
      TERM=ONE/A
      SUM=TERM
      DO 30 IX=2,200
      A=A+ONE
      TERM=TERM*T/A
      SUM=SUM+TERM
      IF(DABS(TERM/SUM).LT.TOL)GO TO 40
   30 CONTINUE
      WRITE(*,1000)T
      STOP
   40 F(m)=HALF*SUM*TEXP
      GO TO 110
C     10.0 <= T < 42.0.
   50 A=DFLOAT(MM1)
      B=A+HALF
      A=A-HALF
      TX=ONE/T
      APPROX=RPITWO*DSQRT(TX)*(TX**MM1)
      IF(MM1.EQ.0)GO TO 70
      DO 60 IX=1,MM1
      B=B-ONE
   60 APPROX=APPROX*B
   70 FIMULT=HALF*TEXP*TX
      SUM=ZERO
      IF(FIMULT.EQ.ZERO)GO TO 90
      FIPROP=FIMULT/APPROX
      TERM=ONE
      SUM=ONE
      NOTRMS=IDINT(T)+MM1
      DO 80 IX=2,NOTRMS
      TERM=TERM*A*TX
      SUM=SUM+TERM
      IF(DABS(TERM*FIPROP/SUM).LE.TOL)GO TO 90
   80 A=A-ONE
      WRITE(IOUT,1000)T
      STOP
   90 F(m)=APPROX-FIMULT*SUM
      GO TO 110
C     T >= 42.0.
  100 TX=DFLOAT(M)-HALF
      F(m)=HALF*GA(M)/(T**TX)
C     RECUR DOWNWARDS TO F(1)
  110 IF(MM1.EQ.0)RETURN
      TX=T+T
      SUM=DFLOAT(M+M-3)
      DO 120 IX=1,MM1
      F(M-IX)=(TX*F(M-IX+1)+TEXP)/SUM
  120 SUM=SUM-TWO
      RETURN
      end 
      FUNCTION S(N1,L1,M1,N2,L2,M2,A,B,AB2,PAX,PBX,PAY,PBY,PAZ,PBZ)
       IMPLICIT REAL*8(A-H,O-Z)  
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      PARAMETER (PI=3.141592653589793d0)
      parameter (pi3=31.0062766802998d0)      
       AB=A+B
       ALFA=A*B/AB
       AB3=AB**3 
       COEF=DSQRT(PI3/AB3)
       S=COEF*DEXP(-ALFA*AB2)*SK(N1,N2,A,B,PAX,PBX)*
     $   SK(L1,L2,A,B,PAY,PBY)*SK(M1,M2,A,B,PAZ,PBZ)  
       RETURN
       END


      FUNCTION SK(N1,N2,A,B,PA,PB)
      IMPLICIT REAL*8(A-H,O-Z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      xxx=0.d0
      N=(N1+N2)/2
      AB=2*(A+B)
      DO 10 I=0,N
        xxx=xxx+FI(2*I,N1,N2,PA,PB)*BIFAC(2*I+1)/AB**I
 10   CONTINUE 
       sk=xxx
      RETURN 
      END

      function ANORM(n,l,m,a)
      implicit real*8(a-h,o-z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)   
      PARAMETER (PI=3.141592653589793d0)
      parameter (pi3=31.0062766802998d0)      
      rl=1.d0/bifac(2*l+1)
      rm=1.d0/bifac(2*m+1)
      rn=1.d0/bifac(2*n+1)
      nlm=n+l+m
      coef=8.d0*a*a*a/PI3      
      coef=dsqrt(coef)
      coef1=(4.d0*a)**nlm
      anorm=coef*coef1*rn*rl*rm
      anorm=dsqrt(anorm)
      return
      end


      FUNCTION T(N1,L1,M1,N2,L2,M2,a,b,ab2,pax,pbx,pay,pby,paz,pbz)
      IMPLICIT REAL*8(A-H,O-Z)
      aNLM2=B*(2*(N2+L2+M2)+3)
      NN=N2*(N2-1)
      LL=L2*(L2-1)
      MM=M2*(M2-1)
      SP2=2*B**2*(
     $    S(N1,L1,M1,N2+2,L2,M2,a,b,ab2,pax,pbx,pay,pby,paz,pbz)+
     $    S(N1,L1,M1,N2,L2+2,M2,a,b,ab2,pax,pbx,pay,pby,paz,pbz)+
     $    S(N1,L1,M1,N2,L2,M2+2,a,b,ab2,pax,pbx,pay,pby,paz,pbz))
      if (nn.eq.0.and.ll.eq.0.and.mm.eq.0) then
         sm2=0.d0
      else 
      SM2=NN*S(N1,L1,M1,N2-2,L2,M2,a,b,ab2,pax,pbx,pay,pby,paz,pbz)+
     $    LL*S(N1,L1,M1,N2,L2-2,M2,a,b,ab2,pax,pbx,pay,pby,paz,pbz)+ 
     $    MM*S(N1,L1,M1,N2,L2,M2-2,a,b,ab2,pax,pbx,pay,pby,paz,pbz) 
      endif    
      T=aNLM2*S(N1,L1,M1,N2,L2,M2,a,b,ab2,pax,pbx,pay,pby,paz,pbz)-
     $   SP2-SM2/2.d0
      RETURN
      END


      FUNCTION V(N1,L1,M1,N2,L2,M2,a,b,ab2,pc2,PAX,PAY,PAZ,
     $           PBX,PBY,PBZ,PCX,PCY,PCZ)
      IMPLICIT REAL*8(A-H,O-Z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      dimension fff(100)
      PARAMETER (PI=3.141592653589793d0)
      ALFA=A*B/(A+B)
      VCOEF=2.d0*PI/(A+B)*EXP(-ALFA*AB2) 
      ARGF=(A+B)*PC2 
      NN1=N1+N2+L1+L2+M1+M2
      call fmt(argf,nn1+1,fff)
      v1=0.d0
      DO 20 NU=0,NN1
      v0=0.d0
      DO 30 I=0,N1+N2
      DO 40 J=0,L1+L2
      DO 50 K=0,M1+M2 
        IF((I+J+K).EQ.NU) THEN 
        V0=V0+VG(I,N1,N2,a,b,PAX,PBX,PCX)*
     $        VG(J,L1,L2,a,b,PAY,PBY,PCY)*
     $        VG(K,M1,M2,a,b,PAZ,PBZ,PCZ)
        ENDIF
 50   CONTINUE
 40   CONTINUE 
 30   CONTINUE
      v1=v1+v0*fff(nu+1)
 20   CONTINUE 
      V=V1*VCOEF 
      RETURN
      END


      FUNCTION VG(II,N1,N2,a,b,pax,pbx,pcx)
      IMPLICIT REAL*8(A-H,O-Z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      VGAB0=1.d0/(4.d0*(A+B))
      vg=0.d0 
      DO 60 I=0,N1+N2
      DO 70 J=0,I/2
      DO 80 K=0,(I-2*J)/2
        IF((I-2*J-K).EQ.II) THEN
        VG=VG+(-1)**I*(-1)**K*FI(I,N1,N2,PAX,PBX)*
     $  FACT(I+1)/(FACT(J+1)*FACT(K+1)*FACT(I-2*J-2*K+1))*
     $  VGAB0**(J+K)*PCX**(I-2*J-2*K)
        ENDIF
 80   CONTINUE
 70   CONTINUE
 60   CONTINUE 
      RETURN
      END   

       function TIntg(n1,l1,m1,n2,l2,m2,n3,l3,m3,n4,l4,m4,a,b,c,d,
     $            ab2,cd2,pq2,ax,bx,cx,dx,ay,by,cy,dy,az,bz,cz,dz,
     $            pqx,pqy,pqz) 
        implicit real*8(a-h,o-z) 
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      dimension dii(250),dij(250),dik(250),fff(100)
      PARAMETER (PI=3.141592653589793d0)
      parameter (pi3=31.0062766802998d0)   
      parameter (pi52=34.98683665524973d0)   
       alfa=a*b/(a+b)
       gamma=c*d/(c+d)
       delta=(a+b+c+d)/(4.d0*(a+b)*(c+d))
       n12=n1+n2+n3+n4+l1+l2+l3+l4+m1+m2+m3+m4 
       argf=pq2/(4.d0*delta)    
       coef=pi52*dsqrt(1.d0/(a+b+c+d))*
     $   exp(-alfa*ab2-gamma*cd2)/((a+b)*(c+d))  
        TIntg=0.d0
        call dfill(n1,n2,n3,n4,a,b,c,d,ax,bx,cx,dx,pqx,dii)      
        call dfill(l1,l2,l3,l4,a,b,c,d,ay,by,cy,dy,pqy,dij)      
        call dfill(m1,m2,m3,m4,a,b,c,d,az,bz,cz,dz,pqz,dik)      
        call fmt(argf,n12+1,fff)
        do 100 nu=0,n12
        TIntg0=0.d0
       do 101 i=0,n1+n2+n3+n4
           diix=dii(i+1)
          if (diix.eq.0.d0) goto 101
       do 102 j=0,l1+l2+l3+l4
           dijy=dij(j+1)
          if (dijy.eq.0.d0)goto 102
       do 103 k=0,m1+m2+m3+m4
      if((i+j+k).eq.nu) then
       TIntg0=TIntg0+diix*dijy*dik(k+1)
      endif
 103    continue
 102    continue
 101    continue
       TIntg=TIntg+TIntg0*fff(nu+1)
 100    continue
       TIntg=coef*TIntg
       return
       end

      subroutine dfill(n1,n2,n3,n4,a,b,c,d,ax,bx,cx,dx,pqx,dd)
        implicit real*8(a-h,o-z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)        
      dimension hs(250),ht(250)
      dimension dd(1)
      delta=(a+b+c+d)/(4.d0*(a+b)*(c+d))
      nn1=n1+n2
      nn2=n3+n4
      nn=nn1+nn2
      call hfill(n1,n2,ax,bx,a+b,hs) 
      call hfill(n3,n4,cx,dx,c+d,ht) 
      if(nn.eq.0) then 
         his=hs(1)
         hit=ht(1)
         dd(1)=his*hit
         return
       endif

        do 140 i=0,nn
        dd(i+1)=0.d0
 140    continue  
        do 150 is=0,nn1
        do 151 it=0,nn2
        ist=(is+it)/2
        do 152 iu=0,ist
         i=is+it-iu
        dd(i+1)=dd(i+1)+(-1)**(iu+it)*fact(is+it+1)*
     $  (-pqx)**(i-iu)/(fact(iu+1)*fact(i-iu+1)*delta**i)*
     $  hs(is+1)*ht(it+1)
 152    continue
 151    continue
 150    continue
      return        
      end     

      subroutine hfill(n1,n2,a,b,ex,h)
      implicit real*8(a-h,o-z)
      dimension ef(20),h(100)
      common /bin/bin(30,31),bifac(23),pisqh,fac(31)
      nn=n1+n2

      if(nn.eq.0) then
         h(1)=1.d0
         return
      endif

      eh=0.25d0/ex

      if(n1.lt.3.and.n2.lt.3) then
        h(nn+1)= eh**nn

        if(n1.ge.n2)then
        ah=a
        bh=b
        else
        ah=b
        bh=a
        endif

        if(nn.eq.1) then
        h(1)=ah
        else
        ed=0.5d0/ex
        rd=ah*bh
        rh=ah+bh
           if(nn.eq.2) then
              if(n1.eq.1) then
              h(1)=rd+ed
              h(2)=rh*eh
              else
              h(1)=ah**2+ed
              h(2)=ah*ed
              endif
           else
           ru=ah**2
           rv=bh**2
           rw=eh**2

              if(nn.eq.3) then
              h(1)=ru*bh+(ah+rh)*ed
              h(2)=(2.d0*rd+ru)*eh+6.d0*rw
              h(3)=(ah+rh)*rw
              else
              rt=2.d0*rw*eh
              ro=ru+rv+4.d0*rd
              h(1)=rd**2+ro*ed+12.d0*rw
              h(2)=rh*(rd*ed+12.d0*rw)
              h(3)=ro*rw+6.d0*rt
              h(4)=rh*rt
              endif
      endif
      endif
       else
         do 11 n6=0,nn-1
         h(n6+1)=0
         ef(n6+1)=fi(n6,n1,n2,a,b)
 11      continue
         ef(nn+1)=1.d0
         do 12 n4=0,nn
         nlim=n4/2
         do 12 n5=0,nlim
         n6=n4-2*n5
         if(n6.eq.nn)then
         h(n6+1)=eh**nn
         else
         h(n6+1)=h(n6+1)+fac(n4+1)*ef(n4+1)/fac(n5+1)/fac(n6+1)
     $         *eh**(n4-n5)
         endif
  12    continue

      endif

      return
      end


      SUBROUTINE SDIAG(X,m,D,n)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (NMAX=500)
C DIAGONALIZATION OF THE REAL SYMMETRIC MATRIX X. IN D THE EIGENVALUES.
      DIMENSION D(n)
      DIMENSION E(NMAX),X(m,m)
      EPS=5.D-10
      TOL=5.D-15
      IF(N.EQ.1) GOTO 400
    5 DO 150 NI=2,N
      II=N+2-NI
      DO 150 I=II,II
      L=I-2
      H=0.0D0
      G=X(I,I-1)
      IF(L)140,140,20
   20 DO 30 K=1,L
   30 H=H+X(I,K)*X(I,K)
      S=H+G*G
      IF(S.GE.TOL) GOTO 50
   40 H=0.0D0
      GO TO 140
   50 IF(H)140,140,60
   60 L=L+1
      F=G
      G=DSQRT(S)
      IF(F)75,75,70
   70 G=-G
   75 H=S-F*G
      X(I,I-1)=F-G
      F=0.0D0
      DO 110 J=1,L
      X(J,I)=X(I,J)/H
      S=0.0D0
      DO 80 K=1,J
   80 S=S+X(J,K)*X(I,K)
      J1=J+1
      IF(J1.GT.L) GOTO 100
   85 DO 90 K=J1,L
   90 S=S+X(K,J)*X(I,K)
  100 E(J)=S/H
  110 F=F+S*X(J,I)
      F=F/(H+H)
      DO 120 J=1,L
  120 E(J)=E(J)-F*X(I,J)
      DO 130 J=1,L
      F=X(I,J)
      S=E(J)
      DO 130 K=1,J
  130 X(J,K)=X(J,K)-F*E(K)-X(I,K)*S
  140 D(I)=H
  150 E(I-1)=G
  160 D(1)=X(1,1)
      X(1,1)=1.0D0
      DO 220 I=2,N
      L=I-1
      IF(D(I))200,200,170
  170 DO 190 J=1,L
      S=0.0D0
      DO 180 K=1,L
  180 S=S+X(I,K)*X(K,J)
      DO 190 K=1,L
  190 X(K,J)=X(K,J)-S*X(K,I)
  200 D(I)=X(I,I)
      X(I,I)=1.0D0
  210 DO 220 J=1,L
      X(I,J)=0.0D0
  220 X(J,I)=0.0D0
      B=0.0D0
      F=0.0D0
      E(N)=0.0D0
      DO 340 L=1,N
      H=EPS*(DABS(D(L))+DABS(E(L)))
      IF(H.GT.B) B=H
  235 DO 240 J=L,N
      IF(DABS(E(J)).LE.B) GO TO 250
  240 CONTINUE
  250 IF(J.EQ.L) GOTO 340
  260 P=(D(L+1)-D(L))*.50D0/E(L)
      R=DSQRT(P*P+1.0D0)
      IF(P)270,280,280
  270 P=P-R
      GO TO 290
  280 P=P+R
  290 H=D(L)-E(L)/P
      DO 300 I=L,N
  300 D(I)=D(I)-H
      F=F+H
      P=D(J)
      C=1.0D0
      S=0.0D0
      J1=J-1
      DO 330 NI=L,J1
      II=L+J1-NI
      DO 330 I=II,II
      G=C*E(I)
      G=C*E(I)
      H=C*P
      IF(DABS(P).LT.DABS(E(I))) GO TO 310
  305 C=E(I)/P
      R=DSQRT(C*C+1.0D0)
      E(I+1)=S*P*R
      S=C/R
      C=1.0D0/R
      GO TO 320
  310 C=P/E(I)
      R=DSQRT(C*C+1.0D0)
      E(I+1)=S*E(I)*R
      S=1.0D0/R
      C=C/R
  320 P=C*D(I)-S*G
      D(I+1)=H+S*(C*G+S*D(I))
      DO 330 K=1,N
      H=X(K,I+1)
      X(K,I+1)=X(K,I)*S+H*C
  330 X(K,I)=X(K,I)*C-H*S
      E(L)=S*P
      D(L)=C*P
      IF(DABS(E(L)).GT.B) GO TO 260
  340 D(L)=D(L)+F
      NI=N-1
  350 DO 380 I=1,NI
      K=I
      P=D(I)
      J1=I+1
      DO 360 J=J1,N
      IF(D(J).LE.P) GOTO 360
  355 K=J
      P=D(J)
  360 CONTINUE
      IF(K.EQ.I) GOTO 380
  365 D(K)=D(I)
      D(I)=P
      DO 370 J=1,N
      P=X(J,I)
      X(J,I)=X(J,K)
  370 X(J,K)=P
  380 CONTINUE
  390 GO TO 410
  400 D(1)=X(1,1)
      X(1,1)=1.0D0
  410 RETURN
      END
