      SUBROUTINE METHOD
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     INPUT OF DFP OPTIONS.
C     *
CCCC  LOGICAL QUADRS
      INTEGER QUADRS
      COMMON
     ./BESAFE/ TLIMIT,SFDFP,SFSCF
     ./FLAG1 / KTITLE(12),KOMENT(10),KHARGE,KGEOM,KITSCF,KDUMMY,
     .         KSYM,KDEP,KOUNT,NTYPE,KRSAVE,NSTTT
     ./FLAG2 / MIDDLE,SECADD,TIME1
     ./MXFLAG/ MAXEND
     ./PASS2 / MAXLIN,IPRINT,ISWTCH,NRST,NSUCC,TOLIN(3),
     .         TOLEND(3),FMIN,RST,FAC
     ./SC    / EINC,IGG1,CCCOS,EYEAD
     ./SCRT  / SCFCRT,SCFF
     ./SKIPA / IGRAD,ISKPA,NWSKP,QUADRS
     ./VVV   / CHANGE(3),DELTA(3),XFAC,YFAC
     ./XLSQ1 / XMINM,XCRIT,YMAXST,YMINST,MXCONT,TOLS(6)
     ./XLSQ3 / RSTABS,SSQUIT
     ./XPRJU / IREP,IJUMP
     ./XSKPRT/ IPUBO,IPUEV,JPRINT,NPRINT
     ./XXMAXM/ XMAXM,PMSTE,DELL,TDEL
      DIMENSION ITOL(6)
C *** INITIALIZE VARIABLES.
      CHANGE(1)=0.00001
      CHANGE(2)=0.01745329252*0.002
      CHANGE(3)=0.01745329252*0.005
      KOUNT=0
      MAXLIN=0
      IIN=0
      IEND=0
      IGG1=0
      NRST=0
      RST=0.
      FAC=0.
      XFAC=0.
      PMSTE=0.
      DELL =0.
      CCCOS=0.
      EYEAD=0.
      MXCONT=0
      YMAXST=0.
      XCRIT =0.
      YMINST=0.
      YFAC  =0.
      SECADD=0.
      DO 10 I=1,6
   10 ITOL(I)=0
C *** FIRST CARD.
      READ(5,501) MAXEND,IPRINT,IREP,IOPTC,MIDDLE,NOPRT,JDUMMY,
     1  NWSKP,IGRAD,JPRINT,ISCF,ISCFF,ISFDFP,ISTABS,ISQUIT,
     2  (KOMENT(I),I=1,10)
      IF(MAXEND.EQ.0) MAXEND=9999
      IF(IPRINT.EQ.0)IPRINT=99
      IF(NOPRT .LT.0)IPRINT=0
      IF(ISCF.EQ.0 .AND. MAXEND.GT.3) ISCF=4
      IF(ISCF.EQ.0) ISCF=5
      IF(ISCFF.EQ.0) ISCFF=4
      IF(ISFDFP.EQ.0) ISFDFP=15
      IF(ISTABS.EQ.0) ISTABS=300
      IF(ISQUIT.EQ.0) ISQUIT=1
      SCFCRT=10.**(-ISCF)
      SCFF=10.**(-ISCFF)
      SFDFP=0.1*FLOAT(ISFDFP)
      RSTABS=FLOAT(ISTABS)
      SSQUIT=FLOAT(ISQUIT)
C *** SECOND CARD (OPTIONAL).
      IF(IOPTC.EQ.1) READ(5,720) MAXLIN,IIN,IEND,IGG1,NRST,RST,FAC,XFAC,
     1  PMSTE,DELL,CCCOS,EYEAD
      IF(MAXLIN.EQ.0) MAXLIN=15
      IF(IIN.EQ.0) IIN=4
      IF(IEND.EQ.0) IEND=4
      DO 11 I=1,3
      TOLIN(I) =10.**(-IIN)
   11 TOLEND(I)=10.**(-IEND)
      TOLEND(3)=TOLEND(3)*10000.
      IF(IGG1.EQ.0) IGG1=3
      IF(NRST.EQ.0) NRST=50
      IF(RST.EQ.0.) RST=0.05
      IF(FAC.EQ.0.) FAC=1.
      IF(XFAC.EQ.0.) XFAC=1.
      TDEL=6.
      IF(PMSTE.LT.0.00001) PMSTE=0.1
      IF(DELL.LT.0.00001) DELL=0.01
      IF(EYEAD.EQ.0.) EYEAD=0.005
C *** THIRD CARD (OPTIONAL).
      IF(IOPTC.EQ.1) READ(5,1922) MXCONT,YMAXST,XCRIT,YMINST,YFAC,
     1  (ITOL(I),I=1,6)
      IF(MXCONT.EQ.0 ) MXCONT=15
      IF(YMAXST.EQ.0.) YMAXST=0.1
      IF(XCRIT .EQ.0.) XCRIT=0.0001
      IF(YMINST.EQ.0.) YMINST=0.0001
      IF(YFAC  .EQ.0.) YFAC=100.
      IF(ITOL(1).EQ.0) ITOL(1)=9
      IF(ITOL(2).EQ.0) ITOL(2)=10
      IF(ITOL(3).EQ.0) ITOL(3)=12
      IF(ITOL(4).EQ.0) ITOL(4)=13
      IF(ITOL(5).EQ.0) ITOL(5)=2
      IF(ITOL(6).EQ.0) ITOL(6)=2
      DO 12 I=1,6
   12 TOLS(I)=10.**(-ITOL(I))
C *** PRINTING SECTION.
      IF(IOPTC.EQ.0) GO TO 1000
      WRITE(6,503) IPRINT,MAXEND
      WRITE(6,505) TOLEND(1),TOLEND(2),TOLEND(3),EYEAD,IGG1
      WRITE(6,512) NRST,RST,PMSTE,DELL,TDEL
      WRITE(6,506) MAXLIN
      WRITE(6,504) TOLIN(1),TOLIN(2),TOLIN(3),FAC
      DEL1=XFAC*0.00001
      DEL2=XFAC*0.002
      DEL3=XFAC*0.005
      WRITE(6,510) DEL1,DEL2,DEL3
      WRITE(6,515) MXCONT
      WRITE(6,516) XCRIT,TOLS(5),TOLS(6)
      DEL1=YFAC*0.00001
      DEL2=YFAC*0.002
      DEL3=YFAC*0.005
      WRITE(6,510) DEL1,DEL2,DEL3
      WRITE(6,411) SCFCRT
      WRITE(6,412) SCFF
      WRITE(6,413) MAXEND,IPRINT,IREP,IOPTC,MIDDLE,NTYPE,JDUMMY,NWSKP,
     1  IGRAD,JPRINT,ISCF,ISCFF,ISFDFP,ISTABS,ISQUIT
      IF(CCCOS.GT.0.0000001) WRITE(6,960) CCCOS
 1000 RETURN
  411 FORMAT(1H ,/,1X,'SCF CONVERGENCE CRITERION FOR FULL SCF  =',E10.3)
  412 FORMAT(1H ,/,1X,'SCF CONVERGENCE CRITERION FOR GRADIENTS =',E10.3)
  413 FORMAT(1H ,/,1X,'CONTROL VARIABLES',4X,I4,I3,10I2,I3,I5,I3)
  500 FORMAT(3F10.5)
  501 FORMAT(13I2,4X,2I5,10A4)
  503 FORMAT(////,' OPTIONS FOR DFP OPTIMIZATION ...'/
     1  '0    PRINTING SWITCH ...',I5/
     2  '0    MAXIMUM NUMBER OF FUNCTION EVALUATIONS OVERALL  ...',I5)
  504 FORMAT('0    TOLERANCES ...'/
     1  '       ON X = ',E10.3/
     2  '       ON F = ',E10.3/
     3  '       ON THE LINEAR DERIV = ',E10.3/
     4  '0    LINEAR SEARCH FACTOR  = ',E10.3)
  505 FORMAT('0    DFP CONVERGENCE CRITERIA ...'/
     1  '       ON X = ',E10.3/
     2  '       ON F = ',E10.3/
     3  '       ON GRADIENTS = ',E10.3/
     4  '       ON ALPHA.P.G = ',E10.3/
     5  '       ON IGG1 = ',I3)
  506 FORMAT('0OPTIONS FOR CUBIC LINE SEARCH ...'/
     1  '0    MAXIMUM NUMBER OF FUNCTION EVALUATIONS PER LINE SEARCH =',
     2   I5)
  510 FORMAT('0    STEP SIZE IN GRADIENT CALCULATION ...'/
     1  '       FOR BOND LENGTHS = ',E10.3/
     2  '       FOR BOND ANGLES  = ',E10.3/
     3  '       FOR TWIST ANGLES = ',E10.3)
  512 FORMAT('0    RESTART PARAMETERS ...'/
     1  '       RESTART EACH ',I5,'  CYCLES, OR WHENEVER'/
     2  '       COSINE OF ANGLE BETWEEN P AND -G .LE.',E10.3/
     3  '       MAXIMUM VALUE FOR H MATRIX ELEMENTS  ',E10.3/
     4  '       INCREMENT FOR CHANGE OF VARIABLES    ',E10.3/
     5  '       SCALING FACTOR FOR STEP SIZE         ',E10.3)
  515 FORMAT('0OPTIONS FOR QUADRATIC LINE SEARCH ...'/
     1  '0    MAXIMUM NUMBER OF FUNCTION EVALUATIONS PER LINE SEARCH =',
     2   I5)
  516 FORMAT('0    TOLERANCES ...'/
     1  '       ON X = ',E10.3/
     2  '       ON ALPHA (RELATIVE) = ',E10.3/
     3  '       ON ALPHA (ABSOLUTE) = ',E10.3)
  720 FORMAT(5I2,7F10.5)
  960 FORMAT(1H ,/,1X,'CCCOS =',F12.7)
 1922 FORMAT(I5,4F10.5,7I5)
      END
C     ******************************************************************
      SUBROUTINE INPUT (F,LM5)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     INPUT OF MOLECULAR DATA
C     *
CCCC  LOGICAL QUADRS
      INTEGER QUADRS
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./BOND  / KTRIAL
     ./CYCLES/ NPBI,NPETER
     ./ENERG / EE,ENUCLR,EAT,ATHEAT
     ./EXPOL / NSTART,NSTEP
     ./FLAG1 / KTITLE(12),KOMENT(10),KHARGE,KGEOM,KITSCF,KDUMMY,
     .         KSYM,KDEP,KOUNT,NTYPE,KRSAVE,NCNDO
     ./FLAG3 / KRESET,IWADE
     ./HALFE / IMULT,IODD,JODD
     ./MXFLAG/ MAXEND
     ./ORBITS/ NUMB,NORBS,NMOS
     ./PARDER/ CORE(18),EHEAT(18),EISOL(18)
     ./PARM1 / A(3,50),NA(50),NB(50),NC(50),NN(50),NATOMS,LREACT(2)
     ./SETCI / KCI
     ./SKIPA / IGRAD,ISKPA,NWSKP,QUADRS
     ./VVV   / CHANGE(3),DELTA(3),XFAC,YFAC
     ./XSKPRT/ IPUBO,IPUEV,JPRINT,NPRINT
      DIMENSION F(LM5)
      DATA SMALL/1.E-06/
C *** INITIALIZATION.
      KOUNT  = KOUNT+1
      ISKPA  = 0
      KRESET = 0
      NPBI   = 0
      NPETER = 0
CCCC  QUADRS = .FALSE.
      QUADRS = 0
C *** TITLE CARD FOR THE MOLECULE.
      READ(5,100) KHARGE,IMULT,KTRIAL,KGEOM,IPUBO,IPUEV,KITSCF,NPRINT,
     1  KDUMMY,KSYM,KDEP,KCI,NSTART,NSTEP,(KTITLE(I),I=1,12)
      IF(KHARGE.EQ.99) RETURN
      IF(IMULT .GT.3) WRITE(6,611)
      IF(IMULT .GT.3) STOP
      IF(KTRIAL.EQ.3) IPUBO=1
      IF(KTRIAL.EQ.4) IPUEV=1
      IF(IPUBO .EQ.1) IPUEV=0
      IF(KITSCF.EQ.0) KITSCF=50
      IF(NSTART.EQ.0) NSTART=4
      IF(NSTEP .EQ.0) NSTEP=4
      IF(NPRINT.GT.1 .AND. MAXEND.GT.3) NPRINT=1
CCCC  IF(KCI.GT.0 .OR. IMULT.GT.0 .OR. IGRAD.EQ.1) QUADRS=.TRUE.
      IF(KCI.GT.0 .OR. IMULT.GT.0 .OR. IGRAD.EQ.1) QUADRS=1
CCCC  IF(QUADRS) ISKPA=1
      IF(QUADRS .EQ. 1) ISKPA=1
CCCC  IF(.NOT.QUADRS) NWSKP=0
      IF(QUADRS .EQ. 0) NWSKP=0
      ZFAC=XFAC
CCCC  IF(QUADRS) ZFAC=YFAC
      IF(QUADRS .EQ. 1) ZFAC=YFAC
      DO 1 I=1,3
    1 DELTA(I)=CHANGE(I)*ZFAC
C *** INPUT THE TRIAL GEOMETRY AND COMPUTE THE COORDINATES.
      CALL ESTIM(JPRINT)
      CALL GMETRY(+1)
C *** DETERMINE FIRST AND LAST BASIS ORBITAL OF EACH ATOM.
      NELNS=-KHARGE
      IA=1
      DO 5  I=1,NUMAT
      NFIRST(I)=IA
      NI=NAT(I)
      IF (NI.GT.2) GO TO 2
      NELNS=NELNS+NI
      IB=IA
      GO TO 4
    2 IF(NI.GT.10) GO TO 3
      NELNS=NELNS+NI-2
      IB=IA+3
      GO TO 4
    3 NELNS=NELNS+NI-10
      IB=IA+3
    4 NLAST(I)=IB
    5 IA=IB+1
C *** OUTPUT THE CARTESIAN COORDINATES.
      IF(JPRINT.LT.0) GO TO 50
      WRITE(6,600) (KOMENT(I),I=1,10),(KTITLE(I),I=1,12)
      WRITE(6,603)
      K=0
      DO 20 I=1,NATOMS
      NI=NN(I)
      IF(NI.EQ.99) GO TO 21
      IA=NFIRST(I-K)
      IB=NLAST (I-K)
      WRITE(6,604) I,NI,(COORD(J,I),J=1,3),IA,IB
      GO TO 20
   21 K=K+1
      WRITE(6,604) I,NI,(COORD(J,I),J=1,3)
   20 CONTINUE
C *** OUTPUT THE INTERNUCLEAR SEPARATIONS.
      K=0
      KSTOP=0
      DO 40  I=1,NATOMS
      DO 40  J=1,I
      K=K+1
      F(K)=SQRT((COORD(1,I)-COORD(1,J))**2+(COORD(2,I)-COORD(2,J))**2
     1         +(COORD(3,I)-COORD(3,J))**2)
      IF(I.EQ.J .OR. NN(I).EQ.99 .OR. NN(J).EQ.99) GO TO 40
      IF(F(K).LT.SMALL) KSTOP=1
   40 CONTINUE
      WRITE(6,602)
      CALL VECPRT(F,LM5,NATOMS)
      IF(KSTOP.EQ.0) GO TO 50
      WRITE(6,612)
      STOP
C *** REMOVE DUMMY ATOMS.
   50 CALL GMETRY(-2)
C *** DETERMINE OCCUPATION OF THE MOLECULAR ORBITALS.
      NORBS  = NLAST(NUMAT)
      NCLOSE = NELNS/2
      NODD   = NELNS-2*NCLOSE
C     CHECK FOR SIMPLE INPUT ERRORS.
      IF(NODD.EQ.0 .AND. IMULT.NE.2) GO TO 60
      IF(NODD.EQ.1 .AND. IMULT.EQ.2) GO TO 60
      WRITE(6,610) IMULT,NELNS,KHARGE
      STOP
C     CASE IMULT=0.
   60 IF(IMULT.GT.0) GO TO 61
      NUMB   = NCLOSE
      IODD   = 0
      JODD   = 0
      GO TO 65
C     CASE IMULT=1,3.
   61 IF(IMULT.EQ.2) GO TO 62
      NCLOSE = NCLOSE-1
      NUMB   = NCLOSE+2
      IODD   = NCLOSE+1
      JODD   = NUMB
      GO TO 65
C     CASE IMULT=2.
   62 NUMB   = NCLOSE+1
      IODD   = NUMB
      JODD   = 0
C     MINIMUM NUMBER OF MOS REQUIRED.
   65 NMOS   = NUMB
C     PRINTING SECTION.
      IF(JPRINT.LT.0) GO TO 70
      WRITE(6,605) KHARGE,NELNS,NCLOSE
      write(7,777)nclose,nclose-1,nclose-2,nclose-3
 777  format(':1,$ s/AAA/',i2,'/g',/,
     $ ':1,$ s/BBB/',i2,'/g',/,
     $ ':1,$ s/CCC/',i2,'/g',/,
     $ ':1,$ s/DDD/',i2,'/g'/':wq')
      IF(IODD.GT.0 .AND. JODD.EQ.0) WRITE(6,354) IMULT,IODD
      IF(IODD.GT.0 .AND. JODD.GT.0) WRITE(6,355) IMULT,IODD,JODD
      WRITE(6,607) KHARGE,IMULT,KTRIAL,KGEOM,IPUBO,IPUEV,KITSCF,NPRINT,
     1   KDUMMY,KSYM,KDEP,KCI,NSTART,NSTEP
C *** COMPUTE SUMS OF ATOMIC ENERGIES AND HEATS OF FORMATION.
   70 ATHEAT = 0.
      EAT    = 0.
      DO 80 I=1,NUMAT
      NI     = NAT(I)
      ATHEAT = ATHEAT + EHEAT(NI)
   80 EAT    = EAT + EISOL(NI)
      RETURN
  100 FORMAT(6I2,I4,7I2,12A4)
  354 FORMAT(/' MULTIPLICITY     =',I3,10X,'ONE ELECTRON IN ORBITAL',I4)
  355 FORMAT(/' MULTIPLICITY     =',I3,10X,'ONE ELECTRON IN ORBITALS',
     1          I4,2X,'AND',I4)
  600 FORMAT(////, 5X,10A4/ 5X,12A4)
  602 FORMAT(////5X,'INITIAL INTERATOMIC DISTANCES (ANGSTROMS)')
  603 FORMAT(//  5X,44HTRIAL SET OF ATOMIC COORDINATES (ANGSTROMS)
     1       //  5X,8HATOM NO.,8X,10HATOMIC NO.,9X,12HX-COORDINATE,8X,
     2       12HY-COORDINATE,8X,12HZ-COORDINATE,7X,15HATOMIC ORBITALS//)
  604 FORMAT(8X,I2,16X,I2,14X,3(F10.6,10X),I3,4H TO ,I3 )
  605 FORMAT(////19H MOLECULAR CHARGE =,I3,10X,I3,15H ELECTRONS, AND,I3,
     1      20H DOUBLY OCCUPIED MOS )
  607 FORMAT(/ 1X,'OPTIONS',5X,6I2,I4,7I2)
  610 FORMAT(//1X,'MULTIPLICITY AND NUMBER OF ELECTRONS INCOMPATIBLE.',
     1       / 1X,'MULTIPLICITY        =',I4,
     2       / 1X,'NUMBER OF ELECTRONS =',I4,
     3       / 1X,'MOLECULAR CHARGE    =',I4//)
  611 FORMAT(//1X,'MULTIPLICITY GREATER THAN 3. STOP.'//)
  612 FORMAT(//1X,'THERE ARE AT LEAST TWO ATOMS WITH ZERO DISTANCE.',
     1       / 1X,'CHECK INPUT GEOMETRY. STOP.'//)
      END
C     ******************************************************************
      SUBROUTINE ESTIM(JPRINT)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     INPUT OF GEOMETRY IN INTERNAL COORDINATES.
C     *
      COMMON
     ./ATOMS / NATOMS,NN(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./DFP   / SET(99),NVAR
     ./FLAG1 / KTITLE(12),KOMENT(10),KHARGE,KGEOM,KITSCF,KDUMMY,
     .         KSYM,KDEP,KOUNT,NTYPE,KRSAVE,NSTTT
     ./FLAG2 / MIDDLE,SECADD,TIME1
     ./PARM1 / A(3,50),NC(50),NB(50),NA(50),NAT(50),NUMAT,LREACT(2)
     ./PARM2 / NSYMA,NSYM1,NSYMB,ISYM(8,50),NDEP,IDEPFN(20),LOCDEP
     .         (20),LOCPAR(20)
     ./PARM3 / LOC(2,99)
      DIMENSION L(3)
      LOGICAL IFLAG,PRT
      PRT=JPRINT.GE.0
C     *
C     TWO OPTIONS FOR INPUT ARE AVAILABLE.
C     KGEOM=0, STANDARD INPUT OF THE GEOMETRY.
C     KGEOM=1, INPUT OF A NEW REACTION COORDINATE ONLY.
C     *
C     OPTION KGEOM=0. DESCRIPTION OF INPUT FOR EACH ATOM.
C     NAT(I) = THE ATOMIC NUMBER OF ATOM I .
C            = 99, THEN THE I-TH ATOM IS A DUMMY ATOM USED ONLY TO
C              SIMPLIFY THE DEFINITION OF THE MOLECULAR GEOMETRY.
C     A(1,I) = THE INTERNUCLEAR SEPARATION  IN ANGSTROMS  BETWEEN ATOMS
C              NA(I) AND (I).
C     A(2,I) = THE ANGLE NB(I)-NA(I)-(I) INPUT IN DEGREES  STORED IN
C              RADIANS.
C     A(3,I) = THE ANGLE BETWEEN THE VECTORS NC(I)-NB(I) AND NA(I)-(I)
C              INPUT IN DEGREES - STORED IN RADIANS.
C     L(J)   = -1 IF A(J,I) IS THE REACTION COORDINATE.
C            = +1 IF A(J,I) IS A PARAMETER TO BE OPTIMISED
C            =  0 OTHERWISE.
C     NOTE.    MUCH OF THIS DATA IS NOT INCLUDED FOR THE FIRST 3 ATOMS.
C     ATOM 1   INPUT NAT(1) ONLY.
C     ATOM 2   INPUT NAT(2) AND A(1,2)  SEPARATION BETWEEN ATOMS 1 + 2
C     ATOM 3   INPUT NAT(3), A(1,3)     SEPARATION BETWEEN ATOMS 2 + 3
C              AND A(2,3)               ANGLE  ATOM 1 -ATOM 2 -ATOM 3
C     *
C     SELECTION OF INPUT OPTION.
C     *
      IF(MIDDLE.GT.0) GO TO 1
      IF(KOUNT .EQ.1) GO TO 1
      IF(KGEOM .EQ.1) GO TO 30
C     *
C     OPTION KGEOM=0. STANDARD INPUT OF GEOMETRY.
C     *
C *** INITIALIZATION.
    1 NVAR=0
      NATOMS=0
      NPOINT=0
      LREACT(1)=0
      LREACT(2)=0
      DO 2 J=1,99
      LOC(1,J)=0
    2 LOC(2,J)=0
      I=0
C *** INPUT OF INTERNAL COORDINATES, LOOP OVER ATOMS.
    3 I=I+1
      READ(5,500) NAT(I),(A(J,I),L(J),J=1,3),NAI,NB(I),NC(I)
      IF(NAT(I).LE.0) GO TO 8
      NA(I)=NAI
      IF((NA(I).GE.I).OR.(NB(I).GE.I).OR.(NC(I).GE.I)) GO TO 1001
      IF(NAT(I).EQ.99) GO TO 4
      NATOMS=NATOMS+1
      NN(NATOMS)=NAT(I)
      JAT1=NN(NATOMS)
      IF(JAT1.GT.18) GO TO 1004
C     CONVERT THE ANGLES TO RADIANS.
    4 A(2,I)=A(2,I)*0.0174532925
      A(3,I)=A(3,I)*0.0174532925
      DO 7  J=1,3
      IF(L(J)) 5,7,6
C     LREACT(1) DEFINES THE ATOM LINKED WITH THE REACTION COORDINATE,
C     AND LREACT(2) THE TYPE OF REACTION COORDINATE.
    5 LREACT(1)=I
      LREACT(2)=J
      GO TO 7
C     LOC(1,NVAR) AND LOC(2,NVAR) SIMILARLY DEFINE LOCATION OF NVAR-TH
C     GEOMETRICAL VARIABLE TO BE OPTIMIZED.
    6 NVAR=NVAR+1
      LOC(1,NVAR)=I
      LOC(2,NVAR)=J
      SET(NVAR)=A(J,I)
    7 CONTINUE
      GO TO 3
C *** AT THE END OF THE LOOP, THE FOLLOWING VARIABLES ARE DEFINED.
C     NUMAT = THE NUMBER OF ATOMS IN THE MOLECULE INCLUDING DUMMY ATOMS.
C     NATOMS= THE NUMBER OF ATOMS IN THE MOLECULE EXCLUDING DUMMY ATOMS.
C     NVAR  = THE NUMBER OF GEOMETRICAL VARIABLES TO BE OPTIMIZED.
    8 CONTINUE
      NUMAT=I-1
      NA(2)=1
      NA(3)=2
      NB(3)=1
C *** INPUT OF SYMMETRY CONDITIONS, FIRST PART.
C     NSYMA IS THE NUMBER OF SETS OF EQUAL BOND LENGTHS OR ANGLES TO BE
C     INPUT AT THIS POINT (BEFORE DEPENDENT PARAMETERS).
C     ISYM(6,I) AND ISYM(7,I) DEFINE THE PRIMARY VARIABLE (I-TH SET).
C     THE CONVENTIONS ARE THE SAME AS FOR LREACT AND LOC (SEE ABOVE).
C     ISYM(8,I) IS THE NUMBER OF SECONDARY VARIABLES WHICH ARE SET EQUAL
C     TO THE PRIMARY VARIABLE DEFINED BY ISYM(6,I) AND ISYM(7,I).
      NDEP=0
      NSYMA=0
      NSYM1=0
      NSYMB=0
      IF((KSYM.EQ.0).AND.(KDEP.EQ.0)) GO TO 19
      IF(PRT) WRITE(6,600) (KOMENT(I),I=1,10),(KTITLE(I),I=1,12)
      IF(KSYM.EQ.0) GO TO 13
    9 NSYM=1
      IFLAG=.FALSE.
      READ(5,501) (ISYM(I,NSYM),I=6,8),(ISYM(I,NSYM),I=1,5)
      J=ISYM(8,NSYM)
      IF(J.GT.5) GO TO 1002
      IF(J.GT.0) GO TO 10
C     THERE ARE NO SYMMETRY CONDITIONS TO BE IMPOSED BEFORE COMPUTING
C     THE PARAMETER DEPENDENCE DATA.
      IF(PRT) WRITE(6,601)
      IF(KDEP.EQ.0) GO TO 19
      GO TO 13
C     SYMMETRY CONDITIONS TO BE INPUT.
   10 IF(PRT) WRITE(6,602)
      IF(PRT .AND. KDEP.NE.0) WRITE(6,603)
   11 IF(PRT) WRITE(6,604)
   12 IF(PRT) WRITE(6,605) (ISYM(I,NSYM),I=6,7),(ISYM(I,NSYM),I=1,J)
      NSYM=NSYM+1
      READ(5,501) (ISYM(I,NSYM),I=6,8),(ISYM(I,NSYM),I=1,5)
      J=ISYM(8,NSYM)
      IF(J.GT.5) GO TO 1002
      IF(J.GT.0) GO TO 12
      IF(IFLAG) GO TO 17
      NSYMA=NSYM-1
      IF(KDEP.EQ.0) GO TO 18
C *** INPUT OF DEPENDENT PARAMETERS.
C     LOCDEP IS THE ATOM NUMBER ON WHICH THE DEPENDENT PARAMETER IS
C     LOCATED, AND I IS ITS TYPE (SEE ABOVE).
C     IDEPFN IS THE STATEMENT NUMBER IN SUBROUTINE HADDON OR DEPVAR
C     USED TO EVALUATE THE NDEP-TH DEPENDENT PARAMETER VIA A COMPUTED
C     GOTO STATEMENT.
C     LOCPAR IS THE ATOM NUMBER ON WHICH THE VARIABLE USED TO DETERMINE
C     THE NDEP-TH DEPENDENT PARAMETER IS LOCATED, AND LTYPE IS ITS TYPE.
   13 IF(PRT) WRITE(6,606)
   14 NDEP=NDEP+1
      READ(5,502) LOCDEP(NDEP),I,IDEPFN(NDEP),N,LOCPAR(NDEP),LTYPE
      IF(LOCDEP(NDEP).LE.0) GO TO 15
      IF(PRT) WRITE(6,607)LOCDEP(NDEP),I,IDEPFN(NDEP),LOCPAR(NDEP),LTYPE
      GO TO 14
   15 NDEP=NDEP-1
      IF(KSYM.EQ.0) GO TO 18
C *** INPUT OF SYMMETRY CONDITIONS, SECOND PART.
   16 READ(5,501) (ISYM(I,NSYM),I=6,8),(ISYM(I,NSYM),I=1,5)
      J=ISYM(8,NSYM)
      IF(J.GT.5) GO TO 1002
      IF(J.LE.0 .AND. PRT) WRITE(6,613)
      IF(J.LE.0) GO TO 18
C     SYMMETRY CONDITIONS ARE TO BE IMPOSED AFTER COMPUTING THE
C     PARAMETER-DEPENDENCE DATA.
      IF(PRT) WRITE(6,608)
      IFLAG=.TRUE.
      GO TO 11
   17 NSYM1=NSYMA+1
      NSYMB=NSYM-1
   18 IF(PRT) WRITE(6,609)
C *** PRINTING SECTION.
   19 IF(PRT) WRITE(6,600) (KOMENT(I),I=1,10),(KTITLE(I),I=1,12)
      IF(PRT .AND. NPOINT.GT.0) WRITE(6,659) NPOINT
      IF(PRT) WRITE(6,610)
      IF(PRT .AND. MIDDLE.GT.0) WRITE(6,617)
      CALL SYMTRY (JPRINT)
      IF(PRT) WRITE(6,611) NVAR
      RETURN
C     *
C     OPTION KGEOM=1. INPUT OF A NEW REACTION COORDINATE ONLY.
C     THE REST OF THE GEOMETRY IS TAKEN FROM THE PREVIOUS RUN.
C     *
   30 READ(5,504) LREACT(1),LREACT(2),REACT,NPOINT
      I=LREACT(1)
      J=LREACT(2)
      IF((I.LE.0).OR.(I.GT.NUMAT).OR.(J.LE.0).OR.(J.GT.3)) GO TO 1003
      IF(J.GT.1) REACT=REACT*0.01745329252
      A(J,I)=REACT
C     STORE VARIABLES TO BE OPTIMIZED.
      DO 31 K=1,NVAR
      I=LOC(1,K)
      J=LOC(2,K)
   31 SET(K)=A(J,I)
C     GO TO PRINTING SECTION.
      GO TO 19
C     *
C *** ERROR SECTION
C     *
 1001 WRITE(6,614) I
      STOP
 1002 WRITE(6,615) NSYM
      STOP
 1003 WRITE(6,616)
      STOP
 1004 WRITE(6,618) NATOMS,JAT1
      STOP
  500 FORMAT(I2,8X,3(F10.5,2X,I2,6X),3I2)
  501 FORMAT(I2,2X,I1,5X,I2,5X,10(3X,I2) )
  502 FORMAT(I2,1X,I1,5X,I2,2X,I2,5X,10(I2,1X,I1,2X) )
  504 FORMAT(I2,1X,I2,5X,F10.5,3I2,I3)
  600 FORMAT(//// 5X,10A4/ 5X,12A4)
  601 FORMAT(   //5X,89HTHERE ARE NO SYMMETRY CONDITIONS TO BE IMPOSED B
     1EFORE EVALUATING THE DEPENDENT VARIABLES.   )
  602 FORMAT(   //5X,19HSYMMETRY CONDITIONS   )
  603 FORMAT(1H+,24X,55HTO BE IMPOSED BEFORE EVALUATING THE DEPENDENT VA
     1RIABLES    )
  604 FORMAT(/15X,8HVARIABLE /15X, 9HPARAMETER,20X, 64HNUMBERS OF ATOMS
     1FOR WHICH PARAMETER EQUALS VARIABLE PARAMETER  /15X,8HLOCATION
     2 // 14X,10HATOM  TYPE   /)
  605 FORMAT(15X,I2,5X,I1,16X,10I7  )
  606 FORMAT(///5X,25HPARAMETER DEPENDENCE DATA //15X,9HDEPENDENT, 6X,
     1 9HDEPENDENT /15X,9HPARAMETER,6X,8HFUNCTION,6X,68HLOCATIONS OF THE
     2 PARAMETERS USED TO EVALUATE THE DEPENDENT PARAMETER / 15X,
     3 8HLOCATION,8X,6HNUMBER,28X,26HATOM NUMBERS AND TYPES ( ) //
     4 14X,10HATOM  TYPE  /)
  607 FORMAT(15X,I2,5X,I1,10X,I2,9X,8(I2,1X,1H(,I1,1H),3X),
     1     / 44X,8(I2,1X,1H(,I1,1H),3X) / 44X,8(I2,1X,1H(,I1,1H),3X) )
  608 FORMAT(///5X,74HSYMMETRY CONDITIONS TO BE IMPOSED AFTER EVALUATING
     1 THE DEPENDENT VARIABLES   )
  609 FORMAT(//// 15H ************** // 5X,50HTYPE.  1=BOND-LENGTH  2=BO
     1ND-ANGLE  3=TWIST-ANGLE  )
  610 FORMAT(//5X,25HTRIAL GEOMETRY PARAMETERS /)
  611 FORMAT(//// 15H ************** // 5X,50H *  PARAMETERS TO BE OPTIM
     1IZED, OF WHICH THERE ARE, I3 / 5X,27H +  THE REACTION COORDINATE )
  613 FORMAT(///5X,87HTHERE ARE NO SYMMETRY CONDITIONS TO BE IMPOSED AFT
     1ER EVALUATING THE DEPENDENT VARIABLES   )
  614 FORMAT(///5X,35H***** GEOMETRY IS ILL DEFINED, ATOM ,I3)
  615 FORMAT(///5X,44H***** SYMMETRY CONDITION IS ILL DEFINED, SET ,I3)
  616 FORMAT(///5X,44H***** THE REACTION COORDINATE IS ILL DEFINED )
  617 FORMAT(5X,64H NOTE. THESE PARAMETERS DEFINE THE INITIAL TRIAL GEOM
     1ETRY OF THE   /12X,58HPREVIOUS RUN. THIS RUN STARTS WHERE THE PREV
     2IOUS RUN ENDED   / 12X,13HPREMATURELY.   //)
  618 FORMAT(///5X,27H***** ATOMIC NUMBER OF ATOM ,I3,3H  =,I4)
  642 FORMAT(5(I3,I2,F10.5))
  659 FORMAT(//,5X,'POINT',I4,3X,'IN REACTION PATH')
      END
C     ******************************************************************
      SUBROUTINE SETUPS
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     INPUT FOR CONFIGURATION INTERACTION
C     *
      COMMON
     ./CCIS  / KTHMO,LTHMO,MTHMO,NTHMO,LROOT,NC,ELENGY,
     .         E(6),ENGYCI(3),VECTCI(3,3),JFROM(3),JTO(3)
     ./HALFE / IMULT,IODD,JODD
     ./ORBITS/ NUMB,NORBS,NMOS
     ./XSKPRT/ IPUBO,IPUEV,JPRINT,NPRINT
      JFROM(1)=0
      JTO(1)=0
      READ(5,100) LROOT,KTHMO,LTHMO,MTHMO,NTHMO
      IF(IMULT-1) 10,15,20
C     DEFAULT VALUES FOR 2*2 CLOSED-SHELL CI.
   10 CONTINUE
      IF(LROOT.EQ.0) LROOT=1
      IF(KTHMO.EQ.0) KTHMO=NUMB
      IF(LTHMO.EQ.0) LTHMO=NUMB+1
      NC=2
      JFROM(2)= KTHMO
      JTO(2)  = LTHMO
      NMOS    = LTHMO
      GO TO 25
C     DEFAULT VALUES FOR 3*3 SINGLET CI (HALF ELECTRON METHOD).
   15 CONTINUE
      IF(LROOT.EQ.0) LROOT=1
      IF(KTHMO.EQ.0) KTHMO=NUMB-1
      IF(LTHMO.EQ.0) LTHMO=NUMB
      IF(MTHMO.EQ.0) MTHMO=NUMB
      IF(NTHMO.EQ.0) NTHMO=NUMB-1
      NC=3
      JFROM(2)= LTHMO
      JFROM(3)= KTHMO
      JTO(2)  = KTHMO
      JTO(3)  = LTHMO
      NMOS    = NTHMO
      IF(MTHMO.GT.NMOS) NMOS=MTHMO
      GO TO 25
C     DEFAULT VALUES FOR 2*2 DOUBLET CI (HALF ELECTRON METHOD).
   20 CONTINUE
      IF(LROOT.EQ.0) LROOT=1
      IF(KTHMO.EQ.0) KTHMO=NUMB
      IF(LTHMO.EQ.0) LTHMO=NUMB+1
      NC=2
      JFROM(2)= KTHMO
      JTO(2)  = LTHMO
      NMOS    = LTHMO
C     PRINT CI DATA.
   25 CONTINUE
      IF(JPRINT.LT.0) RETURN
      IF(NC.EQ.2) WRITE(6,110) LROOT,KTHMO,LTHMO
      IF(NC.EQ.3) WRITE(6,110) LROOT,KTHMO,LTHMO,MTHMO,NTHMO
      RETURN
  100 FORMAT(10I5)
  110 FORMAT(/1X,'CI DATA',5X,5I4)
      END
C     ******************************************************************
      SUBROUTINE INSYMC
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     INPUT FOR SYMMETRY ASSIGNMENT.
C     *
      COMMON
     ./CIFLAG/ ICJUMP,IOUTCI,IAX,LROOT,IMPEN,IEN2,IPERT(4)
     ./CIMOS / IMOCI(100),NSYM(100)
     ./CIPARM/ ICI1,ICI2,IOUT2,ISUB
     ./ORBITS/ NUMB,NORBS,NMOS
     ./SYMMIN/ ICEN(15),ICEN1(24),ICEN2(24),IOZ,NNXY,NRXY,NRYZ,IDZ,IAXE
     ./XSKPRT/ IPUBO,IPUEV,JPRINT,NPRINT
      DIMENSION SYMGRP(5)
      DATA SYMGRP/4HCS   ,4HC2   ,4HC2V  ,4HD2H  ,4HC2H  /
      NRE=5
      NRA=6
C *** INPUT OF SYMMETRY RELATIONS.
      READ(NRE,50) ISUB,IOZ,IAX,NNXY,NRXY,NRYZ,IDZ,IAXE
      IF(ISUB.LE.0) GO TO 100
      IF(ISUB.EQ.1 .OR. ISUB.GT.3) IOZ=0
      IF(ISUB.EQ.1 .OR. ISUB.GT.3) IAX=0
      IF(ISUB.EQ.2 .OR. ISUB.EQ.3) NNXY=0
      IF(ISUB.EQ.2 .OR. ISUB.EQ.3) NRXY=0
      IF(NNXY.GT.0) READ(NRE,22) (ICEN (I),I=1,NNXY)
      IF(NRXY.GT.0) READ(NRE,22) (ICEN1(I),I=1,NRXY)
      IF(NRYZ.GT.0) READ(NRE,22) (ICEN2(I),I=1,NRYZ)
      IF(JPRINT.LT.0) GO TO 100
      WRITE(NRA,3140) SYMGRP(ISUB)
      WRITE(NRA,3145) ISUB,IOZ,IAX,NNXY,NRXY,NRYZ,IDZ,IAXE
      IF(NNXY.GT.0) WRITE(NRA,3155) (ICEN (I),I=1,NNXY)
      IF(NRXY.GT.0) WRITE(NRA,3165) (ICEN1(I),I=1,NRXY)
      IF(NRYZ.GT.0) WRITE(NRA,3175) (ICEN2(I),I=1,NRYZ)
C *** INPUT OF OPTIONS FOR PERTURBATION TREATMENT.
  100 NAMB=NORBS-NUMB
      READ(NRE,50) ICI1,ICI2,IOUTCI,MOVO,MPERT
      IF(ICI1.EQ.0   ) ICI1=20
      IF(ICI1.GT.NUMB) ICI1=NUMB
      IF(ICI2.EQ.0   ) ICI2=20
      IF(ICI2.GT.NAMB) ICI2=NAMB
      IF(JPRINT.GE.0 ) WRITE(NRA,3185) ICI1,ICI2,IOUTCI
      IOUT2=IOUTCI
C *** DEFINITION OF ORBITALS INVOLVED IN THE PERTURBATION TREATMENT.
      IA=ICI1+1
      IB=ICI1+ICI2
      DO 101 I=1,ICI1
  101 IMOCI(I)=NUMB+1-I
      DO 102 I=IA,IB
  102 IMOCI(I)=NUMB+1+I-IA
      NMOS=IMOCI(IB)
      IF(MOVO.EQ.0) GO TO 105
      READ(NRE,50) (IMOCI(I),I=1,ICI1)
      READ(NRE,50) (IMOCI(I),I=IA,IB)
      DO 103 I=IA,IB
  103 IF(IMOCI(I).GT.NMOS) NMOS=IMOCI(I)
      IF(JPRINT.LT.0) GO TO 105
      WRITE(NRA,3200) (IMOCI(I),I=1,ICI1)
      WRITE(NRA,3205) (IMOCI(I),I=IA,IB)
C *** SELECTION OF PERTURBATION TREATMENT.
  105 IPERT(1) = 0
      IPERT(2) = 0
      IPERT(3) = 0
      IPERT(4) = 1
      IEN2     = 1
      IF(MPERT.EQ.0) RETURN
      READ(NRE,50) (IPERT(I),I=1,4)
      IF(JPRINT.GE.0) WRITE(6,3195) (IPERT(I),I=1,4)
      IEN2=0
      IF(IPERT(2).NE.0 .OR. IPERT(4).NE.0) IEN2=1
      RETURN
   22 FORMAT(40I2)
   50 FORMAT(20I4)
 3140 FORMAT(//1X,'POINT GROUP ',A4)
 3145 FORMAT(/1X,'SYMMETRY OPTIONS'/ 10I4)
 3155 FORMAT(/1X,'CENTERS IN XY-PLANE'/ (30I4))
 3165 FORMAT(/1X,'CENTERS RELATED BY XY-PLANE'/ (4X,2I4))
 3175 FORMAT(/1X,'CENTERS RELATED BY YZ-PLANE'/ (4X,2I4))
 3185 FORMAT(/1X,'NUMBER OF MOS',2X,I4,
     1       /1X,'NUMBER OF VOS',2X,I4,
     2       /1X,'PRINTING FLAG',2X,I4)
 3195 FORMAT(/1X,'MPERT OPTIONS',2X,4I4)
 3200 FORMAT(/1X,'MOS',12X,20I4/(16X,20I4))
 3205 FORMAT(/1X,'VOS',12X,20I4/(16X,20I4))
      END
C     ******************************************************************
      SUBROUTINE SYMMC
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     INITIALIZE MULTIPLICATION TABLES.
C     *
      COMMON /CIPARM/ ICI1(4),ITYPE(8,8)
      DIMENSION MULT(36)
      DATA MULT/1,2,1,3,4,1,4,3,2,1,5,6,7,8,1,6,5,8,7,2,1,7,8,5,6,3,4,
     11,8,7,6,5,4,3,2,1/
      NN=0
      DO 10 I=1,8
      DO 10 J=1,I
      NN=NN+1
      ITYPE(I,J)=MULT(NN)
   10 ITYPE(J,I)=ITYPE(I,J)
      RETURN
      END
C     ******************************************************************
      SUBROUTINE DYNCOR (LSP)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     DYNAMIC CORE ALLOCATION AND CHECK ON LIMITS.
C     *
C     IN THE PRESENT PROGRAM THE COMMON BLOCK /MATRIX/ IS USED AS BUFFER
C     FOR LARGE DATA ARRAYS, WITH DYNAMIC ALLOCATION OF CORE SPACE. THE
C     CORE REQUIREMENTS ARE LARGEST IN THE SCF SEGMENT AND IN THE PERT
C     SEGMENT (INTEGRAL TRANSFORMATION). FOR THESE SEGMENTS, SUBROUTINE
C     DYNCOR CHECKS WHETHER THE AVAILABLE SPACE IS SUFFICIENT, AND THEN
C     ALLOCATES THE CORE SPACE. THIS INVOLVES COMPUTING VARIOUS FIELD
C     LENGTHS (LM2-LM4 FOR SCF, LM6-LM8 FOR PERT) AS WELL AS COMPUTING
C     VARIOUS ADDRESSES FOR FIRST FIELD ELEMENTS (LS1-LS8 FOR SCF,
C     LP1-LP6 FOR PERT).
C     *
C     NOTATION.
C     LM1    MAXIMUM NUMBER OF ATOMS.
C     LM2    ACTUAL  NUMBER OF BASIS ORBITALS.
C     LM3    ACTUAL  NUMBER OF SCF EIGENVECTORS COMPUTED.
C     LM4    DIMENSION OF LOWER TRIANGLE OF LM2*LM2 MATRIX.
C     LM5    LENGTH OF COMMON /MATRIX/.
C     LM6    NUMBER OF UNIQUE ONE-CENTER AO PAIRS IN THE MOLECULE.
C     LM7    LENGTH OF FIRST  BUFFER FOR INTEGRAL TRANSFORMATION.
C     LM8    LENGTH OF SECOND BUFFER FOR INTEGRAL TRANSFORMATION.
C     LM9    LENGTH OF COMMON /WREP/.
C     NOTE.  LM1,LM5,LM9 ARE DEFINED IN THE MAIN PROGRAM.
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./CIPARM/ ICI1,ICI2
     ./LIMITS/ LM1,LM2,LM3,LM4,LM5,LM6,LM7,LM8,LM9
     ./LMOUT / INOUT
     ./LMPERT/ LP1,LP2,LP3,LP4,LP5,LP6
     ./LMSCF / LS1,LS2,LS3,LS4,LS5,LS6,LS7,LS8
     ./OPTION/ IOP
     ./ORBITS/ NUMB,NORBS,NMOS
     ./SETCI / KCI
     ./XSKPRT/ IPUBO(3),NPRINT
C     *
C     SCF SEGMENT.
C     *
CCC        WRITE (*,709)
709     FORMAT (' DYNCOR - BAN ')
      LM2    = NORBS
      LM3    = NORBS
      LM4    = (LM2*(LM2+1))/2
C     CHECK TOTAL FIELD LENGTH REQUIRED.
      LSUM   = LM2*LM3+2*LM3+5*LM2+2*LM4
      IF(LSUM.LE.LM5) GO TO 10
      LM3    = NMOS
      LSUM   = LM2*LM3+2*LM3+5*LM2+2*LM4
      IF(LSUM.GT.LM5) GO TO 40
C     ASSIGN ADDRESSES.
   10 LS1    = 1
      LS2    = LS1+LM2*LM3
      LS3    = LS2+LM3
      LS4    = LS3+LM3
      LS5    = LS4+5*LM2
      LS8    = LM5-LM4+1
      LSP    = LS8
      LTEST  = LSUM+2*LM4
      IF(LTEST.GT.LM5) GO TO 20
C     EVERYTHING FITS INTO THE CORE.
      INOUT  = 0
      LSUM   = LTEST
      LS6    = LS5+LM4
      LS7    = LS6+LM4
      GO TO 30
C     FILE HANDLING REQUIRED.
   20 INOUT  = 2
      LS6    = LS5
      LS7    = LS5
C     PRINTING SECTION.
   30 IF(NPRINT.LT.3) GO TO 100
      WRITE(6,500) LM5,LSUM,LM2,LM3,LM4
      IF(INOUT.GT.0) WRITE(6,505) INOUT
      L23    = LM2*LM3
      L25    = LM2*5
      LL1    = LS2-1
      LL2    = LS3-1
      LL3    = LS4-1
      LL4    = LS5-1
      LL5    = LS5-1+LM4
      LL6    = LS6-1+LM4
      LL7    = LS7-1+LM4
      WRITE(6,510) LS1,LL1,L23,LS2,LL2,LM3,LS3,LL3,LM3,LS4,LL4,L25,
     1             LS5,LL5,LM4,LS6,LL6,LM4,LS7,LL7,LM4,LS8,LM5,LM4
      GO TO 100
C     ERROR EXIT.
   40 WRITE(6,500) LM5,LSUM,LM2,LM3,LM4
      WRITE(6,520)
      WRITE(6,900)
      STOP
C     *
C     PERT SEGMENT (INTEGRAL TRANSFORMATION).
C     *
  100 IF(IABS(KCI).LT.2) GO TO 200
      LM6    = 0
      DO 110 I=1,NUMAT
      IAO    = NLAST(I)-NFIRST(I)+1
  110 LM6    = LM6+(IAO*(IAO+1))/2
      IF(IOP.GT.1) LM6=NUMAT
      LM7    = LM6
      LM8    = (ICI1+ICI2)**2
      LGG    = ICI1*LM6
      IF(LGG.GT.LM8) LM8=LGG
C     CHECK TOTAL FIELD LENGTH REQUIRED.
      LSUM   = LM2*LM3+LM3+2*LM6+LM7+LM8
      IF(LSUM.GT.LM5) GO TO 140
C     ASSIGN ADDRESSES.
      LP1    = 1
      LP2    = LP1+LM2*LM3
      LP3    = LP2+LM3
      LP4    = LP3+LM6
      LP5    = LP4+LM6
      LSUM   = LM2*LM3+LM3+2*LM6+LM6*LM6+LM8+LM4
      IF(LSUM.GT.LM5) GO TO 120
C     EVERYTHING FITS INTO THE CORE.
      LM7    = LM6*LM6
      GO TO 130
C     FILE HANDLING REQUIRED.
  120 IF(INOUT.EQ.0) INOUT=1
      LSUM   = LSUM-LM4
      IF(LSUM.GT.LM5) GO TO 125
      LM7    = LM6*LM6
      GO TO 130
  125 LSUM   = LM5
      LM7    = LM5-LM2*LM3-LM3-2*LM6-LM8
  130 LP6    = LP5+LM7
C     PRINTING SECTION
      IF(NPRINT.LT.3) GO TO 200
      WRITE(6,600) LM5,LSUM,LM6,LM7,LM8
      IF(INOUT.EQ.1) WRITE(6,505) INOUT
      L23    = LM2*LM3
      LL1    = LP2-1
      LL2    = LP3-1
      LL3    = LP4-1
      LL4    = LP5-1
      LL5    = LP6-1
      LL6    = LP6-1+LM4
      WRITE(6,610) LP1,LL1,L23,LP2,LL2,LM3,LP3,LL3,LM6,LP4,LL4,LM6,
     1             LP5,LL5,LM7,LP6,LL6,LM8
      GO TO 200
C     ERROR EXIT.
  140 WRITE(6,600) LM5,LSUM,LM6,LM7,LM8
      WRITE(6,620)
      WRITE(6,900)
      STOP
C     *
C     CHECK ON OTHER LIMITS.
C     *
  200 IF(IOP.LE.0) GO TO 210
      NREP   = (NUMAT*(NUMAT+1))/2
      IF(NREP.LE.LM9) GO TO 210
      WRITE(6,700) NREP,LM9
      WRITE(6,900)
      STOP
  210 RETURN
  500 FORMAT (///1X,'TOTAL LENGTH OF COMMON /MATRIX/      ',I6,
     1        /  1X,'FIELD LENGTH REQUIRED IN SCF         ',I6,
     2        /  1X,'NUMBER OF BASIS ORBITALS             ',I6,
     3        /  1X,'NUMBER OF EIGENVECTORS COMPUTED      ',I6,
     4        /  1X,'DIMENSION OF LOWER TRIANGLE MATRIX   ',I6)
  505 FORMAT (   1X,'FILE HANDLING OPTION                 ',I6)
  510 FORMAT (///1X,'CORE ALLOCATION FOR SCF SEGMENT',
     1        // 1X,' START    FINAL   LENGTH    CONTENTS',
     2        // 1X,I6,2I9,4X,'EIGENVECTORS',
     3        /  1X,I6,2I9,4X,'EIGENVALUES',
     4        /  1X,I6,2I9,4X,'OCCUPATION NUMBERS',
     5        /  1X,I6,2I9,4X,'DIAGONALIZATION BUFFER',
     6        /  1X,I6,2I9,4X,'DIFFERENCE DENSITY MATRIX',
     7        /  1X,I6,2I9,4X,'FOCK MATRIX',
     8        /  1X,I6,2I9,4X,'CORE HAMILTONIAN MATRIX',
     9        /  1X,I6,2I9,4X,'DENSITY MATRIX')
  520 FORMAT (/  1X,'COMMON /MATRIX/ TOO SMALL IN SCF SEGMENT.')
  600 FORMAT (///1X,'TOTAL LENGTH OF COMMON /MATRIX/      ',I6,
     1        /  1X,'FIELD LENGTH REQUIRED IN PERT        ',I6,
     2        /  1X,'NUMBER OF ONE-CENTER AO PAIRS        ',I6,
     3        /  1X,'LENGTH OF FIRST  BUFFER IN PERT      ',I6,
     4        /  1X,'LENGTH OF SECOND BUFFER IN PERT      ',I6)
  610 FORMAT (///1X,'CORE ALLOCATION FOR PERT SEGMENT',
     1        // 1X,' START    FINAL   LENGTH    CONTENTS',
     2        // 1X,I6,2I9,4X,'EIGENVECTORS',
     3        /  1X,I6,2I9,4X,'EIGENVALUES',
     4        /  1X,I6,2I9,4X,'COEFFICIENT PRODUCTS',
     5        /  1X,I6,2I9,4X,'HALF-TRANSFORMED INTEGRALS',
     6        /  1X,I6,2I9,4X,'FIRST  INTEGRAL BUFFER',
     7        /  1X,I6,2I9,4X,'SECOND INTEGRAL BUFFER')
  620 FORMAT (/  1X,'COMMON /MATRIX/ TOO SMALL IN PERT SEGMENT.')
  700 FORMAT (///1X,'NUMBER OF COULOMB INTEGRALS (CNDO,INDO)',I6,
     1        /  1X,'MAXIMUM NUMBER ALLOWED IN COMMON /WREP/',I6)
  900 FORMAT (///1X,'STOP. THE MOLECULE IS TOO BIG.'///)
      END
