      SUBROUTINE partic(C,E,OCC,Q,D,F,H,P,W,LM2,LM3,LM4,LM9,NROOT)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     Energy partitioning (I.Mayer, Budapest, 1992)
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./ENERG / EE,ENUCLR,EAT,ATHEAT
     ./FLAG1 / KTITLE(12),KOMENT(10),KHARGE,KGEOM,KITSCF,KDUMMY,
     .         KSYM,KDEP,KOUNT,NTYPE,KRSAVE,ITSAVE
     ./FLAG3 / KRESET,IWADE
     ./FLAG4 / INTSUM
     ./FUNCT / VALUE,EESAVE,ENSAVE,EPSAVE
     ./HALFE / IMULT,IODD,JODD
     ./HALFX / XI,XJ,XK
     ./LMOUT / INOUT
     ./NBFILE/ NB1,NB2,NB3,NB4
     ./OPTION/ IOP
     ./ORBITS/ NUMB,NORBS
     ./REP   / GSS(18),GPP(18),GSP(18),GP2(18),HSP(18),HPP(18)
     ./SCRT  / SCFCRT,SCFF
     ./XSKPRT/ IPUBO,IPUEV,JPRINT,NPRINT
      common /parti/ ept(50,50),ept0(50,50),nept,limept
     ./EXTRA / RI(22),CORE(4,2),T(5),X(3),Y(3),Z(3)
     ./PASS1 / NI,NJ,R,GAM,NBOND,IIDUM
     $/mani/kontrol,iodd1,iodd2,afact,fact2
      DIMENSION C(LM2,LM3),D(LM4),E(LM3),F(LM4),H(LM4),P(LM4)
      DIMENSION OCC(LM3),Q(LM2,5),W(LM9)
c
c nept is the dimension of the energy partitioning matrices !!!
      nept=50
c
      limept=nept**2
C *** INITIALIZATION.
       NPRINT=2
      ENU=0.d0
      num1=numat-1
      if(num1.eq.0)goto 99
      do 100 j=1,num1
      jp1=j+1
      do 100 i=jp1,numat
 100  enu=enu+ept(i,j)
  99   KSCF   = 0
c      NITER  = 0
      ee=0.d0
      DO 10 I=1,NUMB
   10 OCC(I)=2.
      IF(IODD.GT.0) OCC(IODD)=1.
      IF(JODD.GT.0) OCC(JODD)=1.
CCC      IF(NPRINT.GE.2) WRITE(6,600)
CCC      IF(NPRINT.GE.2) WRITE(8,600)
C     FILE HANDLING.
      IF(INOUT.EQ.0) GO TO 2
      REWIND NB1
      READ(NB1) P
      IF(INOUT.LT.2) GO TO 2
      REWIND NB3
      WRITE(NB3) H
C *** START THE SCF LOOP HERE
    2 NITER=NITER+1
   22 CALL ESCF (EH,NORBS,P,h,LM4)
      call pcore (f,h,p,w,lm4,lm9)
c      kfut=1
c      do 132 i=1,norbs
c      lfut=kfut+i-1
c      write(6,6018)(h(ifut),ifut=kfut,lfut)
c      kfut=kfut+i
c 132  continue
c 6018 format(/,2(8f10.5/))
      DO 20 I=1,LM4
   20 F(I)   = H(I)
      CALL pESCF (EHx,NORBS,P,h,LM4)
C *** TWO-CENTER TERMS.
      DO 80  I=1,NUMAT
      NI=NAT(I)
      IA=NFIRST(I)
      IB=NLAST(I)
   30 IMINUS=I-1
      IF(IMINUS.EQ.0) GO TO 80
      DO 70  J=1,IMINUS
      NJ=NAT(J)
      JA=NFIRST(J)
      JB=NLAST(J)
C     COMPUTE THE INTERATOMIC DISTANCE.
      X(1)= COORD(1,I)-COORD(1,J)
      X(2)= COORD(2,I)-COORD(2,J)
      X(3)= COORD(3,I)-COORD(3,J)
      Z(3)= X(1)*X(1)+X(2)*X(2)
      R= SQRT(X(3)*X(3)+Z(3))
C     COMPUTE THE ROTATION MATRIX ELEMENTS TO CONVERT FROM LOCAL TO
C     MOLECULAR COORDINATES.
      CALL ROTMAT
      R=R/0.529167
Cccc     COMPUTE THE CORE RESONANCE INTEGRALS.
ccc      CALL BETAIJ(IA,JA,H,LM4)
C     COMPUTE THE REPULSION INTEGRALS, AND CORE-ELECTRON ATTRACTIONS.
C     INTEGRALS.
      CALL prOTAT (IA,IB,JA,JB,KR,H,W,LM4,LM9,p,qtp)
c      write(6,6001)
c 6001 format(1x,'one-el. two-centre')
c      write(6,642)i,j,ia,ib,ja,jb,qtp
      ehx=ehx+qtp
c This term should be added to ee because will be omitted from F:
      ee=ee+qtp
c Here to be used twice owing to the core in F:
      ept(i,j)=ept(i,j)+qtp+qtp
      ept(j,i)=ept(i,j)
   70 CONTINUE
   80 CONTINUE
      ex=eh-ehx
      write(6,617) ex
  617 format(/,1x,'Trace control',f20.10,//)
C Two-centre two-electron terms will be accumulated in ecoul
c      write(6,6002)
c 6002 format(1x,'two-el. two-centre')
      ecoul=0.d0
      KR=0
      IF(IOP.LE.0 .AND. INTSUM.GT.LM9) REWIND NB2
      DO 9  II=1,NUMAT
      IA=NFIRST(II)
      IB=NLAST(II)
      IF (II.EQ.1) GO TO 5
      IMINUS=II-1
C     INCLUDE THE TWO-CENTER REPULSION INTEGRALS.
      IF(IOP.GT.0) GO TO 41
      DO 400 JJ=1,IMINUS
      JA=NFIRST(JJ)
      JB=NLAST(JJ)
      IF(INTSUM.LE.LM9) GO TO 40
      NO=10**((IB-IA+JB-JA+2)/4)
      READ(NB2) (W(I),I=1,NO)
  40  CALL mtwoe (IA,IB,JA,JB,KR,F,P,W,LM4,LM9,qtp)
c      write(6,642)ii,jj,ia,ib,ja,jb,qtp
      ept(ii,jj)=ept(ii,jj)+qtp
      ept(jj,ii)=ept(ii,jj)
 645  format(1x,4i4,f20.10)
 642  format(1x,6i4,f20.10)
 400  ecoul=ecoul+qtp
      GO TO 5
   41 DO 42 JJ=1,IMINUS
      JA=NFIRST(JJ)
      JB=NLAST(JJ)
      IJ=(II*(II-1))/2+JJ
      WIJ=W(IJ)
      CALL twoen (IA,IB,JA,JB,F,P,WIJ,LM4,qpt)
      ecoul=ecoul+qpt
      ept(ii,jj)=ept(ii,jj)+qpt
  42  ept(jj,ii)=ept(ii,jj)
C     INCLUDE THE ONE-CENTER REPULSION INTEGRALS.
    5 NI=NAT(II)
      QII=0.
      DO 6 I=IA,IB
      K=(I*(I+1))/2
    6 QII=QII+P(K)
C     F(S,S)
      KA=(IA*(IA+1))/2
      F(KA)=F(KA)+0.5*P(KA)*GSS(NI)+(QII-P(KA))*(GSP(NI)-0.5*HSP(NI))
      IF(NI.LT.3) GO TO 9
      IPLUS=IA+1
      L=KA
      DO 7  J=IPLUS,IB
      M=L+IA
      L=L+J
C     F(P,P)
      F(L)=F(L)+0.5*P(L)*GPP(NI)+P(KA)*(GSP(NI)-0.5*HSP(NI))
     1         +(QII-P(L)-P(KA))*(GP2(NI)-0.5*HPP(NI))
C     F(S,P)
    7 F(M)=F(M)+0.5*P(M)*(3.0*HSP(NI)-GSP(NI))
C     F(P,P*)
      IMINUS=IB-1
      DO 8  J=IPLUS,IMINUS
      IC=J+1
      DO 8  L=IC,IB
      M=(L*(L-1))/2+J
    8 F(M)=F(M)+0.5*P(M)*(3.0*HPP(NI)-GP2(NI))
    9 CONTINUE
C *** CALCULATE THE ELECTRONIC ENERGY.
      CALL ESCF(EF,NORBS,P,F,LM4)
      CALL pESCF(EFx,NORBS,P,F,LM4)
c      kfut=1
c      do 232 i=1,norbs
c      lfut=kfut+i-1
c      write(6,6018)(f(ifut),ifut=kfut,lfut)
c      kfut=kfut+i
c 232  continue
      ex=ef-efx
      write(6,617) ex
      EE=ee+EFx+EHx+ ecoul
c      write(6,666)ecoul
 666  format(1x,'ecoul=', f20.10)
C *** HALF-ELECTRON CORRECTION
      IF(JODD.GT.0) GO TO 51
      IF(IODD.GT.0) GO TO 50
      GO TO 52
   50 CONTINUE
      fact=-0.25d0
      XI=pSPCG(C(1,IODD),C(1,IODD),C(1,IODD),C(1,IODD),W,LM2,LM9,fact)
      EE=EE-0.25*XI
      GO TO 52
   51 CONTINUE
      fact=-0.25d0
      XI=pSPCG(C(1,IODD),C(1,IODD),C(1,IODD),C(1,IODD),W,LM2,LM9,fact)
      XJ=pSPCG(C(1,JODD),C(1,JODD),C(1,JODD),C(1,JODD),W,LM2,LM9,fact)
      fact=-0.5d0
      IF(IMULT.EQ.1) fact=1.5d0
      XK=pSPCG(C(1,IODD),C(1,JODD),C(1,JODD),C(1,IODD),W,LM2,LM9,fact)
      EE=EE-0.25*(XI+XJ)-0.5*XK
      IF(IMULT.EQ.1) EE=EE+2.0*XK
   52 CONTINUE
      etot=0.d0
      do 101 i=1,numat
      do 101 j=1,i
 101  etot=etot+ept(i,j)
      write(6,667) etot
      write(8,667) etot
 667  format(1x, 'control total en.', f20.5, ' *****')
      write(6,610)ee
      write(8,610)ee
 610  format(1x, 'control elec. en.', f20.5, ' *****')
      write(6,611)enu
      write(8,611)enu
 611  format(1x, 'control nucl. en.', f20.5, ' *****')
      write(6,668)
      write(8,668)
 668  format(/,30x,' ENERGY PARTITIONING',//)
      if(kontrol.eq.97.or.kontrol.eq.98)goto 345
      call putvec(9,ept,limept)
 345  call mtprin(numat,6)
c      IF(KRESET.EQ.1) RETURN
c      VALUE =ATHEAT+23.061*(EE+ENUCLR-EAT)
c      EESAVE=EE
c      ENSAVE=ENUCLR
c      EPSAVE=-E(NUMB)
      RETURN
      END
      SUBROUTINE twoen (IA,IB,JA,JB,F,P,WIJ,LM4,qpt)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION F(LM4),P(LM4)
      QI=0.
      QJ=0.
      DO 10 I=IA,IB
      K=(I*(I+1))/2
   10 QI=QI+P(K)
      DO 20 J=JA,JB
      K=(J*(J+1))/2
   20 QJ=QJ+P(K)
      qpt=qi*qj*wij
      DO 50 I=IA,IB
      DO 50 J=JA,JB
      K=(I*(I-1))/2+J
   50 F(K)=F(K)-0.5*P(K)*WIJ
      RETURN
      END
      SUBROUTINE mtwoe(IA,IB,JA,JB,KR,F,P,W,LM4,LM9,qtp)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON
     ./FLAG4 / INTSUM
      DIMENSION F(LM4),P(LM4),W(LM9)
      qtp=0.d0
      xx=0.d0
      yy=0.d0
      KK=0
      IF(INTSUM.LE.LM9) KK=KR
      DO 4 I=IA,IB
      KA=(I*(I-1))/2
      DO 4 J=IA,I
      KB=(J*(J-1))/2
      IJ=KA+J
      AA=2.
      IF(I.EQ.J) AA=1.
      DO 4 K=JA,JB
      KC=(K*(K-1))/2
      IK=KA+K
      JK=KB+K
      DO 4 L=JA,K
      IL=KA+L
      JL=KB+L
      KL=KC+L
      BB=2.
      IF (K.EQ.L) BB=1.
      KK=KK+1
      A=W(KK)
c     qtp=qtp+p(IJ)*BB*A*P(KL)
      x=p(KL)*AA*A*P(IJ)*bb
c      write(6,66)i,j,k,l,x
 66   format(40x,4i3,'x=',f20.10)
      qtp=qtp+x
      xx=xx+x
      A=A*AA*BB*0.25
      y=-p(IK)*A*P(JL)-p(IL)*A*P(JK)
c      qtp=qtp-p(IK)*A*P(JL)
c      qtp=qtp-p(IL)*A*P(JK)
      qtp=qtp+y
      yy=yy+y
c      write(6,67)i,j,k,l,y
 67   format(42x,4i3,'y=',f20.10)
    4 CONTINUE
      KR=KK
c      write(6,65)xx,yy
 65   format(10x,'xx,yy',2f20.10)
      RETURN
      END
      SUBROUTINE pESCF (EE,N,P,F,LM4)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     $ /parti/ ept(50,50)
C     *
C     ELECTRONIC ENERGY.
C     *
      DIMENSION P(LM4),F(LM4)
      EE     = 0.d0
      k=1
      do 1 iat=1,numat
      if1=nfirst(iat)
      il1=nlast(iat)
      do 1 jat=1,iat
      if2=nfirst(jat)
      il2=nlast(jat)
      t=0.d0
      do 2 i=if1,il1
      if(iat.eq.jat) il2=i
      do 2 j=if2,il2
      ka=(i*(i-1))/2+j
      t=t+P(Ka)*F(Ka)
c      write(6,61) iat,jat,i,j,k,ka
 61   format(6i3)
  2   k=k+1
      ee=ee+t
      ept(iat,jat)=ept(iat,jat)+t
      ept(jat,iat)=ept(iat,jat)
  1   continue
c      KMAX   = (N*(N+1))/2
c      DO 10 K=1,KMAX
c   10 EE     = EE + P(K)*F(K)
c      DO 20 I=1,N
c      K      = (I*(I+1))/2
c   20 EE     = EE - 0.5*P(K)*F(K)
      do 11 iat=1,numat
      if1=nfirst(iat)
      il1=nlast(iat)
      t=0.d0
      DO 20 I=if1,il1
      K = (I*(I+1))/2
   20 t=t - 0.5*P(K)*F(K)
      EE   = EE+t
      ept(iat,iat)=ept(iat,iat)+t
  11  continue
      RETURN
      END
      SUBROUTINE MTPRIN(N,ifile)
       IMPLICIT REAL*8 (A-H,O-Z)
      COMMON /parti/ h(50,50)
      K=8
      NMIN=1
      NMAX=MIN0(N,K)
   62 FORMAT(1X,I2,1X,8F9.4)
   1  WRITE(ifile,61) (I,I=NMIN,NMAX)
   61 FORMAT(6X,10(3X,I2,4X))
      WRITE(ifile,64)
   64 FORMAT(/)
      DO 2 I=1,N
      WRITE(ifile,62)I,(H(I,J),J=NMIN,NMAX)
   2  CONTINUE
      NMIN=NMIN+8
      K=K+8
      NMAX=MIN0(N,K)
      IF(NMAX.GE.NMIN) GOTO 71
      RETURN
   71 WRITE(ifile,63)
   63 FORMAT(///)
      GO TO 1
      END
      SUBROUTINE pCORE(F,H,P,W,LM4,LM9)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     CORE HAMILTONIAN FOR MNDO: one-center and resonance terms
c       - to be used for energy partitioning
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./DENERG/ DENER
     ./ENERG / EE,ENUCLR,EAT,ATHEAT
     ./EXTRA / RI(22),CORE(4,2),T(5),X(3),Y(3),Z(3)
     ./FLAG3 / KRESET,IWADE
     ./FLAG4 / INTSUM
     ./NBFILE/ NB1,NB2,NB3,NB4
     ./ORBITS/ NUMB,NORBS
     ./PARDER/ TORE(18),EHEAT(18),EISOL(18)
     ./PAROPT/ USS(18),UPP(18),ZS(18),ZP(18),BETAS(18),BETAP(18),ALP(18)
     ./PASS1 / NI,NJ,R,GAM,NBOND,II
     ./SKIPA / IGRAD,ISKPA,NWSKP,QUADRS
     ./XDER  / COLD(3,50)
     $ /parti/ ept(50,50)
      DIMENSION F(LM4),H(LM4),P(LM4),W(LM9)
      DIMENSION DCL(3),DIF(3)
      LOGICAL QUADRS
C *** INITIALIZE SOME VARIABLES.
      LIN=(NORBS*(NORBS+1))/2
      IJUMP=0
      IF(ISKPA.EQ.0 .AND. KRESET.EQ.1) IJUMP=1
      DO 10 I=1,LIN
ccc      F(I)=0.
   10 H(I)=0.
      KR=0
      KS=0
c      ENUCLR=0.
c      TOLER =1.E-12
C     COMPUTE NUMBER OF REPULSION INTEGRALS.
      INTSUM=0
      IF(NUMAT.LE.1) GO TO 12
      DO 11 I=2,NUMAT
      INTA=NLAST(I)-NFIRST(I)+1
      IMINUS=I-1
      DO 11 J=1,IMINUS
      INTB=NLAST(J)-NFIRST(J)+1
   11 INTSUM=INTSUM+10**((INTA+INTB)/4)
      IF(IJUMP.EQ.0 .AND. INTSUM.GT.LM9) REWIND NB2
   12 CONTINUE
C *** ONE-CENTER TERMS.
      DO 80  I=1,NUMAT
      NI=NAT(I)
      IA=NFIRST(I)
      IB=NLAST(I)
      IF(IJUMP.EQ.1) GO TO 30
      LL=(IA*(IA+1))/2
      H(LL)=USS(NI)
      IF(NI.LT.3) GO TO 30
      IC=IA+1
      DO 20 J=IC,IB
      LL=(J*(J+1))/2
   20 H(LL)=UPP(NI)
C *** TWO-CENTER TERMS. - now only the resonance ones
   30 IMINUS=I-1
      IF(IMINUS.EQ.0) GO TO 80
      DO 70  J=1,IMINUS
      NJ=NAT(J)
      JA=NFIRST(J)
      JB=NLAST(J)
C     COMPUTE THE INTERATOMIC DISTANCE.
      X(1)= COORD(1,I)-COORD(1,J)
      X(2)= COORD(2,I)-COORD(2,J)
      X(3)= COORD(3,I)-COORD(3,J)
      Z(3)= X(1)*X(1)+X(2)*X(2)
      R= SQRT(X(3)*X(3)+Z(3))
C     CHECK FOR GRADIENT CALCULATION.
c      IF(IJUMP.EQ.0) GO TO 50
c      DO 40 K=1,3
c      DCL(K)=COLD(K,I)-COLD(K,J)
c      DIF(K)=X(K)-DCL(K)
c   40 DIF(K)=DIF(K)*DIF(K)
c      IF(DIF(1).GE.TOLER) GO TO 50
c      IF(DIF(2).GE.TOLER) GO TO 50
c      IF(DIF(3).LT.TOLER) GO TO 70
   50 CONTINUE
C     COMPUTE THE ROTATION MATRIX ELEMENTS TO CONVERT FROM LOCAL TO
C     MOLECULAR COORDINATES.
      CALL ROTMAT
      R=R/0.529167
C     COMPUTE THE CORE RESONANCE INTEGRALS.
      CALL BETAIJ(IA,JA,H,LM4)
Ccc     COMPUTE THE REPULSION INTEGRALS, AND CORE-ELECTRON ATTRACTIONS.
Ccc     INTEGRALS.
cccccc     CALL ROTATE (IA,IB,JA,JB,KR,H,W,LM4,LM9)
   60 CONTINUE
   70 CONTINUE
   80 CONTINUE
      RETURN
      END
      SUBROUTINE pROTAT(IA,IB,JA,JB,KR,H,W,LM4,LM9,p,qtp)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     TWO-centre one-electron coulomb contributions to the
c      energy
C     *
      COMMON
     ./EXTRA / RI(22),CORE(4,2),T(5),X(3),Y(3),Z(3)
     ./FLAG3 / KRESET,IWADE
     ./FLAG4 / INTSUM
     ./NBFILE/ NB1,NB2,NB3,NB4
     ./PASS1 / NI,NJ,R,GAM,NBOND,IIDUM
     ./SKIPA / IGRAD,ISKPA,NWSKP,QUADRS
      DIMENSION H(LM4),W(LM9),p(lm4)
      LOGICAL SI,SK
      LOGICAL QUADRS
C *** COMPUTE INTEGRALS IN LOCAL COORDINATES.
      qtp=0.d0
      CALL pREP (NI,NJ,R)
      GAM=RI(1)
      KI=0
      IF(INTSUM.LE.LM9) KI=KR
C *** BOTH ATOMS ARE FIRST-ROW ELEMENTS. NO NEED TO ROTATE COORDINATES.
      IF((NI.GT.2).OR.(NJ.GT.2)) GO TO 1
      I=(IA*(IA+1))/2
c      H(I)=H(I)-CORE(1,1)
      qtp=qtp-CORE(1,1)*p(i)/2.d0
      I=(JA*(JA+1))/2
c      H(I)=H(I)-CORE(1,2)
      qtp=qtp-CORE(1,2)*p(i)/2.d0
      KI=KI+1
      GO TO 18
  1   continue
C     *
C *** THE NUCLEAR ATTRACTION INTEGRALS CORE(KL,IJ) ARE STORED AS FOLLOWS
C     (SS/)=1,   (SO/)=2,   (OO/)=3,   (PP/)=4
C     WHERE IJ=1 IF THE ORBITALS CENTRED ON ATOM I,  =2 IF ON ATOM J.
C     *
      K=IA
      L=IB
      KK=1
   14 DO 17   I=K,L
      SI=I.GT.K
      II=I-K
      LL=(I*(I-1))/2
      DO 17   J=K,I
      M=LL+J
      IF(SI) GO TO 15
C     (S,S/)
      tp=-CORE(1,KK)*p(m)
      if(j.eq.i)tp=tp/2.d0
      qtp=qtp+tp
      GO TO 17
   15 JJ=J-K
      IF(JJ.GT.0) GO TO 16
C     (P,S/)
      tp=-X(II)*CORE(2,KK)*p(m)
      if(j.eq.i)tp=tp/2.d0
      qtp=qtp+tp
      GO TO 17
C     (P,P/)
   16 HTMP=-CORE(3,KK)*X(II)*X(JJ)-CORE(4,KK)*(Y(II)*Y(JJ)+Z(II)*Z(JJ))
      tp=HTMP*p(m)
      if(j.eq.i)tp=tp/2.d0
      qtp=qtp+tp
   17 CONTINUE
      KK=KK+1
      IF(KK.GT.2) GO TO 18
      K=JA
      L=JB
      GO TO 14
   18 KR=KI
      RETURN
      END
      SUBROUTINE pREP (NI,NJ,R)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON
     ./EXTRA / A(22),CORE(4,2),TXYZ(14)
     ./MULTIP/ DD(18),QQ(18),AA(18,3)
     ./OPTION/ IOP
     ./PARDER/ TORE(18),EHEAT(18),EISOL(18)
      PP=0.5
      P2=0.25
      P3=0.125
      P4=0.0625
c   Only parts necessary for energy partitioning are conserved
C     *
C *** THIS ROUTINE COMPUTES THE TWO-CENTRE REPULSION INTEGRALS AND THE
C *** NUCLEAR ATTRACTION INTEGRALS IN LOCAL COORDINATES.
C     *
C     THE TWO-CENTRE REPULSION INTEGRALS (OVER LOCAL COORDINATES) ARE
C     STORED AS FOLLOWS (WHERE P-SIGMA = O,  AND P-PI = P AND P* )
C     (SS/SS)=1,   (SO/SS)=2,   (OO/SS)=3,   (PP/SS)=4,   (SS/OS)=5,
C     (SO/SO)=6,   (SP/SP)=7,   (OO/SO)=8,   (PP/SO)=9,   (PO/SP)=10,
C     (SS/OO)=11,  (SS/PP)=12,  (SO/OO)=13,  (SO/PP)=14,  (SP/OP)=15,
C     (OO/OO)=16,  (PP/OO)=17,  (OO/PP)=18,  (PP/PP)=19,  (PO/PO)=20,
C     (PP/P*P*)=21,   (P*P/P*P)=22.
C     THE STORAGE OF THE NUCLEAR ATTRACTION INTEGRALS  CORE(KL/IJ) IS
C     (SS/)=1,   (SO/)=2,   (OO/)=3,   (PP/)=4
C     WHERE IJ=1 IF THE ORBITALS CENTRED ON ATOM I,  =2 IF ON ATOM J.
C     NI AND NJ ARE THE ATOMIC NUMBERS OF THE TWO ELEMENTS.
C     *
      DO 1  I=1,22
    1 A(I)=0.0
      DO 2  I=1,4
      CORE(I,1)=0.0
    2 CORE(I,2)=0.0
C     ATOMIC UNITS ARE USED IN THE CALCULATION
C     DEFINE CHARGE SEPARATIONS.
      DA=DD(NI)
      DB=DD(NJ)
      QA=QQ(NI)
      QB=QQ(NJ)
C     HYDROGEN - HYDROGEN
      AEE= (AA(NI,1)+AA(NJ,1))**2
      EE    = 1./SQRT(R**2+AEE)
      A(1)= EE*27.21
      CORE(1,1)= TORE(NJ)*A(1)
      CORE(1,2)= TORE(NI)*A(1)
      IF (NI .LT. 3 .AND. NJ .LT. 3) RETURN
      IF (NI .LT. 3) GO TO 3
C     HEAVY ATOM - HYDROGEN
      ADE= (AA(NI,2)+AA(NJ,1))**2
      AQE= (AA(NI,3)+AA(NJ,1))**2
      DZE   =-1./SQRT((R+DA)**2+ADE) + 1./SQRT((R-DA)**2+ADE)
      QZZE  = 1./SQRT((R-2.*QA)**2+AQE) - 2./SQRT(R**2+AQE)
     1       +1./SQRT((R+2.*QA)**2+AQE)
      QXXE  = 2./SQRT(R**2+4.*QA**2+AQE) - 2./SQRT(R**2+AQE)
      DZE   = DZE   *PP
      QXXE  = QXXE  *P2
      QZZE  = QZZE  *P2
      A(2) = -DZE
      A(3)=  EE + QZZE
      A(4)=  EE + QXXE
      IF (NJ .LT. 3) GO TO 100
C     HYDROGEN - HEAVY ATOM
    3 CONTINUE
      AED= (AA(NI,1)+AA(NJ,2))**2
      AEQ= (AA(NI,1)+AA(NJ,3))**2
      EDZ   =-1./SQRT((R-DB)**2+AED) + 1./SQRT((R+DB)**2+AED)
      EQZZ  = 1./SQRT((R-2.*QB)**2+AEQ) - 2./SQRT(R**2+AEQ)
     1       +1./SQRT((R+2.*QB)**2+AEQ)
      EQXX  = 2./SQRT(R**2+4.*QB**2+AEQ) - 2./SQRT(R**2+AEQ)
      EDZ   = EDZ   *PP
      EQXX  = EQXX  *P2
      EQZZ  = EQZZ  *P2
      A(5) = -EDZ
      A(11)= EE + EQZZ
      A(12)=  EE + EQXX
ccc      IF (NI .LT. 3) GO TO 100
C     HEAVY ATOM - HEAVY ATOM
  100 CONTINUE
C     CONVERT INTO EV.
      DO 110 I=2,22
  110 A(I)=A(I)*27.21
C     CALCULATE CORE-ELECTRON ATTRACTIONS.
      CORE(2,1)= TORE(NJ) * A(2)
      CORE(3,1)= TORE(NJ) * A(3)
      CORE(4,1)= TORE(NJ) * A(4)
      CORE(2,2)= TORE(NI) * A(5)
      CORE(3,2)= TORE(NI) * A(11)
      CORE(4,2)= TORE(NI) * A(12)
      RETURN
      END
      FUNCTION pSPCG(C1,C2,C3,C4,W,LM2,LM9,factor)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     SPCG CALCULATES THE REPULSION BETWEEN ELECTRON 1 IN MOLECULAR
C     ORBITALS C1,C2 AND ELECTRON 2 IN C3,C4 FOR THE VALENCE SHELL.
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./FLAG4 / INTSUM
     ./NBFILE/ NB1,NB2,NB3,NB4
     ./OPTION/ IOP
     ./REP   / GSS(18),GPP(18),GSP(18),GP2(18),HSP(18),HPP(18)
     $ /parti/ ept(50,50)
      DIMENSION C1(LM2),C2(LM2),C3(LM2),C4(LM2),W(LM9)
      pSPCG=0.
C *** TWO-CENTRE TERMS.
      IF(NUMAT.EQ.1) GO TO 2
      KK=0
      IF(IOP.LE.0 .AND. INTSUM.GT.LM9) REWIND NB2
      DO 9 II=2,NUMAT
      IA=NFIRST(II)
      IB=NLAST(II)
      IMINUS=II-1
      DO 10 JJ=1,IMINUS
      JA=NFIRST(JJ)
      JB=NLAST(JJ)
      tij=0.d0
C     MINDO, CNDO, INDO.
      IF(IOP.LE.0) GO TO 12
      IJ=(II*(II-1))/2+JJ
      DO 13 I=IA,IB
      DO 13 J=JA,JB
      tij=tij+W(IJ)*(C1(I)*C2(I)*C3(J)*C4(J)
     1                +C1(J)*C2(J)*C3(I)*C4(I))
   13 CONTINUE
      GO TO 110
C     MNDO.
   12 IF(INTSUM.LE.LM9) GO TO 15
      KK=0
      NO=10**((IB-IA+JB-JA+2)/4)
      READ(NB2) (W(I),I=1,NO)
   15 DO 11 I=IA,IB
      DO 11 J=IA,I
      DO 11 K=JA,JB
      DO 11 L=JA,K
      KK=KK+1
      tij=tij+W(KK)*(C1(I)*C2(J)*C3(K)*C4(L)
     1               + C1(K)*C2(L)*C3(I)*C4(J) )
      IF(I.NE.J) tij=tij+W(KK)*(C1(J)*C2(I)*C3(K)*C4(L)
     1                          + C1(K)*C2(L)*C3(J)*C4(I) )
      IF(K.NE.L) tij=tij+W(KK)*(C1(I)*C2(J)*C3(L)*C4(K)
     1                          + C1(L)*C2(K)*C3(I)*C4(J) )
      IF(I.NE.J .AND. K.NE.L) tij=tij+W(KK)*(C1(J)*C2(I)*C3(L)*C4(K)
     1                                       + C1(L)*C2(K)*C3(J)*C4(I))
   11 CONTINUE
 110  pspcg=pspcg+tij
      ept(ii,jj)=ept(ii,jj)+factor*tij
      ept(jj,ii)=ept(ii,jj)
   10 CONTINUE
    9 CONTINUE
    2 CONTINUE
C *** ONE-CENTRE TERMS.
      IS1=0
      DO 300 I1=1,NUMAT
      tii=0.d0
      IS1=IS1+1
      IZN=NAT(I1)
C     (SS/SS)
      tii=tii+C1(IS1)*C2(IS1)*C3(IS1)*C4(IS1)*GSS(IZN)
      IF(IZN.LT.3) GO TO 3
      IS=IS1
      IS1=IS1+1
      IX=IS1
      IS1=IS1+1
      IY=IS1
      IS1=IS1+1
      IZ=IS1
C     (PP/PP) FOR P=X,Y,Z
      tii=tii+GPP(IZN)*
     1  (C1(IX)*C2(IX)*C3(IX)*C4(IX)+
     2   C1(IY)*C2(IY)*C3(IY)*C4(IY)+
     3   C1(IZ)*C2(IZ)*C3(IZ)*C4(IZ) )
C     (SS/PP)+(PP/SS) FOR P=X,Y,Z
      tii=tii+GSP(IZN)*
     1  (C1(IS)*C2(IS)*C3(IX)*C4(IX)+
     2   C1(IS)*C2(IS)*C3(IY)*C4(IY)+
     3   C1(IS)*C2(IS)*C3(IZ)*C4(IZ)+
     4   C1(IX)*C2(IX)*C3(IS)*C4(IS)+
     5   C1(IY)*C2(IY)*C3(IS)*C4(IS)+
     6   C1(IZ)*C2(IZ)*C3(IS)*C4(IS) )
C     (PP/P,P,)+(P,P,/PP) FOR P.NE.P,=X,Y,Z
      tii=tii+GP2(IZN)*
     1  (C1(IX)*C2(IX)*C3(IY)*C4(IY)+
     2   C1(IX)*C2(IX)*C3(IZ)*C4(IZ)+
     3   C1(IY)*C2(IY)*C3(IZ)*C4(IZ)+
     4   C1(IY)*C2(IY)*C3(IX)*C4(IX)+
     5   C1(IZ)*C2(IZ)*C3(IX)*C4(IX)+
     6   C1(IZ)*C2(IZ)*C3(IY)*C4(IY) )
      TEMP1=HSP(IZN)
      DO 4 J1=IX,IZ
C     (SP/SP)+(SP/PS)+(PS/SP)+(PS/PS) FOR P=X,Y,Z
      tii=tii+TEMP1*
     1  (C1(IS)*C2(J1)*C3(J1)*C4(IS)+
     2   C1(IS)*C2(J1)*C3(IS)*C4(J1)+
     3   C1(J1)*C2(IS)*C3(IS)*C4(J1)+
     4   C1(J1)*C2(IS)*C3(J1)*C4(IS) )
    4 CONTINUE
      TEMP1=HPP(IZN)
      DO 5 J1=IX,IZ
      DO 6 K1=IX,IZ
      IF(J1.EQ.K1) GO TO 6
C     (PP,/PP,)+(PP,/P,P)+(P,P/PP,)+(P,P/P,P) FOR P.NE.P,=X,Y,Z
      tii=tii+TEMP1*
     1  (C1(J1)*C2(K1)*C3(J1)*C4(K1)+
     2   C1(J1)*C2(K1)*C3(K1)*C4(J1) )
    6 CONTINUE
    5 CONTINUE
    3 CONTINUE
      pspcg=pspcg+tii
      ept(i1,i1)=ept(i1,i1)+factor*tii
  300 CONTINUE
      RETURN
      END
