C     ******************************************************************
      SUBROUTINE MOINT2 (C,CC,C12,G,GG,W,WW,IMOCI,ITYPE,NSYM,LM2,LM3,
     1                   KMAX,LM7,LM8,LM9,LM10,NB2,NB3,IA,IB,JB,
     2                   IEN2,IOUT2,NNTOT)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     PARTIAL INTEGRAL TRANSFORMATION.
C     *
      DIMENSION C(LM2,LM3),CC(LM7),W(LM9)
      DIMENSION IMOCI(LM3),ITYPE(8,8),NSYM(LM3)
      DIMENSION C12(KMAX),WW(KMAX)
      DIMENSION G(LM8),GG(LM10,LM10)
      DATA ZERO/0.E0/,ONE/1.E0/,EV/27.21E0/
      REV =ONE/EV
      LMAX=LM7/KMAX
      JMAX=LM8/KMAX
      IF(JMAX.GT.JB) JMAX=JB
C     *
C     COMPUTE (IJ,KL) INTEGRALS.
C     *
      NN=0
      NNTOT=0
C     OUTER IJ-LOOP.
      DO 100 I=IA,IB
      II=IMOCI(I)
      IS=NSYM(II)
C     COMPUTE JMAX SETS OF (IJ,AB) INTEGRALS.
      MM=1-KMAX
      DO 110 J=1,JMAX
      IJ=IMOCI(J)
      MM=MM+KMAX
      CALL CCPROD (C(1,II),C(1,IJ),C12,LM2,KMAX)
  110 CALL WWSTEP (C12,CC,G(MM),LM7,NB3,KMAX,LMAX)
C     RESUME IJ-LOOP.
      DO 100 J=1,JB
      IJ=IMOCI(J)
      JS=NSYM(IJ)
      NSIJ=ITYPE(IS,JS)
C     INNER KL-LOOP.
      DO 100 K=IA,I
      IK=IMOCI(K)
      KS=NSYM(IK)
      DO 100 L=1,J
      IL=IMOCI(L)
      LS=NSYM(IL)
      NSKL=ITYPE(KS,LS)
      IF(NSIJ.NE.NSKL) GO TO 100
C     COMPUTE INTEGRAL (IJ,KL).
      NN=NN+1
      IF(NN.LE.LM9) GO TO 150
      IF(NNTOT.EQ.0) REWIND NB2
      WRITE(NB2) W
      NNTOT=NNTOT+LM9
      NN=1
  150 IF(J.GT.JMAX) GO TO 160
      MM=1+KMAX*(J-1)
      CALL CCPROD (C(1,IK),C(1,IL),C12,LM2,KMAX)
      WNN = SISMS (C12,G(MM),KMAX)
      GO TO 170
  160 CALL CCPROD (C(1,II),C(1,IJ),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      CALL CCPROD (C(1,IK),C(1,IL),C12,LM2,KMAX)
      WNN = SISMS (C12,WW,KMAX)
  170 W(NN)=WNN*REV
      IF(I.EQ.K .OR. J.EQ.L) GO TO 100
C     COMPUTE INTEGRAL (IL,KJ).
      NN=NN+1
      IF(NN.LE.LM9) GO TO 180
      IF(NNTOT.EQ.0) REWIND NB2
      WRITE(NB2) W
      NNTOT=NNTOT+LM9
      NN=1
  180 IF(L.GT.JMAX) GO TO 190
      MM=1+KMAX*(L-1)
      CALL CCPROD (C(1,IK),C(1,IJ),C12,LM2,KMAX)
      WNN = SISMS (C12,G(MM),KMAX)
      GO TO 200
  190 CALL CCPROD (C(1,II),C(1,IL),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      CALL CCPROD (C(1,IK),C(1,IJ),C12,LM2,KMAX)
      WNN = SISMS (C12,WW,KMAX)
  200 W(NN)=WNN*REV
  100 CONTINUE
C     NUMBER OF NONZERO INTEGRALS.
      NNTOT=NNTOT+NN
      IF(NNTOT.GT.LM9) WRITE(NB2) W
      IF(IOUT2.GE.0) WRITE(6,210) NNTOT
  210 FORMAT(/1X,'THERE ARE',I7,' NONZERO MATRIX ELEMENTS.'/)
      LREC=1+(NNTOT-1)/LM9
      IF(IOUT2.GE.4 .AND. LREC.GT.1) WRITE(6,220) NB2,LREC,LM9
  220 FORMAT( 1X,'THEY ARE STORED ON FILE',I3,' IN',I4,' RECORDS OF',
     1  I5,' WORDS.'/)
C     *
C     COMPUTE COULOMB AND EXCHANGE INTEGRALS.
C     *
      DO 250 I=1,IB
      DO 250 J=1,IB
  250 GG(J,I)=ZERO
      IF(IEN2.EQ.0) RETURN
C     COULOMB INTEGRALS (II,JJ).
      DO 300 I=1,IB
      II=IMOCI(I)
      CALL CCPROD (C(1,II),C(1,II),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      DO 300 J=1,I
      IJ=IMOCI(J)
      CALL CCPROD (C(1,IJ),C(1,IJ),C12,LM2,KMAX)
      WNN = SISMS (C12,WW,KMAX)
  300 GG(I,J)=WNN*REV
C     EXCHANGE INTEGRALS (IJ,IJ) NOT YET COMPUTED.
      IF(IB.EQ.1) RETURN
      DO 310 I=2,IB
      II=IMOCI(I)
      IMINUS=I-1
      DO 310 J=1,IMINUS
      IF(I.GE.IA .AND. J.LE.JB) GO TO 310
      IJ=IMOCI(J)
      CALL CCPROD (C(1,II),C(1,IJ),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      WNN = SISMS (C12,WW,KMAX)
      GG(J,I)=WNN*REV
  310 CONTINUE
C     EXCHANGE INTEGRALS (IJ,IJ) ALREADY COMPUTED.
      IF(NNTOT.LE.LM9) GO TO 340
      REWIND NB2
      READ(NB2) W
  340 NN=0
      DO 350 I=IA,IB
      II=IMOCI(I)
      IS=NSYM(II)
      DO 350 J=1,JB
      IJ=IMOCI(J)
      JS=NSYM(IJ)
      NSIJ=ITYPE(IS,JS)
      DO 350 K=IA,I
      IK=IMOCI(K)
      KS=NSYM(IK)
      DO 350 L=1,J
      IL=IMOCI(L)
      LS=NSYM(IL)
      NSKL=ITYPE(KS,LS)
      IF(NSIJ.NE.NSKL) GO TO 350
      NN=NN+1
      IF(NN.LE.LM9) GO TO 360
      READ(NB2) W
      NN=1
  360 IF(I.EQ.K .AND. J.EQ.L) GG(J,I)=W(NN)
      IF(I.EQ.K .OR.  J.EQ.L) GO TO 350
      NN=NN+1
      IF(NN.LE.LM9) GO TO 350
      READ(NB2) W
      NN=1
  350 CONTINUE
      RETURN
      END
C     ******************************************************************
      SUBROUTINE CCPROD (C1,C2,C12,LM2,LM6)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     PRODUCTS OF COEFFICIENTS.
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(150)
     ./OPTION/ IOP
      DIMENSION C1(LM2),C2(LM2),C12(LM6)
      IF(IOP.EQ.2) GO TO 30
C     MNDO,MINDO,INDO.
      KK=0
      DO 10 II=1,NUMAT
      IA=NFIRST(II)
      IB=NLAST(II)
      KK=KK+1
      C12(KK)=C1(IA)*C2(IA)
      IF(IA.EQ.IB) GO TO 10
      CS1  = C1(IA)
      CPX1 = C1(IA+1)
      CPY1 = C1(IA+2)
      CPZ1 = C1(IA+3)
      CS2  = C2(IA)
      CPX2 = C2(IA+1)
      CPY2 = C2(IA+2)
      CPZ2 = C2(IA+3)
      C12(KK+1) = CPX1*CS2  + CPX2*CS1
      C12(KK+2) = CPX1*CPX2
      C12(KK+3) = CPY1*CS2  + CPY2*CS1
      C12(KK+4) = CPY1*CPX2 + CPY2*CPX1
      C12(KK+5) = CPY1*CPY2
      C12(KK+6) = CPZ1*CS2  + CPZ2*CS1
      C12(KK+7) = CPZ1*CPX2 + CPZ2*CPX1
      C12(KK+8) = CPZ1*CPY2 + CPZ2*CPY1
      C12(KK+9) = CPZ1*CPZ2
      KK = KK+9
   10 CONTINUE
      RETURN
C     CNDO.
   30 DO 40 II=1,NUMAT
      IA=NFIRST(II)
      IB=NLAST(II)
      CC=0.
      DO 50 I=IA,IB
   50 CC=CC+C1(I)*C2(I)
   40 C12(II)=CC
      RETURN
      END
C     ******************************************************************
      SUBROUTINE WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     CALCULATION OF A SET OF (IJ,AB) INTEGRALS.
C     *
      DIMENSION C12(KMAX),CC(LM7),WW(KMAX)
      IF(KMAX.GT.LMAX) GO TO 20
C     AO INTEGRALS IN CC(LM7).
      KK=1-KMAX
      DO 10 NN=1,KMAX
      KK=KK+KMAX
   10 WW(NN) = SISMS (C12,CC(KK),KMAX)
      RETURN
C     AO INTEGRALS ON FILE NB3.
   20 REWIND NB3
      READ(NB3) CC
      KK=1-KMAX
      LL=0
      DO 40 NN=1,KMAX
      LL=LL+1
      IF(LL.LE.LMAX) GO TO 30
      READ(NB3) CC
      KK=1-KMAX
      LL=1
   30 KK=KK+KMAX
   40 WW(NN) = SISMS (C12,CC(KK),KMAX)
      RETURN
      END
C     ******************************************************************
      FUNCTION SISMS (C12,CC,LM6)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     SCALAR PRODUCT.
C     *
      DIMENSION C12(LM6),CC(LM6)
      SISMS=0.
      DO 10 I=1,LM6
   10 SISMS=SISMS+C12(I)*CC(I)
      RETURN
      END
C     ******************************************************************
      SUBROUTINE MPEN (E2,EIG,G,W,IMOCI,ITYPE,NSYM,LM3,LM9,LM10,NB2,
     1                 IA,IB,JB,IOUT2,NNTOT)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     PERTURBATION TREATMENT WITH ONE MAIN CONFIGURATION.
C     *
      COMMON
     ./CIFLAG/ ICJUMP(6),IPERT(4)
      DIMENSION EIG(LM3),G(LM10,LM10),W(LM9)
      DIMENSION IMOCI(LM3),ITYPE(8,8),NSYM(LM3)
      DIMENSION NAME(4)
      LOGICAL DEBUG
      DATA NAME/4HRSMP,4HRSEN,4HBWMP,4HBWEN/
      DATA ZERO/0.E0/,ONE/1.E0/,TWO/2.E0/,THREE/3.E0/
      DATA HALF/0.5E0/,ONE5/1.5E0/
      DATA EV/27.21E0/,CAL/23.061E0/
      DATA EBWLIM/1.E-08/
C *** INITIALIZE ENERGIES.
      E2=ZERO
      EB=ZERO
      EC=ZERO
      IF(IOUT2.GE.4) WRITE(6,620)
C *** LOOP OVER OPTIONS.
      DO 100 IOP=1,4
      JOP=IPERT(IOP)
      IF(JOP.EQ.0) GO TO 100
      EBW=ZERO
      IBW=0
   20 IBW=IBW+1
      DEBUG = IOUT2.GE.4 .AND. IBW.EQ.1
      IF(DEBUG) WRITE(6,650)
C     READ INTEGRALS.
      IF(NNTOT.GT.LM9) REWIND NB2
      IF(NNTOT.GT.LM9) READ(NB2) W
C *** COMPUTE THE SECOND-ORDER ENERGIES.
      KK=0
      CC=ZERO
      CCSUM=ZERO
      EESUM=ZERO
C     OUTER IJ-LOOP.
      DO 80 I=IA,IB
      II=IMOCI(I)
      IS=NSYM(II)
      DI=EIG(II)
      DO 80 J=1,JB
      IJ=IMOCI(J)
      JS=NSYM(IJ)
      NSIJ=ITYPE(IS,JS)
      DIJ=DI-EIG(IJ)
      GIJ=G(I,J)
      GJI=G(J,I)
C     INNER KL-LOOP.
      DO 80 K=IA,I
      IK=IMOCI(K)
      KS=NSYM(IK)
      DIJK=DIJ+EIG(IK)
      GIK=G(I,K)
      GJK=G(J,K)
      GKI=G(K,I)
      GKJ=G(K,J)
      DO 80 L=1,J
      IL=IMOCI(L)
      LS=NSYM(IL)
      NSKL=ITYPE(KS,LS)
      IF(NSIJ.NE.NSKL) GO TO 80
      GIL=G(I,L)
      GJL=G(J,L)
      GKL=G(K,L)
      GLI=G(L,I)
      GLJ=G(L,J)
      GLK=G(L,K)
C     INTEGRALS B1 AND B2.
      KK=KK+1
      IF(KK.GT.LM9) READ(NB2) W
      IF(KK.GT.LM9) KK=1
      B1=W(KK)
      BA=B1*B1
      IF(I.EQ.K .OR. J.EQ.L) GO TO 30
      KK=KK+1
      IF(KK.GT.LM9) READ(NB2) W
      IF(KK.GT.LM9) KK=1
      B2=W(KK)
      BB=B2*B2
      BM=(B1-B2)**2
C     ENERGY DENOMINATOR.
   30 DIJKL=DIJK-EIG(IL)
      GO TO (40,60,40,60),IOP
C     MP TREATMENT.
   40 EA=DIJKL-EBW
      EE=-BA/EA
      IF(I.GT.K .OR. J.GT.L) EE=EE*TWO
      IF(I.EQ.K .OR. J.EQ.L) GO TO 70
      EE=EE-TWO*(BB+BM)/EA
      GO TO 70
C     EN TREATMENT.
   60 E0=DIJKL+GIK+GJL-GIJ-GIL-GKJ-GKL-EBW
      IF(I.GT.K .AND. J.GT.L) GO TO 65
      EA=E0+GJI+GLK
      IF(I.GT.K) EA=EA+GKI
      IF(J.GT.L) EA=EA+GLJ
      EE=-BA/EA
      IF(I.GT.K .OR. J.GT.L) EE=EE*TWO
      CC=-EE/EA
      GO TO 70
   65 GS=GJI+GLI+GJK+GLK
      EA=E0+GKI+GLJ+HALF*GS
      EB=E0-GKI-GLJ+ONE5*GS
      BP=(B1+B2)**2
      EE=-BP/EA-THREE*BM/EB
      CC=BP/EA**2+THREE*BM/EB**2
C     SUMMATION.
   70 EESUM=EESUM+EE
      CCSUM=CCSUM+CC
C     DEBUG PRINTING.
      IF(.NOT.DEBUG) GO TO 80
      IF(I.GT.K .AND. J.GT.L) GO TO 75
      B2=ZERO
      EB=ZERO
      EC=ZERO
   75 WRITE(6,630) II,IJ,IK,IL,B1,B2,EA,EB,EC,EE,CC
   80 CONTINUE
      IF(IOP.LT.3) GO TO 90
C *** BW TREATMENT.
      IF(IOUT2.LT.0) GO TO 85
      IF(IBW.EQ.1) WRITE(6,650)
      WRITE(6,710) IBW,EESUM
   85 IF(DABS(EESUM-EBW).LT.EBWLIM) GO TO 90
      EBW=EESUM
      GO TO 20
C *** PRINT THE RESULTS.
   90 EEV=EESUM*EV
      EKCAL=EEV*CAL
      IF(IOUT2.GT.-5) WRITE(6,510) EESUM,EEV,EKCAL,NAME(IOP)
      IF(JOP.GT.0) E2=EEV
C *** DAVIDSON CORRECTION FOR IOP=4.
      IF(IOP.NE.4 .OR. IOUT2.LE.-5) GO TO 100
      CC0   = ONE/(ONE+CCSUM)
      CCD   = ONE-CC0
      C0    = DSQRT(CC0)
      EDSUM = CCD*EESUM
      EDEV  = CCD*EEV
      EDCAL = CCD*EKCAL
      WRITE(6,520) EDSUM,EDEV,EDCAL,NAME(IOP)
      WRITE(6,530) C0,CC0
  100 CONTINUE
      IF(NNTOT.GT.LM9) CALL CLODA(NB2)
      RETURN
  510 FORMAT (/ 1X,'SECOND-ORDER ENERGY =',F12.7,' A.U.=',F12.7,' EV=',
     1             F12.7,' KCAL/MOLE',10X,'OPTION=',A4)
  520 FORMAT (/ 1X,'DAVIDSON CORRECTION =',F12.7,' A.U.=',F12.7,' EV=',
     1             F12.7,' KCAL/MOLE',10X,'OPTION=',A4)
  530 FORMAT (/ 1X,'COEFFICIENT OF SCF CONFIGURATION       ',F12.7/
     1          1X,'SQUARE OF COEFFICIENT                  ',F12.7)
  620 FORMAT (//1X,'DEBUG PRINT FOR SECOND-ORDER TERMS.'//
     1          1X,'  II  IJ  IK  IL',5X,'B1',10X,'B2',10X,'EA',
     2         10X,'EB',10X,'EC',10X,'EE',10X,'CC')
  630 FORMAT (  1X,4I4,8F12.7)
  650 FORMAT (  1X)
  710 FORMAT (  1X,'CYCLE',I3, 5X,'ENERGY =',F12.7,' A.U.')
      END
C     ******************************************************************
      SUBROUTINE MINICI (C,CC,C12,EIG,WW,LM2,LM3,KMAX,LM7,NB3,IOUT2,
     1                   CA,CB,DELT,KK,LL)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     MINIMAL CONFIGURATION INTERACTION.
C     *
      DIMENSION C(LM2,LM3),CC(LM7),EIG(LM3)
      DIMENSION C12(KMAX),WW(KMAX)
      DATA ONE/1.E0/,TWO/2.E0/,FOUR/4.E0/
      DATA HALF/0.5E0/,EV/27.21E0/
      CALL WINT (KK,KK,KK,KK,GKK,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      CALL WINT (LL,LL,LL,LL,GLL,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      CALL WINT (KK,KK,LL,LL,GLK,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      CALL WINT (KK,LL,KK,LL,GKL,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      REV  = ONE/EV
      GKK  = GKK*REV
      GLL  = GLL*REV
      GLK  = GLK*REV
      GKL  = GKL*REV
      DIFF = TWO*EIG(LL)-TWO*EIG(KK)+GKK+GLL-FOUR*GLK+TWO*GKL
      BET2 = GKL*GKL
      DELT =-HALF*(DIFF-DSQRT(DIFF**2+FOUR*BET2))
      DELL =-DELT
      DEL2 = DELT*DELT
      DENO = DEL2+BET2
      CA   = DSQRT(BET2/DENO)
      CB   =-DSQRT(DEL2/DENO)
      IF(IOUT2.GE.4) WRITE(6,500) KK,LL,DIFF,GKL,DELL,CA,CB
      RETURN
  500 FORMAT (///1X,'MINIMAL CI TREATMENT INVOLVING MOS',2I5//
     1  1X,'ENERGY OF SECOND CONFIGURATION',F12.7,'  A.U.'/
     2  1X,'MATRIX ELEMENT                ',F12.7,'  A.U.'/
     3  1X,'ENERGY OF LOWEST CI ROOT      ',F12.7,'  A.U.'/
     4  1X,'CI COEFFICIENTS               ',2F12.7)
      END
C     ******************************************************************
      SUBROUTINE WINT (I,J,K,L,W,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     CALCULATION OF A SINGLE INTEGRAL (IJ,KL).
C     *
      DIMENSION C(LM2,LM3),CC(LM7),C12(KMAX),WW(KMAX)
      LMAX=LM7/KMAX
      CALL CCPROD (C(1,I),C(1,J),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      CALL CCPROD (C(1,K),C(1,L),C12,LM2,KMAX)
      W=SISMS(C12,WW,KMAX)
      RETURN
      END
C     ******************************************************************
      SUBROUTINE MOINT3 (C,CC,C12,G,GG,W,WW,IMOCI,ITYPE,NSYM,LM2,LM3,
     1                   KMAX,LM7,LM8,LM9,LM10,NB2,NB3,IA,IB,JB,IEN2,
     2                   IOUT2,NNTOT,CA,CB,KK,LL,IABSCI)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     PARTIAL INTEGRAL TRANSFORMATION.
C     *
      DIMENSION C(LM2,LM3),CC(LM7),W(LM9)
      DIMENSION IMOCI(LM3),ITYPE(8,8),NSYM(LM3)
      DIMENSION C12(KMAX),WW(KMAX)
      DIMENSION G(LM8),GG(LM10,LM10)
      DATA ZERO/0.E0/,ONE/1.E0/,TWO/2.E0/,THREE/3.E0/
      DATA EV/27.21E0/
C     INITIALIZATION.
      REV =ONE/EV
      SQ2 =DSQRT(TWO)
      SQ3 =DSQRT(THREE)
      LMAX=LM7/KMAX
      KKS=NSYM(KK)
      LLS=NSYM(LL)
      NN=0
      NNTOT=0
C     *
C     MATRIX ELEMENTS FOR SINGLE EXCITATIONS.
C     *
      CALL CCPROD (C(1,KK),C(1,LL),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      DO 50 I=1,IB
      II=IMOCI(I)
      IF(II.EQ.LL) GO TO 50
      IS=NSYM(II)
      NSIK=ITYPE(IS,KKS)
      NSIL=ITYPE(IS,LLS)
      IF(NSIK.NE.1 .AND. I.GE.IA) GO TO 50
      IF(NSIL.NE.1 .AND. I.LT.IA) GO TO 50
      IF(I.GE.IA) GO TO 70
C     MO I IS OCCUPIED.
      CALL CCPROD (C(1,KK),C(1,II),C12,LM2,KMAX)
      WNN=-SISMS(C12,WW,KMAX)
      IF(II.NE.KK) GO TO 60
      CALL CCPROD (C(1,LL),C(1,LL),C12,LM2,KMAX)
      WNN=-WNN-SISMS(C12,WW,KMAX)
      GO TO 60
C     MO I IS UNOCCUPIED.
   70 CALL CCPROD (C(1,LL),C(1,II),C12,LM2,KMAX)
      WNN=SISMS(C12,WW,KMAX)
C     STORE THE MATRIX ELEMENT COMPUTED.
   60 NN=NN+1
      W(NN)=CB*SQ2*WNN*REV
   50 CONTINUE
C     *
C     MATRIX ELEMENTS FOR DOUBLE EXCITATIONS.
C     *
      JMAX=LM8/KMAX
      IF(JMAX.GT.JB) JMAX=JB
C     OUTER IJ-LOOP.
      DO 100 I=IA,IB
      II=IMOCI(I)
      IS=NSYM(II)
C     COMPUTE JMAX SETS OF (IJ,AB) INTEGRALS.
      MM=1-KMAX
      DO 110 J=1,JMAX
      IJ=IMOCI(J)
      MM=MM+KMAX
      CALL CCPROD (C(1,II),C(1,IJ),C12,LM2,KMAX)
  110 CALL WWSTEP (C12,CC,G(MM),LM7,NB3,KMAX,LMAX)
C     RESUME IJ-LOOP.
      DO 100 J=1,JB
      IJ=IMOCI(J)
      JS=NSYM(IJ)
      NSIJ=ITYPE(IS,JS)
C     INNER KL-LOOP.
      DO 100 K=IA,I
      IK=IMOCI(K)
      KS=NSYM(IK)
      IEQK=0
      IF(I.GT.K) IEQK=1
      DO 100 L=1,J
      IL=IMOCI(L)
      LS=NSYM(IL)
      NSKL=ITYPE(KS,LS)
      IF(NSIJ.NE.NSKL) GO TO 100
      IF(II.EQ.LL .AND. IJ.EQ.KK .AND. IK.EQ.LL .AND. IL.EQ.KK) GOTO 100
      JEQL=0
      IF(J.GT.L) JEQL=1
      IGO=1+IEQK+2*JEQL
      IGOGO=0
C     COMPUTE INTEGRAL (IJ,KL), I.E. (IU,JV) IN NOTES.
      IF(J.GT.JMAX) GO TO 160
      MM=1+KMAX*(J-1)
      CALL CCPROD (C(1,IK),C(1,IL),C12,LM2,KMAX)
      WN1 = SISMS (C12,G(MM),KMAX)
      GO TO 170
  160 CALL CCPROD (C(1,II),C(1,IJ),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      CALL CCPROD (C(1,IK),C(1,IL),C12,LM2,KMAX)
      WN1 = SISMS (C12,WW,KMAX)
  170 CONTINUE
      IF(I.EQ.K .OR. J.EQ.L) GO TO 200
C     COMPUTE INTEGRAL (IL,KJ), I.E. (IV,JU) IN NOTES.
      IF(L.GT.JMAX) GO TO 190
      MM=1+KMAX*(L-1)
      CALL CCPROD (C(1,IK),C(1,IJ),C12,LM2,KMAX)
      WN2 = SISMS (C12,G(MM),KMAX)
      GO TO 200
  190 CALL CCPROD (C(1,II),C(1,IL),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      CALL CCPROD (C(1,IK),C(1,IJ),C12,LM2,KMAX)
      WN2 = SISMS (C12,WW,KMAX)
  200 CONTINUE
      GO TO (210,220,230,240),IGO
C     EXCITATIONS J,J-I,I.
  210 WNN=CA*WN1
      IF(II.NE.LL .AND. IJ.NE.KK) GO TO 250
      IF(II.NE.LL) GO TO 211
      CALL WINT (IJ,KK,IJ,KK,WN3,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      WNN=WNN+CB*WN3
      GO TO 250
  211 CALL WINT (LL,II,LL,II,WN3,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      WNN=WNN+CB*WN3
      GO TO 250
C     EXCITATIONS J,J-I,K.
  220 WNN=CA*SQ2*WN1
      IF(IJ.NE.KK) GO TO 250
      IF(II.EQ.LL .OR. IK.EQ.LL) GO TO 221
      CALL WINT (LL,II,LL,IK,WN3,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      WNN=WNN+CB*SQ2*WN3
      GO TO 250
  221 CALL WINT (LL,LL,II,IK,WN3,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      CALL WINT (KK,KK,II,IK,WN4,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      WNN=WNN+CB*SQ2*(WN1+WN3-TWO*WN4)
      GO TO 250
C     EXCITATIONS J,L-I,I.
  230 WNN=-CA*SQ2*WN1
      IF(II.NE.LL) GO TO 250
      IF(IJ.EQ.KK .OR. IL.EQ.KK) GO TO 231
      CALL WINT (IJ,KK,IL,KK,WN3,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      WNN=WNN-CB*SQ2*WN3
      GO TO 250
  231 CALL WINT (KK,KK,IJ,IL,WN3,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      CALL WINT (LL,LL,IJ,IL,WN4,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      WNN=WNN-CB*SQ2*(WN1+WN3-TWO*WN4)
      GO TO 250
C     EXCITATIONS J,L-I,K.
C     NOTE. WN1 IS (IU,KL), WN2 IS (IK,LU) IN NOTES.
  240 WNN=-CA*(WN2+WN1)
      IGOGO=1
      IF(IJ.NE.KK .AND. IL.NE.KK) GO TO 250
      IF(II.NE.LL .AND. IK.NE.LL) GO TO 250
      CALL WINT (IJ,IL,II,IK,WN3,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      WNN=WNN-CB*(WN1-TWO*WN3)
      GO TO 250
  245 WNN=CA*SQ3*(WN2-WN1)
      IGOGO=0
      IF(IJ.NE.KK .AND. IL.NE.KK) GO TO 250
      IF(II.NE.LL .AND. IK.NE.LL) GO TO 250
      WNN=WNN-CB*SQ3*WN1
C     STORE THE MATRIX ELEMENT COMPUTED.
  250 NN=NN+1
      IF(NN.LE.LM9) GO TO 260
      IF(NNTOT.EQ.0) REWIND NB2
      WRITE(NB2) W
      NNTOT=NNTOT+LM9
      NN=1
  260 W(NN)=WNN*REV
      IF(IGOGO.EQ.1) GO TO 245
  100 CONTINUE
      IF(IABSCI.EQ.3) GO TO 540
C     *
C     MATRIX ELEMENTS FOR TRIPLE EXCITATIONS.
C     *
C *** FIRST SUM. TYPES 8B,9,10.
      JMAX=LM8/KMAX+IA-1
      IF(JMAX.GT.IB) JMAX=IB
C     COMPUTE JMAX SETS OF (IJ,AB) INTEGRALS.
      MM=1-KMAX
      DO 290 J=IA,JMAX
      IJ=IMOCI(J)
      MM=MM+KMAX
      IF(IJ.EQ.LL) GO TO 290
      CALL CCPROD (C(1,LL),C(1,IJ),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,G(MM),LM7,NB3,KMAX,LMAX)
  290 CONTINUE
C     START THE LOOP.
      DO 300 I=1,JB
      II=IMOCI(I)
      IF(II.EQ.KK) GO TO 300
      IS=NSYM(II)
      NSILL=ITYPE(IS,LLS)
      DO 310 J=IA,IB
      IJ=IMOCI(J)
      IF(IJ.EQ.LL) GO TO 310
      JS=NSYM(IJ)
      DO 320 K=IA,J
      IK=IMOCI(K)
      IF(IK.EQ.LL) GO TO 320
      KS=NSYM(IK)
      NSJK=ITYPE(JS,KS)
      IF(NSILL.NE.NSJK) GO TO 320
C     COMPUTE FIRST INTEGRAL, I.E. (IU,LV) IN NOTES.
      IF(J.GT.JMAX) GO TO 330
      MM=1+KMAX*(J-IA)
      CALL CCPROD (C(1,II),C(1,IK),C12,LM2,KMAX)
      WN1 = SISMS (C12,G(MM),KMAX)
      GO TO 335
  330 CALL CCPROD (C(1,LL),C(1,IJ),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      CALL CCPROD (C(1,II),C(1,IK),C12,LM2,KMAX)
      WN1 = SISMS (C12,WW,KMAX)
  335 CONTINUE
      IF(J.EQ.K) GO TO 345
C     COMPUTE SECOND INTEGRAL, I.E. (IV,LU) IN NOTES.
      IF(K.GT.JMAX) GO TO 340
      MM=1+KMAX*(K-IA)
      CALL CCPROD (C(1,II),C(1,IJ),C12,LM2,KMAX)
      WN2 = SISMS (C12,G(MM),KMAX)
      GO TO 345
  340 CALL CCPROD (C(1,LL),C(1,IK),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      CALL CCPROD (C(1,II),C(1,IJ),C12,LM2,KMAX)
      WN2 = SISMS (C12,WW,KMAX)
  345 CONTINUE
      IGOGO=0
      IF(J.GT.K) GO TO 350
C     EXCITATIONS I,KMO,KMO-J,J,LMO.
      WNN=-CB*SQ2*WN1
      GO TO 370
C     EXCITATIONS I,KMO,KMO-J,K,LMO.
  350 WNN=-CB*(WN2+WN1)
      IGOGO=1
      GO TO 370
  360 WNN=CB*SQ3*(WN2-WN1)
      IGOGO=0
C     STORE THE MATRIX ELEMENT COMPUTED.
  370 NN=NN+1
      IF(NN.LE.LM9) GO TO 380
      IF(NNTOT.EQ.0) REWIND NB2
      WRITE(NB2) W
      NNTOT=NNTOT+LM9
      NN=1
  380 W(NN)=WNN*REV
      IF(IGOGO.EQ.1) GO TO 360
  320 CONTINUE
  310 CONTINUE
  300 CONTINUE
C *** SECOND SUM. TYPES 8A,12,13.
      JMAX=LM8/KMAX
      IF(JMAX.GT.JB) JMAX=JB
C     COMPUTE JMAX SETS OF (IJ,AB) INTEGRALS.
      MM=1-KMAX
      DO 390 J=1,JMAX
      IJ=IMOCI(J)
      MM=MM+KMAX
      IF(IJ.EQ.KK) GO TO 390
      CALL CCPROD (C(1,KK),C(1,IJ),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,G(MM),LM7,NB3,KMAX,LMAX)
  390 CONTINUE
C     START THE LOOP.
      DO 400 I=IA,IB
      II=IMOCI(I)
      IF(II.EQ.LL) GO TO 400
      IS=NSYM(II)
      NSIKK=ITYPE(IS,KKS)
      DO 410 J=1,JB
      IJ=IMOCI(J)
      IF(IJ.EQ.KK) GO TO 410
      JS=NSYM(IJ)
      DO 420 K=1,J
      IK=IMOCI(K)
      IF(IK.EQ.KK) GO TO 420
      KS=NSYM(IK)
      NSJK=ITYPE(JS,KS)
      IF(NSIKK.NE.NSJK) GO TO 420
C     COMPUTE FIRST INTEGRAL, I.E. (KJ,IU) IN NOTES.
      IF(J.GT.JMAX) GO TO 430
      MM=1+KMAX*(J-1)
      CALL CCPROD (C(1,II),C(1,IK),C12,LM2,KMAX)
      WN1 = SISMS (C12,G(MM),KMAX)
      GO TO 435
  430 CALL CCPROD (C(1,KK),C(1,IJ),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      CALL CCPROD (C(1,II),C(1,IK),C12,LM2,KMAX)
      WN1 = SISMS (C12,WW,KMAX)
  435 CONTINUE
      IF(J.EQ.K) GO TO 445
C     COMPUTE SECOND INTEGRAL, I.E. (KI,JU) IN NOTES.
      IF(K.GT.JMAX) GO TO 440
      MM=1+KMAX*(K-1)
      CALL CCPROD (C(1,II),C(1,IJ),C12,LM2,KMAX)
      WN2 = SISMS (C12,G(MM),KMAX)
      GO TO 445
  440 CALL CCPROD (C(1,KK),C(1,IK),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      CALL CCPROD (C(1,II),C(1,IJ),C12,LM2,KMAX)
      WN2 = SISMS (C12,WW,KMAX)
  445 CONTINUE
      IGOGO=0
      IF(J.GT.K) GO TO 450
C     EXCITATIONS J,J,KMO-I,LMO,LMO.
      WNN=CB*SQ2*WN1
      GO TO 470
C     EXCITATIONS J,K,KMO-I,LMO,LMO.
  450 WNN=CB*(TWO*WN2-WN1)
      IGOGO=1
      GO TO 470
  460 WNN=-CB*SQ3*WN1
      IGOGO=0
C     STORE THE MATRIX ELEMENT COMPUTED.
  470 NN=NN+1
      IF(NN.LE.LM9) GO TO 480
      IF(NNTOT.EQ.0) REWIND NB2
      WRITE(NB2) W
      NNTOT=NNTOT+LM9
      NN=1
  480 W(NN)=WNN*REV
      IF(IGOGO.EQ.1) GO TO 460
  420 CONTINUE
  410 CONTINUE
  400 CONTINUE
C *** THIRD SUM. TYPE 8C.
      DO 500 I=1,JB
      II=IMOCI(I)
      IF(II.EQ.KK) GO TO 500
      IS=NSYM(II)
      DO 510 J=IA,IB
      IJ=IMOCI(J)
      IF(IJ.EQ.LL) GO TO 510
      JS=NSYM(IJ)
      NSIJ=ITYPE(IS,JS)
      IF(NSIJ.NE.1) GO TO 510
      CALL WINT (LL,LL,II,IJ,WN1,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      CALL WINT (LL,II,LL,IJ,WN2,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      CALL WINT (KK,KK,II,IJ,WN3,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
      CALL WINT (KK,II,KK,IJ,WN4,C,CC,C12,WW,LM2,LM3,LM7,NB3,KMAX)
C     EXCITATIONS I,KMO,KMO-J,LMO,LMO.
      WNN=TWO*WN1-WN2-TWO*WN3+WN4
      NN=NN+1
      IF(NN.LE.LM9) GO TO 530
      IF(NNTOT.EQ.0) REWIND NB2
      WRITE(NB2) W
      NNTOT=NNTOT+LM9
      NN=1
  530 W(NN)=CB*SQ2*WNN*REV
  510 CONTINUE
  500 CONTINUE
C     *
C     NUMBER OF NONZERO MATRIX ELEMENTS.
C     *
  540 NNTOT=NNTOT+NN
      IF(NNTOT.GT.LM9) WRITE(NB2) W
      IF(IOUT2.GE.0) WRITE(6,550) NNTOT
  550 FORMAT(/1X,'THERE ARE',I7,' NONZERO MATRIX ELEMENTS.'/)
      LREC=1+(NNTOT-1)/LM9
      IF(IOUT2.GE.4 .AND. LREC.GT.1) WRITE(6,560) NB2,LREC,LM9
  560 FORMAT( 1X,'THEY ARE STORED ON FILE',I3,' IN',I4,' RECORDS OF',
     1  I5,' WORDS.'/)
C     *
C     COMPUTE COULOMB AND EXCHANGE INTEGRALS.
C     *
      DO 600 I=1,IB
      DO 600 J=1,IB
  600 GG(J,I)=ZERO
      IF(IEN2.EQ.0) RETURN
C     COULOMB INTEGRALS (II,JJ).
  610 DO 620 I=1,IB
      II=IMOCI(I)
      CALL CCPROD (C(1,II),C(1,II),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      DO 620 J=1,I
      IJ=IMOCI(J)
      CALL CCPROD (C(1,IJ),C(1,IJ),C12,LM2,KMAX)
      WNN = SISMS (C12,WW,KMAX)
  620 GG(I,J)=WNN*REV
C     EXCHANGE INTEGRALS (IJ,IJ).
      IF(IB.EQ.1) RETURN
      DO 630 I=2,IB
      II=IMOCI(I)
      IMINUS=I-1
      DO 630 J=1,IMINUS
      IJ=IMOCI(J)
      CALL CCPROD (C(1,II),C(1,IJ),C12,LM2,KMAX)
      CALL WWSTEP (C12,CC,WW,LM7,NB3,KMAX,LMAX)
      WNN = SISMS (C12,WW,KMAX)
      GG(J,I)=WNN*REV
  630 CONTINUE
      RETURN
      END
C     ******************************************************************
      SUBROUTINE DGPERT (E2,EIG,G,W,IMOCI,ITYPE,NSYM,LM3,LM9,LM10,NB2,
     1                   IA,IB,JB,IOUT2,NNTOT,CA,CB,DELT,KK,LL,IABSCI)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     PERTURBATION TREATMENT WITH TWO MAIN CONFIGURATIONS.
C     *
      COMMON
     ./CIFLAG/ ICJUMP(6),IPERT(4)
      DIMENSION EIG(LM3),G(LM10,LM10),W(LM9)
      DIMENSION IMOCI(LM3),ITYPE(8,8),NSYM(LM3)
      DIMENSION NAME(4)
      LOGICAL DEBUG
      DATA NAME/4HRSMP,4HRSEN,4HBWMP,4HBWEN/
      DATA ZERO/0.E0/,TWO/2.E0/
      DATA EV/27.21E0/,CAL/23.061E0/
      DATA EBWLIM/1.E-08/
C *** INITIALIZATION.
      E2=ZERO
      I4=0
      KKS=NSYM(KK)
      LLS=NSYM(LL)
      DO 10 I=1,IB
      II=IMOCI(I)
      IF(II.EQ.KK) KMO=I
   10 IF(II.EQ.LL) LMO=I
      CBA=CB/CA
      IF(IOUT2.GE.4) WRITE(6,620)
C *** LOOP OVER OPTIONS.
      DO 600 IOP=1,4
      JOP=IPERT(IOP)
      IF(JOP.EQ.0) GO TO 600
      EBW=ZERO
      IBW=0
   20 IBW=IBW+1
      DBW=DELT-EBW
      DEBUG = IOUT2.GE.4 .AND. IBW.EQ.1
      IF(DEBUG) WRITE(6,650)
C     READ MATRIX ELEMENTS.
      IF(NNTOT.GT.LM9) REWIND NB2
      IF(NNTOT.GT.LM9) READ(NB2) W
      NN=0
C *** SINGLE EXCITATIONS, I-LMO AND KMO-I.
      ESUM1=ZERO
      DO 100 I=1,IB
      II=IMOCI(I)
      IF(II.EQ.LL) GO TO 100
      IS=NSYM(II)
      NSIK=ITYPE(IS,KKS)
      NSIL=ITYPE(IS,LLS)
      IF(NSIK.NE.1 .AND. I.GE.IA) GO TO 100
      IF(NSIL.NE.1 .AND. I.LT.IA) GO TO 100
      NN=NN+1
      IF(NN.GT.LM9) READ(NB2) W
      IF(NN.GT.LM9) NN=1
      BA=W(NN)
      IF(I.GE.IA) GO TO 110
      EA=EIG(LL)-EIG(II)
      IF(IOP.EQ.1 .OR. IOP.EQ.3) GO TO 120
      EA=EA-G(LMO,I)+TWO*G(I,LMO)
      GO TO 120
  110 EA=EIG(II)-EIG(KK)
      IF(IOP.EQ.1 .OR. IOP.EQ.3) GO TO 120
      EA=EA-G(I,KMO)+TWO*G(KMO,I)
  120 EE=-BA*BA/(EA+DBW)
      ESUM1=ESUM1+EE
      IF(DEBUG) WRITE(6,900) II,I4,I4,I4,BA,EA,EE
  100 CONTINUE
      IF(DEBUG) WRITE(6,650)
C *** DOUBLE AND QUADRUPLE EXCITATIONS.
      ESUM2=ZERO
      ESUM4=ZERO
      DO 200 I=IA,IB
      II=IMOCI(I)
      IS=NSYM(II)
      DO 200 J=1,JB
      IJ=IMOCI(J)
      JS=NSYM(IJ)
      NSIJ=ITYPE(IS,JS)
      DO 200 K=IA,I
      IK=IMOCI(K)
      KS=NSYM(IK)
      DO 200 L=1,J
      IL=IMOCI(L)
      LS=NSYM(IL)
      NSKL=ITYPE(KS,LS)
      IF(NSIJ.NE.NSKL) GO TO 200
      IF(II.EQ.LL .AND. IJ.EQ.KK .AND. IK.EQ.LL .AND. IL.EQ.KK) GOTO 200
C     EXCITATIONS J,L-I,K.
      NN=NN+1
      IF(NN.GT.LM9) READ(NB2) W
      IF(NN.GT.LM9) NN=1
      BA=W(NN)
      CALL ERGCON (EA,EB,EIG,IMOCI,LM3,J,L,I4,I4,I,K,I4,I4,IOP,
     1             G,LM10)
      EE=-BA*BA/(EA+DBW)
      ESUM2=ESUM2+EE
      IF(DEBUG) WRITE(6,900) II,IJ,IK,IL,BA,EA,EE
      IF(I.EQ.K .OR. J.EQ.L) GO TO 210
      NN=NN+1
      IF(NN.GT.LM9) READ(NB2) W
      IF(NN.GT.LM9) NN=1
      BB=W(NN)
      EE=-BB*BB/(EB+DBW)
      ESUM2=ESUM2+EE
      IF(DEBUG) WRITE(6,900) II,IJ,IK,IL,BB,EB,EE
C     EXCITATIONS J,L,KMO,KMO-I,K,LMO,LMO.
  210 IF(II.EQ.LL .OR. IJ.EQ.KK) GO TO 200
      IF(IK.EQ.LL .OR. IL.EQ.KK) GO TO 200
      IF(IABSCI.EQ.3) GO TO 200
      CALL ERGCON (EA,EB,EIG,IMOCI,LM3,J,L,KMO,KMO,I,K,LMO,LMO,IOP,
     1             G,LM10)
      BA=BA*CBA
      EE=-BA*BA/(EA+DBW)
      ESUM4=ESUM4+EE
      IF(DEBUG) WRITE(6,900) II,IJ,IK,IL,BA,EA,EE
      IF(I.EQ.K .OR. J.EQ.L) GO TO 200
      BB=BB*CBA
      EE=-BB*BB/(EB+DBW)
      ESUM4=ESUM4+EE
      IF(DEBUG) WRITE(6,900) II,IJ,IK,IL,BB,EB,EE
  200 CONTINUE
      IF(DEBUG) WRITE(6,650)
C *** TRIPLE EXCITATIONS.
      ESUM3=ZERO
      IF(IABSCI.EQ.3) GO TO 550
C     EXCITATIONS I,KMO,KMO-J,K,LMO  (TYPE 8B,9,10).
      DO 300 I=1,JB
      II=IMOCI(I)
      IF(II.EQ.KK) GO TO 300
      IS=NSYM(II)
      NSILL=ITYPE(IS,LLS)
      DO 310 J=IA,IB
      IJ=IMOCI(J)
      IF(IJ.EQ.LL) GO TO 310
      JS=NSYM(IJ)
      DO 320 K=IA,J
      IK=IMOCI(K)
      IF(IK.EQ.LL) GO TO 320
      KS=NSYM(IK)
      NSJK=ITYPE(JS,KS)
      IF(NSILL.NE.NSJK) GO TO 320
      NN=NN+1
      IF(NN.GT.LM9) READ(NB2) W
      IF(NN.GT.LM9) NN=1
      BA=W(NN)
      CALL ERGCON (EA,EB,EIG,IMOCI,LM3,I,KMO,KMO,I4,J,K,LMO,I4,IOP,
     1             G,LM10)
      EE=-BA*BA/(EA+DBW)
      ESUM3=ESUM3+EE
      IF(DEBUG) WRITE(6,900) II,IJ,IK,I4,BA,EA,EE
      IF(J.EQ.K) GO TO 320
      NN=NN+1
      IF(NN.GT.LM9) READ(NB2) W
      IF(NN.GT.LM9) NN=1
      BB=W(NN)
      EE=-BB*BB/(EB+DBW)
      ESUM3=ESUM3+EE
      IF(DEBUG) WRITE(6,900) II,IJ,IK,I4,BB,EB,EE
  320 CONTINUE
  310 CONTINUE
  300 CONTINUE
C     EXCITATIONS J,K,KMO-I,LMO,LMO  (TYPE 8A,12,13).
      DO 400 I=IA,IB
      II=IMOCI(I)
      IF(II.EQ.LL) GO TO 400
      IS=NSYM(II)
      NSIKK=ITYPE(IS,KKS)
      DO 410 J=1,JB
      IJ=IMOCI(J)
      IF(IJ.EQ.KK) GO TO 410
      JS=NSYM(IJ)
      DO 420 K=1,J
      IK=IMOCI(K)
      IF(IK.EQ.KK) GO TO 420
      KS=NSYM(IK)
      NSJK=ITYPE(JS,KS)
      IF(NSIKK.NE.NSJK) GO TO 420
      NN=NN+1
      IF(NN.GT.LM9) READ(NB2) W
      IF(NN.GT.LM9) NN=1
      BA=W(NN)
      CALL ERGCON (EA,EB,EIG,IMOCI,LM3,J,K,KMO,I4,I,LMO,LMO,I4,IOP,
     1             G,LM10)
      EE=-BA*BA/(EA+DBW)
      ESUM3=ESUM3+EE
      IF(DEBUG) WRITE(6,900) II,IJ,IK,I4,BA,EA,EE
      IF(J.EQ.K) GO TO 420
      NN=NN+1
      IF(NN.GT.LM9) READ(NB2) W
      IF(NN.GT.LM9) NN=1
      BB=W(NN)
      EE=-BB*BB/(EB+DBW)
      ESUM3=ESUM3+EE
      IF(DEBUG) WRITE(6,900) II,IJ,IK,I4,BB,EB,EE
  420 CONTINUE
  410 CONTINUE
  400 CONTINUE
C     EXCITATIONS I,KMO,KMO-J,LMO,LMO  (TYPE 8C).
      DO 500 I=1,JB
      II=IMOCI(I)
      IF(II.EQ.KK) GO TO 500
      IS=NSYM(II)
      DO 510 J=IA,IB
      IJ=IMOCI(J)
      IF(IJ.EQ.LL) GO TO 510
      JS=NSYM(IJ)
      NSIJ=ITYPE(IS,JS)
      IF(NSIJ.NE.1) GO TO 510
      NN=NN+1
      IF(NN.GT.LM9) READ(NB2) W
      IF(NN.GT.LM9) NN=1
      BA=W(NN)
      CALL ERGCON (EA,EB,EIG,IMOCI,LM3,I,KMO,KMO,I4,J,LMO,LMO,I4,IOP,
     1             G,LM10)
      EE=-BA*BA/(EA+DBW)
      ESUM3=ESUM3+EE
      IF(DEBUG) WRITE(6,900) II,IJ,I4,I4,BA,EA,EE
  510 CONTINUE
  500 CONTINUE
C *** ENERGY CORRECTION.
  550 EESUM=ESUM1+ESUM2+ESUM3+ESUM4
      IF(IOP.LT.3) GO TO 90
C *** BW TREATMENT.
      IF(IOUT2.LT.0) GO TO 80
      IF(IBW.EQ.1) WRITE(6,650)
      WRITE(6,670) IBW,EESUM,ESUM1,ESUM2,ESUM3,ESUM4
   80 IF(DABS(EESUM-EBW).LT.EBWLIM) GO TO 90
      EBW=EESUM
      GO TO 20
C *** PRINT THE RESULTS.
   90 ESUM=EESUM-DELT
      EEV=ESUM*EV
      EKCAL=EEV*CAL
      DELTAU=-DELT
      DELTEV=DELTAU*EV
      DELTKC=DELTEV*CAL
      IOPCI=IABSCI-2
      IF(IOUT2.GT.-5) WRITE(6,920) DELTAU,DELTEV,DELTKC,KK,LL
      IF(IOUT2.GT.-5) WRITE(6,910) ESUM,EEV,EKCAL,NAME(IOP),IOPCI
      IF(JOP.GT.0) E2=EEV
  600 CONTINUE
      IF(NNTOT.GT.LM9) CALL CLODA(NB2)
      RETURN
  620 FORMAT (//1X,'DEBUG PRINT FOR SECOND-ORDER TERMS.'//
     1          1X,'  II  IJ  IK  IL',5X,'BA',10X,'EA',10X,'EE')
  650 FORMAT (  1X)
  670 FORMAT (  1X,'CYCLE',I3 ,5X,'ENERGIES (IN A.U.)',3X,5F12.7)
  900 FORMAT (  1X,4I4,6F12.7)
  910 FORMAT (/ 1X,'SECOND-ORDER ENERGY =',F12.7,' A.U.=',F12.7,' EV=',
     1             F12.7,' KCAL/MOLE',10X,'OPTION=',A4,I1)
  920 FORMAT (/ 1X,'CI STABILIZATION    =',F12.7,' A.U.=',F12.7,' EV=',
     1             F12.7,' KCAL/MOLE',10X,'MO-VO ',2I3)
      END
C     ******************************************************************
      SUBROUTINE ERGCON(EA,EB,EIG,IMOCI,LM3,II,IJ,IK,IL,IU,IV,IW,IX,IOP,
     1                  G,LM10)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     ENERGY OF CONFIGURATION.
C     *
C     NOTE. THE ARRAY G(I,J) CONTAINS THE COULOMB (I.GE.J) AND
C     EXCHANGE (I.LT.J) INTEGRALS. FOR COMPATIBILITY WITH THIS
C     STORAGE, THE EXCITATION INDICES MUST FULFIL.
C     II.GE.IJ.GE.IK.GE.IL, AND IU.GE.IV.GE.IW.GE.IX.
C     ALL INDICES FOR OCCUPIED MOS MUST BE SMALLER THAN THOSE
C     FOR UNOCCUPIED MOS, I.E. II.LT.IU ETC.
      DIMENSION EIG(LM3),IMOCI(LM3)
      DIMENSION G(LM10,LM10)
      DATA HALF/0.5E0/,ONE5/1.5E0/,TWO/2.E0/
      IF(II.LT.IJ .OR. IU.LT.IV) GO TO 500
C     INITIALIZATION.
      III=IMOCI(II)
      IIJ=IMOCI(IJ)
      IIU=IMOCI(IU)
      IIV=IMOCI(IV)
      IF(IL.GT.0 .AND. IX.GT.0) GO TO 300
      IF(IK.GT.0 .AND. IW.GT.0) GO TO 200
C *** DOUBLE EXCITATIONS.
      EA=EIG(IIU)+EIG(IIV)-EIG(III)-EIG(IIJ)
      EB=EA
      IF(IOP.EQ.1 .OR. IOP.EQ.3) RETURN
      EA=EA+G(II,IJ)+G(IU,IV)-G(IU,II)-G(IV,II)-G(IU,IJ)-G(IV,IJ)
   50 EE=EA
      IF(II.NE.IJ) GO TO 110
      IF(IU.NE.IV) GO TO 100
C     CASE II,II-IU,IU (TYPE 2).
      EA=EA+TWO*G(II,IU)
      RETURN
C     CASE II,II-IU,IV (TYPE 3).
  100 EA=EA+G(II,IU)+G(II,IV)+G(IV,IU)
      RETURN
C     CASE II,IJ-IU,IU (TYPE 4).
  110 IF(IU.NE.IV) GO TO 120
      EA=EA+G(II,IU)+G(IJ,IU)+G(IJ,II)
      RETURN
C     CASE II,IJ-IU,IV (TYPE 5,6).
  120 GS1=G(II,IU)+G(II,IV)+G(IJ,IU)+G(IJ,IV)
      GS2=G(IJ,II)+G(IV,IU)
      EA =EE+HALF*GS1+GS2
      EB =EE+ONE5*GS1-GS2
      RETURN
C *** TRIPLE EXCITATIONS.
  200 IF(IJ.LT.IK .OR. IV.LT.IW) GO TO 500
      IIK=IMOCI(IK)
      IIW=IMOCI(IW)
      EA=EIG(IIU)+EIG(IIV)+EIG(IIW)-EIG(III)-EIG(IIJ)-EIG(IIK)
      EB=EA
      IF(IOP.EQ.1 .OR. IOP.EQ.3) RETURN
      EA=EA+G(II,IJ)+G(II,IK)+G(IJ,IK)+G(IU,IV)+G(IU,IW)+G(IV,IW)
      EA=EA-G(IU,II)-G(IU,IJ)-G(IU,IK)-G(IV,II)-G(IV,IJ)-G(IV,IK)
      EA=EA-G(IW,II)-G(IW,IJ)-G(IW,IK)
      EE=EA
      IF(IJ.NE.IK) GO TO 220
      IF(IV.NE.IW) GO TO 210
C     CASE II,IJ,IJ-IU,IV,IV (TYPE 8C).
      EA=EA-G(IJ,II)-G(IV,IU)+TWO*G(II,IU)+G(II,IV)+G(IJ,IU)
     1     +TWO*G(IJ,IV)
      RETURN
C     CASE II,IJ,IJ-IU,IV,IW (TYPE 9,10).
  210 IF(IU.EQ.IV) GO TO 215
      GS1=-G(IJ,II)+HALF*(G(II,IU)+G(II,IV))+G(IJ,IU)+G(IJ,IV)+G(IJ,IW)
      GS2=-HALF*(G(IW,IV)+G(IW,IU))+G(IV,IU)
      EA =EE+GS1+GS2+TWO*G(II,IW)
      EB =EE+GS1-GS2+G(II,IV)+G(II,IU)
      RETURN
C     CASE II,IJ,IJ-IU,IU,IW (TYPE 8B).
  215 EA=EA-G(IJ,II)-G(IW,IU)+TWO*G(II,IW)+G(II,IU)+G(IJ,IW)
     1     +TWO*G(IJ,IU)
      RETURN
C     CASE II,IJ,IK-IU,IV,IV (TYPE 12,13).
  220 IF(IV.NE.IW) GO TO 500
      IF(II.EQ.IJ) GO TO 225
      GS1=-G(IV,IU)+HALF*(G(IK,IU)+G(IJ,IU))+G(II,IV)+G(IJ,IV)+G(IK,IV)
      GS2=-HALF*(G(IK,II)+G(IJ,II))+G(IK,IJ)
      EA =EE+GS1+GS2+TWO*G(II,IU)
      EB =EE+GS1-GS2+G(IK,IU)+G(IJ,IU)
      RETURN
C     CASE II,II,IK-IU,IV,IV (TYPE 8B).
  225 EA=EA-G(IK,II)-G(IV,IU)+TWO*G(IK,IU)+G(IK,IV)+G(II,IU)
     1     +TWO*G(II,IV)
      RETURN
C *** QUADRUPLE EXCITATIONS.
  300 IF(IK.NE.IL .OR. IW.NE.IX) GO TO 500
      IIK=IMOCI(IK)
      IIL=IMOCI(IL)
      IIW=IMOCI(IW)
      IIX=IMOCI(IX)
      EA=EIG(IIU)+EIG(IIV)+EIG(IIW)+EIG(IIX)-EIG(III)-EIG(IIJ)-EIG(IIK)-
     1   EIG(IIL)
      EB=EA
      IF(IOP.EQ.1 .OR. IOP.EQ.3) RETURN
      EA=EA+G(II,IJ)+G(II,IK)+G(II,IL)+G(IJ,IK)+G(IJ,IL)+G(IK,IL)
      EA=EA+G(IU,IV)+G(IU,IW)+G(IU,IX)+G(IV,IW)+G(IV,IX)+G(IW,IX)
      EA=EA-G(IU,II)-G(IU,IJ)-G(IU,IK)-G(IU,IL)
      EA=EA-G(IV,II)-G(IV,IJ)-G(IV,IK)-G(IV,IL)
      EA=EA-G(IW,II)-G(IW,IJ)-G(IW,IK)-G(IW,IL)
      EA=EA-G(IX,II)-G(IX,IJ)-G(IX,IK)-G(IX,IL)
      EA=EA-G(IK,II)-G(IK,IJ)-G(IW,IU)-G(IW,IV)
     1     +G(II,IW)+G(IJ,IW)
     1     +G(IK,IU)+G(IK,IV)+TWO*G(IK,IW)
      GO TO 50
C *** ERROR EXIT.
  500 WRITE(6,510) II,IJ,IK,IL,IU,IV,IW,IX
      STOP
  510 FORMAT(//1X,'THE PROGRAM CANNOT HANDLE THE FOLLOWING EXCITATION',
     1  ' INDICES.'/1X,8I5//)
      END
C     ******************************************************************
C     ******************************************************************
      SUBROUTINE PRTDFP (Q,LM5)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     DFP RESULTS
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./CYCLES/ ICYC,IFUN
     ./DFP   / X(99),N
     ./ERG   / EX,G(99)
     ./FLAG1 / KTITLE(12),KOMENT(10),KHARGE(10)
     ./FUNCT / ENERGY,EESAVE,ENSAVE,EPSAVE
     ./MXFLAG/ MAXEND
     ./PARM1 / A(3,50),NA(200),NATOMS,LREACT(2)
     ./PARM3 / LOC(2,99)
     ./SEARCH/ JOP
     ./XPRJU / IREP,IJUMP
      DIMENSION Q(LM5)
      WRITE(6,100) (KOMENT(I),I=1,10), (KTITLE(I),I=1,12)
      IF(IJUMP.EQ.1) GO TO 20
      IF(MAXEND.GT.3) WRITE(6,110) ICYC,IFUN
      WRITE(6,120) ENERGY
C *** PRINT GRADIENTS.
      IF(MAXEND.GT.3) WRITE(6,600)
      IF(MAXEND.EQ.3) WRITE(6,601)
      DO 829 I=1,N
      Q(I)=X(I)
      IF(LOC(2,I)-2) 829,828,828
  828 Q(I)=Q(I)*57.2957795
  829 CONTINUE
      NTO=N/10
      NREM=N-(NTO*10)
      IINC1=-9
      IF(NTO.LT.1) GO TO 831
      DO 830 I=1,NTO
      WRITE(6,851)
      IINC1=IINC1+10
      IINC2=IINC1+9
      WRITE(6,852) (J,J=IINC1,IINC2)
      WRITE(6,853) (Q(J),J=IINC1,IINC2)
      WRITE(6,854) (G(J),J=IINC1,IINC2)
  830 CONTINUE
  831 CONTINUE
      IF(NREM.LT.1) GO TO 832
      WRITE(6,851)
      IINC1=IINC1+10
      IINC2=IINC1+(NREM-1)
      WRITE(6,852) (J,J=IINC1,IINC2)
      WRITE(6,853) (Q(J),J=IINC1,IINC2)
      WRITE(6,854) (G(J),J=IINC1,IINC2)
  832 CONTINUE
C *** PRINT MOLECULAR GEOMETRY AND INTERATOMIC DISTANCES.
   20 IF(MAXEND.LE.3) RETURN
      WRITE(6,602)
      CALL SYMTRY(+1)
      CALL GMETRY(+1)
      K=0
      DO 30 I=1,NATOMS
      DO 30 J=1,I
      K=K+1
      Q(K)=DSQRT((COORD(1,I)-COORD(1,J))**2+(COORD(2,I)-COORD(2,J))**2
     1         +(COORD(3,I)-COORD(3,J))**2)
   30 CONTINUE
      WRITE(6,604)
      CALL VECPRT(Q,LM5,NATOMS)
C *** STOP IN CASE OF TIME LIMIT.
      IF(IJUMP.EQ.0) RETURN
      WRITE(6,900) ICYC
      WRITE(6,910) ENERGY
      IF(JOP.EQ.1) WRITE(6,920) EPSAVE
      WRITE(6,602)
      STOP
  100 FORMAT(//// 5X,10A4/ 5X,12A4/)
  110 FORMAT(// 5X,'OPTIMIZATION FINISHED AFTER',I4,' CYCLES AND',I4,
     1             ' SCF CALCULATIONS')
  120 FORMAT(/  5X,'HEAT OF FORMATION   ',F15.5,' KCAL/MOLE')
  600 FORMAT(///5X,'OPTIMIZED VARIABLES AND GRADIENTS'/)
  601 FORMAT(///5X,'VARIABLES AND GRADIENTS'/)
  602 FORMAT(//)
  604 FORMAT(///5X,'INTERATOMIC DISTANCES (ANGSTROMS)'/)
  851 FORMAT(1H )
  852 FORMAT(1H ,3X,'I',7X,I2,9(10X,I2))
  853 FORMAT(1H ,1X,'X(I)',1X,F10.5,2X,9(F10.5,2X))
  854 FORMAT(1H ,1X,'G(I)',1X,F10.5,2X,9(F10.5,2X))
  900 FORMAT(///5X,'THE JOB APPROACHES ITS TIME LIMIT IN CYCLE',I3,'.',
     1       /  5X,'ALL RELEVANT INFORMATION HAS BEEN SAVED ON FILE.',
     2       /  5X,'CONTINUE THE OPTIMIZATION IN A NEW JOB.')
  910 FORMAT(/  5X,'CURRENT HEAT OF FORMATION',F15.3,' KCAL/MOLE')
  920 FORMAT(/  5X,'CURRENT SUM OF SQUARES   ',F15.3)
      END
C     ******************************************************************
      SUBROUTINE PRTLST
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     SUMMARY OF RESULTS
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./BOND  / KTRIAL
     ./DIPOL / DD
     ./EXPOL / NSTART,NSTEP
     ./FLAG1 / KTITLE(12),KOMENT(10),KHARGE,KGEOM,KITSCF,KDUMMY,
     .         KSYM,KDEP,KOUNT,NTYPE,KRSAVE,NSTTT
     ./FUNCT / ENERGY,EESAVE,ENSAVE,EPSAVE
     ./HALFE / IMULT,IODD,JODD
     ./PARM1 / A(3,50),NA(50),NB(50),NC(50),NN(50),NATOMS,LREACT(2)
     ./PARM3 / LOC(2,99)
     ./SETCI / KCI
     ./XPRJU / IREP,IJUMP
     ./XSKPRT/ IPUBO,IPUEV,JPRINT,NPRINT
      DIMENSION ILL(3),QQ(3)
      LOGICAL IREPO
      DATA BLANK / 1H  /
      DATA STAR  / 1H* /
      DATA PLUS  / 1H+ /
      CALL GMETRY(+1)
C     OUTPUT AFTER JOB COMPLETION
      WRITE(6,702) (KOMENT(I), I=1,10), (KTITLE(I), I=1,12)
      WRITE(6,610)
      WRITE(6,620) ENERGY
      IF(IMULT.EQ.0) WRITE(6,624) EPSAVE
      IF(NPRINT.GE.0 .AND. KHARGE.EQ.0) WRITE(6,625) DD
      IF(KHARGE.NE.0) WRITE(6,2040) KHARGE
      IF(IMULT.LT.1) GO TO 10
      WRITE(6,2041) IMULT
      IF(JODD.EQ.0) WRITE(6,2043) IODD
      IF(JODD.GT.0) WRITE(6,2042) IODD,JODD
C     OUTPUT OF GEOMETRY
   10 IREPO=IREP.EQ.1
      IF(IREPO) WRITE(7,7000) KHARGE,IMULT,KTRIAL,KGEOM,IPUBO,IPUEV,
     1  KITSCF,NPRINT,KDUMMY,KSYM,KDEP,KCI,NSTART,NSTEP,
     2  (KTITLE(I),I=1,12)
      WRITE(6,4399)
      WRITE(6,4400)
      WRITE(6,4401)
      WRITE(6,4402)
      NXX=1
      IF(IREPO) WRITE(7,881) NN(1)
      WRITE(6,871) NXX,NN(1),NXX,COORD(1,1),COORD(2,1),COORD(3,1)
      IA=LOC(1,1)
      ILL(1)=0
      IF (LREACT(1).EQ.2) ILL(1)=-1
      QQ(1)=BLANK
      IF (LREACT(1).EQ.2) QQ(1)=PLUS
      IF(LOC(1,1).NE.2) GO TO 20
      ILL(1)=1
      QQ(1)=STAR
      NXX=NXX+1
      IA=LOC(1,NXX)
   20 IF(IREPO) WRITE(7,803) NN(2),A(1,2),ILL(1),NC(2)
      I=2
      WRITE(6,872) I,NN(2),A(1,2),QQ(1),NC(2),I,COORD(1,2),COORD(2,2),
     1COORD(3,2)
      IF(NATOMS.LT.3) GO TO 80
      DO 30 J=1,2
      QQ(J)=BLANK
      ILL(J)=0
      IF(IA.NE.3) GO TO 30
      IF(LOC(2,NXX).NE.J) GO TO 30
      QQ(J)=STAR
      ILL(J)=1
      NXX=NXX+1
      IA=LOC(1,NXX)
   30 CONTINUE
      W=A(2,3)*57.29577951
      IF (LREACT(1).NE.3) GO TO 40
      J=LREACT(2)
      ILL(J)=-1
      QQ(J)=PLUS
   40 IF(IREPO) WRITE(7,804) NN(3),A(1,3),ILL(1),W,ILL(2),NC(3),NB(3)
      I=3
      WRITE(6,873) I,NN(3),A(1,3),QQ(1),W,QQ(2),NC(3),NB(3),I,COORD(1,3)
     1,COORD(2,3),COORD(3,3)
      IF(NATOMS.LT.4) GO TO 80
      DO 70 I=4,NATOMS
      DO 50 J=1,3
      QQ(J)=BLANK
      ILL(J)= 0
      IF (IA.NE.I) GO TO 50
      IF(J.NE.LOC(2,NXX)) GO TO 50
      QQ(J)=STAR
      ILL(J)= 1
      NXX=NXX+1
      IA=LOC(1,NXX)
   50 CONTINUE
      W = A(2,I)*57.29577951
      XW= A(3,I)*57.29577951
      IF(LREACT(1).NE.I) GO TO 60
      J=LREACT(2)
      ILL(J)=-1
      QQ(J)=PLUS
   60 IF(IREPO)
     1WRITE(7,881) NN(I),A(1,I),ILL(1),W,ILL(2),XW,ILL(3),NC(I),NB(I),
     2NA(I)
      WRITE(6,889) I,NN(I),A(1,I),QQ(1),W,QQ(2),XW,QQ(3),NC(I),NB(I),
     1NA(I),I,COORD(1,I),COORD(2,I),COORD(3,I)
   70 CONTINUE
   80 CONTINUE
C     PUNCH CARTESIAN COORDINATES.
      IF(IREP.NE.2) RETURN
      WRITE(7,900) (KTITLE(I),I=1,12)
      WRITE(7,910) NUMAT,KHARGE,IMULT,KTRIAL,KGEOM,IPUBO,IPUEV,KITSCF,
     1  NPRINT,KDUMMY,KSYM,KDEP,KCI,NSTART,NSTEP
      CALL GMETRY(-2)
      DO 90 I=1,NUMAT
   90 WRITE(7,920) NAT(I),(COORD(J,I),J=1,3)
      RETURN
  610 FORMAT(/)
  620 FORMAT(/  , 5X,'HEAT OF FORMATION         ',F15.5,' KCAL/MOLE')
  624 FORMAT(/  , 5X,'IONIZATION POTENTIAL      ',F15.5,' EV')
  625 FORMAT(/  , 5X,'DIPOLE MOMENT             ',F15.5,' DEBYE')
  702 FORMAT(////, 5X,10A4/ 5X,12A4)
  803 FORMAT(I2,8X,1(F10.5,2X,I2,6X),40X,I2)
  804 FORMAT(I2,8X,2(F10.5,2X,I2,6X),20X,2I2)
  871 FORMAT(6X,I2,5X,I2,66X,I2,F13.5,2F15.5)
  872 FORMAT(6X,I2,5X,I2,5X,F10.4,1X,A1,28X,I2,19X,I2,F13.5,2F15.5)
  873 FORMAT(6X,I2,5X,I2,5X,F10.4,1X,A1,F10.3,1X,A1,13X,2(3X,I2),14X,I2,
     1 F13.5,2F15.5)
  881 FORMAT(I2,8X,3(F10.5,2X,I2,6X),3I2)
  889 FORMAT(1H ,5X,I2,5X,I2,5X,F10.4,1X,A1,2(F10.3,1X,A1),1X,3(3X,I2),
     1  9X,I2,F13.5,2F15.5)
  900 FORMAT(12A4)
  910 FORMAT(20I4)
  920 FORMAT(I4,3(3X,F12.7))
 2040 FORMAT(/, 5X,'CHARGE      ',I5)
 2041 FORMAT(/, 5X,'MULTIPLICITY',I5)
 2042 FORMAT(/, 5X,'ONE ELECTRON IN ORBITALS',I4,3X,'AND',I4)
 2043 FORMAT(/, 5X,'ONE ELECTRON IN ORBITAL',I4)
 4399 FORMAT(1H ,///,5X,'ATOM',3X,'ATOMIC',3X,'BOND LENGTH',3X,'BOND ANG
     1LE',2X,'TWIST ANGLE',22X,'ATOM',18X,'COORDINATES')
 4400 FORMAT(1H ,3X,'NUMBER',2X,'NUMBER',3X,'(ANGSTROMS)',3X,'(DEGREES)'
     1,4X,'(DEGREES)',22X,'NUMBER')
 4401 FORMAT(1H ,5X,' I ',16X,'J I', 9X,'K J I',7X,'L K J I',5X,'J',4X,
     1'K',4X,'L',10X,'I',9X,'X',14X,'Y',14X,'Z')
 4402 FORMAT(1H )
 7000 FORMAT(6I2,I4,7I2,12A4)
      END



