C     ******************************************************************
      SUBROUTINE CREP (NI,NJ,ZI,ZJ,RAB,W)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     REPULSION INTEGRALS (SS,SS)
C     *
      REAL K,K1,K2,K3,K4
C *** INITIALIZE SOME VARIABLES.
      LI=1
      LJ=1
      IF(NI.GT. 2) LI=2
      IF(NI.GT.10) LI=3
      IF(NJ.GT. 2) LJ=2
      IF(NJ.GT.10) LJ=3
C     SWITCH EXPONENTS, IF NECESSARY.
      IF(LI.GT.LJ) GO TO 10
      NTYPE=(LJ*(LJ-1))/2+LI
      ZA=ZI
      ZB=ZJ
      GO TO 20
   10 NTYPE=(LI*(LI-1))/2+LJ
      ZA=ZJ
      ZB=ZI
   20 IF(NTYPE.GT.3) GO TO 999
C     CALCULATE REDUCED VARIABLES.
      Z=0.5*(ZA+ZB)
      T=(ZA-ZB)/(ZA+ZB)
      P=Z*RAB
      PA=ZA*RAB
      EA=DEXP(-2.*PA)
      IF(T.EQ.0.0) GO TO 90
      K=0.5*(T+1./T)
      PB=ZB*RAB
      EB=DEXP(-2.*PB)
      APK=1.+K
      AMK=1.-K
      APK2=APK*APK
      AMK2=AMK*AMK
      IF(NTYPE.GT.1) GO TO 40
C *** CALCULATE THE INTEGRALS.
C     (1S,1S/1S,1S)
      A=Z/P*(1.-AMK2*0.25*(2.+K+PA)*EA-APK2*0.25*(2.-K+PB)*EB)
      GO TO 160
C     (1S,1S/2S,2S)
   40 CONTINUE
      AMK3=AMK2*AMK
      PB2=PB*PB
      PB3=PB2*PB
      K2=K*K
      K3=K2*K
      IF(NTYPE.GT.2) GO TO 70
   50 A=Z/P*(1.-AMK3*0.0625*(1.-5.*K-4.*K2-2.*K*PA)*EA-APK2*(0.0625*(
     1 15.-22.*K+15.*K2-4.*K3)+0.375*(3.-3.*K+K2)*PB+0.25*(2.-K)*PB2
     2 +PB3/12.)*EB)
      GO TO 160
C     (2S,2S/2S,2S)
   70 CONTINUE
      APK3=APK2*APK
      PB4=PB3*PB
      PA2=PA*PA
      PA3=PA2*PA
      PA4=PA3*PA
      K4=K3*K
   80 A=Z/P*(1.-AMK3*(0.0625*(8.-K-27.*K2-30.*K3-10.*K4)+0.03125*(11.-
     1 19.*K-44.*K2-20.*K3)*PA+0.0625*(1.-5.*K-4.*K2)*PA2-K*PA3/24.)*EA
     2 -APK3*(0.0625*(8.+K-27.*K2+30.*K3-10.*K4)+0.03125*(11.+19.*K-44.*
     3 K2+20.*K3)*PB+0.0625*(1.+5.*K-4.*K2)*PB2+K*PB3/24.)*EB)
      GO TO 160
C *** SIMPLIFIED CALCULATION OF THE INTEGRALS FOR T=0.
   90 CONTINUE
      P2=P*P
      P3=P2*P
      P4=P3*P
      P5=P4*P
      P6=P5*P
      P7=P6*P
      GO TO (100,120,150),NTYPE
C     (1S,1S/1S,1S)
  100 A=Z/P*(1.-(1.+1.375*P+.75*P2+P3/6.)*EA)
      GO TO 160
C     (1S,1S/2S,2S)
  120 A=Z/P*(1.-(1.+1.5625*P+1.125*P2+23.*P3/48.+.125*P4+P5/60.)*EA)
      GO TO 160
C     (2S,2S/2S,2S)
  150 A=Z/P*(1.-(1.+419.*P/256.+163.*P2/128.+119.*P3/192.+5.*P4/24.
     1 +P5/20.+P6/120.+P7/1260.)*EA)
C *** CONVERT TO EV.
  160 W=A*27.21
      RETURN
C *** ERROR EXIT.
  999 WRITE(6,900)
      WRITE(8,900)
      STOP
  900 FORMAT(///5X,'THIS PROGRAM CANNOT HANDLE THIRD-ROW ELEMENTS',
     1             ' IN CNDO/2. STOP.'///)
      RETURN
      END
C     ******************************************************************
      SUBROUTINE ITER (C,E,OCC,Q,D,F,H,P,W,LM2,LM3,LM4,LM9,NROOT)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     SCF ITERATIONS
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./ENERG / EE,ENUCLR,EAT,ATHEAT
     ./FLAG1 / KTITLE(12),KOMENT(10),KHARGE,KGEOM,KITSCF,KDUMMY,
     .         KSYM,KDEP,KOUNT,NTYPE,KRSAVE,ITSAVE
     ./FLAG3 / KRESET,IWADE
     ./FLAG4 / INTSUM
     ./FUNCT / VALUE,EESAVE,ENSAVE,EPSAVE
     ./HALFE / IMULT,IODD,JODD
     ./HALFX / XI,XJ,XK
     ./LMOUT / INOUT
     ./NBFILE/ NB1,NB2,NB3,NB4
     ./OPTION/ IOP
     ./ORBITS/ NUMB,NORBS
     ./REP   / GSS(18),GPP(18),GSP(18),GP2(18),HSP(18),HPP(18)
     ./SCRT  / SCFCRT,SCFF
     ./XSKPRT/ IPUBO,IPUEV,JPRINT,NPRINT
     $/mani/kontrol,iodd1,iodd2,fact,fact2
      DIMENSION C(LM2,LM3),D(LM4),E(LM3),F(LM4),H(LM4),P(LM4)
      DIMENSION OCC(LM3),Q(LM2,5),W(LM9)
C *** INITIALIZATION.
      jump=0
      if(lm2.gt.200.or.lm3.gt.200)stop 223
        NPRINT=2
      KSCF   = 0
      NITER  = 0
      EEP    = 0.
      DO 10 I=1,NUMB
   10 OCC(I)=2.d0
      IF(IODD.GT.0) OCC(IODD)=1.d0
      IF(JODD.GT.0) OCC(JODD)=1.d0
CCC      IF(NPRINT.GE.2) WRITE(6,600)
CCC      IF(NPRINT.GE.2) WRITE(8,600)
C     FILE HANDLING.
      IF(INOUT.EQ.0) GO TO 122
      REWIND NB1
      READ(NB1) P
      IF(INOUT.LT.2) GO TO 122
      REWIND NB3
      WRITE(NB3) H
C *** START THE SCF LOOP HERE
 122  if(kontrol.ne.97.and.kontrol.ne.98)goto 2
      jump=1
      write(6,*)'mndo5',kontrol,iodd1,iodd2,fact,fact2,jump
      CALL PMATR(C,D,P,OCC,LM2,LM3,LM4,INOUT,NB1,NITER,PL,YL)
   2  NITER=NITER+1
      IF(INOUT.GT.1) GO TO 21
      DO 20 I=1,LM4
   20 F(I)   = H(I)
      GO TO 22
   21 REWIND NB3
      READ(NB3) F
   22 CALL ESCF (EH,NORBS,P,F,LM4)
C *** CONSTRUCT THE F-MATRIX.
      KR=0
      IF(IOP.LE.0 .AND. INTSUM.GT.LM9) REWIND NB2
      DO 9  II=1,NUMAT
      IA=NFIRST(II)
      IB=NLAST(II)
      IF (II.EQ.1) GO TO 5
      IMINUS=II-1
C     INCLUDE THE TWO-CENTER REPULSION INTEGRALS.
      IF(IOP.GT.0) GO TO 41
      DO 40 JJ=1,IMINUS
      JA=NFIRST(JJ)
      JB=NLAST(JJ)
      IF(INTSUM.LE.LM9) GO TO 40
      NO=10**((IB-IA+JB-JA+2)/4)
      READ(NB2) (W(I),I=1,NO)
   40 CALL DFOCK (IA,IB,JA,JB,KR,F,P,W,LM4,LM9)
      GO TO 5
   41 DO 42 JJ=1,IMINUS
      JA=NFIRST(JJ)
      JB=NLAST(JJ)
      IJ=(II*(II-1))/2+JJ
      WIJ=W(IJ)
   42 CALL MFOCK (IA,IB,JA,JB,F,P,WIJ,LM4)
C     INCLUDE THE ONE-CENTER REPULSION INTEGRALS.
    5 NI=NAT(II)
      QII=0.
      DO 6 I=IA,IB
      K=(I*(I+1))/2
    6 QII=QII+P(K)
C     F(S,S)
      KA=(IA*(IA+1))/2
      F(KA)=F(KA)+0.5*P(KA)*GSS(NI)+(QII-P(KA))*(GSP(NI)-0.5*HSP(NI))
      IF(NI.LT.3) GO TO 9
      IPLUS=IA+1
      L=KA
      DO 7  J=IPLUS,IB
      M=L+IA
      L=L+J
C     F(P,P)
      F(L)=F(L)+0.5*P(L)*GPP(NI)+P(KA)*(GSP(NI)-0.5*HSP(NI))
     1         +(QII-P(L)-P(KA))*(GP2(NI)-0.5*HPP(NI))
C     F(S,P)
    7 F(M)=F(M)+0.5*P(M)*(3.0*HSP(NI)-GSP(NI))
C     F(P,P*)
      IMINUS=IB-1
      DO 8  J=IPLUS,IMINUS
      IC=J+1
      DO 8  L=IC,IB
      M=(L*(L-1))/2+J
    8 F(M)=F(M)+0.5*P(M)*(3.0*HPP(NI)-GP2(NI))
    9 CONTINUE
C *** CALCULATE THE ELECTRONIC ENERGY.
      CALL ESCF(EF,NORBS,P,F,LM4)
      EE=EF+EH
      IF(KSCF.EQ.1) GO TO 31
C *** DIAGONALISE THE F-MATRIX.
      if(jump.eq.1)goto 701
      CALL GIVENS(NORBS,NROOT,LM2,F,Q,E,C,LM4)
C *** COMPUTE THE DENSITY MATRIX.
      CALL pmatr(C,D,P,OCC,LM2,LM3,LM4,INOUT,NB1,NITER,PL,YL)
C *** TEST FOR SELF-CONSISTENCE.
      EERROR=EE-EEP
      EEP=EE
CCC      IF(NPRINT.GE.2) WRITE(6,601) NITER,EE,EERROR,PL,YL
c      IF(NPRINT.GE.2) WRITE(8,601) NITER,EE,EERROR,PL,YL
      IF(KRESET.EQ.1) GO TO 60
      IF((DABS(EERROR).LT.SCFCRT).AND.(PL.LE.(4.*SCFCRT))) GO TO 30
      GO TO 61
   60 CONTINUE
      IF(DABS(EERROR).LT.SCFF) GO TO 30
   61 CONTINUE
      IF(KITSCF.GT.NITER) GO TO 2
C *** NO SELF-CONSISTENCE.
      WRITE(6,6000)
      WRITE(8,6000)
CCC      WRITE(6,742) EERROR,PL
      WRITE(8,742) EERROR,PL
      IF(KRESET.EQ.1) WRITE(6,820)
      IF(KRESET.EQ.1) WRITE(8,820)
      STOP
C *** SELF-CONSISTENCE ACHIEVED.
  701 continue
   30 CONTINUE
      ITSAVE=NITER
      KSCF=1
      GO TO 2
   31 CONTINUE
C     SAVE FINAL DENSITY AND FOCK MATRIX.
      IF(INOUT.EQ.0) GO TO 32
      REWIND NB1
      WRITE(NB1) P
      CALL CLODA(NB1)
      IF(INOUT.LT.2) GO TO 32
      WRITE(NB3) F
      CALL CLODA(NB3)
   32 CONTINUE
C *** HALF-ELECTRON CORRECTION
      IF(JODD.GT.0) GO TO 51
      IF(IODD.GT.0) GO TO 50
      GO TO 52
   50 CONTINUE
      XI=SPCG(C(1,IODD),C(1,IODD),C(1,IODD),C(1,IODD),W,LM2,LM9)
      EE=EE-0.25*XI
      GO TO 52
   51 CONTINUE
      XI=SPCG(C(1,IODD),C(1,IODD),C(1,IODD),C(1,IODD),W,LM2,LM9)
      XJ=SPCG(C(1,JODD),C(1,JODD),C(1,JODD),C(1,JODD),W,LM2,LM9)
      XK=SPCG(C(1,IODD),C(1,JODD),C(1,JODD),C(1,IODD),W,LM2,LM9)
      EE=EE-0.25*(XI+XJ)-0.5*XK
      IF(IMULT.EQ.1) EE=EE+2.0*XK
   52 CONTINUE
      IF(KRESET.EQ.1) RETURN
      VALUE =ATHEAT+23.061*(EE+ENUCLR-EAT)
      EESAVE=EE
      ENSAVE=ENUCLR
      EPSAVE=-E(NUMB)
      RETURN
  600 FORMAT(//// 5X,'SCF-INFORMATION. NUMBER OF ITERATION NITER, ',
     1  'ELECTRONIC ENERGY EE (IN EV), ENERGY CHANGE DELTAE (IN EV), '
     2  / 5X,'AND MAXIMUM CHANGE DELTAP IN THE DIAGONAL ELEMENTS OF ',
     3  'THE  DENSITY  MATRIX.'// 5X,'NITER',12X,'EE',14X,'DELTAE',
     4  11X,'DELTAP',11X,'LAMBDA'/)
  601 FORMAT(5X,I3,4X,4F17.7)
  742 FORMAT(//10X,'DELTAE= ',F15.7,5X,'DELTAP= ',F15.7///)
  820 FORMAT(10X,'CONVERGENCE PROBLEMS IN GRADIENT CALCULATION'///)
 6000 FORMAT(//10X,'UNABLE TO ACHIEVE SELFCONSISTENCE'/)
      END
C     ******************************************************************
      SUBROUTINE DFOCK(IA,IB,JA,JB,KR,F,P,W,LM4,LM9)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON
     ./FLAG4 / INTSUM
      DIMENSION F(LM4),P(LM4),W(LM9)
      KK=0
      IF(INTSUM.LE.LM9) KK=KR
      DO 4 I=IA,IB
      KA=(I*(I-1))/2
      DO 4 J=IA,I
      KB=(J*(J-1))/2
      IJ=KA+J
      AA=2.
      IF(I.EQ.J) AA=1.
      DO 4 K=JA,JB
      KC=(K*(K-1))/2
      IK=KA+K
      JK=KB+K
      DO 4 L=JA,K
      IL=KA+L
      JL=KB+L
      KL=KC+L
      BB=2.
      IF (K.EQ.L) BB=1.
      KK=KK+1
      A=W(KK)
      F(IJ)= F(IJ) + BB*A*P(KL)
      F(KL)= F(KL) + AA*A*P(IJ)
      A=A*AA*BB*0.125
      F(IK)= F(IK) - A*P(JL)
      F(IL)= F(IL) - A*P(JK)
      F(JK)= F(JK) - A*P(IL)
      F(JL)= F(JL) - A*P(IK)
    4 CONTINUE
      KR=KK
      RETURN
      END
C     ******************************************************************
      SUBROUTINE MFOCK (IA,IB,JA,JB,F,P,WIJ,LM4)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION F(LM4),P(LM4)
      QI=0.
      QJ=0.
      DO 10 I=IA,IB
      K=(I*(I+1))/2
   10 QI=QI+P(K)
      DO 20 J=JA,JB
      K=(J*(J+1))/2
   20 QJ=QJ+P(K)
      DO 30 I=IA,IB
      K=(I*(I+1))/2
   30 F(K)=F(K)+QJ*WIJ
      DO 40 J=JA,JB
      K=(J*(J+1))/2
   40 F(K)=F(K)+QI*WIJ
      DO 50 I=IA,IB
      DO 50 J=JA,JB
      K=(I*(I-1))/2+J
   50 F(K)=F(K)-0.5*P(K)*WIJ
      RETURN
      END
C     ******************************************************************
      SUBROUTINE ESCF (EE,N,P,F,LM4)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     ELECTRONIC ENERGY.
C     *
      DIMENSION P(LM4),F(LM4)
      EE     = 0.
      KMAX   = (N*(N+1))/2
      DO 10 K=1,KMAX
   10 EE     = EE + P(K)*F(K)
      DO 20 I=1,N
      K      = (I*(I+1))/2
   20 EE     = EE - 0.5*P(K)*F(K)
      RETURN
      END
C     ******************************************************************
      FUNCTION SPCG(C1,C2,C3,C4,W,LM2,LM9)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     SPCG CALCULATES THE REPULSION BETWEEN ELECTRON 1 IN MOLECULAR
C     ORBITALS C1,C2 AND ELECTRON 2 IN C3,C4 FOR THE VALENCE SHELL.
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./FLAG4 / INTSUM
     ./NBFILE/ NB1,NB2,NB3,NB4
     ./OPTION/ IOP
     ./REP   / GSS(18),GPP(18),GSP(18),GP2(18),HSP(18),HPP(18)
      DIMENSION C1(LM2),C2(LM2),C3(LM2),C4(LM2),W(LM9)
      SPCG=0.
C *** TWO-CENTRE TERMS.
      IF(NUMAT.EQ.1) GO TO 2
      KK=0
      IF(IOP.LE.0 .AND. INTSUM.GT.LM9) REWIND NB2
      DO 9 II=2,NUMAT
      IA=NFIRST(II)
      IB=NLAST(II)
      IMINUS=II-1
      DO 10 JJ=1,IMINUS
      JA=NFIRST(JJ)
      JB=NLAST(JJ)
C     MINDO, CNDO, INDO.
      IF(IOP.LE.0) GO TO 12
      IJ=(II*(II-1))/2+JJ
      DO 13 I=IA,IB
      DO 13 J=JA,JB
      SPCG=SPCG+W(IJ)*(C1(I)*C2(I)*C3(J)*C4(J)
     1                +C1(J)*C2(J)*C3(I)*C4(I))
   13 CONTINUE
      GO TO 10
C     MNDO.
   12 IF(INTSUM.LE.LM9) GO TO 15
      KK=0
      NO=10**((IB-IA+JB-JA+2)/4)
      READ(NB2) (W(I),I=1,NO)
   15 DO 11 I=IA,IB
      DO 11 J=IA,I
      DO 11 K=JA,JB
      DO 11 L=JA,K
      KK=KK+1
      SPCG=SPCG+W(KK)*(C1(I)*C2(J)*C3(K)*C4(L)
     1               + C1(K)*C2(L)*C3(I)*C4(J) )
      IF(I.NE.J) SPCG=SPCG+W(KK)*(C1(J)*C2(I)*C3(K)*C4(L)
     1                          + C1(K)*C2(L)*C3(J)*C4(I) )
      IF(K.NE.L) SPCG=SPCG+W(KK)*(C1(I)*C2(J)*C3(L)*C4(K)
     1                          + C1(L)*C2(K)*C3(I)*C4(J) )
      IF(I.NE.J .AND. K.NE.L) SPCG=SPCG+W(KK)*(C1(J)*C2(I)*C3(L)*C4(K)
     1                                       + C1(L)*C2(K)*C3(J)*C4(I))
   11 CONTINUE
   10 CONTINUE
    9 CONTINUE
    2 CONTINUE
C *** ONE-CENTRE TERMS.
      IS1=0
      DO 3 I1=1,NUMAT
      IS1=IS1+1
      IZN=NAT(I1)
C     (SS/SS)
      SPCG=SPCG+C1(IS1)*C2(IS1)*C3(IS1)*C4(IS1)*GSS(IZN)
      IF(IZN.LT.3) GO TO 3
      IS=IS1
      IS1=IS1+1
      IX=IS1
      IS1=IS1+1
      IY=IS1
      IS1=IS1+1
      IZ=IS1
C     (PP/PP) FOR P=X,Y,Z
      SPCG=SPCG+GPP(IZN)*
     1  (C1(IX)*C2(IX)*C3(IX)*C4(IX)+
     2   C1(IY)*C2(IY)*C3(IY)*C4(IY)+
     3   C1(IZ)*C2(IZ)*C3(IZ)*C4(IZ) )
C     (SS/PP)+(PP/SS) FOR P=X,Y,Z
      SPCG=SPCG+GSP(IZN)*
     1  (C1(IS)*C2(IS)*C3(IX)*C4(IX)+
     2   C1(IS)*C2(IS)*C3(IY)*C4(IY)+
     3   C1(IS)*C2(IS)*C3(IZ)*C4(IZ)+
     4   C1(IX)*C2(IX)*C3(IS)*C4(IS)+
     5   C1(IY)*C2(IY)*C3(IS)*C4(IS)+
     6   C1(IZ)*C2(IZ)*C3(IS)*C4(IS) )
C     (PP/P,P,)+(P,P,/PP) FOR P.NE.P,=X,Y,Z
      SPCG=SPCG+GP2(IZN)*
     1  (C1(IX)*C2(IX)*C3(IY)*C4(IY)+
     2   C1(IX)*C2(IX)*C3(IZ)*C4(IZ)+
     3   C1(IY)*C2(IY)*C3(IZ)*C4(IZ)+
     4   C1(IY)*C2(IY)*C3(IX)*C4(IX)+
     5   C1(IZ)*C2(IZ)*C3(IX)*C4(IX)+
     6   C1(IZ)*C2(IZ)*C3(IY)*C4(IY) )
      TEMP1=HSP(IZN)
      DO 4 J1=IX,IZ
C     (SP/SP)+(SP/PS)+(PS/SP)+(PS/PS) FOR P=X,Y,Z
      SPCG=SPCG+TEMP1*
     1  (C1(IS)*C2(J1)*C3(J1)*C4(IS)+
     2   C1(IS)*C2(J1)*C3(IS)*C4(J1)+
     3   C1(J1)*C2(IS)*C3(IS)*C4(J1)+
     4   C1(J1)*C2(IS)*C3(J1)*C4(IS) )
    4 CONTINUE
      TEMP1=HPP(IZN)
      DO 5 J1=IX,IZ
      DO 6 K1=IX,IZ
      IF(J1.EQ.K1) GO TO 6
C     (PP,/PP,)+(PP,/P,P)+(P,P/PP,)+(P,P/P,P) FOR P.NE.P,=X,Y,Z
      SPCG=SPCG+TEMP1*
     1  (C1(J1)*C2(K1)*C3(J1)*C4(K1)+
     2   C1(J1)*C2(K1)*C3(K1)*C4(J1) )
    6 CONTINUE
    5 CONTINUE
    3 CONTINUE
      RETURN
      END
C     ******************************************************************
      SUBROUTINE PRTSCF (C,E,F,H,P,LM2,LM3,LM4)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     SCF RESULTS
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./FLAG1 / KTITLE(12),KOMENT(10),KHARGE,KDUMMY(8),ITSAVE
     ./FUNCT / ENERGY,EESAVE,ENSAVE,EPSAVE
     ./HALFE / IMULT,IODD,JODD
     ./HALFX / XIIII,XJJJJ,XIJIJ
     ./LMOUT / INOUT
     ./MXFLAG/ MAXEND
     ./NBFILE/ NB1,NB2,NB3,NB4
     ./ORBITS/ NUMB,NORBS
     ./XSKPRT/ IPUBO,IPUEV,JPRINT,NPRINT
     $/mani/kontrol,iodd1,iodd2,fact,fact2
      DIMENSION C(LM2,LM3),E(LM3),F(LM4),H(LM4),P(LM4)
      dimension ilabo(4)
      data ilabo/4h  S ,4h PX ,4h PY ,4h PZ /
      WRITE(6,700) (KOMENT(I),I=1,10), (KTITLE(I),I=1,12)
      WRITE(8,700) (KOMENT(I),I=1,10), (KTITLE(I),I=1,12)
C     PRINT THE FOCK MATRIX AND THE CORE HAMILTONIAN MATRIX.
      IF (NPRINT.LT.1) GO TO 30
      IF(INOUT.GT.1) REWIND NB3
      IF(INOUT.GT.1) READ(NB3) H
      WRITE(6,703)
c      WRITE(8,703)
      CALL VECPRT(H,LM4,NORBS)
      IF(INOUT.GT.1) READ(NB3) F
      WRITE(6,704)
c      WRITE(8,704)
      CALL VECPRT(F,LM4,NORBS)
      IF(INOUT.GT.1) CALL CLODA(NB3)
   30 CONTINUE
C     OUTPUT FINAL EIGENVALUES, EIGENVECTORS, AND DENSITY MATRIX
      WRITE(6,603)
c      WRITE(8,603)
      CALL MATOUT(C,E,LM3,NORBS,LM2,LM3)
      if(kontrol.eq.97.or.kontrol.eq.98)goto 781
      nvec=lm2*lm3
      rewind 9
      call putvec(9,c,nvec)
      write(9) E
      goto 782
 781  continue
      read(9) E
      dorbe=e(iodd1)-e(numb)
      write(8,824)iodd1,e(iodd1),dorbe
 824  format(///'  IONIZATION FROM ORBITAL',I3,',  ORB. ENEGY=',f9.5,
     $ ',  DIFF. TO HOMO=',f9.5/)
 782  WRITE(6,608)
c      WRITE(8,608)
      CALL VECPRT(P,LM4,NORBS)
C     PRINT ENERGIES.
      EEPEN=EESAVE+ENSAVE
      WRITE(6,600)
c      WRITE(8,600)
      WRITE(6,630) ENERGY
      WRITE(8,630) ENERGY
      WRITE(6,631) EEPEN
      WRITE(8,631) EEPEN
      WRITE(6,632) EESAVE
      WRITE(8,632) EESAVE
      WRITE(6,633) ENSAVE
      WRITE(8,633) ENSAVE
      IF(IMULT.LE.0) GO TO 50
      IF(IMULT.EQ.2) GO TO 40
      SUM= -0.25*XIIII-0.25*XJJJJ-0.5*XIJIJ
      IF(IMULT.EQ.1) SUM=SUM+2.*XIJIJ
      WRITE(6,634) SUM
      WRITE(8,634) SUM
      WRITE(6,636) XIIII,XJJJJ,XIJIJ
      WRITE(8,636) XIIII,XJJJJ,XIJIJ
      GO TO 50
   40 CONTINUE
      SUM= -0.25*XIIII
      WRITE(6,634) SUM
      WRITE(8,634) SUM
      WRITE(6,635) XIIII
      WRITE(8,635) XIIII
   50 CONTINUE
      if(iodd1.eq.0)goto 988
      write(8,888)iodd1
  888 format(///'    MAIN ORBITAL COMPONENTS OF ORBITAL',I4,//' ATOM',
     $ '  TYPE','        ORB. COEFF.','       WEIGHT',/)
      DO 801 I=1,NUMAT
      NI=NAT(I)
      IA=NFIRST(I)
      IB=NLAST(I)
c     write(8,*)i,ni,ia,ib
      do 811 j=ia,ib
      if(dabs(c(j,iodd1)).lt.0.1d0) goto 811
      xx=c(j,iodd1)
      x2=xx*xx
      ityp=j-ia+1
      write(8,889)i,ilabo(ityp),xx,x2
  811 continue
  801 continue
      write(8,887)
  887 format(///)
  889 format(1x,i3,3x,a4,3x,f15.10,3x,f15.10)
  988 IF(MAXEND.LE.3) WRITE(6,637) ITSAVE
c      IF(MAXEND.LE.3) WRITE(8,637) ITSAVE
C     SAVE DENSITY MATRIX, OR EIGENVECTORS AND EIGENVALUES.
      IF(IPUBO.NE.1) GO TO 60
      REWIND NB1
      WRITE(NB1) P
      CALL CLODA(NB1)
      WRITE(6,705) NB1
      WRITE(8,705) NB1
      RETURN
   60 CONTINUE
      IF (IPUEV.NE.1) RETURN
      REWIND NB1
      WRITE(NB1) ((C(J,I),J=1,LM2),I=1,LM3)
      WRITE(NB1) E
      CALL CLODA(NB1)
      WRITE(6,706) NB1
      WRITE(8,706) NB1
      RETURN
  600 FORMAT(1X)
  603 FORMAT(///5X,'EIGENVALUES AND EIGENVECTORS.'//)
  608 FORMAT(///5X,' DENSITY  MATRIX.'/)
  630 FORMAT(///5X,'HEAT OF FORMATION    ',F15.5,' KCAL/MOLE')
  631 FORMAT(   5X,'TOTAL ENERGY         ',F15.5,' EV')
  632 FORMAT(   5X,'ELECTRONIC ENERGY    ',F15.5,' EV')
  633 FORMAT(   5X,'NUCLEAR ENERGY       ',F15.5,' EV')
  634 FORMAT(   5X,'HALF ELECTRON TERM   ',F15.5,' EV')
  635 FORMAT(   5X,'INTEGRAL J11         ',F15.5,' EV')
  636 FORMAT(   5X,'INTEGRAL J11         ',F15.5,' EV'/
     1          5X,'INTEGRAL J22         ',F15.5,' EV'/
     2          5X,'INTEGRAL K12         ',F15.5,' EV')
  637 FORMAT(   5X,'SCF CYCLES           ',I9)
  700 FORMAT(////5X,10A4/5X,12A4)
  703 FORMAT(///5X,'CORE HAMILTONIAN MATRIX.'/)
  704 FORMAT(///5X,'FOCK MATRIX.'/)
  705 FORMAT(// 5X,'THE DENSITY MATRIX HAS BEEN SAVED ON FILE',I3)
  706 FORMAT(// 5X,'THE EIGENVECTORS AND EIGENVALUES HAVE BEEN SAVED',
     1             ' ON FILE',I3)
      END
C     ******************************************************************
      SUBROUTINE DIPOLE (P,LM4)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     POPULATION ANALYSIS, AND CALCULATION OF DIPOLE MOMENT.
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./DIPOL / DD
     ./FLAG1 / KTITLE(12),KOMENT(10),KHARGE,KGEOM(9)
     ./PARDER/ CORE(18),EHEAT(18),EISOL(18)
     ./PAROPT/ USS(18),UPP(18),ZS(18),ZP(18),BS(18),BP(18),ALP(18)
     ./XSKPRT/ IPUBO(3),NPRINT
      DIMENSION P(LM4)
      DIMENSION DIP(4,3)
      DO 1 I=1,4
      DO 1 J=1,3
    1 DIP(I,J)=0.0
      IF(NPRINT.GE.0) WRITE(6,500)
      IF(NPRINT.GE.0) WRITE(8,500)
C *** LOOP OVER ALL ATOMS.
      DO 2 I=1,NUMAT
      NI=NAT(I)
      IA=NFIRST(I)
      IB=NLAST(I)
C *** ATOMIC POPULATIONS.
      W=0.
      DO 7 J=IA,IB
      K=(J*(J+1))/2
    7 W=W+P(K)
      QI=CORE(NI)-W
      IF(NPRINT.GE.0) WRITE(6,510) I,QI,W
      IF(NPRINT.GE.0) WRITE(8,510) I,QI,W
C *** CHARGE CONTRIBUTIONS TO DIPOLE MOMENT.
      DO 8 J=1,3
    8 DIP(J,1)=DIP(J,1)+4.803*QI*COORD(J,I)
C *** HYBRIDIZATION CONTRIBUTIONS TO DIPOLE MOMENT.
      IF(NI.LE.2) GO TO 2
      IF(NI.LE.10) HYF= 469.56193322*SQRT((ZS(NI)*ZP(NI))**5) /
     1                  (ZS(NI)+ZP(NI))**6
      IF(NI.GT.10) HYF=2629.54682607*SQRT((ZS(NI)*ZP(NI))**7) /
     1                 (ZS(NI)+ZP(NI))**8
      DO 5 J=1,3
      L=((IA+J)*(IA+J-1))/2+IA
    5 DIP(J,2)=DIP(J,2)-HYF*P(L)
    2 CONTINUE
      IF(KHARGE.NE.0) RETURN
C *** CALCULATION OF DIPOLE MOMENT.
      DO 3 J=1,3
    3 DIP(J,3)=DIP(J,2)+DIP(J,1)
      DO 4 J=1,3
    4 DIP(4,J)=DSQRT(DIP(1,J)**2+DIP(2,J)**2+DIP(3,J)**2)
      IF(NPRINT.GE.0) WRITE(6,600) ((DIP(I,J),I=1,4),J=1,3)
      IF(NPRINT.GE.0) WRITE(8,600) ((DIP(I,J),I=1,4),J=1,3)
      DD=DIP(4,3)
      RETURN
  500 FORMAT(//// 5X,'NET ATOMIC CHARGES.'// 9X,'ATOM NO.', 5X,
     1  'CHARGE', 6X,'DENSITY'/)
  510 FORMAT(12X,I2,3X,2F12.5)
  600 FORMAT(//// 5X,6HDIPOLE,14X,2HX ,10X,2HY ,10X,2HZ , 8X,5HTOTAL//
     1  5X,12HPOINT-CHARGE,4F12.5/  5X,12HHYBRID      ,4F12.5/
     2  5X,12HSUM         ,4F12.5)
      END
C     ******************************************************************
      SUBROUTINE CIS (C,E1ELN,W,LM2,LM3,LM9)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     CONFIGURATION INTERACTION
C     *
      COMMON
     ./CCIS  / K,L,M,N,LROOT,NC,ELENGY,E(6),ENGYCI(3),
     .         VECTCI(3,3),JFROM(3),JTO(3)
     ./ENERG / ENERGY,ENUCLR,EAT,ATHEAT
     ./FLAG3 / KRESET,IWADE
     ./HALFE / IMULT,IODD,JODD
     ./XCI   / ECI(3),BKCAL(3)
     ./ORBITS/ NUMB,NORBS
c COMMON /ORBITS/ has been added by me: variable NUMB used at label ..
c was not defined.  I.Mayer, Budapest October 1991
      DIMENSION C(LM2,LM3),E1ELN(LM3),W(LM9)
      DIMENSION EDUM(6),Q(15)
      ELENGY=ENERGY
      XKKKK= SPCG (C(1,K),C(1,K),C(1,K),C(1,K),W,LM2,LM9)
      XLLLL= SPCG (C(1,L),C(1,L),C(1,L),C(1,L),W,LM2,LM9)
      XKKLL= SPCG (C(1,K),C(1,K),C(1,L),C(1,L),W,LM2,LM9)
      XKLLK= SPCG (C(1,K),C(1,L),C(1,L),C(1,K),W,LM2,LM9)
      IF(IMULT-1) 10,15,20
C *** 2*2 CLOSED-SHELL CI.
C     DOUBLE EXCITATION FROM K TO L.
   10 CONTINUE
      E(1)= ELENGY
      E(2)= XKLLK
      E(3)= ELENGY + 2.*(E1ELN(L)-E1ELN(K)) - 4.*XKKLL + 2.*XKLLK
     1             + XKKKK + XLLLL
      GO TO 100
C *** 3*3 CI FOR THE FIRST EXCITED SINGLET (HALF ELECTRON METHOD).
C     IN THE FIRST CONFIGURATION, K AND L ARE SINGLY OCCUPIED (HALF
C     ELECTRON SCF MOS). THE OTHER TWO CONFIGURATIONS ARE THE CLOSED
C     SHELLS RESULTING FROM DEEXCITATION FROM L TO K, AND EXCITATION
C     FROM K TO L.
   15 CONTINUE
      XKKKL= SPCG (C(1,K),C(1,K),C(1,K),C(1,L),W,LM2,LM9)
      XLLLK= SPCG (C(1,L),C(1,L),C(1,L),C(1,K),W,LM2,LM9)
      H12=0.5*SQRT(2.)*(XKKKL-XLLLK)
      E(1)= ELENGY
      E(2)= H12
      E(3)= ELENGY+E1ELN(K)-E1ELN(L)-XKKLL-XKLLK+0.5*(XKKKK+XLLLL)
      E(4)=-H12
      E(5)= XKLLK
      E(6)= E(3)+2.*(E1ELN(L)-E1ELN(K))
      GO TO 100
C *** 2*2 CI FOR DOUBLET (HALF ELECTRON METHOD).
   20 CONTINUE
      IF(L.GT.NUMB) GO TO 25
C     EXCITATION FROM K TO L (DOUBLY TO SINGLY OCCUPIED).
      XKLLL= SPCG (C(1,K),C(1,L),C(1,L),C(1,L),W,LM2,LM9)
      E(1)= ELENGY
      E(2)= 0.5*XKLLL
      E(3)= ELENGY+E1ELN(L)-E1ELN(K)+0.5*XLLLL-XKKLL+0.5*XKLLK
      GO TO 100
C     EXCITATION FROM K TO L (SINGLY OCCUPIED TO UNOCCUPIED).
   25 CONTINUE
      XKKKL= SPCG (C(1,K),C(1,K),C(1,K),C(1,L),W,LM2,LM9)
      E(1)= ELENGY
      E(2)= -0.5*XKKKL
      E(3)= ELENGY+E1ELN(L)-E1ELN(K)+0.5*XKKKK-XKKLL+0.5*XKLLK
C *** SOLVE THE CI-MATRIX.
  100 CONTINUE
      LINCI=(NC*(NC+1))/2
      DO 110 I=1,LINCI
  110 EDUM(I)=E(I)
      CALL GIVENS(NC,NC,3,EDUM,Q,ENGYCI,VECTCI,9)
  115 ENERGY=ENGYCI(LROOT)
      IF(KRESET.EQ.1) RETURN
      DO 120 I=1,NC
      J=(I*(I+1))/2
      BKCAL(I)=E(J)
      BKCAL(I)=ATHEAT+23.061*(BKCAL(I) +ENUCLR-EAT)
  120 ECI(I)  =ATHEAT+23.061*(ENGYCI(I)+ENUCLR-EAT)
      RETURN
      END
C     ******************************************************************
      SUBROUTINE PRTCIS
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     CI RESULTS
C     *
      COMMON
     ./CCIS  / KTHMO,LTHMO,MTHMO,NTHMO,LROOT,NCI,ELENGY,
     .         E(6),ENGYCI(3),VECTCI(3,3),JFROM(3),JTO(3)
     ./FUNCT / ENERGY,EESAVE,ENSAVE,EPSAVE
     ./XCI   / ECI(3),BKCAL(3)
      LINCI=(NCI*(NCI+1))/2
      DO 10 IX=1,NCI
      KX=(IX*(IX+1))/2
      E(KX)=E(KX)+ENSAVE
   10 ENGYCI(IX)=ENGYCI(IX)+ENSAVE
      WRITE(6,6615)
      WRITE(6,6620) (I,I=1,NCI)
      WRITE(6,6625) (JFROM(I),JTO(I),I=1,NCI)
      WRITE(6,6640)
      CALL VECPRT(E,LINCI,NCI)
      WRITE(6,6645)
      WRITE(6,6650) (I,I=1,NCI)
      WRITE(6,6660) (BKCAL(I),I=1,NCI)
      WRITE(6,6670)
      CALL MATOUT(VECTCI,ENGYCI,NCI,NCI,3,3)
      WRITE(6,6680) LROOT
      WRITE(6,6650) (I,I=1,NCI)
      WRITE(6,6660) (ECI(I),I=1,NCI)
      RETURN
 6615 FORMAT(////, '  SUMMARY OF CI-RESULTS ' //)
 6620 FORMAT(1H ,' CONFIGURATION',12X,3(I2,6X))
 6625 FORMAT(1H ,'   EXCITATION ',10X,3(I2,' ',I2,3X))
 6640 FORMAT(1H ,///,' THE CI MATRIX BEFORE DIAGONALIZATION (IN EV)')
 6645 FORMAT(1H ,///,' ZERO-ORDER ENERGIES IN KCAL/MOLE')
 6650 FORMAT(1H ,5X,13(I2,8X))
 6660 FORMAT(1H ,13F10.3)
 6670 FORMAT(1H ,///,' LOWEST EIGENVALUES (IN EV) AND EIGENVECTORS',
     .' OF THE CI MATRIX')
 6680 FORMAT(1H ,///,' LOWEST EIGENVALUES - HEATS OF FORMATION',
     .' IN KCAL/MOLE',10X,'LROOT =',I2)
      END
C     ******************************************************************
C     ******************************************************************
      SUBROUTINE PERT (C,E,C12,WW,CC,G,W,LM1,LM2,LM3,LM6,LM7,LM8,LM9,
     1                 NB2,NB3,NROOT,NOPRT)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     PERTURBATION TREATMENT.
C     *
CCCC  LOGICAL NOPRT
      INTEGER NOPRT
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(150)
     ./CIFLAG/ ICJUMP,IOUTCI,IAX,LROOT,IMPEN,IEN2,IPERT(4)
     ./CIMOS / IMOCI(100),NSYM(100)
     ./CIPARM/ ICI1,ICI2,IOUT2,ISUB,ITYPE(8,8)
     ./ENERG / EE,ENUCLR(3)
     ./ORBITS/ NUMB,NORBS
     ./SETCI / KCI
      DIMENSION C(LM2,LM3),E(LM3),C12(LM6),WW(LM6),CC(LM7),G(LM8),W(LM9)
      DIMENSION INDX(50),INDY(50)
      DATA EV / 27.21E0 /
C *** INITIALIZATION.
      LM10   = ICI1+ICI2
      IA     = ICI1+1
      IB     = LM10
      IABSCI = IABS(KCI)
      IOUT2  = IOUTCI
CCCC  IF(NOPRT) IOUT2=-11
      IF(NOPRT .EQ. 1) IOUT2=-11
C *** ASSIGNMENT OF MO SYMMETRY.
      CALL MOSYM (C,E,NSYM,NFIRST,NLAST,LM1,LM2,LM3,IAX,ISUB,NROOT,
     1            NUMAT,IOUTCI,NOPRT)
C *** CONVERT EIGENVALUES TO ATOMIC UNITS.
      DO 10 I=1,LM3
   10 E(I) = E(I)/EV
C *** ORDERING OF AO REPULSION INTEGRALS.
CCC      CALL TIME   (IT1)
      CALL WORDER (CC,W,INDX,INDY,NAT,NFIRST,NLAST,LM1,LM7,LM9,NB2,NB3,
     1             NUMAT,IOUT2)
C *** PERTURBATION TREATMENT (ONE MAIN CONFIGURATION).
      IF(IABSCI.GT.2) GO TO 20
      CALL MOINT2 (C,CC,C12,G,G,W,WW,IMOCI,ITYPE,NSYM,LM2,LM3,LM6,LM7,
     1             LM8,LM9,LM10,NB2,NB3,IA,IB,ICI1,IEN2,IOUT2,NNTOT)
CCC      CALL TIME   (IT2)
      CALL MPEN   (E2,E,G,W,IMOCI,ITYPE,NSYM,LM3,LM9,LM10,NB2,IA,IB,
     1             ICI1,IOUT2,NNTOT)
      GO TO 30
C *** PERTURBATION TREATMENT (TWO MAIN CONFIGURATIONS).
   20 KK=NUMB
      LL=NUMB+1
      CALL MINICI (C,CC,C12,E,WW,LM2,LM3,LM6,LM7,NB3,IOUT2,CA,CB,
     1             DELT,KK,LL)
      CALL MOINT3 (C,CC,C12,G,G,W,WW,IMOCI,ITYPE,NSYM,LM2,LM3,LM6,LM7,
     1             LM8,LM9,LM10,NB2,NB3,IA,IB,ICI1,IEN2,IOUT2,NNTOT,
     2             CA,CB,KK,LL,IABSCI)
CCC      CALL TIME   (IT2)
      CALL DGPERT (E2,E,G,W,IMOCI,ITYPE,NSYM,LM3,LM9,LM10,NB2,IA,IB,
     1             ICI1,IOUT2,NNTOT,CA,CB,DELT,KK,LL,IABSCI)
C *** ELECTRONIC ENERGY.
   30 EE=EE+E2
      KKTOT=LM6*LM6
      IF(NNTOT.GT.LM9) CALL CLODA(NB2)
      IF(KKTOT.GT.LM7) CALL CLODA(NB3)
      IF(IOUT2.LT.-2) RETURN
C *** TIMING.
CCC      CALL TIME   (IT3)
ccc      T1 = 0.00001*FLOAT(IT2-IT1)
ccc      T2 = 0.00001*FLOAT(IT3-IT2)
CCC   WRITE(6,100) T1,T2
      RETURN
  100 FORMAT (///1X,'COMPUTATION TIME FOR'/
     1   1X,'INTEGRAL TRANSFORMATION',F12.3,' SEC'/
     2   1X,'PERTURBATION TREATMENT ',F12.3,' SEC')
      END
C     ******************************************************************
      SUBROUTINE MOSYM (C,E,NSYM,NFIRST,NLAST,LM1,LM2,LM3,IAX,ISUB,N,
     1                  NUMAT,IOUTCI,NOPRT)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     ASSIGNMENT OF MO SYMMETRY (ADAPTED FROM QCPE 174).
C     *
CCCC  LOGICAL NOPRT
      INTEGER NOPRT
      COMMON
     ./SYMMIN/ ICEN(15),ICEN1(24),ICEN2(24),IOZ,NNXY,NRXY,NRYZ,IDZ,IAXE
      DIMENSION C(LM2,LM3),E(LM3),NSYM(LM3),NFIRST(LM1),NLAST(LM1)
      DATA SMALL/0.01E0/,MOD/-1/
C     *
C     INITIALIZE SOME VARIABLES.
C     *
      IF(ISUB.LT.0) RETURN
      DO 5 I=1,N
    5 NSYM(I)= 1
      IF(ISUB.EQ.0) RETURN
      JTEST=0
      NDEGN=0
C     PERMUTATION OF MO COEFFICIENTS.
      IF(IAX.EQ.1) CALL CSWTCH (C,NFIRST,NLAST,LM1,LM2,LM3,IAX,N,NUMAT)
C     *
C     SYMMETRIZE DEGENERATE ORBITALS.
C     *
      IF(IDZ.EQ.0) GO TO 20
      IF(IAXE.EQ.0) IAXE=3
      I=0
  400 I=I+1
      IDUMB=1
      JTEST=1
      MU1=NFIRST(IDZ)-1
      IB=NLAST(IDZ)-MU1
      DO 440 IA=1,IB
      MU = MU1+IA
      IF(DABS(C(MU,I)).LT.SMALL) GO TO 440
      GO TO (410,420,430),IAXE
  410 GO TO (440,440,480,470,440,440,480,470,440),IA
  420 GO TO (440,460,440,450,440,460,440,450,440),IA
  430 GO TO (440,480,470,440,440,480,470,480,470),IA
  440 CONTINUE
      GO TO 500
  450 MU=MU-2
  460 NU=MU+2
      GO TO 490
  470 MU=MU-1
  480 NU=MU+1
  490 CALL DEGENC (MU,NU,C,E,LM2,LM3,I,JTEST,IDUMB,N)
      I=I+1
  500 IF(I.LT.(N-1)) GO TO 400
      JTEST=2
      NDEGN=1
C     *
C     LOOP OVER MOLECULAR ORBITALS AND TEST FOR SYMMETRY.
C     *
   20 I=0
   30 I=I+1
      IDUMB=1
      GO TO (1,2,2,1,1),ISUB
C     CENTERS IN XY PLANE
    1 IF(NNXY.EQ.0) GO TO 100
      DO 50 I1=1,NNXY
      JA=ICEN(I1)
      MU1 = NFIRST(JA)-1
      IB  = NLAST(JA)-MU1
      DO 50 IA=1,IB
      MU=MU1+IA
      IF(DABS(C(MU,I)).GT.SMALL) GO TO (110,110,110,111,110,110,111,
     1  111,110),IA
   50 CONTINUE
C     CENTERS RELATED BY XY PLANE
  100 IF(NRXY.EQ.0) GO TO 2500
      DO 120 I1=1,NRXY,2
      JA=ICEN1(I1)
      KA=ICEN1(I1+1)
      MU1=NFIRST(JA)-1
      NU1=NFIRST(KA)-1
      IB =NLAST(KA)-NU1
      DO 150 IA=1,IB
      MU=MU1+IA
      NU=NU1+IA
      IF(DABS(C(MU,I)).LT.SMALL) GO TO 150
  101 IF(DABS(C(MU,I)-C(NU,I)).LT.SMALL)
     1GO TO (110,110,110,111,110,110,111,111,110),IA
      IF(DABS(C(MU,I)+C(NU,I)).LT.SMALL)
     1GO TO (111,111,111,110,111,111,110,110,111),IA
      CALL DEGENC (MU,NU,C,E,LM2,LM3,I,JTEST,IDUMB,N)
      NDEGN=1
      IF(IDUMB.EQ.0) GO TO 2500
      GO TO 101
  150 CONTINUE
  120 CONTINUE
      GO TO 2500
  110 IXY=+1
      GO TO 2
  111 IXY=-1
    2 IF(ISUB.EQ.1) GO TO 9999
C     USE OF UNIQUE ATOM ON Z AXIS (IN C2V ONLY)
      IF(IOZ.EQ.0) GO TO 200
      MU1=NFIRST(IOZ)-1
      IB =NLAST(IOZ)-MU1
      DO 220 IA=1,IB
      MU=MU1+IA
      IF(DABS(C(MU,I)).GT.SMALL)
     1GO TO (230,231,231,230,230,231,231,230,230),IA
  220 CONTINUE
      GO TO 200
  230 IC2=+1
      GO TO 240
  231 IC2=-1
  240 GO TO (310,311,310,310,310,311,310,310,311),IA
C     CENTERS RELATED BY YZ PLANE AND/OR C2 AXIS.
  200 IF(NRYZ.EQ.0) GO TO 2500
      DO 250 I1=1,NRYZ,2
      JA=ICEN2(I1)
      KA=ICEN2(I1+1)
      MU1=NFIRST(JA)-1
      NU1=NFIRST(KA)-1
      IB =NLAST(KA)-NU1
      DO 270 IA=1,IB
      MU=MU1+IA
      NU=NU1+IA
      IF(DABS(C(MU,I)).LT.SMALL) GO TO 270
  201 IF(DABS(C(MU,I)-C(NU,I)).LT.SMALL)
     1GO TO (210,211,211,210,210,211,211,210,210),IA
      IF(DABS(C(MU,I)+C(NU,I)).LT.SMALL)
     1GO TO (211,210,210,211,211,210,210,211,211),IA
      CALL DEGENC (MU,NU,C,E,LM2,LM3,I,JTEST,IDUMB,N)
      NDEGN=1
      IF(IDUMB.EQ.0) GO TO 2500
      GO TO 201
  270 CONTINUE
  250 CONTINUE
      GO TO 2500
  210 IC2=+1
      GO TO 212
  211 IC2=-1
  212 IF((ISUB.EQ.2) .OR. (ISUB.EQ.5)) GO TO 9999
      IF(DABS(C(MU,I)-C(NU,I)).LT.SMALL)
     1GO TO (310,311,310,310,310,310,311,310,311),IA
      GO TO (311,310,311,311,311,311,310,311,310),IA
  310 IYZ=+1
      GO TO 9999
  311 IYZ=-1
 9999 CONTINUE
C     *
C     ASSIGN SYMMETRY NUMBER TO MOLECULAR ORBITAL.
C     *
      GO TO (1000,1001,1002,1003,1004),ISUB
C     CS
 1000 IF(IXY.EQ.(+1)) NSYM(I)=1
      IF(IXY.EQ.(-1)) NSYM(I)=2
      GO TO 2000
C     C2
 1001 IF(IC2.EQ.(+1)) NSYM(I)=1
      IF(IC2.EQ.(-1)) NSYM(I)=2
      GO TO 2000
C     C2V
 1002 IF((IC2.EQ.(+1)).AND.(IYZ.EQ.(+1))) NSYM(I)=1
      IF((IC2.EQ.(+1)).AND.(IYZ.EQ.(-1))) NSYM(I)=2
      IF((IC2.EQ.(-1)).AND.(IYZ.EQ.(+1))) NSYM(I)=3
      IF((IC2.EQ.(-1)).AND.(IYZ.EQ.(-1))) NSYM(I)=4
      GO TO 2000
C     D2H
 1003 IF(((IC2.EQ.(+1)).AND.(IYZ.EQ.(+1))).AND.(IXY.EQ.(+1))) NSYM(I)=1
      IF(((IC2.EQ.(+1)).AND.(IYZ.EQ.(-1))).AND.(IXY.EQ.(-1))) NSYM(I)=2
      IF(((IC2.EQ.(+1)).AND.(IYZ.EQ.(-1))).AND.(IXY.EQ.(+1))) NSYM(I)=3
      IF(((IC2.EQ.(+1)).AND.(IYZ.EQ.(+1))).AND.(IXY.EQ.(-1))) NSYM(I)=4
      IF(((IC2.EQ.(-1)).AND.(IYZ.EQ.(-1))).AND.(IXY.EQ.(-1))) NSYM(I)=5
      IF(((IC2.EQ.(-1)).AND.(IYZ.EQ.(+1))).AND.(IXY.EQ.(+1))) NSYM(I)=6
      IF(((IC2.EQ.(-1)).AND.(IYZ.EQ.(+1))).AND.(IXY.EQ.(-1))) NSYM(I)=7
      IF(((IC2.EQ.(-1)).AND.(IYZ.EQ.(-1))).AND.(IXY.EQ.(+1))) NSYM(I)=8
      GO TO 2000
C     C2H
 1004 IF((IC2.EQ.(-1)).AND.(IXY.EQ.(+1))) NSYM(I)=1
      IF((IC2.EQ.(-1)).AND.(IXY.EQ.(-1))) NSYM(I)=2
      IF((IC2.EQ.(+1)).AND.(IXY.EQ.(-1))) NSYM(I)=3
      IF((IC2.EQ.(+1)).AND.(IXY.EQ.(+1))) NSYM(I)=4
 2000 IF(I.LT.N) GO TO 30
      GO TO 3000
C     *
C     ERROR EXIT
C     *
 2500 WRITE(6,2510) I,JA,KA
      IF(JTEST.EQ.2) WRITE(6,2520) I
      DO 2505 I=1,N
 2505 NSYM(I)=1
      NDEGN=0
C     *
C     PRINTING SECTION AND EXIT.
C     *
 3000 IF(IAX.EQ.1) CALL CSWTCH (C,NFIRST,NLAST,LM1,LM2,LM3,MOD,N,NUMAT)
CCCC  IF(NOPRT .OR. IOUTCI.LE.-5) RETURN
      IF(NOPRT.EQ.1 .OR. IOUTCI.LE.-5) RETURN
      WRITE(6,2530)
      WRITE(6,2540) (NSYM(I),I=1,N)
      WRITE(6,2550)
      IF(NDEGN.EQ.0) RETURN
      WRITE(6,2560)
      CALL MATOUT (C,E,LM3,LM2,LM2,LM3)
      RETURN
 2510 FORMAT(/1X,'SYMMETRY NOT OBEYED IN VECTOR',I3,' FOR PAIR',2I3/)
 2520 FORMAT(/1X,'SYMMETRIZATION FAILED IN VECTOR',I3/)
 2530 FORMAT(///1X,'MO SYMMETRY NUMBERS.'/)
 2540 FORMAT(1X,20I4)
 2550 FORMAT(1X)
 2560 FORMAT(///1X,'EIGENVALUES AND SYMMETRY-ADAPTED EIGENVECTORS.'/)
      END
C     ******************************************************************
      SUBROUTINE CSWTCH (C,NFIRST,NLAST,LM1,LM2,LM3,MOD,NORBS,NUMAT)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     PERMUTATION OF MO COEFFICIENTS FOR SYMMETRY ASSIGNMENT.
C     *
      DIMENSION C(LM2,LM3),NFIRST(LM1),NLAST(LM1)
      DO 10 I=1,NORBS
      DO 20 J=1,NUMAT
      JA=NFIRST(J)
      JB=NLAST (J)
      IF(JA.EQ.JB) GO TO 20
      IF(MOD.LT.0) GO TO 30
      T=C(JA+3,I)
      C(JA+3,I)=C(JA+1,I)
      C(JA+1,I)=C(JA+2,I)
      C(JA+2,I)=T
      GO TO 20
   30 T=C(JA+3,I)
      C(JA+3,I)=C(JA+2,I)
      C(JA+2,I)=C(JA+1,I)
      C(JA+1,I)=T
   20 CONTINUE
   10 CONTINUE
      RETURN
      END
C     ******************************************************************
      SUBROUTINE DEGENC (NS1,NS2,C,E,LM2,LM3,I,JTEST,IDUMB,N)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     SYMMETRIZATION OF DEGENERATE VECTORS.
C     *
      DIMENSION C(LM2,LM3),E(LM3)
      DATA ZERO/0.E0/,ONE/1.E0/,SMALL/0.01E0/
      IF(IDUMB.EQ.2)GO TO 10
      IF(I.EQ.N) GO TO 7
      IF(DABS(E(I)-E(I+1))-SMALL)   1,1,2
    2 IF(I.EQ.1) GO TO 10
    7 IF(DABS(E(I)-E(I-1))-SMALL)  3,3,10
    3 I=I-1
    1 IF((I+2).GT.N) GO TO 4
      IF(DABS(E(I+1)-E(I+2))-SMALL)   10,10,4
    4 IF(JTEST-1)40,41,10
   41 T1  =DSQRT(C(NS1,I)**2 + C(NS1,I+1)**2)
      BE1 =C(NS1,I)/T1
      DBE =C(NS1,I+1)/T1
      GO TO 42
   40 T1 = C(NS1,I+1)**2-C(NS2,I+1)**2
      IF(T1.EQ.ZERO) GO TO 20
      T2 = (C(NS1,I)*C(NS2,I+1)-C(NS2,I)*C(NS1,I+1))+
     1     (C(NS2,I)*C(NS2,I+1)-C(NS1,I)*C(NS1,I+1))
      D= T2/T1
      BE1 = ONE/DSQRT(ONE+D*D)
      DBE = D*BE1
   42 DO 5  J=1,N
      T1 = C(J,I)
      T2 = C(J,I+1)
      C(J,I) = BE1*T1 + DBE*T2
    5 C(J,I+1) = DBE*T1 - BE1*T2
   20 IDUMB=IDUMB+1
      RETURN
   10 IDUMB=0
      RETURN
      END
C     ******************************************************************
      SUBROUTINE WORDER (CC,W,INDX,INDY,NAT,NFIRST,NLAST,LM1,LM7,LM9,
     1                   NB2,NB3,NUMAT,IOUT2)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     ORDERING OF AO REPULSION INTEGRALS.
C     *
      COMMON
     ./FLAG4 / INTSUM
     ./OPTION/ IOP
     ./REP   / GSS(18),GPP(18),GSP(18),GP2(18),HSP(18),HPP(18)
      DIMENSION CC(LM7),W(LM9)
      DIMENSION INDX(LM1),INDY(LM1),NAT(LM1),NFIRST(LM1),NLAST(LM1)
      DATA ZERO/0.E0/
C     *
C     CONTROL VARIABLES.
C     *
      IF(IOP.EQ.2) GO TO 60
C     MNDO,MINDO,INDO.
      KK=1
      DO 50 I=1,NUMAT
      INDX(I)=KK
      KK=KK+1
      IF(NAT(I).GT.2) KK=KK+9
      INDY(I)=KK-1
   50 CONTINUE
      GO TO 70
C     CNDO.
   60 DO 65 I=1,NUMAT
      INDX(I)=I
   65 INDY(I)=I
      KK=NUMAT+1
C     STORAGE CONTROL.
   70 KMAX=KK-1
      LMAX=LM7/KMAX
      KTOT=KMAX*KMAX
      IF(KMAX.GT.LMAX) KTOT=KMAX*LMAX
      IF(IOP.EQ.2) GO TO 500
C     *
C     SORTING OF INTEGRALS FOR MNDO AND MINDO.
C     *
C     NUMBER OF RECORDS.
      LREC=1+(KMAX-1)/LMAX
      IF(LREC.GT.1) REWIND NB3
C     LOOP OVER RECORDS.
      DO 100 L=1,LREC
      LA=LMAX*(L-1)+1
      LB=LMAX*L
      KP=KMAX*(LA-1)
C     INITIALIZE INTEGRALS.
      DO 110 KK=1,KTOT
  110 CC(KK)=ZERO
C     *
C     LOOP OVER ONE-CENTER INTEGRALS.
C     *
      DO 120 II=1,NUMAT
      IA=INDX(II)
      IF(IA.GT.LB) GO TO 190
      IB=INDY(II)
      IF(IB.LT.LA) GO TO 120
      NI=NAT(II)
      IF(NI.GT.2) GO TO 130
C     HYDROGEN.
      KK=KMAX*(IA-1)+IA-KP
      CC(KK)=GSS(NI)
      GO TO 120
C     HEAVY ATOM.
  130 DO 140 I=IA,IB
      IF(I.LT.LA .OR. I.GT.LB) GO TO 140
      KS =KMAX*(I-1)+IA-1-KP
      KGO=I-IA+1
      KK =KS+KGO
      GO TO (150,160,170,160,180,170,160,180,180,170),KGO
  150 CC(KK   )=GSS(NI)
      CC(KS+3 )=GSP(NI)
      CC(KS+6 )=GSP(NI)
      CC(KS+10)=GSP(NI)
      GO TO 140
  160 CC(KK   )=HSP(NI)
      GO TO 140
  170 CC(KS+1 )=GSP(NI)
      CC(KS+3 )=GP2(NI)
      CC(KS+6 )=GP2(NI)
      CC(KS+10)=GP2(NI)
      CC(KK   )=GPP(NI)
      GO TO 140
  180 CC(KK   )=HPP(NI)
  140 CONTINUE
  120 CONTINUE
C     *
C     LOOP OVER TWO-CENTER INTEGRALS, MNDO.
C     *
  190 IF(NUMAT.EQ.1) GO TO 400
      IF(IOP.GT.0) GO TO 300
      IF(INTSUM.GT.LM9) REWIND NB2
      NA=0
      DO 200 II=2,NUMAT
      IA=INDX(II)
      IB=INDY(II)
      IW=IB-IA+1
      IMINUS=II-1
      DO 200 JJ=1,IMINUS
      JA=INDX(JJ)
      JB=INDY(JJ)
      JW=JB-JA+1
      NO=IW*JW
      IF(INTSUM.LE.LM9) GO TO 210
      READ(NB2) (W(I),I=1,NO)
      NA=0
C     CASE II.GT.JJ.
  210 IF(IA.GT.LB .OR. IB.LT.LA) GO TO 240
      DO 220 I=IA,IB
      IF(I.LT.LA .OR. I.GT.LB) GO TO 220
      KS=KMAX*(I-1)+JA-1-KP
      NS=NA+JW*(I-IA)
      DO 230 J=1,JW
      KK=KS+J
      NN=NS+J
  230 CC(KK)=W(NN)
  220 CONTINUE
C     CASE II.LT.JJ.
  240 IF(JA.GT.LB .OR. JB.LT.LA) GO TO 270
      DO 250 J=JA,JB
      IF(J.LT.LA .OR. J.GT.LB) GO TO 250
      KS=KMAX*(J-1)+IA-1-KP
      NS=NA+J-JA+1-JW
      DO 260 I=1,IW
      KK=KS+I
      NN=NS+JW*I
  260 CC(KK)=W(NN)
  250 CONTINUE
  270 NA=NA+NO
  200 CONTINUE
      GO TO 400
C     *
C     LOOP OVER TWO-CENTER INTEGRALS, MINDO.
C     *
  300 DO 310 II=2,NUMAT
      IA=INDX(II)
      IB=INDY(II)
      IT=NLAST(II)-NFIRST(II)+1
      IMINUS=II-1
      DO 310 JJ=1,IMINUS
      JA=INDX(JJ)
      JB=INDY(JJ)
      JT=NLAST(JJ)-NFIRST(JJ)+1
      IJ=(II*IMINUS)/2+JJ
      WIJ=W(IJ)
C     CASE II.GT.JJ.
      IF(IA.GT.LB .OR. IB.LT.LA) GO TO 340
      DO 320 I=1,IT
      IL=IA-1+(I*(I+1))/2
      IF(IL.LT.LA .OR. IL.GT.LB) GO TO 320
      KS=KMAX*(IL-1)+JA-1-KP
      DO 330 J=1,JT
      JL=(J*(J+1))/2
      KK=KS+JL
  330 CC(KK)=WIJ
  320 CONTINUE
C     CASE II.LT.JJ.
  340 IF(JA.GT.LB .OR. JB.LT.LA) GO TO 310
      DO 350 J=1,JT
      JL=JA-1+(J*(J+1))/2
      IF(JL.LT.LA .OR. JL.GT.LB) GO TO 350
      KS=KMAX*(JL-1)+IA-1-KP
      DO 360 I=1,IT
      IL=(I*(I+1))/2
      KK=KS+IL
  360 CC(KK)=WIJ
  350 CONTINUE
  310 CONTINUE
C     WRITE INTEGRAL RECORD, IF NECESSARY.
  400 IF(LREC.GT.1) WRITE(NB3) CC
  100 CONTINUE
      GO TO 600
C     *
C     SORTING OF INTEGRALS FOR CNDO.
C     *
  500 DO 510 II=1,NUMAT
      NI=NAT(II)
      KK=KMAX*(II-1)+II
      CC(KK)=GSS(NI)
      IF(II.EQ.1) GO TO 510
      IMINUS=II-1
      ID=(II*IMINUS)/2
      DO 520 JJ=1,IMINUS
      NJ=NAT(JJ)
      IJ=ID+JJ
      WIJ=W(IJ)
      KIJ=KMAX*(II-1)+JJ
      KJI=KMAX*(JJ-1)+II
      CC(KIJ)=WIJ
  520 CC(KJI)=WIJ
  510 CONTINUE
C     *
C     DEBUG PRINT.
C     *
  600 IF(IOUT2.LT.1) RETURN
      WRITE(6,700)
      WRITE(6,710) KMAX
      IF(LREC.GT.1) WRITE(6,715) LREC,LMAX,KTOT
      IF(IOUT2.LT.4) RETURN
      IMAX=KMAX
      IF(LREC.EQ.1) GO TO 605
      IMAX=LMAX
      REWIND NB3
      READ(NB3) CC
  605 WRITE(6,720)
      KK=1
      DO 610 I=1,IMAX
      KA=KK
      KB=KA+KMAX-1
      WRITE(6,730) (CC(K),K=KA,KB)
  610 KK=KA+KMAX
      RETURN
  700 FORMAT(////1X,'AO INTEGRALS IN NEW ORDER.'/)
  710 FORMAT(//1X,'THE AO INTEGRALS ARE STORED IN A MATRIX WITH',I4,
     1  ' ROWS AND COLUMNS.')
  715 FORMAT(  1X,'THERE ARE',I4,' RECORDS EACH OF WHICH CONTAINS',I4,
     2  ' COLUMNS AND',I6,' INTEGRALS.')
  720 FORMAT(//1X,'INTEGRALS IN THE FIRST RECORD.'/)
  730 FORMAT(  1X,10F10.5)
      END
