C     ******************************************************************
      SUBROUTINE GUESSP (C,P,LM2,LM3,LM4,KHARGE)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     DEFINITION OF INITIAL DENSITY MATRIX.
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./BOND  / KTRIAL
     ./FLAG2 / MIDDLE,SECADD,TIME1
     ./HALFE / IMULT,IODD,JODD
     ./LMOUT / INOUT
     ./NBFILE/ NB1,NB2,NB3,NB4
     ./ORBITS/ NUMB,NORBS
     ./PARDER/ CORE(18),EHEAT(18),EISOL(18)
     ./XSKPRT/ IPUBO,IPUEV,JPRINT,NPRINT
     $/mani/kontrol,iodd1,iodd2,fact,fact2
      DIMENSION C(LM2,LM3),P(LM4)
      IF(MIDDLE.GT.0) RETURN
      IF(KTRIAL.EQ.1) RETURN
      IF(KTRIAL.EQ.3) GO TO 30
      IF(KTRIAL.EQ.4) GO TO 40
C     COMPUTE DIAGONAL TRIAL DENSITY MATRIX.
      read(5,59,end=100) kontrol,iodd1,iodd2,fact,fact2
   59 format(3i2,2f20.10)
      write(6,*)'mndo4',kontrol,iodd1,iodd2,fact,fact2
      if(kontrol.eq.97.or.kontrol.eq.98) return
100   K      = 0
      YY     = FLOAT(KHARGE)/FLOAT(NORBS)
      DO 10 I=1,NUMAT
      IA     = NFIRST(I)
      IB     = NLAST(I)
      NI     = NAT(I)
      XX     = 1.
      IF(NI.GT.2) XX=0.25
      W      = CORE(NI)*XX-YY
      DO 10 J=IA,IB
      DO 20 L=1,J
      K      = K+1
   20 P(K)   = 0.
      IF((J-IA+1).GT.4) GO TO 10
      P(K)   = W
   10 CONTINUE
      IF(INOUT.GT.0) GO TO 70
      RETURN
C     INITIAL DENSITY MATRIX FROM FILE NB1.
   30 REWIND NB1
      READ(NB1) P
      CALL CLODA (NB1)
      GO TO 60
C     INITIAL DENSITY MATRIX FROM EIGENVECTORS ON FILE NB1.
   40 REWIND NB1
      READ (NB1) ((C(J,I),J=1,LM2),I=1,LM3)
      CALL CLODA (NB1)
      KK     = 0
      DO 50 I=1,LM2
      DO 50 J=1,I
      KK     = KK+1
      P(KK)  = 0.
      DO 50 K=1,NUMB
      OCCNM  = 2.
      IF(K.EQ.IODD .OR. K.EQ.JODD) OCCNM=1.
   50 P(KK)  = P(KK)+OCCNM*C(I,K)*C(J,K)
C     PRINTING SECTION.
   60 IF(JPRINT.LT.0) GO TO 70
      WRITE(6,500)
      CALL VECPRT (P,LM4,NORBS)
C     SAVE DENSITY MATRIX ON FILE NB1.
   70 IF(INOUT.EQ.0 .OR. KTRIAL.EQ.3) RETURN
      REWIND NB1
      WRITE(NB1) P
      CALL CLODA(NB1)
      RETURN
  500 FORMAT (// 5X,'INITIAL DENSITY MATRIX')
      END
C     ******************************************************************
C     ******************************************************************
      SUBROUTINE SCF (A,LM5)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     SCF SECTION OF THE PROGRAM
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./ERG   / ENERGY,G(99)
     ./FLAG3 / KRESET,IWADE
     ./XDER  / COLD(3,50)
      DIMENSION A(LM5)
      CALL SCFCAL (A,LM5)
      IF(IWADE.EQ.-1) RETURN
      DO 10 I=1,NUMAT
      DO 10 J=1,3
   10 COLD(J,I)=COORD(J,I)
      CALL DERIV (A,G,LM5)
      RETURN
      END
C     ******************************************************************
      SUBROUTINE DERIV (C,G,LM5)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     GRADIENTS OF THE ENERGY
C     *
      COMMON
     ./DENERG/ DENER
     ./DFP   / SET(99),NVAR
     ./FLAG3 / KRESET,IWADE
     ./FUNCT / EVALUE,EESAVE,ENSAVE,EPSAVE
     ./PARM1 / A(3,50),NA(203)
     ./PARM3 / LOC(2,99)
     ./SKIPA / IGRAD,ISKPA,NWSKP,QUADRS
     ./VVV   / CHANGE(3),DELTA(3),XFAC,YFAC
      DIMENSION C(LM5),G(99)
      LOGICAL QUADRS
      KRESET=1
      IF(NWSKP.GT.0) WRITE(6,51)
      IF(NWSKP.GT.0) WRITE(6,50)
      DO 20 I=1,NVAR
      K=LOC(1,I)
      L=LOC(2,I)
      XSTORE=A(L,K)
      A(L,K)=XSTORE+DELTA(L)
      CALL SYMTRY(-1)
      CALL GMETRY(-1)
      CALL SCFCAL (C,LM5)
      AA=DENER
      A(L,K)=XSTORE-DELTA(L)
      CALL SYMTRY(-1)
      CALL GMETRY(-1)
      CALL SCFCAL (C,LM5)
      A(L,K)=XSTORE
      BB=AA-DENER
      G(I)=BB/(2.*DELTA(L))
      IF(NWSKP.GT.0) WRITE(6,52) I,DENER,EVALUE,AA,G(I)
   20 CONTINUE
      IF(NWSKP.GT.0) WRITE(6,51)
      CALL SYMTRY(-1)
      CALL GMETRY(-1)
      KRESET=0
      RETURN
   50 FORMAT(1H , 5X,'VARIABLE',5X,'F(X-DELTA)',9X,'F(X)',9X,'F(X+DELTA)
     1',7X,'GRADIENT')
   51 FORMAT(/)
   52 FORMAT(6X,I5,3X,4F16.9)
      END
C     ******************************************************************
      SUBROUTINE SCFCAL (A,LM5)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     SCF CALCULATION AND CORRELATION TREATMENT.
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./CYCLES/ NCYC,NSCF
     ./DENERG/ DENER
     ./ENERG / EE,ENUCLR,EAT,ATHEAT
     ./ERG   / ENERGY,G(99)
     ./FLAG3 / KRESET,IWADE
     ./FLAG4 / INTSUM
     ./FUNCT / VALUE,EESAVE,ENSAVE,EPSAVE
     ./LIMITS/ LM1,LM2,LM3,LM4,LMA,LM6,LM7,LM8,LM9
     ./LMPERT/ LP1,LP2,LP3,LP4,LP5,LP6
     ./LMSCF / LS1,LS2,LS3,LS4,LS5,LS6,LS7,LS8
     ./MXFLAG/ MAXEND
     ./NBFILE/ NB1,NB2,NB3,NB4
      COMMON
     ./OPTION/ IOP
     ./ORBITS/ NUMB,NORBS,NMOS
     ./OVERLY/ IOV,JOV,KOV,LOV
     ./SETCI / KCI
     ./SKIPA / IGRAD,ISKPA,NWSKP,QUADRS
     ./WREP  / W(1275)
     ./XSKPRT/ IPUBO(3),NPRINT
     $/mani/kontrol,iodd1,iodd2,bondlim,cutoff
      common /parti/ ept(50,50),ept0(50,50),nept,limept
      DIMENSION A(LM5),ikell(500,2)
      LOGICAL NOCI,NOPRT,QUADRS
C *** SCF CALCULATION.
CCC      CALL LOAD(3)
      IF(IOP.LE.0) CALL HCORE (A,A(LS7),A(LS8),W,LM4,LM9)
CCC   IF(IOP.EQ.1) CALL MINDO (A,A(LS7),A(LS8),W,LM4,LM9)
CCC   IF(IOP.GT.1) CALL CNDO  (A,A(LS7),A(LS8),W,LM4,LM9)
CCC      IF(ISKPA.EQ.0 .AND. KRESET.EQ.1) CALL UNLOAD(3)
      IF(ISKPA.EQ.0 .AND. KRESET.EQ.1) RETURN
      NOCI   = KCI.EQ.0 .OR. (KCI.LT.0 .AND. LOV.NE.0 .AND. LOV.NE.4)
      NOPRT  = KRESET.EQ.1 .OR. (MAXEND.GT.3 .AND. LOV.NE.4)
      NROOT  = LM3
      IF(NOPRT) NROOT=NMOS
      CALL ITER (A,A(LS2),A(LS3),A(LS4),A(LS5),A(LS6),A(LS7),A(LS8),
     1           W,LM2,LM3,LM4,LM9,NROOT)
      EEP    = EE
C     SCF OUTPUT.
      IF(NOPRT .OR. NPRINT.LT.0) GO TO 10
      CALL PRTSCF (A,A(LS2),A(LS6),A(LS7),A(LS8),LM2,LM3,LM4)
      CALL partic(A,A(LS2),A(LS3),A(LS4),A(LS5),A(LS6),A(LS7),A(LS8),
     1           W,LM2,LM3,LM4,LM9,NROOT)
      if(kontrol.eq.97.or.kontrol.eq.98) call getvec(9,ept0,limept)
      num1=numat-1
      call mtprin(numat,8)
      if(kontrol.ne.97.and.kontrol.ne.98)goto 74
      write(8,*)'limits:',bondlim,cutoff
      ifut=1
      do 73 i=1,num1
      i1=i+1
      do 73 j=i1,numat
      ept(i,j)=ept(i,j)-ept0(i,j)
      if(DABS(ept(j,i)).lt.bondlim.or.dabs(ept(i,j)).lt.cutoff) then
c            ept(i,j)=0.d0
             goto 73
       else
             ikell(ifut,1)=i
             ikell(ifut,2)=j
             ifut=ifut+1
      end if
  73  continue
      write(8,875)
  875 format(///,15x,'APPRECIABLY CHANGING BOND ENERGIES:',//,
     $ 3X,'I',3X,'J',10X,'  MOLECULE',15X,'ION',12x,'BOND WEAKENING'/)
      ifin=ifut-1
      if(ifin.eq.0) goto 74
      if(ifin.eq.1) go to 77
      if1=ifin-1
      do 178 ii=1,if1
      do 178 jj=ii,ifin
      i1=ikell(ii,1)
      j1=ikell(ii,2)
      i2=ikell(jj,1)
      j2=ikell(jj,2)
      if(ept(i1,j1).gt.ept(i2,j2))goto 178
      ikell(ii,1)=i2
      ikell(ii,2)=j2
      ikell(jj,1)=i1
      ikell(jj,2)=j1
 178  continue
  77  do 75 ii=1,ifin
      i=ikell(ii,1)
      j=ikell(ii,2)
   75 write(8,874)i,j,ept0(j,i),ept(j,i),ept(i,j)
  874 format(2i4,3f20.4)
  74  continue
      CALL DIPOLE (A(LS8),LM4)
C *** MINIMAL CONFIGURATION INTERACTION.
   10 IF(NOCI .OR. IABS(KCI).GT.1) GO TO 20
      CALL CIS (A,A(LS2),W,LM2,LM3,LM9)
      IF(NOPRT .OR. NPRINT.LT.0) GO TO 20
      CALL PRTCIS
CCC   20 CALL UNLOAD(3)
20      IF(IOP.LE.0 .AND. INTSUM.GT.LM9) CALL CLODA(NB2)
C *** INTEGRAL TRANSFORMATION AND PERTURBATION TREATMENT.
      IF(NOCI .OR. IABS(KCI).LT.2) GO TO 30
CCC      CALL LOAD(10)
      CALL PERT (A,A(LP2),A(LP3),A(LP4),A(LP5),A(LP6),W,LM1,LM2,LM3,
     1           LM6,LM7,LM8,LM9,NB2,NB3,NROOT,NOPRT)
CCC      CALL UNLOAD(10)
C *** HEAT OF FORMATION.
   30 IF(KCI.LT.0) EE=EEP
      DENER  = ATHEAT + 23.061*(EE+ENUCLR-EAT)
      NSCF   = NSCF+1
      IF(KRESET.EQ.1) RETURN
      ENERGY = DENER
      VALUE  = DENER
      RETURN
      END
C     ******************************************************************
      SUBROUTINE HCORE(F,H,P,W,LM4,LM9)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     CORE HAMILTONIAN FOR MNDO.
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./DENERG/ DENER
     ./ENERG / EE,ENUCLR,EAT,ATHEAT
     ./EXTRA / RI(22),CORE(4,2),T(5),X(3),Y(3),Z(3)
     ./FLAG3 / KRESET,IWADE
     ./FLAG4 / INTSUM
     ./NBFILE/ NB1,NB2,NB3,NB4
     ./ORBITS/ NUMB,NORBS
     ./PARDER/ TORE(18),EHEAT(18),EISOL(18)
     ./PAROPT/ USS(18),UPP(18),ZS(18),ZP(18),BETAS(18),BETAP(18),ALP(18)
     ./PASS1 / NI,NJ,R,GAM,NBOND,II
     ./SKIPA / IGRAD,ISKPA,NWSKP,QUADRS
     ./XDER  / COLD(3,50)
     $ /parti/ ept(50,50)
      DIMENSION F(LM4),H(LM4),P(LM4),W(LM9)
      DIMENSION DCL(3),DIF(3)
      LOGICAL QUADRS
C *** INITIALIZE SOME VARIABLES.
      LIN=(NORBS*(NORBS+1))/2
      IJUMP=0
      IF(ISKPA.EQ.0 .AND. KRESET.EQ.1) IJUMP=1
      DO 10 I=1,LIN
      F(I)=0.
   10 H(I)=0.
      KR=0
      KS=0
      ENUCLR=0.
      TOLER =1.E-12
C     COMPUTE NUMBER OF REPULSION INTEGRALS.
      INTSUM=0
      IF(NUMAT.LE.1) GO TO 12
      DO 11 I=2,NUMAT
      INTA=NLAST(I)-NFIRST(I)+1
      IMINUS=I-1
      DO 11 J=1,IMINUS
      INTB=NLAST(J)-NFIRST(J)+1
   11 INTSUM=INTSUM+10**((INTA+INTB)/4)
      IF(IJUMP.EQ.0 .AND. INTSUM.GT.LM9) REWIND NB2
   12 CONTINUE
C *** ONE-CENTER TERMS.
      DO 80  I=1,NUMAT
      NI=NAT(I)
      IA=NFIRST(I)
      IB=NLAST(I)
      IF(IJUMP.EQ.1) GO TO 30
      LL=(IA*(IA+1))/2
      H(LL)=USS(NI)
      IF(NI.LT.3) GO TO 30
      IC=IA+1
      DO 20 J=IC,IB
      LL=(J*(J+1))/2
   20 H(LL)=UPP(NI)
C *** TWO-CENTER TERMS.
   30 IMINUS=I-1
      IF(IMINUS.EQ.0) GO TO 80
      DO 70  J=1,IMINUS
      NJ=NAT(J)
      JA=NFIRST(J)
      JB=NLAST(J)
C     COMPUTE THE INTERATOMIC DISTANCE.
      X(1)= COORD(1,I)-COORD(1,J)
      X(2)= COORD(2,I)-COORD(2,J)
      X(3)= COORD(3,I)-COORD(3,J)
      Z(3)= X(1)*X(1)+X(2)*X(2)
      R= SQRT(X(3)*X(3)+Z(3))
C     CHECK FOR GRADIENT CALCULATION.
      IF(IJUMP.EQ.0) GO TO 50
      DO 40 K=1,3
      DCL(K)=COLD(K,I)-COLD(K,J)
      DIF(K)=X(K)-DCL(K)
   40 DIF(K)=DIF(K)*DIF(K)
      IF(DIF(1).GE.TOLER) GO TO 50
      IF(DIF(2).GE.TOLER) GO TO 50
      IF(DIF(3).LT.TOLER) GO TO 70
   50 CONTINUE
C     COMPUTE THE ROTATION MATRIX ELEMENTS TO CONVERT FROM LOCAL TO
C     MOLECULAR COORDINATES.
      CALL ROTMAT
      R=R/0.529167
C     COMPUTE THE CORE RESONANCE INTEGRALS.
      CALL BETAIJ(IA,JA,H,LM4)
C     COMPUTE THE REPULSION INTEGRALS, AND CORE-ELECTRON ATTRACTIONS.
C     INTEGRALS.
      CALL ROTATE (IA,IB,JA,JB,KR,H,W,LM4,LM9)
      R=R*0.529167
C     ENUCLR IS SUMMED OVER CORE-CORE REPULSION INTEGRALS.
      SCALE=1.0+EXP(-ALP(NI)*R)+EXP(-ALP(NJ)*R)
      NT=NI+NJ
      IF (NT.LT.8 .OR. NT.GT.9) GO TO 60
      IF (NI.EQ.7 .OR. NI.EQ.8) SCALE=SCALE+(R-1.)*EXP(-ALP(NI)*R)
      IF (NJ.EQ.7 .OR. NJ.EQ.8) SCALE=SCALE+(R-1.)*EXP(-ALP(NJ)*R)
   60 CONTINUE
      anuctm=TORE(NI)*TORE(NJ)*GAM*SCALE
      ENUCLR=ENUCLR+anuctm
      ept(i,j)=anuctm
      ept(j,i)=anuctm
C     PSEUDO-FOCK MATRIX FOR GRADIENTS.
      IF(IJUMP.EQ.1) CALL DFOCK (IA,IB,JA,JB,KS,F,P,W,LM4,LM9)
   70 CONTINUE
   80 CONTINUE
      IF(IJUMP.EQ.0) RETURN
C *** ENERGY FOR GRADIENT CALCULATION.
      DO 90 I=1,LIN
   90 F(I)=F(I)+H(I)
      CALL ESCF (EF,NORBS,P,F,LM4)
      CALL ESCF (EH,NORBS,P,H,LM4)
      EE=EF+EH
      DENER= 23.061*(EE+ENUCLR)
      RETURN
      END
C     ******************************************************************
      SUBROUTINE ROTMAT
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     ROTATION MATRIX.
C     *
      COMMON
     ./EXTRA / RI(22),CORE(4,2),T(5),X(3),Y(3),Z(3)
     ./PASS1 / NI,NJ,R,GAM,NBOND,II
      A= 1./R
      X(1)= X(1)*A
      X(2)= X(2)*A
      X(3)= X(3)*A
      Z(3)= SQRT(Z(3))*A
      IF(Z(3).LT.0.000001) GO TO 10
      A=1.0/Z(3)
      Y(1)= A*X(2)
      Y(2)=-A*X(1)
      Y(3)=0.
      Z(1)= A*X(1)*X(3)
      Z(2)= A*X(2)*X(3)
      Z(3)=-Z(3)
      RETURN
   10 Y(1)= 0.
      Y(2)= 1.
      Y(3)= 0.
      Z(1)= 1.
      Z(2)= 0.
      RETURN
      END
C     ******************************************************************
      SUBROUTINE BETAIJ(IA,JA,H,LM4)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     CORE RESONANCE INTEGRALS FOR MNDO.
C     *
      COMMON
     ./EXTRA / RI(22),CORE(4,2),T(5),X(3),Y(3),Z(3)
     ./PAROPT/ USS(18),UPP(18),ZS(18),ZP(18),BETAS(18),BETAP(18),ALP(18)
     ./PASS1 / NI,NJ,R,GAM,NBOND,II
      DIMENSION H(LM4)
      CALL OVERLP
C     S(I)/S(J)
      M=(IA*(IA-1))/2+JA
      H(M)= 0.5*(BETAS(NI)+BETAS(NJ))*T(1)
      IF(NI.LT.3 .AND. NJ.LT.3) RETURN
C     S(I)/P(J)
      IF(NJ.LT.3) GO TO 6
      A= 0.5*(BETAS(NI)+BETAP(NJ))*T(2)
      DO 5  K=1,3
      M=M+1
    5 H(M)=A*X(K)
      IF(NI.LT.3) RETURN
C     P(I)/S(J)
    6 A= 0.5*(BETAP(NI)+BETAS(NJ))*T(3)
      DO 7  K=1,3
      M= IA+K
      M= (M*(M-1))/2+JA
    7 H(M)=A*X(K)
      IF(NJ.LT.3) RETURN
C     P(I)/P(J)
      A= 0.5*(BETAP(NI)+BETAP(NJ))
      DO 8  K=1,3
      N= IA+K
      N= (N*(N-1))/2
      DO 8  L=1,3
      M= N+JA+L
      FF= 0.
      IF(K.EQ.L) FF=1.
      H(M)=A*(X(K)*X(L)*T(4)+(FF-X(K)*X(L))*T(5))
    8 CONTINUE
      RETURN
      END
C     ******************************************************************
      SUBROUTINE OVERLP
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     OVERLAP INTEGRALS
C     *
      COMMON
     ./EXTRA / RICORE(30),Z(5),XYZ(9)
     ./PAROPT/ USS(18),UPP(18),ZS(18),ZP(18),BETAS(18),BETAP(18),ALP(18)
     ./PASS1 / NA,NB,RAB,GIJ,NBOND,II
     ./SETC  / A(7),B(7),SA,SB,FACTOR,ISP,IPS
      ESA=ZS(NA)
      EPA=ZP(NA)
      ESB=ZS(NB)
      EPB=ZP(NB)
      DO 4 ID=1,5
    4 Z(ID)=0.
      CALL BONTYP
      GO TO (15,16,18,17,19,20) ,II
C *** THE ORDERING OF THE ELEMENTS WITHIN Z IS
C     Z(1)=(S(B)/S(A))   Z(2)=(P-SIGMA(B)/S(A))   Z(3)=(S(B)/P-SIGMA(A))
C     Z(4)=(P-SIGMA(B)/P-SIGMA(A))                Z(5)=(P-PI(B)/P-PI(A))
C     *
C *** FIRST ROW - FIRST ROW OVERLAPS
   15 CALL SET(ESA,ESB)
    5 Z(1)=0.25*SQRT((SA*SB*RAB*RAB)**3)*(A(3)*B(1)-B(3)*A(1))
      RETURN
C *** FIRST ROW - SECOND ROW OVERLAPS
   16 CALL SET(ESA,ESB)
    6 W=SQRT((SA**3)*(SB**5))*(RAB**4)*0.125
      Z(1)=W*SQRT(1.0/3.0)*(A(4)*B(1)-B(4)*A(1)+A(3)*B(2)-B(3)*A(2))
      IF(NA.GT.1) CALL SET(EPA,ESB)
      IF(NB.GT.1) CALL SET(ESA,EPB)
      W=SQRT((SA**3)*(SB**5))*(RAB**4)*0.125
      Z(ISP)=W*(A(3)*B(1)-B(3)*A(1)+A(4)*B(2)-B(4)*A(2))*FACTOR
      RETURN
C *** FIRST ROW - THIRD ROW OVERLAPS
   17 CALL SET(ESA,ESB)
    7 W=SQRT((SA**3)*(SB**7)/7.5)*(RAB**5)*0.0625
      Z(1)=W*(A(5)*B(1)-B(5)*A(1)+2.0*(A(4)*B(2)-B(4)*A(2)))/SQRT(3.0)
      IF(NA.GT.1) CALL SET(EPA,ESB)
      IF(NB.GT.1) CALL SET(ESA,EPB)
      W=SQRT((SA**3)*(SB**7)/7.5)*(RAB**5)*0.0625
      Z(ISP)=W*FACTOR*(A(4)*(B(1)+B(3))-B(4)*(A(1)+A(3))
     1                +B(2)*(A(3)+A(5))-A(2)*(B(3)+B(5)))
      RETURN
C *** SECOND ROW - SECOND ROW OVERLAPS
   18 CALL SET(ESA,ESB)
    8 W=SQRT((SA*SB)**5)*(RAB**5)*0.0625
      RT3=1.0/SQRT(3.0)
      Z(1)=W*(A(5)*B(1)+B(5)*A(1)-2.0*A(3)*B(3))/3.0
      CALL SET(ESA,EPB)
      IF(NA.GT.NB) CALL SET(EPA,ESB)
      W=SQRT((SA*SB)**5)*(RAB**5)*0.0625
      D=A(4)*(B(1)-B(3))-A(2)*(B(3)-B(5))
      E=B(4)*(A(1)-A(3))-B(2)*(A(3)-A(5))
      Z(ISP)=W*RT3*FACTOR*(D+E)
      CALL SET(EPA,ESB)
      IF(NA.GT.NB) CALL SET(ESA,EPB)
      W=SQRT((SA*SB)**5)*(RAB**5)*0.0625
      D=A(4)*(B(1)-B(3))-A(2)*(B(3)-B(5))
      E=B(4)*(A(1)-A(3))-B(2)*(A(3)-A(5))
      Z(IPS)=W*RT3*FACTOR*(E-D)
      CALL SET(EPA,EPB)
      W=SQRT((SA*SB)**5)*(RAB**5)*0.0625
      Z(4)=W*(B(3)*(A(5)+A(1))-A(3)*(B(5)+B(1)))
      Z(5)=0.5*W*(A(5)*(B(1)-B(3))-B(5)*(A(1)-A(3))-A(3)*B(1)+B(3)*A(1))
      RETURN
C *** SECOND ROW - THIRD ROW OVERLAPS
   19 CALL SET(ESA,ESB)
    9 W=SQRT((SA**5)*(SB**7)/7.5)*(RAB**6)*0.03125
      RT3=1.0/SQRT(3.0)
      Z(1)=W*(A(6)*B(1)+A(5)*B(2)-2.0*(A(4)*B(3)+A(3)*B(4))+A(2)*B(5)
     1       +A(1)*B(6))/3.0
      CALL SET(ESA,EPB)
      IF(NA.GT.NB) CALL SET(EPA,ESB)
      W=SQRT((SA**5)*(SB**7)/7.5)*(RAB**6)*0.03125
      Z(ISP)=W*RT3*FACTOR*(A(6)*B(2)+A(5)*B(1)-2.0*(A(4)*B(4)+A(3)*B(3))
     1                    +A(2)*B(6)+A(1)*B(5))
      CALL SET(EPA,ESB)
      IF(NA.GT.NB) CALL SET(ESA,EPB)
      W=SQRT((SA**5)*SB**7 /7.5)*(RAB**6)*0.03125
      Z(IPS)=W*RT3*FACTOR*(A(5)*(2.0*B(3)-B(1))-B(5)*(2.0*A(3)-A(1))
     1                    -A(2)*(B(6)-2.0*B(4))+B(2)*(A(6)-2.0*A(4)))
      CALL SET(EPA,EPB)
      W=SQRT((SA**5)*SB**7 /7.5)*(RAB**6)*0.03125
      Z(4)=W*(B(4)*(A(1)+A(5))-A(4)*(B(1)+B(5))+B(3)*(A(2)+A(6))
     1      -A(3)*(B(2)+B(6)))
      Z(5)=0.5*W*(A(6)*(B(1)-B(3))-B(6)*(A(1)-A(3))+A(5)*(B(2)-B(4))
     1       -B(5)*(A(2)-A(4))-A(4)*B(1)+B(4)*A(1)-A(3)*B(2)+B(3)*A(2))
      RETURN
C *** THIRD ROW - THIRD ROW OVERLAPS
   20 CALL SET(ESA,ESB)
   10 W=SQRT((SA*SB*RAB*RAB)**7)/480.0
      RT3=1.0/SQRT(3.0)
      Z(1)=W*(A(7)*B(1)-3.0*(A(5)*B(3)-A(3)*B(5))-A(1)*B(7))/3.0
      CALL SET(ESA,EPB)
      IF(NA.GT.NB) CALL SET(EPA,ESB)
      W=SQRT((SA*SB*RAB*RAB)**7)/480.
      D=A(6)*(B(1)-B(3))-2.0*A(4)*(B(3)-B(5))+A(2)*(B(5)-B(7))
      E=B(6)*(A(1)-A(3))-2.0*B(4)*(A(3)-A(5))+B(2)*(A(5)-A(7))
      Z(ISP)=W*RT3*FACTOR*(D-E)
      CALL SET(EPA,ESB)
      IF(NA.GT.NB) CALL SET(ESA,EPB)
      W=SQRT((SA*SB*RAB*RAB)**7)/480.
      D=A(6)*(B(1)-B(3))-2.0*A(4)*(B(3)-B(5))+A(2)*(B(5)-B(7))
      E=B(6)*(A(1)-A(3))-2.0*B(4)*(A(3)-A(5))+B(2)*(A(5)-A(7))
      Z(IPS)=W*RT3*FACTOR*(-D-E)
      CALL SET(EPA,EPB)
      W=SQRT((SA*SB*RAB*RAB)**7)/480.
      Z(4)=W*(A(3)*(B(7)+2.0*B(3))-A(5)*(B(1)+2.0*B(5))-B(5)*A(1)
     1      +A(7)*B(3))
      Z(5)=0.5*W*(A(7)*(B(1)-B(3))+B(7)*(A(1)-A(3))
     1   +A(5)*(B(5)-B(3)-B(1))+B(5)*(A(5)-A(3)-A(1))+2.0*A(3)*B(3))
      RETURN
      END
C     ******************************************************************
      SUBROUTINE BONTYP
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON
     ./DNBND / INMB(18),III(18)
     ./PASS1 / NI,NJ,RIJ,GIJ,NBOND,II
      JMAX=MAX0(INMB(NI),INMB(NJ))
      JMIN=MIN0(INMB(NI),INMB(NJ))
      NBOND=(JMAX*(JMAX-1))/2+JMIN
      JMAX=MAX0(III(NI),III(NJ))
      JMIN=MIN0(III(NI),III(NJ))
      II=(JMAX*(JMAX-1))/2+JMIN
      RETURN
      END
C     ******************************************************************
      SUBROUTINE SET(S1,S2)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON
     ./PASS1 / NA,NB,RAB,GIJ,NBOND,II
     ./SETC  / A(7),B(7),SA,SB,FACTOR,ISP,IPS
      IF(NA.GT.NB) GO TO 1
      ISP=2
      IPS=3
      FACTOR = +1.0
      SA=S1
      SB=S2
      GO TO 2
    1 ISP=3
      IPS=2
      FACTOR = -1.0
      SA=S2
      SB=S1
    2 J=II+2
      IF(II.GT.3) J=J-1
      ALPHA=0.5*RAB*(SA+SB)
      BETA=0.5*RAB*(SB-SA)
      JCALL=J-1
      CALL AINTGS(ALPHA,JCALL)
      CALL BINTGS(BETA,JCALL)
      RETURN
      END
C     ******************************************************************
      SUBROUTINE AINTGS(X,K)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/SETC  / A(7),B(7),SDUM(3),IDUM(2)
      C=EXP(-X)
      A(1)=C/X
      DO 10 I=1,K
      A(I+1)=(A(I)*FLOAT(I)+C)/X
   10 CONTINUE
      RETURN
      END
C     ******************************************************************
      SUBROUTINE BINTGS(X,K)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/SETC  / A(7),B(7),SDUM(3),IDUM(2)
      COMMON/XFACT / FACT(15)
      KK=K+1
      ABSX=DABS(X)
      IF(ABSX.GT.3.) GO TO 15
      IF(ABSX.LE.2.) GO TO 10
      IF(K.LE.10) GO TO 15
      LAST=15
      GO TO 17
   10 IF(ABSX.LE.1.) GO TO 11
      IF(K.LE.7) GO TO 15
      LAST=12
      GO TO 17
   11 IF(ABSX.LE.0.5) GO TO 12
      IF(K.LE.5) GO TO 15
      LAST=7
      GO TO 17
   12 IF(ABSX.LE.0.000001) GO TO 22
      LAST=6
      GO TO 17
   15 EXPX=EXP(X)
      EXPMX=1.0/EXPX
      B(1)=(EXPX-EXPMX)/X
      DO 16 I=1,K
   16 B(I+1)= (FLOAT(I)*B(I)+(-1.0)**I*EXPX-EXPMX)/X
      GO TO 30
   17 LLAST=LAST+1
      DO 21 I=1,KK
      Y=0.0
      DO 20 MM=1,LLAST
      M=MM-1
      N=MAX0(M,1)
   20 Y=Y+(-X)**M*FLOAT(2*MOD(M+I,2))/(FACT(N)*FLOAT(M+I))
   21 B(I)=Y
      GO TO 30
   22 DO 25 I=1,KK
   25 B(I)= FLOAT(2*MOD(I,2))/FLOAT(I)
   30 CONTINUE
      RETURN
      END
C     ******************************************************************
      SUBROUTINE ROTATE(IA,IB,JA,JB,KR,H,W,LM4,LM9)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     TWO-ELECTRON REPULSION AND NUCLEAR ATTRACTION INTEGRALS.
C     TRANSFORMATION FROM LOCAL TO MOLECULAR COORDINATES.
C     *
      COMMON
     ./EXTRA / RI(22),CORE(4,2),T(5),X(3),Y(3),Z(3)
     ./FLAG3 / KRESET,IWADE
     ./FLAG4 / INTSUM
     ./NBFILE/ NB1,NB2,NB3,NB4
     ./PASS1 / NI,NJ,R,GAM,NBOND,IIDUM
     ./SKIPA / IGRAD,ISKPA,NWSKP,QUADRS
      DIMENSION H(LM4),W(LM9)
      LOGICAL SI,SK
      LOGICAL QUADRS
C     *
C *** THE TWO-ELECTRON REPULSION INTEGRALS OVER LOCAL COORDINATES ARE
C     EVALUATED BY SUBROUTINE REPP AND STORED IN RI AS FOLLOWS (WHERE
C     P-SIGMA = O, AND P-PI = P OR P*).
C     (SS/SS)=1,   (SO/SS)=2,   (OO/SS)=3,   (PP/SS)=4,   (SS/OS)=5,
C     (SO/SO)=6,   (SP/SP)=7,   (OO/SO)=8,   (PP/SO)=9,   (PO/SP)=10,
C     (SS/OO)=11,  (SS/PP)=12,  (SO/OO)=13,  (SO/PP)=14,  (SP/OP)=15,
C     (OO/OO)=16,  (PP/OO)=17,  (OO/PP)=18,  (PP/PP)=19,  (PO/PO)=20,
C     (PP/P*P*)=21,   (P*P/P*P)=22.
C     THE TWO-ELECTRON REPULSION INTEGRALS IN MOLECULAR COORDINATES (W)
C     ARE STORED IN THE ORDER IN WHICH THEY WILL LATER BE USED, I.E.
C     (IJ/KL) WITH J.LE.I AND L.LE.K, WHERE L VARIES MOST RAPIDLY AND
C     I LEAST RAPIDLY.
C     *
C *** COMPUTE INTEGRALS IN LOCAL COORDINATES.
      CALL REPP (NI,NJ,R)
      GAM=RI(1)
      KI=0
      IF(INTSUM.LE.LM9) KI=KR
C *** BOTH ATOMS ARE FIRST-ROW ELEMENTS. NO NEED TO ROTATE COORDINATES.
      IF((NI.GT.2).OR.(NJ.GT.2)) GO TO 1
      I=(IA*(IA+1))/2
      H(I)=H(I)-CORE(1,1)
      I=(JA*(JA+1))/2
      H(I)=H(I)-CORE(1,2)
      KI=KI+1
      W(KI)=RI(1)
      GO TO 18
C *** ROTATE THE TWO-CENTRE REPULSION INTEGRALS.
    1 DO 13  I=IA,IB
      SI=I.EQ.IA
      II=I-IA
      DO 13  J=IA,I
      JJ=J-IA
      IJ=0
      IF(JJ.EQ.0) IJ=-1
      IF(SI) IJ=+1
      DO 13  K=JA,JB
      KK=K-JA
      SK=KK.GT.0
      DO 13  L=JA,K
      KI=KI+1
      IF(SK) GO TO 5
C *** INTEGRAL (I,J/K,L) IS OF THE TYPE (I,J/S,S)
      IF(IJ) 3,4,2
C     (SS/SS)
    2 W(KI)=RI(1)
      GO TO 13
C     (PS/SS)
    3 W(KI)=RI(2)*X(II)
      GO TO 13
C     (PP/SS)
    4 W(KI)=RI(3)*X(II)*X(JJ)+RI(4)*(Y(II)*Y(JJ)+Z(II)*Z(JJ))
      GO TO 13
    5 LL=L-JA
      IF(LL.GT.0) GO TO 9
C *** INTEGRAL (I,J/K,L) IS OF THE TYPE (I,J/P,S)
      IF(IJ) 7,8,6
C     (SS/PS)
    6 W(KI)=RI(5)*X(KK)
      GO TO 13
C     (PS/PS)
    7 W(KI)=RI(6)*X(II)*X(KK)+RI(7)*(Y(II)*Y(KK)+Z(II)*Z(KK))
      GO TO 13
C     (PP/PS)
    8 W(KI)=X(KK)*(RI(8)*X(II)*X(JJ)+RI(9)*(Y(II)*Y(JJ)+Z(II)*Z(JJ)))
     1     +RI(10)*(X(II)*(Y(JJ)*Y(KK)+Z(JJ)*Z(KK))
     2             +X(JJ)*(Y(II)*Y(KK)+Z(II)*Z(KK)))
      GO TO 13
C *** INTEGRAL (I,J/K,L) IS OF THE TYPE (I,J/P,P)
    9 IF(IJ) 11,12,10
C     (SS/PP)
   10 W(KI)=RI(11)*X(KK)*X(LL)+RI(12)*(Y(KK)*Y(LL)+Z(KK)*Z(LL))
      GO TO 13
C     (PS/PP)
   11 W(KI)=X(II)*(RI(13)*X(KK)*X(LL)+RI(14)*(Y(KK)*Y(LL)+Z(KK)*Z(LL)))
     1     +RI(15)*(Y(II)*(Y(KK)*X(LL)+Y(LL)*X(KK))
     2             +Z(II)*(Z(KK)*X(LL)+Z(LL)*X(KK)))
      GO TO 13
C     (PP/PP)
   12 W(KI)=(RI(16)*X(II)*X(JJ)
     1      +RI(17)*(Y(II)*Y(JJ)+Z(II)*Z(JJ)))*X(KK)*X(LL)
     2      +RI(18)*X(II)*X(JJ)*(Y(KK)*Y(LL)+Z(KK)*Z(LL))
     3      +RI(19)*(Y(II)*Y(JJ)*Y(KK)*Y(LL)+Z(II)*Z(JJ)*Z(KK)*Z(LL))
     4      +RI(20)*(X(II)*(X(KK)*(Y(JJ)*Y(LL)+Z(JJ)*Z(LL))
     5                     +X(LL)*(Y(JJ)*Y(KK)+Z(JJ)*Z(KK)))
     6              +X(JJ)*(X(KK)*(Y(II)*Y(LL)+Z(II)*Z(LL))
     7                     +X(LL)*(Y(II)*Y(KK)+Z(II)*Z(KK))))
     8      +RI(21)*(Y(II)*Y(JJ)*Z(KK)*Z(LL)+Z(II)*Z(JJ)*Y(KK)*Y(LL))
     9      +RI(22)*(Y(II)*Z(JJ)+Z(II)*Y(JJ))*(Y(KK)*Z(LL)+Z(KK)*Y(LL))
   13 CONTINUE
C     *
C *** THE NUCLEAR ATTRACTION INTEGRALS CORE(KL,IJ) ARE STORED AS FOLLOWS
C     (SS/)=1,   (SO/)=2,   (OO/)=3,   (PP/)=4
C     WHERE IJ=1 IF THE ORBITALS CENTRED ON ATOM I,  =2 IF ON ATOM J.
C     *
      K=IA
      L=IB
      KK=1
   14 DO 17   I=K,L
      SI=I.GT.K
      II=I-K
      LL=(I*(I-1))/2
      DO 17   J=K,I
      M=LL+J
      IF(SI) GO TO 15
C     (S,S/)
      H(M)=H(M)-CORE(1,KK)
      GO TO 17
   15 JJ=J-K
      IF(JJ.GT.0) GO TO 16
C     (P,S/)
      H(M)=H(M)-X(II)*CORE(2,KK)
      GO TO 17
C     (P,P/)
   16 HTMP=-CORE(3,KK)*X(II)*X(JJ)-CORE(4,KK)*(Y(II)*Y(JJ)+Z(II)*Z(JJ))
      H(M)=H(M)+HTMP
   17 CONTINUE
      KK=KK+1
      IF(KK.GT.2) GO TO 18
      K=JA
      L=JB
      GO TO 14
C     *
C *** WRITE INTEGRALS ON FILE NB2.
C     *
   18 KR=KI
      IF(.NOT.QUADRS .AND. KRESET.EQ.1) RETURN
      IF(INTSUM.LE.LM9) RETURN
      WRITE(NB2) (W(I),I=1,KI)
      RETURN
      END
C     ******************************************************************
      SUBROUTINE REPP (NI,NJ,R)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON
     ./EXTRA / A(22),CORE(4,2),TXYZ(14)
     ./MULTIP/ DD(18),QQ(18),AA(18,3)
     ./OPTION/ IOP
     ./PARDER/ TORE(18),EHEAT(18),EISOL(18)
      PP=0.5
      P2=0.25
      P3=0.125
      P4=0.0625
C     *
C *** THIS ROUTINE COMPUTES THE TWO-CENTRE REPULSION INTEGRALS AND THE
C *** NUCLEAR ATTRACTION INTEGRALS IN LOCAL COORDINATES.
C     *
C     THE TWO-CENTRE REPULSION INTEGRALS (OVER LOCAL COORDINATES) ARE
C     STORED AS FOLLOWS (WHERE P-SIGMA = O,  AND P-PI = P AND P* )
C     (SS/SS)=1,   (SO/SS)=2,   (OO/SS)=3,   (PP/SS)=4,   (SS/OS)=5,
C     (SO/SO)=6,   (SP/SP)=7,   (OO/SO)=8,   (PP/SO)=9,   (PO/SP)=10,
C     (SS/OO)=11,  (SS/PP)=12,  (SO/OO)=13,  (SO/PP)=14,  (SP/OP)=15,
C     (OO/OO)=16,  (PP/OO)=17,  (OO/PP)=18,  (PP/PP)=19,  (PO/PO)=20,
C     (PP/P*P*)=21,   (P*P/P*P)=22.
C     THE STORAGE OF THE NUCLEAR ATTRACTION INTEGRALS  CORE(KL/IJ) IS
C     (SS/)=1,   (SO/)=2,   (OO/)=3,   (PP/)=4
C     WHERE IJ=1 IF THE ORBITALS CENTRED ON ATOM I,  =2 IF ON ATOM J.
C     NI AND NJ ARE THE ATOMIC NUMBERS OF THE TWO ELEMENTS.
C     *
      DO 1  I=1,22
    1 A(I)=0.0
      DO 2  I=1,4
      CORE(I,1)=0.0
    2 CORE(I,2)=0.0
C     ATOMIC UNITS ARE USED IN THE CALCULATION
C     DEFINE CHARGE SEPARATIONS.
      DA=DD(NI)
      DB=DD(NJ)
      QA=QQ(NI)
      QB=QQ(NJ)
C     HYDROGEN - HYDROGEN
      AEE= (AA(NI,1)+AA(NJ,1))**2
      EE    = 1./SQRT(R**2+AEE)
      A(1)= EE*27.21
      CORE(1,1)= TORE(NJ)*A(1)
      CORE(1,2)= TORE(NI)*A(1)
      IF (NI .LT. 3 .AND. NJ .LT. 3) RETURN
      IF (NI .LT. 3) GO TO 3
C     HEAVY ATOM - HYDROGEN
      ADE= (AA(NI,2)+AA(NJ,1))**2
      AQE= (AA(NI,3)+AA(NJ,1))**2
      DZE   =-1./SQRT((R+DA)**2+ADE) + 1./SQRT((R-DA)**2+ADE)
      QZZE  = 1./SQRT((R-2.*QA)**2+AQE) - 2./SQRT(R**2+AQE)
     1       +1./SQRT((R+2.*QA)**2+AQE)
      QXXE  = 2./SQRT(R**2+4.*QA**2+AQE) - 2./SQRT(R**2+AQE)
      DZE   = DZE   *PP
      QXXE  = QXXE  *P2
      QZZE  = QZZE  *P2
      A(2) = -DZE
      A(3)=  EE + QZZE
      A(4)=  EE + QXXE
      IF (NJ .LT. 3) GO TO 100
C     HYDROGEN - HEAVY ATOM
    3 CONTINUE
      AED= (AA(NI,1)+AA(NJ,2))**2
      AEQ= (AA(NI,1)+AA(NJ,3))**2
      EDZ   =-1./SQRT((R-DB)**2+AED) + 1./SQRT((R+DB)**2+AED)
      EQZZ  = 1./SQRT((R-2.*QB)**2+AEQ) - 2./SQRT(R**2+AEQ)
     1       +1./SQRT((R+2.*QB)**2+AEQ)
      EQXX  = 2./SQRT(R**2+4.*QB**2+AEQ) - 2./SQRT(R**2+AEQ)
      EDZ   = EDZ   *PP
      EQXX  = EQXX  *P2
      EQZZ  = EQZZ  *P2
      A(5) = -EDZ
      A(11)= EE + EQZZ
      A(12)=  EE + EQXX
      IF (NI .LT. 3) GO TO 100
C     HEAVY ATOM - HEAVY ATOM
      ADD= (AA(NI,2)+AA(NJ,2))**2
      ADQ= (AA(NI,2)+AA(NJ,3))**2
      AQD= (AA(NI,3)+AA(NJ,2))**2
      AQQ= (AA(NI,3)+AA(NJ,3))**2
      DXDX  = 2./SQRT(R**2+(DA-DB)**2+ADD)
     1       -2./SQRT(R**2+(DA+DB)**2+ADD)
      DZDZ  = 1./SQRT((R+DA-DB)**2+ADD) + 1./SQRT((R-DA+DB)**2+ADD)
     1       -1./SQRT((R-DA-DB)**2+ADD) - 1./SQRT((R+DA+DB)**2+ADD)
      DZQXX =-2./SQRT((R+DA)**2+4.*QB**2+ADQ)
     1       +2./SQRT((R-DA)**2+4.*QB**2+ADQ)
     2       +2./SQRT((R+DA)**2+ADQ)
     3       -2./SQRT((R-DA)**2+ADQ)
      QXXDZ =-2./SQRT((R-DB)**2+4.*QA**2+AQD)
     1       +2./SQRT((R+DB)**2+4.*QA**2+AQD)
     2       +2./SQRT((R-DB)**2+AQD)
     3       -2./SQRT((R+DB)**2+AQD)
      DZQZZ =-1./SQRT((R+DA-2.*QB)**2+ADQ)
     1       +1./SQRT((R-DA-2.*QB)**2+ADQ)
     2       -1./SQRT((R+DA+2.*QB)**2+ADQ)
     3       +1./SQRT((R-DA+2.*QB)**2+ADQ)
     4       -2./SQRT((R-DA)**2+ADQ)
     5       +2./SQRT((R+DA)**2+ADQ)
      QZZDZ =-1./SQRT((R+2.*QA-DB)**2+AQD)
     1       +1./SQRT((R+2.*QA+DB)**2+AQD)
     2       -1./SQRT((R-2.*QA-DB)**2+AQD)
     3       +1./SQRT((R-2.*QA+DB)**2+AQD)
     4       +2./SQRT((R-DB)**2+AQD)
     5       -2./SQRT((R+DB)**2+AQD)
      QXXQXX= 2./SQRT(R**2+4.*(QA-QB)**2+AQQ)
     1       +2./SQRT(R**2+4.*(QA+QB)**2+AQQ)
     2       -4./SQRT(R**2+4.*QA**2+AQQ)
     3       -4./SQRT(R**2+4.*QB**2+AQQ)
     4       +4./SQRT(R**2+AQQ)
      QXXQYY= 4./SQRT(R**2+4.*QA**2+4.*QB**2+AQQ)
     1       -4./SQRT(R**2+4.*QA**2+AQQ)
     2       -4./SQRT(R**2+4.*QB**2+AQQ)
     3       +4./SQRT(R**2+AQQ)
      QXXQZZ= 2./SQRT((R-2.*QB)**2+4.*QA**2+AQQ)
     1       +2./SQRT((R+2.*QB)**2+4.*QA**2+AQQ)
     2       -2./SQRT((R-2.*QB)**2+AQQ)
     3       -2./SQRT((R+2.*QB)**2+AQQ)
     4       -4./SQRT(R**2+4.*QA**2+AQQ)
     5       +4./SQRT(R**2+AQQ)
      QZZQXX= 2./SQRT((R+2.*QA)**2+4.*QB**2+AQQ)
     1       +2./SQRT((R-2.*QA)**2+4.*QB**2+AQQ)
     2       -2./SQRT((R+2.*QA)**2+AQQ)
     3       -2./SQRT((R-2.*QA)**2+AQQ)
     4       -4./SQRT(R**2+4.*QB**2+AQQ)
     5       +4./SQRT(R**2+AQQ)
      QZZQZZ= 1./SQRT((R+2.*QA-2.*QB)**2+AQQ)
     1       +1./SQRT((R+2.*QA+2.*QB)**2+AQQ)
     2       +1./SQRT((R-2.*QA-2.*QB)**2+AQQ)
     3       +1./SQRT((R-2.*QA+2.*QB)**2+AQQ)
     4       -2./SQRT((R-2.*QA)**2+AQQ)
     5       -2./SQRT((R+2.*QA)**2+AQQ)
     6       -2./SQRT((R-2.*QB)**2+AQQ)
     7       -2./SQRT((R+2.*QB)**2+AQQ)
     8       +4./SQRT(R**2+AQQ)
      DXQXZ =-2./SQRT((R-QB)**2+(DA-QB)**2+ADQ)
     1       +2./SQRT((R+QB)**2+(DA-QB)**2+ADQ)
     2       +2./SQRT((R-QB)**2+(DA+QB)**2+ADQ)
     3       -2./SQRT((R+QB)**2+(DA+QB)**2+ADQ)
      QXZDX =-2./SQRT((R+QA)**2+(QA-DB)**2+AQD)
     1       +2./SQRT((R-QA)**2+(QA-DB)**2+AQD)
     2       +2./SQRT((R+QA)**2+(QA+DB)**2+AQD)
     3       -2./SQRT((R-QA)**2+(QA+DB)**2+AQD)
      QXYQXY= 4./SQRT(R**2+2.*(QA-QB)**2+AQQ)
     1       +4./SQRT(R**2+2.*(QA+QB)**2+AQQ)
     2       -8./SQRT(R**2+2.*(QA**2+QB**2)+AQQ)
      QXZQXZ= 2./SQRT((R+QA-QB)**2+(QA-QB)**2+AQQ)
     1       -2./SQRT((R+QA+QB)**2+(QA-QB)**2+AQQ)
     2       -2./SQRT((R-QA-QB)**2+(QA-QB)**2+AQQ)
     3       +2./SQRT((R-QA+QB)**2+(QA-QB)**2+AQQ)
     4       -2./SQRT((R+QA-QB)**2+(QA+QB)**2+AQQ)
     5       +2./SQRT((R+QA+QB)**2+(QA+QB)**2+AQQ)
     6       +2./SQRT((R-QA-QB)**2+(QA+QB)**2+AQQ)
     7       -2./SQRT((R-QA+QB)**2+(QA+QB)**2+AQQ)
      DXDX  = DXDX  *P2
      DZDZ  = DZDZ  *P2
      DZQXX = DZQXX *P3
      QXXDZ = QXXDZ *P3
      DZQZZ = DZQZZ *P3
      QZZDZ = QZZDZ *P3
      DXQXZ = DXQXZ *P3
      QXZDX = QXZDX *P3
      QXXQXX= QXXQXX*P4
      QXXQYY= QXXQYY*P4
      QXXQZZ= QXXQZZ*P4
      QZZQXX= QZZQXX*P4
      QZZQZZ= QZZQZZ*P4
      QXZQXZ= QXZQXZ*P4
      QXYQXY= QXYQXY*P4
      A(6) =  DZDZ
      A(7) =  DXDX
      A(8) = -EDZ - QZZDZ
      A(9) = -EDZ - QXXDZ
      A(10)= -QXZDX
      A(13)= -DZE - DZQZZ
      A(14)= -DZE - DZQXX
      A(15)= -DXQXZ
      A(16)=  EE + EQZZ + QZZE + QZZQZZ
      A(17)=  EE + EQZZ + QXXE + QXXQZZ
      A(18)=  EE + EQXX + QZZE + QZZQXX
      A(19)=  EE + EQXX + QXXE + QXXQXX
      A(20)=  QXZQXZ
      A(21)=  EE + EQXX + QXXE + QXXQYY
      A(22)=  QXYQXY
      IF(IOP.LT.0) A(22)=0.5*(A(19)-A(21))
  100 CONTINUE
C     CONVERT INTO EV.
      DO 110 I=2,22
  110 A(I)=A(I)*27.21
C     CALCULATE CORE-ELECTRON ATTRACTIONS.
      CORE(2,1)= TORE(NJ) * A(2)
      CORE(3,1)= TORE(NJ) * A(3)
      CORE(4,1)= TORE(NJ) * A(4)
      CORE(2,2)= TORE(NI) * A(5)
      CORE(3,2)= TORE(NI) * A(11)
      CORE(4,2)= TORE(NI) * A(12)
      RETURN
      END
