C     ******************************************************************
      SUBROUTINE FLEPO (H,PP,LM4,LM5)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     DFP SECTION OF THE PROGRAM.
C     *
C     THIS SUBROUTINE ATTEMPTS TO MINIMIZE A REAL-VALUED FUNCTION F OF
C     THE N-COMPONENT REAL VECTOR X BY THE DAVIDON-FLETCHER-POWELL
C     ALGORITHM. THE USER MUST SUPPLY THE SUBROUTINE  COMPFG(N,X,F,G)
C     WHICH COMPUTES FUNCTION VALUES  F  AND GRADIENTS  G  AT GIVEN
C     VALUES FOR THE VARIABLES X.  THE MINIMIZATION PROCEEDS BY A
C     SEQUENCE OF ONE-DIMENSIONAL MINIMIZATIONS.  THESE ARE CARRIED OUT
C     BY SUBROUTINES LINMIN/LOCMIN, WHICH SOLVE THE SUBPROBLEM OF
C     MINIMIZING THE FUNCTION  F  ALONG THE LINE   X+ALPHA*P,   WHERE X
C     IS THE VECTOR OF CURRENT VARIABLE VALUES,  ALPHA IS A SCALAR
C     VARIABLE, AND  P  IS A SEARCH-DIRECTION VECTOR PROVIDED BY THE
C     DAVIDON-FLETCHER-POWELL ALGORITHM.  EACH ITERATION STEP CARRIED
C     OUT BY FLEPO PROCEEDS BY LETTING LINMIN/LOCMIN FIND A VALUE FOR
C     ALPHA WHICH MINIMIZES  F  ALONG  X+ALPHA*P, BY UPDATING THE
C     VECTOR  X  BY THE AMOUNT  ALPHA*P,  AND FINALLY BY GENERATING A
C     NEW VECTOR  P.
C     THE CONVERGENCE IS TESTED IN FLEPO BY THE 3-ELEMENT VECTOR TOLEND.
C     THE TEST ON X IS SATISFIED, IF THE RELATIVE CHANGE IN X, MEASURED
C     BY ITS NORM, OVER ANY TWO SUCCESSIVE ITERATIONS DROPS BELOW
C     TOLEND(1). THE TEST ON F IS SATISFIED, IF THE RELATIVE CHANGE IN
C     F DROPS BELOW TOLEND(2). THE TEST ON G IS SATISFIED, IF ALL
C     GRADIENT COMPONENTS ARE LESS THAN TOLEND(3).
C     A SUCCESSFUL TERMINATION OF THE OPTIMIZATION OCCURS WHEN THE
C     TESTS ON X AND G (NSUCC=1) OR ON F AND G (NSUCC=2) ARE BOTH
C     SATISFIED, OR WHEN THE TEST ON X OR F IS SATISFIED FOR IGG1
C     CONSECUTIVE CYCLES EVEN WHEN THE TEST ON G IS NOT SATISFIED
C     (NSUCC=3). THE OPTIMIZATION IS ALSO TERMINATED IF, AT THE
C     BEGINNING OF A CYCLE, THE PREDICTED DECREASE IN F, MEASURED BY
C     ALPHA.P.G, IS LESS THAN EYEAD (NSUCC=0).
C     AN UNSUCCESSFUL TERMINATION OCCURS WHEN F CANNOT BE LOWERED IN
C     TWO CONSECUTIVE CYCLES (NSUCC=10), OR WHEN THE NUMBER OF FUNCTION
C     EVALUATIONS EXCEEDS MAXEND (NSUCC=11).
C     *
C     THE PRESENT CODE ALLOWS TO ASSIGN THE OPTIMIZATION ROUTINES AND
C     THE FUNCTION EVALUATION ROUTINES TO DIFFERENT SEGMENTS. EACH CALL
C     FOR A FUNCTION EVALUATION THEN IMPLIES AN UNLOADING AND SUBSEQUENT
C     RELOADING OF THE OPTIMIZATION ROUTINES IN THEIR INITIAL STATE.
C     THIS REQUIRES A MECHANISM FOR RETURNING TO THE CALLING STATEMENT
C     IN THE OPTIMIZATION SECTION WHICH IS IDENTIFIED BY THE VALUES OF
C     THE VARIABLES IOV,JOV,KOV,LOV IN /OVERLY/.
C     IF SEGMENTATION IS DESIRED (IOV=1, OTHERWISE IOV=0), THE VALUES
C     (JOV,KOV,LOV) DEFINE A UNIQUE PATH TO THE CALLING STATEMENT IN
C     SUBROUTINE COMPFG. JOV=1 DURING A FUNCTION EVALUATION (OTHERWISE
C     JOV=0, CF. SUBROUTINE COMPFG). KOV=0 IMPLIES CALLING COMPFG FROM
C     SUBROUTINE FLEPO, AND KOV=1 FROM THE LINE SEARCH ROUTINES LINMIN
C     OR LOCMIN. FINALLY, LOV DENOTES THE ACTUAL STATEMENT IN FLEPO,
C     LINMIN, OR LOCMIN, WHICH IS EXECUTED AFTER RETURNING FROM A
C     FUNCTION EVALUATION.
C     NOTE. LOV=4 INDICATES THAT THE OPTIMIZATION IS COMPLETED.
C     *
C     THERE ARE TWO MODES FOR CONTINUING OPTIMIZATIONS IN NEW JOBS.
C     (A) MIDDLE= 0,1. THE RELEVANT INFORMATION IS SAVED ON FILE 4 AT
C         THE END OF EACH DFP CYCLE. THE CONTINUATION POINT FOR THE NEXT
C         JOB IS EITHER AT THE BEGINNING OF THE NEXT DFP CYCLE (LOV=5)
C         OR AT THE BEGINNING OF THE PRINTING SECTION (LOV=6).
C     (B) MIDDLE=-2,2. THE RELEVANT INFORMATION IS SAVED ON FILE 4 AFTER
C         EACH FUNCTION EVALUATION. THE CONTINUATION POINT FOR THE NEXT
C         JOB IS GIVEN BY (JOV,KOV,LOV). IN ADDITION TO THE STANDARD
C         DEFINITIONS FOR (JOV,KOV,LOV), LOV=5 AND LOV=6 DENOTE THE
C         CONTINUATION POINTS DESCRIBED ABOVE.
C     IF THERE IS AN ATTEMPT TO CONTINUE AN OPTIMIZATION COMPLETED
C     PREVIOUSLY, LOV=4 IS READ FROM FILE 4. THIS CAUSES THE PROGRAM
C     TO RETURN AFTER A SINGLE FUNCTION EVALUATION.
C     *
      COMMON
     ./BESAFE/ TLIMIT,SFDFP,SFSCF
     ./CCCCK / ICCHK,SMVAL
     ./CYCLES/ JCYC,NPETER
     ./DFP   / X(99),N
     ./DFPGO / GLAST(99),GG(99),XLAST(99)
     ./ERG   / ENERGX,GRAD(99)
     ./FLAG1 / KTITLE(12),KOMENT(10),KHARGE(10)
     ./FLAG2 / MIDDLE,SECADD,TIME1
     ./FLAG3 / KRESET,IWADE
     ./FLPOCM/ NN,MXLN,TOLN(3),FC,ISWTCH,G(99),P(99),DOT,ALPHA,FIP1
     ./MXFLAG/ MAXEND
     ./OPCOM1/ FI,FIII,GD(99),GNORM,PNLAST,XD(99),CNCADD,CNCOS,SCFCRD,
     .         SCFGRD,ZCONS,S,TF,TX,XN,Y,YHY
     ./OPCOM2/ IT1,IHDIM,IPSGN,NREM,NTO
     ./OVERLY/ IOV,JOV,KOV,LOV
      COMMON
     ./PARM3 / LOC(2,99)
     ./PASS2 / MAXLIN,IPRINT,ISWDUM,NRST,NSUCC,TOLIN(3),
     .         TOLEND(3),FMIN,RST,FAC
     ./PASS3 / JPRINT,JNRST,NCOUNT,COS,PNORM,LNSTOP,IREPET
     ./SC    / EINC,IGG1,CCCOS,EYEAD
     ./SCRT  / SCFCRT,SCFF
     ./SKIPA / IGRAD,ISKPA,NWSKP,QUADRS
     ./SLVER / FREPF,YEAD,DEL
     ./XLSQ1 / XMINM,XCRIT,YMAXST,YMINST,MXCONT,TOLS(6)
     ./XPRJU / IREP,IJUMP
     ./XXMAXM/ XMAXM,PMSTE,DELL,TDEL
      DIMENSION H(LM5),PP(LM4)
      LOGICAL QUADRS
C     *
C     OVERLAY CONTROL
C     *
      IF(IOV.EQ.0) GO TO 100
      IF(JOV.EQ.0) GO TO 100
      IF(LOV.EQ.4) GO TO 104
      IF(MIDDLE.GE.0) GO TO 110
      CALL PUNOUT (H,PP,LM4,LM5)
CCC      CALL TIME(IT)
ccc      TX2  = 0.00001*FLOAT(IT)
ccc      TSCF = TX2-SFSCF
ccc      SFSCF= TX2
ccc      IF(TLIMIT.LT.TX2+SFDFP*TSCF) STOP
  110 IF(KOV.GT.0) GO TO 1000
      GO TO (101,102,103,104,1,11),LOV
C     *
C     SETUP PHASE (EXECUTED ONLY ONCE)
C     *
  100 KOV=0
      IF(N.LE.0) WRITE(6,290)
      IF(N.LE.0) WRITE(8,290)
      IF(N.LE.0) STOP
      IF(IPRINT.NE.0) WRITE(6,300) (KOMENT(I),I=1,10),
     1  (KTITLE(I),I=1,12)
CCC      IF(IPRINT.NE.0) WRITE(8,300) (KOMENT(I),I=1,10),
CCC     1  (KTITLE(I),I=1,12)
      IJUMP=0
      DEL=DELL
      SCFCRD=SCFCRT
      SCFGRD=SCFF
      FREPF=900000.0
      ZCONS=0.000000001
C     RESTART OPTIONS.
      CCN=FLOAT(N)
      CNCADD=1.0/DSQRT(CCN)
      IF(CNCADD.GT.0.15) CNCADD=0.15
      IF(CCCOS.GT.0.0000001) CNCADD=CCCOS
      CNCOS=RST
C     LINE SEARCH OPTIONS.
      NN = N
      MXLN = MAXLIN
      TOLN(1) = TOLIN(1)
      TOLN(2) = TOLIN(2)
      TOLN(3) = TOLIN(3)
      FC = FAC
C     PRINTING FLAGS.
      IPSGN = 1
      IF (IPRINT .EQ. 0)  IPSGN =  0
      IF (IPRINT .LT. 0)  IPSGN = -1
      IPRINT = IABS(IPRINT)
      NTO=N/10
      NREM=N-(NTO*10)
      LNSTOP=1
      IREPET=1
      IWADE=1
      IHDIM=(N*(N+1))/2
C     CHECK FOR JOB CONTINUATION.
      IF(MIDDLE.GT.0) GO TO 111
      JPRINT = 0
      ALPHA = 1.0
      PNORM = 1.0
      JNRST = 0
      COS = 0.0
      JCYC = 0
      NCOUNT=0
C     INITIAL FUNCTION EVALUATION.
  101 LOV=1
      CALL COMPFG(N,X,FIP1,G)
      IF(JOV.EQ.1) RETURN
      NCOUNT=1
      IF(QUADRS) NCOUNT=2*N+1
CCC      CALL TIME(IT1)
      GO TO 1
C     *
C     CONTINUATION OF A PREVIOUS JOB
C     *
  111 CONTINUE
      JUMP=0
      CALL PUNIN (H,PP,LM4,LM5,JUMP)
CCC      CALL TIME(IT1)
      IF(LOV.EQ.4) GO TO 24
      IF(MIDDLE.EQ.1 .AND. LOV.EQ.5) GO TO 1
      IF(MIDDLE.EQ.1 .AND. LOV.EQ.6) GO TO 11
      IF(IPSGN .LT.0) WRITE(6,310) IOV,JOV,KOV,LOV
CCC      IF(IPSGN .LT.0) WRITE(8,310) IOV,JOV,KOV,LOV
      MIDDLE = -MIDDLE
      GO TO 110
C     *
C     START OF EACH ITERATION CYCLE ...
C     *
    1 GNORM = 0.0
      DO 2 K=1,N
    2 GNORM = GNORM+G(K)**2
      GNORM = DSQRT(GNORM)
      IF(IPRINT.NE.0) WRITE(6,876)
      IF(IPRINT.NE.0) WRITE(8,876)
      JCYC = JCYC+1
      JPRINT = JPRINT+1
      JNRST = JNRST+1
      ISWTCH = 0
      IF(JPRINT.GE.IPRINT) ISWTCH=IPSGN
      IF(GNORM.GT.50.) GO TO 3
      IF(SCFCRD.GE.1.E-04) SCFCRT=1.E-05
      IF(SCFGRD.GE.1.E-04) SCFF  =1.E-05
    3 IF(LNSTOP.EQ.1)  GO TO 4
      IF(COS.LE.CNCOS) GO TO 4
      IF(JNRST.LT.NRST) GO TO 6
C     *
C     RESTART SECTION
C     *
    4 CONTINUE
      DO 84 I=1,N
      XD(I)=X(I)-DSIGN(DEL,G(I))
   84 CONTINUE
C     FUNCTION EVALUATION AT SECOND POINT.
  102 LOV=2
      CALL COMPFG(N,XD,FIII,GD)
      IF(JOV.EQ.1) RETURN
      NCOUNT=NCOUNT+1
      IF(QUADRS) NCOUNT=NCOUNT+2*N
C     INITIAL ESTIMATE OF A DIAGONAL H MATRIX.
      DO 203 I=1,IHDIM
  203 H(I)=0.0
      DO 204 I=1,N
      II=I+N*(I-1)-((I*(I-1))/2)
      GGGGG=G(I)-GD(I)
      IF(DABS(GGGGG).LT.ZCONS) GO TO 938
      GGD=DABS(G(I))
      IF(FIII.LT.FIP1) GGD=DABS(GD(I))
      H(II)=DSIGN(DEL,G(I))/GGGGG
      IF(H(II).LT.0.0.AND.GGD.LT.ZCONS) GO TO 938
      IF(H(II).LT.0.0) H(II)=(TDEL*DEL)/GGD
      GO TO 939
  938 H(II)=0.01
  939 CONTINUE
      IF(GGD.LT.ZCONS) GGD=ZCONS
      PMSTEP=DABS(PMSTE/GGD)
      IF(H(II).GT.PMSTEP) H(II)=PMSTEP
  204 CONTINUE
      JNRST = 0
C     START FROM POINT WITH LOWER ENERGY.
      IF(FIII.GE.FIP1 .AND. IPRINT.NE.0) WRITE(6,149) FIP1,FIII
CCC      IF(FIII.GE.FIP1 .AND. IPRINT.NE.0) WRITE(8,149) FIP1,FIII
      IF(FIII.GE.FIP1) GO TO 8
      IF(IPRINT.NE.0) WRITE(6,141) FIP1,FIII
CCC      IF(IPRINT.NE.0) WRITE(8,141) FIP1,FIII
      FIP1=FIII
      GNORM=0.0
      DO 87 I=1,N
      X(I)=XD(I)
      G(I)=GD(I)
   87 GNORM=GNORM+G(I)**2
      GNORM=DSQRT(GNORM)
      GO TO 8
C     *
C     UPDATE VARIABLE-METRIC MATRIX
C     *
    6 SY = 0.0
      YHY = 0.0
      JUMP=1
      CALL PUNIN (H,PP,LM4,LM5,JUMP)
      DO 61 I=1,N
      S = 0.0
      DO 60 K=1,N
      IK=I+N*(K-1)-((K*(K-1))/2)
      IF(K.GT.I) IK=K+N*(I-1)-((I*(I-1))/2)
   60 S=S+H(IK)*(G(K)-GLAST(K))
      GG(I) = S
      Y = G(I)-GLAST(I)
      YHY = YHY+GG(I)*Y
   61 SY = SY+(X(I)-XLAST(I))*Y
      DO 7 I=1,N
      Y = X(I)-XLAST(I)
      DO 7 K=I,N
      IK=K+N*(I-1)-((I*(I-1))/2)
      H(IK)=    H(IK)+Y*(X(K)-XLAST(K))/SY-GG(I)*GG(K)/YHY
    7 CONTINUE
C     *
C     ESTABLISH NEW SEARCH DIRECTION
C     *
    8 PNLAST = PNORM
      PNORM = 0.0
      DOT = 0.0
      DO 9 K=1,N
      S = 0.0
      DO 90 I=1,N
      IK=I+N*(K-1)-((K*(K-1))/2)
      IF(K.GT.I) IK=K+N*(I-1)-((I*(I-1))/2)
      S=S-H(IK)*G(I)
   90 CONTINUE
      P(K) = S
      PNORM = PNORM+P(K)**2
    9 DOT = DOT+P(K)*G(K)
      PNORM =DSQRT(PNORM)
      COS = -DOT/(PNORM*GNORM)
C     *
C     CHECK FOR NECESSITY OF RESTART
C     *
      IF(JNRST.EQ.0) GO TO 301
      IF(COS.LE.CNCADD.AND.YEAD.GT. 1.0) GO TO 400
      IF(COS.LE.CNCOS) GO TO 400
      GO TO 301
  400 PNORM=PNLAST
      IF(IPRINT.NE.0) WRITE(6,720) COS
CCC      IF(IPRINT.NE.0) WRITE(8,720) COS
      GO TO 4
  301 CONTINUE
      LOV=6
      CALL PUNOUT (H,PP,LM4,LM5)
C     *
C     PRINTING SECTION
C     *
   11 IF(IPRINT.EQ.0) GO TO 833
      WRITE(6,500) JCYC,FIP1
CCC      WRITE(8,500) JCYC,FIP1
      DO 829 I=1,N
      XD(I)=X(I)
      IF(LOC(2,I)-2) 829,828,828
  828 XD(I)=X(I)*57.2957795
  829 CONTINUE
      IINC1=-9
      IF(NTO.LT.1 .OR. JPRINT.LT.IPRINT) GO TO 831
      DO 830 I=1,NTO
      WRITE(6,851)
      WRITE(8,851)
      IINC1=IINC1+10
      IINC2=IINC1+9
      WRITE(6,852) (J,J=IINC1,IINC2)
      WRITE(8,852) (J,J=IINC1,IINC2)
      WRITE(6,853) (XD(J),J=IINC1,IINC2)
      WRITE(8,853) (XD(J),J=IINC1,IINC2)
      WRITE(6,854) (G(J),J=IINC1,IINC2)
      WRITE(8,854) (G(J),J=IINC1,IINC2)
      IF(ISWTCH.LT.0) WRITE(6,855) (P(J),J=IINC1,IINC2)
      IF(ISWTCH.LT.0) WRITE(8,855) (P(J),J=IINC1,IINC2)
  830 CONTINUE
  831 CONTINUE
      IF(NREM.LT.1 .OR. JPRINT.LT.IPRINT) GO TO 832
      WRITE(6,851)
      WRITE(8,851)
      IINC1=IINC1+10
      IINC2=IINC1+(NREM-1)
      WRITE(6,852) (J,J=IINC1,IINC2)
      WRITE(8,852) (J,J=IINC1,IINC2)
      WRITE(6,853) (XD(J),J=IINC1,IINC2)
      WRITE(8,853) (XD(J),J=IINC1,IINC2)
      WRITE(6,854) (G(J),J=IINC1,IINC2)
      WRITE(8,854) (G(J),J=IINC1,IINC2)
      IF(ISWTCH.LT.0) WRITE(6,855) (P(J),J=IINC1,IINC2)
      IF(ISWTCH.LT.0) WRITE(8,855) (P(J),J=IINC1,IINC2)
  832 CONTINUE
      IF(JPRINT.GE.IPRINT) JPRINT=0
      WRITE(6,875)
      WRITE(8,875)
      WRITE(6,507) GNORM,COS
      WRITE(8,507) GNORM,COS
C     *
C     PREPARE FOR LINE SEARCH
C     *
  833 FI = FIP1
      LNSTOP = 0
      ALPHA = ALPHA*PNLAST/PNORM
      IF(JNRST.EQ.0) ALPHA=1.0
      YEAD=DABS(ALPHA*DOT)
      IF(IPRINT.NE.0) WRITE(6,7136) YEAD
      IF(IPRINT.NE.0) WRITE(8,7136) YEAD
      IF(JNRST.EQ.0) GO TO 4360
      IF(YEAD.LT.EYEAD) GO TO 7134
 4360 CONTINUE
      SMVAL=FIP1
      XMAXM=0.
      DO 630 I=1,N
      GLAST(I)=G(I)
      XLAST(I)=X(I)
      PABS=DABS(P(I))
      XMAXM=DMAX1(XMAXM,PABS)
  630 CONTINUE
      IF(.NOT.QUADRS) XMAXM=0.1/XMAXM
      IF(.NOT.QUADRS) GO TO 1000
      XMINM=XMAXM
      XMAXM=YMAXST/XMAXM
      IWADE=-1
 1000 CONTINUE
C     *
C     LINE SEARCH
C     *
      KOV=1
      IF(.NOT.QUADRS) CALL LINMIN
      IF(QUADRS) CALL LOCMIN
      IF(JOV.EQ.1) RETURN
      IF(QUADRS) IWADE=1
      KOV=0
C     *
C     CHECK SUCCESS OF LINE SEARCH
C     *
      IF(ICCHK.EQ.0) GO TO 458
      IF(IPRINT.NE.0) WRITE(6,480)
      IF(IPRINT.NE.0) WRITE(8,480)
      FIP1=SMVAL
      DO 401 I=1,N
      G(I)=GLAST(I)
      X(I)=XLAST(I)
      GRAD(I)=G(I)
  401 CONTINUE
      IF(JNRST.EQ.0) GO TO 430
      IF(IPRINT.NE.0) WRITE(6,482)
      IF(IPRINT.NE.0) WRITE(8,482)
      COS=0.0
      GO TO 23
  430 IF(IPRINT.NE.0) WRITE(6,445)
      IF(IPRINT.NE.0) WRITE(8,445)
      NSUCC=10
      FMIN=FIP1
      IF(IPRINT.NE.0) WRITE(6,518) FMIN
      IF(IPRINT.NE.0) WRITE(8,518) FMIN
      GO TO 24
  458 CONTINUE
  103 LOV=3
      IF(QUADRS) CALL COMPFG(N,X,FIP1,G)
      IF(JOV.EQ.1) RETURN
      IF(QUADRS) NCOUNT=NCOUNT+2*N+1
   14 XN = 0.0
      DO 15 K=1,N
   15 XN = XN+X(K)**2
      XN = DSQRT(XN)
      TX = DABS(ALPHA*PNORM)
      IF (XN .NE. 0.0)  TX=TX/XN
      TF = DABS(FI-FIP1)
      IF (FIP1 .NE. 0.0)  TF=TF/DABS(FIP1)
      IF (ISWTCH)  17,18,17
   17 WRITE (6,509)  NCOUNT,TX,TF
      WRITE (8,509)  NCOUNT,TX,TF
   18 IF (NCOUNT .LT. MAXEND)  GO TO 19
      IF(IPRINT.NE.0) WRITE(6,510)
      IF(IPRINT.NE.0) WRITE(8,510)
      NSUCC=11
      FMIN=FIP1
      IF(IPRINT.NE.0) WRITE(6,518) FMIN
      IF(IPRINT.NE.0) WRITE(8,518) FMIN
      GO TO 24
C     *
C     TERMINATION TESTS
C     *
 7134 IF(IPRINT.NE.0) WRITE(6,7135)
      IF(IPRINT.NE.0) WRITE(8,7135)
      JCYC=JCYC-1
      NSUCC=0
      GO TO 24
   19 IF (TX .GT. TOLEND(1))  GO TO 20
      IF(IPRINT.NE.0) WRITE(6,511)
      IF(IPRINT.NE.0) WRITE(8,511)
      NSUCC = 1
      GO TO 21
   20 IF (TF .GT. TOLEND(2))  GO TO 29
      IF(IPRINT.NE.0) WRITE(6,512)
      IF(IPRINT.NE.0) WRITE(8,512)
      NSUCC = 2
   21 DO 22 I=1,N
      IF(DABS(G(I)).GT.TOLEND(3)) GO TO 25
   22 CONTINUE
      IF(IPRINT.NE.0) WRITE(6,515)
      IF(IPRINT.NE.0) WRITE(8,515)
      FMIN=FIP1
      GO TO 24
   25 IF(IPRINT.NE.0) WRITE(6,516)
      IF(IPRINT.NE.0) WRITE(8,516)
      IREPET=IREPET+1
      IF(IREPET.EQ.1) FREPF=FIP1
      IF(IREPET.LE.IGG1) GO TO 23
      IF(IPRINT.NE.0) WRITE(6,517)
      IF(IPRINT.NE.0) WRITE(8,517)
      NSUCC=3
      FMIN=FIP1
      GO TO 24
   29 IREPET=0
   23 CONTINUE
C     *
C     PREPARE NEXT CYCLE AND CHECK FOR TIME LIMIT
C     *
      BSMVF=DABS(SMVAL-FIP1)
      IF(BSMVF.GT.10.0) COS=0.0
      DEL=0.002
      IF(BSMVF.GT.1.0) DEL=DELL/2.0
      IF(BSMVF.GT.5.0) DEL=DELL
      LOV=5
      CALL PUNOUT (H,PP,LM4,LM5)
CCC      CALL TIME(IT2)
ccc      TCYCLE=0.00001*FLOAT(IT2-IT1)
CCC      IF(IPRINT.NE.0) WRITE(6,6010) JCYC,TCYCLE
ccc      IT1=IT2
ccc      TX2=0.00001*FLOAT(IT2)
ccc      IF (TLIMIT .GT. TX2+SFDFP*TCYCLE) GO TO 1
              GO TO 1
   10 IJUMP=1
      RETURN
C     *
C     EXIT AFTER FINISHING THE OPTIMIZATION
C     *
   24 CONTINUE
      LOV=4
      CALL PUNOUT (H,PP,LM4,LM5)
      IWADE=-1
      JOV=0
  104 LOV=4
      CALL COMPFG(N,X,FIP1,G)
      IF(JOV.EQ.1) RETURN
      NPETER=NCOUNT+1
      IPRINT=IPRINT*IPSGN
      SCFCRT=SCFCRD
      SCFF  =SCFGRD
      RETURN
  141 FORMAT(1H ,5X,'FUNCTION VALUE=',F15.8,5X,'IS BEING REPLACED BY VAL
     1UE=',F15.8,5X,'FOUND IN RESTART PROCEDURE'/,6X,'THE CORRESPONDING
     2X VALUES AND GRADIENTS ARE ALSO BEING REPLACED'/)
  149 FORMAT(1H ,5X,'FUNCTION VALUE=',F15.8,5X,'WILL NOT BE REPLACED BY
     1VALUE=',F15.8,5X,'CALCULATED BY RESTART PROCEDURE'/)
  290 FORMAT(///6X,'OPTIMIZATION REQUIRES AT LEAST ONE VARIABLE.'//)
  300 FORMAT(////, 6X,10A4/ 6X,12A4)
  310 FORMAT(//1X,'RESTART CONTROL',5X,4I3)
  445 FORMAT(6X,'UNSUCCESSFUL RESTART. THE SEARCH IS TERMINATED.')
  480 FORMAT(/ ,1H ,  5X,'NO POINT LOWER IN ENERGY THAN THE STARTING POI
     1NT COULD BE FOUND IN THE LINE MINIMIZATION')
  482 FORMAT(1H , 5X,'THE PROGRAM WILL GO TO RESTART SECTION'/)
  500 FORMAT(1H ,'AT THE BEGINNING OF CYCLE',I5,
     1 '  THE FUNCTION VALUE IS ',E17.8/'  THE CURRENT POINT IS ...')
  507 FORMAT('  GRADIENT NORM = ',E11.4/'  ANGLE COSINE  = ',E11.4)
  508 FORMAT('0LINMIN FAILED AT CYCLE',I5//)
  509 FORMAT('  TERMINATION TESTS ...'/'  FUNCTION EVALUATIONS =',I4/
     1 '  RELATIVE CHANGE IN X = ',E10.3/
     2 '  RELATIVE CHANGE IN F = ',E10.3/)
  510 FORMAT('0TERMINATION FROM TOO MANY COUNTS')
  511 FORMAT('0TEST ON X SATISFIED')
  512 FORMAT('0TEST ON F SATISFIED')
  515 FORMAT(' TEST ON G SATISFIED')
  516 FORMAT(' TEST ON G NOT SATISFIED'/)
  517 FORMAT(' FURTHER QUENCHING NOT REQUESTED ')
  518 FORMAT(///1X,'UNSUCCESSFUL TERMINATION AT FUNCTION VALUE ',F20.6)
  720 FORMAT(//,5X,'SINCE COS=',F9.5,5X,'THE PROGRAM WILL GO TO RESTART
     1SECTION'/)
  851 FORMAT(1H )
  852 FORMAT(1H ,3X,'I',6X,I3,9(9X,I3))
  853 FORMAT(1H ,1X,'X(I)',1X,F10.5,2X,9(F10.5,2X))
  854 FORMAT(1H ,1X,'G(I)',1X,F10.5,2X,9(F10.5,2X))
  855 FORMAT(1H ,1X,'P(I)',1X,F10.5,2X,9(F10.5,2X))
  875 FORMAT(1H )
  876 FORMAT(//1X,5H*****/)
  877 FORMAT(1H ,/)
CCC 6010 FORMAT(1H ,' TIME FOR CYCLE',I3,' IS',F7.1,' SECONDS.')
 7135 FORMAT('0TEST ON ALPHA.P.G SATISFIED')
 7136 FORMAT(1H ,' -ALPHA.P.G    = ',E11.4/)
      END
C     *****************************************************************
      SUBROUTINE LINMIN
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     CUBIC LINE SEARCH
C     *
      REAL ITA,LAMBDA
      COMMON
     ./CCCCK / ICCHK,SMVAL
     ./DFP   / X(99),N
     ./FLPOCM/ NN,MAXIT,TOLIT(3),FAC,IPRINT,Q(99),P(99),G,T,F
     ./LIN1  / FA,FB,FLAST,GA,GB,ITA,LAMBDA,RLAL,TA,TB,TLAST,TDUM(201)
     ./LIN2  / ICOUNT,IHK,INUMB,IDUM(3)
     ./OVERLY/ IOV,JOV,KOV,LOV
     ./PASS3 / JPRINT,JNRST,NCOUNT,COS,PNORM,LNSTOP,IREPET
     ./XXMAXM/ XMAXM,PMSTE,DELL,TDEL
C     OVERLAY CONTROL
      IF(IOV.EQ.0) GO TO 1
      IF(JOV.EQ.0) GO TO 1
      GO TO (101,102,103),LOV
C     SETUP PHASE
    1 T = T*FAC
      IHK=1
      TLAST = 0.0
      FLAST = 0.0
      IF (IPRINT) 2,3,3
    2 WRITE(6,84)
      WRITE(8,84)
      WRITE(6,85)
      WRITE(8,85)
      WRITE(6,86)
      WRITE(8,86)
    3 ICOUNT = NCOUNT
      INUMB=0
      FB = F
      GB = G
      IF (GB .LT. 0.0)  GO TO 5
      DO 4 I=1,NN
    4 P(I) = -P(I)
      GB = -GB
C     WE ARE SEARCHING DOWNHILL
    5 ITA = T
      T = 0.0
    7 FA = FB
      GA = GB
      TA = T
      IF(INUMB.EQ.0) GO TO 6322
      IF(ITA.GT.XMAXM) ITA=XMAXM
 6322 CONTINUE
      T = T+ITA
      TB = T
C     FORM THE NEW VARIABLES.  STEP SIZE ITA, SEARCH DIRECTION P.
      DO 8 I=1,NN
    8 X(I) = X(I)+ITA*P(I)
C     CALCULATE NEW ENERGY AND GRADIENT CORRESPONDING TO NEW VARIABLES
  101 LOV=1
      CALL COMPFG(NN,X,FB,Q)
      IF(JOV.EQ.1) RETURN
      INUMB=INUMB+1
      NCOUNT = NCOUNT+1
C     GB IS THE PROJECTION OF THE GRADIENT ALONG P
      GB = 0.0
      DO 98 I=1,NN
   98 GB = GB+P(I)*Q(I)
      IF (IPRINT) 9,10,10
    9 WRITE(6,88) INUMB,TA,TB,FA,FB,GA,GB
      WRITE(8,88) INUMB,TA,TB,FA,FB,GA,GB
   10 IF (.NOT.((GB .LT. 0.0) .AND. (FB .LT. FA)))  GO TO 11
      ITA = 4.0*ITA
      IF ((NCOUNT-ICOUNT) .GE. MAXIT)  GO TO 203
      GO TO 7
C     CALCULATE THE DISTANCE LAMBDA ALONG THE SEARCH DIRECTION P
C     SUCH THAT LAMBDA IS THE DISTANCE CORRESPONDING TO THE
C     MINIMUM IN A CUBIC EQUATION
   11 Z = 3.0*(FA-FB)/ITA +GA+GB
      W = Z*Z-GA*GB
      IF (W .LT. 0.0)  W = 0.0
      W = DSQRT(W)
      TEMP = GA+Z
      IF (TEMP .GE. 0.0)  LAMBDA=ITA*(1.0-(GA+Z+W)/(GA+GB+2.0*Z))
      IF (TEMP .LT. 0.0)  LAMBDA=ITA*(1.0-GA/(GA+Z-W))
      IF ((LAMBDA .LE. 0.0) .OR. (LAMBDA .GE. ITA))  LAMBDA=ITA/2.0
      T = TB-LAMBDA
      HKCON=DABS((T-TLAST)*G)
      IF(IHK.EQ.1) GO TO 3001
      IF(HKCON.LT.0.00005) GO TO 199
 3001 CONTINUE
C     X IS THE GEOMETRY OF THE PREDICTED MINIMUM ALONG THE LINE
      DO 12 I=1,NN
   12 X(I) = X(I)-LAMBDA*P(I)
C     CALCULATE ENERGY AND GRADIENTS AT THE PREDICTED MINIMUM
  102 LOV=2
      CALL COMPFG(NN,X,F,Q)
      IF(JOV.EQ.1) RETURN
      INUMB=INUMB+1
      NCOUNT = NCOUNT+1
C     G IS THE PROJECTION OF THE GRADIENT ALONG P
      G = 0.0
      DO 99 I=1,NN
   99 G = G+P(I)*Q(I)
      IF (IPRINT) 120,125,125
  120 WRITE(6,87) INUMB,TA,T,TB,FA,F,FB,GA,G,GB
      WRITE(8,87) INUMB,TA,T,TB,FA,F,FB,GA,G,GB
  125 TTEST = DABS(TLAST-T)
      IF (T .NE. 0.0)  TTEST = TTEST/DABS(T)
      IF (TTEST .LT. TOLIT(1))  GO TO 200
      FTEST = DABS(FLAST-F)
      IF (F .NE. 0.0)  FTEST = FTEST/DABS(F)
      IF (FTEST .LT. TOLIT(2))  GO TO 201
      IF (DABS(G) .LT. TOLIT(3))  GO TO 202
      IF ((NCOUNT-ICOUNT) .GE. MAXIT) GO TO 203
      TLAST = T
      FLAST = F
      RLAL=LAMBDA
      IF (G .GT. 0.0)  GO TO 13
      IF (F .LT. FA)  GO TO 131
      IHK=1
      Z = ITA-LAMBDA
      ITA = Z/4.0
      FB = FA
      GB = GA
      T = TA
      DO 132 I=1,NN
  132 X(I) = X(I)-Z*P(I)
      GO TO 7
  131 ITA = LAMBDA
      IHK=2
      FA = F
      GA = G
      TA = T
      T = TB
      DO 130 I=1,NN
  130 X(I) = X(I)+LAMBDA*P(I)
      GO TO 11
   13 ITA = ITA-LAMBDA
      IHK=3
      FB = F
      GB = G
      TB = T
      GO TO 11
  199 LNSTOP=5
      T=TLAST
      IF(IHK.EQ.3) GO TO 3002
      DO 3004 I=1,NN
 3004 X(I)=X(I)-RLAL*P(I)
 3002 CONTINUE
  200 LNSTOP = 2
      GO TO 100
  201 LNSTOP = 3
      GO TO 100
  202 LNSTOP = 4
      GO TO 100
  203 LNSTOP = 1
  103 LOV=3
      CALL COMPFG(NN,X,F,Q)
      IF(JOV.EQ.1) RETURN
      NCOUNT = NCOUNT+1
  100 CONTINUE
      ICCHK=0
      IF(F.GT.SMVAL)ICCHK=1
  301 CONTINUE
      RETURN
   84 FORMAT(' ///// LINMIN ENTERED, CUBIC SEARCH')
   85 FORMAT(1H )
   86 FORMAT(1H ,2X,'I',7X,'XA',11X,'X',10X,'XB',13X,'FA',13X,'F',14X,'F
     1B',12X,'GA',10X,'G',11X,'GB',5X)
   87 FORMAT(1H ,1X,I2,3X,E10.3,2(2X,E10.3),3X,F13.8,2(2X,F13.8),3X,E10.
     13,2(2X,E10.3),1X,I3,3X,F5.1)
   88 FORMAT(1H ,1X,I2,3X,E10.3,2X,E10.3,12X,3X,F13.8,2X,F13.8,15X,3X,E1
     10.3,2X,E10.3,12X,1X,I3,3X,F5.1)
      END
C     *****************************************************************
CCC     ./LIN1  / FA,FB,FLAST,GA,GB,ITA,LAMBDA,RLAL,TA,TB,TLAST,TDUM(201
      SUBROUTINE LOCMIN
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     QUADRATIC LINE SEARCH
C     *
      INTEGER LEFT,RIGHT,CENTER
      COMMON
     ./CCCCK / ICCHK,SSQLST
     ./DFP   / X(99),N
     ./FLPOCM/ NN,MXLN,TOLN(3),FC,IPRINT,EFS(99),P(99),GGGG,T,F
     ./LIN1  / ALFS,ENERGY,EPS,ESTOR,FIN,GSTOR(99),PHI(3),SQSTOR,TEE,
     .         TLAST,VT(3),XSTOR(99)
     ./LIN2  / CENTER,ICTR,IQT,LEFT,MXCT,RIGHT
     ./OVERLY/ IOV,JOV,KOV,LOV
     ./PASS3 / JPRINT,JNRST,NCOUNT,COS,PNORM,LNSTOP,IREPET
     ./XLSQ1 / XMINM,XCRIT,YMAXST,YMINST,MXCONT,TOLS(6)
     ./XXMAXM/ XMAXM,PMSTE,DELL,TDEL
      IF(IOV.EQ.0) GO TO 300
      IF(JOV.EQ.0) GO TO 300
      GO TO (301,302,303),LOV
  300 CONTINUE
      EPS=TOLS(5)
      TEE=TOLS(6)
      FIN = F
      IQT=0
      PHI(1) = F
      VT(1) = 0.0
      VT(2) = T/4.0
      IF(VT(2).GT.XMAXM) VT(2)=XMAXM
      T = VT(2)
      DO 1 I=1,N
    1 X(I) = X(I)+T*P(I)
  301 LOV=1
      CALL COMPFG(N,X,PHI(2),EFS)
      IF(JOV.EQ.1) RETURN
      CALL EXCHNG(PHI(2),SQSTOR,ENERGY,ESTOR,X,XSTOR,EFS,GSTOR,T,ALFS,N)
      IF (PHI(1) .GT. PHI(2))  GO TO 101
  100 VT(3) = -VT(2)
      LEFT = 3
      CENTER = 1
      RIGHT = 2
      GO TO 102
  101 VT(3)=2.0*VT(2)
      LEFT = 1
      CENTER = 2
      RIGHT = 3
  102 TLAST = VT(3)
      T = TLAST-T
      DO 2 I=1,N
    2 X(I) = X(I)+T*P(I)
  302 LOV=2
      CALL COMPFG(N,X,F,EFS)
      IF(JOV.EQ.1) RETURN
      IF(F.LT.SQSTOR) CALL EXCHNG(F,SQSTOR,ENERGY,ESTOR,X,XSTOR,EFS,
     1GSTOR,T,ALFS,N)
      IF(F.LT.FIN) IQT=1
      NCOUNT = NCOUNT+2
      PHI(3) = F
      IF (IPRINT) 200,201,201
  200 WRITE (6,500) VT(1),PHI(1),VT(2),PHI(2),VT(3),PHI(3)
      WRITE (8,500) VT(1),PHI(1),VT(2),PHI(2),VT(3),PHI(3)
  201 MXCT=MXCONT
      ICTR=2
  202 ICTR=ICTR+1
      ALPHA = VT(2) - VT(3)
      BETA = VT(3) - VT(1)
      GAMMA = VT(1)-VT(2)
      ALPHA =-(PHI(1)*ALPHA+PHI(2)*BETA+PHI(3)*GAMMA)/(ALPHA*BETA*GAMMA)
      BETA = ((PHI(1)-PHI(2))/GAMMA)-ALPHA*(VT(1)+VT(2))
      IF (ALPHA)  3,3,4
    3 IF (PHI(RIGHT) .GT. PHI(LEFT))  GO TO 31
      T = 3.0*VT(RIGHT)-2.0*VT(CENTER)
      GO TO 42
   31 T = 3.0*VT(LEFT)-2.0*VT(CENTER)
   42 S=T-TLAST
      IF(DABS(S).GT.XMAXM) S=DSIGN(XMAXM,S)
      T=S+TLAST
      GO TO 43
    4 T = -BETA/(2.0*ALPHA)
      S=T-TLAST
      XXM=2.0*XMAXM
      IF(DABS(S).GT.XXM) S=DSIGN(XXM,S)
      T=S+TLAST
   43 CONTINUE
      IF(ICTR.LE.3) GO TO 75
      AABS=DABS(S*XMINM)
      IF(AABS.LT.XCRIT) GO TO 12
   75 CONTINUE
      DO 5 I=1,N
    5 X(I) = X(I)+S*P(I)
  303 LOV=3
      CALL COMPFG(N,X,F,EFS)
      IF(JOV.EQ.1) RETURN
      IF(F.LT.SQSTOR) CALL EXCHNG(F,SQSTOR,ENERGY,ESTOR,X,XSTOR,EFS,
     1GSTOR,T,ALFS,N)
      IF(F.LT.FIN) IQT=1
      NCOUNT = NCOUNT+1
      IF (IPRINT) 600,601,601
  600 WRITE (6,501) VT(LEFT),PHI(LEFT),VT(CENTER),PHI(CENTER),
     1  VT(RIGHT),PHI(RIGHT),T,F
      WRITE (8,501) VT(LEFT),PHI(LEFT),VT(CENTER),PHI(CENTER),
     1  VT(RIGHT),PHI(RIGHT),T,F
  601 CONTINUE
      IF((DABS(T-TLAST).LE.EPS*DABS(T+TLAST)+TEE).AND.(IQT.EQ.1))
     1 GO TO 12
      TLAST = T
      IF ((T .GT. VT(RIGHT)) .OR. (T .GT. VT(CENTER) .AND. F .LT.
     1  PHI(CENTER)) .OR. (T .GT. VT(LEFT) .AND. T .LT. VT(CENTER) .AND.
     2  F .GT. PHI(CENTER)))  GO TO 7
      VT(RIGHT) = T
      PHI(RIGHT) = F
      GO TO 8
    7 VT(LEFT) = T
      PHI(LEFT) = F
    8 IF (VT(CENTER) .LT. VT(RIGHT))  GO TO 9
      I = CENTER
      CENTER = RIGHT
      RIGHT = I
    9 IF (VT(LEFT) .LT. VT(CENTER))  GO TO 10
      I = LEFT
      LEFT = CENTER
      CENTER = I
   10 IF (VT(CENTER) .LT. VT(RIGHT))  GO TO 11
      I = CENTER
      CENTER = RIGHT
      RIGHT = I
   11 IF(ICTR.LT.MXCT) GO TO 202
   12 CONTINUE
      CALL EXCHNG(SQSTOR,F,ESTOR,ENERGY,XSTOR,X,GSTOR,EFS,ALFS,T,N)
      IF(F.GE.SSQLST) ICCHK=1
      IF(F.GE.SSQLST) RETURN
      IF (T) 13,15,15
   13 T = -T
      DO 14 I=1,N
   14 P(I) = -P(I)
   15 CONTINUE
      ICCHK=0
      RETURN
  500 FORMAT(' ////LOCMIN',11X,'ALPHA',13X,'F(X)'// 5X,'LEFT   ...',
     1  2E17.8/5X,'CENTER ...',2E17.8/5X,'RIGHT  ...',2E17.8/)
  501 FORMAT(5X,'LEFT   ...',2E17.8/5X,'CENTER ...',2E17.8/5X,
     1  'RIGHT  ...',2E17.8/5X,'NEW    ...',2E17.8/)
      END
C     *****************************************************************
      SUBROUTINE EXCHNG(A,B,C,D,X,Y,E,F,T,Q,N)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION X(99),Y(99),E(99),F(99)
      B=A
      D=C
      Q=T
      DO 30 I=1,N
      Y(I)=X(I)
      F(I)=E(I)
   30 CONTINUE
      RETURN
      END
C     *****************************************************************
      SUBROUTINE COMPFG(NVAR,X,ENERGY,G)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     THIS ROUTINE CALLS THE SCF PART.
C     *
      COMMON
     ./ERG   / EX,GG(99)
     ./FLAG3 / KRESET,IWADE
     ./OVERLY/ IOV,JOV,KOV,LOV
     ./PARM1 / A(3,50),NA(203)
     ./PARM3 / LOC(2,99)
     ./SEARCH/ JOP
      DIMENSION G(99),X(99)
      IF(IOV.EQ.1 .AND. JOV.EQ.1) GO TO 15
C     MAKE CHANGES IN THE GEOMETRY.
      DO 5 I=1,NVAR
      K=LOC(1,I)
      L=LOC(2,I)
    5 A(L,K)=X(I)
C     DEFINE THE PRESENT GEOMETRY.
      CALL SYMTRY(-1)
      CALL GMETRY(-1)
C     CALL THE SCF PART.
      IF(IOV.EQ.0) GO TO 10
      JOV=1
      RETURN
   10 CONTINUE
   15 JOV=0
C     STORE ENERGY AND GRADIENTS.
      ENERGY=EX
      IF(IWADE.EQ.-1) RETURN
      FUN=0.
      DO 20 I=1,NVAR
      FUN=FUN+GG(I)*GG(I)
      G(I)=GG(I)
      IF(DABS(G(I)).LT.0.00001) G(I)=0.00001
   20 CONTINUE
      IF(JOP.EQ.1) ENERGY=FUN
      RETURN
      END
C     ******************************************************************
C     ******************************************************************
      SUBROUTINE START (A,LM5)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     INPUT SECTION OF THE PROGRAM
C     *
      COMMON
     ./CNTROL/ ICNTRL
     ./FLAG1 / KTITLE(12),KOMENT(10),KHARGE,KGEOM,KITSCF(8)
     ./LIMITS/ LM1,LM2,LM3,LM4,LMA(5)
     ./OPTION/ IOP
     ./SETCI / KCI
      DIMENSION A(LM5)
      IF (ICNTRL.NE.0) GO TO 10
C     INITIALIZATION.
      CALL ZLIMIT
      CALL OBFAC
      IF(IOP.LE.0) CALL PARAM
CCC      IF(IOP.EQ.1) CALL MPARAM
CCC      IF(IOP.GT.1) CALL CPARAM
      CALL METHOD
C     INPUT OF MOLECULAR GEOMETRY.
   10 CALL INPUT (A,LM5)
      IF(KHARGE.EQ.99) STOP
      IF(KGEOM.GT.0) RETURN
C     INPUT OF CORRELATION DATA.
      IF(KCI.EQ.0) GO TO 30
      IF(IABS(KCI).GT.1) GO TO 20
      CALL SETUPS
      GO TO 30
   20 CALL INSYMC
      CALL SYMMC
C     DYNAMIC CORE ALLOCATION.
   30 CALL DYNCOR (LSP)
C     INITIAL DENSITY MATRIX.
      CALL GUESSP (A,A(LSP),LM2,LM3,LM4,KHARGE)
      RETURN
      END
C     ******************************************************************
      SUBROUTINE ZLIMIT
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     INPUT OF TIME LIMIT, SCF OPTION AND SEARCH OPTION.
C     *
      COMMON
     ./BESAFE/ TLIMIT,SFDFP,SFSCF
     ./OPTION/ IOP
     ./SEARCH/ JOP
      READ(5,100) LIMIT,IOP,JOP
      IF(LIMIT.EQ.0) LIMIT=3600
      TLIMIT=FLOAT(LIMIT)
      SFSCF=0.
      IF(IOP.LT.0) WRITE(6,105)
c      IF(IOP.LT.0) WRITE(8,105)
      IF(IOP.EQ.0) WRITE(6,110)
c      IF(IOP.EQ.0) WRITE(8,110)
      IF(IOP.EQ.1) WRITE(6,120)
c      IF(IOP.EQ.1) WRITE(8,120)
      IF(IOP.EQ.2) WRITE(6,130)
c      IF(IOP.EQ.2) WRITE(8,130)
      JOP=0
      RETURN
  100 FORMAT(10I5)
  105 FORMAT(/1X,'MNDOC')
  110 FORMAT(/1X,'MNDO')
  120 FORMAT(/1X,'MINDO/3')
  130 FORMAT(/1X,'CNDO/2')
      END
C     ******************************************************************
      SUBROUTINE OBFAC
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON
     ./XFACT / FACTE(15)
      X=1.
      DO 30 I=1,15
      X=X*FLOAT(I)
      FACTE(I)=X
   30 CONTINUE
      RETURN
      END
