C     PROGRAM MNDOC, QCPE VERSION.
C     BY WALTER THIEL, FACHBEREICH PHYSIKALISCHE CHEMIE DER PHILIPPS-
C     UNIVERSITAET, AUF DEN LAHNBERGEN, D-3550 MARBURG, WEST-GERMANY.
C
C     PROGRAM TO CARRY OUT MNDOC, MNDO, MINDO/3 AND CNDO/2 CALCULATIONS
C     AND TO LOCATE ENERGY MINIMA ON POTENTIAL ENERGY SURFACES BY THE
C     DFP METHOD.
C
C     THANKS ARE DUE TO ALL THOSE WHO WORKED ON EARLIER VERSIONS OF
C     SUBROUTINES IN THIS PROGRAM - AMONG THEM N.C.BAIRD, R.C.BINGHAM,
C     C.E.DOUBLEDAY, R.C.HADDON, H.W.KOLLMAR, D.H.LO, AND P.K.WEINER.
C
C     ******************************************************************
C
C     REFERENCES.
C
C     MNDOC     W.THIEL, J.AM.CHEM.SOC. 103, 1413, 1420 (1981).
C     MNDO      M.J.S.DEWAR AND W.THIEL, J.AM.CHEM.SOC. 99, 4899 (1977).
C     MINDO/3   R.C.BINGHAM, M.J.S.DEWAR AND D.H.LO, J.AM.CHEM.SOC.
C               97, 1285 (1975).
C     CNDO/2    J.A.POPLE AND G.A.SEGAL, J.CHEM.PHYS. 44, 3289 (1966).
C     DFP       R.FLETCHER AND M.J.D.POWELL, COMPUT.J. 6, 163 (1963).
C               W.C.DAVIDON, COMPUT.J. 10, 406 (1968).
C
C     ******************************************************************
C
C     OUTLINE OF INPUT.
C
C     IN THIS SECTION, THE INPUT FOR THE PROGRAM IS SUMMARIZED BRIEFLY.
C     A MORE DETAILED DESCRIPTION WILL BE GIVEN IN THE NEXT SECTION.
C
C     THE INPUT CONSISTS OF THE FOLLOWING PARTS.
C
C     1.    TIME LIMIT CARD, WITH CHOICE OF SCF METHOD.
C           THE PROGRAM WILL STOP A DFP OPTIMIZATION IF THE TIME LIMIT
C           IS APPROACHED. THE OPTIMIZATION CAN BE CONTINUED IN ANOTHER
C           JOB.
C     2.    ONE OR THREE CARDS FOR DFP OPTIONS. IT IS RECOMMENDED TO USE
C           THE DEFAULT VALUES. IN THIS CASE, ONLY THE FIRST DFP CARD IS
C           NEEDED (TO SPECIFY THE VARIABLES MAXEND AND MIDDLE).
C     3.    CARDS FOR THE FIRST MOLECULE.
C     3.1.  TITLE CARD, INCLUDING OPTIONS.
C     3.2.  ATOMIC NUMBERS AND INTERNAL COORDINATES, ONE CARD PER ATOM,
C           WITH A BLANK CARD AT THE END.
C     3.3.  OPTION KSYM=1. SYMMETRY CONDITIONS, PART 1.
C     3.4.  OPTION KDEP=1. DEFINITION OF DEPENDENT PARAMETERS.
C     3.5.  OPTION KSYM=1. SYMMETRY CONDITIONS, PART 2.
C     3.6.  OPTION IABS(KCI)=1.   CONFIGURATION INTERACTION DATA.
C     3.7.  OPTION IABS(KCI)=2-4. PERTURBATION TREATMENT, SYMMETRY DATA.
C     3.8.  OPTION IABS(KCI)=2-4. PERTURBATION TREATMENT, OTHER DATA.
C     4.    CARDS FOR THE FOLLOWING MOLECULES (OPTIONAL).
C           THE PROGRAM ALLOWS COMPUTATIONS FOR AN ARBITRARY NUMBER
C           OF MOLECULES TO BE CARRIED OUT IN A SINGLE JOB. THE INPUT
C           FOR EACH NEW MOLECULE CONSISTS OF A NEW SET OF CARDS AS
C           DESCRIBED UNDER 3. A SIMPLIFIED INPUT FOR REACTION PATH
C           CALCULATIONS IS AVAILABLE, TOO.
C     5.    LAST CARD. THE INPUT IS TERMINATED BY A CARD WHICH HAS 99
C           PUNCHED IN COLUMNS 1-2.
C
C     INPUT FOR CONTINUATION JOBS.
C     IN ORDER TO CONTINUE AN UNCOMPLETED DFP OPTIMIZATION, THE INPUT
C     DECK FOR THE CORRESPONDING MOLECULE IS RESUBMITTED AFTER SETTING
C     MIDDLE ON CARD 2. THE CONTINUATION JOB MAKES USE OF THE DFP
C     INFORMATION SAVED ON FILE 4 BY THE PRECEDING JOB.
C
C     ******************************************************************
C
C     DESCRIPTION OF INPUT.
C
C     COLUMNS  NAME   FORMAT          DESCRIPTION
C
C     ***** TIME LIMIT CARD ********************************************
C
C        1-5  LIMIT     I5     TIME LIMIT IN SECONDS. DEFAULT 3600.
C        5-10 IOP       I5     CHOICE OF SEMIEMPIRICAL SCF METHOD.
C                              -1 MNDOC, 0 MNDO, 1 MINDO/3, 2 CNDO/2.
C
C     *****  CARD FOR DFP OPTIONS  *************************************
C
C        1-2  MAXEND    I2     MAXIMUM NUMBER OF SCF CALCULATIONS
C                              TO BE DONE FOR EACH MOLECULE.
C                              THE MOLECULAR GEOMETRY WILL BE OPTIMIZED
C                              FOR MAXEND.EQ.0 AND FOR MAXEND.GT.3.
C                              =0 SET MAXEND=9999 (DEFAULT VALUE)
C                              =1 ONE SCF CALCULATION FOR EACH MOLECULE
C                              =2 ONE SCF CALCULATION FOR THE FIRST
C                                 MOLECULE, THEN SET MAXEND=9999 FOR
C                                 THE REMAINING MOLECULES (USEFUL FOR
C                                 REACTION PATH CALCULATIONS)
C                              =3 GRADIENT CALCULATION FOR EACH MOLECULE
C        3-4  IPRINT    I2     PRINT SWITCH. +K WILL PRINT GEOMETRY AND
C                              GRADIENT EVERY K-CYCLES. -K WILL PRINT
C                              THESE ALONG WITH THE SEARCH DIRECTIONS
C                              AND LINE MINIMIZATION INFORMATION EVERY
C                              K-CYCLES. DEFAULT +99.
C        5-6  IREP      I2     =1 INTERNAL COORDINATES SAVED ON FILE 7
C                              =2 CARTESIAN COORDINATES SAVED ON FILE 7
C        7-8  IOPTC     I2     =1 READ DFP PARAMETERS ON THE FOLLOWING
C                                 TWO CARDS
C                              FOR IOPTC.NE.1 OMIT THE NEXT TWO CARDS
C                              FOR IOPTC.NE.0 PRINT THE DFP OPTIONS
C        9-10 MIDDLE    I2     =0  NORMAL JOB.
C                              =1  CONTINUATION OF A PREVIOUS JOB
C                                  STARTING WITH A NEW DFP CYCLE AND
C                                  USING INFORMATION SAVED ON FILE 4
C                                  VIA MIDDLE=0.
C                              =2  CONTINUATION OF A PREVIOUS JOB
C                                  WITHIN A DFP CYCLE USING INFORMATION
C                                  SAVED ON FILE 4 VIA MIDDLE=-2.
C                              =-2 INFORMATION ON FILE 4 IS PERMANENTLY
C                                  UPDATED TO ALLOW FOR CONTINUATION
C                                  WITHIN A DFP CYCLE VIA MIDDLE=2.
C                              OPTIONS MIDDLE=-2,+2 SHOULD BE USED ONLY
C                              IF ONE DFP CYCLE CANNOT BE COMPLETED IN
C                              A SINGLE JOB.
C       11-12 NOPRT     I2     FOR NOPRT.LT.0 NO OUTPUT OF DFP DATA.
C                              NOPRT OVERRIDES IPRINT OPTION.
C       15-16 NWSKP     I2     =1 DETAILED PRINTING IN QUADRATIC SEARCH
C       17-18 IGRAD     I2     =1 QUADRATIC SEARCH IS USED THROUGHOUT
C                                 (OVERRIDES USUAL INTERNAL SELECTION)
C       19-20 JPRINT    I2     FOR JPRINT.LT.0 NO OUTPUT OF INPUT DATA
C       21-22 ISCF      I2     SCF TOLERANCE. (10**(-ISCF)) EV.
C                              DEFAULT 4 FOR GEOMETRY OPTIMIZATION
C                              DEFAULT 5 FOR FIXED GEOMETRY
C       23-24 ISCFF     I2     SCF TOLERANCE FOR CALCULATION OF GRADIENT
C                              (10**(-ISCFF)) EV. DEFAULT 4.
C       25-26 ISFDFP    I2     DFP SAFETY FACTOR. DEFAULT 15.
C                              THE JOB WILL TERMINATE IF THE REMAINING
C                              TIME IS LESS THAN (0.1*FLOAT(ISFDFP)*
C                              TIME FOR THE PREVIOUS DFP CYCLE).
C       41-80 KOMENT   10A4    COMMENT ON DFP OPTIMIZATION
C
C   *****  OMIT IF IOPTC.NE.1 ******************************************
C   *****  SPECIAL OPTIONS FOR DFP AND CUBIC LINE SEARCH  **************
C
C       1-2   MAXLIN    I2     NUMBER OF SCF CALCULATIONS ALLOWED FOR
C                              EACH LINE MINIMIZATION.
C                              DEFAULT 15.
C       3-4   IIN       I2     EXPONENT FOR LINE MINIMIZATION
C                              TOLERANCE (10**(-IIN))
C                              DEFAULT 4.
C       5-6   IEND      I2     EXPONENT FOR DFP OPTIMIZATION
C                              TOLERANCE  (10**(-IEND))
C                              DEFAULT 4.
C       7-8   IGG1      I2     NUMBER OF ADDITIONAL CYCLES TO GET ALL
C                              GRADIENT COMPONENTS BELOW TOLERANCE.
C                              DEFAULT 3.
C       9-10  NRST      I2     RESET H MATRIX IN THE DFP SECTION EVERY
C                              NRST CYCLES.
C                              DEFAULT 50
C      11-20  RST      F10.5   RESET H MATRIX WHENEVER THE COSINE OF THE
C                              ANGLE BETWEEN THE GRADIENT AND THE SEARCH
C                              DIRECTION IS LESS THAN RST.
C                              DEFAULT 0.05
C      21-30  FAC      F10.5   LINE MINIMIZATION FACTOR.
C                              DEFAULT 1.0
C      31-40  XFAC     F10.5   SCALING FACTOR FOR STEP SIZE IN GRADIENT
C                              CALCULATION.
C                              DEFAULT 1.0 IN CUBIC SEARCH.
C      41-50  PMSTE    F10.5   MAXIMUM STEP SIZE TAKEN AFTER RESTARTING
C                              H MATRIX. RECOMMEND A NUMBER 0.1 TO 0.5
C                              DEFAULT=0.1
C      51-60  DELL     F10.5   INCREMENT BY WHICH VARIABLES ARE CHANGED
C                              TO RESTART H MATRIX. THIS VALUE DECREASES
C                              AS ENERGY CHANGE DECREASES
C                              DEFAULT=0.01
C      61-70  CCCOS    F10.5   THE VALUE OF RST UNTIL THE PREDICTED
C                              DECREASE IN ENERGY AS GIVEN BY
C                              -ALPHA*P*G IS LE 1.0
C                              DEFAULT=MINIMUM(1.0/SQRT(NUMBER OF
C                              VARIABLES),0.15)
C      71-80  EYEAD    F10.5   CALCULATION ENDS WHEN -ALPHA*P*G LT EYEAD
C                              DEFAULT=0.005
C
C   *****  OMIT IF IOPTC.NE.1 *****************************************
C   *****  SPECIAL OPTIONS FOR QUADRATIC LINE SEARCH  *****************
C
C       1-5   MXCONT    I5     NUMBER OF SCF CALCULATIONS ALLOWED FOR
C                              EACH LINE SEARCH. DEFAULT 15.
C       6-15  YMAXST   F10.5   VARIABLE USED TO DETERMINE MAXIMUM VALUE
C                              FOR ALPHA. DEFAULT 0.1
C      16-25  XCRIT    F10.5   CRITERION ON X. DEFAULT 0.0001
C      36-45  YFAC     F10.5   SCALING FACTOR FOR STEP SIZE IN GRADIENT
C                              CALCULATION.
C                              DEFAULT 100.0 IN QUADRATIC SEARCH.
C      45-75  ITOL(I)  6I5     TOLERANCES (10**(-ITOL(I)))
C             I=1,6            DEFAULT 9,10,12,13,2,2
C
C   ******   TITLE CARD FOR MOLECULE   ********************************
C
C       1-2   KHARGE    I2     MOLECULAR CHARGE
C                              =99 TO END THE RUN
C       3-4   IMULT     I2     MULTIPLICITY
C                              =0 SINGLET, CLOSED-SHELL MOS
C                              =1 SINGLET, OPEN-SHELL HALF-ELECTRON MOS.
C                                 THIS SCF SOLUTION USUALLY CORRESPONDS
C                                 TO AN EXCITED SINGLET STATE.
C                              =2 DOUBLET, OPEN-SHELL HALF-ELECTRON MOS.
C                              =3 TRIPLET, OPEN-SHELL HALF-ELECTRON MOS.
C       5-6   KTRIAL    I2     INITIAL DENSITY MATRIX FOR SCF
C                              =0 STANDARD DIAGONAL MATRIX
C                              =1 DENSITY MATRIX IS IN THE COMPUTER
C                                 FROM PREVIOUS RUN (USEFUL ALONG A
C                                 REACTION PATH)
C                              =2 STANDARD DIAGONAL MATRIX (AS KTRIAL=0)
C                              =3 DENSITY MATRIX WILL BE READ IN
C                                 FROM FILE 1.
C                              =4 EIGENVECTORS WILL BE READ IN FROM
C                                 FILE 1 TO COMPUTE DENSITY MATRIX.
C       7-8   KGEOM     I2     =0 THE TRIAL GEOMETRY IS READ IN.
C                              =1 A NEW VALUE OF THE REACTION COORDINATE
C                                 IS INPUT. THE REST OF THE GEOMETRY IS
C                                 TAKEN FROM THE PREVIOUS RUN.
C                              =-1 PROGRAM TERMINATES AFTER COMPUTING
C                                  COORDINATES AND DISTANCES (USEFUL
C                                  FOR CHECKING THE INPUT DATA).
C       9-10  IPUBO     I2     =1 DENSITY MATRIX IS SAVED ON FILE 1.
C                                 IPUBO IS SET EQUAL TO 1, IF KTRIAL=3.
C      11-12  IPUEV     I2     =1 EIGENVECTORS ARE SAVED ON FILE 1.
C                                 IPUEV IS SET EQUAL TO 1, IF KTRIAL=4.
C                                 IPUEV IS SET EQUAL TO 0, IF IPUBO =1.
C      13-16  KITSCF    I4     NUMBER OF SCF ITERATIONS. DEFAULT=50.
C      17-18  NPRINT    I2     =-1 PRINTS NO SCF-INFORMATION.
C                              = 0 PRINTS C,P MATRICES, NET CHARGES,
C                                  AND DIPOLE MOMENT (DEFAULT VALUE)
C                              =+1 PRINTS H,F MATRICES, TOO.
C                              =+2 PRINTS ELECTRONIC ENERGY IN EACH
C                                  SCF-ITERATION, TOO, IF MAXEND.LE.3.
C      21-22  KSYM      I2     NONZERO IF SYMMETRY CONDITIONS ARE TO
C                              BE INPUT.
C      23-24  KDEP      I2     NONZERO IF DEPENDENT FUNCTIONS ARE TO BE
C                              INPUT. THESE DEPENDENT FUNCTIONS RELATE
C                              CHANGES IN THE PARAMETERS TO EACH OTHER.
C                              THE USER MUST SUPPLY THE REQUIRED
C                              EQUATIONS FOR EACH MOLECULAR SYSTEM
C                              INVESTIGATED. THESE ARE PART OF THE
C                              USER SUPPLIED SUBROUTINE DEPVAR.
C                              SOME STANDARD DEPENDENT FUNCTIONS ARE
C                              PREDEFINED IN SUBROUTINE HADDON.
C      25-26  KCI       I2     =0 NO CORRELATION TREATMENT.
C                              =1 MINIMAL CONFIGURATION INTERACTION
C                                 2*2 CI FOR SINGLET, CLOSED-SHELL MOS.
C                                 3*3 CI FOR SINGLET, OPEN-SHELL MOS.
C                                 2*2 CI FOR DOUBLET, OPEN-SHELL MOS.
C                              =2 BRILLOUIN-WIGNER PERTURBATION TREATMEN
C                                 WITH ONE MAIN CONFIGURATION. BWEN.
C                              =3 BRILLOUIN-WIGNER PERTURBATION TREATMEN
C                                 WITH TWO MAIN CONFIGURATIONS. BWEN1.
C                              =4 BRILLOUIN-WIGNER PERTURBATION TREATMEN
C                                 WITH TWO MAIN CONFIGURATIONS. BWEN2.
C                              IF KCI IS NEGATIVE, GEOMETRY OPTIMIZATION
C                              ARE CARRIED OUT AT THE SCF LEVEL, FOLLOWE
C                              BY A SINGLE CORRELATION CALCULATION AT TH
C                              OPTIMIZED GEOMETRY, ACCORDING TO IABS(KCI
C      27-28  NSTART    I2     FIRST SCF EXTRAPOLATION IN CYCLE NSTART.
C                              DEFAULT 4.
C      29-30  NSTEP     I2     FOLLOWING SCF EXTRAPOLATIONS EVERY NSTEP
C                              CYCLES. DEFAULT 4.
C      31-78  KTITLE   12A4    TITLE FOR THE MOLECULE.
C
C ***** TRIAL MOLECULAR GEOMETRY ***** ONE CARD PER ATOM ***************
C
C       1-2   NAT(I)    I2    ATOMIC NUMBER OF ATOM (I).
C                             =99 IF THE ATOM IS A DUMMY (IE. TO ASSIST
C                                 IN THE DEFINITION OF THE GEOMETRY)
C                             = 0 TO END INPUT OF GEOMETRY.
C      11-20  A(1,I)   F10.5  INTERATOMIC SEPARATION (IN ANGSTROMS)
C                             BETWEEN ATOMS I AND NA(I).
C      23-24  LA        I2    =-1 IF A(1,I) IS THE REACTION COORDINATE.
C                             = 0 IF A(1,I) IS NOT TO BE OPTIMIZED.
C                             =+1 IF A(1,I) IS TO BE OPTIMIZED.
C      31-40  A(2,I)   F10.5  THE ANGLE NB(I)-NA(I)-(I) IN DEGREES.
C      43-44  LB        I2    =-1,0,+1 AS WITH LA.
C      51-60  A(3,I)   F10.5  THE ANGLE BETWEEN THE VECTORS NC(I)-NB(I)
C                             NA(I)-(I) IN DEGREES  MEASURED CLOCKWISE
C                             IN THE DIRECTION B TO A.
C      63-64  LC        I2    =-1,0,+1 AS WITH LA AND LB.
C      71-72  NA(I)     I2    ATOM NUMBER (SEE ABOVE).
C      73-74  NB(I)     I2    ATOM NUMBER (SEE ABOVE).
C      75-76  NC(I)     I2    ATOM NUMBER (SEE ABOVE).
C
C          *****  NOTE  ***** SIMPLIFIED INPUT FOR ATOMS 1-3.
C                             ATOM 1, ONLY NAT(1).
C                             ATOM 2, ONLY NAT(2),A(1,2),LA.
C                             ATOM 3, ONLY NAT(3),A(1,3),LA,A(2,3),LB.
C                             THE PROGRAM ALWAYS ASSUMES
C                             NA(2)=1, NA(3)=2, NB(3)=1.
C
C                             END INPUT OF GEOMETRY WITH A BLANK CARD.
C
C ***** SYMMETRY DATA ***** KSYM=1 *************************************
C
C          ***** PART 1 ***** SYMMETRY DATA TO BE IMPOSED BEFORE COM-
C                             PUTING DEPENDENT PARAMETER VALUES.
C                             ONE SET OF EQUAL BOND LENGTHS, EQUAL BOND
C                             ANGLES, OR EQUAL TWIST ANGLES CONSISTS OF
C                             A PRIMARY VARIABLE WHICH MAY BE OPTIMIZED,
C                             AND UP TO FIVE SECONDARY VARIABLES WHICH
C                             ARE SET EQUAL TO THE PRIMARY VARIABLE.
C                             USE MORE THAN ONE CARD IF THERE ARE MORE
C                             THAN FIVE SECONDARY VARIABLES.
C
C       1-2   ISYM(6,I)  I2   ATOM NUMBER ON WHICH THE PRIMARY VARIABLE
C                             OF THE I-TH SET IS LOCATED.
C        5    ISYM(7,I)  I1   TYPE OF VARIABLE IN THE I-TH SET.
C                             =1  BOND LENGTH.
C                             =2  BOND ANGLE.
C                             =3  TWIST ANGLE.
C      11-12  ISYM(8,I)  I2   THE NUMBER OF SECONDARY VARIABLES IN THE
C                             I-TH SET.
C      21-45  ISYM(J,I) (I2,  ATOM NUMBERS ON WHICH THE SECONDARY VARI-
C              J=1,5     3X)  ABLES OF THE I-TH SET ARE LOCATED.
C
C                             END INPUT OF SYMMETRY WITH A BLANK CARD.
C                             IF KDEP=1, A BLANK CARD MUST BE INSERTED
C                             EVEN IF THERE ARE NO SYMMETRY DATA TO
C                             BE IMPOSED BEFORE COMPUTING DEPENDENT
C                             PARAMETER VALUES.
C
C ***** DEPENDENT PARAMETERS ***** KDEP=1 ******************************
C
C                             ONE CARD FOR EACH PARAMETER THAT IS
C                             DETERMINED BY CHANGES IN THE VARIABLE
C                             PARAMETER.
C                             THE FUNCTIONS MUST BE SUPPLIED BY THE USER
C                             IF THE ANGULAR FUNCTIONS SUPPLIED IN
C                             SUBROUTINE HADDON ARE NOT SUFFICIENT.
C
C       1-2   LOCDEP(I)  I2   ATOM NUMBER ON WHICH THE I-TH DEPENDENT
C                             PARAMETER IS LOCATED.
C        4    N          I1   TYPE OF THE I-TH DEPENDENT PARAMETER
C                             =1  BOND LENGTH
C                             =2  BOND ANGLE
C                             =3  TWIST ANGLE
C      10-11  IDEPFN(I)  I2   THE FUNCTION NUMBER USED TO EVALUATE THE
C                             I-TH DEPENDENT PARAMETER.
C                             THIS IS USED IN A  GO TO( , , ,...),IDEPFN
C                             STATEMENT IN SUBROUTINE HADDON OR THE USER
C                             SUPPLIED SUBROUTINE DEPVAR. VALUES 1 TO 14
C                             ARE RESERVED FOR USE IN SUBROUTINE HADDON.
C                             VALUES GREATER THAN 14 MUST BE USED IN
C                             SUBROUTINE DEPVAR.
C      14-15  M          I2   THE NUMBER OF VARIABLES USED TO DETERMINE
C                             DEPENDENT PARAMETER (M=1 IN THIS PROGRAM)
C      21-22  LOCPAR(I)  I2   LOCATION OF THE PARAMETER USED TO DEFINE
C                             THE I-TH DEPENDENT PARAMETER.
C      24     LTYPE      I1   TYPE OF PARAMETER AT LOCPAR(I)
C
C                             END INPUT WITH A BLANK CARD.
C
C ***** SYMMETRY DATA (CONTINUED) ***** KSYM=1  KDEP=1 *****************
C
C          ***** PART 2 ***** SYMMETRY DATA TO BE IMPOSED AFTER COM-
C                             PUTING DEPENDENT PARAMETER VALUES.
C                             IF THERE ARE NO MORE SYMMETRY CONDITIONS
C                             AFTER COMPUTING THE DEPENDENT PARAMETERS,
C                             A BLANK CARD MUST BE INSERTED.
C                             INPUT OF SYMMETRY DATA IS THE SAME AS IN
C                             PART 1.
C
C ***** CONFIGURATION INTERACTION ***** IABS(KCI)=1 ********************
C
C       1-5   LROOT     I5    CI STATE WHOSE GEOMETRY IS OPTIMIZED.
C                             DEFAULT 1.
C       6-10  K         I5    NUMBER OF MO INVOLVED IN CI (SEE BELOW).
C      11-15  L         I5    NUMBER OF MO INVOLVED IN CI (SEE BELOW).
C      16-20  M         I5    NUMBER OF MO INVOLVED IN CI (SEE BELOW).
C      21-25  N         I5    NUMBER OF MO INVOLVED IN CI (SEE BELOW).
C
C     THREE TYPES OF MINIMAL CONFIGURATION INTERACTION ARE POSSIBLE.
C
C     IMULT=0, SINGLET, CLOSED-SHELL MOS, 2*2 CI.
C     K DOUBLY OCCUPIED, DOUBLE EXCITATION K TO L.
C     DEFAULT. HOMO TO LUMO.
C
C     IMULT=1, SINGLET, OPEN-SHELL HALF-ELECTRON MOS, 3*3 CI.
C     K AND L SINGLY OCCUPIED, SINGLE EXCITATIONS K TO M, L TO N.
C     DEFAULT. K TO L, L TO K, I.E. CONFIGURATIONS KK, KL, LL.
C
C     IMULT=2, DOUBLET, OPEN-SHELL HALF-ELECTRON MOS, 2*2 CI.
C     CASE A. K SINGLY OCCUPIED, SINGLE EXCITATION K TO L.
C     CASE B. L SINGLY OCCUPIED, SINGLE EXCITATION K TO L.
C     DEFAULT. CASE A, EXCITATION HOMO TO LUMO.
C
C ***** PERTURBATION TREATMENT, SYMMETRY ***** IABS(KCI)=2-4 ***********
C
C     FOR THE ASSIGNMENT OF MO SYMMETRY IN THE POINT GROUPS CS,C2,C2V,
C     D2H,C2H, THE ORIENTATION OF THE MOLECULE ** MUST ** CONFORM TO
C     THE FOLLOWING CONVENTIONS.
C
C     CS.  XY-PLANE AS CS-PLANE.
C     C2.  Z-AXIS AS C2-AXIS (IAX=0).
C     C2.  X-AXIS AS C2-AXIS (IAX=1).
C     C2V. Z-AXIS AS C2-AXIS, YZ-PLANE AS CS-PLANE (IAX=0).
C     C2V. X-AXIS AS C2-AXIS, XZ-PLANE AS CS-PLANE (IAX=1).
C     D2H. Z-AXIS AS C2-AXIS, XY-PLANE AS MAIN CS-PLANE, YZ-PLANE AS
C          SECOND CS-PLANE.
C     C2H. Z-AXIS AS C2-AXIS, XY-PLANE AS CS-PLANE.
C
C     FOR PLANAR MOLECULES, THE XY-PLANE IS THE MOLECULAR PLANE,WITH TWO
C     EXCEPTIONS. FOR POINT GROUPS C2,C2V AND OPTION IAX=0, THE MOLECULE
C     LIES IN THE XZ-PLANE.
C
C     NOTE. WHEN DEFINING THE NUMBER OF A PARTICULAR ATOM IN THE
C     MOLECULE (OPTIONS IOZ,IDZ,ICEN,ICEN1,ICEN2), DUMMY ATOMS ARE
C     NOT COUNTED.
C
C     *** FIRST CARD ***
C
C       1-4   ISUB      I4    POINT GROUP. 0 NO SYMMETRY, 1 CS, 2 C2,
C                             3 C2V, 4 D2H, 5 C2H.
C       5-8   IOZ       I4    NUMBER OF A UNIQUE ATOM ON THE C2-AXIS
C                             (FOR C2V ONLY).
C       9-12  IAX       I4    0 Z-AXIS AS C2-AXIS
C                             1 X-AXIS AS C2-AXIS (FOR C2,C2V ONLY).
C      13-16  NNXY      I4    TOTAL NUMBER OF ATOMS IN XY-PLANE
C                             (FOR CS,D2H,C2H ONLY). MAXIMUM 15.
C      17-20  NRXY      I4    TOTAL NUMBER OF ATOMS RELATED BY XY-PLANE
C                             (FOR CS,D2H,C2H ONLY). MAXIMUM 24.
C      21-24  NRYZ      I4    TOTAL NUMBER OF ATOMS RELATED BY C2-AXIS
C                             (FOR C2,C2V,C2H ONLY) OR BY YZ-PLANE
C                             (FOR C2V,D2H ONLY). MAXIMUM 24.
C                             NOTE. XZ INSTEAD OF YZ FOR C2V, IAX=1.
C      25-28  IDZ       I4    NUMBER OF ATOM ON AN N-FOLD AXIS USED IN
C                             THE SYMMETRIZATION OF DEGENERATE VECTORS.
C      29-32  IAXE      I4    DEFINITION OF N-FOLD AXIS USED IN THE
C                             SYMMETRIZATION OF DEGENERATE VECTORS.
C                             0 Z-AXIS, 1 X-AXIS, 2 Y-AXIS, 3 Z-AXIS.
C
C     *** SECOND CARD (OMIT IF NNXY.LE.0) ***
C
C       1-30  ICEN(I)  15I2   NUMBERS OF ATOMS IN XY-PLANE.
C
C     *** THIRD  CARD (OMIT IF NRXY.LE.0) ***
C
C       1-48  ICEN1(I) 24I2   NUMBERS OF ATOMS RELATED BY XY-PLANE.
C
C     *** FOURTH CARD (OMIT IF NRYZ.LE.0) ***
C
C       1-48  ICEN2(I) 24I2   NUMBERS OF ATOMS RELATED BY YZ-PLANE.
C
C ***** PERTURBATION TREATMENT, DATA ***** IABS(KCI)=2-4 ***************
C
C     *** FIRST CARD ***
C
C       1-4   ICI1      I4    TOTAL NUMBER OF OCCUPIED ORBITALS TO BE
C                             INCLUDED IN THE PERTURBATION TREATMENT.
C                             DEFAULT ALL, UP TO A MAXIMUM OF 20.
C                             HIGHER ICI1 VALUES (ICI1.GT.20) ARE NOT
C                             SELECTED BY DEFAULT AND MUST BE READ IN.
C       5-8   ICI2      I4    TOTAL NUMBER OF UNOCCUPIED ORBITALS TO BE
C                             INCLUDED IN THE PERTURBATION TREATMENT.
C                             DEFAULT ALL, UP TO A MAXIMUM OF 20.
C                             HIGHER ICI2 VALUES (ICI2.GT.20) ARE NOT
C                             SELECTED BY DEFAULT AND MUST BE READ IN.
C       9-12  IOUTCI    I4    PRINTING FLAG.
C                             0 STANDARD, 4 DEBUG, -5 NO PRINT.
C      13-16  MOVO      I4    DEFINITION OF ORBITALS INVOLVED IN THE
C                             PERTURBATION TREATMENT. DEFAULT 0.
C                             =0  USE ICI1 HIGHEST  OCCUPIED ORBITALS
C                                 AND ICI2 LOWEST UNOCCUPIED ORBITALS.
C                             =1  READ ORBITAL NUMBERS ON EXTRA CARDS.
C      17-20  MPERT     I4    TYPE OF PERTURBATION TREATMENT. DEFAULT 0.
C                             =0  BWEN TREATMENT (SEE BELOW).
C                             =1  SELECT TREATMENT ON EXTRA CARD.
C
C     *** SECOND CARD (OMIT IF MOVO.EQ.0) ***
C
C       1-80  IMOCI(I) 20I4   NUMBERS OF OCCUPIED ORBITALS INVOLVED IN
C            (I=1,ICI1)       THE PERTURBATION TREATMENT. THE NUMBERING
C                             REFERS TO THE SCF OUTPUT. USE MORE THAN
C                             ONE CARD FOR INPUT, IF NECESSARY.
C
C     *** THIRD  CARD (OMIT IF MOVO.EQ.0) ***
C
C       1-80  IMOCI(I) 20I4   NUMBERS OF UNOCCUPIED ORBITALS INVOLVED IN
C            (I=ICI1+1,       THE PERTURBATION TREATMENT. THE NUMBERING
C             ICI1+ICI2)      REFERS TO THE SCF OUTPUT. USE MORE THAN
C                             ONE CARD FOR INPUT, IF NECESSARY.
C
C     *** FOURTH CARD (OMIT IF MPERT.EQ.0) ***
C
C       1-16  IPERT(I) 4I4    DEFINITION OF PERTURBATION TREATMENT.
C                             I=1 RSMP, I=2 RSEN, I=3 BWMP, I=4 BWEN.
C                             RS RAYLEIGH-SCHROEDINGER TREATMENT.
C                             BW BRILLOUIN-WIGNER TREATMENT.
C                             MP MOLLER-PLESSET DENOMINATORS.
C                             EN EPSTEIN-NESBET DENOMINATORS.
C                             FOR NONZERO IPERT(I), A PERTURBATION CAL-
C                             CULATION IS CARRIED OUT, ACCORDING TO I.
C                             FOR POSITIVE IPERT(I), THE PERTURBATION
C                             CORRECTION IS ADDED TO THE TOTAL ENERGY.
C                             DEFAULT. BWEN TREATMENT, ONLY IPERT(4)=1.
C
C ***** INPUT FOR THE NEXT MOLECULE ************************************
C
C     AT THIS POINT, THE NEXT MOLECULE CAN BE READ IN STARTING WITH THE
C     TITLE CARD. TO TERMINATE THE JOB, SET KHARGE=99 (COLUMNS 1-2 OF
C     THE TITLE CARD).
C
C     SIMPLIFIED INPUT FOR REACTION PATHS. AFTER THE FIRST POINT, SET
C     KGEOM=1 ON THE TITLE CARD OF THE NEXT POINTS, AND THEN READ
C     ** ONLY ** THE FOLLOWING CARD.
C
C ***** A NEW REACTION COORDINATE VALUE ONLY ***** KGEOM=1 *************
C
C       1-2   LREACT(1) I2    ATOM NUMBER WITH THE REACTION COORDINATE
C       4-5   LREACT(2) I2    TYPE OF THE REACTION COORDINATE
C                             =1  BOND LENGTH
C                             =2  BOND ANGLE
C                             =3  TWIST ANGLE
C      11-20  REACT    F10.5  THE NEW VALUE FOR THE REACTION COORDINATE.
C      21-22  NPOINT    I2    IDENTIFICATION NUMBER ONE MAY USE TO
C                             DISTINGUISH BETWEEN DIFFERENT POINTS IN A
C                             REACTION PATH.
C
C **********************************************************************
C
C     FILE DICTIONARY.
C
C     1    SEQUENTIAL DISK FILE.
C          USED FOR INPUT  OF DENSITY MATRIX, IF KTRIAL=3.
C          USED FOR INPUT  OF EIGENVECTORS  , IF KTRIAL=4.
C          USED FOR OUTPUT OF DENSITY MATRIX, IF IPUBO =1.
C          USED FOR OUTPUT OF EIGENVECTORS  , IF IPUEV =1.
C          USED TO STORE DENSITY MATRICES DURING JOB, IF INOUT.GT.0.
C     2    SEQUENTIAL DISK FILE.
C          USED TO STORE THE TWO-ELECTRON AO INTEGRALS IN SCF  SEGMENT.
C          USED TO STORE THE TWO-ELECTRON MO INTEGRALS IN PERT SEGMENT.
C     3    SEQUENTIAL DISK FILE.
C          USED TO STORE THE H,F MATRICES IN SCF SEGMENT, IF INOUT.GT.1.
C          USED TO STORE ORDERED AO INTEGRALS IN PERT SEGMENT.
C     4    SEQUENTIAL DISK FILE.
C          USED TO STORE DFP INFORMATION IN AND AFTER EACH DFP CYCLE.
C          NECESSARY TO CONTINUE A DFP OPTIMIZATION IN A NEW JOB.
C     5    INPUT  FILE. CARD READER.
C     6    OUTPUT FILE. PRINTER.
C     7    PUNCH  FILE. THE OPTIMIZED GEOMETRY IS PUNCHED, IF IREP=1,2.
C
C     FILE 1 WILL BE USED ONLY IF THE CORRESPONDING INPUT/OUTPUT OPTIONS
C     ARE READ IN (SEE ABOVE) OR IF THE AVAILABLE BUFFER IS INSUFFICIENT
C     (INOUT.GT.0, AS DETERMINED BY THE PROGRAM).
C     FILES 2 AND 3 WILL LIKEWISE BE USED ONLY IF THE AVAILABLE BUFFER
C     IS INSUFFICIENT (AS DETERMINED BY THE PROGRAM).
C     FILE 4 WILL ALWAYS BE USED IN GEOMETRY OPTIMIZATIONS.
C
C **********************************************************************
C
C     PROGRAM MNDOC (INPUT=1001B,OUTPUT=1001B,PUNCH=1001B,TAPE1=1001B,
C    .TAPE2=1001B,TAPE3=1001B,TAPE4=1001B,TAPE5=INPUT,TAPE6=OUTPUT,
C    .TAPE7=PUNCH)
C     *
C     THE FOLLOWING LIST CONTAINS ALL COMMON BLOCKS OF THE PROGRAM,
C     EXCEPT THOSE USED IN THE DFP SEGMENT EXCLUSIVELY, I.E.
C     CCCCK,DFPGO,FLPOCM,LIN1,LIN2,OPCOM1,OPCOM2,PASS3,SLVER.
C     *
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON
     ./ATOMS / NUMAT,NAT(150),COORD(150)
     ./BESAFE/ TLIMIT(3)
     ./BOND  / KTRIAL
     ./CCIS  / KTHMO(6),CIYES(19),JFROM(6)
     ./CIFLAG/ ICJUMP(10)
     ./CIMOS / IMOCI(100),NSYM(100)
     ./CIPARM/ ICI12(68)
     ./CNTROL/ ICNTRL
     ./CYCLES/ NPBI,NPETER
     ./DENERG/ DENER
     ./DFP   / X(99),NVAR
     ./DIPOL / DIP
     ./DNBND / INMB(36)
     ./ENERG / EE(4)
     ./ERG   / ENERGY(100)
     ./EXPOL / NSTART(2)
     ./EXTRA / RI(44)
      COMMON
     ./FLAG1 / KTITLE(22),KHARGE,KGEOM,KITSCF(8)
     ./FLAG2 / MIDDLE,SECADD,TIME1
     ./FLAG3 / KRESET,IWADE
     ./FLAG4 / INTSUM
     ./FUNCT / EVALUE(4)
     ./HALFE / IMULT(3)
     ./HALFX / XIJK(3)
     ./LIMITS/ LM1,LM2,LM3,LM4,LM5,LM6,LM7,LM8,LM9
     ./LMOUT / INOUT
     ./LMPERT/ LP1(6)
     ./LMSCF / LS1(7),LS8
     ./MATRIX/ A(250000)
     ./MULTIP/ DD(90)
     ./MXFLAG/ MAXEND
     ./NBFILE/ NB1,NB2,NB3,NB4
      COMMON
     ./OPTION/ IOP
     ./ORBITS/ NUMB(3)
     ./OVERLY/ IOV,JOV,KOV,LOV
     ./PARDER/ TORE(54)
     ./PARM1 / AA(150),NA(203)
     ./PARM2 / NSYMA(464)
     ./PARM3 / LOC(2,99)
     ./PARMIN/ F0(54)
     ./PAROPT/ USS(182)
     ./PASS1 / NI,NJ,R,GAM,NBOND,II
     ./PASS2 / MAXLIN(5),TOLIN(9)
     ./REP   / GSS(108)
      COMMON
     ./SC    / EINC,IGG1,CCCOS,EYEAD
     ./SCRT  / SCFCRT(2)
     ./SEARCH/ JOP
     ./SETC  / AB(17),ISP,IPS
     ./SETCI / KCI
     ./SKIPA / IGRAD,ISKPA,NWSKP(2)
     ./SYMMIN/ IICEN(69)
     ./VVV   / CHANGE(8)
     ./WREP  / W(50000)
     ./XCI   / ECI(6)
     ./XDER  / COLD(150)
     ./XFACT / FACT(15)
     ./XLSQ1 / XMINM(4),MXCONT,TOLS(6)
     ./XLSQ3 / RSTABS(2)
     ./XPRJU / IREP,IJUMP
     ./XSKPRT/ IPUBO(4)
     ./XXMAXM/ XMAXM(4)
      common  /parti/ ept(50,50)
C *** OPEN OUTPUT FILES
      OPEN (UNIT=6,STATUS='unknown',FILE='MNDOC.OUT')
      OPEN (UNIT=8,FILE='MS.out',status='unknown')
      open(1,file='scr1.',form='unformatted',status='unknown')
      open(2,file='scr2.',form='unformatted',status='unknown')
      open(3,file='scr3.',form='unformatted',status='unknown')
      open(4,file='scr4.',form='unformatted',status='unknown')
      open(9,file='scr9.',form='unformatted',status='unknown')
c      WRITE (8,120)
C *** OVERLAY CONTROL.
      IOV=1
      JOV=0
      KOV=0
      LOV=0
C *** FILE NUMBERS.
      NB1=1
      NB2=2
      NB3=3
      NB4=4
C *** LIMITATIONS.
C     LM1   MAXIMUM NUMBER OF ATOMS.
C     LM5   LENGTH OF COMMON /MATRIX/.
C     LM9   LENGTH OF COMMON /WREP/.
      LM1=50
      LM5=250000
      LM9=50000
C *** DETERMINE THE STARTING TIME.
CCC      CALL TIME(IT)
CCC      TIME1  = 0.00001*FLOAT(IT)
      SECADD = 0.
      INTSUM = 0
      ICNTRL = 0
C *** READ THE INPUT DATA.
   10 CONTINUE
CCC      CALL LOAD(2)
      CALL START (A,LM5)
CCC      CALL UNLOAD(2)
      ICNTRL = 1
      IF (KGEOM.EQ.-1) GO TO 10
      IF (MAXEND.GT.3) GO TO 2
      IF (MAXEND.EQ.3) GO TO 1
C *** DO A SINGLE SCF-CALCULATION.
      IWADE=-1
      CALL SCF (A,LM5)
      GO TO 3
C *** DO A SINGLE SCF AND GRADIENT CALCULATION.
    1 IWADE=1
      CALL SCF (A,LM5)
      GO TO 3
C *** OPTIMIZE THE MOLECULAR GEOMETRY.
    2 CONTINUE
CCC      CALL LOAD(1)
      CALL FLEPO (A,A(LS8),LM4,LM5)
CCC      CALL UNLOAD(1)
      IF(JOV.EQ.0) GO TO 3
      CALL SCF (A,LM5)
      GO TO 2
C *** PRINT SUMMARY OF RESULTS.
    3 CONTINUE
      IF(MAXEND.LT.0) GO TO 4
CCC      CALL LOAD(4)
      IF(MAXEND.GE.3) CALL PRTDFP (A,LM5)
      CALL PRTLST
CCC      CALL UNLOAD(4)
C *** DETERMINE THE COMPUTATION TIME.
    4 CONTINUE
CCC      CALL TIME(IT)
CCC      TIME2  = 0.00001*FLOAT(IT)
CCC      TIME1  = SECADD+TIME2-TIME1
CCC      WRITE(6,100) TIME1
      WRITE(6,110) NPETER
C *** PREPARE FOR THE NEXT MOLECULE.
CCC      TIME1  = TIME2
CCC      SECADD = 0.
      IF(MIDDLE.EQ.1) MIDDLE=0
      IF(MIDDLE.GT.1) MIDDLE=-MIDDLE
      IF(MAXEND.EQ.2) MAXEND=9999
      GO TO 10
CCC  100 FORMAT(////5X,'COMPUTATION TIME = ',F8.2,3X,'SECONDS')
  110 FORMAT(/   5X,'SCF CALCULATIONS = ',I5///)
120     FORMAT (' //  ***** M N D O C ***** //')
      END
C     ******************************************************************
      SUBROUTINE CLODA (I)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     DUMMY ROUTINE FOR CLOSING FILE I.
C     *
      RETURN
      END
C     ******************************************************************
      BLOCKDATA
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON
     ./DNBND / INMB(18),III(18)
     ./REP   / GSS(18),GPP(18),GSP(18),GP2(18),HSP(18),HPP(18)
      DATA GSS/ 12.848,0., 7.30, 9.00,10.59,12.23,13.59,15.42,16.92,0.,
     1                     0.00, 0.00, 8.09, 9.82,11.56,12.88,15.03,0. /
      DATA GPP/ 0.,0., 5.00, 6.97, 8.86,11.08,12.98,14.52,16.71, 0.,
     1                 0.00, 0.00, 5.98, 7.31, 8.64, 9.90,11.30, 0.  /
      DATA GSP/ 0.,0., 5.42, 7.43, 9.56,11.47,12.66,14.48,17.25, 0.,
     1                 0.00, 0.00, 6.63, 8.36,10.08,11.26,13.16, 0.  /
      DATA GP2/ 0.,0., 4.52, 6.22, 7.86, 9.84,11.59,12.98,14.91, 0.,
     1                 0.00, 0.00, 5.40, 6.54, 7.68, 8.83, 9.97, 0.  /
      DATA HSP/ 0.,0., 0.83, 1.28, 1.81, 2.43, 3.14, 3.94, 4.83, 0.,
     1                 0.00, 0.00, 0.70, 1.32, 1.92, 2.26, 2.42, 0.  /
      DATA HPP/ 0.,0., 0.24, 0.38, 0.50, 0.62, 0.70, 0.77, 0.90, 0.,
     1                 0.00, 0.00, 0.29, 0.38, 0.48, 0.54, 0.67, 0.  /
      DATA INMB/1,0,0,0,2,3,4,5,6,0,0,0,0,7,8,9,10,0/
      DATA III /1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3 /
      END
C     ******************************************************************
      SUBROUTINE VECPRT (A,ISIZE,NUMB)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     PRINT LINEAR ARRAY AS LOWER TRIANGLE OF A MATRIX
C     *
      DIMENSION  LINE(31), A(ISIZE)
      DATA LINE4 / 4H---- /
      DO 1  I=1,31
    1 LINE(I)=LINE4
      LIMIT=(NUMB*(NUMB+1))/2
      KK=8
      NA=1
    2 LL=0
      M=MIN0((NUMB+1-NA),10)
      MA=3*M+1
      M=NA+M-1
      WRITE(6,600) (I,I=NA,M)
CCC      WRITE(8,600) (I,I=NA,M)
      WRITE(6,601) (LINE(K), K=1,MA)
CCC      WRITE(8,601) (LINE(K), K=1,MA)
      DO 4  I=NA,NUMB
      LL=LL+1
      K=(I*(I-1))/2
      L=MIN0((K+M),(K+I) )
      K=K+NA
    3 WRITE(6,603) I,(A(N), N=K,L)
CCC      WRITE(8,603) I,(A(N), N=K,L)
    4 CONTINUE
      IF(L.GE.LIMIT) GO TO 5
      NA=M+1
      GO TO 2
    5 RETURN
  600 FORMAT(//2X,10(7X,I5))
  601 FORMAT(1H ,31A4)
  602 FORMAT(////)
  603 FORMAT(1H ,I3,1X,10F12.5)
      END
C     ******************************************************************
      SUBROUTINE MATOUT(A,B,NC,NR,LM2,LM3)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     PRINT THE MATRIX A(NR,NC)
C     *
      DIMENSION  A(LM2,LM3),B(LM3)
      KA=1
      KC=10
    1 KB=MIN0(KC,NC)
      WRITE(6,600) (I,I=KA,KB)
CCC      WRITE(8,600) (I,I=KA,KB)
      WRITE(6,601) (B(I),I=KA,KB)
CCC      WRITE(8,601) (B(I),I=KA,KB)
      WRITE(6,602)
CCC      WRITE(8,602)
    2 N=0
      DO 3  I=1,NR
      WRITE(6,603) I,(A(I,J),J=KA,KB)
CCC      WRITE(8,603) I,(A(I,J),J=KA,KB)
      N=N+1
      IF(N.LT.10) GO TO 3
      WRITE(6,602)
CCC      WRITE(8,602)
      N=0
    3 CONTINUE
    4 IF(KB.EQ.NC) RETURN
      KA=KC+1
      KC=KC+10
      GO TO 1
  600 FORMAT(// 9H ROOT NO., I5,9I12)
  601 FORMAT(/5X,10F12.5)
  602 FORMAT(2H   )
  603 FORMAT(I5,10F12.5)
  604 FORMAT(////)
      END
C     ******************************************************************
      SUBROUTINE GMETRY(JCXYZ)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     CALCULATE CARTESIAN COORDINATES FROM INTERNAL COORDINATES
C     *
      COMMON
     ./ATOMS / NUMAT,NAT(50),NFIRST(50),NLAST(50),COORD(3,50)
     ./PARM1 / A(3,50),NA(50),NB(50),NC(50),NN(50),NATOMS,LREACT(2)
      LOGICAL LINEAR
      LINEAR=.FALSE.
      IF(JCXYZ.EQ.-2) GO TO 8
C     FIND THE FIRST ATOM (IF ANY) WHICH IS NOT COLLINEAR WITH ATOMS
C     1 AND 2.  ASSUME THAT THE ATOMS ARE COLLINEAR IF THE COSINE OF THE
C     ANGLE IS GREATER THAN 0.99999999
      DO 1  I=3,NATOMS
      CCOS=COS(A(2,I))
      IF(ABS(CCOS).LT.0.99999999) GO TO 2
    1 CONTINUE
C     THE MOLECULE IS LINEAR
      LINEAR=.TRUE.
      I=NATOMS+1
    2 COORD(1,I-1)= A(1,I-1)
      COORD(2,I-1)=0.
      COORD(3,I-1)=0.
      II=I-2
      DO 3  J=1,II
      K=II-J+1
      COORD(1,K)=COORD(1,K+1)-A(1,K+1)
      COORD(2,K)=0.
      COORD(3,K)=0.
    3 CONTINUE
      IF(LINEAR) GO TO 8
      SSIN=SIN(A(2,I))
      COORD(1,I)=COORD(1,I-1)-A(1,I)*CCOS
      COORD(2,I)=A(1,I)*SSIN
      COORD(3,I)=0.
      IF(I.EQ.NATOMS) GO TO 8
      II=I+1
      DO 7  I=II,NATOMS
      COSA=COS(A(2,I))
      MB=NB(I)
      MC=NC(I)
      XB=COORD(1,MB)-COORD(1,MC)
      YB=COORD(2,MB)-COORD(2,MC)
      ZB=COORD(3,MB)-COORD(3,MC)
      RBC=1.0/SQRT(XB*XB+YB*YB+ZB*ZB)
      IF(ABS(COSA).LT.0.99999999) GO TO 4
C     ATOMS MC, MB, AND (I) ARE COLLINEAR
      RBC=A(1,I)*RBC
      COORD(1,I)=COORD(1,MC)-XB*RBC
      COORD(2,I)=COORD(2,MC)-YB*RBC
      COORD(3,I)=COORD(3,MC)-ZB*RBC
      GO TO 7
C     THE ATOMS ARE NOT COLLINEAR
    4 MA=NA(I)
      XA=COORD(1,MA)-COORD(1,MC)
      YA=COORD(2,MA)-COORD(2,MC)
      ZA=COORD(3,MA)-COORD(3,MC)
C     ROTATE ABOUT THE Z-AXIS TO MAKE YB=0, AND XB POSITIVE.  IF XYB IS
C     TOO SMALL, FIRST ROTATE THE Y-AXIS BY 90 DEGREES.
      XYB=SQRT(XB*XB+YB*YB)
      K=-1
      IF(XYB.GT.0.1 ) GO TO 5
      XPA=ZA
      ZA =-XA
      XA =XPA
      XPB=ZB
      ZB =-XB
      XB =XPB
      XYB=SQRT(XB*XB+YB*YB)
      K=1
C     ROTATE ABOUT THE Y-AXIS TO MAKE ZB VANISH
    5 COSTH=XB/XYB
      SINTH=YB/XYB
      XPA=XA*COSTH+YA*SINTH
      YPA=YA*COSTH-XA*SINTH
      SINPH=ZB*RBC
      COSPH=SQRT(ABS(1.-SINPH*SINPH))
      XQA=XPA*COSPH+ZA*SINPH
      ZQA= ZA*COSPH-XPA*SINPH
C     ROTATE ABOUT THE X-AXIS TO MAKE ZA=0, AND YA POSITIVE.
      YZA=SQRT(YPA**2+ZQA**2)
      COSKH=YPA/YZA
      SINKH=ZQA/YZA
C     COORDINATES      A=(XQA,YZA,0),   B=(RBC,0,0),  C=(0,0,0)
C     NONE ARE NEGATIVE.
C     THE COORDINATES OF I ARE EVALUATED IN THE NEW FRAME.
      SINA=SIN(A(2,I))
      SIND=SIN(A(3,I))
      COSD=COS(A(3,I))
      XD=A(1,I)*COSA
      YD=A(1,I)*SINA*COSD
      ZD=A(1,I)*SINA*SIND
C     TRANSFORM THE COORDINATES BACK TO THE ORIGINAL SYSTEM.
      YPD= YD*COSKH- ZD*SINKH
      ZPD= ZD*COSKH+ YD*SINKH
      XPD= XD*COSPH-ZPD*SINPH
      ZQD=ZPD*COSPH+ XD*SINPH
      XQD=XPD*COSTH-YPD*SINTH
      YQD=YPD*COSTH+XPD*SINTH
      IF(K.LT.1) GO TO 6
      XRD=-ZQD
      ZQD= XQD
      XQD= XRD
    6 COORD(1,I)=XQD+COORD(1,MC)
      COORD(2,I)=YQD+COORD(2,MC)
      COORD(3,I)=ZQD+COORD(3,MC)
    7 CONTINUE
C *** NOW REMOVE THE DUMMY ATOM COORDINATES, IF ANY, FROM COORD
    8 IF(NATOMS.EQ.NUMAT) RETURN
      IF(JCXYZ.EQ.1) GO TO 110
      J=0
      DO 10  I=1,NATOMS
      IF(NN(I).EQ.99) GO TO 10
      J=J+1
      DO 9  K=1,3
    9 COORD(K,J)=COORD(K,I)
   10 CONTINUE
  110 CONTINUE
      RETURN
      END
C     ******************************************************************
      SUBROUTINE SYMTRY(LTYPE)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     SYMMETRY CONDITIONS AND DEPENDENT FUNCTIONS
C     *
      COMMON
     ./PARM1 / A(3,50),NC(50),NB(50),NA(50),NAT(50),NUMAT,LREACT(2)
     ./PARM2 / NSYMA,NSYM1,NSYMB,ISYM(8,50),NDEP,IDEPFN(20),LOCDEP
     .         (20),LOCPAR(20)
     ./PARM3 / LOC(2,99)
      DIMENSION Q(3)
      DATA BLANK / 1H  /
      DATA STAR  / 1H* /
      DATA PLUS  / 1H+ /
      IF(NSYMA.EQ.0) GO TO 2
C     IMPOSE THE FIRST SET OF SYMMETRY CONDITIONS.
      DO 1  I=1,NSYMA
      IA=ISYM(6,I)
      IB=ISYM(7,I)
      J =ISYM(8,I)
      W =A(IB,IA)
      DO 1  K=1,J
      KA=ISYM(K,I)
    1 A(IB,KA)=W
    2 IF(NDEP.EQ.0) GO TO 5
C     COMPUTE THE DEPENDENT PARAMETERS.
      DO 3  I=1,NDEP
      CALL HADDON(VALUE,LOCN,IDEPFN(I),LOCPAR(I),A)
      J=LOCDEP(I)
    3 A(LOCN,J)=VALUE
      IF(NSYMB.EQ.0) GO TO 5
C     IMPOSE THE REMAINING SYMMETRY CONDITIONS.
      DO 4  I=NSYM1,NSYMB
      IA=ISYM(6,I)
      IB=ISYM(7,I)
      J =ISYM(8,I)
      W =A(IB,IA)
      DO 4  K=1,J
      KA=ISYM(K,I)
    4 A(IB,KA)=W
    5 IF(LTYPE.LT.0) RETURN
C     PRINT THE GEOMETRY (LTYPE.GE.0).
      WRITE(6,600)
CCC      WRITE(8,600)
      N =1
      WRITE(6,601) NAT(1)
CCC      WRITE(8,601) NAT(1)
      IF(NUMAT.LT.2) RETURN
      IA = LOC(1,1)
      Q(1)=BLANK
      IF(LREACT(1).EQ.2) Q(1)=PLUS
      IF(LOC(1,1).NE.2) GO TO 6
      Q(1)=STAR
      N=N+1
      IA=LOC(1,N)
    6 WRITE(6,602) NAT(2),A(1,2),Q(1),NA(2)
CCC      WRITE(8,602) NAT(2),A(1,2),Q(1),NA(2)
      IF(NUMAT.LT.3) RETURN
      DO 7  J=1,2
      Q(J)=BLANK
      IF(IA.NE.3) GO TO 7
      IF(LOC(2,N).NE.J) GO TO 7
      Q(J)=STAR
      N=N+1
      IA=LOC(1,N)
    7 CONTINUE
      W=A(2,3)*57.29577951
      IF(LREACT(1).NE.3) GO TO 8
      J=LREACT(2)
      Q(J)=PLUS
    8 WRITE(6,603) NAT(3),A(1,3),Q(1),W,Q(2),NA(3),NB(3)
CCC      WRITE(8,603) NAT(3),A(1,3),Q(1),W,Q(2),NA(3),NB(3)
      IF(NUMAT.LT.4)  RETURN
      DO 11  I=4,NUMAT
      DO 9  J=1,3
      Q(J)=BLANK
      IF(IA.NE.I) GO TO 9
      IF(J.NE.LOC(2,N)) GO TO 9
      Q(J)=STAR
      N=N+1
      IA=LOC(1,N)
    9 CONTINUE
      W=A(2,I)*57.29577951
      X=A(3,I)*57.29577951
      IF(LREACT(1).NE.I) GO TO 10
      J=LREACT(2)
      Q(J)=PLUS
   10 WRITE(6,604) I,NAT(I),A(1,I),Q(1),W,Q(2),X,Q(3),NA(I),NB(I),NC(I)
CCC      WRITE(8,604) I,NAT(I),A(1,I),Q(1),W,Q(2),X,Q(3),NA(I),NB(I),NC(
   11 CONTINUE
      RETURN
  600 FORMAT(/6X,4HATOM,6X,6HATOMIC,15X,11HBOND LENGTH,10X,10HBOND ANGLE
     1,11X,11HTWIST ANGLE /5X,6HNUMBER,5X,6HNUMBER,15X,11H(ANGSTROMS),
     2 11X,9H(DEGREES),12X,9H(DEGREES) /8X, 1HI ,32X,4HNA I,16X,
     3 7HNB NA I,12X,10HNC NB NA I,16X,2HNA,5X,2HNB,5X,2HNC /)
  601 FORMAT(8X,1H1,9X,I2)
  602 FORMAT(8X,1H2,9X,I2,F26.5,1X,A1,57X,I2)
  603 FORMAT(8X,1H3,9X,I2,7X,2(F19.5,1X,A1),36X,2(I2,5X) )
  604 FORMAT(7X,I2,9X,I2,7X,3(F19.5,1X,A1),10X,3(5X,I2) )
      END
C     ******************************************************************
      SUBROUTINE HADDON(W,L,M,LOC,A)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     PREDEFINED DEPENDENT FUNCTIONS
C     *
      DIMENSION A(3,50)
      PI = 3.1415926536
      IF(M.GT.14) GO TO 15
      I = LOC
      GO TO (1,2,3,4,5,6,7,8,9,10,11,12,13,14),M
    1 W=(    PI/2.0)-A(3,I)
      GO TO 20
    2 W=(    PI/2.0)+A(3,I)
      GO TO 20
    3 W=(2.0*PI/3.0)-A(3,I)
      GO TO 20
    4 W=(2.0*PI/3.0)+A(3,I)
      GO TO 20
    5 W=(    PI    )-A(3,I)
      GO TO 20
    6 W=(    PI    )+A(3,I)
      GO TO 20
    7 W=(4.0*PI/3.0)-A(3,I)
      GO TO 20
    8 W=(4.0*PI/3.0)+A(3,I)
      GO TO 20
    9 W=(3.0*PI/2.0)-A(3,I)
      GO TO 20
   10 W=(3.0*PI/2.0)+A(3,I)
      GO TO 20
   11 W=            -A(3,I)
   20 L=3
      RETURN
   12 L=1
      W=A(1,I)/2.
      RETURN
   13 L=2
      W=A(2,I)/2.
      RETURN
   14 L=2
      W=PI-A(2,I)
      RETURN
   15 CALL DEPVAR(W,L,M,LOC,A)
      RETURN
      END
C     ******************************************************************
      SUBROUTINE DEPVAR(W,L,M,LOC,A)
      IMPLICIT REAL*8 (A-H,O-Z)
C     *
C     DUMMY SUBROUTINE FOR DEPENDENT FUNCTIONS
C     *
      RETURN
      END
