/*
 *   MNDO output file-bol uj inputot keszit.
 *   1 mode: trial geometry parameters
 *   2 mode: optimized geometry
 *   Fejlec 2. sor: 0 1 (optimalas)
 *   Fejlec 3. sor: 0 0 (semleges, singlet)
 */

#include <stdio.h>
#include <fcntl.h>

FILE *Mnd_out;
FILE *Mnd_inp;
char Out_name[80];
char Inp_name[80];
char Total_name[80];
int  Mode;
int  Homo;
char Header[132];

main (argc, argv)
int argc;
char **argv;
{
        char work[80];
	int i;

        if (argc < 4) {
                printf (" MNDOUT  file_name.inp  file_name.inp  mode=1,2,n\n\n");
                exit();
        }
        strcpy (Out_name, argv[1]);
        strcpy (Inp_name, argv[2]);
        Mode = atoi (argv[3]);
        if (Mode > 2)
                Homo = Mode;
        if ((Mnd_inp = fopen (Inp_name, "w")) == NULL) {
                printf (" Open error, file %s\n\n", Inp_name);
                exit (0);
        }



        if (Mode == 1)
                trial_geom_input ();
        if (Mode == 2)
                final_geom_input (1);
        if (Mode > 2) {
                for (i = Homo; i > Homo - 4; i--) {
			itoa(i, work, 10);
			printf ("----------%s-------\n", work);
                	strcat (work, ".inp");
			printf ("----------%s-------\n", work);
                        ext_name (Inp_name, Total_name, work);
 		        if ((Mnd_inp = fopen (Total_name, "w")) == NULL) {
                		printf (" Open error, file %s\n\n", Inp_name);
		                exit (0);
        		}
		final_geom_input (i);
		}
        }
        exit (0);
}

header ()
{
        char line[132];
        int i;

        for (i = 0; i< 8; i++)
                getline (Mnd_out, Header);

}

trial_geom_input ()
{
        char line[132];
        int i;
        int is, in;
        double dist, angle, torsion;
        int n1, n2, n3;
        char opt1[8], opt2[8], opt3[8];
        int o1, o2, o3;

        if ((Mnd_out = fopen (Out_name, "r")) == NULL) {
                printf (" Open error, file %s\n\n", Out_name);
                exit (0);
        }
        header ();
        dist = 0.0;
        angle = 0.0;
        torsion= 0.0;
        n1 = 0;
        n2 = 0;
        n3 = 0;
        opt1[0] = '\0';
        opt2[0] = '\0';
        opt3[0] = '\0';
        search ("TRIAL");
        for (i = 0; i < 6; i++)
                getline (Mnd_out, line);
        fprintf (Mnd_inp, "\n 0 1\n 0 0         200");
        fprintf (Mnd_inp, "         %s\n", Header);
        while (getline (Mnd_out, line) > 0) {
                printf ("--- %s ---\n", line);
                sscanf (line, "%d %d", &is, &in);
                if (is == 1) {
                        n1 = 0; n2 = 0; n3 = 0;
                        goto next;
                }
                sscanf (line + 30, "%lf %s", &dist, opt1);
                if (is == 2) {
                        sscanf (line + 104, "%d", &n1);
                        n1 = 1; n2 = 0; n3 = 0;
                        goto next;
                }
                sscanf (line + 52, "%lf %s", &angle, opt2);
                if (is == 3) {
                        sscanf (line, "%d %d", &n1, &n2);
                        n1 = 2; n2 = 1; n3= 0;
                        goto next;
                }
                sscanf (line + 72, "%lf %s", &torsion, opt3);
                sscanf (line + 104, "%d %d %d", &n1, &n2, &n3);
                next:
                o1 = 0;
                o2 = 0;
                o3 = 0;
                if (opt1[0] == '*')
                        o1 = 1;
                if (opt2[0] == '*')
                        o2 = 1;
                if (opt3[0] == '*')
                        o3 = 1;
                printf (" %d %d %lf %s %lf %s %lf %s %d %d %d\n",
                        is, in, dist, opt1, angle, opt2, torsion, opt3, n1, n2, n3);

                fprintf (Mnd_inp, "%2d %17.5lf %3d %15.5lf %3d %15.5lf %3d %7d%2d%2d\n",
                        in, dist, o1, angle, o2, torsion, o3, n1, n2, n3);
        }
        fprintf (Mnd_inp, "\n99\n");

}

final_geom_input (homo_n)
int homo_n;
{
        char line[132];
        int i;
        int is, in;
        double dist, angle, torsion;
        int n1, n2, n3;
        char opt1[8], opt2[8], opt3[8];
        int o1, o2, o3;

        if ((Mnd_out = fopen (Out_name, "r")) == NULL) {
                printf (" Open error, file %s\n\n", Out_name);
                exit (0);
        }
        header ();
        dist = 0.0;
        angle = 0.0;
        torsion= 0.0;
        n1 = 0;
        n2 = 0;
        n3 = 0;
        opt1[0] = '\0';
        opt2[0] = '\0';
        opt3[0] = '\0';
        search ("OPTIMIZED VARIA");
        search ("NUMBER");
        for (i = 0; i < 2; i++)
                getline (Mnd_out, line);
        if (homo_n > 2)
		fprintf (Mnd_inp, "\n 1 0\n 1 2         200");
	else
		fprintf (Mnd_inp, "\n 1 0\n 0 0         200");
        fprintf (Mnd_inp, "        %s\n", Header);
        while (getline (Mnd_out, line) > 0) {
                printf ("--- %s ---\n", line);
                sscanf (line, "%d %d", &is, &in);
                if (is == 1) {
                        n1 = 0;n2= 0; n3 = 0;
                        goto next;
                }
                sscanf (line + 30, "%lf %s", &dist, opt1);
                if (is == 2) {
                        sscanf (line + 104, "%d", &n1);
                        n1 = 1; n2 = 0; n3 = 0;
                        goto next;
                }
                sscanf (line + 52, "%lf %s", &angle, opt2);
                if (is == 3) {
                        sscanf (line, "%d %d", &n1, &n2);
                        n1 = 2; n2 = 1; n3 = 0;
                        goto next;
                }
                sscanf (line + 72, "%lf %s", &torsion, opt3);
                sscanf (line + 104, "%d %d %d", &n1, &n2, &n3);
                next:
                o1 = 0;
                o2 = 0;
                o3 = 0;
                if (opt1[0] == '*')
                        o1 = 1;
                if (opt2[0] == '*')
                        o2 = 1;
                if (opt3[0] == '*')
                        o3 = 1;
                printf (" %d %d %lf %s %lf %s %lf %s %d %d %d\n",
                        is, in, dist, opt1, angle, opt2, torsion, opt3, n1, n2, n3);

                fprintf (Mnd_inp, "%2d %17.5lf %3d %15.5lf %3d %15.5lf %3d %7d%2d%2d\n",
                        in, dist, o1, angle, o2, torsion, o3, n1, n2, n3);
        }
	if (homo_n > 2)
		fprintf (Mnd_inp, " \n98%2d\n", homo_n);
	else
		fprintf (Mnd_inp, "  \n  \n");
        fprintf (Mnd_inp, "99 \n");
        fclose (Mnd_out);

}

getline (file, t)
FILE *file;
char *t;
{
        int c;
        int len;

        len = 0;
        while ((c = getc(file)) != '\n' && c != EOF) {
                *t++ = c;
                len++;
        }
        if (c == EOF) {
                fclose (Mnd_inp);
                exit (0);
        }
        *t = '\0';
        return (len);
}

search (target)
char *target;
{
        char line[140];
        char *p;
        int len;
        int talalt;
        char *s, *t;

        talalt = 0;
        while (talalt != 1) {
                len = getline (Mnd_out, line);
                p = line;
                while ((talalt = strequ(target,p)) != 1 && p < line + len)
                        p++;
        }
}

strequ(s,t)
char *s, *t;
{
        while (*s == *t && *s != '\0' && *s != '\n') {
                s++;
                t++;
        }
        if (*s == '\0' || *s == '\n')
                return (1);
        return (-1);
}


/*--- A minta nevet kiegesziti .SPK es .IND kiterjesztessel -------------*/

ext_name (name, extname, ext)    /* SPK es IND  FILENEVEK LETREHOZASA */
/*-----------------------------------------------------------------------*/
char *name;
char *extname;
char *ext;
{
        while ((*extname++ = *name++) != '\0');
        *extname--;
        while ((*extname++ = *ext++) != '\0');
        *extname = '\0';
}
itoa(n,s)
char s[80];
int n;
{
    int i,sign;
    if((sign=n)<0)
           n=-n;
    i=0;
    do {s[i++] = n%10 + '0';
    } while((n/=10) > 0);
    if(sign<0) s[i++] = '-' ;
    s[i] = '\0';
    reverse(s);
}
reverse(s)
char s[80];
{  
    int c,i,j;
    for(i=0,j=strlen(s)-1; i<j; i++,j--) {
        c=s[i];
        s[i]=s[j];
        s[j]=c;
}}
