#include <stdio.h>
#define MAX 200

double Mat[MAX][MAX];
double Fval[MAX];
double Val[MAX];
double Sbab[MAX];

int Atyp[MAX];
int Natom;
int Nparam;
int Div[44];

FILE *In;
FILE *Out;
char Namein[] = "MNDOC.OUT";
char Nameout[] = "MNDOC.BND";
char Title[80];

main(argc, argv)
int argc;
char **argv;
{
        char line[140];
        double x;
        int i, j;
        int k, l;
        int i0, n;
        char *p, *q;
        char *p0;

        printf ("\n  CALCULATING BOND ORDERS AND VALENCIES \n\n");
        if (argc < 2)
                p = Namein;
        else
                p = argv[1];

        if ((In = fopen (p, "r")) == NULL) {
                printf (" Open error, file %s\n", p);
                exit(0);
        }
        printf ("  input file  %s \n", p);
        q = p;
        while (*q != '.' && *q != '\0')
                q++;
        if (*q == '\0')
                p = Nameout;
        else {
                *++q = 'b';
                *++q = 'n';
                *++q = 'd';
                *++q = '\0';
        }
        if (argc == 3)
                p = argv[2];
        if ((Out = fopen (p, "w")) == NULL) {
                printf (" Open error, file %s\n", p);
                exit(0);
        }
        printf ("  output file  %s\n\n", p);
        getheader (4);
        getline (In, Title);
        printf ("%s\n\n", Title);
next:
	zero ();
        search ("TRIAL SET OF");
        for (i = 0; i < 3; i++)
                getline (In, line);
        Natom = 0;
        Nparam = 0;
        while ( fscanf (In, "%*d %d ", &Atyp[Natom]) > 0) {
                getline (In, line);
                if (Atyp[Natom] != 99) {
                        if (Atyp[Natom] > 1)
                                Nparam += 4;
                        else
                                Nparam += 1;
                        Natom++;
                }
        }
        search ("DENSITY");
        getline(In, line);


        getheader(4);
        printf ("  %d atom, %d parameter\n", Natom, Nparam);

        i0 = 0;
        for (l = 0; l < Nparam / 10 + 1; l++) {
                for (i = i0; i < Nparam; i++) {
                        fscanf (In, "%*d");
                        for (j = i0; j <= i && j < i0 + 10; j++) {
                                fscanf (In, "%lf", &x);
                                Mat[i][j] = x;
                        }
                }
                getheader(5);
                i0 += 10;
        }
        divide();
        sq_sum();
        mat_out();
        goto next;

}

mat_out()
{
        int i, j, k;
        int freeval;
        double eps;

        eps = 0.0005;
        fprintf (Out, "\n%s\n\n", Title);
        fprintf (Out, "  BOND ORDER MATRIX");
      /*  freeval = 0;
        for (i = 0; i < Natom; i++)
                if (Fval[i] > eps)
                        freeval = 1;
        */
        freeval = 1;

        for (i = 0; i < Natom; i++) {
                fprintf (Out, "\n\n");
                if (freeval)
                        fprintf (Out, "%7.3lf", Fval[i]);
                fprintf (Out, "%3d.", i + 1);
                for (j = 0; j <= i; j++) {
                        fprintf (Out, "%7.3lf", Mat[i][j]);
                        if ((j + 1) % 8 == 0) {
                                fprintf (Out, "\n    ");
                                if (freeval > 0)
                                        fprintf (Out, "       ");
                        }
                }
        }
        fprintf (Out,"\n");
}

divide()
{
        int i;

        Div[0] = 0;
        for (i = 0; i < Natom; i++) {
                if (Atyp[i] == 1)
                        Div[i + 1] = Div[i] + 1;
                else
                        Div[i + 1] = Div[i] + 4;
        }
}

sq_sum()
{
        int i, j;
        int k, l;
        int k1, l1;
        double s, sum;
        double pij2, pii, pii2;

        for (i = 0; i < Natom; i++) {
                pii2 = 0.0;
                pii = 0.0;
                pij2 = 0.0;
                for (k = Div[i]; k < Div[i + 1]; k++) {
                        for (l = Div[i]; l < k; l++)
                                pij2 = pij2 + Mat[k][l] * Mat[k][l];
                        pii2 = pii2 + Mat[k][k] * Mat[k][k];
                        pii = pii + Mat[k][k];
                }
                Val[i] = 2.0 * pii - pii2 - 2 * pij2;
                for (j = 0; j < i; j++) {
                        sum = 0.0;
                        for (k = Div[i]; k < Div[i + 1]; k++) {
                                for (l = Div[j]; l < Div[j + 1]; l++) {
                                        s = Mat[k][l];
                                        s = s * s;
                                        sum += s;
                                }
                        }
                        Sbab[i] += sum;
                        Sbab[j] += sum;
                        Mat[i][j] = sum;
                }
        }
        for (i = 0; i < Natom; i++) {
                Mat[i][i] = Val[i];
                Fval[i] = Val[i] - Sbab[i];
        }
}

getheader(n)
int n;
{
        int i;
        char c;

        for (i = 0; i < n; i++) {
                while ((c = getc(In)) != '\n' && c != EOF);
                if (c == EOF)
                        return(0);
        }
}


getline (file, t)
FILE *file;
char *t;
{
        int c;
        int len;

        len = 0;
        while ((c = getc(file)) != '\n' && c != EOF) {
                *t++ = c;
                len++;
        }
	if (c == EOF) {
		fclose (Out);
		exit (0);
	}
        *t = '\0';
        return (len);
}

search (target)
char *target;
{
        char line[140];
        char *p;
        int len;
        int talalt;
        char *s, *t;

        talalt = 0;
        while (talalt != 1) {
                len = getline (In, line);
                p = line;
                while ((talalt = strequ(target,p)) != 1 && p < line + len)
                        p++;
        }
}





strequ(s,t)
char *s, *t;
{
        while (*s == *t && *s != '\0' && *s != '\n') {
                s++;
                t++;
        }
        if (*s == '\0' || *s == '\n')
                return (1);
        return (-1);
}

zero ()
{
	int i, j;

	for (i = 0; i < MAX; i++) {
		for (j = 0; j < MAX; j++)
			Mat[i][j] = 0.0;
		Fval[i] = 0.0;
		Val[i]  = 0.0;
		Sbab[i] = 0.0;
	}
}
