      implicit real*8(a-h,o-z)
c     
c-------------------------------------------------------------------------------
c
c                    Program LOCAL, Version 1.01
c                   -----------------------------
c
c    Calculating:
c    ------------
c
c      A) Conventional (Hilbert space) bond orders and valences
c         (I. Mayer, Chem. Phys.Lett. 97, 270, 1983....)
c
c      B) Mulliken populations
c
c      C) "Extremely localized" set of non-orthogonal molecular orbitals, 
c         their strictly localized projections as well as their 
c         Lowdin-orthogonalized counterparts.
c         (T. Zoboki and I. Mayer, to be published) 
c
c          For details see the "Read me" file.
c
c
c    Cite this program as:
c    ---------------------
c    I. Mayer, Program "LOCAL", Version 1.01, Budapest, 2010.     
c
c-------------------------------------------------------------------------------
C  The program has been written by using parts of the program APOST by
c  I. Mayer and A. Hamza, Budapest, 2000-2003.
c      
c
c                     
c          e-mail: mayer@chemres.hu
c
c ------------------------------------------------------------------------
c
c
      common iop(45)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      
      parameter (nmax=500)
      parameter (ndeckl=500)
      parameter (maxat=30)
      parameter (maxat1=101)
      parameter (maxp=2000)
      common /lim/ llim(nmax),iulim(nmax)
      common /bord/ibonds(maxat,maxat)
c     dimension sam(nmax,nmax)
      common /to/to(nmax,nmax)
      dimension pmul(maxat)
      common/r/ sm12(ndeckl,ndeckl),sp12(ndeckl,ndeckl),
     $   strt(ndeckl,ndeckl),ptrt(ndeckl,ndeckl)
     $ , s23(ndeckl),s23m(ndeckl),r(nmax,nmax)
      common /c/ps(nmax,nmax),p(nmax,nmax),c(nmax,nmax)
      dimension p0(nmax,nmax)   
c      dimension clin(nmax**2)
c      equivalence (clin(1),c(1,1))
      dimension h(nmax,nmax)
      common /pointer/na(maxat)     
      common /hold/ihold(nmax),illim(nmax)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(nmax,nmax),t(nmax,nmax),
     $             sat(nmax,nmax,maxat)
      common /ia/iznuc(maxat),kop,megall
c     common /achi/achi(maxat,maxat)

      common /map/imap(maxp),imap2(maxp),ireadp
      common /qat/qat(maxat,2)
      common /ovpop/op(maxat,maxat),totq
      common /lbl/msc(nmax)

      common /pielekt/ ipiatom(20,maxat),npi(maxat),npiel(maxat),ipi
      dimension vals(maxat),valp(maxat),vald(maxat),valf(maxat),
     $valtot(maxat)
      dimension mocal(4),ilab(40),ilabel(nmax)
      dimension iatgr(maxat),alambda(nmax),iorbs(maxat)
      dimension ibe(20)
      common/exclude/ iexat(20,10),iexorb(20,10)
      character*80 name      
      equivalence (ibe(1),name)

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    


      data itot  /'Tota'/
      data ispin  /'Spin'/
      data irohf1 /'  RO'/
      data irohf2 /'HF  '/
      data mocal /'Alph','a MO',' coe','ffic'/

      data ispace /'    '/
      data ilab(1)/'   S'/
      data ilab(2)/'  PX'/
      data ilab(3)/'  PY'/
      data ilab(4)/'  PZ'/
      data ilab(5)/'  XX'/
      data ilab(6)/'  YY'/
      data ilab(7)/'  ZZ'/
      data ilab(8)/'  XY'/
      data ilab(9)/'  XZ'/
      data ilab(10)/'  YZ'/
      data ilab(11)/' D 0'/
      data ilab(12)/' D+1'/
      data ilab(13)/' D-1'/
      data ilab(14)/' D+2'/
      data ilab(15)/' D-2'/
      data ilab(16)/' F 0'/
      data ilab(17)/' F+1'/
      data ilab(18)/' F-1'/
      data ilab(19)/' F+2'/
      data ilab(20)/' F-2'/
      data ilab(21)/' F+3'/
      data ilab(22)/' F-3'/
      data ilab(23)/'  F '/
      
c     read(*,*,end=1001,err=101) Natgr
c  Natgr is the number of atoms in the group
c     read(*,*,end=102,err=102) (iatgr(i),i=1,Natgr)     
      read(*,150)ibe
 150  format(20a4)
      
      open (14,file=name)     
      open (16,file='exclude')
      open (17,file='charge')
      do i=1,20
      do j=1,10
      iexat(i,j)=0
      iexorb(i,j)=0
      enddo
      enddo

      do i=1,20
      read(16,16,err=321,end=321)(iexat(i,j),j=1,10)
      read(16,16,err=321,end=321)(iexorb(i,j),j=1,10)
  16  format(10i2)
      enddo
 321  continue


      call kiir
      call start
 
      
      m=igr

      call getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      if(nat.ne.natoms) stop 7584
      if(m.ne.nbas) stop 7585
      
      call getsome(nmax,nbas,natoms,h)

      call denstest
      
c     print *,' after denstest'      
c     call flush

      call inpint(natoms,llim,iulim)
c     print *, (msc(i),i=1,nbas)
c     print *,' Data:'
c     print 80,(ilab(i),i=1,4)
c     call flush
      i=1
  111 if(msc(i).eq.0) then
c     print *,i,msc(i)
      ilabel(i)=ilab(1)
c     write(*,80),ilabel(i)
      i=i+1
c     call flush
      if(i.gt.nbas)goto 112
      goto 111
      endif
      if(msc(i).eq.1)then
c     print *,i,msc(i)
      ilabel(i)=ilab(2)
      ilabel(i+1)=ilab(3)
      ilabel(i+2)=ilab(4)
c     write(*,80)ilabel(i),ilabel(i+1),ilabel(i+2)
      i=i+3
      if(i.gt.nbas)goto 112
      goto 111
      endif
      if(msc(i).eq.2)then
      ilabel(i)=ilab(5)
      ilabel(i+1)=ilab(6)
      ilabel(i+2)=ilab(7)
      ilabel(i+3)=ilab(8)
      ilabel(i+4)=ilab(9)
      ilabel(i+5)=ilab(10)
      i=i+6            
      if(i.gt.nbas)goto 112
      goto 111
      endif        
      if(msc(i).eq.-2)then
      ilabel(i)=ilab(11)
      ilabel(i+1)=ilab(12)
      ilabel(i+2)=ilab(13)
      ilabel(i+3)=ilab(14)
      ilabel(i+4)=ilab(15)
      i=i+5
      if(i.gt.nbas)goto 112
      goto 111
      endif

      if(msc(i).eq.-3)then
      ilabel(i)=ilab(16)
      ilabel(i+1)=ilab(17)
      ilabel(i+2)=ilab(18)
      ilabel(i+3)=ilab(19)
      ilabel(i+4)=ilab(20)
      ilabel(i+5)=ilab(21)
      ilabel(i+6)=ilab(22)
      i=i+7            
      if(i.gt.nbas)goto 112
      goto 111
      endif        
      if(msc(i).eq.3)then
      do k=i,i+9
      ilabel(k)=ilab(23)
      enddo
      i=i+10
      if(i.gt.nbas)goto 112
      goto 111
      endif
      ilabel(i)=ispace
      i=i+1
      if(i.gt.nbas)goto 112
      goto 111
c     call flush
 80   format(20a4)
      
 112  continue   
c112  write(*,80)(ilabel(i),i=1,nbas)
c     call numint
      if(ireadp.eq.1) call ordersat(nmax,nbas,natoms,h)
  
       tc1=0.d0
       tc2=0.d0
       do kat=1,nat
       x=0.d0
c      do mu=1,igr
c      do nu=1,igr
c      x=x+p(mu,nu)*sat(mu,nu,kat)
c      enddo
c      enddo
c      qat(kat,1)=x
       qat(kat,1)=0.d0
       qat(kat,2)=0.d0
       enddo

       do mu=1,igr
       kat=ihold(mu)
       x=0.d0
       do itau=1,igr
       x=x+p(mu,itau)*s(itau,mu)
       enddo
       qat(kat,2)=qat(kat,2)+x
       enddo
       
c     write(44)((p(i,j),i=1,nbas),j=1,nbas)
c     write(45)((s(i,j),i=1,nbas),j=1,nbas)

c     print *,' before border'      
c     call flush

      call border(P,ps,S,llim,iulim,natoms,nbas)
c     print *,' after border'      
c     call flush
      print *,'  '
      print *,'  '
      print *,'    ELECTRON POPULATIONS'
      print *,'  '
      print *,'  Atom   Mulliken'
      print *,' -----------------'
      do i=1,nat
c     tc1=tc1+qat(i,1)
      tc2=tc2+qat(i,2)
      print 161, i,mend(iznuc(i)),qat(i,2)
 161  format(1x,i3,A4,2f10.6)      
      enddo
      print *,' -----------------'
      print 162, tc2
 162  format(1x,'  Sum  ',2f10.6)  
      print *,'  '
      print *,'  '
      print *,'    TOTAL ATOMIC CHARGES    '
      print *,'  '
      print *,'  Atom   Mulliken'
      print *,' -----------------'
      tc1=0.d0
      tc2=0.d0
      do i=1,nat
c     tc1=tc1-qat(i,1)+dfloat(iznuc(i))
      tc2=tc2-qat(i,2)+dfloat(iznuc(i))
      print 161, i,mend(iznuc(i)),
     $    dfloat(iznuc(i))-qat(i,2)
      enddo
      print *,' -----------------'
      print 162,  tc2
      print *,'  '
      print *,'  '
 667  format(1x,79(1h-))       
      
c     print *," Mulliken's net atomic populations"
c     print *,'    (=sum of natural atomic occuppancies)'
c       
c     print *,' -----------------'
c     qqnet=0.d0
c     do i=1,natoms
c     qnet=0.d0
c     do mu=llim(i),iulim(i)
c     do nu=llim(i),iulim(i)
c     qnet=qnet+p(mu,nu)*s(nu,mu)
c     enddo
c     enddo
c     print 161, i,mend(iznuc(i)),qnet     
c     print *,i, qnet
c     qqnet=qqnet+qnet
c     enddo
c     print *,' -----------------'
c     Print 162,qqnet
      do i=1,nbas
      do j=1,nbas
      strt(i,j)=s(i,j)
c     ptrt(i,j)=p(i,j)
      enddo
      enddo
      
C   Matrix products PS and SPS in R and T

      do i=1,nbas
      do j=1,nbas
      x=0.d0
      do k=1,nbas
      x=x+p(i,k)*s(k,j)
      enddo      
      r(i,j)=x
      enddo
      enddo

      x=0.d0
      do i=1,nbas
      x=x+r(i,i)
      enddo
      print *,' Trace of PS matrix',x

      do i=1,nbas
      do j=1,nbas
      ps(i,j)=0.5d0*r(i,j)
      enddo
      enddo


      do i=1,nbas
      do j=1,nbas
      x=0.d0
      do k=1,nbas
      x=x+s(i,k)*r(k,j)
      enddo
      t(i,j)=x
      enddo
      enddo

      do i=1,nbas
      do j=1,nbas
c      strt(i,j)=s(i,j)
      ptrt(i,j)=t(i,j)
      enddo
      enddo


      read(*,150)ibe
      call distance(ibonds,natoms,ifail)
      if(ifail.eq.0)then
      do i=1,natoms
      iorbs(i)=ibonds(i,i)
      enddo
      print *,' IORBS',(iorbs(i),i=1,natoms)
      else
      do i=1,natoms
      iorbs(i)=0
      enddo
 122  read(*,*,end=123)i,iorbs(i)
      if(i.eq.0)goto124
      goto 122  
 123  print *,' End of data encountered'
 124  print *,' IORBS',(iorbs(i),i=1,natoms)
      endif


      joshift=0
      do i=1,natoms
      natgr=1
      iatgr(1)=i
      norb=iorbs(i)
c     print *,'i, norb', i, norb
      if(norb.ne.0)then
      call grouporb(natoms,nbas,natgr,iatgr,norb,alambda,ilabel,joshift)
      joshift=joshift+norb
      endif
      enddo
      iveg=joshift
      print *,' Atoms finished'
      print *,'Number of one center orbs, lambdas'
      print 62,iveg,(alambda(i),i=1,iveg)
 62   format(i4,2x,2(8F9.6/))

                                                                                
C  Itt a P... atszamolasa!!!!

C  Extracting the atomic orbitals from the P-matrix of occ. subspace

c  Computing the inverse overlap matrix of the orbitals in matrix to
 
      do i=1,iveg
      do j=i,iveg
      x=0.d0
      do mu=1,nbas
      do nu=1,nbas
      x=x+to(mu,i)*strt(mu,nu)*to(nu,j)
      enddo
      enddo
      ps(i,j)=x
      ps(j,i)=x
      enddo
      enddo
      

      call sdiag(ps,ndeckl,s23,iveg)
 
      print *,'  '
      print *,' eigenvalues of the MO overlap matrix'
      print *,(s23(i),i=1,iveg)
      print *,'  '
      do i=1,iveg
      s23(i)=1.d0/s23(i)
      enddo

      do i=1,iveg
      do j=1,iveg
      x=0.d0
      do k=1,iveg
      x=x+ps(i,k)*s23(k)*ps(j,k)
      enddo
      t(i,j)=x
      enddo
      enddo




      do mu=1,nbas
      do nu=1,nbas
      p0(mu,nu)=p(mu,nu)
      x=0.d0
      do i=1,iveg
      do j=1,iveg
      x=x+to(mu,i)*t(i,j)*to(nu,j)
      enddo
      enddo
      p(mu,nu)=p(mu,nu)-2.d0*x
      enddo
      enddo                                                                          
                                                                                
      
C   Matrix products PS and SPS in R and T with the modified P

      do i=1,nbas
      do j=1,nbas
      x=0.d0
      do k=1,nbas
      x=x+p(i,k)*strt(k,j)
      enddo      
      r(i,j)=x
      enddo
      enddo

      x=0.d0
      do i=1,nbas
      x=x+r(i,i)
      enddo
      print *,' Trace of PS matrix',x

      do i=1,nbas
      do j=1,nbas
      ps(i,j)=0.5d0*r(i,j)
      enddo
      enddo


      do i=1,nbas
      do j=1,nbas
      x=0.d0
      do k=1,nbas
      x=x+strt(i,k)*r(k,j)
      enddo
      t(i,j)=x
      enddo
      enddo

      do i=1,nbas
      do j=1,nbas
c      strt(i,j)=s(i,j)
      ptrt(i,j)=t(i,j)
      enddo
      enddo


                                                                                
                                                                                
      natgr=2
      if(ifail.eq.0)then
      do i=1,natoms-1
      do j=i+1,natoms
      if(ibonds(i,j).ne.0) then
      norb=ibonds(i,j)
      iatgr(1)=i
      iatgr(2)=j
      call grouporb(natoms,nbas,natgr,iatgr,norb,alambda,ilabel,joshift)
      joshift=joshift+norb
      iveg=joshift
      endif
      enddo
      enddo
      else
 142  read(*,*,end=126) iatgr(1),iatgr(2),norb
 125  if(iatgr(1).eq.0)goto 127
      if(norb.ne.0)then
      call grouporb(natoms,nbas,natgr,iatgr,norb,alambda,ilabel,joshift)
      joshift=joshift+norb
      else
      print *,' Zero orbitals specified for the bond',iatgr(1),'--',
     $  iatgr(2)
      stop 128
      endif
                                                                                
      iveg=joshift
                                                                                
      goto 142
      endif
 126  print *,' End of data encountered'
 127  print *,' Bonds finished'
      print *,'Number of one and two-center center orbs, lambdas'
      print 62,iveg,(alambda(i),i=1,iveg)
 


                                                                                
C  Itt a P... ujabb atszamolasa!!!!

C  Extracting the atomic orbitals from the P-matrix of occ. subspace

      do mu=1,nbas
      do nu=1,nbas
      p(mu,nu)=p0(mu,nu)
      enddo
      enddo



c  Computing the inverse overlap matrix of the orbitals in matrix to
 
      do i=1,iveg
      do j=i,iveg
      x=0.d0
      do mu=1,nbas
      do nu=1,nbas
      x=x+to(mu,i)*strt(mu,nu)*to(nu,j)
      enddo
      enddo
      ps(i,j)=x
      ps(j,i)=x
      enddo
      enddo
      

      call sdiag(ps,ndeckl,s23,iveg)
 
      print *,'  '
      print *,' eigenvalues of the MO overlap matrix'
      print *,(s23(i),i=1,iveg)
      print *,'  '
      do i=1,iveg
      s23(i)=1.d0/s23(i)
      enddo

      do i=1,iveg
      do j=1,iveg
      x=0.d0
      do k=1,iveg
      x=x+ps(i,k)*s23(k)*ps(j,k)
      enddo
      t(i,j)=x
      enddo
      enddo




      do mu=1,nbas
      do nu=1,nbas
      p0(mu,nu)=p(mu,nu)
      x=0.d0
      do i=1,iveg
      do j=1,iveg
      x=x+to(mu,i)*t(i,j)*to(nu,j)
      enddo
      enddo
      p(mu,nu)=p(mu,nu)-2.d0*x
      enddo
      enddo                                                                          
                                                                                

                                                                                
      
C   Matrix products PS and SPS in R and T with the modified P

      do i=1,nbas
      do j=1,nbas
      x=0.d0
      do k=1,nbas
      x=x+p(i,k)*strt(k,j)
      enddo      
      r(i,j)=x
      enddo
      enddo

      x=0.d0
      do i=1,nbas
      x=x+r(i,i)
      enddo
      print *,' Trace of PS matrix',x

      do i=1,nbas
      do j=1,nbas
      ps(i,j)=0.5d0*r(i,j)
      enddo
      enddo


      do i=1,nbas
      do j=1,nbas
      x=0.d0
      do k=1,nbas
      x=x+strt(i,k)*r(k,j)
      enddo
      t(i,j)=x
      enddo
      enddo

      do i=1,nbas
      do j=1,nbas
c      strt(i,j)=s(i,j)
      ptrt(i,j)=t(i,j)
      enddo
      enddo


      do iii=1,ipi

      natgr=npi(iii)
      nnpi=0
      do i=1,natgr
      iatgr(i)=ipiatom(iii,i)
      nnpi=nnpi+npiel(iatgr(i))
      enddo
      print *, natgr,' Pi atoms:'
      print *, (iatgr(i),i=1,natgr)
      print *,' Number of Pi-electrons', nnpi
      norb=nnpi/2
      if(2*norb.ne.nnpi) stop 444
 

      call grouporb(natoms,nbas,natgr,iatgr,norb,alambda,ilabel,joshift)
      joshift=joshift+norb

      iveg=joshift
      enddo
      print *,' Pi-electrons finished'
      print *,'Number of orbitals, lambdas'
      print 62,iveg,(alambda(i),i=1,iveg)




      write(77) nbas,iveg
      write(77)(alambda(i),i=1,iveg)
      write(77)((c(i,j),i=1,nbas),j=1,iveg)
      write(78) nbas,iveg
      write(78)(alambda(i),i=1,iveg)
      write(78)((to(i,j),i=1,nbas),j=1,iveg)
c     do i=1,nbas
c     print 61,(c(i,j),j=1,iveg)
c     enddo
      print *,' '
c     do i=1,nbas
c     print 61,(to(i,j),j=1,iveg)
c     enddo
  61  format(1x,8f9.5)
      do i=1,iveg
      do j=1,iveg
      x=0.d0
      y=0.d0
      z=0.d0
      do mu=1,nbas
      do nu=1,nbas
      x=x+c(mu,i)*strt(mu,nu)*c(nu,j)
      y=y+to(mu,i)*strt(mu,nu)*to(nu,j)
      z=z+c(mu,i)*strt(mu,nu)*to(nu,j)
      enddo
      enddo
      p(i,j)=x
      s(i,j)=y
      t(i,j)=z
      enddo
      enddo
      print *,' '
      print *,' Lambda values recalculated'
      print 62,iveg,(t(i,i),i=1,iveg)
      print *,' '
      print *,'  Group orbitals'
      call mprint01(c,iveg,nbas,nmax)
      print *,' '
      print *,'  Localized orbitals'
      call mprint01(to,iveg,nbas,nmax)
      print *,' ' 
      print *,' Overlap of the group orbitals'
      call mprint01(p,iveg,iveg,nmax)





c     do i=1,iveg
c     print 61,(p(i,j),j=1,iveg)
c     enddo      
      print *,' ' 
      print *,' Overlap of the localized orbitals'
      call mprint01(s,iveg,iveg,nmax)
c     do i=1,iveg
c     print 61,(s(i,j),j=1,iveg)
c     enddo      
      print *,' ' 
      print *,' Cross-overlaps '
      call mprint01(t,iveg,iveg,nmax)
c     do i=1,iveg
c     print 61,(t(i,j),j=1,iveg)
c     enddo


      
      call sdiag(s,ndeckl,s23,iveg)
      print *,' Eigenvalues of the loc. orbitals overlap matrix'
      print *,(s23(i),i=1,iveg)
      do i=1,iveg
      s23(i)=1/dsqrt(s23(i))
      enddo
      do i=1,iveg
      do j=1,iveg
      x=0.d0
      do k=1,iveg
      x=x+s(i,k)*s23(k)*s(j,k)
      enddo
      t(i,j)=x
      enddo
      enddo

      print *,'Loc. orbitals S^(-1/2) natrix'
      call mprint01(t,iveg,iveg,nmax)

      do mu=1,nbas
      do j=1,iveg
      x=0.d0
      do k=1,iveg
      x=x+t(k,j)*to(mu,k)
      enddo
      h(mu,j)=x
      enddo
      enddo

      print *,' '
      print *,'  Lowdin-orthogonalized localized orbitals'
      call mprint01(h,iveg,nbas,nmax)

      difi=0.d0
      do mu=1,nbas
      do nu=1,nbas
      x=0.d0
      do i=1,iveg
      x=x+h(mu,i)*h(nu,i)
      enddo
      difi=dmax1(difi,dabs(2.d0*x-p0(mu,nu)))
      enddo
      enddo
      print *,' Difi= ',difi
c     write(55)((p0(i,j),i=1,nbas),j=1,nbas)

      write(79) nbas,iveg
      write(79)(alambda(i),i=1,iveg)
      write(79)((h(i,j),i=1,nbas),j=1,iveg)



      
      call sdiag(p,ndeckl,s23,iveg)
      print *,' Eigenvalues of the group orbitals overlap matrix'
      print *,(s23(i),i=1,iveg)
      do i=1,iveg
      s23(i)=1/dsqrt(s23(i))
      enddo
      do i=1,iveg
      do j=1,iveg
      x=0.d0
      do k=1,iveg
      x=x+p(i,k)*s23(k)*p(j,k)
      enddo
      t(i,j)=x
      enddo
      enddo

      print *,'Group orbitals S^(-1/2) natrix'
      call mprint01(t,iveg,iveg,nmax)

      do mu=1,nbas
      do j=1,iveg
      x=0.d0
      do k=1,iveg
      x=x+t(k,j)*c(mu,k)
      enddo
      p(mu,j)=x
      enddo
      enddo

      print *,' '
      print *,'  Lowdin-orthogonalized group orbitals'
      call mprint01(p,iveg,nbas,nmax)

      write(80) nbas,iveg
      write(80)(alambda(i),i=1,iveg)
      write(80)((p(i,j),i=1,nbas),j=1,iveg)


      stop
  101 stop 101
  102 stop 102
 1001 print *,' No group specified. Stop'
      stop 1001
      end


      subroutine grouporb(natoms,nbas,natgr,iatgr,norb,alambda,ilabel,
     $    joshift)
      implicit real*8(a-h,o-z)
      common iop(45)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      
      parameter (nmax=500)
      parameter (ndeckl=500)
      parameter (maxat=30)
      parameter (maxat1=101)
      parameter (maxp=2000)
      common /lim/ llim(nmax),iulim(nmax)
c     dimension ibe(20)
c     dimension sam(nmax,nmax)
      dimension tt(nmax,nmax)
      dimension pmul(maxat)
      common/r/ sm12(ndeckl,ndeckl),sp12(ndeckl,ndeckl),
     $   strt(ndeckl,ndeckl),ptrt(ndeckl,ndeckl)
     $ , s23(ndeckl),s23m(ndeckl),r(nmax,nmax)
      common /c/ps(nmax,nmax),pp(nmax,nmax),c(nmax,nmax)
      dimension p(nmax,nmax)   
c      dimension clin(nmax**2)
c      equivalence (clin(1),c(1,1))
      common /pointer/na(maxat)     
      common /to/to(nmax,nmax)
      common /hold/ihold(nmax),illim(nmax)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(nmax,nmax),t(nmax,nmax),
     $             sat(nmax,nmax,maxat)
      common /ia/iznuc(maxat),kop,megall
c     common /achi/achi(maxat,maxat)

      common /map/imap(maxp),imap2(maxp),ireadp
      common /qat/qat(maxat,2)
      common /ovpop/op(maxat,maxat),totq
      common /lbl/msc(nmax)
      common/exclude/ iexat(20,10),iexorb(20,10)

      dimension vals(maxat),valp(maxat),vald(maxat),valf(maxat),
     $valtot(maxat)
      dimension mocal(4),ilab(40),ilabel(nmax)
      dimension iatgr(maxat),alambda(nmax)
      dimension ibe(20)
      character*80 name      
      equivalence (ibe(1),name)
      dimension map(nmax)

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    


      data itot  /'Tota'/
      data ispin  /'Spin'/
      data irohf1 /'  RO'/
      data irohf2 /'HF  '/
      data mocal /'Alph','a MO',' coe','ffic'/

      data ispace /'    '/
      data ilab(1)/'   S'/
      data ilab(2)/'  PX'/
      data ilab(3)/'  PY'/
      data ilab(4)/'  PZ'/
      data ilab(5)/'  XX'/
      data ilab(6)/'  YY'/
      data ilab(7)/'  ZZ'/
      data ilab(8)/'  XY'/
      data ilab(9)/'  XZ'/
      data ilab(10)/'  YZ'/
      data ilab(11)/' D 0'/
      data ilab(12)/' D+1'/
      data ilab(13)/' D-1'/
      data ilab(14)/' D+2'/
      data ilab(15)/' D-2'/
      data ilab(16)/' F 0'/
      data ilab(17)/' F+1'/
      data ilab(18)/' F-1'/
      data ilab(19)/' F+2'/
      data ilab(20)/' F-2'/
      data ilab(21)/' F+3'/
      data ilab(22)/' F-3'/
      data ilab(23)/'  F '/
      

C process the specification of the group. (If natgr=0, do effective AO-s)
      
c     read(*,*,end=1001,err=101) Natgr
c  Natgr is the number of atoms in the group
      if(natgr.eq.0) goto 1001
      if(natgr.lt.0.or.natgr.gt.natoms) then
      print *,' Wrong group data. STOP'
      stop 1004
      endif
c     read(*,*,end=102,err=102) (iatgr(i),i=1,Natgr)     
      do i=1,Natgr
      if(iatgr(i).le.0.or.iatgr(i).gt.natoms) then
      print *,' Wrong group data. STOP'
      stop 1005
      endif
      enddo

      if(Natgr.gt.1)then
      do i=1,Natgr-1
      do j=i+1,Natgr
      if(iatgr(i).eq.iatgr(j))then
      print *,' Wrong group data. STOP'
      stop 1006
      endif
      enddo
      enddo
      endif

      print *,' '
      print *,' '
       print 667
 667  format(1x,79(1h-))       
      print *,' '
c     print *,' Natgr=',natgr
      print *,' '
      print *,' The group consists of ',natgr,' atoms:' 
      print *,' '
      print 617, (iatgr(iagr),mend(iznuc(iatgr(iagr))),iagr=1,Natgr)
  617 format(10(i3,a4,1h ))
      print *,' '


      
      jex=0
      do 323 ii=1,20
      if(iexat(ii,1).eq.0) goto 322
      jat=0
      do j=1,10
      if(iexat(ii,j).ne.0)jat=j
      enddo
      print *,'jat=',jat
      if(jat.ne.natgr)goto 323
      do 327 j=1,jat
      if(iexat(ii,j).ne.iatgr(j))goto 323
  327 continue
      isor=ii
      print *,' Exclusion found, line=',isor
      goto 324
  323 continue
      goto 322
  324 jex=1
      do j=1,10
      if(iexorb(isor,j).ne.0)jex=j
      enddo
      
  322 continue
      print *,'jex=',jex
      nact=norb


      iki=0
      do 325 i=1,nact+jex
      do j=1,jex
      if(iexorb(isor,j).eq.i)goto 325
      enddo
      iki=iki+1
      map(iki)=i
 325  continue    
      print *,(map(i),i=1,nact)
      im=map(nact)+1
      do i=nact+1,nmax
      map(i)=im
      im=im+1
      enddo
c     print *,(map(i),i=1,40)
C    Fragment S and SPS matrices

      goto 1002
c 101 stop 101
c 102 stop 102
 1002 continue
      ifut=0
      do i=1,Natgr
      jfut=0
      iat=iatgr(i)
      ishift=llim(iat)-1
      do j=1,Natgr
      jat=iatgr(j)
      jshift=llim(jat)-1
      do mu=llim(iat),iulim(iat)
      do nu=llim(jat),iulim(jat)
      s(ifut+mu-ishift,jfut+nu-jshift)=strt(mu,nu)
      p(ifut+mu-ishift,jfut+nu-jshift)=ptrt(mu,nu)
      enddo
      enddo
      jfut=jfut+iulim(jat)-llim(jat)+1
      enddo
      ifut=ifut+iulim(iat)-llim(iat)+1
      enddo
      mgr=jfut
      if(mgr.ne.ifut)stop 103
c     print *, ' Group S matrix'
c     call mprint0(s,mgr,ndeckl)
c     print *, ' Group SPS matrix'
c     call mprint0(p,mgr,ndeckl)
      do i=1,mgr
      do j=1,mgr
      r(i,j)=t(i,j)
      enddo
      enddo
c     call sdiag(r,ndeckl,s23,mgr)
c     print *,' Sajatertekek a metrika nelkul'
c     print *, (s23(i),i=1,mgr)
c     print *,' '
c     print *, ' Group D matrix'
c     call mprint0(p,mgr,ndeckl)
c     x=0.d0
c     do mu=1,mgr
c     do nu=1,mgr
c     x=x+p(mu,nu)*s(nu,mu)
c     enddo
c     enddo
c     print *,' Group net Mulliken population', x

      call sdiag(s,ndeckl,s23,mgr)
c     print *,' Eigenvalues of the group S matrix'
c     print *, (s23(i),i=1,mgr)
      do i=1,mgr
      x=dsqrt(dabs(s23(i)))
      s23(i)=x
      s23m(i)=1.d0/x
      enddo
c     print *, (s23(i),i=1,mgr)

      do i=1,mgr 
      do j=1,mgr 
      x=0.d0
      y=0.d0
      do k=1,mgr
      x=x+s(i,k)*s23(k)*s(j,k)
      y=y+s(i,k)*s23m(k)*s(j,k)
      enddo
      sp12(i,j)=x
      sm12(i,j)=y
      enddo
      enddo

c     print *, ' Group S^(-1/2) matrix'
c     call mprint0(sm12,mgr,ndeckl)

      do i=1,mgr
      do j=1,mgr
      x=0.d0
      do k=1,mgr
      x=x+sm12(i,k)*p(k,j)
      enddo
      t(i,j)=x
      enddo
      enddo


      do i=1,mgr
      do j=1,mgr
      x=0.d0
      do k=1,mgr
      x=x+t(i,k)*sm12(k,j)
      enddo
      p(i,j)=x
      enddo
      enddo

c     print *, ' Group Lowdin D-matrix'
c     call mprint0(p,mgr,ndeckl)
 
      call sdiag(p,ndeckl,s23,mgr)
c     x=0.d0
c     do i=1,mgr
c     x=x+s23(i)
c     enddo
c     print *,' Sum of the eigenvalues of the  group  SDS matrix',x


      print *,' Eigenvalues of the group  SDS matrix'
      print *, (s23(i),i=1,mgr)
      print *, 'Logarithmic localization parameters'
      print *, (-dlog10(1.d0-s23(i)/2.d0),i=1,mgr)
      print *,' Lambda values '
      do i=1,mgr-jex
      if(s23(i).gt.0.d0)s23(i)=dsqrt(s23(map(i))/2.d0)
      enddo
      do i=1,mgr-jex
      alambda(i+joshift)=s23(i)
      enddo
      print *, (s23(i),i=1,mgr-jex)
      print *,' '
      iveg=0
      do i=1,mgr-jex
      if(s23(i).gt.0.03d0)iveg=i
      enddo
c     print *,' iveg', iveg
            
      do i=1,mgr
      do j=1,mgr
      x=0.d0
      do k=1,mgr
      x=x+sm12(i,k)*p(k,j)
      enddo
      tt(i,j)=x
      enddo
      enddo

c     do i=1,mgr
c     write(*,624)(t(i,j),j=1,iveg)
c     enddo
  624 format(10f8.4)     

      do i=1,nbas 
      do j=1,nbas 
      c(j,i+joshift)=0.d0
      enddo
      enddo
      
      do j=1,iveg

      ifut=0
      do i=1,Natgr
      iat=iatgr(i)
       do mu=llim(iat),iulim(iat)
       c(mu,j+joshift)=tt(mu+ifut-llim(iat)+1,map(j))
       enddo
      ifut=ifut+iulim(iat)-llim(iat)+1
      enddo

      enddo
           
      print *,' '
c     do i=1,nbas
c     write(*,624)(c(i,j),j=1,iveg)
c     enddo

c     print *,'nbas,iveg', nbas,iveg
c     write(77) nbas,iveg
c     write(77)(s23(i),i=1,iveg)
c     write(77)((c(i,j),i=1,nbas),j=1,iveg)

      print *,' '
      print *,' Group orbitals with natural occupancies > 0.03'
      print *,' '


      call mprint4(c,iveg,nbas,ndeckl,s23,ilabel,iznuc,mend,llim,iulim,
     $natoms,natgr,iatgr,joshift)      


c     rewind 99
c     read(99,*,err=1111,end=1111) Nact
      nact=norb

c     print *,'norb,nact', norb,nact
      lim=0
      do i=1,Natgr
      iat=iatgr(i)
      lim=lim+iulim(iat)-llim(iat)+1
      enddo
      

      nact=min0(nact,lim)
      print *,' Processing ',Nact,' group orbitals'
      print *,' '
c      print *,'   Matrix PS  '
      
c     do mu=1,nbas
c     print 61, (ps(mu,i),i=1,nbas)
c     enddo
      print *,' '
      print *,' The localized orbitals of the group'
      

      do i=1,nact
      do mu=1,nbas
      x=0.d0
      lim=0
      do nu=1,nbas
      x=x+ps(mu,nu)*c(nu,i+joshift)
      enddo

c     do ii=1,Natgr
c     lim1=lim
c     iat=iatgr(ii)
c     ishift=llim(iat)-1
c     lim=lim+iulim(iat)-llim(iat)+1
c     print *,'iat,iulim(iat),llim(iat),lim1,lim,ishift',
c    $  iat,iulim(iat),llim(iat),lim1,lim,ishift
c     do nu=lim1+1,lim
c     x=x+ps(mu,nu+ishift)*c(nu,i)
c     print *,'mu,nu,ps(mu,nu+ishift),c(nu,i)',
c    $ mu,nu,ps(mu,nu+ishift),c(nu,i)
c     enddo
c     enddo

      to(mu,i+joshift)=x
c     t(mu,i)=x
      enddo
      enddo
      
c     if(nact.ne.0)then
c     do mu=1,nbas
c     print 61, (to(mu,i+joshift),i=1,nact)
c     print 61, (t(mu,i),i=1,nact)
c     enddo
c     print *,' '
c     endif
      

      do i=1,nact
      x=0.d0
      do mu=1,nbas
      do nu=1,nbas
      x=x+to(mu,i+joshift)*strt(mu,nu)*to(nu,i+joshift)
      enddo
      enddo
      p(i,i)=1.d0/dsqrt(x)
      enddo
 
      do i=1,nact
      do mu=1,nbas
      to(mu,i+joshift)=to(mu,i+joshift)*p(i,i)
      enddo
      enddo
      
      if(nact.ne.0)then
      do mu=1,nbas
      print 61, (to(mu,i+joshift),i=1,nact)
      enddo
      endif
  61  format(1x,8f9.5)

c     do i=1,nact
c     do j=1,nact
c     x=0.d0
c     do mu=1,nbas
c     do nu=1,nbas
c     x=x+to(mu,i+joshift)*strt(mu,nu)*to(nu,j+joshift)
c     enddo
c     enddo
c     p(i,j)=x
c     enddo
c     enddo
c     
c     do i=1,nact
c     print 62, (p(i,j),j=1,nact)
c     enddo
  62  format(5f15.10)
c     print *,' '
c     print 62, (2.d0*p(i,i),i=1,nact)

 1111 continue
      return
      stop 
 1001 Print *,' No group specified' 
      print *,' STOP '
     
      return
c     stop  
c1000 stop 1000     
      end 

      subroutine getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      implicit real*8(a-h,o-z)
      dimension llim(nmax),iulim(nmax),na(maxat)
      NATOMS=0
      NBAS=0
      DO 3 I=1,nmax
      IF(iulim(I).GT.0) NATOMS=I
  3   NBAS=iulim(natoms)
       if(natoms.gt.maxat)then
      write(*,*)'   TOO MANY ATOMS, STOP'
      stop
       endif
      if(natoms.eq.1) then
      write(*,*)'  ONLY ONE ATOM'
      stop  
      endif
      nnn=0
      do 4 i=1,natoms
      na(i)=iulim(i)-llim(i)+1
  4   nnn=nnn+na(i)
      if(nnn.ne.nbas)stop 1212
      nnab=(natoms*(natoms-1))/2
      if(nnab*2.ne.natoms*(natoms-1))stop 1213

      print *,'   '
      write(*,*)natoms,' ATOMS, ',nnab,' ATOMIC PAIRS'
      
      end

      subroutine getsome(ndeckl,nbas,natoms,h)
      implicit real*8(a-h,o-z)
      parameter (maxat=30)
      parameter (nmax=500) 
      parameter (maxp=2000)
      common /stv/ s(nmax,nmax),t(nmax,nmax),
     $   vv(nmax,nmax,maxat)   
      common /c/ps(nmax,nmax),p(nmax,nmax),dummy(nmax,nmax)
      dimension h(nmax,nmax)
      common /map/imap(maxp),imap2(maxp),ireadp
      m=nbas
       do 121 j=1,m
       jj=imap(j)
       do 121 i=1,m
        ii=imap(i)
  121  h(jj,ii)=s(j,i)
       do 131 i=1,m
       do 131 j=1,m
  131  s(j,i)=h(j,i)
       
       return
       end

      subroutine pm(c,nocc,m,p,ndeckl)  
      implicit real*8(a-h,o-z)
      dimension c(ndeckl,ndeckl),p(ndeckl,ndeckl)
       do 1 i=1,m
       do 1 j=1,m
       x=0.d0
       do 2 k=1,nocc
  2     x=x+c(i,k)*c(j,k)
  1    p(i,j)=2.d0*x

  61  format(1x,8f9.7)

       return
       end

      subroutine inpint(natoms,llim,iulim)
      IMPLICIT REAL*8 (A-H,O-Z)
      
      parameter (maxat=30)
      parameter (nmax=500)
c     dimension g(mgmax)
      dimension llim(nmax),iulim(nmax)
      common /pointer/na(maxat)     
      common /hold/ihold(nmax),illim(nmax)
      common /nat/ nat,igr,ifg,idum3(4)
      common iop(45)
     
      do i=1,natoms
      do mu=llim(i),iulim(i)
      ihold(mu)=i
      enddo
      enddo
   61 format(20i2)

      do i=1,natoms
      illim(i)=llim(i)
      enddo

c     call gamgen
c     do i=1,Natoms
c     call shellat(i,igr,natoms)
c     if(iop(7).ne.0)call unconat(i)
c     enddo
      
      return      
      end


      SUBROUTINE MPRINT(H,N,ndim)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION H(NDIM,NDIM)
      parameter (maxat=30)
      common /ia/ia(maxat),kkk,idummy

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
    
      K=8 
   65 FORMAT(1H0,40X,A4/)
      NMIN=1
      NMAX=MIN0(N,K)
   62 FORMAT(1X,I3,A4,8F9.4)
   1  PRINT 61, (I, mend(ia(i)),I=NMIN,NMAX)
   61 FORMAT(10X,8(1X,I3,A4,1X))
      PRINT 64
   64 FORMAT(1X)
      DO 2 I=1,N
      PRINT 62,I,mend(ia(i)),(H(I,J),J=NMIN,NMAX)
   2  CONTINUE
      NMIN=NMIN+8
      K=K+8
      NMAX=MIN0(N,K)
      IF(NMAX.GE.NMIN) GOTO 71
      RETURN
   71 PRINT 63
   63 FORMAT(1X///)
      GO TO 1
      END

      subroutine kiir
      implicit real*8(a-h,o-z)
      write(*,6670)
      write(*,6661)
 6661 format(/20x,'Program LOCAL, Version 1.01')
      write(*,6662)
 6662 format(20x,28(1h-),/)
      write(*,6663)
      write(*,6660)
 6663 format(3x,'Calculating:')
 6660 format(3x,'------------',/)
      write(*,6664)
 6664 format(5x,2hA),' Conventional (Hilbert space) bond orders and'
     $ , ' valences'/'        (I. Mayer, Chem. Phys.'
     $,'Lett. 97, 270, 1983....)',/)
      write(*,6665)
 6665 format(5x,2hB)," Mulliken's  populations"/)
      write(*,6545)
 6545 format(5x,2hC),' "Extremely localized" set of non-orthogonal',
     $' molecular',/,'        orbitals, their strictly localized ',
     $ 'projections and '/,
     $'        Lowdin-orthogonalized counterparts'/,
     $'        (T. Zoboki and I. Mayer, to be published)'/ )
 6666 format(3x,'for a wave function obtained in a Gaussian ',
     $ 'calculation (G92, G94, G98, G03...?)',//)
      write(*,6667)
      write(*,6668)
      write(*,6669)
 6667 format(2x,' Cite this program as:')
 6668 format(2x,' ---------------------')
 6669 format(' I. Mayer, Program "LOCAL", Version 1.00,'
     $ ,' Budapest, 2010.',/)
 6670 format(1x,79(1h-))
      write(*,6670)
      end

      subroutine ordersat(ndeckl,nbas,natoms,h)
      implicit real*8(a-h,o-z)
      parameter (maxat=30)
      parameter (nmax=500) 
      parameter (maxp=2000)
      common /stv/ s(nmax,nmax),t(nmax,nmax),
     $   sat(nmax,nmax,maxat)   
      common /c/ps(nmax,nmax),p(nmax,nmax),dummy(nmax,nmax)
      dimension h(nmax,nmax)
      common /map/imap(maxp),imap2(maxp),ireadp
      m=nbas
c     print *, 'Ordersat'
c     print *,(imap2(i),i=1,nbas)
       do 1 kat=1,natoms
       do 121 j=1,m
       jj=imap2(j)
       do 121 i=1,m
        ii=imap2(i)
  121  h(jj,ii)=sat(j,i,kat)
       do 131 i=1,m
       do 131 j=1,m
  131  sat(j,i,kat)=h(j,i)
    1  continue 
       return
       end



      
      
      subroutine denstest
      implicit real*8(a-h,o-z)
      common iop(45)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      
      parameter (nmax=500)
      parameter (maxat=30)
      parameter (maxat1=101)
      parameter (maxp=2000)
      common /lim/ llim(nmax),iulim(nmax)
      dimension ibe(20)
c     dimension sam(nmax,nmax)
      dimension h(nmax,nmax)
      dimension pmul(maxat)
      common /c/ps(nmax,nmax),p(nmax,nmax),dummy(nmax,nmax)
      common /opensh/ cb(nmax,nmax)   
      dimension clin(nmax**2)
      equivalence (clin(1),cb(1,1))
      common /pointer/na(maxat)     
      common /hold/ihold(nmax),illim(nmax)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(nmax,nmax),t(nmax,nmax),
     $             sat(nmax,nmax,maxat)
      common /ia/iznuc(maxat),kop,megall
c     common /achi/achi(maxat,maxat)

      common /map/imap(maxp),imap2(maxp),ireadp
      common /qat/qat(maxat,2)
      common /ovpop/op(maxat,maxat),totq

      dimension mocal(4)
    


      data itot  /'Tota'/
      data ispin  /'Spin'/
      data irohf1 /'  RO'/
      data irohf2 /'HF  '/
      data mocal /'Alph','a MO',' coe','ffic'/

      

 

      
      m=igr
      nbas=igr

c     call getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
c     if(nat.ne.natoms) stop 7584
c     if(m.ne.nbas) stop 7585
      
c     call getsome(nmax,nbas,natoms,h)

c     print *,' Checking the number of electrons'
       tc1=0.d0
       do mu=1,igr
c      kat=ihold(mu)
       x=0.d0
       do itau=1,igr
       x=x+p(mu,itau)*s(itau,mu)
       enddo
c      qat(kat,2)=qat(kat,2)+x
       tc1=tc1+x
       enddo

c      print *,'when calc',(qat(i,2),i=1,natoms)

c            print *,tc1,nalf,nb,nalf+nb
       if(dabs(tc1-dfloat(nalf+nb)).gt.0.1d0)then
      print *,' '
      Print *,' WRONG DENSITY  (Trace of DS=', tc1,')'
      rewind 15
      ntriang=(igr*(igr+1))/2
c     print *,' Ntriang',ntriang
      ndens=-1
 200  read(15,150,end=211)(ibe(i),i=1,4)
 150  format(20a4) 
      if(ibe(1).eq.itot)ndens=ndens+1
      goto 200
 211  rewind 15
 212  read(15,150,end=1711)(ibe(i),i=1,4)
      if(ibe(3).eq.irohf1.and.ibe(4).eq.irohf2)then 
      print *,' '
      Print *,' ROHF case'
      goto 2000
      else
      goto 212
      endif
 1711 print *, 'Different data order. Rereading the',  
     $   ndens,'-d/th density of the checkpoint file'   
      ncou=-1
      rewind 15
 220  read(15,150)(ibe(i),i=1,4)
      if(ibe(1).eq.itot)ncou=ncou+1
      if(ncou.eq.ndens) then
      read(15,*)(clin(i),i=1,ntriang)
c     print *, (clin(i),i=1,ntriang)
      goto 230
      else
      endif        
      goto 220

 230   ncou=1
      do j=1,i
      do i=j,igr
      p(i,j)=clin(ncou)
      p(j,i)=clin(ncou)
      ncou=ncou+1
      enddo
      enddo
      
      else
      endif


       tc1=0.d0
       do mu=1,igr
c      kat=ihold(mu)
       x=0.d0
       do itau=1,igr
       x=x+p(mu,itau)*s(itau,mu)
       enddo
c      qat(kat,2)=qat(kat,2)+x
       tc1=tc1+x
       enddo

c      print *,'when calc',(qat(i,2),i=1,natoms)

c              print *,tc1,nalf,nb,nalf+nb
       if(dabs(tc1-dfloat(nalf+nb)).gt.0.1d0)then
      Print *,' *** ', tc1
      print *,' WRONG DENSITY.  STOP. '
      STOP
      endif

      
c     do i=1,igr
c     print *,(p(i,j),j=1,i)
c     enddo
       
c     call pm(c,nocc,nbas,p,nmax)
c     print *,'after calling PM'
c     do i=1,igr
c     print 6230,(p(i,j),j=1,i)
c     enddo
c6230 format(5f10.5)    

      if(nalf.ne.nb)then
c      print *,' Checking the spin norm'
       tc1=0.d0
       do mu=1,igr
       x=0.d0
       do itau=1,igr
       x=x+ps(mu,itau)*s(itau,mu)
       enddo
       tc1=tc1+x
       enddo

c      print *,'when calc',(qat(i,2),i=1,natoms)

c             print *,tc1,nalf,nb,nalf-nb

      if(dabs(tc1-dfloat(nalf-nb)).gt.0.01d0)then
               
      rewind 15
      ntriang=(igr*(igr+1))/2
      print *,' Ntriang',ntriang
      nsdens=0
 1200 read(15,150,end=1211)(ibe(i),i=1,4)
 1150 format(20a4) 
      if(ibe(1).eq.ispin)nsdens=ndens+1
      goto 1200
 1211 if(nsdens.eq.0) goto 1500
      print *, 'Different data order. Rereading the',  
     $   nsdens,'-d/th s.density of the checkpoint file'   
      ncou=-1
      rewind 15
 1220 read(15,150)(ibe(i),i=1,4)
      if(ibe(1).eq.ispin)ncou=ncou+1
      if(ncou.eq.nsdens) then
      read(15,*)(clin(i),i=1,ntriang)
      goto 1230
      else
      endif        
      goto 1220

 1230 ncou=1
      do j=1,igr
      do i=j,igr
      ps(i,j)=clin(ncou)
      ps(j,i)=clin(ncou)
      ncou=ncou+1
      enddo
      enddo
      
      endif        
      endif
      goto 1510 
 1500 print *, ' No spin-density is present in the checkpoint file'      
      print *, ' In the ROHF case can be constructed '
      print *, ' In CAS (etc?) - not '
      stop
       
c       tc1=0.d0
c       do mu=1,igr
c       kat=ihold(mu)
c       x=0.d0
c       do itau=1,igr
c       x=x+p(mu,itau)*s(itau,mu)
c       enddo
c       qat(kat,2)=qat(kat,2)+x
c       tc1=tc1+x
c       enddo
cc      print *,'before calling border',(qat(i,2),i=1,natoms)

 1510  return    
  
       

 2000 print *,'Density and spin-density will be re-built by using' 
     $ ,  ' the MO-s'


       rewind 15
 146  read(15,150,end=1000)(ibe(i),i=1,4)

      if(ibe(1).eq.mocal(1).and.ibe(2).eq.mocal(2).
     $ and.ibe(3).eq.mocal(3).and.ibe(4).eq.mocal(4)) then
      read(15,*,err=2003)((cb(i,j),i=1,nbas),j=1,nbas)
 2003 continue    
      else 
      goto 146
      endif
        
      do mu=1,igr
      do nu=1,mu
      x=0.d0
      do i=1,nb
      x=x+cb(mu,i)*cb(nu,i)
      enddo
      p(mu,nu)=2.d0*x
      x=0.d0
      do j=nb+1,nalf
      x=x+cb(mu,i)*cb(nu,i)
      enddo
      p(mu,nu)=p(mu,nu)+x
      p(nu,mu)=p(mu,nu)
      ps(mu,nu)=x
      ps(nu,mu)=x
      enddo
      enddo
      
      T1=0.d0
      T2=0.d0
c     print *,t1,t2,igr
      do mu=1,igr
      do nu=1,igr
      t1=t1+p(mu,nu)*s(nu,mu)
      t2=t2+ps(mu,nu)*s(nu,mu)
      enddo
      enddo
c     print *, 'T1,T2', t1,t2,nalf+nb,nalf-nb
      print *,' '
      if(dabs(t1-dfloat(nalf+nb)).lt.0.01d0.and.
     $  dabs(t2-dfloat(nalf-nb)).lt.0.01d0)then
      print *, 'Now correct density and spin density  (Traces=', 
     $    t1,t2,')'
      else 
      print *, 'Irrecoverable case', t1,t2
      stop
      endif
      
      goto 1510



      
      

 
        
      stop  
 1000 stop 1000     
      end 

      SUBROUTINE MPRINT0(H,N,ndim)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION H(NDIM,NDIM)
      parameter (maxat=30)
      common /ia/ia(maxat),kkk,idummy

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
    
      K=8 
   65 FORMAT(1H0,40X,A4/)
      NMIN=1
      NMAX=MIN0(N,K)
   62 FORMAT(1X,I3,4x,8F9.4)
   1  PRINT 61, (I, I=NMIN,NMAX)
   61 FORMAT(10X,8(1X,I3,5X))
      PRINT 64
   64 FORMAT(1X)
      DO 2 I=1,N
      PRINT 62,I,(H(I,J),J=NMIN,NMAX)
   2  CONTINUE
      NMIN=NMIN+8
      K=K+8
      NMAX=MIN0(N,K)
      IF(NMAX.GE.NMIN) GOTO 71
      RETURN
   71 PRINT 63
   63 FORMAT(1X///)
      GO TO 1
      END
              
      SUBROUTINE MPRINT01(H,N,nbas,ndim)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION H(NDIM,NDIM)
      parameter (maxat=30)
      common /ia/ia(maxat),kkk,idummy

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
    
      K=8 
   65 FORMAT(1H0,40X,A4/)
      NMIN=1
      NMAX=MIN0(N,K)
   62 FORMAT(1X,I3,4x,8F9.4)
   1  PRINT 61, (I, I=NMIN,NMAX)
   61 FORMAT(10X,8(1X,I3,5X))
      PRINT 64
   64 FORMAT(1X)
      DO 2 I=1,Nbas
      PRINT 62,I,(H(I,J),J=NMIN,NMAX)
   2  CONTINUE
      NMIN=NMIN+8
      K=K+8
      NMAX=MIN0(N,K)
      IF(NMAX.GE.NMIN) GOTO 71
      RETURN
   71 PRINT 63
   63 FORMAT(1X///)
      GO TO 1
      END
      subroutine distance(ibonds,natoms,ifail)
      implicit real*8(a-h,o-z)
      common iop(45)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      
      parameter (nmax=500)
      parameter (ndeckl=500)
      parameter (maxat=30)
      parameter (maxat1=101)
      parameter (maxp=2000)
      common /lim/ llim(nmax),iulim(nmax)
c     dimension ibe(20)
c     dimension sam(nmax,nmax)
      common /to/to(nmax,nmax)
      dimension pmul(maxat)
      common/r/ sm12(ndeckl,ndeckl),sp12(ndeckl,ndeckl),
     $   strt(ndeckl,ndeckl),ptrt(ndeckl,ndeckl)
     $ , s23(ndeckl),s23m(ndeckl),r(nmax,nmax)
      common /c/ps(nmax,nmax),p(nmax,nmax),c(nmax,nmax)
      dimension p0(nmax,nmax)   
c     dimension ibonds(maxat,maxat),rr(98)
      dimension ibonds(maxat,maxat)
c      dimension clin(nmax**2)
c      equivalence (clin(1),c(1,1))
      dimension h(nmax,nmax)
      common /pointer/na(maxat)     
      common /hold/ihold(nmax),illim(nmax)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(nmax,nmax),t(nmax,nmax),
     $             sat(nmax,nmax,maxat)
      common /ia/iznuc(maxat),kop,megall
c     common /achi/achi(maxat,maxat)

      common /map/imap(maxp),imap2(maxp),ireadp
      common /qat/qat(maxat,2)
      common /ovpop/op(maxat,maxat),totq
      common /lbl/msc(nmax)

      dimension vals(maxat),valp(maxat),vald(maxat),valf(maxat),
     $valtot(maxat),icharge(maxat)
      dimension mocal(4),ilab(40),ilabel(nmax)
      dimension iatgr(maxat),alambda(nmax),iorbs(maxat)
      common /pielekt/ ipiatom(20,maxat),npi(maxat),npiel(maxat),ipi
      dimension ibe(20)
      character*80 name      
      equivalence (ibe(1),name)

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    


      do i=1,natoms
      if(iznuc(i).gt.17)then
      print *,' There is an atom over chlorine -- full input used' 
      ifail=1
      return
      endif
      enddo

      
c     do i=1,natoms
c     do j=1,natoms
c     achi(i,j)=dist(i,j)
c     ibonds(i,j)=0
c     enddo
c     enddo
c     print *,' '
c     print *,' Distance matrix, natoms=',natoms
c     call mprint(achi,natoms, maxat)
c     do i=1,natoms
c     print 661, (achi(i,j),j=1,natoms)
c661  format(10f8.3)
c     enddo
      
c     do i=1,natoms
c     print 61,(ibonds(i,j),j=1,natoms)
c     enddo



      print *,' '
c120     read(*,61,end=121) i,j,ibonds(i,j)
c     if(i.eq.0)goto 121
c     ibonds(j,i)=ibonds(i,j)
c     goto 120
c121  do i=1,natoms-1
c     ia=iznuc(i)
c     do j=i+1,natoms
c     ja=iznuc(j)
c     if(ibonds(i,j).eq.0)then
c     if(dist(i,j).le.rr(ia)+rr(ja))ibonds(i,j)=1
c     ibonds(j,i)=ibonds(i,j)
c     endif
c     enddo
c     enddo


      do i=1,20
      npi(i)=0
      do j=1,natoms
      ipiatom(i,j)=0
      enddo
      enddo
      do i=1,natoms
      npiel(i)=0
      enddo

c     do i=1,20 
c     print *,'1. group ',i
c     print *,(ipiatom(i,j),j=1,natoms)
c     enddo
      

      ipi=0
      do i=1,20
      read(*,61,end=70,err=70) (ipiatom(i,j),j=1,20)
c     print *, 'beolv ',i,'   ',(ipiatom(i,j),j=1,20)
 61   format(20i2) 
      if(ipiatom(i,1).eq.0)goto 70    
      ipi=i
      enddo
  70  print *,' Number of pi groups=', ipi  

c     do i=1,ipi
c     print *,'2.  group ',i
c     print *,(ipiatom(i,j),j=1,natoms)
c     enddo
      
      do i=1,natoms
      npiel(i)=0
      enddo


      do i=1,ipi
      do j=1,natoms
      if(ipiatom(i,j).ne.0)npi(i)=j
      enddo
c     print *,'3.'
c     print 662, (ipiatom(i,j),j=1,npi(i))
      enddo

      if(ipi.eq.0)goto 777

      do i=1,ipi
      do j=1,npi(i)
      nn=ipiatom(i,j)
      npiel(nn)=1
      neighb=0
      do 77 k=1,natoms
      if(k.eq.nn)goto 77
      if(ibonds(k,nn).ne.0)neighb=neighb+1
      do ii=1,npi(i)
      if((k.eq.ipiatom(i,ii).and.k.ne.nn).and.ibonds(k,nn).gt.1)
     $ ibonds(k,nn)=1
      enddo      

  77  continue  
      print *,'nn,iznuc(nn),neighb',nn,iznuc(nn),neighb
      if((iznuc(nn).eq.7.or.iznuc(nn).eq.15).and.neighb.eq.3)
     $ npiel(nn)=2
      if((iznuc(nn).eq.8.or.iznuc(nn).eq.16).and.neighb.eq.2)
     $ npiel(nn)=2
      enddo
      enddo
      print *,' Number of Pi-electrons',(npiel(i),i=1,natoms)
      call flush
  777 continue
      do iat=1,natoms
      icharge(iat)=0
      enddo
      iflag=0
  17  read(17,*,err=333,end=333)iat,icharge(iat)
      print *,' Reference charge of atom',iat,' is',icharge(iat)
      iflag=1
      if(ipi.ne.0)npiel(iat)=npiel(iat)-icharge(iat)
      goto 17
 333  continue
      if(iflag.eq.1.and.ipi.ne.0) 
     $   print *,' Number of Pi-electrons recalc.d'
     $    ,(npiel(i),i=1,natoms)
      icharg=0
      do i=1,natoms
      icharg=icharg+icharge(i)
      enddo
      if(icharg.ne.0) then
      print *, ' Total charge=', icharg         
c     stop 673
      endif



c     do i=1,natoms
c     print *,(ibonds(i,j),j=1,natoms)
c     enddo
     



      do i=1,natoms
c     if(i.eq.3.or.i.eq.4)print *,i,iznuc(i),npiel(i),icharge(i)
      iii=iznuc(i)-npiel(i)-icharge(i)
      do j=1,natoms
      iii=iii-ibonds(i,j)
      enddo
c     if(i.eq.3.or.i.eq.4)print *,i,iii
      ii2=iii/2
      if(iii.eq.2*ii2) then
      ibonds(i,i)=ii2
      else
      print *,' Problem with atom ', i,iii,ii2
      stop 720
      endif
      enddo

      print *,' Topological matrix -- (number of core and lone '
     $, 'pair orbs. in the diagonals)'
      print *,' '
      do i=1,natoms
      print 662, (ibonds(i,j),j=1,natoms)
 662  format(40i2)
      enddo
      print *,' '
      return
      end
