
      subroutine numint
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (PI=3.141592653589793D0)
      PARAMETER (maxp=2000,maxg=1000,maxc=26,maxat=20) 
c     parameter (NMAX=100000)
      parameter (nmax=500)
      parameter (maxpoint=3300*maxat)
      dimension wp(maxpoint),chp(maxpoint,nmax),omp(maxpoint)
      common /stv/ sp(nmax,nmax),tt(nmax,nmax),
     $             sat(nmax,nmax,maxat)
      common /nat/ nat,igr,ifg,idum(4)
      common /c/ps(nmax,nmax),p(nmax,nmax)

      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)
      common /coord/ coord(3,maxat),zn(maxat)
      common /pr/iprint
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)

      common/actual/iact,jat,icenter
      common/pi/pir,pisqrt
      common /hold/ihold(nmax),illim(nmax)
      common /map/imap(maxp),imap2(maxp),ireadp
c     dimension fmu(nmax)
      common /ovpop/op(maxat,maxat),totq
      common /gridp/Nrad,Nang
      
      Pi1=dacos(-1.d0)
      pisqrt=dsqrt(pi)
      iul=ifiul(igr)
      call prepar

      read(60,*,end=111,err=111) nrad,nang
      print *,' '
      print *,' '
      print *,' Radial points: ', nrad
c Possible values for Nang: 6,14,26,38,50,74,86,110,146,170,
c                   194,230,266,302,350,434,590,770,974'
      goto 112
 111  nrad=30
      nang=110
      print *,' Radial points: ', nrad
 112  call quad(Nrad,Nang) 
       
       if(Nrad*Nang*nat.gt.maxpoint) then
       print *, 'Too many points - increase parameter "maxpoint"!'
       stop
       else
       endif        
      
       if(Nrad.gt.100) then
       print *, 'The number of radial points per atom must not ',
     $ 'exceed 100' 
       stop
       else
       endif        
c     print 61, (ihold(i),i=1,igr)
   61 format(20i2)
      iatps=Nang*NRad
       do 700 i=1,igr
      ipoint=1
        iact=i
c       do 700 j=i,igr
c        jact=j  
c        sssat=0.d0 
      do jat=1,nat
          icenter=jat
          call fpoints(ipoint,chp,Nang,NRad)
          ipoint=ipoint+iatps
c          sssat=sssat+sum1
c	  sat(i,j,jat)=sum1
c	  sat(j,i,jat)=sum1
         enddo
c     print *,"Basis f.n-s", i,j,'  Overlap integral ',sssat,sp(i,j)
c     print *,' '
 700   continue
         ipoints=ipoint-1
          print *,' Number of grid points:',ipoints         
          
      ipoint=1
 

          
c       iact=i

           do icenter=1,nat
          call rpoints(ipoint,wp,Nang,NRad)
          ipoint=ipoint+iatps
           enddo
         ipoints=ipoint-1
c        print 611, (wp(i),i=1,ipoints)
 611  format(1x,20(7f10.7/))        
c         print *,' Number of grid points',ipoints         
c         do 1000 icenter=1,nat

      ipoint=1
c       iact=i
           do jat=1,nat
          icenter=jat
          call wpoints(ipoint,omp,Nang,NRad)
          ipoint=ipoint+iatps
           enddo
         ipoints=ipoint-1
c         print *,' Number of grid points',ipoints         
c         enddo
          
          
          do mu=1,igr
          do nu=1,mu
          do icenter=1,nat
           x=0.d0
          do 77 ifut=iatps*(icenter-1)+1,iatps*icenter
 77       x=x+wp(ifut)*chp(ifut,mu)*chp(ifut,nu)*omp(ifut)
          sat(mu,nu,icenter)=x 
          sat(nu,mu,icenter)=x 
c         print *,mu,nu,icenter,x
          enddo
          enddo
          enddo
      
      
      return
      end
      subroutine rpoints(ipoint,wp,N,Nrad)
      IMPLICIT REAL*8(A-H,O-Z)
      parameter (nmax=500)
      PARAMETER (PI=3.141592653589793D0)
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)
      common/actual/iact,jat,icenter
      parameter (maxat=20)
      parameter (maxpoint=3300*maxat)
      dimension wp(maxpoint),chp(maxpoint,nmax),omp(maxpoint)

      irun=ipoint                                                                  
      do k=1,Nrad
        xxr=wr(k)*xr(k)*xr(k)
       do i=1,N
c       sum0=sum0+w(i)*xxr
      wp(irun)=w(i)*xxr*4.d0*Pi
c     chp(irun,iact)=funct(i,k)
      irun=irun+1
      
c        sum1=sum1+funct(i,k)*w(i)*xxr
       enddo
      enddo
c     print *,irun-1
c     sum0=sum0*4.0*PI
c     sum1=sum1*4.0*PI
c     print *,' N, sum:',n,sum0,sum0/pi,sum1,sum1/pi,sum2,sum2/Pi
      
c     print *,' N, Nrad, sum:',n,nrad,sum0/pi,sum1
      
c     stop
      return
      end
      
      subroutine fpoints(ipoint,chp,N,Nrad)
      IMPLICIT REAL*8(A-H,O-Z)
      parameter (nmax=500)
      PARAMETER (PI=3.141592653589793D0)
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)
      common/actual/iact,jat,icenter
      parameter (maxat=20)
      parameter (maxpoint=3300*maxat)
      dimension wp(maxpoint),chp(maxpoint,nmax)

      irun=ipoint                                                                  
      do k=1,Nrad
c       xxr=wr(k)*xr(k)*xr(k)
       do i=1,N
c       sum0=sum0+w(i)*xxr
c     wp(irun)=w(i)*xxr
      chp(irun,iact)=funct(i,k)
      irun=irun+1
      
c        sum1=sum1+funct(i,k)*w(i)*xxr
       enddo
      enddo
c     sum0=sum0*4.0*PI
      sum1=sum1*4.0*PI
c     print *,' N, sum:',n,sum0,sum0/pi,sum1,sum1/pi,sum2,sum2/Pi
      
c     print *,' N, Nrad, sum:',n,nrad,sum0/pi,sum1
      
c     stop
      return
      end
      subroutine wpoints(ipoint,omp,N,Nrad)
      IMPLICIT REAL*8(A-H,O-Z)
      parameter (nmax=500)
      PARAMETER (PI=3.141592653589793D0)
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)
      common/actual/iact,jat,icenter
      parameter (maxat=20)
      parameter (maxpoint=3300*maxat)
      dimension omp(maxpoint)

      irun=ipoint                                                                  
      do k=1,Nrad
c       xxr=wr(k)*xr(k)*xr(k)
       do i=1,N
c       sum0=sum0+w(i)*xxr
c     wp(irun)=w(i)*xxr
      omp(irun)=www(i,k)
      irun=irun+1
      
c        sum1=sum1+funct(i,k)*w(i)*xxr
       enddo
      enddo
c     sum0=sum0*4.0*PI
c     sum1=sum1*4.0*PI
c     print *,' N, sum:',n,sum0,sum0/pi,sum1,sum1/pi,sum2,sum2/Pi
      
c     print *,' N, Nrad, sum:',n,nrad,sum0/pi,sum1
      
c     stop
      return
      end


      function funct(i,k)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (PI=3.141592653589793D0)
      PARAMETER (maxp=2000,maxg=1000,maxc=26,maxat=20) 
c     parameter (NMAX=100000)
      parameter (mgmax=10 000 000)
      parameter (nmax=500)
      common /stv/ sp(nmax,nmax),tt(nmax,nmax),
     $             vv(nmax,nmax,maxat)
      common /nat/ nat,igr,ifg,idum(4)

      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)
      common /coord/ coord(3,maxat),zn(maxat)
      common /hold/ihold(nmax),illim(nmax)
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)

      common/actual/iact,jact,icenter
      common/pi/pir,pisqrt
      
      iactat=ihold(iact)
      f=0.d0
      thx=th(i)
      fix=ph(i)
      rr=xr(k)
c     print *,th,fi,rr,f
      xabs=rr*dsin(thx)*dcos(fix)+coord(1,icenter)
      yabs=rr*dsin(thx)*dsin(fix)+coord(2,icenter)
      zabs=rr*dcos(thx)+coord(3,icenter)
      x=xabs-coord(1,iactat)   
      y=yabs-coord(2,iactat)   
      z=zabs-coord(3,iactat)   
      rr=dsqrt(x**2+y**2+z**2)
      ngri=ifiul(iact)-ifill(iact)+1
      do ki=1,ngri
      ipr=ifill(iact)+ki-1
      nn=n(ipr)
      ll=l(ipr)
      mm=m(ipr)
      f=f+(x**nn)*(y**ll)*(z**mm)*dexp(-expp(ipr)*(rr**2))
     $    *coeff(iact,ki)
c     print *,iact,ki,ipr,expp(ipr),coeff(iact,ki)
      enddo

      funct=f
      
      return
      end
      function www(i,k)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (PI=3.141592653589793D0)
      PARAMETER (maxp=2000,maxg=1000,maxc=26,maxat=20) 
      parameter (nmax=500)
      common /stv/ sp(nmax,nmax),tt(nmax,nmax),
     $             vv(nmax,nmax,maxat)
      common /nat/ nat,igr,ifg,idum(4)

      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)
      common /coord/ coord(3,maxat),zn(maxat)
      common /hold/ihold(nmax),illim(nmax)
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)

      common/actual/iact,jact,icenter
      common/pi/pir,pisqrt
      
      iactat=ihold(iact)
      f=0.d0
      thx=th(i)
      fix=ph(i)
      rr=xr(k)
c     print *,th,fi,rr,f
      xabs=rr*dsin(thx)*dcos(fix)+coord(1,icenter)
      yabs=rr*dsin(thx)*dsin(fix)+coord(2,icenter)
      zabs=rr*dcos(thx)+coord(3,icenter)

      www=wat(icenter,xabs,yabs,zabs)    
      
      return
      end


      
      subroutine prepar
      implicit real*8 (a-h,o-z)
      parameter (maxat=20)
      dimension atrad(92)
      common /atomrad/atr(maxat),dist(maxat,maxat)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      common /coord/ coord(3,maxat),zn(maxat)
      common /ia/iznuc(maxat),kop,megall
      RR(x,y,z)=dsqrt(x**2+y**2+z**2)

C Atomic radii                                
      atrad(1)=.35d0/0.529177

      atrad(3)=1.45d0/0.529177
      atrad(4)=1.05d0/0.529177
      atrad(5)=.85d0/0.529177

      atrad(6)=.7d0/0.529177
      atrad(7)=.65d0/0.529177
      atrad(8)=.6d0/0.529177
      atrad(9)=.9d0/0.529177


      atrad(11)=1.8d0/0.529177
      atrad(12)=1.5d0/0.529177
      atrad(13)=1.25d0/0.529177
      atrad(14)=1.1d0/0.529177
      atrad(15)=1.d0/0.529177
      atrad(16)=1.d0/0.529177
      atrad(17)=1.d0/0.529177
      
                                                                                
      atrad(32)=1.25d0/0.529177
      atrad(33)=1.15d0/0.529177
      atrad(34)=1.15d0/0.529177
      atrad(35)=1.15d0/0.529177
                                                                                
      

      do i=1,nat
      ia=iznuc(i)
      atr(i)=atrad(ia)
      enddo
      
c     print *,'atr/prepar',(atr(i),i=1,nat)
C Atomradiuszokat ertelmesen feltolteni!
      

      do i=1,nat-1
      dist(i,i)=0.d0
      do j=i+1,nat
      dist(i,j)=RR(coord(1,i)-coord(1,j),coord(2,i)-coord(2,j),
     $   coord(3,i)-coord(3,j))
      dist(j,i)=dist(i,j)
      enddo
      enddo
      print *,' '
c     print *,' '
c     print *, "Distance matrix"
      print *,' '
      print *,' '
c     do i=1,nat
c     print *, (dist(i,j),j=1,nat)
c     enddo
c     print *,' '
c     print *,' '
      return
      end
      
