      subroutine fborder(Pa,Pb,S,illim,iulim,natoms,nbasis)
      implicit real*8(a-h,o-z)
      parameter (maxat=20,nmax=500)
      dimension pa(nmax,nmax),pb(nmax,nmax),rindex(maxat,maxat)
      dimension tindex(maxat),diag(maxat),illim(nmax),iulim(nmax)
      dimension pas(nmax,nmax),pbs(nmax,nmax),ps(nmax,nmax)
      dimension s(nmax,nmax) 
      dimension kiir1(4),kiir2(4) 
      common /ia/ia(maxat),kop,idummy 
      common /stv/ sp(nmax,nmax),ttsc(nmax,nmax),
     $             sat(nmax,nmax,maxat)
      dimension tt(nmax,nmax,maxat)
      common /qat/qat(maxat,2)
      integer uli,ulj 

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
       data kiir1/'  AT','OM  ','VALE','NCE '/
       data kiir2/' ATO','M   ','VALE','NCE '/
c
C
c
C    CALCULATING "FUZZY" BOND-ORDER AND VALENCE INDICES  
C          According to: 
C          I. MAYER and P. SALVADOR, Chem. Phys. Lett. 383, 368, 2004
C                   
C  
c
C  Input parameters: Pa: alpha or total electron density matrix;
c                    Pb: beta electron density matrix;
c                    S: Overlap matrix; 
c                    Illim and Iulim: arrays of lower and upper limits of the 
c                                basis orbitals belonging to a given atom;
c                    Natoms: number of the atoms;
c                    Nbasis: number of basis orbitals.
C  
c     Uses also:     qat(maxat,2): an array, the first column of which
c                    contains "fuzzy atom" populations of individual atoms
C  
c       
       print *,' '
c     IF(kop.EQ.0) WRITE (*,62)
c     IF(kop.NE.0) WRITE (*,63)
  62  FORMAT(1X,'CLOSED-SHELL SYSTEM'/)
  63  FORMAT(1X,'OPEN-SHELL SYSTEM'/)
       
C
C
C  COMPUTE THE MATRIX PRODUCTS P*S^A
C
      do iat=1,natoms
      do mu=1,nbasis
      do nu=1,nbasis
      x=0.d0
      do itau=1,nbasis
      x=x+Pa(mu,itau)*sat(itau,nu,iat)
      enddo
      tt(mu,nu,iat)=x
      enddo
      enddo
      enddo

      do iat=1,natoms
      do ibt=iat,natoms
 
      x=0.d0
      do mu=1,nbasis
      do nu=1,nbasis
      x=x+tt(mu,nu,iat)*tt(nu,mu,ibt)
      enddo
      enddo
      rindex(iat,ibt)=x
      rindex(ibt,iat)=x
      enddo
      enddo

      do i=1,natoms
      diag(i)=rindex(i,i)
      rindex(i,i)=0.d0
      enddo
c     print *, 'diag'
c     print *, (diag(i),i=1,natoms)
       
c     CALL Mprint(rindex,NATOMS,maxat)
      if(kop.ne.0)then

      do iat=1,natoms
      do mu=1,nbasis
      do nu=1,nbasis
      x=0.d0
      do itau=1,nbasis
      x=x+Pb(mu,itau)*sat(itau,nu,iat)
      enddo
      tt(mu,nu,iat)=x
      enddo
      enddo
      enddo

      do iat=1,natoms
      do ibt=iat,natoms
 
      x=0.d0
      do mu=1,nbasis
      do nu=1,nbasis
      x=x+tt(mu,nu,iat)*tt(nu,mu,ibt)
      enddo
      enddo
      rindex(iat,ibt)=rindex(iat,ibt)+x
      rindex(ibt,iat)=rindex(iat,ibt)
      enddo
      enddo

      do i=1,natoms
      rindex(i,i)=0.d0
      enddo

c     CALL Mprint(rindex,NATOMS,maxat)
      endif
      WRITE(*,6342)
 6342 FORMAT(1x,/21X,'"FUZZY ATOMS" BOND ORDER MATRIX'//)
      CALL Mprint(rindex,NATOMS,maxat)
C
C CALCULATION OF THE VALENCE NUMBERS
C
      DO 9 I=1,NATOMS
      X=0.D0
      DO 10 J=1,NATOMS
  10  X=X+rindex(I,J)
  9   rindex(I,I)=X
      do i=1,natoms 
      tindex(i)=rindex(i,i)
      enddo
      do i=1,natoms
      diag(i)=2.d0*qat(i,1)-diag(i)
      enddo
      
      kmin1=min0(natoms,5)-1
 123  format(20A4)      
      
c     print *,'kmin1',kmin1

      
      WRITE(*,611)
      write(*,123)(kiir1(j),j=1,4),((kiir2(j),j=1,4),i=1,kmin1)
 640  format(20(I3,A4,F8.5,4(I3,A4,1X,f8.5)/))
 621  FORMAT(//17X,'VALENCES USED IN BONDS (SUM OF BOND ORDERS)'/)
 611  FORMAT(//25X,'"FUZZY ATOMS" TOTAL VALENCES'/)
 612  FORMAT(//30X,'FREE VALENCES',/)
      write(*,640) (I,mend(ia(i)),diag(I),I=1,NATOMS)
      PRINT 621
      write(*,640) (I,mend(ia(i)),tindex(I),I=1,NATOMS)
      do i=1,natoms
      diag(i)=diag(i)-tindex(i)
      enddo
      
      print 612
      print *,' (In the closed shell RHF case should be small:'
     $, ' integration inaccurracy)'
      print *,' '
      write(*,640) (I,mend(ia(i)),diag(I),I=1,NATOMS)
  644 format(1P5G16.6)    
      
      return
      end

