c     
c-------------------------------------------------------------------------------
c
c                    Program FUZZY, Version 1.01
c                   ----------------------------
c
c    Calculating:
c    ------------
c
c      A) Conventional (Hilbert space) bond orders and valences
c         (I. Mayer, Chem. Phys. Lett. 97, 270, 1983....)
c
c      B) Mulliken and "fuzzy atom" populations
c
c      C) "Fuzzy atoms" bond orders and valences
c         (I. Mayer and P. Salvador, Chem. Phys. Lett. 383, 368, 2004)
c
c    Cite this program as:
c   ---------------------
c  I. Mayer and P. Salvador, Program "FUZZY", Version 1.01, Girona, Ocober 2003.
c  (Revision: Budapest, August 2004.)
c-------------------------------------------------------------------------------
C  The program has been written by using parts of the pprogram APOST by
c  I. Mayer and A. Hamza, Budapest, 2000-2003.
c      
c
c  The numerical integration utilizes the subroutines for Lebedev
C  quadrature downloaded from CCL. The appropriate reference is:
c      
c V.I. Lebedev, and D.N. Laikov, Doklady Mathematics, {\bf 59}, No. 3, 477 
c (1999)
c
c  We are extremely grateful for the possibility of using these routines!  
c       
c                     
c          e-mails: mayer@chemres.hu, pedro.salvador@udg.es 
c
c ------------------------------------------------------------------------
c
c

      implicit real*8(a-h,o-z)
      common iop(45)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      
      parameter (nmax=500)
      parameter (maxat=20)
      parameter (maxat1=101)
      parameter (maxp=2000)
      common /lim/ llim(nmax),iulim(nmax)
      dimension ibe(20)
c     dimension sam(nmax,nmax)
      dimension h(nmax,nmax)
      dimension pmul(maxat)
      common /c/ps(nmax,nmax),p(nmax,nmax)
      common /opensh/ cb(nmax,nmax)   
      dimension clin(nmax**2)
      equivalence (clin(1),cb(1,1))
      common /pointer/na(maxat)     
      common /hold/ihold(nmax),illim(nmax)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(nmax,nmax),t(nmax,nmax),
     $             sat(nmax,nmax,maxat)
      common /ia/iznuc(maxat),kop,megall
      common /achi/achi(maxat,maxat)

      common /map/imap(maxp),imap2(maxp),ireadp
      common /qat/qat(maxat,2)
      common /ovpop/op(maxat,maxat),totq

      dimension mocal(4)
      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    


      data itot  /'Tota'/
      data ispin  /'Spin'/
      data irohf1 /'  RO'/
      data irohf2 /'HF  '/
      data mocal /'Alph','a MO',' coe','ffic'/

      

      call kiir
      call start
 

      
      m=igr

      call getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      if(nat.ne.natoms) stop 7584
      if(m.ne.nbas) stop 7585
      
      call getsome(nmax,nbas,natoms,h)

      call denstest
      
      call inpint(natoms,llim,iulim)
      call numint
      if(ireadp.eq.1) call ordersat(nmax,nbas,natoms,h)
  
       tc1=0.d0
       tc2=0.d0
       do kat=1,nat
       x=0.d0
       do mu=1,igr
       do nu=1,igr
       x=x+p(mu,nu)*sat(mu,nu,kat)
       enddo
       enddo
       qat(kat,1)=x
       qat(kat,2)=0.d0
       enddo

       do mu=1,igr
       kat=ihold(mu)
       x=0.d0
       do itau=1,igr
       x=x+p(mu,itau)*s(itau,mu)
       enddo
       qat(kat,2)=qat(kat,2)+x
       enddo
       
      if(iuhf.ne.0)kop=1

      call border(P,ps,S,llim,iulim,natoms,nbas)
      call opop
c       call fborder(p,p,s,llim,iulim,nat,igr)
       print *,' '
       print *,' '
       Print 666
 666  FORMAT(1H ,4X,'"FUZZY ATOMS" POPULATIONS, BOND ORDERS AND' 
     $ ,' VALENCE INDICES ',/
     $ '     ACCORDING TO I. MAYER and P. SALVADOR, CPL 383, 368, 2004')
      print *,' '
      print *,' '
c       print 667
      print *,'          "FUZZY ATOMS" OVERLAP POPULATION MATRIX'
      print *,' '
      call mprint(op,natoms,maxat)
      totq=dfloat(nalf+nb)-totq
      print *,'  '
      print 163,totq
 163  format(1x,' (Deviation from symmetry, if any: integration',
     $ ' inaccurracy)'
     $,/, '  Num. integration control (should be small):', f12.6)       
      print *,'  '
      print *,'  '
      print *,'    ELECTRON POPULATIONS'
      print *,'  '
      print *,'  Atom   "Fuzzy"   Mulliken'
      print *,' -----------------------------'
      do i=1,nat
      tc1=tc1+qat(i,1)
      tc2=tc2+qat(i,2)
      print 161, i,mend(iznuc(i)),qat(i,1),qat(i,2)
 161  format(1x,i3,A4,2f10.6)      
      enddo
      print *,' -----------------------------'
      print 162, tc1, tc2
 162  format(1x,'  Sum  ',2f10.6)  
      print *,'  '
      print *,'  '
      print *,'    TOTAL ATOMIC CHARGES    '
      print *,'  '
      print *,'  Atom   "Fuzzy"   Mulliken'
      print *,' -----------------------------'
      tc1=0.d0
      tc2=0.d0
      do i=1,nat
      tc1=tc1-qat(i,1)+dfloat(iznuc(i))
      tc2=tc2-qat(i,2)+dfloat(iznuc(i))
      print 161, i,mend(iznuc(i)),dfloat(iznuc(i))-qat(i,1),
     $    dfloat(iznuc(i))-qat(i,2)
      enddo
      print *,' -----------------------------'
      print 162, tc1, tc2
      print *,'  '
      print *,'  '
 667  format(1x,79(1h-))       
        
      call fborder(p,ps,s,llim,iulim,nat,igr)
c       call border(p,p,sp,llim,iulim,nat,igr)
      stop




      
      

 
        
      stop  
 1000 stop 1000     
      end 

      subroutine getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      implicit real*8(a-h,o-z)
      dimension llim(nmax),iulim(nmax),na(maxat)
      NATOMS=0
      NBAS=0
      DO 3 I=1,nmax
      IF(iulim(I).GT.0) NATOMS=I
  3   NBAS=iulim(natoms)
       if(natoms.gt.maxat)then
      write(*,*)'   TOO MANY ATOMS, STOP'
      stop
       endif
      if(natoms.eq.1) then
      write(*,*)'  ONLY ONE ATOM'
      stop  
      endif
      nnn=0
      do 4 i=1,natoms
      na(i)=iulim(i)-llim(i)+1
  4   nnn=nnn+na(i)
      if(nnn.ne.nbas)stop 1212
      nnab=(natoms*(natoms-1))/2
      if(nnab*2.ne.natoms*(natoms-1))stop 1213

      print *,'   '
      write(*,*)natoms,' ATOMS, ',nnab,' ATOMIC PAIRS'
      
      end

      subroutine getsome(ndeckl,nbas,natoms,h)
      implicit real*8(a-h,o-z)
      parameter (maxat=20)
      parameter (nmax=500) 
      parameter (maxp=2000)
      common /stv/ s(nmax,nmax),t(nmax,nmax),
     $   vv(nmax,nmax,maxat)   
      common /c/ps(nmax,nmax),p(nmax,nmax)
      dimension h(nmax,nmax)
      common /map/imap(maxp),imap2(maxp),ireadp
      m=nbas
       do 121 j=1,m
       jj=imap(j)
       do 121 i=1,m
        ii=imap(i)
  121  h(jj,ii)=s(j,i)
       do 131 i=1,m
       do 131 j=1,m
  131  s(j,i)=h(j,i)
       
       return
       end

      subroutine pm(c,nocc,m,p,ndeckl)  
      implicit real*8(a-h,o-z)
      dimension c(ndeckl,ndeckl),p(ndeckl,ndeckl)
       do 1 i=1,m
       do 1 j=1,m
       x=0.d0
       do 2 k=1,nocc
  2     x=x+c(i,k)*c(j,k)
  1    p(i,j)=2.d0*x

  61  format(1x,8f9.7)

       return
       end

      subroutine inpint(natoms,llim,iulim)
      IMPLICIT REAL*8 (A-H,O-Z)
      
      parameter (maxat=20)
      parameter (nmax=500)
c     dimension g(mgmax)
      dimension llim(nmax),iulim(nmax)
      common /pointer/na(maxat)     
      common /hold/ihold(nmax),illim(nmax)
      common /nat/ nat,igr,ifg,idum3(4)
      common iop(45)
     
      do i=1,natoms
      do mu=llim(i),iulim(i)
      ihold(mu)=i
      enddo
      enddo
   61 format(20i2)

      do i=1,natoms
      illim(i)=llim(i)
      enddo

c     call gamgen
c     do i=1,Natoms
c     call shellat(i,igr,natoms)
c     if(iop(7).ne.0)call unconat(i)
c     enddo
      
      return      
      end


      SUBROUTINE MPRINT(H,N,ndim)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION H(NDIM,NDIM)
      parameter (maxat=20)
      common /ia/ia(maxat),kkk,idummy

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
    
      K=8 
   65 FORMAT(1H0,40X,A4/)
      NMIN=1
      NMAX=MIN0(N,K)
   62 FORMAT(1X,I3,A4,8F9.4)
   1  PRINT 61, (I, mend(ia(i)),I=NMIN,NMAX)
   61 FORMAT(10X,8(1X,I3,A4,1X))
      PRINT 64
   64 FORMAT(1X)
      DO 2 I=1,N
      PRINT 62,I,mend(ia(i)),(H(I,J),J=NMIN,NMAX)
   2  CONTINUE
      NMIN=NMIN+8
      K=K+8
      NMAX=MIN0(N,K)
      IF(NMAX.GE.NMIN) GOTO 71
      RETURN
   71 PRINT 63
   63 FORMAT(1X///)
      GO TO 1
      END

      subroutine kiir
      implicit real*8(a-h,o-z)
      write(*,6670)
      write(*,6661)
 6661 format(/20x,'Program FUZZY, Version 1.01')
      write(*,6662)
 6662 format(20x,28(1h-),/)
      write(*,6663)
      write(*,6660)
 6663 format(3x,'Calculating:')
 6660 format(3x,'------------',/)
      write(*,6664)
 6664 format(5x,2hA),' Conventional (Hilbert space) bond orders and'
     $ , ' valences'/'        (I. Mayer, Chem. Phys.'
     $,'Lett. 97, 270, 1983....)',/)
      write(*,6665)
 6665 format(5x,2hB),' Mulliken and "fuzzy atom" populations'/)
      write(*,6545)
 6545 format(5x,2hC),' "Fuzzy atoms" bond orders and valences'/,
     $  '        (I. Mayer and P. Salvador, CPL 383, 368, 2004',/) 
 6666 format(3x,'for a wave function obtained in a Gaussian ',
     $ 'calculation (G92, G94, G98, ...?)',//)
      write(*,6667)
      write(*,6668)
      write(*,6669)
 6667 format(2x,' Cite this program as:')
 6668 format(2x,' ---------------------')
 6669 format(' I. Mayer and P. Salvador, Program "FUZZY", Version 1.01,'
     $ ,' Girona, Ocober 2003/Budapest, August 2004.',/)
 6670 format(1x,79(1h-))
      write(*,6670)
      end

      subroutine ordersat(ndeckl,nbas,natoms,h)
      implicit real*8(a-h,o-z)
      parameter (maxat=20)
      parameter (nmax=500) 
      parameter (maxp=2000)
      common /stv/ s(nmax,nmax),t(nmax,nmax),
     $   sat(nmax,nmax,maxat)   
      common /c/ps(nmax,nmax),p(nmax,nmax)
      dimension h(nmax,nmax)
      common /map/imap(maxp),imap2(maxp),ireadp
      m=nbas
c     print *, 'Ordersat'
c     print *,(imap2(i),i=1,nbas)
       do 1 kat=1,natoms
       do 121 j=1,m
       jj=imap2(j)
       do 121 i=1,m
        ii=imap2(i)
  121  h(jj,ii)=sat(j,i,kat)
       do 131 i=1,m
       do 131 j=1,m
  131  sat(j,i,kat)=h(j,i)
    1  continue 
       return
       end


      subroutine opop
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (PI=3.141592653589793D0)
      PARAMETER (maxp=2000,maxg=1000,maxc=26,maxat=20) 
c     parameter (NMAX=100000)
      parameter (nmax=500)
      parameter (maxpoint=3300*maxat)
      common /stv/ sp(nmax,nmax),tt(nmax,nmax),
     $             sat(nmax,nmax,maxat)
      common /nat/ nat,igr,ifg,idum(4)
      common /c/ps(nmax,nmax),p(nmax,nmax)

      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /pr/iprint
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)

      common/actual/iact,jat,icenter
      common/pi/pir,pisqrt
      common /hold/ihold(nmax),illim(nmax)
      common /map/imap(maxp),imap2(maxp),ireadp
      dimension fmu(nmax)
      common /ovpop/op(maxat,maxat),totq
      common /gridp/Nrad,Nang
       do i=1,nat
       do j=1,nat
       op(j,i)=0.d0
       enddo
       enddo
       
      
          totq=0.d0
          do 500 iatom=1,nat
          icenter=iatom
c         do 500 jatom=1,nat
c         jcenter=jatom
      do 510 k=1,Nrad
        xxr=wr(k)*xr(k)*xr(k)
       do 510 i=1,Nang
c         sss=0.d0
      wt=w(i)*xxr*4.d0*Pi

      f=0.d0
      thx=th(i)
      fix=ph(i)
      rr=xr(k)
c     print *,th,fi,rr,f

      xabs=rr*dsin(thx)*dcos(fix)+coord(1,icenter)
      yabs=rr*dsin(thx)*dsin(fix)+coord(2,icenter)
      zabs=rr*dcos(thx)+coord(3,icenter)

      do mu=1,igr

       iactat=ihold(mu)
      
      x=xabs-coord(1,iactat)   
      y=yabs-coord(2,iactat)   
      z=zabs-coord(3,iactat)   
      rr=dsqrt(x**2+y**2+z**2)
      
      f=0.d0
      ngri=ifiul(mu)-ifill(mu)+1
      do ki=1,ngri
      ipr=ifill(mu)+ki-1
      nn=n(ipr)
      ll=l(ipr)
      mm=m(ipr)
      f=f+(x**nn)*(y**ll)*(z**mm)*dexp(-expp(ipr)*(rr**2))
     $    *coeff(mu,ki)
      enddo
      fmu(imap(mu))=f
      enddo
      q=0.d0
      do mu=1,igr
      do nu=mu,igr
      z=P(mu,nu)*fmu(mu)*fmu(nu)
      q=q+z
      if(mu.ne.nu)q=q+z
      
      enddo
      enddo

c     rho(k)=q

      wt=wt*wat(icenter,xabs,yabs,zabs)
          do 501 jatom=1,nat
          jcenter=jatom
      wtj=wt*wat(jcenter,xabs,yabs,zabs)
      sss=q*wtj



          
      op(iatom,jatom)=op(iatom,jatom)+sss
      totq=totq+sss
 501  continue
 510  continue
c     print *, iatom,jatom,sss    
 500  continue         
c     print *, totq
          
c      do  iatom=1,nat-1
c      do  jatom=iatom,nat
c      tttx=(op(iatom,jatom)+op(jatom,iatom))/2.d0
c      op(iatom,jatom)=tttx
c      op(jatom,iatom)=tttx
c      enddo
c      enddo


      return
      end

      
      
      subroutine denstest
      implicit real*8(a-h,o-z)
      common iop(45)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      
      parameter (nmax=500)
      parameter (maxat=20)
      parameter (maxat1=101)
      parameter (maxp=2000)
      common /lim/ llim(nmax),iulim(nmax)
      dimension ibe(20)
c     dimension sam(nmax,nmax)
      dimension h(nmax,nmax)
      dimension pmul(maxat)
      common /c/ps(nmax,nmax),p(nmax,nmax)
      common /opensh/ cb(nmax,nmax)   
      dimension clin(nmax**2)
      equivalence (clin(1),cb(1,1))
      common /pointer/na(maxat)     
      common /hold/ihold(nmax),illim(nmax)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(nmax,nmax),t(nmax,nmax),
     $             sat(nmax,nmax,maxat)
      common /ia/iznuc(maxat),kop,megall
      common /achi/achi(maxat,maxat)

      common /map/imap(maxp),imap2(maxp),ireadp
      common /qat/qat(maxat,2)
      common /ovpop/op(maxat,maxat),totq

      dimension mocal(4)
    


      data itot  /'Tota'/
      data ispin  /'Spin'/
      data irohf1 /'  RO'/
      data irohf2 /'HF  '/
      data mocal /'Alph','a MO',' coe','ffic'/

      

 

      
      m=igr
      nbas=igr

c     call getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
c     if(nat.ne.natoms) stop 7584
c     if(m.ne.nbas) stop 7585
      
c     call getsome(nmax,nbas,natoms,h)

c     print *,' Checking the number of electrons'
       tc1=0.d0
       do mu=1,igr
c      kat=ihold(mu)
       x=0.d0
       do itau=1,igr
       x=x+p(mu,itau)*s(itau,mu)
       enddo
c      qat(kat,2)=qat(kat,2)+x
       tc1=tc1+x
       enddo

c      print *,'when calc',(qat(i,2),i=1,natoms)

c            print *,tc1,nalf,nb,nalf+nb
       if(dabs(tc1-dfloat(nalf+nb)).gt.0.1d0)then
      print *,' '
      Print *,' WRONG DENSITY  (Trace of DS=', tc1,')'
      rewind 15
      ntriang=(igr*(igr+1))/2
c     print *,' Ntriang',ntriang
      ndens=-1
 200  read(15,150,end=211)(ibe(i),i=1,4)
 150  format(20a4) 
      if(ibe(1).eq.itot)ndens=ndens+1
      goto 200
 211  rewind 15
 212  read(15,150,end=1711)(ibe(i),i=1,4)
      if(ibe(3).eq.irohf1.and.ibe(4).eq.irohf2)then 
      print *,' '
      Print *,' ROHF case'
      goto 2000
      else
      goto 212
      endif
 1711 print *, 'Different data order. Rereading the',  
     $   ndens,'-d/th density of the checkpoint file'   
      ncou=-1
      rewind 15
 220  read(15,150)(ibe(i),i=1,4)
      if(ibe(1).eq.itot)ncou=ncou+1
      if(ncou.eq.ndens) then
      read(15,*)(clin(i),i=1,ntriang)
c     print *, (clin(i),i=1,ntriang)
      goto 230
      else
      endif        
      goto 220

 230   ncou=1
      do j=1,i
      do i=j,igr
      p(i,j)=clin(ncou)
      p(j,i)=clin(ncou)
      ncou=ncou+1
      enddo
      enddo
      
      else
      endif


       tc1=0.d0
       do mu=1,igr
c      kat=ihold(mu)
       x=0.d0
       do itau=1,igr
       x=x+p(mu,itau)*s(itau,mu)
       enddo
c      qat(kat,2)=qat(kat,2)+x
       tc1=tc1+x
       enddo

c      print *,'when calc',(qat(i,2),i=1,natoms)

c              print *,tc1,nalf,nb,nalf+nb
       if(dabs(tc1-dfloat(nalf+nb)).gt.0.1d0)then
      Print *,' *** ', tc1
      print *,' WRONG DENSITY.  STOP. '
      STOP
      endif

      
c     do i=1,igr
c     print *,(p(i,j),j=1,i)
c     enddo
       
c     call pm(c,nocc,nbas,p,nmax)
c     print *,'after calling PM'
c     do i=1,igr
c     print 6230,(p(i,j),j=1,i)
c     enddo
c6230 format(5f10.5)    

      if(nalf.ne.nb)then
c      print *,' Checking the spin norm'
       tc1=0.d0
       do mu=1,igr
       x=0.d0
       do itau=1,igr
       x=x+ps(mu,itau)*s(itau,mu)
       enddo
       tc1=tc1+x
       enddo

c      print *,'when calc',(qat(i,2),i=1,natoms)

c             print *,tc1,nalf,nb,nalf-nb

      if(dabs(tc1-dfloat(nalf-nb)).gt.0.01d0)then
               
      rewind 15
      ntriang=(igr*(igr+1))/2
      print *,' Ntriang',ntriang
      nsdens=0
 1200 read(15,150,end=1211)(ibe(i),i=1,4)
 1150 format(20a4) 
      if(ibe(1).eq.ispin)nsdens=ndens+1
      goto 1200
 1211 if(nsdens.eq.0) goto 1500
      print *, 'Different data order. Rereading the',  
     $   nsdens,'-d/th s.density of the checkpoint file'   
      ncou=-1
      rewind 15
 1220 read(15,150)(ibe(i),i=1,4)
      if(ibe(1).eq.ispin)ncou=ncou+1
      if(ncou.eq.nsdens) then
      read(15,*)(clin(i),i=1,ntriang)
      goto 1230
      else
      endif        
      goto 1220

 1230 ncou=1
      do j=1,igr
      do i=j,igr
      ps(i,j)=clin(ncou)
      ps(j,i)=clin(ncou)
      ncou=ncou+1
      enddo
      enddo
      
      endif        
      endif
      goto 1510 
 1500 print *, ' No spin-density is present in the checkpoint file'      
      print *, ' In the ROHF case can be constructed '
      print *, ' In CAS (etc?) - not '
      stop
       
c       tc1=0.d0
c       do mu=1,igr
c       kat=ihold(mu)
c       x=0.d0
c       do itau=1,igr
c       x=x+p(mu,itau)*s(itau,mu)
c       enddo
c       qat(kat,2)=qat(kat,2)+x
c       tc1=tc1+x
c       enddo
cc      print *,'before calling border',(qat(i,2),i=1,natoms)

 1510  return    
  
       

 2000 print *,'Density and spin-density will be re-built by using' 
     $ ,  ' the MO-s'


       rewind 15
 146  read(15,150,end=1000)(ibe(i),i=1,4)

      if(ibe(1).eq.mocal(1).and.ibe(2).eq.mocal(2).
     $ and.ibe(3).eq.mocal(3).and.ibe(4).eq.mocal(4)) then
      read(15,*,err=2003)((cb(i,j),i=1,nbas),j=1,nbas)
 2003 continue    
      else 
      goto 146
      endif
        
      do mu=1,igr
      do nu=1,mu
      x=0.d0
      do i=1,nb
      x=x+cb(mu,i)*cb(nu,i)
      enddo
      p(mu,nu)=2.d0*x
      x=0.d0
      do i=nb+1,nalf
      x=x+cb(mu,i)*cb(nu,i)
      enddo
      p(mu,nu)=p(mu,nu)+x
      p(nu,mu)=p(mu,nu)
      ps(mu,nu)=x
      ps(nu,mu)=x
      enddo
      enddo
      
      T1=0.d0
      T2=0.d0
c     print *,t1,t2,igr
      do mu=1,igr
      do nu=1,igr
      t1=t1+p(mu,nu)*s(nu,mu)
      t2=t2+ps(mu,nu)*s(nu,mu)
      enddo
      enddo
c     print *, 'T1,T2', t1,t2,nalf+nb,nalf-nb
      print *,' '
      if(dabs(t1-dfloat(nalf+nb)).lt.0.01d0.and.
     $  dabs(t2-dfloat(nalf-nb)).lt.0.01d0)then
      print *, 'Now correct density and spin density  (Traces=', 
     $    t1,t2,')'
      else 
      print *, 'Irrecoverable case', t1,t2
      stop
      endif
      
      goto 1510



      
      

 
        
      stop  
 1000 stop 1000     
      end 

              
