c     
c                        Program ENPART, Version 1.0
c                        ---------------------------
c
c                                I. Mayer 
c            Chemical Research Center, Hungarian Academy of Sciences
c                    H-1515 Budapest, P.O.Box 17, Hungary
c
c                          e-mail: mayer@chemres.hu
c
c ------------------------------------------------------------------------
c
c   This program performs *a posteriori* analysis of the single determinant 
c   Hartree-Fock ab initio wave wave functions produced by the widely used 
c   "Gaussian" system G92, G94, G98, G03. (For DFT-type wave functions
c   - actulally only B3LYP - the HF-like energy of the single determinant built 
c   up of the Kohn-Sham orbitals can be considered.) 
c
c  The analyses performed:
c
c  A) Bond order and valence analysis (I. Mayer, Chem. Phys. Lett. 97, 270 
c     1983; addendum for open shells: Chem. Phys. Lett. 117, 396, 1985, etc.;
c     for a recent survey see I. Mayer, J. Comp. Chem. 28, 204, 2007);
c
c  B) Decompositions of the molecular energy into one- and diatomic energy 
c     components described in detail in I. Mayer, Phys.Chem.Chem.Phys 8, 4630
c     (2006). The decompositions denoted "E1-type" and "E2-type" differ in the
c     treatment of the kinetic energy integrals. (Also, the decompositions
c     of the two-electron Coulomb and exchange energies are printed.)  
c
c     The decomposition of "E2-type" [it was first introduced in I. Mayer,
c     Chem. Phys. Lett. 382, 265 (2003)]  gives rather "chemical" values
c     of the energy components at the equilibrium geometries but must not
c     be used at other ones. Decomposition "E1" is more "physical" in
c     that sense. For a discussion of this point see I. Mayer, Faraday 
c     Discussions 135, 439 (2007).
c 
c  
c  The program uses parts of the APOST program by I. Mayer and A. Hamza
c  
c
      implicit real*8(a-h,o-z)
      common iop(45)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      
      parameter (nmax=500)
      parameter (maxat=100)
      parameter (maxat1=101)
      parameter (maxp=2000)
      parameter (ndeckl=500)
      parameter (mmax=5 000 000)
c     parameter (mgmax= 5 000 000)
      common /lim/ llim(nmax),iulim(nmax)
c     common /large/aa(mmax),z(mmax),gt(mgmax)  
c     common /large/aa(mmax),z(mmax)
      common /large/z(mmax)
      dimension sam(ndeckl,ndeckl)
c     dimension ea(maxat),eab(maxat,maxat),h(ndeckl,ndeckl)
      dimension h(ndeckl,ndeckl)
c     dimension epoint(maxat,maxat),epent(maxat,maxat),exch(maxat,maxat)
c     dimension efin(maxat,maxat),eover(maxat,maxat)   
c     dimension elect(maxat,maxat),eaa(maxat,maxat), et(maxat,maxat)
c     dimension pmul(maxat)
      common /c/c(ndeckl,ndeckl),p(ndeckl,ndeckl)
      common /pointer/ipoint(maxat),ijpoint(maxat,maxat),na(maxat)     
      common /coord/ coord(3,maxat),zn(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(ndeckl,ndeckl),t(ndeckl,ndeckl),
     $             vv(ndeckl,ndeckl,maxat)
      common /ia/iznuc(maxat),kop,megall

      common/comp/ecomp1(maxat,maxat),coul(maxat,maxat),
     $ exch1(maxat,maxat)
      common /map/imap(maxp),imapsav(maxp)
      dimension ee1(maxat,maxat),ee2(maxat,maxat)

c     data bohr/0.52917715D+00/
c     data bohr/0.52917706D+00/

      call kiir
      call start
 
      oneel=0.d0
      bsse=0.d0

      m=igr


      call getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      if(nat.ne.natoms) stop 7584
      if(m.ne.nbas) stop 7585
      nlength=natoms*nbas**2           
      if(nlength.gt.mmax)then
      write(*,*) nlength,' WORDS ARE REQUIRED FOR THE MATRIX Z'
      write(*,*) ' AVAILABLE ONLY:', mmax, '--  STOP'
      stop
      endif

      ng=0
      do i=1,natoms
      ipoint(i)=ng+1
      ng=ng+na(i)**4
      enddo
      ijpoint(1,2)=ng+1
      maxx=0
      do i=1,natoms-1
      do j=i+1,natoms
      maxx=max0(maxx,na(i)+na(j))
      enddo
      enddo
      ng=ng+maxx**4
c     if(ng.gt.mgmax)then
c     write(*,*) ng,' WORDS ARE REQUIRED FOR THE MATRIX G'
c     write(*,*) ' AVAILABLE ONLY:', mgmax, '--  STOP'
c     stop
c     endif

      
      call getcore(z,ndeckl,nbas,natoms,h)

      if(iuhf.eq.1) then
      print *, 'The present version is for closed shell case only!'
c      call enpo(na,ipoint,ijpoint) 
      stop
      endif

      call pm(c,nocc,nbas,p,ndeckl)
      call border(P,sam,S,llim,iulim,natoms,nbas)

      if(iop(7).eq.2)then
      print *,' '
      print *,' '
      print *,' '
      print *,' '
      print *,'The present program does not perform energy', 
     $ ' partitioning',
     $ ' for F (G...) orbitals'
      print *,' '
      print *,'          PROGRAM STOPS'
      stop 4359
      endif

      print *,'   '
      print 688
 688  format(80(1h-))
      print *,'   '
      nnab=(natoms*(natoms-1)/2)
      write(*,*)natoms,' ATOMS, ',nnab,' ATOMIC PAIRS'
c     call inpint(mgmax,natoms,llim,iulim)
      call inpint(natoms,llim,iulim)


      do i=1,natoms
      do j=1,natoms
      coul(i,j)=0.d0
      exch1(i,j)=0.d0
      enddo
      enddo

C Innen uj
c     ekin=0.d0
c     do mu=1,m
c     do nu=1,m
c     ekin=ekin+p(mu,nu)*t(nu,mu)
c     enddo
c     enddo
c     print *,' Kinet. energy=',ekin
 

      do i=1,natoms
      x=0.d0
      do mu=llim(i),iulim(i)
      do nu=1,m
      x=x+p(mu,nu)*t(nu,mu) 
      enddo
      enddo
      ee1(i,i)=x
      enddo

      
c     Print *,' EE1, kinetic energy'
c     call mprint(ee1,natoms,maxat)


      do i=1,natoms
      x=0.d0
      do mu=llim(i),iulim(i)
      do nu=llim(i),iulim(i)
      x=x+p(mu,nu)*t(nu,mu)
      enddo
      enddo
      ee2(i,i)=x
      enddo

      
      do i=1,natoms-1
      do j=i+1,natoms
      x=0.d0
      do mu=llim(i),iulim(i)
      do nu=llim(j),iulim(j)
      x=x+p(mu,nu)*t(nu,mu)
      enddo
      enddo
      ee2(i,j)=2.d0*x
      ee2(j,i)=2.d0*x
      enddo
      enddo


c     Print *,' EE2, kinetic energy'
c     call mprint(ee2,natoms,maxat)

c Betesszuk h-ba a teljes core-t:
 
c      do mu=1,m
c      do nu=1,m
c      h(mu,nu)=t(mu,nu)
c      do i=1,maxat
c      h(mu,nu)=h(mu,nu)+vv(mu,nu,i)
c      enddo
c      enddo
c      enddo

c     x=0.d0
c     do mu=1,m
c     do nu=1,m
c     x=x+p(mu,nu)*h(nu,mu)
c     enddo
c     enddo

c     print *, ' Total one-electron energy=',x
      
c     oneelc=ekin

      do i=1,natoms
      x=0.d0
      do mu=llim(i),iulim(i)
      do nu=1,m
      x=x+p(mu,nu)*vv(nu,mu,i) 
      enddo
      enddo
      ee1(i,i)=ee1(i,i)+x
      ee2(i,i)=ee2(i,i)+x
c     oneelc=oneelc+x
      enddo

      enuc=0.d0

      do i=1,natoms-1
      do j=i+1,natoms
 
      rij=dsqrt((coord(1,i)-coord(1,j))**2+(coord(2,i)-coord(2,j))**2
     $ +(coord(3,i)-coord(3,j))**2)

      y=zn(i)*zn(j)/rij      
      enuc=enuc+y
      x=0.d0
      do mu=llim(i),iulim(i)
      do nu=1,m
      x=x+p(mu,nu)*vv(nu,mu,j)
      enddo
      enddo
       
      do mu=llim(j),iulim(j)
      do nu=1,m
      x=x+p(mu,nu)*vv(nu,mu,i)
      enddo
      enddo

c     oneelc=oneelc+x
      x=x+y
      ee1(i,j)=ee1(i,j)+x
      ee1(j,i)=ee1(j,i)+x


      ee2(i,j)=ee2(i,j)+x
      ee2(j,i)=ee2(j,i)+x

      enddo
      enddo



c     Print *,' EE1, nuc-nuc+one-el. energy'
c     call mprint(ee1,natoms,maxat)
   
c     Print *,' EE2, nuc-nuc+one-el. energy'
c     call mprint(ee2,natoms,maxat)
c     print *,' One-el. contr.=',oneelc
      print *, ' ' 
      print *,' Nuclear energy=',enuc
      
      do i=1,natoms
      do j=1,natoms
      ecomp1(i,j)=0.d0
      enddo
      enddo


c     z1=0.d0
c     z2=0.d0
c     do i=1,natoms
c     do j=i,natoms
c     z1=z1+ee1(i,j)
c     z2=z2+ee2(i,j)
c     enddo
c     enddo
c     print *, ' z1,z2',z1,z2

      call shellgen(igr,natoms)
      if(iop(7).ne.0)call uncongen
   
      do i=1,natoms
      do j=i,natoms
      coul(j,i)=coul(i,j)
      exch1(j,i)=exch1(i,j)
      enddo
      enddo

      
      print *,' ' 
      print *,' Coulomb two-el'
      call mprint(coul,natoms,maxat)
      print *,' ' 
      print *,' Hartree-Fock exchange '
      call mprint(exch1,natoms,maxat)
     
      do i=1,natoms
      do j=i,natoms
      ecomp1(i,j)=ecomp1(i,j)+coul(i,j)+exch1(i,j)
      enddo
      enddo

c     z0=0.d0
c     do i=1,natoms-1
c     do j=i+1,natoms
c     z0=z0+ecomp1(i,j)
c      enddo
c      enddo
c     print *,' z0=',z0
 
      do i=1,natoms
      do j=i,natoms
      ee1(i,j)=ee1(i,j)+ecomp1(i,j)
      ee1(j,i)=ee1(i,j)
      ee2(i,j)=ee2(i,j)+ecomp1(i,j)
      ee2(j,i)=ee2(i,j)
      enddo
      enddo

c     z1=0.d0
c     do i=1,natoms-1
c     do j=i+1,natoms
c     z1=z1+ee1(i,j)
c      enddo
c      enddo
c     print *,' z1=',z1
 
      print *, ' ' 
      print *,' E1-type energy decomposition'
      call mprint(ee1,natoms,maxat) 


      print *, ' ' 
      print *,' E2-type energy decomposition'
      call mprint(ee2,natoms,maxat) 

      x=0.d0
      y=0.d0
      do i=1,natoms
      do j=i,natoms
      x=x+ee1(i,j)
      y=y+ee2(i,j)
      enddo
      enddo

      do i=1,natoms
      do j=1,natoms
      ecomp1(i,j)=0.d0
      enddo
      enddo

      print *,' Total energy',x,y
c Idaig uj
      stop







      end 

      subroutine getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      implicit real*8(a-h,o-z)
      parameter (n128=500)
      dimension llim(n128),iulim(n128),na(maxat)
      NATOMS=0
      NBAS=0
      DO 3 I=1,n128
      IF(iulim(I).GT.0) NATOMS=I
  3   NBAS=iulim(natoms)
       if(natoms.gt.maxat)then
      write(*,*)'   TOO MANY ATOMS, STOP'
      stop
       endif
      if(natoms.eq.1) then
      write(*,*)'  ONLY ONE ATOM'
      stop  
      endif
      nnn=0
      do 4 i=1,natoms
      na(i)=iulim(i)-llim(i)+1
  4   nnn=nnn+na(i)
      if(nnn.ne.nbas)stop 1212
      nnab=(natoms*(natoms-1))/2
      if(nnab*2.ne.natoms*(natoms-1))stop 1213

      print *,'   '
      write(*,*)natoms,' ATOMS, ',nnab,' ATOMIC PAIRS'
      
      end

      subroutine getcore(z,ndeckl,nbas,natoms,h)
      implicit real*8(a-h,o-z)
      parameter (maxat=100)
      parameter (ndeck=500) 
      parameter (maxp=2000)
      common /stv/ s(ndeck,ndeck),t(ndeck,ndeck),
     $   vv(ndeck,ndeck,maxat)   
      dimension h(ndeckl,ndeckl),z(nbas,nbas,natoms)
      common /map/imap(maxp),imapsav(maxp)
      m=nbas

      do i=1,m
      imapsav(i)=imap(i)
      enddo
      
      do 1 iat=1,natoms
       do 11 j=1,m
       jj=imap(j)
       do 11 i=1,m
        ii=imap(i)
   11  z(jj,ii,iat)=vv(j,i,iat)
       do 12 j=1,m
       do 12 i=1,m
   12  vv(j,i,iat)=z(j,i,iat)
   1  continue
       do 21 j=1,m
       jj=imap(j)
       do 21 i=1,m
        ii=imap(i)
   21  h(jj,ii)=t(j,i)
       do 31 i=1,m
       do 31 j=1,m
   31  t(j,i)=h(j,i)
       
       do 121 j=1,m
       jj=imap(j)
       do 121 i=1,m
        ii=imap(i)
  121  h(jj,ii)=s(j,i)
       do 131 i=1,m
       do 131 j=1,m
  131  s(j,i)=h(j,i)
       
  61  format(1x,8f9.6)

       return
       end



      subroutine invert1(sao,ndeckl,s,llim,m)        
      implicit real*8(a-h,o-z)
      dimension sao(ndeckl,ndeckl),s(m,m)

      do 1 i=1,m
      ieltol=llim+i-1 
      do 1 j=1,m
      jeltol=llim+j-1 
   1  s(j,i)=sao(jeltol,ieltol)
      
  61  format(1x,7f10.7)
      call inv1(s,m)
      return
      end



      subroutine invert2(sao,ndeckl,s,llima,ma,llimb,mb,m)
      implicit real*8(a-h,o-z)
      dimension sao(ndeckl,ndeckl),s(m,m)
 
      data isor/0/
      isor=isor+1

 
      do 1 i=1,ma
      ieltol=llima+i-1 
      do 1 j=1,ma
      jeltol=llima+j-1 
   1  s(j,i)=sao(jeltol,ieltol)
      do 2 i=1,mb
      ieltol=llimb+i-1 
      do 2 j=1,mb
      jeltol=llimb+j-1 
   2  s(ma+j,ma+i)=sao(jeltol,ieltol)
      do 3 i=1,mb
      ieltol=llimb+i-1 
      do 3 j=1,ma
      jeltol=llima+j-1 
   3  s(j,ma+i)=sao(jeltol,ieltol)
      do 4 i=1,ma
      ieltol=llima+i-1 
      do 4 j=1,mb
      jeltol=llimb+j-1 
   4  s(ma+j,i)=sao(jeltol,ieltol)
  61  format(1x,7f10.7)
      call inv1(s,m)
      return
      end
      subroutine pm(c,nocc,m,p,ndeckl)  
      implicit real*8(a-h,o-z)
      dimension c(ndeckl,ndeckl),p(ndeckl,ndeckl)
       do 1 i=1,m
       do 1 j=1,m
       x=0.d0
       do 2 k=1,nocc
  2     x=x+c(i,k)*c(j,k)
  1    p(i,j)=2.d0*x

  61  format(1x,8f9.7)

       return
       end


   
      SUBROUTINE INV1(S,M)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (NMAX=500)
      DIMENSION S(m,m),S23(NMAX),SM(nmax,nmax)
C INVERSION OF A REAL SYMMETRIC MATRIX BY DIAGONALIZATION
C  DIAGONALIZE S, BUILD S**(-1) - and put it in S !!!!
      CALL SDIAGI(S,M,S23)
      DO 4 I=1,M
      IF(S23(I).LE.1.D-25) STOP 1925
  4   S23(I)=1.D0/S23(I)
      DO 5 I=1,M
      DO 5 J=1,M
      Y=0.D0
      DO 6 K=1,M
  6   Y=Y+S(I,K)*S23(K)*S(J,K)
      SM(I,J)=Y
  5   SM(J,I)=Y
      do 7 j=1,m
      do 7 i=1,m
  7   s(i,j)=sm(i,j)
      RETURN
      END
      SUBROUTINE SDIAGI(X,n,D)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (NMAX=500)
C DIAGONALIZATION OF THE REAL SYMMETRIC MATRIX X. IN D THE EIGENVALUES.
      DIMENSION D(n)
      DIMENSION E(NMAX),X(n,n)
      EPS=5.D-15
      TOL=5.D-40
      IF(N.EQ.1) GOTO 400
    5 DO 150 NI=2,N
      II=N+2-NI
      DO 150 I=II,II
      L=I-2
      H=0.0D0
      G=X(I,I-1)
      IF(L)140,140,20
   20 DO 30 K=1,L
   30 H=H+X(I,K)*X(I,K)
      S=H+G*G
      IF(S.GE.TOL) GOTO 50
   40 H=0.0D0
      GO TO 140
   50 IF(H)140,140,60
   60 L=L+1
      F=G
      G=DSQRT(S)
      IF(F)75,75,70
   70 G=-G
   75 H=S-F*G
      X(I,I-1)=F-G
      F=0.0D0
      DO 110 J=1,L
      X(J,I)=X(I,J)/H
      S=0.0D0
      DO 80 K=1,J
   80 S=S+X(J,K)*X(I,K)
      J1=J+1
      IF(J1.GT.L) GOTO 100
   85 DO 90 K=J1,L
   90 S=S+X(K,J)*X(I,K)
  100 E(J)=S/H
  110 F=F+S*X(J,I)
      F=F/(H+H)
      DO 120 J=1,L
  120 E(J)=E(J)-F*X(I,J)
      DO 130 J=1,L
      F=X(I,J)
      S=E(J)
      DO 130 K=1,J
  130 X(J,K)=X(J,K)-F*E(K)-X(I,K)*S
  140 D(I)=H
  150 E(I-1)=G
  160 D(1)=X(1,1)
      X(1,1)=1.0D0
      DO 220 I=2,N
      L=I-1
      IF(D(I))200,200,170
  170 DO 190 J=1,L
      S=0.0D0
      DO 180 K=1,L
  180 S=S+X(I,K)*X(K,J)
      DO 190 K=1,L
  190 X(K,J)=X(K,J)-S*X(K,I)
  200 D(I)=X(I,I)
      X(I,I)=1.0D0
  210 DO 220 J=1,L
      X(I,J)=0.0D0
  220 X(J,I)=0.0D0
      B=0.0D0
      F=0.0D0
      E(N)=0.0D0
      DO 340 L=1,N
      H=EPS*(DABS(D(L))+DABS(E(L)))
      IF(H.GT.B) B=H
  235 DO 240 J=L,N
      IF(DABS(E(J)).LE.B) GO TO 250
  240 CONTINUE
  250 IF(J.EQ.L) GOTO 340
  260 P=(D(L+1)-D(L))*.50D0/E(L)
      R=DSQRT(P*P+1.0D0)
      IF(P)270,280,280
  270 P=P-R
      GO TO 290
  280 P=P+R
  290 H=D(L)-E(L)/P
      DO 300 I=L,N
  300 D(I)=D(I)-H
      F=F+H
      P=D(J)
      C=1.0D0
      S=0.0D0
      J1=J-1
      DO 330 NI=L,J1
      II=L+J1-NI
      DO 330 I=II,II
      G=C*E(I)
      G=C*E(I)
      H=C*P
      IF(DABS(P).LT.DABS(E(I))) GO TO 310
  305 C=E(I)/P
      R=DSQRT(C*C+1.0D0)
      E(I+1)=S*P*R
      S=C/R
      C=1.0D0/R
      GO TO 320
  310 C=P/E(I)
      R=DSQRT(C*C+1.0D0)
      E(I+1)=S*E(I)*R
      S=1.0D0/R
      C=C/R
  320 P=C*D(I)-S*G
      D(I+1)=H+S*(C*G+S*D(I))
      DO 330 K=1,N
      H=X(K,I+1)
      X(K,I+1)=X(K,I)*S+H*C
  330 X(K,I)=X(K,I)*C-H*S
      E(L)=S*P
      D(L)=C*P
      IF(DABS(E(L)).GT.B) GO TO 260
  340 D(L)=D(L)+F
      NI=N-1
  350 DO 380 I=1,NI
      K=I
      P=D(I)
      J1=I+1
      DO 360 J=J1,N
      IF(D(J).LE.P) GOTO 360
  355 K=J
      P=D(J)
  360 CONTINUE
      IF(K.EQ.I) GOTO 380
  365 D(K)=D(I)
      D(I)=P
      DO 370 J=1,N
      P=X(J,I)
      X(J,I)=X(J,K)
  370 X(J,K)=P
  380 CONTINUE
  390 GO TO 410
  400 D(1)=X(1,1)
      X(1,1)=1.0D0
  410 RETURN
      END
c     subroutine inpint(mgmax,natoms,llim,iulim)
      subroutine inpint(natoms,llim,iulim)
      IMPLICIT REAL*8 (A-H,O-Z)
      
      parameter (maxat=100)
      parameter (nmax=500)
      parameter (n128=500)
c     dimension g(mgmax)
      dimension llim(n128),iulim(n128)
      common /pointer/ipoint(maxat),ijpoint(maxat,maxat),na(maxat)     
      common /hold/ihold(nmax),illim(n128)
      common /nat/ nat,igr,ifg,idum3(4)
      common iop(45)
     
      do i=1,natoms
      do mu=llim(i),iulim(i)
      ihold(mu)=i
      enddo
      enddo
   61 format(20i2)

       do i=1,natoms
       illim(i)=llim(i)
       enddo

      call gamgen
c      do i=1,Natoms
c     call shellat(i,igr,natoms)
c     if(iop(7).ne.0)call unconat(i)
c     enddo
        return      
      end

      subroutine bepack1(gf,ii,jj,kk,ll,llim,g,mi,ihold)
      implicit real*8(a-h,o-z)
      parameter (maxat=100)
      dimension llim(maxat),g(mi,mi,mi,mi),ihold(maxat)
      ih=ihold(ii)
      ishift=llim(ih)-1
      i=ii-ishift
      j=jj-ishift
      k=kk-ishift
      l=ll-ishift
      g(i,j,k,l)=gf
      g(j,i,l,k)=gf
      g(k,l,i,j)=gf
      g(l,k,j,i)=gf
      g(i,l,k,j)=gf
      g(l,i,j,k)=gf
      g(k,j,i,l)=gf
      g(j,k,l,i)=gf
      return
      end
      subroutine bepack2(gf,ii,jj,kk,ll,llim,g,mi,ihold,na)
      implicit real*8(a-h,o-z)
      parameter (maxat=100)
      dimension llim(maxat),g(mi,mi,mi,mi),ihold(maxat)
      dimension na(maxat)
      
      ih=ihold(ii)
      jh=ihold(jj)
      kh=ihold(kk)
      lh=ihold(ll)
      iat=min0(ih,jh,kh,lh)
      jat=max0(ih,jh,kh,lh)
      ni=na(iat)

      ishift=llim(ih)-1
      if(ih.eq.jat)ishift=ishift-ni

      jshift=llim(jh)-1
      if(jh.eq.jat)jshift=jshift-ni

      kshift=llim(kh)-1
      if(kh.eq.jat)kshift=kshift-ni

      lshift=llim(lh)-1
      if(lh.eq.jat)lshift=lshift-ni
     
      i=ii-ishift
      j=jj-jshift
      k=kk-kshift
      l=ll-lshift
      g(i,j,k,l)=gf
      g(j,i,l,k)=gf
      g(k,l,i,j)=gf
      g(l,k,j,i)=gf
      g(i,l,k,j)=gf
      g(l,i,j,k)=gf
      g(k,j,i,l)=gf
      g(j,k,l,i)=gf
      return
      end

      SUBROUTINE MPRINT(H,N,ndim)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION H(NDIM,NDIM)
      parameter (maxat=100)
      common /ia/ia(maxat),kkk,idummy

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
    
      K=8 
   65 FORMAT(1H0,40X,A4/)
      NMIN=1
      NMAX=MIN0(N,K)
   62 FORMAT(1X,I3,A4,8F9.4)
   1  PRINT 61, (I, mend(ia(i)),I=NMIN,NMAX)
   61 FORMAT(10X,8(1X,I3,A4,1X))
      PRINT 64
   64 FORMAT(1X)
      DO 2 I=1,N
      PRINT 62,I,mend(ia(i)),(H(I,J),J=NMIN,NMAX)
   2  CONTINUE
      NMIN=NMIN+8
      K=K+8
      NMAX=MIN0(N,K)
      IF(NMAX.GE.NMIN) GOTO 71
      RETURN
   71 PRINT 63
   63 FORMAT(1X///)
      GO TO 1
      END

      subroutine kiir
      implicit real*8(a-h,o-z)
      write(*,6670)
      write(*,6661)
 6661 format(/20x,'Program ENPART, Version 1.0')
      write(*,6662)
 6662 format(20x,28(1h-),/)
      write(*,6663)
      write(*,6660)
 6663 format(3x,'Calculating:')
 6660 format(3x,'------------',/)
      write(*,6664)
 6664 format(5x,2hA),' Bond orders and valences (I. Mayer, Chem. Phys.'
     $,'Lett. 97, 270, 1983....)',/)
      write(*,6665)
 6665 format(5x,2hB),' Energy components (I. Mayer, Phys. Chem. Chem. '
     $ , 'Phys. 8, 4630, 2006)',/)
      write(*,6666)
 6666 format(3x,'for a wave function obtained in a Gaussian ',
     $ 'calculation (G92, G94, G98, G03)',//)
      write(*,6667)
      write(*,6668)
      write(*,6669)
 6667 format(2x,'Cite this program as:')
 6668 format(2x,'---------------------')
 6669 format(1x,'I. Mayer, Program "ENPART", Version 1.0'
     $ ,' (Chemical Research Center,',/,
     $ ' Hungarian Academy of Sciences), Budapest, 2007.'/)
 6670 format(1x,79(1h-))
      write(*,6670)
      end
