      SUBROUTINE UNCONat(iat)
c Computes one-center two-electron integrals for D orbitals.     

C     LINK 305
C*
C     ----------------
C     QCPE GAUSSIAN 76
C     U OF T VERSION
C     OCTOBER 1979
C     ----------------
C*
C     TWO-ELECTRON INTEGRAL PACKAGE FOR SPD FUNCTIONS.
C     NORMALLY ONLY INTEGRALS INVOLVING D SHELLS ARE EVALUATED HERE
C     (THE CODE IS OPTIMIZED FOR UNCONTRACTED FUNCTIONS), BUT IT IS
C     CAPABLE OF EVALUATING ALL THE INTEGRALS.
C
C     THE MODE OF OPERATION IS DETERMINED BY IOP(38) - IF PROGRAM SHELL
C     WAS CALLED DURING THIS OVERLAY, UNCON ASSUMES ALL NON-D INTEGRALS
C     HAVE ALREADY BEEN EVALUATED. HOWEVER, IF IOP(38) IS 0, THEN ALL
C     THE INTEGRALS ARE EVALUATED HERE - THUS IT IS VERY IMPORTANT TO
C     CALL LINKS 304 AND 305 FROM THE SAME OVERLAY CARD IN THE ROUTE.
C
C     THE ACCURACY OPTION IS DETERMINED FROM IOP(22):
C     0  ALL PRE-CUTOFF'S ARE 0.0.
C     1  PRE-CUTOFF'S ARE 1.0D-10, 1.0D-8, 1.0D-6, 1.0D-4 AND 1.0D-2
C     FOR 0 THROUGH 4 D SHELLS.
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER SHELLA,SHELLN,SHELLT,AOS,UBOUND,aon
C*
      parameter (maxg=1000)
      parameter (maxp=2000)
      common/ihol/ihold(maxg),ixyz(maxg),icent
      common /limits/llsh(maxg),iulsh(maxg),ist
      COMMON IOP(45),ID1(37),Cx(30,3),CD(4),ID2(131)
C*
      COMMON/B/EXX(maxp),C1(maxp),C2(maxp),C3(240),x(maxp),y(maxp),
     *z(maxp),JAN(80),SHELLA(maxp),SHELLN(maxp),
     *SHELLT(maxp),AOS(maxg),AON(20),NSHELL,MAXTYP

      
C     USE COMMON /C100/ FOR SCRATCH.
      COMMON/C100/KOP1,KOP2,F(9)
      COMMON/C100/  XYZP(3),EP,RAB2,OFAB,
     $              XYZQ(3),EQ,RCD2,OFCD,
     $              PQX,PQY,PQZ,RPQ
      COMMON/C100/SAB(9),SCD(9),R(3,3),D(6,6),ET(35),SA(73),SB(73),
     $ SC(73),SD(73),TW(197),TQ(1296),FT(2215),CFILL(2228)
C     NOTE THAT ISHELL THROUGH LRANGE ARE PASSED TO SHLOUTd.
C     THE UNUSED SPACE IN /SHLINF/ IS FILLED BY VARIABLE DUM - THE
C     DIMENSION OF THIS VARIABLE IS MACHINE DEPENDENT - SEE BELOW.
      COMMON/SHLINF/R3OV2,IMJ,IMK,JML,KML,IMKJML,ISTART,JSTART,KSTART,
     $ LSTART,IEND,JEND,KEND,LEND,MEND,NUMD,IT,JT,KT,LT,INTC,
     $ IS1(30),SAS(3),SBS(3),SCS(3),SDS(3),CUTINT(5),XYZA(3),XYZB(3),
     $ XYZC(3),XYZD(3),RA(10),DUM,
     $ ISHELL,JSHELL,KSHELL,LSHELL,IRANGE,JRANGE,KRANGE,LRANGE
      COMMON/IO/INN,IOUT,IODUM(53)
C*
      DIMENSION IJKL(10,10),IJKLAO(10),LBOUND(3),UBOUND(3)
      DIMENSION DUM(61)
C*
      EQUIVALENCE (XA,XYZA(1))
      EQUIVALENCE (YA,XYZA(2))
      EQUIVALENCE (ZA,XYZA(3))
      EQUIVALENCE (XB,XYZB(1))
      EQUIVALENCE (YB,XYZB(2))
      EQUIVALENCE (ZB,XYZB(3))
      EQUIVALENCE (XC,XYZC(1))
      EQUIVALENCE (YC,XYZC(2))
      EQUIVALENCE (ZC,XYZC(3))
      EQUIVALENCE (XD,XYZD(1))
      EQUIVALENCE (YD,XYZD(2))
      EQUIVALENCE (ZD,XYZD(3))
      EQUIVALENCE (PX,XYZP(1))
      EQUIVALENCE (PY,XYZP(2))
      EQUIVALENCE (PZ,XYZP(3))
      EQUIVALENCE (QX,XYZQ(1))
      EQUIVALENCE (QY,XYZQ(2))
      EQUIVALENCE (QZ,XYZQ(3))
C*
      DATA IJKL/   1,   2,   6,  10,  14,  24,  34,  44,  54,  64,  74,
     $  78,  88,  98, 108, 128, 148, 168, 188, 208, 228, 232, 242, 252,
     $ 262, 282, 302, 322, 342, 362, 382, 386, 396, 406, 416, 436, 456,
     $ 476, 496, 516, 536, 546, 566, 586, 606, 641, 676, 711, 746, 781,
     $ 816, 826, 846, 866, 886, 921, 956, 991,1026,1061,1096,1106,1126,
     $1146,1166,1201,1236,1271,1306,1341,1376,1386,1406,1426,1446,1481,
     $1516,1551,1586,1621,1656,1666,1686,1706,1726,1761,1796,1831,1866,
     $1901,1936,1946,1966,1986,2006,2041,2076,2111,2146,2181/
      DATA IJKLAO/1,3*2,6*3/
      DATA LBOUND/1,1,5/,UBOUND/1,4,10/
      DATA PI/3.14159265358979D0/
      DATA HALF/0.5D0/,ONE/1.0D0/,TWO/2.0D0/
      DATA TWOPT5/2.5D0/,THREE/3.0D0/,OFCUT/42.0D0/
      DATA ZERO/0.0D0/,F100/100.0D0/,TENM10/1.0D-10/
C*
 1000 FORMAT('02-ELECTRON INTEGRALS FOR F ORBITALS NOT AVAILABLE')
C*

      IF(MAXTYP.LE.2)GO TO 1
      WRITE(IOUT,1000)
      IOP(1)=-2
      RETURN
c
c
C     INITIALIZE CONSTANTS.
   1  if(maxtyp.lt.2) return
      CUTINT(1)=ZERO
                             iop(38)=1
                             iop(22)=0
      IF(IOP(22).EQ.1)CUTINT(1)=TENM10
      DO 4 I=2,5
    4 CUTINT(I)=F100*CUTINT(I-1)
      CONST=TWO*PI**TWOPT5
      R3=DSQRT(THREE)
      DO 6 I=1,7
    6 RA(I)=ONE
      RA( 8)=R3
      RA( 9)=R3
      RA(10)=R3
      R3OV2=HALF*R3
      KOP1=3
      KOP2=1
      IOP38=IOP(38)
      IF(IOP38.EQ.0)CALL SHLOUTd(-1,TQ,1296)
C
 612  format(1p5e15.7)
   
      llima=llsh(iat)
      iulima=iulsh(iat)

C   The cycles run on the orbitals of atom A

      DO 405 ISHELL=llima,iulima
      I=IXYZ(ISHELL)
      XA=x(Ishell)
      YA=y(Ishell)
      ZA=z(Ishell)
      IA=SHELLA(ISHELL)
      IN=SHELLN(ISHELL)+IA-1
      IT=SHELLT(ISHELL)
      ISTART=LBOUND(IT+1)
 68   format(2i3,3f15.8,4i3)
C
      DO 401 JSHELL=llima,ISHELL
      J=IXYZ(JSHELL)
      Xb=x(jshell)
      Yb=y(jshell)
      Zb=z(jshell)
      JA=SHELLA(JSHELL)
      JN=SHELLN(JSHELL)+JA-1
      JT=SHELLT(JSHELL)
      JSTART=LBOUND(JT+1)
      RABSQ=(XB-XA)*(XB-XA)+(YB-YA)*(YB-YA)+(ZB-ZA)*(ZB-ZA)
C
      DO 402 KSHELL=llima,ISHELL
      K=IXYZ(KSHELL)
      Xc=x(kshell)
      Yc=y(kshell)
      Zc=z(kshell)
      KA=SHELLA(KSHELL)
      KN=SHELLN(KSHELL)+KA-1
      KT=SHELLT(KSHELL)
      KSTART=LBOUND(KT+1)
      MAXL=KSHELL
      IF (ISHELL.EQ.KSHELL) MAXL=JSHELL
C
      DO 403 LSHELL=llima,MAXL
      LT=SHELLT(LSHELL)
C     CALCULATE THE NUMBER OF D SHELLS.
      NUMD=IT/2+JT/2+KT/2+LT/2
      IF(IOP38.NE.0.AND.NUMD.EQ.0)GO TO 403
      IMJ=ISHELL-JSHELL
      IMK=ISHELL-KSHELL
      JML=IABS(JSHELL-LSHELL)
      KML=KSHELL-LSHELL
      IMKJML=IMK+JML
      L=IXYZ(LSHELL)
      Xd=x(Lshell)
      Yd=y(Lshell)
      Zd=z(Lshell)
      LA=SHELLA(LSHELL)
      LN=SHELLN(LSHELL)+LA-1
      LSTART=LBOUND(LT+1)
      RCDSQ=(XD-XC)*(XD-XC)+(YD-YC)*(YD-YC)+(ZD-ZC)*(ZD-ZC)
      IEND=UBOUND(IT+1)
      JEND=UBOUND(JT+1)
      KEND=UBOUND(KT+1)
      LEND=UBOUND(LT+1)
      IRANGE=IEND-ISTART+1
      JRANGE=JEND-JSTART+1
      KRANGE=KEND-KSTART+1
      LRANGE=LEND-LSTART+1
      MEND=IRANGE*JRANGE*KRANGE*LRANGE
                 
      DO 730 I=1,MEND
  730 TQ(I)=ZERO
C
C     COMMENCE LOOP OVER GAUSSIAN EXPANSION
C
      INTCNT=0
      DO 300 IGAUSS=IA,IN
      AS=EXX(IGAUSS)
      CALL UFILLC(IT,IGAUSS,C1,C2,SAS)
C
      DO 301 JGAUSS=JA,JN
      BS=EXX(JGAUSS)
      CALL UFILLC(JT,JGAUSS,C1,C2,SBS)
      EP=AS+BS
      PX=(AS*XA+BS*XB)/EP
      PY=(AS*YA+BS*YB)/EP
      PZ=(AS*ZA+BS*ZB)/EP
      OFAB=AS*BS*RABSQ/EP
      IF(OFAB.GE.OFCUT)GO TO 301
      OFAB=DEXP(-OFAB)
      OFAB=OFAB*CONST/EP
C
      DO 302 KGAUSS=KA,KN
      CS=EXX(KGAUSS)
      CALL UFILLC(KT,KGAUSS,C1,C2,SCS)
C
      DO 303 LGAUSS=LA,LN
      DS=EXX(LGAUSS)
      CALL UFILLC(LT,LGAUSS,C1,C2,SDS)
      EQ=CS+DS
      QX=(CS*XC+DS*XD)/EQ
      QY=(CS*YC+DS*YD)/EQ
      QZ=(CS*ZC+DS*ZD)/EQ
      OFCD=CS*DS*RCDSQ/EQ
      IF(OFCD.GE.OFCUT)GO TO 303
      OFCD=OFAB*DEXP(-OFCD)
      OFCD=OFCD/(EQ*DSQRT(EP+EQ))
      IF(OFCD.LE.CUTINT(NUMD+1))GO TO 303
      K=0
      DO 330 I=1,3
      SASA=SCS(I)*OFCD
      DO 330 J=1,3
      K=K+1
      SAB(K)=SAS(I)*SBS(J)
  330 SCD(K)=SASA*SDS(J)
      PQX=QX-PX
      PQY=QY-PY
      PQZ=QZ-PZ
      RPQSQ=PQX*PQX+PQY*PQY+PQZ*PQZ
C     WATCH FOR SMALL VALUES OF RPQSQ.
      IF(RPQSQ.LE.TENM10)RPQSQ=ZERO
      RPQ=DSQRT(RPQSQ)
      FG=EP*EQ/(EP+EQ)
      T=RPQSQ*FG
      FG=FG+FG
C     COMPUTE FM(T).  IF T < FMCUT, USE PRESTORED LIST FOR
C     AN ARGUMENT OF ZERO.  AFTER GETTING FM(T), CONVERT TO FM'(T).
      M=IT+JT+KT+LT+1
      CALL FMT(T,M,f)
      IF(M.EQ.1)GO TO 281
      TEMP=ONE
      DO 280 I=2,M
      TEMP=TEMP*FG
  280 F(I)=F(I)*TEMP
  281 CALL FORMS(KT+LT)
      CALL ROTATE
      CALL FABCD(SA,XYZA,XYZP,IT)
      CALL FABCD(SB,XYZB,XYZP,JT)
      CALL FABCD(SC,XYZC,XYZQ,KT)
      CALL FABCD(SD,XYZD,XYZQ,LT)
      DO 100 K=KSTART,KEND
      KFT=IJKL(K,1)
      IF (KSHELL.EQ.LSHELL) LEND=K
      DO 100 L=LSTART,LEND
      LFT=IJKL(L,1)
      KL=IJKL(K,L)
  100 CALL FORMQ(SC(KFT),SD(LFT),FT(KL),IJKLAO(K),IJKLAO(L))
      INTC=0
      DO 200 I=ISTART,IEND
      IET=IJKL(I,1)
      IF (ISHELL.EQ.JSHELL) JEND=I
      IF (ISHELL.EQ.KSHELL.AND.JSHELL.EQ.LSHELL) KEND=I
      DO 211 J=JSTART,JEND
      JET=IJKL(J,1)
      CALL FORMP(SA(IET),SB(JET),IJKLAO(I),IJKLAO(J),KT+LT)
      DO 212 K=KSTART,KEND
      LEND=UBOUND(LT+1)
      IF (KSHELL.EQ.LSHELL) LEND=K
      IF (ISHELL.EQ.KSHELL.AND.JSHELL.EQ.LSHELL.AND.I.EQ.K) LEND=J
      KLIMIT=7-IJKLAO(K)
      DO 213 L=LSTART,LEND
      M=IJKL(K,L)-1
      LLIMIT=KLIMIT-IJKLAO(L)
      Q=ET(1)*FT(M+1)
      IF (LLIMIT.EQ.5) GO TO 160
      Q=Q+ET(2)*FT(M+2)+ET(3)*FT(M+3)+ET(4)*FT(M+4)
      IF (LLIMIT.EQ.4) GO TO 160
      Q=Q+ET(5)*FT(M+5)+ET(6)*FT(M+6)+ET(7)*FT(M+7)+ET(8)*FT(M+8)
     1 +ET(9)*FT(M+9)+ET(10)*FT(M+10)
      IF (LLIMIT.EQ.3) GO TO 160
      Q=Q+ET(11)*FT(M+11)+ET(12)*FT(M+12)+ET(13)*FT(M+13)+
     1 ET(14)*FT(M+14)+ET(15)*FT(M+15)+ET(16)*FT(M+16)+ET(18)*FT(M+18)+
     2 ET(19)*FT(M+19)+ET(20)*FT(M+20)+ET(17)*FT(M+17)
      IF (LLIMIT.EQ.2) GO TO 160
      Q=Q+ET(21)*FT(M+21)+ET(22)*FT(M+22)+ET(23)*FT(M+23)+
     1 ET(24)*FT(M+24)+ET(25)*FT(M+25)+ET(26)*FT(M+26)+ET(27)*FT(M+27)+
     2 ET(28)*FT(M+28)+ET(29)*FT(M+29)+ET(30)*FT(M+30)+ET(31)*FT(M+31)+
     3 ET(32)*FT(M+32)+ET(33)*FT(M+33)+ET(34)*FT(M+34)+ET(35)*FT(M+35)
  160 INTC=INTC+1
      TQ(INTC)=TQ(INTC)+Q
  213 CONTINUE
  212 CONTINUE
  211 CONTINUE
  200 CONTINUE
      INTCNT=INTC
  303 CONTINUE
  302 CONTINUE
  301 CONTINUE
  300 CONTINUE
C
C     END OF LOOP OVER GAUSSIANS
C
      IF(INTCNT.EQ.0)GO TO 403
      INTC=0
C     RENORMALIZE CONTRACTED GAUSSIAN INTEGRALS.
      DO 870 I=ISTART,IEND
      RI=RA(I)
      IF(IMJ.EQ.0)JEND=I
      IF(IMK+JML.EQ.0)KEND=I
      DO 870 J=JSTART,JEND
      RJ=RI*RA(J)
      DO 870 K=KSTART,KEND
      RK=RJ*RA(K)
      LEND=UBOUND(LT+1)
      IF(KML.EQ.0)LEND=K
      IF(IMK+JML+IABS(I-K).EQ.0)LEND=J
      DO 870 L=LSTART,LEND
      INTC=INTC+1
  870 TQ(INTC)=TQ(INTC)*RK*RA(L)
C     RESTORE JEND, KEND AND LEND.
      JEND=UBOUND(JT+1)
      KEND=UBOUND(KT+1)
      LEND=UBOUND(LT+1)
C     RESTORE SHELL DUPLICATES; TRANSFORM 6D TO 5D.
      CALL URD65
  403 CONTINUE
  402 CONTINUE
  401 CONTINUE
  405 CONTINUE
C     EMPTY LAST BUFFER.
      CALL SHLOUTd(0,TQ,1296)
      RETURN
      END
      SUBROUTINE UNCONab(iat,jat)

c Computes two-center two-electron integrals for D orbitals.     
 

C     LINK 305
C*
C     ----------------
C     QCPE GAUSSIAN 76
C     U OF T VERSION
C     OCTOBER 1979
C     ----------------
C*
C     TWO-ELECTRON INTEGRAL PACKAGE FOR SPD FUNCTIONS.
C     NORMALLY ONLY INTEGRALS INVOLVING D SHELLS ARE EVALUATED HERE
C     (THE CODE IS OPTIMIZED FOR UNCONTRACTED FUNCTIONS), BUT IT IS
C     CAPABLE OF EVALUATING ALL THE INTEGRALS.
C
C     THE MODE OF OPERATION IS DETERMINED BY IOP(38) - IF PROGRAM SHELL
C     WAS CALLED DURING THIS OVERLAY, UNCON ASSUMES ALL NON-D INTEGRALS
C     HAVE ALREADY BEEN EVALUATED. HOWEVER, IF IOP(38) IS 0, THEN ALL
C     THE INTEGRALS ARE EVALUATED HERE - THUS IT IS VERY IMPORTANT TO
C     CALL LINKS 304 AND 305 FROM THE SAME OVERLAY CARD IN THE ROUTE.
C
C     THE ACCURACY OPTION IS DETERMINED FROM IOP(22):
C     0  ALL PRE-CUTOFF'S ARE 0.0.
C     1  PRE-CUTOFF'S ARE 1.0D-10, 1.0D-8, 1.0D-6, 1.0D-4 AND 1.0D-2
C     FOR 0 THROUGH 4 D SHELLS.
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER SHELLA,SHELLN,SHELLT,AOS,UBOUND,aon
C*
      parameter (maxg=1000)
      parameter (maxp=2000)
      common/ihol/ihold(maxg),ixyz(maxg),icent

      common /limits/llsh(maxg),iulsh(maxg),ist


c     common/f9/f(9)
 
c     COMMON IOP(45),ID1(37),C(30,3),CD(4),ID2(131)
      COMMON IOP(45),ID1(37),Cx(30,3),CD(4),ID2(131)
C*
c      COMMON/B/IXYZ(50),SHELLA(50),SHELLN(50),SHELLT(50),SHELLC(50),
c    $ AOS(50),NSHELL,MAXTYP,EXX(180),C1(180),C2(180)



      COMMON/B/EXX(maxp),C1(maxp),C2(maxp),C3(240),x(maxp),y(maxp),
     *z(maxp),JAN(80),SHELLA(maxp),SHELLN(maxp),
     *SHELLT(maxp),AOS(maxg),AON(20),NSHELL,MAXTYP

      
C     USE COMMON /C100/ FOR SCRATCH.
      COMMON/C100/KOP1,KOP2,F(9)
      COMMON/C100/  XYZP(3),EP,RAB2,OFAB,
     $              XYZQ(3),EQ,RCD2,OFCD,
     $              PQX,PQY,PQZ,RPQ
      COMMON/C100/SAB(9),SCD(9),R(3,3),D(6,6),ET(35),SA(73),SB(73),
     $ SC(73),SD(73),TW(197),TQ(1296),FT(2215),CFILL(2228)
C     NOTE THAT ISHELL THROUGH LRANGE ARE PASSED TO SHLOUTd.
C     THE UNUSED SPACE IN /SHLINF/ IS FILLED BY VARIABLE DUM - THE
C     DIMENSION OF THIS VARIABLE IS MACHINE DEPENDENT - SEE BELOW.
      COMMON/SHLINF/R3OV2,IMJ,IMK,JML,KML,IMKJML,ISTART,JSTART,KSTART,
     $ LSTART,IEND,JEND,KEND,LEND,MEND,NUMD,IT,JT,KT,LT,INTC,
     $ IS1(30),SAS(3),SBS(3),SCS(3),SDS(3),CUTINT(5),XYZA(3),XYZB(3),
     $ XYZC(3),XYZD(3),RA(10),DUM,
     $ ISHELL,JSHELL,KSHELL,LSHELL,IRANGE,JRANGE,KRANGE,LRANGE
      COMMON/IO/INN,IOUT,IODUM(53)
C*
      DIMENSION IJKL(10,10),IJKLAO(10),LBOUND(3),UBOUND(3)
C     *IBM*/*SEL*
      DIMENSION DUM(61)
C     *CDC*
C     DIMENSION DUM(42)
C*

      dimension imap(maxp)

      EQUIVALENCE (XA,XYZA(1))
      EQUIVALENCE (YA,XYZA(2))
      EQUIVALENCE (ZA,XYZA(3))
      EQUIVALENCE (XB,XYZB(1))
      EQUIVALENCE (YB,XYZB(2))
      EQUIVALENCE (ZB,XYZB(3))
      EQUIVALENCE (XC,XYZC(1))
      EQUIVALENCE (YC,XYZC(2))
      EQUIVALENCE (ZC,XYZC(3))
      EQUIVALENCE (XD,XYZD(1))
      EQUIVALENCE (YD,XYZD(2))
      EQUIVALENCE (ZD,XYZD(3))
      EQUIVALENCE (PX,XYZP(1))
      EQUIVALENCE (PY,XYZP(2))
      EQUIVALENCE (PZ,XYZP(3))
      EQUIVALENCE (QX,XYZQ(1))
      EQUIVALENCE (QY,XYZQ(2))
      EQUIVALENCE (QZ,XYZQ(3))
C*
      DATA IJKL/   1,   2,   6,  10,  14,  24,  34,  44,  54,  64,  74,
     $  78,  88,  98, 108, 128, 148, 168, 188, 208, 228, 232, 242, 252,
     $ 262, 282, 302, 322, 342, 362, 382, 386, 396, 406, 416, 436, 456,
     $ 476, 496, 516, 536, 546, 566, 586, 606, 641, 676, 711, 746, 781,
     $ 816, 826, 846, 866, 886, 921, 956, 991,1026,1061,1096,1106,1126,
     $1146,1166,1201,1236,1271,1306,1341,1376,1386,1406,1426,1446,1481,
     $1516,1551,1586,1621,1656,1666,1686,1706,1726,1761,1796,1831,1866,
     $1901,1936,1946,1966,1986,2006,2041,2076,2111,2146,2181/
      DATA IJKLAO/1,3*2,6*3/
      DATA LBOUND/1,1,5/,UBOUND/1,4,10/
      DATA PI/3.14159265358979D0/
      DATA HALF/0.5D0/,ONE/1.0D0/,TWO/2.0D0/
      DATA TWOPT5/2.5D0/,THREE/3.0D0/,OFCUT/42.0D0/
      DATA ZERO/0.0D0/,F100/100.0D0/,TENM10/1.0D-10/
C*
 1000 FORMAT('02-ELECTRON INTEGRALS FOR F ORBITALS NOT AVAILABLE')
C*


      IF(MAXTYP.LE.2)GO TO 1
      WRITE(IOUT,1000)
      IOP(1)=-2
      RETURN
c
c
C     INITIALIZE CONSTANTS.
   1   if(maxtyp.lt.2)return
      CUTINT(1)=ZERO
                             iop(38)=1
                             iop(22)=0
      IF(IOP(22).EQ.1)CUTINT(1)=TENM10
      DO 4 I=2,5
    4 CUTINT(I)=F100*CUTINT(I-1)
      CONST=TWO*PI**TWOPT5
      R3=DSQRT(THREE)
      DO 6 I=1,7
    6 RA(I)=ONE
      RA( 8)=R3
      RA( 9)=R3
      RA(10)=R3
      R3OV2=HALF*R3
      KOP1=3
      KOP2=1
      IOP38=IOP(38)
      IF(IOP38.EQ.0)CALL SHLOUTd(-1,TQ,1296)
C
 612  format(1p5e15.7)
   
  611 format(10i3)
 123  ma=iulsh(iat)-llsh(iat)+1
      mb=iulsh(jat)-llsh(jat)+1
      mab=ma+mb
      do 121 i=1,ma
 121  imap(i)=llsh(iat)+i-1
      do 122 i=1,mb
 122  imap(ma+i)=llsh(jat)+i-1
c
c     This "mapping" provides that only integrals involving centers
C     A and B will be calculated
c     

C     READ IN BASIS SET SPECIFICATIONS
      DO 405 ifut=1,mab   
      ishell=imap(ifut)
      I=IXYZ(ISHELL)
      XA=x(Ishell)
      YA=y(Ishell)
      ZA=z(Ishell)
      IA=SHELLA(ISHELL)
      IN=SHELLN(ISHELL)+IA-1
      IT=SHELLT(ISHELL)
      ISTART=LBOUND(IT+1)
c     print 68,ishell,i,xa,Ya,za,ia,in,it,istart
 68   format(2i3,3f15.8,4i3)
C
      DO 401 jfut=1,ifut
      jshell=imap(jfut)
      J=IXYZ(JSHELL)
      Xb=x(jshell)
      Yb=y(jshell)
      Zb=z(jshell)
      JA=SHELLA(JSHELL)
      JN=SHELLN(JSHELL)+JA-1
      JT=SHELLT(JSHELL)
      JSTART=LBOUND(JT+1)
      RABSQ=(XB-XA)*(XB-XA)+(YB-YA)*(YB-YA)+(ZB-ZA)*(ZB-ZA)
C
      DO 402 kfut=1,ifut
      kshell=imap(kfut)
      K=IXYZ(KSHELL)
      Xc=x(kshell)
      Yc=y(kshell)
      Zc=z(kshell)
      KA=SHELLA(KSHELL)
      KN=SHELLN(KSHELL)+KA-1
      KT=SHELLT(KSHELL)
      KSTART=LBOUND(KT+1)
      MAXL=kfut   
      IF (ifut.EQ.kfut) MAXL=jfut  
C
      DO 403 lfut=1,MAXL
      lshell=imap(lfut)
      LT=SHELLT(LSHELL)
C     CALCULATE THE NUMBER OF D SHELLS.
      NUMD=IT/2+JT/2+KT/2+LT/2
c     print *,'it..numd',it,jt,kt,lt,numd
      IF(IOP38.NE.0.AND.NUMD.EQ.0)GO TO 403
      ih1=ixyz(ishell)
      icent=1
      if(ixyz(jshell).ne.ih1)then
      icent=2
      ih2=ixyz(jshell)
      endif

      goto (101,102),icent
  101 if(ixyz(kshell).ne.ih1)then
      icent=2
      ih2=ixyz(kshell)
      endif
      goto 103
  102 if(ixyz(kshell).ne.ih1.and.ixyz(kshell).ne.ih2) stop 700

  103 goto (203,202),icent
  202 if(ixyz(lshell).ne.ih1.and.ixyz(lshell).ne.ih2) stop 701
  203 if(ixyz(lshell).ne.ih1) icent=2
      if(icent.eq.1)goto 403

      IMJ=ISHELL-JSHELL
      IMK=ISHELL-KSHELL
      JML=IABS(JSHELL-LSHELL)
      KML=KSHELL-LSHELL
      IMKJML=IMK+JML
      L=IXYZ(LSHELL)
      Xd=x(Lshell)
      Yd=y(Lshell)
      Zd=z(Lshell)
      LA=SHELLA(LSHELL)
      LN=SHELLN(LSHELL)+LA-1
      LSTART=LBOUND(LT+1)
      RCDSQ=(XD-XC)*(XD-XC)+(YD-YC)*(YD-YC)+(ZD-ZC)*(ZD-ZC)
      IEND=UBOUND(IT+1)
      JEND=UBOUND(JT+1)
      KEND=UBOUND(KT+1)
      LEND=UBOUND(LT+1)
      IRANGE=IEND-ISTART+1
      JRANGE=JEND-JSTART+1
      KRANGE=KEND-KSTART+1
      LRANGE=LEND-LSTART+1
      MEND=IRANGE*JRANGE*KRANGE*LRANGE
                 
      DO 730 I=1,MEND
  730 TQ(I)=ZERO
C
C     COMMENCE LOOP OVER GAUSSIAN EXPANSION
C
      INTCNT=0
      DO 300 IGAUSS=IA,IN
      AS=EXX(IGAUSS)
      CALL UFILLC(IT,IGAUSS,C1,C2,SAS)
C
      DO 301 JGAUSS=JA,JN
      BS=EXX(JGAUSS)
      CALL UFILLC(JT,JGAUSS,C1,C2,SBS)
      EP=AS+BS
      PX=(AS*XA+BS*XB)/EP
      PY=(AS*YA+BS*YB)/EP
      PZ=(AS*ZA+BS*ZB)/EP
      OFAB=AS*BS*RABSQ/EP
      IF(OFAB.GE.OFCUT)GO TO 301
      OFAB=DEXP(-OFAB)
      OFAB=OFAB*CONST/EP
C
      DO 302 KGAUSS=KA,KN
      CS=EXX(KGAUSS)
      CALL UFILLC(KT,KGAUSS,C1,C2,SCS)
C
      DO 303 LGAUSS=LA,LN
      DS=EXX(LGAUSS)
      CALL UFILLC(LT,LGAUSS,C1,C2,SDS)
      EQ=CS+DS
      QX=(CS*XC+DS*XD)/EQ
      QY=(CS*YC+DS*YD)/EQ
      QZ=(CS*ZC+DS*ZD)/EQ
      OFCD=CS*DS*RCDSQ/EQ
      IF(OFCD.GE.OFCUT)GO TO 303
      OFCD=OFAB*DEXP(-OFCD)
      OFCD=OFCD/(EQ*DSQRT(EP+EQ))
      IF(OFCD.LE.CUTINT(NUMD+1))GO TO 303
      K=0
      DO 330 I=1,3
      SASA=SCS(I)*OFCD
      DO 330 J=1,3
      K=K+1
      SAB(K)=SAS(I)*SBS(J)
  330 SCD(K)=SASA*SDS(J)
      PQX=QX-PX
      PQY=QY-PY
      PQZ=QZ-PZ
      RPQSQ=PQX*PQX+PQY*PQY+PQZ*PQZ
C     WATCH FOR SMALL VALUES OF RPQSQ.
      IF(RPQSQ.LE.TENM10)RPQSQ=ZERO
      RPQ=DSQRT(RPQSQ)
      FG=EP*EQ/(EP+EQ)
      T=RPQSQ*FG
      FG=FG+FG
C     COMPUTE FM(T).  IF T < FMCUT, USE PRESTORED LIST FOR
C     AN ARGUMENT OF ZERO.  AFTER GETTING FM(T), CONVERT TO FM'(T).
      M=IT+JT+KT+LT+1
      CALL FMT(T,M,f)
      IF(M.EQ.1)GO TO 281
      TEMP=ONE
      DO 280 I=2,M
      TEMP=TEMP*FG
  280 F(I)=F(I)*TEMP
  281 CALL FORMS(KT+LT)
      CALL ROTATE
      CALL FABCD(SA,XYZA,XYZP,IT)
      CALL FABCD(SB,XYZB,XYZP,JT)
      CALL FABCD(SC,XYZC,XYZQ,KT)
      CALL FABCD(SD,XYZD,XYZQ,LT)
      DO 100 K=KSTART,KEND
      KFT=IJKL(K,1)
      IF (KSHELL.EQ.LSHELL) LEND=K
      DO 100 L=LSTART,LEND
      LFT=IJKL(L,1)
      KL=IJKL(K,L)
  100 CALL FORMQ(SC(KFT),SD(LFT),FT(KL),IJKLAO(K),IJKLAO(L))
      INTC=0
      DO 200 I=ISTART,IEND
      IET=IJKL(I,1)
      IF (ISHELL.EQ.JSHELL) JEND=I
      IF (ISHELL.EQ.KSHELL.AND.JSHELL.EQ.LSHELL) KEND=I
      DO 211 J=JSTART,JEND
      JET=IJKL(J,1)
      CALL FORMP(SA(IET),SB(JET),IJKLAO(I),IJKLAO(J),KT+LT)
      DO 212 K=KSTART,KEND
      LEND=UBOUND(LT+1)
      IF (KSHELL.EQ.LSHELL) LEND=K
      IF (ISHELL.EQ.KSHELL.AND.JSHELL.EQ.LSHELL.AND.I.EQ.K) LEND=J
      KLIMIT=7-IJKLAO(K)
      DO 213 L=LSTART,LEND
      M=IJKL(K,L)-1
      LLIMIT=KLIMIT-IJKLAO(L)
      Q=ET(1)*FT(M+1)
      IF (LLIMIT.EQ.5) GO TO 160
      Q=Q+ET(2)*FT(M+2)+ET(3)*FT(M+3)+ET(4)*FT(M+4)
      IF (LLIMIT.EQ.4) GO TO 160
      Q=Q+ET(5)*FT(M+5)+ET(6)*FT(M+6)+ET(7)*FT(M+7)+ET(8)*FT(M+8)
     1 +ET(9)*FT(M+9)+ET(10)*FT(M+10)
      IF (LLIMIT.EQ.3) GO TO 160
      Q=Q+ET(11)*FT(M+11)+ET(12)*FT(M+12)+ET(13)*FT(M+13)+
     1 ET(14)*FT(M+14)+ET(15)*FT(M+15)+ET(16)*FT(M+16)+ET(18)*FT(M+18)+
     2 ET(19)*FT(M+19)+ET(20)*FT(M+20)+ET(17)*FT(M+17)
      IF (LLIMIT.EQ.2) GO TO 160
      Q=Q+ET(21)*FT(M+21)+ET(22)*FT(M+22)+ET(23)*FT(M+23)+
     1 ET(24)*FT(M+24)+ET(25)*FT(M+25)+ET(26)*FT(M+26)+ET(27)*FT(M+27)+
     2 ET(28)*FT(M+28)+ET(29)*FT(M+29)+ET(30)*FT(M+30)+ET(31)*FT(M+31)+
     3 ET(32)*FT(M+32)+ET(33)*FT(M+33)+ET(34)*FT(M+34)+ET(35)*FT(M+35)
  160 INTC=INTC+1
      TQ(INTC)=TQ(INTC)+Q
  213 CONTINUE
  212 CONTINUE
  211 CONTINUE
  200 CONTINUE
      INTCNT=INTC
  303 CONTINUE
  302 CONTINUE
  301 CONTINUE
  300 CONTINUE
C
C     END OF LOOP OVER GAUSSIANS
C
      IF(INTCNT.EQ.0)GO TO 403
      INTC=0
C     RENORMALIZE CONTRACTED GAUSSIAN INTEGRALS.
      DO 870 I=ISTART,IEND
      RI=RA(I)
      IF(IMJ.EQ.0)JEND=I
      IF(IMK+JML.EQ.0)KEND=I
      DO 870 J=JSTART,JEND
      RJ=RI*RA(J)
      DO 870 K=KSTART,KEND
      RK=RJ*RA(K)
      LEND=UBOUND(LT+1)
      IF(KML.EQ.0)LEND=K
      IF(IMK+JML+IABS(I-K).EQ.0)LEND=J
      DO 870 L=LSTART,LEND
      INTC=INTC+1
  870 TQ(INTC)=TQ(INTC)*RK*RA(L)
C     RESTORE JEND, KEND AND LEND.
      JEND=UBOUND(JT+1)
      KEND=UBOUND(KT+1)
      LEND=UBOUND(LT+1)
C     RESTORE SHELL DUPLICATES; TRANSFORM 6D TO 5D.
      CALL URD65
  403 CONTINUE
  402 CONTINUE
  401 CONTINUE
  405 CONTINUE
C     EMPTY LAST BUFFER.
      CALL SHLOUTd(0,TQ,1296)
      RETURN
      END
      SUBROUTINE UFILLC(IT,IG,C1,C2,SAS)
C*
C     --------------
C     U OF T VERSION
C     MARCH 1979
C     --------------
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION C1(180),C2(180),SAS(3)
      DATA ZERO/0.0D0/
      IF(IT-1)10,20,30
C     S SHELL.
   10 SAS(1)=C1(IG)
      SAS(2)=ZERO
      SAS(3)=ZERO
      RETURN
C     SP SHELL.
   20 SAS(1)=C1(IG)
      SAS(2)=C2(IG)
      SAS(3)=ZERO
      RETURN
C     D SHELL.
   30 SAS(1)=ZERO
      SAS(2)=ZERO
      SAS(3)=C1(IG)
      RETURN
      END
      SUBROUTINE URD65
C
C     --------------------------
C     GAUSSIAN 76 (QCPE VERSION)
C     DECEMBER 1977
C     --------------------------
C
C     ROUTINE TO TRANSFORM (IN A STEP-WISE FASHION) THE 6D INTEGRALS
C     TO THE FIVE PURE D INTEGRALS.
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON IOP(45),IC1(37),CDUM(94),IC2(131)
C
      COMMON/SHLINF/R3OV2,IMJ,IMK,JML,KML,IMKJML,ISTART,JSTART,KSTART,
     $ LSTART,IEND,JEND,KEND,LEND,MEND,NUMD,IT,JT,KT,LT,INTC,
     $ IIND(10),JIND(10),KIND(10),DUM,
     $ ISHELL,JSHELL,KSHELL,LSHELL,IRANGE,JRANGE,KRANGE,LRANGE
      COMMON/C100/KOPS(2),CFILL1(612),TQ(1296),CFILL2(2215),TQOUT(1296),
     $ CFILL3(932)
C
      DIMENSION TQNEW(1296)
C     *IBM*/*SEL*
      DIMENSION DUM(100)
C     *CDC*
C     DIMENSION DUM(81)
C
      EQUIVALENCE (TQNEW(1),TQ(1))
C
      DATA ZERO/0.0D0/,PT5/0.5D0/
C
C     INDEXING RANGES ARE PICKED UP FROM /SHLINF/.
C     COMPUTE RANGE PRODUCTS AND INDEXING BIASES.
C
c     print *,' IOP', iop(7),iop(8)
      KSL=KRANGE*LRANGE
      JSKSL=JRANGE*KSL
      ISJ=IRANGE*JRANGE
      ISTP1=ISTART-1
      JSTP1=JSTART-1
      KSTP1=KSTART-1
      LSTP1=LSTART-1
C
C     COMPUTE INDEXING ARRAYS.
C     THESE ARRAYS GIVE THE PROPER INDEX INTO THE ARRAY AS DIMENSIONED
C     BY THE MAXIMUM RANGES IN A PARTICULAR SHELL COMBINATION.
C
      ITEMP=0
      DO 100 K=KSTART,KEND
      KIND(K)=ITEMP*LRANGE
  100 ITEMP=ITEMP+1
      ITEMP=0
      DO 110 J=JSTART,JEND
      JIND(J)=ITEMP*KSL
  110 ITEMP=ITEMP+1
      ITEMP=0
      DO 120 I=ISTART,IEND
      IIND(I)=ITEMP*JSKSL
  120 ITEMP=ITEMP+1
C
C     FILL OUT TQ TO RESTORE SHELL DUPLICATES.
C
C     IN WHAT FOLLOWS, THERE ARE 6 CASES TO BE CONSIDERED.
C
C        CASE  CONDITION          RELATION OF ISHELL, ETC.
C        ----  ---------          ------------------------
C
C          1   NONE               ALL DISTINCT, IE. NO TWO SHELLS ARE
C                                 THE SAME.
C
C          2   A                  ISHELL=JSHELL ONLY (EG. (33,21)).
C
C          3   B                  KSHELL=LSHELL ONLY (EG. (32,11)).
C          4   C                  ISHELL=KSHELL AND JSHELL=LSHELL ONLY
C                                 (EG. (21,21)).
C
C          5   AB                 ISHELL=JSHELL AND KSHELL=LSHELL,
C                                 (EG. (22,11)).
C
C          6   ABC, AC, BC        ALL EQUAL (EG. (22,22)).
C
C
C     CASE 1 IS THE MOST FREQUENTLY OCCURRING CASE, AND IS TESTED FOR
C     FIRST.  THE OTHER CASES ARE TESTED FOR ESSENTIALLY IN THAT
C     MANNER THAT REDUCES THE NUMBER OF IF-STATEMENTS.
C
C     IF THE PRODUCT IS NON-ZERO, WE HAVE CASE 1.
C
      IF(IMJ*KML*IMKJML.NE.0)GO TO 1000
C
C     ENTRY AT THIS POINT IMPLIES THAT AT LEAST ONE OF THE 3
C     POSSIBLE SHELL COINCIDENCE FLAGS IS ZERO.
C     THE ALL EQUAL CASE IS EASIEST TO DETECT.
C
      IF(IMJ+IMKJML.EQ.0)GO TO 6
C
C     ENTRY AT THIS POINT IMPLIES THAT ONE OR BOTH OF IMJ, IMKJML
C     IS NON-ZERO.
C     THEREFORE, IMKJML=0 IMPLIES CASE 4.
C
      IF(IMKJML.EQ.0)GO TO 4
C
C     AT THIS POINT, EITHER IMJ OR KML (OR BOTH) IS (ARE) ZERO.
C     TEST FOR BOTH SIMULTANEOUSLY ZERO.
C
      IF(IMJ+KML.EQ.0)GO TO 5
C
C     AT THIS POINT, BOTH ARE NOT ZERO TOGETHER.
C     (IMJ*IMKJML*KML)=0 AND THE PREVIOUS TWO TESTS  MEAN THAT AT
C     LEAST ONE IS ZERO.
C     THEREFORE, ONLY TEST FOR ONE OF THEM (IMJ).
C
      IF(IMJ.NE.0)GO TO 3
C
C     ALL POSSIBLE CASES HAVE BEEN ELIMINATED.
C
C     ******************************************************************
C     CASE 1, NO OPERATION REQUIRED, INTEGRALS ARE READY FOR TRANS-
C     FORMATION.
C     ******************************************************************
C
C     ******************************************************************
C     CASE 2, ISHELL=JSHELL.
C     ******************************************************************
C
C     TQ CONTAINS (IRANGE*(IRANGE+1))/2 RECTANGULAR MATRICES
C     WITH EACH CONTAINING (LRANGE*KRANGE) INTEGRALS.
C     WE DESIRE TO EXPAND (IJ) THROUGHOUT INTO TQNEW.
C     TO DO THIS, WE FALL BACKWARDS THROUGH TQ.
C     THE PLOY IS AS FOLLOWS,
C        SELECT A PAIR (IJ) IN DECREMENTING MODE.
C        THERE ARE TWO POSSIBILITIES,
C             1. I.GE.J, HERE, THE DESIRED RECTANGULAR ARRAY
C             IS LOCATED IN TQ.
C             IT IS COPIED TO TQNEW IN DESCENDING MODE, USING RUNNING
C             INDICES.
C             2. I.LT.J, HERE, THE DESIRED ARRAY IS ALREADY IN TQNEW.
C             IT IS COPIED, AGAIN IN DESCENDING MODE, TO ITS NEW
C             RESTING PLACE IN TQNEW.
C
C     NOTE THAT IF KSHELL=LSHELL, THIS CASE DEGENRATES TO A SERIES
C     OF SINGLE ELEMENT COPIES.
C
C     BYPASS EXPANSION IF IRANGE=1.
C     SINCE ISHELL=JSHELL, IT IS ONLY NECESSARY TO TEST IRANGE.
C
      IF(IRANGE.EQ.1)GO TO 1000
C
C     PERFORM INITIALIZATION.
C     LWATQ IS PICKED UP FROM INTC   (INDX2).
C     LWATQN IS PICKED UP FROM MEND   (INDX1).
C     THESE ARE MAINTAINED AS RUNNING INDICES.
C     THUS, IN ANY GIVEN PASS, THE ONLY INDEX THAT MUST BE
C     COMPUTED  IS INDX3 (BASED ON IND AND JND).
C
      INDX1=MEND+1
      INDX2=INTC+1
      IND=IEND+1
      DO 350 I=ISTART,IEND
      IND=IND-1
      JND=JEND+1
      DO 350 J=JSTART,JEND
      JND=JND-1
C     NOW HAVE A PAIR (IND,JND).  MAKE TESTS AND BRANCH TO
C     PARTICULAR COPY CODE.
      IF(IND.LT.JND)GO TO 330
C     PREFERRED CASE, IND.GE.JND.
C     HERE, WE COPY FROM TQ TO TQNEW SEQUENTIALLY BACKWARDS.
      DO 320 KL=1,KSL
      INDX1=INDX1-1
      INDX2=INDX2-1
  320 TQNEW(INDX1)=TQ(INDX2)
      GO TO 350
C     JND.GT.IND.
C     HERE, COPY FROM TQNEW TO TQNEW, USING COMPUTED INDEX INDX3.
  330 INDX3=IIND(JND)+JIND(IND)+KSL
      DO 340 KL=1,KSL
      INDX1=INDX1-1
      TQNEW(INDX1)=TQNEW(INDX3)
  340 INDX3=INDX3-1
  350 CONTINUE
      GO TO 1000
C
C     ******************************************************************
C     CASE 3, KSHELL=LSHELL ONLY.
C     ******************************************************************
C
C     CURRENTLY, TQ CONTAINS IRANGE*JRANGE SYMMETRIC MATRICES
C     ((KRANGE*(KRANGE+1))/2 ELEMENTS IN EACH).
C     WE DESIRE TO EXPAND K.GE.L FOR EACH PAIR (IJ) THROUGHOUT.
C     THUS, TQNEW WILL CONTAIN IRANGE*JRANGE SQUARE MATRICES.
C
C     THE TACTIC HERE IS TO FALL BACKWARDS THROUGH ALL PAIRS (IJ)
C     AND TO PERFORM A SIMPLE LINEAR TO SQUARE CONVERSION
C     FOR EACH.
C     THIS PROCESS IS ACCOMPLISHED IN 2 STAGES FOR EACH PAIR (IJ).
C     FIRST, THE EXISTING ELEMENTS OF THE SYMMETRIC MATRIX ARE
C     TRANSFERRED TO THE APPROPRIATE PLACES IN TQNEW.
C     SECOND, THE MATRIX IS EXPANDED TO SQUARE FORM IN PLACE IN
C     TQNEW.
C
C     IN ANY PASS THROUGH THE IJ-LOOP, THE LWATQN FOR THE NTT WORD
C     TRANSFER IS COMPUTED FROM INDX1, A RUNNING INDEX STARTING AT MEND.
C     SIMILARLY, LWATQ IS MAINTAINED IN INDX2, A RUNNING INDEX THAT
C     STARTS AT INTC.
C
C     THIS UNPACK IS BYPASSED IF KRANGE AND LRANGE=1.
C     SINCE KSHELL=LSHELL, IT FOLLOWS THAT KRANGE=LRANGE, AND
C     IT IS SUFFICIENT TO TEST JUST KRANGE.
C
    3 IF(KRANGE.EQ.1)GO TO 1000
C     PERFORM NECESSARY INITIALIZATION.
      NTT=(KRANGE*(KRANGE+1))/2
      KRP1=KRANGE+1
      KRM1=KRANGE-1
      LWATQ=INTC
      LWATQN=MEND
      DO 450 IJ=1,ISJ
      INDX1=LWATQN
      INDX2=LWATQ
      LWATQ=LWATQ-NTT
      LWATQN=LWATQN-KSL
C     PERFORM NTT-WORD TRANSFER.
      DO 420 K=1,KRANGE
      LLIM=KRP1-K
      DO 410 L=1,LLIM
      TQNEW(INDX1)=TQ(INDX2)
      INDX2=INDX2-1
  410 INDX1=INDX1-1
  420 INDX1=INDX1-K
C     PERFORM EXPANSION OF (KL) IN PLACE IN TQNEW.
      INDX1=LWATQN+2
      INDX2=LWATQN+KRP1
      DO 440 K=1,KRM1
C     USE INDS1 AND INDS2 TO PRESERVE INDX1 AND INDX2.
      INDS1=INDX1
      INDS2=INDX2
      KRMK=KRANGE-K
      DO 430 L=1,KRMK
      TQNEW(INDX1)=TQNEW(INDX2)
      INDX1=INDX1+1
  430 INDX2=INDX2+KRANGE
      INDX1=INDS1+KRP1
  440 INDX2=INDS2+KRP1
  450 CONTINUE
      GO TO 1000
C
C     ******************************************************************
C     CASE 4, ISHELL=KSHELL AND JSHELL=LSHELL.
C     ******************************************************************
C
C     THIS CASE (AND ALSO CASE 6) IS SOMEWHAT COMPLICATED AND A
C     SUBSTANTIAL AMOUNT OF OVERHEAD IS INCURRED.
C
C     THE PROCEDURE IS AS FOLLOWS.
C
C     WE STEP BACKWARDS THROUGH (I,J,K,L), USING THE FULL POSSIBLE
C     RANGE.
C     INSIDE THE L-LOOP, THE FOUR INDICES ARE EXAMINED.  THE FOLLOWING
C     LIMITS APPLY TO THE INTEGRALS IN TQ,
C
C        I.GE.K
C        WHEN I=K, J.GE.L
C
C     THE FOUR INDICES ARE TESTED AGAINST THESE CONDITIONS AND
C     EITHER
C
C        1.  THE CONDITIONS ARE MET, IN WHICH CASE, THE NEXT
C            SEQUENTIALLY DECREMENTING INTEGRAL IS COPIED FROM TQ TO
C            TQNEW AND THE APPROPRIATE COUNTERS (INDICES) ARE
C            DECREMENTED.
C
C        2.  THE CONDITIONS ARE NOT SATISFIED.  IN THIS CASE, DUE TO THE
C            NATURE OF THE COPY, THE DESIRED INTEGRAL ALREADY RESIDES
C            IN TQNEW.
C            IT IS TRANSFERRED, AND AGAIN
C            INDEXING IS DONE.
C
C     INDX1 INDEXES IN TQNEW, AND STARTS AT MEND.
C     INDX2 INDEXES IN TQ, AND STARTS AT INTC.
C     INDX3 INDEXES IN TQNEW WHEN COPYING FORM TQNEW TO TQNEW.  THIS
C     INDEX MUST BE COMPUTED.
C
    4 INDX1=MEND
      INDX2=INTC+1
      IND=IEND+1
      DO 560 I=ISTART,IEND
      IND=IND-1
      ITEMP=KIND(IND)-JSTP1
      JND=JEND+1
      DO 560 J=JSTART,JEND
      JND=JND-1
      JTEMP=ITEMP+JND
      KND=KEND+1
      DO 560 K=KSTART,KEND
      KND=KND-1
      KTEMP=JTEMP+IIND(KND)
      LND=LEND+1
      DO 560 L=LSTART,LEND
      LND=LND-1
C     NOW IN L-LOOP, PERFORM TESTS.
      IF(IND-KND)530,520,550
  520 IF(JND.GE.LND)GO TO 550
C     COPY FROM TQNEW TO TQNEW AFTER COMPUTING INDX3.
  530 INDX3=KTEMP+JIND(LND)
      TQNEW(INDX1)=TQNEW(INDX3)
      GO TO 560
C     COPY NEXT SEQUENTIAL INTEGRAL FROM TQ TO TQNEW.
  550 INDX2=INDX2-1
      TQNEW(INDX1)=TQ(INDX2)
  560 INDX1=INDX1-1
      GO TO 1000
C
C     ******************************************************************
C     CASE 5, ISHELL=JSHELL AND KSHELL=LSHELL.
C     ******************************************************************
C
C     THIS CASE IS ESSENTIALLY THE SAME AS CASES 2 AND 3 COMBINED.
C     LWA IN TQ IS MOST CONVENIENTLY SPECIFIED BY INTC (MAINTAINED IN
C     INDX2).
C     LWA IN TQNEW IS IIND(IND)+JIND(JND)+KSL, OR STARTING AT
C     MEND, IT IS DECREMENTED BY KSL ON EACH PASS.
C
C     FOR EACH PAIR (IND,JND) WE EITHER
C        (IND.GE.JND) COPY FROM TQ TO TQNEW AND THEN EXPAND (KL) IN
C                     PLACE IN TQNEW.
C        (IND.LT.JND) COPY (STILL DECREMENTING) DIRECTLY FROM TQNEW
C                     TO TQNEW.
C
C     NOTE THAT IF  KRANGE AND LRANGE ARE 1, AN ALTERNATIVE PROCEDURE
C     MUST BE USED .
C
    5 IF(KRANGE.EQ.1)GO TO 710
      LWATQ=INTC
      LWATQN=MEND
      NTT=(KRANGE*(KRANGE+1))/2
      KRP1=KRANGE+1
      KRM1=KRANGE-1
      IND=IEND+1
      DO 690 I=ISTART,IEND
      IND=IND-1
      JND=JEND+1
      DO 690 J=JSTART,JEND
      JND=JND-1
C     TEST (IND,JND) TO DETERMINE THE ACTION TO BE TAKEN.
      IF(IND.LT.JND)GO TO 670
C     IND.GE.JND, DO AS IN CASE 3.
C     COPY NTT INTEGRALS FROM TQ TO TQNEW WITH CORRECT PLACEMENT.
      INDX2=LWATQ
      INDX1=LWATQN
      LWATQ=LWATQ-NTT
      LWATQN=LWATQN-KSL
      DO 640 K=1,KRANGE
      LLIM=KRP1-K
      DO 630 L=1,LLIM
      TQNEW(INDX1)=TQ(INDX2)
      INDX2=INDX2-1
  630 INDX1=INDX1-1
  640 INDX1=INDX1-K
C     EXECUTE EXPANSION OF (KL).
      INDX1=LWATQN+2
      INDX2=LWATQN+KRP1
      DO 660 K=1,KRM1
      INDS1=INDX1
      INDS2=INDX2
      KRMK=KRANGE-K
      DO 650 L=1,KRMK
      TQNEW(INDX1)=TQNEW(INDX2)
      INDX1=INDX1+1
  650 INDX2=INDX2+KRANGE
      INDX1=INDS1+KRP1
  660 INDX2=INDS2+KRP1
      GO TO 690
C
C     (IND.LT.JND), DESIRED ARRAY ALREADY RESIDES IN TQNEW.
C                   FIND IT AND COPY IT OUT.
C     THIS IS DONE BY COPY SEQUENTIALLY IN REVERSE FROM TQNEW TO
C     TQNEW.
C     INDX1 STEPS INPUT INTO TQNEW.
C     INDX2 STEPS OUTPUT FROM TQNEW.
C     DETERMINE INDX1 FROM LWATQN, AND DECREMENT LWATQN.
C     LWATQN (OUTPUT) IS COMPUTED FROM THE STANDARD INDEXING ARRAYS.
C
  670 INDX1=LWATQN
      LWATQN=LWATQN-KSL
      INDX2=IIND(JND)+JIND(IND)+KSL
C     COPY OVER KL.
      DO 680 KL=1,KSL
      TQNEW(INDX1)=TQNEW(INDX2)
      INDX1=INDX1-1
  680 INDX2=INDX2-1
  690 CONTINUE
      GO TO 1000
C
C     IN CASE 5 (ISHELL=JSHELL AND KSHELL=LSHELL), IT IS NECESSARY
C     TO PROCEED DIFFERENTLY IF KRANGE AND LRANGE EQUAL ONE.
C     IN THIS CASE, WE HAVE WHAT AMOUNTS TO A SYMMETRIC
C     MATRIX IN (IJ).  THE DIMENSION IS EITHER 1, 4 OR 6.
C     IN ANY EVENT, WE MERELY PERFORM A LINEAR TO SQUARE CONVERSION.
C
C     THE LWA IN TQ IS CLEARLY SPECIFIED BY INTC.   (INDX2)
C     THE LWA IN TQNEW IS MEND.   (INDX1)
C
C     IF IRANGE (AND THEREFORE JRANGE) IS ALSO 1, SKIP THE EXPANSION.
C
  710 IF(IRANGE.EQ.1)GO TO 1000
      INDX1=MEND
      INDX2=INTC
      IRP1=IRANGE+1
      IRM1=IRANGE-1
C     ARRANGE THE NTT EXISTING ELEMENTS.
      DO 730 I=1,IRANGE
      JLIM=IRP1-I
      DO 720 J=1,JLIM
      TQNEW(INDX1)=TQ(INDX2)
      INDX2=INDX2-1
  720 INDX1=INDX1-1
  730 INDX1=INDX1-I
C     EXPAND OVER (IJ).
C     THE FWA IS ASSUMED TO BE 1.
      INDX1=2
      INDX2=IRP1
      DO 750 I=1,IRM1
      INDS1=INDX1
      INDS2=INDX2
      IRMI=IRANGE-I
      DO 740 J=1,IRMI
      TQNEW(INDX1)=TQNEW(INDX2)
      INDX1=INDX1+1
  740 INDX2=INDX2+JRANGE
      INDX1=INDS1+IRP1
  750 INDX2=INDS2+IRP1
      GO TO 1000
C
C     ******************************************************************
C     CASE 6, ALL SHELL INDICES ARE EQUAL.
C     ******************************************************************
C
C     THE TECHNIQUES OF CASE 4 ARE EMPLOYED.
C     THIS CASE INVOLVES THE MOST OVERHEAD, BUT IS THE LEAST FRE-
C     QUENTLY EXECUTED PART (LESS THAN OR EQUAL TO NSHELL TIMES
C     PER INTEGRAL EVALUATION).
C
    6 INDX1=MEND
      INDX2=INTC+1
      IND=IEND+1
      DO 890 I=ISTART,IEND
      IND=IND-1
      JND=JEND+1
      DO 890 J=JSTART,JEND
      JND=JND-1
      KND=KEND+1
      DO 890 K=KSTART,KEND
      KND=KND-1
      LND=LEND+1
      DO 890 L=LSTART,LEND
      LND=LND-1
C     NOW HAVE ALL FOUR INDICES (IND,JND,KND,LND).
C     IFLAG IS FOR DETERMINING WHERE TO PULL THE NEXT INTEGRAL FROM.
C     IFLAG=0, INTEGRAL COMES FROM TQNEW.
C     IFLAG=1, INTEGRAL COMES FROM TQ.
C     INDX2 STEPS BACKWARDS THROUGH TQ.  IT IS DECREMENTED ONLY WHEN
C     AN INTEGRAL IS ACTUALLY COPIED.
C     INDX1 STEPS INPUT INTO TQNEW.  IT IS ALWAYS DECREMENTED.
C     INDX3 STEPS OUTPUT FROM TQNEW INTO TQNEW.
C     THIS INDEX IS COMPUTED ON DEMAND.
C     NOTE THAT IN THE FOLLOWING, IND, ETC. ARE SORTED.
      IFLAG=1
      INEW=IND
      JNEW=JND
      KNEW=KND
      LNEW=LND
      IF(INEW.GE.JNEW)GO TO 810
C     SWITCH (IJ), AND SET IFLAG.
      ITEMP=INEW
      INEW=JNEW
      JNEW=ITEMP
      IFLAG=0
C     SWITCH (KL) AND SET IFLAG.
  810 IF(KNEW.GE.LNEW)GO TO 830
      ITEMP=KNEW
      KNEW=LNEW
      LNEW=ITEMP
      IFLAG=0
  830 IF(INEW-KNEW)850,840,860
  840 IF(JNEW.GE.LNEW)GO TO 860
C     SWITCH (IJ) AND (KL) AND SET IFLAG.
  850 ITEMP=INEW
      INEW=KNEW
      KNEW=ITEMP
      ITEMP=JNEW
      JNEW=LNEW
      LNEW=ITEMP
      GO TO 880
  860 IF(IFLAG.EQ.0)GO TO 880
C     COPY FROM TQ TO TQNEW.
      INDX2=INDX2-1
      TQNEW(INDX1)=TQ(INDX2)
      GO TO 890
C     COPY FROM TQNEW TO TQNEW.
  880 INDX3=IIND(INEW)+JIND(JNEW)+KIND(KNEW)+LNEW-LSTP1
      TQNEW(INDX1)=TQ(INDX3)
C     ALWAYS DECREMENT INDX1.
  890 INDX1=INDX1-1
C
C***********************************************************************
C     TRANSFORMATION SECTION.
C***********************************************************************
C
C     WE ARE FINALLY READY TO DO, IN A STEPWISE FASHION, THE 6D TO 5D
C     CONVERSION.  AT THIS POINT, IT IS APPROPRIATE TO CLEAN UP THE
C     NOTATION.
C
C     THE LOOP ORDER IS (OUTERMOST) I, J, K, L (INNERMOST).
C
C     THE I-LOOP GOES OVER THE FUNCTIONS AT CENTER A.
C     THE J-LOOP GOES OVER THE FUNCTIONS AT CENTER B.
C     THE K-LOOP GOES OVER THE FUNCTIONS AT CENTER C.
C     THE L-LOOP GOES OVER THE FUNCTIONS AT CENTER D.
C
C     THE TRANSFORMATION IS DONE STEP-WISE, USING THE FOLLOWING
C     TRANSFORMATION MATRIX,
C
C        ( 1  0  0  0  0  0  0  0  0  0 ) ( S    )   ( S           )
C        (                              ) (      )   (             )
C        ( 0  1  0  0  0  0  0  0  0  0 ) ( X    )   ( X           )
C        (                              ) (      )   (             )
C        ( 0  0  1  0  0  0  0  0  0  0 ) ( Y    )   ( Y           )
C        (                              ) (      )   (             )
C        ( 0  0  0  1  0  0  0  0  0  0 ) ( Z    )   ( Z           )
C        (                              ) (      )   (             )
C        ( 0  0  0  0 -H -H  1  0  0  0 ) ( X**2 ) = ( 3*Z**2-R**2 )
C        (                              ) (      )   (             )
C        ( 0  0  0  0  R -R  0  0  0  0 ) ( Y**2 )   ( X**2-Y**2   )
C        (                              ) (      )   (             )
C        ( 0  0  0  0  0  0  0  1  0  0 ) ( Z**2 )   ( XY          )
C        (                              ) (      )   (             )
C        ( 0  0  0  0  0  0  0  0  1  0 ) ( XY   )   ( XZ          )
C        (                              ) (      )   (             )
C        ( 0  0  0  0  0  0  0  0  0  1 ) ( XZ   )   ( YZ          )
C                                         (      )
C                                         ( YZ   )
C
C     WHERE H=0.5, AND R=SQRT(3.0)/2.0.
C     SINCE THIS TRANSFORMATION IS CLOSE TO AN IDENTITY TRANSFORMATION,
C     ONLY THE REQUIRED STEPS ARE ACTUALLY CARRIED OUT.
C
C     THE NUMBER OF WORDS IN TQNEW IS EQUAL TO (IRANGE*JRANGE*KRANGE*
C     LRANGE).
C
C     ALL FURTHER OPERATIONS TAKE PLACE ENTIRELY IN TQNEW.
C     THE CURRENT ORDER OF FUNCTIONS IS
C
C         1,2,3,4,5,   6,   7,   8, 9, 10
C        (S,X,Y,Z,X**2,Y**2,Z**2,XY,XZ,YZ)
C
C     INITIALIZATION SECTION.
 1000 IEND5D=IEND
      JEND5D=JEND
      KEND5D=KEND
      LEND5D=LEND
      IF(IOP(8).EQ.0)GO TO 1010
C     TRANSFORM 6D TO 5D.
      IF(IT.EQ.2)IEND5D=9
      IF(JT.EQ.2)JEND5D=9
      IF(KT.EQ.2)KEND5D=9
      IF(LT.EQ.2)LEND5D=9
 1010 IRNG5D=IEND5D-ISTP1
      JRNG5D=JEND5D-JSTP1
      KRNG5D=KEND5D-KSTP1
      LRNG5D=LEND5D-LSTP1
      K5SL5=KRNG5D*LRNG5D
      J6K5L5=JRANGE*K5SL5
      J5K5L5=JRNG5D*K5SL5
C     BY-PASS 6D TO 5D TRANSFORMATION IF POSSIBLE.
      IF(IOP(8).EQ.0.OR.NUMD.EQ.0)GO TO 1600
C
C     BYPASS TRANSFORMATION AT CENTERS C AND D IF THERE ARE NO SECOND
C     ORDER FUNCTIONS AT EITHER CENTER.
      IF((KT-2)*(LT-2).NE.0)GO TO 1400
C
C     EXECUTE TRANSFORMATION AT CENTERS C AND D.
C
C     DESCRIPTION OF INDEXING, TRANSFORMATION AT CENTER D (L-INDEX).
C
C        IIND(I)+JIND(J)+KIND(K)
C
C     GIVES THE (FWA-1) OF A VECTOR (OVER L) THAT IS LRANGE WORDS LONG.
C     X**2 CORRESPONDS TO L=5.  THUS, LNEW=5-LSTP1.  HENCE,
C
C        IIND(I)+JIND(J)+KIND(K)+5-LSTP1
C
C     POINTS TO AN X**2 FUNCTION ON CENTER D.  SINCE WE START AT THE
C     BEGINNING, THE INITIAL INDEX IS 5-LSTP1 AND IS SUBSEQUENTLY IN-
C     CREMENTED BY LRANGE.
C
C     DESCRIPTION OF INDEXING, TRANSFORMATION AT CENTER C (K-INDEX).
C
C     THE ARGUMENT IS SIMILAR TO THE ABOVE,
C     INDEXING STARTS AT
C
C        IIND(I)+JIND(J)+KIND(5)+1
C
C     AND IS INCREMENTED BY 1 ON EACH PASS THROUGH THE L-LOOP.
C
C     INDX1 IS USED FOR THE L-TRANSFORMATION.
C     INDX2 IS USED FOR THE K-TRANSFORMATION.
C
C     INITIALIZE INDX1.
      INDX1=5-LSTP1
C     COLLECT FACTORS OF LRANGE.
      LRANG2=LRANGE+LRANGE
      LRANG3=LRANG2+LRANGE
      LRANG4=LRANG3+LRANGE
      LRANG5=LRANG4+LRANGE
      K5P1=KIND(5)+1
C
C     COMMENCE LOOPS OVER THE FUNCTIONS AT CENTERS A AND B.
C
      DO 1140 I=ISTART,IEND
      ITEMP=IIND(I)+K5P1
      DO 1140 J=JSTART,JEND
C     HAVE ONE PAIR (IJ).
C     BYPASS TRANSFORMATION AT D IF POSSIBLE.
      IF(LT.NE.2)GO TO 1120
C     LOOP OVER ALL POSSIBLE VALUES OF K (FUNCTIONS AT CENTER C).
      DO 1110 K=KSTART,KEND
C     HAVE ONE TRIPLE (IJK).
C     DO TRANSFORMATION AT CENTER D FOR THIS TRIPLE.
C     SAVE X**2 AT D.
      TEMP=TQNEW(INDX1)
C     COMPUTE 3*Z**2-R**2 AT D.
      TQNEW(INDX1)=TQNEW(INDX1+2)-PT5*(TEMP+TQNEW(INDX1+1))
C     COMPUTE X**2-Y**2 AT D.
      TEMP=R3OV2*(TEMP-TQNEW(INDX1+1))
C     SHIFT REMAINING FUNCTIONS AT D FOR THIS TRIPLE (IJK).
      TQNEW(INDX1+1)=TQNEW(INDX1+4)
      TQNEW(INDX1+2)=TQNEW(INDX1+5)
      TQNEW(INDX1+4)=TQNEW(INDX1+3)
      TQNEW(INDX1+3)=TEMP
 1110 INDX1=INDX1+LRANGE
C     TRANSFORMATION COMPLETE AT CENTER D FOR THE PAIR (IJ) AND ONE
C     RANGE OF K.
C     THE FUNCTIONS AT D HAVE THE ORDER
C        (S,X,Y,Z,3*Z**2-R**2,XZ,YZ,X**2-Y**2,XY)
C     THE TENTH SLOT IS TO BE CONSIDERED BLANK. (IT IS DONE AWAY
C     WITH LATER).
C
C     BYPASS TRANSFORMATION AT C IF POSSIBLE.
      IF(KT.NE.2)GO TO 1140
C     PERFORM TRANSFORMATION AT C.
C     OBTAIN STARTING INDEX.
 1120 INDX2=JIND(J)+ITEMP
C     LOOP OVER FUNCTIONS AT CENTER D.  HERE, WE NEED ONLY GO UP TO
C     LEND5D.
      DO 1130 L=LSTART,LEND5D
C     HAVE ONE TRIPLE (IJL).
C     DO TRANSFORMATION AT CENTER C.
      TEMP=TQ(INDX2)
      TQNEW(INDX2)=TQNEW(INDX2+LRANG2)-PT5*(TEMP+TQNEW(INDX2+LRANGE))
      TEMP=R3OV2*(TEMP-TQNEW(INDX2+LRANGE))
      TQNEW(INDX2+LRANGE)=TQNEW(INDX2+LRANG4)
      TQNEW(INDX2+LRANG2)=TQNEW(INDX2+LRANG5)
      TQNEW(INDX2+LRANG4)=TQNEW(INDX2+LRANG3)
      TQNEW(INDX2+LRANG3)=TEMP
 1130 INDX2=INDX2+1
 1140 CONTINUE
C     THE ORDER  OF THE FUNCTIONS AT A AND B IS UNCHANGED.
C     THE ORDER OF THE FUNCTIONS AT C AND D IS NOW
C        (S,X,Y,Z,3*Z**2-R**2,XZ,YZ,X**2-Y**2,XY).
C     DUE TO THESE ALTERATIONS, THERE ARE A NUMBER OF GAPS IN TQNEW.
C     THESE GAPS ARE COMPRESSED BEFORE PROCEEDING.
C
C     COMPUTE AUXILLIARY INCREMENTS FOR COMPRESSION.
      LINCR=1
      IF(LT.NE.2)LINCR=0
      KINCR=LRANGE
      IF(KT.NE.2)KINCR=0
C
C     INITIALIZE INDICES.  INDX1 IS FOR COMPRESSED ARRAY.
C     INDX2 COUNTS IN FULL ARRAY.
      INDX1=0
      INDX2=0
C     LOOP OVER COMBINED FUNCTIONS AT A AND B.
      DO 1210 IJ=1,ISJ
C     LOOP OVER 5D FUNCTIONS AT CENTER C.
      DO 1200 K=KSTART,KEND5D
C     LOOP OVER 5D FUNCTIONS AT CENTER D.
      DO 1190 L=LSTART,LEND5D
C     INCREMENT COUNTERS AND COPY.
      INDX1=INDX1+1
      INDX2=INDX2+1
 1190 TQNEW(INDX1)=TQNEW(INDX2)
C     TERMINATE LOOP AT CENTER C BY INCREMENTING INDX2 BY 1 (LT=2)
C     OR 0 (LT.NE.2).
C     THIS STEPS PAST THE EXTRANEOUS FUNCTION AT D.
 1200 INDX2=INDX2+LINCR
C     TERMINATE THE IJ LOOP BY INCREMENTING INDX2 BY LRANGE (KT=2) OR
C     0 (KT.NE.2).
C     THIS STEPS PAST THE FUNCTIONS CORRESPONDING TO K=10 THAT ARE
C     DUPLICATE.
 1210 INDX2=INDX2+KINCR
C     RE-COMPUTE IIND, JIND, AND KIND.
C     BYPASS THE RE-COMPUTATION OF KIND IF POSSIBLE.
      IF(LT.NE.2)GO TO 1250
      ITEMP=0
      DO 1240 K=KSTART,KEND5D
      KIND(K)=ITEMP*LRNG5D
 1240 ITEMP=ITEMP+1
 1250 ITEMP=0
      DO 1260 J=JSTART,JEND
      JIND(J)=ITEMP*K5SL5
 1260 ITEMP=ITEMP+1
      ITEMP=0
      DO 1270 I=ISTART,IEND
      IIND(I)=ITEMP*J6K5L5
 1270 ITEMP=ITEMP+1
C
C     TRANSFORMATION COMPLETE AT CENTERS C AND D.
C     THE ARRAY TQNEW CONTAINS IRANGE*JRANGE*KRNG5D*LRNG5D INTEGRALS.
C     THE ONLY DUPLICATE INTEGRALS CORRESPOND TO SHELL DUPLICATES.
C
C     TRANSFORM THE FUNCTIONS AT CENTER B.
C     HERE WE LOOP OVER ALL I, AND THE PRODUCT OF THE RANGES AT K AND L.
C
C     FORM FACTORS OF KSL.
 1400 K5SL52=K5SL5+K5SL5
      K5SL53=K5SL52+K5SL5
      K5SL54=K5SL53+K5SL5
      K5SL55=K5SL54+K5SL5
C
C     BYAPSS TRANSFORMATION AT CENTER B IF POSSIBLE.
      IF(JT.NE.2)GO TO 1500
C     PERFORM TRANSFORMATION AT CENTER B.
      DO 1430 I=ISTART,IEND
      INDX1=IIND(I)+JIND(5)
      DO 1430 KL=1,K5SL5
C     HAVE ONE PSEUDO-TRIPLE (IKL).  PERFORM TRANSFORMATION AT
C     CENTER B.
      INDX1=INDX1+1
      TEMP=TQNEW(INDX1)
      TQNEW(INDX1)=TQNEW(INDX1+K5SL52)-PT5*(TEMP+TQNEW(INDX1+K5SL5))
      TEMP=R3OV2*(TEMP-TQNEW(INDX1+K5SL5))
      TQNEW(INDX1+K5SL5)=TQNEW(INDX1+K5SL54)
      TQNEW(INDX1+K5SL52)=TQNEW(INDX1+K5SL55)
      TQNEW(INDX1+K5SL54)=TQNEW(INDX1+K5SL53)
 1430 TQNEW(INDX1+K5SL53)=TEMP
C     TRANSFORMATION AT CENTER B IS COMPLETE.
C
C     PASS THROUGH TQNEW AS BEFORE, AND COMPRESS OUT UNNECESSARY
C     INTEGRALS.
C     FOR EACH I, THERE IS A BLOCK (K5SL5 WORDS LONG) AFTER J=9
C     THAT MUST BE COMPRESSED OUT.
C     INDX1 COUNTS IN THE COMPRESSED ARRAY, INDX2 COUNTS IN THE FULL
C     ARRAY.
      INDX1=0
      INDX2=0
C     LOOP OVER FUNCTIONS AT CENTER A.
      DO 1460 I=ISTART,IEND
C     LOOP OVER COMBINED FUNCTIONS AT KL.
      DO 1450 KL=1,J5K5L5
      INDX1=INDX1+1
      INDX2=INDX2+1
 1450 TQNEW(INDX1)=TQNEW(INDX2)
C     INCREMENT COUNTER AN ADDITIONAL K5SL5 AT END OF EACH I-LOOP.
 1460 INDX2=INDX2+K5SL5
C     RE-COMPUTE IIND.
      ITEMP=0
      DO 1470 I=ISTART,IEND
      IIND(I)=ITEMP*J5K5L5
 1470 ITEMP=ITEMP+1
C
C     TRANSFORMATION AND COMPRESSION COMPLETE AT CENTERS B, C, AND D.
C     THE ORDER OF THE FUNCTIONS AT A IS UNCHANGED.
C     THE ORDER OF THE FUNCTIONS AT CENTERS B, C, AND D IS
C        (S,X,Y,Z,3*Z**2-R**2,XZ,YZ,X**2-Y**2,XY)
C     THERE ARE CURRENTLY IRANGE*JRNG5D*KRNG5D*LRNG5D INTEGRALS
C     IN THE ARRAY TQNEW.
C     THE ONLY REDUNDANCIES CORRESPOND TO SHELL DUPLICATES.
C
C     TRANSFORM THE FUNCTIONS AT CENTER A.
C     SKIP THE TRANFORMATION AT CENTER A IF POSSIBLE.
 1500 IF(IT.NE.2)GO TO 1600
C     INITIALIZE INDX1.
      INDX1=IIND(5)
C     FORM FACTORS OF J5K5L5.
      JKL52=J5K5L5+J5K5L5
      JKL53=JKL52+J5K5L5
      JKL54=JKL53+J5K5L5
      JKL55=JKL54+J5K5L5
C     PASS OVER COMBINED FUNCTIONS AT B, C, AND D.
      DO 1520 JKL=1,J5K5L5
      INDX1=INDX1+1
      TEMP=TQNEW(INDX1)
      TQNEW(INDX1)=TQNEW(INDX1+JKL52)-PT5*(TEMP+TQNEW(INDX1+J5K5L5))
      TEMP=R3OV2*(TEMP-TQNEW(INDX1+J5K5L5))
      TQNEW(INDX1+J5K5L5)=TQNEW(INDX1+JKL54)
      TQNEW(INDX1+JKL52)=TQNEW(INDX1+JKL55)
      TQNEW(INDX1+JKL54)=TQNEW(INDX1+JKL53)
 1520 TQNEW(INDX1+JKL53)=TEMP
C
C     TRANSFORMATION AT CENTER A IS COMPLETE.
C     THE ORDERING AT ALL CENTERS IS
C
C        (S,X,Y,Z,3*Z**2-R**2,XZ,YZ,X**2-Y**2,XY).
C
C     NO COMPRESSION IS REQUIRED AFTER THE TRANSFORMATION AT
C     CENTER A.
C     TQNEW CURRENTLY CONTAINS IRNG5D*JRNG5D*KRNG5D*LRNG5D INTEGRALS.
C*
C     UPDATE IRANGE TO LRANGE IN /SHLINF/.
 1600 IRANGE=IRNG5D
      JRANGE=JRNG5D
      KRANGE=KRNG5D
      LRANGE=LRNG5D
      MEND=IRANGE*JRANGE*KRANGE*LRANGE
C     IT IS FINALLY TIME TO GET RID OF THE SHELL DUPLICATES.
C     BYPASS THIS SECTION IF THERE ARE NO SHELL DUPLICATES.
      IF(IMJ*KML*IMKJML.EQ.0)GO TO 1610
      CALL SHLOUTd(MEND,TQNEW,MEND)
      RETURN
C     SHELL DUPLICATES EXIST - COPY UNIQUE INTEGRALS TO TQOUT.
C     AT THIS STAGE, IT IS NECESSARY TO RE-COMPUTE IIND, JIND, AND KIND.
 1610 ITEMP=0
      DO 1620 K=KSTART,KEND5D
      KIND(K)=ITEMP*LRNG5D
 1620 ITEMP=ITEMP+1
      ITEMP=0
      DO 1650 J=JSTART,JEND5D
      JIND(J)=ITEMP*K5SL5
 1650 ITEMP=ITEMP+1
      ITEMP=0
      DO 1680 I=ISTART,IEND5D
      IIND(I)=ITEMP*J5K5L5
 1680 ITEMP=ITEMP+1
C     CLEAR TQOUT.
      DO 1690 I=1,MEND
 1690 TQOUT(I)=ZERO
C
C     LOOP OVER INDICES AND SET SHELL DUPLICATES TO ZERO.
      JLIM=JEND5D
      KLIM=KEND5D
      DO 1770 I=ISTART,IEND5D
      ITEMP=IIND(I)-LSTP1
      IF(IMJ.EQ.0)JLIM=I
      IF(IMKJML.EQ.0)KLIM=I
      DO 1770 J=JSTART,JLIM
      JTEMP=ITEMP+JIND(J)
      DO 1770 K=KSTART,KLIM
      KTEMP=JTEMP+KIND(K)
      LLIM=LEND5D
      IF(KML.EQ.0)LLIM=K
      IF(IMKJML+IABS(I-K).EQ.0)LLIM=J
      DO 1770 L=LSTART,LLIM
      INDX1=KTEMP+L
 1770 TQOUT(INDX1)=TQNEW(INDX1)
      CALL SHLOUTd(MEND,TQOUT,MEND)
      RETURN
      END
      SUBROUTINE FORMP(A,B,I,J,KLMAX)
C
C     --------------------------
C     GAUSSIAN 76 (QCPE VERSION)
C     DECEMBER 1977
C     --------------------------
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/C100/KOPS(2),CFILL1(25)
      COMMON/C100/  SASB,SAPB,SADB,PASB,PAPB,PADB,DASB,DAPB,DADB,
     $              SCSD,SCPD,SCDD,PCSD,PCPD,PCDD,DCSD,DCPD,DCDD
      COMMON/C100/CFILL2(45),ET(35),CFILL3(292),
     1S1,S2,S3,S4,S5,S6,S7,S8,S9,S10,S11,S12,S13,S14,S15,S16,S17,S18,
     2S19,S20,S21,S22,S23,S24,S25,S26,S27,S28,S29,S30,S31,S32,S33,S34,
     3S35,S36,S37,S38,S39,S40,S41,S42,S43,S44,S45,S46,S47,S48,S49,S50,
     4S51,S52,S53,S54,S55,S56,S57,S58,S59,S60,S61,S62,S63,S64,S65,S66,
     5S67,S68,S69,S70,S71,S72,S73,S74,S75,S76,S77,S78,S79,S80,S81,S82,
     6S83,S84,S85,S86,S87,S88,S89,S90,S91,S92,S93,S94,S95,S96,S97,S98,
     7S99,S100,S101,S102,S103,S104,S105,S106,S107,S108,S109,S110,S111
      COMMON/C100/
     8S112,S113,S114,S115,S116,S117,S118,S119,S120,S121,S122,S123,S124,
     9S125,S126,S127,S128,S129,S130,S131,S132,S133,S134,S135,S136,S137,
     AS138,S139,S140,S141,S142,S143,S144,S145,S146,S147,S148,S149,
     BS150,S151,S152,S153,S154,S155,S156,S157,S158,S159,S160,S161,
     CS162,S163,S164,S165,S166,S167,S168,S169,S170,S171,S172,S173,S174,
     DS175,S176,S177,S178,S179,S180,S181,S182,S183,S184,S185,S186,S187,
     ES188,S189,S190,S191,S192,S193,S194,S195,S196,S197
      COMMON/C100/CFILL4(5739)
      DIMENSION A(10),B(10)
      EQUIVALENCE (A1SP,A1SD)
      EQUIVALENCE (B1PS,A1SD)
      EQUIVALENCE (A1PP,A1SD)
      EQUIVALENCE (A1PD,A1PP)
      EQUIVALENCE (A2PD,A2PP)
      EQUIVALENCE (A3PD,A3PP)
      EQUIVALENCE (A4PD,A4PP)
      EQUIVALENCE (B1DB,A1SD)
      EQUIVALENCE (B1DP,A1PP)
      EQUIVALENCE (B3DP,A3PP)
      EQUIVALENCE (B2DP,A2PP)
      EQUIVALENCE (B4DP,A4PP)
      EQUIVALENCE (A1DD,A1PP)
      EQUIVALENCE (A2DD,A2PP)
      EQUIVALENCE (A3DD,A3PP)
      EQUIVALENCE (A4DD,A4PP)
      DATA ZERO/0.0D0/
C*
      GO TO (100,200,300),I
  100 GO TO (110,120,130),J
C     ******************************************************************
C     00  --  SASB
C     ******************************************************************
  110 CONTINUE
      E=A(1)*B(1)*SASB
      ET(1)=E*S1
      IF (KLMAX) 500,510,500
  510 RETURN
  500 CONTINUE
      ET(2)=ZERO
      ET(3)=ZERO
      ET(4)=E*S2
      IF (KLMAX-1) 520,510,520
  520 CONTINUE
      ET(5)=E*S4
      ET(6)=ET(5)
      ET(7)=E*S6
      ET(8)=ZERO
      ET(9)=ZERO
      ET(10)=ZERO
      IF (KLMAX-2) 530,510,530
  530 CONTINUE
      ET(11)=ZERO
      ET(12)=ZERO
      ET(13)=E*S10
      ET(14)=ZERO
      ET(15)=ET(13)
      ET(16)=E*S8
      ET(17)=ZERO
      ET(18)=ZERO
      ET(19)=ZERO
      ET(20)=ZERO
      IF (KLMAX-3) 540,510,540
  540 CONTINUE
      ET(21)=E*S12
      ET(22)=E*S16
      ET(23)=E*S18
      ET(24)=ZERO
      ET(25)=ZERO
      ET(26)=ZERO
      ET(27)=ET(21)
      ET(28)=ET(23)
      ET(29)=ZERO
      ET(30)=E*S14
      ET(31)=ZERO
      ET(32)=ZERO
      ET(33)=ZERO
      ET(34)=ZERO
      ET(35)=ZERO
      RETURN
C     ******************************************************************
C     01  --  SAPB
C     ******************************************************************
  120 CONTINUE
      A1SP=A(1)*SAPB
      E=B(1)*A1SP
      XE=B(2)*A1SP
      YE=B(3)*A1SP
      ZE=B(4)*A1SP
  125 ET(1)=E*S1+ZE*S3
      IF (KLMAX) 550,510,550
  550 CONTINUE
      ET(2)=XE*S20
      ET(3)=YE*S20
      ET(4)=E*S2+ZE*S35
      IF (KLMAX-1) 560,510,560
  560 CONTINUE
      ET(5)=E*S4+ZE*S36
      ET(6)=ET(5)
      ET(7)=E*S6+ZE*S38
      ET(8)=ZERO
      ET(9)=XE*S21
      ET(10)=YE*S21
      IF (KLMAX-2) 570,510,570
  570 CONTINUE
      ET(11)=XE*S23
      ET(12)=YE*S33
      ET(13)=E*S10+ZE*S42
      ET(14)=YE*S23
      ET(15)=ET(13)
      ET(16)=E*S8+ZE*S40
      ET(17)=XE*S33
      ET(18)=ZERO
      ET(19)=XE*S25
      ET(20)=YE*S25
      IF (KLMAX-3) 580,510,580
  580 CONTINUE
      ET(21)=E*S12+ZE*S44
      ET(22)=E*S16+ZE*S48
      ET(23)=E*S18+ZE*S50
      ET(24)=ZERO
      ET(25)=XE*S27
      ET(26)=YE*S31
      ET(27)=ET(21)
      ET(28)=ET(23)
      ET(29)=YE*S27
      ET(30)=E*S14+ZE*S46
      ET(31)=ZERO
      ET(32)=ZERO
      ET(33)=XE*S31
      ET(34)=XE*S29
      ET(35)=YE*S29
      RETURN
C     ******************************************************************
C     02  --  SADB
C     ******************************************************************
  130 CONTINUE
      A1SD=A(1)*SADB
      E=B(1)*A1SD
      XE=B(2)*A1SD
      YE=B(3)*A1SD
      ZE=B(4)*A1SD
      XXE=B(5)*A1SD
      YYE=B(6)*A1SD
      ZZE=B(7)*A1SD
      XYE=B(8)*A1SD
      XZE=B(9)*A1SD
      YZE=B(10)*A1SD
  135 ET(1)=E*S1+ZE*S3+(XXE+YYE)*S5+ZZE*S7
      IF (KLMAX) 590,510,590
  590 CONTINUE
      ET(2)=XE*S20+XZE*S22
      ET(3)=YE*S20+YZE*S22
      ET(4)=E*S2+ZE*S35+(XXE+YYE)*S37+ZZE*S39
      IF (KLMAX-1) 600,510,600
  600 CONTINUE
      ET56=E*S4+ZE*S36+ZZE*S54
      ET(5)=ET56+XXE*S52+YYE*S67
      ET(6)=ET56+YYE*S52+XXE*S67
      ET(7)=E*S6+ZE*S38+(XXE+YYE)*S53+ZZE*S74
      ET(8)=XYE*S87
      ET(9)=XE*S21+XZE*S94
      ET(10)=YE*S21+YZE*S94
      IF (KLMAX-2) 610,510,610
  610 CONTINUE
      ET(11)=XE*S23+XZE*S95
      ET(12)=YE*S33+YZE*S105
      ET13=E*S10+ZE*S42+ZZE*S77
      ET(13)=ET13+XXE*S57+YYE*S68
      ET(14)=YE*S23+YZE*S95
      ET(15)=ET13+YYE*S57+XXE*S68
      ET(16)=E*S8+ZE*S40+(XXE+YYE)*S55+ZZE*S75
      ET(17)=XE*S33+XZE*S105
      ET(18)=XYE*S88
      ET(19)=XE*S25+XZE*S97
      ET(20)=YE*S25+YZE*S97
      IF (KLMAX-3) 620,510,620
  620 CONTINUE
      ET21=E*S12+ZE*S44+ZZE*S79
      ET(21)=ET21+XXE*S59+YYE*S70
      ET(22)=E*S16+ZE*S48+(XXE+YYE)*S63+ZZE*S83
      ET23=E*S18+ZE*S50+ZZE*S85
      ET(23)=ET23+XXE*S65+YYE*S72
      ET(24)=XYE*S90
      ET(25)=XE*S27+XZE*S99
      ET(26)=YE*S31+YZE*S103
      ET(27)=ET21+YYE*S59+XXE*S70
      ET(28)=ET23+YYE*S65+XXE*S72
      ET(29)=YE*S27+YZE*S99
      ET(30)=E*S14+ZE*S46+(XXE+YYE)*S61+ZZE*S81
      ET(31)=XYE*S90
      ET(32)=XYE*S92
      ET(33)=XE*S31+XZE*S103
      ET(34)=XE*S29+XZE*S101
      ET(35)=YE*S29+YZE*S101
      RETURN
  200 GO TO (210,220,230),J
C     ******************************************************************
C     10  --  PASB
C     ******************************************************************
  210 CONTINUE
      B1PS=B(1)*PASB
      E=A(1)*B1PS
      XE=A(2)*B1PS
      YE=A(3)*B1PS
      ZE=A(4)*B1PS
      GO TO 125
C     ******************************************************************
C     11  --  PAPB
C     ******************************************************************
  220 CONTINUE
      A1PP=A(1)*PAPB
      A2PP=A(2)*PAPB
      A3PP=A(3)*PAPB
      A4PP=A(4)*PAPB
      E=A1PP*B(1)
      XE=A1PP*B(2)+A2PP*B(1)
      YE=A1PP*B(3)+A3PP*B(1)
      ZE=A1PP*B(4)+A4PP*B(1)
      XXE=A2PP*B(2)
      YYE=A3PP*B(3)
      ZZE=A4PP*B(4)
      XYE=A2PP*B(3)+A3PP*B(2)
      XZE=A2PP*B(4)+A4PP*B(2)
      YZE=A3PP*B(4)+A4PP*B(3)
      GO TO 135
C     ******************************************************************
C     12  --  PADB
C     ******************************************************************
  230 CONTINUE
      A1PD=A(1)*PADB
      A2PD=A(2)*PADB
      A3PD=A(3)*PADB
      A4PD=A(4)*PADB
      E=A1PD*B(1)
      XE=A1PD*B(2)+A2PD*B(1)
      YE=A1PD*B(3)+A3PD*B(1)
      ZE=A1PD*B(4)+A4PD*B(1)
      XXE=A1PD*B(5)+A2PD*B(2)
      YYE=A1PD*B(6)+A3PD*B(3)
      ZZE=A1PD*B(7)+A4PD*B(4)
      XYE=A1PD*B(8)+A3PD*B(2)+A2PD*B(3)
      XZE=A1PD*B(9)+A4PD*B(2)+A2PD*B(4)
      YZE=A1PD*B(10)+A4PD*B(3)+A3PD*B(4)
      XXXE=A2PD*B(5)
      XXYE=A3PD*B(5)+A2PD*B(8)
      XXZE=A4PD*B(5)+A2PD*B(9)
      YYYE=A3PD*B(6)
      YYZE=A4PD*B(6)+A3PD*B(10)
      ZZZE=A4PD*B(7)
      XYYE=A3PD*B(8)+A2PD*B(6)
      XYZE=A4PD*B(8)+A3PD*B(9)+A2PD*B(10)
      XZZE=A4PD*B(9)+A2PD*B(7)
      YZZE=A4PD*B(10)+A3PD*B(7)
  235 ET(1)=E*S1+ZE*S3+(XXE+YYE)*S5+ZZE*S7+ZZZE*S9+(XXZE+YYZE)*S11
      IF (KLMAX) 630,510,630
  630 CONTINUE
      ET(2)=XE*S20+XZE*S22+XXXE*S24+XZZE*S26+XYYE*S34
      ET(3)=YE*S20+YZE*S22+YYYE*S24+YZZE*S26+XXYE*S34
      ET(4)=E*S2+ZE*S35+(XXE+YYE)*S37+ZZE*S39+ZZZE*S41+(XXZE+YYZE)*S43
      IF (KLMAX-1) 640,510,640
  640 CONTINUE
      ET5=E*S4+ZE*S36+ZZE*S54+ZZZE*S56
      ET(5)=ET5+XXE*S52+XXZE*S58+YYE*S67+YYZE*S69
      ET(6)=ET5+YYE*S52+YYZE*S58+XXE*S67+XXZE*S69
      ET(7)=E*S6+ZE*S38+(XXE+YYE)*S53+ZZE*S74+ZZZE*S76+(XXZE+YYZE)*S78
      ET(8)=XYE*S87+XYZE*S89
      ET(9)=XE*S21+XZE*S94+XXXE*S96+XZZE*S98+XYYE*S106
      ET(10)=YE*S21+YZE*S94+YYYE*S96+YZZE*S98+XXYE*S106
      IF (KLMAX-2) 650,510,650
  650 CONTINUE
      ET(11)=XE*S23+XZE*S95+XXXE*S107+XZZE*S109+XYYE*S117
      ET(12)=YE*S33+YZE*S105+YYYE*S116+XXYE*S129+YZZE*S135
      ET13=E*S10+ZE*S42+ZZE*S77+ZZZE*S119
      ET(13)=ET13+XXE*S57+YYE*S68+XXZE*S138+YYZE*S147
      ET(14)=YE*S23+YZE*S95+YYYE*S107+YZZE*S109+XXYE*S117
      ET(15)=ET13+YYE*S57+XXE*S68+YYZE*S138+XXZE*S147
      ET(16)=E*S8+ZE*S40+(XXE+YYE)*S55+ZZE*S75+ZZZE*S118+(XXZE+YYZE)*S12
     10
      ET(17)=XE*S33+XZE*S105+XXXE*S116+XYYE*S129+XZZE*S135
      ET(18)=XYE*S88+XYZE*S159
      ET(19)=XE*S25+XZE*S97+XXXE*S108+XYYE*S134+XZZE*S152
      ET(20)=YE*S25+YZE*S97+YYYE*S108+XXYE*S134+YZZE*S152
      IF (KLMAX-3) 660,510,660
  660 CONTINUE
      ET21=E*S12+ZE*S44+ZZE*S79+ZZZE*S121
      ET(21)=ET21+XXE*S59+YYE*S70+XXZE*S139+YYZE*S148
      ET(22)=E*S16+ZE*S48+(XXE+YYE)*S63+ZZE*S83+ZZZE*S125+(XXZE+YYZE)*S1
     143
      ET23=E*S18+ZE*S50+ZZE*S85+ZZZE*S127
      ET(23)=ET23+XXE*S65+YYE*S72+XXZE*S145+YYZE*S150
      ET(24)=XYE*S90+XYZE*S160
      ET(25)=XE*S27+XZE*S99+XXXE*S110+XYYE*S132+XZZE*S153
      ET(26)=YE*S31+YZE*S103+YYYE*S114+XXYE*S130+YZZE*S157
      ET(27)=ET21+YYE*S59+XXE*S70+YYZE*S139+XXZE*S148
      ET(28)=ET23+YYE*S65+XXE*S72+YYZE*S145+XXZE*S150
      ET(29)=YE*S27+YZE*S99+YYYE*S110+YZZE*S153
     $+XXYE*S132
      ET(30)=E*S14+ZE*S46+(XXE+YYE)*S61+ZZE*S81+ZZZE*S123+(XXZE+YYZE)*S1
     141
      ET(31)=XYE*S90+XYZE*S160
      ET(32)=XYE*S92+XYZE*S162
      ET(33)=XE*S31+XZE*S103+XXXE*S114+XYYE*S130+XZZE*S157
      ET(34)=XE*S29+XZE*S101+XXXE*S112+XYYE*S136+XZZE*S155
      ET(35)=YE*S29+YZE*S101+YYYE*S112+XXYE*S136+YZZE*S155
      RETURN
  300 GO TO (310,320,330),J
C     ******************************************************************
C     20  --  DS
C     ******************************************************************
  310 CONTINUE
      B1DB=B(1)*DASB
      E=A(1)*B1DB
      XE=A(2)*B1DB
      YE=A(3)*B1DB
      ZE=A(4)*B1DB
      XXE=A(5)*B1DB
      YYE=A(6)*B1DB
      ZZE=A(7)*B1DB
      XYE=A(8)*B1DB
      XZE=A(9)*B1DB
      YZE=A(10)*B1DB
      GO TO 135
C     ******************************************************************
C     21  --  DP
C     ******************************************************************
  320 CONTINUE
      B1DP=B(1)*DAPB
      B2DP=B(2)*DAPB
      B3DP=B(3)*DAPB
      B4DP=B(4)*DAPB
      E=A(1)*B1DP
      XE=A(1)*B2DP+A(2)*B1DP
      YE=A(1)*B3DP+A(3)*B1DP
      ZE=A(1)*B4DP+A(4)*B1DP
      XXE=A(2)*B2DP+A(5)*B1DP
      YYE=A(3)*B3DP+A(6)*B1DP
      ZZE=A(4)*B4DP+A(7)*B1DP
      XYE=A(3)*B2DP+A(2)*B3DP+A(8)*B1DP
      XZE=A(4)*B2DP+A(2)*B4DP+A(9)*B1DP
      YZE=A(4)*B3DP+A(3)*B4DP+A(10)*B1DP
      XXXE=A(5)*B2DP
      XXYE=A(8)*B2DP+A(5)*B3DP
      XXZE=A(9)*B2DP+A(5)*B4DP
      YYYE=A(6)*B3DP
      YYZE=A(10)*B3DP+A(6)*B4DP
      ZZZE=A(7)*B4DP
      XYYE=A(6)*B2DP+A(8)*B3DP
      XYZE=A(10)*B2DP+A(9)*B3DP+A(8)*B4DP
      XZZE=A(7)*B2DP+A(9)*B4DP
      YZZE=A(7)*B3DP+A(10)*B4DP
      GO TO 235
C     ******************************************************************
C     22  --  DD
C     ******************************************************************
  330 CONTINUE
      A1DD=A(1)*DADB
      A2DD=A(2)*DADB
      A3DD=A(3)*DADB
      A4DD=A(4)*DADB
      A5DD=A(5)*DADB
      A6DD=A(6)*DADB
      A7DD=A(7)*DADB
      A8DD=A(8)*DADB
      A9DD=A(9)*DADB
      A10DD=A(10)*DADB
      E=A1DD*B(1)
      ZE=A1DD*B(4)+A4DD*B(1)
      XXE=A1DD*B(5)+A2DD*B(2)+A5DD*B(1)
      YYE=A1DD*B(6)+A3DD*B(3)+A6DD*B(1)
      ZZE=A1DD*B(7)+A4DD*B(4)+A7DD*B(1)
      XXZE=A4DD*B(5)+A2DD*B(9)+A9DD*B(2)+A5DD*B(4)
      YYZE=A4DD*B(6)+A3DD*B(10)+A10DD*B(3)+A6DD*B(4)
      ZZZE=A4DD*B(7)+A7DD*B(4)
      XXXXE=A5DD*B(5)
      XXYYE=A6DD*B(5)+A8DD*B(8)+A5DD*B(6)
      XXZZE=A7DD*B(5)+A9DD*B(9)+A5DD*B(7)
      YYYYE=A6DD*B(6)
      YYZZE=A7DD*B(6)+A10DD*B(10)+A6DD*B(7)
      ZZZZE=A7DD*B(7)
      ET(1)=E*S1+ZE*S3+(XXE+YYE)*S5+ZZE*S7+ZZZE*S9+(XXZE+YYZE)*S11+(XXXX
     1E+YYYYE)*S13+ZZZZE*S15+XXYYE*S17+(XXZZE+YYZZE)*S19
      IF (KLMAX) 670,510,670
  670 CONTINUE
      XE=A1DD*B(2)+A2DD*B(1)
      YE=A1DD*B(3)+A3DD*B(1)
      XZE=A1DD*B(9)+A4DD*B(2)+A2DD*B(4)+A9DD*B(1)
      YZE=A1DD*B(10)+A4DD*B(3)+A3DD*B(4)+A10DD*B(1)
      XXXE=A2DD*B(5)+A5DD*B(2)
      XXYE=A3DD*B(5)+A2DD*B(8)+A8DD*B(2)+A5DD*B(3)
      YYYE=A3DD*B(6)+A6DD*B(3)
      XYYE=A3DD*B(8)+A6DD*B(2)+A2DD*B(6)+A8DD*B(3)
      XZZE=A4DD*B(9)+A7DD*B(2)+A2DD*B(7)+A9DD*B(4)
      YZZE=A4DD*B(10)+A7DD*B(3)+A3DD*B(7)+A10DD*B(4)
      XXXZE=A9DD*B(5)+A5DD*B(9)
      XXYZE=A10DD*B(5)+A9DD*B(8)+A8DD*B(9)+A5DD*B(10)
      YYYZE=A10DD*B(6)+A6DD*B(10)
      XYYZE=A10DD*B(8)+A6DD*B(9)+A9DD*B(6)+A8DD*B(10)
      XZZZE=A7DD*B(9)+A9DD*B(7)
      YZZZE=A7DD*B(10)+A10DD*B(7)
      ET(2)=XE*S20+XZE*S22+XXXE*S24+XZZE*S26+XXXZE*S28+XZZZE*S30+XYYZE*S
     132+XYYE*S34
      ET(3) =YE*S20+YZE*S22+YYYE*S24+YZZE*S26+YYYZE*S28+YZZZE*S30+XXYZE*
     1S32+XXYE*S34
      ET(4)=E*S2+ZE*S35+(XXE+YYE)*S37+ZZE*S39+ZZZE*S41+(XXZE+YYZE)*S43+
     1(XXXXE+YYYYE)*S45+ZZZZE*S47+XXYYE*S49+(XXZZE+YYZZE)*S51
      IF (KLMAX-1) 680,510,680
  680 CONTINUE
      XYE=A1DD*B(8)+A3DD*B(2)+A2DD*B(3)+A8DD*B(1)
      XYZE=A4DD*B(8)+A3DD*B(9)+A10DD*B(2)+A2DD*B(10)+A9DD*B(3)+A8DD*B(4)
      XXXYE=A8DD*B(5)+A5DD*B(8)
      XYZZE=A7DD*B(8)+A10DD*B(9)+A9DD*B(10)+A8DD*B(7)
      XYYYE=A6DD*B(8)+A8DD*B(6)
      ET5=E*S4+ZE*S36+ZZE*S54+ZZZE*S56+ZZZZE*S62
      ET(5)=ET5+XXE*S52+XXZE*S58+XXXXE*S60+XXYYE*S64+XXZZE*S66+YYE*S67+
     1YYZE*S69+ YYYYE*S71+YYZZE*S73
      ET(6)=ET5+YYE*S52+YYZE*S58+YYYYE*S60+XXYYE*S64+YYZZE*S66+XXE*S67+
     1XXZE*S69+XXXXE*S71+XXZZE*S73
      ET(7)=E*S6+ZE*S38+(XXE+YYE)*S53+ZZE*S74+ZZZE*S76+(XXZE+YYZE)*S78+
     1(XXXXE+YYYYE)*S80+ZZZZE*S82+XXYYE*S84+(XXZZE+YYZZE)*S86
      ET(8)=XYE*S87+XYZE*S89+XXXYE*S91+XYYYE*S91+XYZZE*S93
      ET(9)=XE*S21+XZE*S94+XXXE*S96+XZZE*S98+XXXZE*S100+XZZZE*S102+XYYZE
     1*S104+XYYE*S106
      ET(10)=YE*S21+YZE*S94+YYYE*S96+YZZE*S98+YYYZE*S100+YZZZE*S102+XXYZ
     1E*S104+XXYE*S106
      IF (KLMAX-2) 690,510,690
  690 CONTINUE
      ET(11)=XE*S23+XZE*S95+XXXE*S107+XZZE*S109+XXXZE*S111+XZZZE*S113+XY
     1YZE*S115+XYYE*S117
      ET(12)=YE*S33+YZE*S105+YYYE*S116+XXYE*S129+XXYZE*S131+YYYZE*S133+Y
     1ZZE*S135+YZZZE*S137
      ET13=E*S10+ZE*S42+ZZE*S77+ZZZE*S119+ZZZZE*S142
      ET(13)=ET13+XXE*S57+YYE*S68+XXZE*S138+XXXXE*S140+XXYYE*S144+XXZZE*
     1S146+YYZE*S147+YYYYE*S149+YYZZE*S151
      ET(14)=YE*S23+YZE*S95+YYYE*S107+YZZE*S109+ YYYZE*S111+YZZZE*S113+
     1XXYZE*S115+XXYE*S117
      ET(15)=ET13+YYE*S57+XXE*S68+YYZE*S138+YYYYE*S140+XXYYE*S144+YYZZE*
     1S146+XXZE*S147+XXXXE*S149+XXZZE*S151
      ET(16)=E*S8+ZE*S40+(XXE+YYE)*S55+ZZE*S75+ZZZE*S118+(XXZE+YYZE)*S12
     10+(XXXXE+YYYYE)*S122+ZZZZE*S124+XXYYE*S126+(XXZZE+YYZZE)*S128
      ET(17)=XE*S33+XZE*S105+XXXE*S116+XYYE*S129+XYYZE*S131+XXXZE*S133+X
     1ZZE*S135+XZZZE*S137
      ET(18)=XYE*S88+XYZE*S159+(XXXYE+XYYYE)*S161+XYZZE*S163
      ET(19)=XE*S25+XZE*S97+XXXE*S108+XYYE*S134+XZZE*S152+XXXZE*S154+XZZ
     1ZE*S156+XYYZE*S158
      ET(20)=YE*S25+YZE*S97+YYYE*S108+XXYE*S134+YZZE*S152+YYYZE*S154+YZZ
     1ZE*S156+XXYZE*S158
      IF (KLMAX-3) 700,510,700
  700 CONTINUE
      ET(21)=E*S12+ZE*S44+XXE*S59+YYE*S70+ZZE*S79+ZZZE*S121+XXZE*S139+YY
     1ZE*S148+XXXXE*S164+ZZZZE*S166+XXYYE*S168+XXZZE*S170+YYYYE*S171+YYZ
     2ZE*S173
      ET(22)=E*S16+ZE*S48+(XXE+YYE)*S63+ZZE*S83+ZZZE*S125+(XXZE+YYZE)*S1
     143+(XXXXE+YYYYE)*S167+ZZZZE*S175+XXYYE*S191+(XXZZE+YYZZE)*S193
      ET(23)=E*S18+ZE*S50+XXE*S65+YYE*S72+ZZE*S85+ZZZE*S127+XXZE*S145+YY
     1ZE*S150+XXXXE*S169+YYYYE*S172+ZZZZE*S177+XXYYE*S192+XXZZE*S194+YYZ
     2ZE*S195
      ET(24)=XYE*S90+XYZE*S160+XXXYE*S179+XYZZE*S181+XYYYE*S182
      ET(25)=XE*S27+XZE*S99+XXXE*S110+XYYE*S132+XZZE*S153+XXXZE*S183+XZZ
     1ZE*S185+XYYZE*S187
      ET(26)=YE*S31+YZE*S103+YYYE*S114+XXYE*S130+YZZE*S157+YYYZE*S186+YZ
     1ZZE*S189+XXYZE*S196
      ET(27)=E*S12+ZE*S44+YYE*S59+XXE*S70+ZZE*S79+ZZZE*S121+YYZE*S139+XX
     1ZE*S148+YYYYE*S164+ZZZZE*S166+XXYYE*S168+YYZZE*S170+XXXXE*S171+XXZ
     2ZE*S173
      ET(28)=E*S18+ZE*S50+YYE*S65+XXE*S72+ZZE*S85+ZZZE*S127+YYZE*S145+XX
     1ZE*S150+YYYYE*S169+XXXXE*S172+ZZZZE*S177+XXYYE*S192+YYZZE*S194+XXZ
     2ZE*S195
      ET(29)=YE*S27+YZE*S99+YYYE*S110+YZZE*S153+YYYZE*S183+YZZZE*S185+XX
     1YZE*S187
     $+XXYE*S132
      ET(30)=E*S14+ZE*S46+(XXE+YYE)*S61+ZZE*S81+ZZZE*S123+(XXZE+YYZE)*S1
     141+(XXXXE+YYYYE)*S165+ZZZZE*S174+XXYYE*S176+(XXZZE+YYZZE)*S178
      ET(31)=XYE*S90+XYZE*S160+XYYYE*S179+XYZZE*S181+XXXYE*S182
      ET(32)=XYE*S92+XYZE*S162+(XXXYE+XYYYE)*S180+XYZZE*S197
      ET(33)=XE*S31+XZE*S103+XXXE*S114+XYYE*S130+XZZE*S157+XXX
     1ZE*S186+XZZZE*S189+XYYZE*S196
      ET(34)=XE*S29+XZE*S101+XXXE*S112+XYYE*S136+XZZE*S155+XXXZE*S184+XZ
     1ZZE*S188+XYYZE*S190
      ET(35)=YE*S29+YZE*S101+YYYE*S112+XXYE*S136+YZZE*S155+YYYZE*S184+YZ
     1ZZE*S188+XXYZE*S190
      RETURN
      END
      SUBROUTINE FORMQ(C,D,FT,K,L)
C
C     --------------------------
C     GAUSSIAN 76 (QCPE VERSION)
C     DECEMBER 1977
C     --------------------------
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/C100/KOPS(2),CFILL1(25)
      COMMON/C100/  SASB,SAPB,SADB,PASB,PAPB,PADB,DASB,DAPB,DADB,
     $              SCSD,SCPD,SCDD,PCSD,PCPD,PCDD,DCSD,DCPD,DCDD
      COMMON/C100/CFILL2(6308)
      DIMENSION C(10),D(10),FT(35)
C
      GO TO (100,200,300),K
C
  100 GO TO (110,120,130),L
C     ******************************************************************
C     00
C     ******************************************************************
  110 FT(1)=C(1)*D(1)*SCSD
      RETURN
C     ******************************************************************
C     01
C     ******************************************************************
  120 CONTINUE
      C1SP=C(1)*SCPD
      FT(1)=C1SP*D(1)
      FT(2)=C1SP*D(2)
      FT(3)=C1SP*D(3)
      FT(4)=C1SP*D(4)
      RETURN
C     ******************************************************************
C     02
C     ******************************************************************
  130 CONTINUE
      C1SD=C(1)*SCDD
      FT(1)=C1SD*D(1)
      FT(2)=C1SD*D(2)
      FT(3)=C1SD*D(3)
      FT(4)=C1SD*D(4)
      FT(5)=C1SD*D(5)
      FT(6)=C1SD*D(6)
      FT(7)=C1SD*D(7)
      FT(8)=C1SD*D(8)
      FT(9)=C1SD*D(9)
      FT(10)=C1SD*D(10)
      RETURN
  200 GO TO (210,220,230),L
C     ******************************************************************
C     10
C     ******************************************************************
  210 CONTINUE
      D1PD=D(1)*PCSD
      FT(1)=C(1)*D1PD
      FT(2)=C(2)*D1PD
      FT(3)=C(3)*D1PD
      FT(4)=C(4)*D1PD
      RETURN
C     ******************************************************************
C     11
C     ******************************************************************
  220 CONTINUE
      C1PP=C(1)*PCPD
      C2PP=C(2)*PCPD
      C3PP=C(3)*PCPD
      C4PP=C(4)*PCPD
      FT(1)=C1PP*D(1)
      FT(2)=C1PP*D(2)+C2PP*D(1)
      FT(3)=C1PP*D(3)+C3PP*D(1)
      FT(4)=C1PP*D(4)+C4PP*D(1)
      FT(5)=C2PP*D(2)
      FT(6)=C3PP*D(3)
      FT(7)=C4PP*D(4)
      FT(8)=C3PP*D(2)+C2PP*D(3)
      FT(9)=C4PP*D(2)+C2PP*D(4)
      FT(10)=C4PP*D(3)+C3PP*D(4)
      RETURN
C     ******************************************************************
C     12
C     ******************************************************************
  230 CONTINUE
      C1PD=C(1)*PCDD
      C2PD=C(2)*PCDD
      C3PD=C(3)*PCDD
      C4PD=C(4)*PCDD
      FT(1)=C1PD*D(1)
      FT(2)=C1PD*D(2)+C2PD*D(1)
      FT(3)=C1PD*D(3)+C3PD*D(1)
      FT(4)=C1PD*D(4)+C4PD*D(1)
      FT(5)=C1PD*D(5)+C2PD*D(2)
      FT(6)=C1PD*D(6)+C3PD*D(3)
      FT(7)=C1PD*D(7)+C4PD*D(4)
      FT(8)=C1PD*D(8)+C3PD*D(2)+C2PD*D(3)
      FT(9)=C1PD*D(9)+C4PD*D(2)+C2PD*D(4)
      FT(10)=C1PD*D(10)+C4PD*D(3)+C3PD*D(4)
      FT(11)=C2PD*D(5)
      FT(12)=C3PD*D(5)+C2PD*D(8)
      FT(13)=C4PD*D(5)+C2PD*D(9)
      FT(14)=C3PD*D(6)
      FT(15)=C4PD*D(6)+C3PD*D(10)
      FT(16)=C4PD*D(7)
      FT(17)=C3PD*D(8)+C2PD*D(6)
      FT(18)=C4PD*D(8)+C3PD*D(9)+C2PD*D(10)
      FT(19)=C4PD*D(9)+C2PD*D(7)
      FT(20)=C4PD*D(10)+C3PD*D(7)
      RETURN
  300 GO TO (310,320,330),L
C     ******************************************************************
C     20
C     ******************************************************************
  310 CONTINUE
      D1DS=D(1)*DCSD
      FT(1)=C(1)*D1DS
      FT(2)=C(2)*D1DS
      FT(3)=C(3)*D1DS
      FT(4)=C(4)*D1DS
      FT(5)=C(5)*D1DS
      FT(6)=C(6)*D1DS
      FT(7)=C(7)*D1DS
      FT(8)=C(8)*D1DS
      FT(9)=C(9)*D1DS
      FT(10)=C(10)*D1DS
      RETURN
C     ******************************************************************
C     21
C     ******************************************************************
  320 CONTINUE
      D1DP=D(1)*DCPD
      D2DP=D(2)*DCPD
      D3DP=D(3)*DCPD
      D4DP=D(4)*DCPD
      FT(1)=C(1)*D1DP
      FT(2)=C(1)*D2DP+C(2)*D1DP
      FT(3)=C(1)*D3DP+C(3)*D1DP
      FT(4)=C(1)*D4DP+C(4)*D1DP
      FT(5)=C(2)*D2DP+C(5)*D1DP
      FT(6)=C(3)*D3DP+C(6)*D1DP
      FT(7)=C(4)*D4DP+C(7)*D1DP
      FT(8)=C(3)*D2DP+C(2)*D3DP+C(8)*D1DP
      FT(9)=C(4)*D2DP+C(2)*D4DP+C(9)*D1DP
      FT(10)=C(4)*D3DP+C(3)*D4DP+C(10)*D1DP
      FT(11)=C(5)*D2DP
      FT(12)=C(8)*D2DP+C(5)*D3DP
      FT(13)=C(9)*D2DP+C(5)*D4DP
      FT(14)=C(6)*D3DP
      FT(15)=C(10)*D3DP+C(6)*D4DP
      FT(16)=C(7)*D4DP
      FT(17)=C(6)*D2DP+C(8)*D3DP
      FT(18)=C(10)*D2DP+C(9)*D3DP+C(8)*D4DP
      FT(19)=C(7)*D2DP+C(9)*D4DP
      FT(20)=C(7)*D3DP+C(10)*D4DP
      RETURN
C     ******************************************************************
C     22
C     ******************************************************************
  330 CONTINUE
      C1DD=C(1)*DCDD
      C2DD=C(2)*DCDD
      C3DD=C(3)*DCDD
      C4DD=C(4)*DCDD
      C5DD=C(5)*DCDD
      C6DD=C(6)*DCDD
      C7DD=C(7)*DCDD
      C8DD=C(8)*DCDD
      C9DD=C(9)*DCDD
      C10DD=C(10)*DCDD
      FT(1)=C1DD*D(1)
      FT(2)=C1DD*D(2)+C2DD*D(1)
      FT(3)=C1DD*D(3)+C3DD*D(1)
      FT(4)=C1DD*D(4)+C4DD*D(1)
      FT(5)=C1DD*D(5)+C2DD*D(2)+C5DD*D(1)
      FT(6)=C1DD*D(6)+C3DD*D(3)+C6DD*D(1)
      FT(7)=C1DD*D(7)+C4DD*D(4)+C7DD*D(1)
      FT(8)=C1DD*D(8)+C3DD*D(2)+C2DD*D(3)+C8DD*D(1)
      FT(9)=C1DD*D(9)+C4DD*D(2)+C2DD*D(4)+C9DD*D(1)
      FT(10)=C1DD*D(10)+C4DD*D(3)+C3DD*D(4)+C10DD*D(1)
      FT(11)=C2DD*D(5)+C5DD*D(2)
      FT(12)=C3DD*D(5)+C2DD*D(8)+C8DD*D(2)+C5DD*D(3)
      FT(13)=C4DD*D(5)+C2DD*D(9)+C9DD*D(2)+C5DD*D(4)
      FT(14)=C3DD*D(6)+C6DD*D(3)
      FT(15)=C4DD*D(6)+C3DD*D(10)+C10DD*D(3)+C6DD*D(4)
      FT(16)=C4DD*D(7)+C7DD*D(4)
      FT(17)=C3DD*D(8)+C6DD*D(2)+C2DD*D(6)+C8DD*D(3)
      FT(18)=C4DD*D(8)+C3DD*D(9)+C10DD*D(2)+C2DD*D(10)+C9DD*D(3)
     $+C8DD*D(4)
      FT(19)=C4DD*D(9)+C7DD*D(2)+C2DD*D(7)+C9DD*D(4)
      FT(20)=C4DD*D(10)+C7DD*D(3)+C3DD*D(7)+C10DD*D(4)
      FT(21)=C5DD*D(5)
      FT(22)=C6DD*D(5)+C8DD*D(8)+C5DD*D(6)
      FT(23)=C7DD*D(5)+C9DD*D(9)+C5DD*D(7)
      FT(24)=C8DD*D(5)+C5DD*D(8)
      FT( 25)=C9DD*D(5)+C5DD*D(9)
      FT(26)=C10DD*D(5)+C9DD*D(8)+C8DD*D(9)+C5DD*D(10)
      FT(27)=C6DD*D(6)
      FT(28)=C7DD*D(6)+C10DD*D(10)+C6DD*D(7)
      FT(29)=C10DD*D(6)+C6DD*D(10)
      FT(30)=C7DD*D(7)
      FT(31)=C6DD*D(8)+C8DD*D(6)
      FT(32)=C7DD*D(8)+C10DD*D(9)+C9DD*D(10)+C8DD*D(7)
      FT(33)=C10DD*D(8)+C6DD*D(9)+C9DD*D(6)+C8DD*D(10)
      FT(34)=C7DD*D(9)+C9DD*D(7)
      FT(35)=C7DD*D(10)+C10DD*D(7)
      RETURN
      END
      SUBROUTINE FABCD(A,XYZA,XYZP,LIMIT)
C
C     --------------------------
C     GAUSSIAN 76 (QCPE VERSION)
C     DECEMBER 1977
C     --------------------------
C
C     ROTATION AND SPLITTING MATRIX  --  CODED OCTOBER 4, 1972
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/C100/KOPS(2),CFILL1(43),R(3,3),D(6,6),CFILL2(6263)
      DIMENSION A(73),XYZA(3),XYZP(3)
      DATA ONE/1.0D0/
C     ******************************************************************
C     S
C     ******************************************************************
      A(1)=ONE
      IF (LIMIT) 100,110,100
  110 RETURN
  100 CONTINUE
C     ******************************************************************
C     X
C     ******************************************************************
      APX=XYZP(1)-XYZA(1)
      A(2)=APX
      A(3)=R(1,1)
      A(4)=R(2,1)
      A(5)=R(3,1)
C     ******************************************************************
C     Y
C     ******************************************************************
      APY=XYZP(2)-XYZA(2)
      A(6)=APY
      A(7)=R(1,2)
      A(8)=R(2,2)
      A(9)=R(3,2)
C     ******************************************************************
C     Z
C     ******************************************************************
      APZ=XYZP(3)-XYZA(3)
      A(10)=APZ
      A(11)=R(1,3)
      A(12)=R(2,3)
      A(13)=R(3,3)
      IF (LIMIT-1) 120,110,120
  120 CONTINUE
C     ******************************************************************
C     XX
C     ******************************************************************
      A(14)=APX**2
      T=APX+APX
      A(15)=R(1,1)*T
      A(16)=R(2,1)*T
      A(17)=R(3,1)*T
      A(18)=D(1,1)
      A(19)=D(2,1)
      A(20)=D(3,1)
      A(21)=D(4,1)
      A(22)=D(5,1)
      A(23)=D(6,1)
C     ******************************************************************
C     YY
C     ******************************************************************
      A(24)=APY**2
      T=APY+APY
      A(25)=R(1,2)*T
      A(26)=R(2,2)*T
      A(27)=R(3,2)*T
      A(28)=D(1,2)
      A(29)=D(2,2)
      A(30)=D(3,2)
      A(31)=D(4,2)
      A(32)=D(5,2)
      A(33)=D(6,2)
C     ******************************************************************
C     ZZ
C     ******************************************************************
      A(34)=APZ**2
      T=APZ+APZ
      A(35)=R(1,3)*T
      A(36)=R(2,3)*T
      A(37)=R(3,3)*T
      A(38)=D(1,3)
      A(39)=D(2,3)
      A(40)=D(3,3)
      A(41)=D(4,3)
      A(42)=D(5,3)
      A(43)=D(6,3)
C     ******************************************************************
C     XY
C     ******************************************************************
      A(44)=APX*APY
      A(45)=R(1,1)*APY+R(1,2)*APX
      A(46)=R(2,1)*APY+R(2,2)*APX
      A(47)=R(3,1)*APY+R(3,2)*APX
      A(48)=D(1,4)
      A(49)=D(2,4)
      A(50)=D(3,4)
      A(51)=D(4,4)
      A(52)=D(5,4)
      A(53)=D(6,4)
C     ******************************************************************
C     XZ
C     ******************************************************************
      A(54)=APX*APZ
      A(55)=R(1,1)*APZ+R(1,3)*APX
      A(56)=R(2,1)*APZ+R(2,3)*APX
      A(57)=R(3,1)*APZ+R(3,3)*APX
      A(58)=D(1,5)
      A(59)=D(2,5)
      A(60)=D(3,5)
      A(61)=D(4,5)
      A(62)=D(5,5)
      A(63)=D(6,5)
C     ******************************************************************
C     YZ
C     ******************************************************************
      A(64)=APY*APZ
      A(65)=R(1,2)*APZ+R(1,3)*APY
      A(66)=R(2,2)*APZ+R(2,3)*APY
      A(67)=R(3,2)*APZ+R(3,3)*APY
      A(68)=D(1,6)
      A(69)=D(2,6)
      A(70)=D(3,6)
      A(71)=D(4,6)
      A(72)=D(5,6)
      A(73)=D(6,6)
      RETURN
      END
      SUBROUTINE ROTATE
C
C     --------------------------
C     GAUSSIAN 76 (QCPE VERSION)
C     DECEMBER 1977
C     --------------------------
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/C100/KOPS(2),CFILL1(9)
      COMMON/C100/  PX,PY,PZ,EP,RAB2,OFAB,
     $              QX,QY,QZ,EQ,RCD2,OFCD,
     $              PQX,PQY,PQZ,RPQ
      COMMON/C100/CFILL2(18),R(3,3),D(6,6),CFILL3(6263)
C     CUTROT IS A CUTOFF IN THE ROTATION ROUTINE.  THIS CAN BE CHANGED
C     IF NECESSARY
      DATA ZERO/0.0D0/,ONE/1.0D0/,TWO/2.0D0/,CUTROT/1.0D-5/
      IF (RPQ-CUTROT) 2,2,3
    3 PQL=DSQRT(PQX*PQX+PQY*PQY)
      IF (PQL-CUTROT) 4,4,5
    5 CONTINUE
      COSP=PQX/PQL
      SINP=PQY/PQL
      COST=PQZ/RPQ
      SINT=PQL/RPQ
      R(1,1)=SINP
      R(1,2)=-COSP
      R(1,3)=ZERO
      R(2,1)=COST*COSP
      R(2,2)=COST*SINP
      R(2,3)=-SINT
      R(3,1)=SINT*COSP
      R(3,2)=SINT*SINP
      R(3,3)=COST
      GO TO 15
    2 CONTINUE
      DO 6 I=1,3
      DO 7 J=1,3
    7 R(I,J)=ZERO
    6 R(I,I)=ONE
      GO TO 15
    4 CONTINUE
      SGN=PQZ/DABS(PQZ)
      DO 8 I=1,3
      DO 8 J=1,3
    8 R(I,J)=ZERO
      R(1,1)=ONE
      R(2,2)=SGN
      R(3,3)=SGN
   15 CONTINUE
      D(1,1)=R(1,1)*R(1,1)
      D(1,2)=R(1,2)*R(1,2)
      D(1,3)=R(1,3)*R(1,3)
      D(1,4)=R(1,1)*R(1,2)
      D(1,5)=R(1,1)*R(1,3)
      D(1,6)=R(1,2)*R(1,3)
      D(2,1)=R(2,1)*R(2,1)
      D(2,2)=R(2,2)*R(2,2)
      D(2,3)=R(2,3)*R(2,3)
      D(2,4)=R(2,1)*R(2,2)
      D(2,5)=R(2,1)*R(2,3)
      D(2,6)=R(2,2)*R(2,3)
      D(3,1)=R(3,1)*R(3,1)
      D(3,2)=R(3,2)*R(3,2)
      D(3,3)=R(3,3)*R(3,3)
      D(3,4)=R(3,1)*R(3,2)
      D(3,5)=R(3,1)*R(3,3)
      D(3,6)=R(3,2)*R(3,3)
      D(4,1)=(R(1,1)*R(2,1))*TWO
      D(4,2)=(R(1,2)*R(2,2))*TWO
      D(4,3)=(R(1,3)*R(2,3))*TWO
      D(4,4)=R(1,1)*R(2,2)+R(2,1)*R(1,2)
      D(4,5)=R(1,1)*R(2,3)+R(2,1)*R(1,3)
      D(4,6)=R(1,2)*R(2,3)+R(2,2)*R(1,3)
      D(5,1)=(R(1,1)*R(3,1))*TWO
      D(5,2)=(R(1,2)*R(3,2))*TWO
      D(5,3)=(R(1,3)*R(3,3))*TWO
      D(5,4)=R(1,1)*R(3,2)+R(3,1)*R(1,2)
      D(5,5)=R(1,1)*R(3,3)+R(3,1)*R(1,3)
      D(5,6)=R(1,2)*R(3,3)+R(3,2)*R(1,3)
      D(6,1)=(R(2,1)*R(3,1))*TWO
      D(6,2)=(R(2,2)*R(3,2))*TWO
      D(6,3)=(R(2,3)*R(3,3))*TWO
      D(6,4)=R(2,1)*R(3,2)+R(3,1)*R(2,2)
      D(6,5)=R(2,1)*R(3,3)+R(3,1)*R(2,3)
      D(6,6)=R(2,2)*R(3,3)+R(3,2)*R(2,3)
      RETURN
      END
      SUBROUTINE FORMS(LQMAX)
C
C     --------------------------
C     GAUSSIAN 76 (QCPE VERSION)
C     DECEMBER 1977
C     --------------------------
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/C100/KOPS(2),FM00,FM01,FM02,FM03,FM04,FM05,FM06,FM07,FM08
      EQUIVALENCE(T0000,FM00),(T0100,FM01),(T0200,FM02)
      COMMON/C100/  PX,PY,PZ,EP,RAB2,OFAB,
     $              QX,QY,QZ,EQ,RCD2,OFCD,
     $              PQX,PQY,PQZ,RPQ
      EQUIVALENCE (S0100,FP01)
      EQUIVALENCE (S0200,FP02)
      EQUIVALENCE (S0300,FP03)
      EQUIVALENCE (S0400,FP04)
      EQUIVALENCE (S0500,FP05)
      EQUIVALENCE (S0600,FP06)
      EQUIVALENCE (S0700,FP07)
      EQUIVALENCE (S0800,FP08)
      COMMON/C100/CFILL1(390),
     1TW0101,TW0102,TW0201,TW0110,TW1001,TW0103,TW0301,TW0104,TW0401,
     2TW0111,TW1101,TW0115,TW1501,TW0105,TW0501,TW0131,TW3101,TW0112,
     3TW1201,TW0606,TW0607,TW0706,TW0613,TW1306,TW0608,TW0806,TW0614,
     4TW1406,TW0609,TW0906,TW1624,TW3006,TW1623,TW2906,TW0202,TW0210,
     5TW1002,TW0203,TW0302,TW0204,TW0402,TW0211,TW1102,TW0215,TW1502,
     6TW0205,TW0502,TW0231,TW3102,TW0212,TW1202,TW1010,TW1003,TW0310,
     7TW1004,TW0410,TW1011,TW1110,TW1015,TW1510,TW1005,TW0510,TW1031
      COMMON/C100/
     8TW3110,TW1012,TW1210,TW2610,TW2611,TW2710,TW2615,TW3510,TW2612,
     9TW2810,TW0303,TW0304,TW0403,TW0311,TW1103,TW0315,TW1503,TW0305,
     ATW0503,TW0331,TW3103,TW0312,TW1203,TW2020,TW2021,TW2120,TW2025,
     BTW2520,TW2022,TW2220,TW0707,TW0713,TW1307,TW0708,TW0807,TW0714,
     CTW1407,TW0709,TW0907,TW1724,TW3007,TW1723,TW2907,TW1313,TW1308,
     D TW(89),CFILL2(5739)
      EQUIVALENCE (TW0813,TW(1))
      EQUIVALENCE (TW1314,TW(2))
      EQUIVALENCE (TW1413,TW(3))
      EQUIVALENCE (TW1309,TW(4))
      EQUIVALENCE (TW0913,TW(5))
      EQUIVALENCE (TW3224,TW(6))
      EQUIVALENCE (TW3013,TW(7))
      EQUIVALENCE (TW3223,TW(8))
      EQUIVALENCE (TW2913,TW(9))
      EQUIVALENCE (TW0404,TW(10))
      EQUIVALENCE (TW0411,TW(11))
      EQUIVALENCE (TW1104,TW(12))
      EQUIVALENCE (TW0415,TW(13))
      EQUIVALENCE (TW1504,TW(14))
      EQUIVALENCE (TW0405,TW(15))
      EQUIVALENCE (TW0504,TW(16))
      EQUIVALENCE (TW0431,TW(17))
      EQUIVALENCE (TW3104,TW(18))
      EQUIVALENCE (TW0412,TW(19))
      EQUIVALENCE (TW1204,TW(20))
      EQUIVALENCE (TW2323,TW(21))
      EQUIVALENCE (TW2324,TW(22))
      EQUIVALENCE (TW2423,TW(23))
      EQUIVALENCE (TW2914,TW(24))
      EQUIVALENCE (TW3323,TW(25))
      EQUIVALENCE (TW2908,TW(26))
      EQUIVALENCE (TW1823,TW(27))
      EQUIVALENCE (TW2909,TW(28))
      EQUIVALENCE (TW1923,TW(29))
      EQUIVALENCE (TW1111,TW(30))
      EQUIVALENCE (TW1115,TW(31))
      EQUIVALENCE (TW1511,TW(32))
      EQUIVALENCE (TW1105,TW(33))
      EQUIVALENCE (TW0511,TW(34))
      EQUIVALENCE (TW1131,TW(35))
      EQUIVALENCE (TW3111,TW(36))
      EQUIVALENCE (TW1112,TW(37))
      EQUIVALENCE (TW1211,TW(38))
      EQUIVALENCE (TW2711,TW(39))
      EQUIVALENCE (TW2715,TW(40))
      EQUIVALENCE (TW3511,TW(41))
      EQUIVALENCE (TW2712,TW(42))
      EQUIVALENCE (TW2811,TW(43))
      EQUIVALENCE (TW0808,TW(44))
      EQUIVALENCE (TW0814,TW(45))
      EQUIVALENCE (TW1408,TW(46))
      EQUIVALENCE (TW0809,TW(47))
      EQUIVALENCE (TW0908,TW(48))
      EQUIVALENCE (TW1824,TW(49))
      EQUIVALENCE (TW3008,TW(50))
      EQUIVALENCE (TW2121,TW(51))
      EQUIVALENCE (TW2125,TW(52))
      EQUIVALENCE (TW2521,TW(53))
      EQUIVALENCE (TW2122,TW(54))
      EQUIVALENCE (TW2221,TW(55))
      EQUIVALENCE (TW1515,TW(56))
      EQUIVALENCE (TW1505,TW(57))
      EQUIVALENCE (TW0515,TW(58))
      EQUIVALENCE (TW1531,TW(59))
      EQUIVALENCE (TW3115,TW(60))
      EQUIVALENCE (TW1512,TW(61))
      EQUIVALENCE (TW1215,TW(62))
      EQUIVALENCE (TW3515,TW(63))
      EQUIVALENCE (TW3512,TW(64))
      EQUIVALENCE (TW2815,TW(65))
      EQUIVALENCE (TW0505,TW(66))
      EQUIVALENCE (TW0531,TW(67))
      EQUIVALENCE (TW3105,TW(68))
      EQUIVALENCE (TW0512,TW(69))
      EQUIVALENCE (TW1205,TW(70))
      EQUIVALENCE (TW2525,TW(71))
      EQUIVALENCE (TW2522,TW(72))
      EQUIVALENCE (TW2225,TW(73))
      EQUIVALENCE (TW3425,TW(74))
      EQUIVALENCE (TW1414,TW(75))
      EQUIVALENCE (TW1409,TW(76))
      EQUIVALENCE (TW0914,TW(77))
      EQUIVALENCE (TW3324,TW(78))
      EQUIVALENCE (TW3014,TW(79))
      EQUIVALENCE (TW0909,TW(80))
      EQUIVALENCE (TW1924,TW(81))
      EQUIVALENCE (TW3009,TW(82))
      EQUIVALENCE (TW3131,TW(83))
      EQUIVALENCE (TW3112,TW(84))
      EQUIVALENCE (TW1231,TW(85))
      EQUIVALENCE (TW1212,TW(86))
      EQUIVALENCE (TW2812,TW(87))
      EQUIVALENCE (TW2424,TW(88))
      EQUIVALENCE (TW2222,TW(89))
      DATA FP01/1.0D0/,FP02/0.5D0/,FP03/0.25D0/,FP04/0.75D0/,
     * FP05/0.125D0/,
     1 FP06/0.375D0/,FP07/0.0625D0/,FP08/0.1875D0/,FP09/1.125D0/,
     * FP10/0.3125D-1/
      DATA
     2 FP11/0.3125D0/,FP12/0.46875D0/,FP13/0.9375D-1/,FP14/0.5625D0/,
     3FP15/0.15625D-1/,FP16/0.234375D0/,FP17/0.703125D0/,FP18/0.21875D0/
      DATA
     4 FP19/0.46875D-1/,FP20/0.28125D0/,FP21/1.6875D0/,FP22/0.9375D0/,
     C FP23/1.40625D0/,FP24/0.78125D-2/,FP25/0.1640625D0/
      DATA
     5 FP26/0.8203125D0/,FP27/0.171875D0/,FP28/0.140625D0/,
     * FP29/0.78125D-1/,
     6 FP30/0.1171875D0/,FP31/0.234375D-1/,FP32/0.703125D-1/,
     * FP33/3.375D0/
      DATA
     7 FP34/2.109375D0/,FP35/0.390625D-2/,FP36/0.109375D0/,
     * FP37/1.640625D0/,
     8 FP38/0.41015625D0/,FP39/0.15625D0/,FP40/0.65625D0/,
     * FP41/0.3984375D0/
      DATA FP42/0.5859375D-1/,FP43/0.17578125D0/,FP44/0.1171875D-1/,
     B FP45/0.3515625D-1/,FP46/0.546875D-1/,ONE/1.0D0/
C     SCSD
      ZZ1=-RPQ
      EE1=ONE/EP
      FF1=ONE/EQ
      EE2=EE1*EE1
      EE3=EE2*EE1
      EE4=EE3*EE1
      ZZ2=ZZ1*ZZ1
      ZZ3=ZZ2*ZZ1
      ZZ4=ZZ3*ZZ1
      T0010=FM00*EE1
      T0020=FM00*EE2
      T0111=FM01*EE1*ZZ1
      T0120=FM01*EE2
      T0121=FM01*EE2*ZZ1
      T0130=FM01*EE3
      T0222=FM02*EE2*ZZ2
      T0231=FM02*EE3*ZZ1
      T0232=FM02*EE3*ZZ2
      T0240=FM02*EE4
      T0333=FM03*EE3*ZZ3
      T0342=FM03*EE4*ZZ2
      T0444=FM04*EE4*ZZ4
      TW0101=T0000*S0100
      TW0201=-T0111*S0200
      TW0301=T0010*S0200+T0222*S0300-T0120*S0300
      TW0401=-T0121*S0400-T0333*S0500+T0231*S0600
      TW0501=T0020*S0400+T0232*S0400-T0130*S0400+T0444*S0700-T0342*S0600
     3+T0240*S0800
      TW1001=T0010*S0200-T0120*S0300
      TW1101=-T0121*S0300+T0231*S0500
      TW1201=T0020*S0300-T0130*S0300+T0232*S0500-T0342*S0700+T0240*S0700
      TW1501=T0020*S0400-T0130*S0400+T0240*S0800
      TW3101=T0020*S0300-T0130*S0300+T0240*S0700
      IF (LQMAX) 100,110,100
  110 RETURN
  100 CONTINUE
C     SCPD,PCSD
      ZZ5=ZZ4*ZZ1
      T0101=FM01*ZZ1
      T0110=FM01*EE1
      T0212=FM02*EE1*ZZ2
      T0221=FM02*EE2*ZZ1
      T0230=FM02*EE3
      T0323=FM03*EE2*ZZ3
      T0332=FM03*EE3*ZZ2
      T0341=FM03*EE4*ZZ1
      T0434=FM04*EE3*ZZ4
      T0443=FM04*EE4*ZZ3
      T0545=FM05*EE4*ZZ5
      S0201=FP02*FF1
      S0301=FP03*FF1
      S0501=FP05*FF1
      S0601=FP06*FF1
      S0701=FP07*FF1
      S0801=FP08*FF1
      S0901=FP09*FF1
      S1001=FP10*FF1
      S1101=FP11*FF1
      S1201=FP12*FF1
      S1301=FP13*FF1
      TW0102=T0101*S0201
      TW0202=-T0212*S0301+T0110*S0301
      TW0302=T0111*S0301+T0323*S0501-T0221*S0601
      TW0402=-T0222*S0601+T0120*S0601-T0434*S0701+T0332*S0601-T0230*S080
     31
      TW0502=T0121*S0601+T0333*S0601-T0231*S0901+T0545*S1001-T0443*S1101
     3+T0341*S1201
      TW1002=T0111*S0301-T0221*S0501
      TW1102=-T0222*S0501+T0120*S0501+T0332*S0701-T0230*S0701
      TW1202=T0121*S0501-T0231*S0301+T0333*S0701-T0443*S1001+T0341*S1301
      TW1502=T0121*S0601-T0231*S0601+T0341*S1301
      TW3102=T0121*S0501-T0231*S0501+T0341*S1001
      TW0606=T0110*S0301
      TW0706=-T0221*S0501
      TW0806=T0120*S0501+T0332*S0701-T0230*S0701
      TW0906=-T0231*S0801-T0443*S1001+T0341*S1301
      TW1306=T0120*S0601-T0230*S0801
      TW1406=-T0231*S0801+T0341*S1301
      TW2906=T0120*S0501-T0230*S0701
      TW3006=-T0231*S0701+T0341*S1001
      IF (LQMAX-1) 120,110,120
  120 CONTINUE
C     PCPD, SCDD, DCSD
      ZZ6=ZZ5*ZZ1
      FF2=FF1*FF1
      T0202=FM02*ZZ2
      T0313=FM03*EE1*ZZ3
      T0211=FM02*EE1*ZZ1
      T0424=FM04*EE2*ZZ4
      T0322=FM03*EE2*ZZ2
      T0220=FM02*EE2
      T0433=FM04*EE3*ZZ3
      T0331=FM03*EE3*ZZ1
      T0442=FM04*EE4*ZZ2
      T0340=FM03*EE4
      T0535=FM05*EE3*ZZ5
      T0544=FM05*EE4*ZZ4
      T0646=FM06*EE4*ZZ6
      S0302=FP03*FF2
      S0502=FP05*FF2
      S0602=FP06*FF2
      S0702=FP07*FF2
      S0802=FP08*FF2
      S0902=FP09*FF2
      S1002=FP10*FF2
      S1102=FP11*FF2
      S1202=FP12*FF2
      S1302=FP13*FF2
      S1402=FP14*FF2
      S1502=FP15*FF2
      S1602=FP16*FF2
      S1702=FP17*FF2
      S1802=FP18*FF2
      S1902=FP19*FF2
      TW0103=T0000*S0201+T0202*S0302-T0100*S0302
      TW0203=-T0111*S0301-T0313*S0502+T0211*S0602
      TW0303=T0010*S0301+T0212*S0502-T0110*S0502+T0222*S0501-T0120*S0501
     3+T0424*S0702-T0322*S0602+T0220*S0802
      TW0403=-T0121*S0601-T0323*S0802+T0221*S1402-T0333*S0701+T0231*S080
     31-T0535*S1002+T0433*S1102-T0331*S1202
      TW0503=T0020*S0601+T0222*S0802-T0120*S0802+T0232*S0601-T0130*S0601
     3+T0434*S0802-T0332*S0902+T0230*S1402+T0444*S1001-T0342*S0801+T0240
     4*S1301+T0646*S1502-T0544*S1602+T0442*S1702-T0340*S1602
      TW1003=T0010*S0301+T0212*S0502-T0110*S0502-T0120*S0501-T0322*S0702
     3+T0220*S0702
      TW1103=-T0121*S0501-T0323*S0702+T0221*S0802+T0231*S0701+T0433*S100
     32-T0331*S1302
      TW1203=T0020*S0501+T0222*S0702-T0120*S0702-T0130*S0501-T0332*S1802
     3+T0230*S0502+T0232*S0701+T0434*S1002-T0342*S1001+T0240*S1001-T0544
     4*S1502+T0442*S1302-T0340*S1902
      TW1503=T0020*S0601+T0222*S0802-T0120*S0802-T0130*S0601-T0332*S0802
     3+T0230*S0802+T0240*S1301+T0442*S1902-T0340*S1902
      TW3103=T0020*S0501+T0222*S0702-T0120*S0702-T0130*S0501-T0332*S0702
     3+T0230*S0702+T0240*S1001+T0442*S1502-T0340*S1502
      TW0607=T0211*S0502
      TW0707=-T0322*S0702+T0220*S0702
      TW0807=T0221*S0702+T0433*S1002-T0331*S1302
      TW0907=-T0332*S1302+T0230*S1302-T0544*S1502+T0442*S1302-T0340*S190
     32
      TW1307=T0221*S0802-T0331*S1302
      TW1407=-T0332*S1302+T0230*S1302+T0442*S1902-T0340*S1902
      TW2907=T0221*S0702-T0331*S1002
      TW3007=-T0332*S1002+T0230*S1002+T0442*S1502-T0340*S1502
      TW0110=T0000*S0201-T0100*S0302
      TW0210=-T0111*S0301+T0211*S0502
      TW0310=T0010*S0301-T0110*S0502+T0222*S0501-T0120*S0501-T0322*S0702
     3+T0220*S0702
      TW0410=-T0121*S0601+T0221*S0802-T0333*S0701+T0231*S0801+T0433*S100
     32-T0331*S1302
      TW0510=T0020*S0601-T0120*S0802+T0232*S0601-T0130*S0601-T0332*S0802
     3+T0230*S0802+T0444*S1001-T0342*S0801+T0240*S1301-T0544*S1502+T0442
     4*S1302-T0340*S1902
      TW1010=T0010*S0301-T0110*S0502-T0120*S0501+T0220*S0802
      TW1110=-T0121*S0501+T0221*S0702+T0231*S0701-T0331*S1302
      TW1210=T0020*S0501-T0120*S0702-T0130*S0501+T0230*S0502+T0232*S0701
     3-T0332*S1002-T0342*S1001+T0240*S1001+T0442*S1902-T0340*S1902
      TW1510=T0020*S0601-T0120*S0802-T0130*S0601+T0230*S1402+T0240*S1301
     3-T0340*S1602
      TW2610=T0010*S0301-T0110*S0502-T0120*S0501+T0220*S0702
      TW2710=-T0121*S0501+T0221*S0702+T0231*S0701-T0331*S1002
      TW2810=T0020*S0501-T0120*S0702-T0130*S0501+T0230*S0702+T0232*S0701
     3-T0332*S1002-T0342*S1001+T0240*S1001+T0442*S1502-T0340*S1502
      TW3110=T0020*S0501-T0120*S0702-T0130*S0501+T0230*S0502+T0240*S1001
     3-T0340*S1902
      TW3510=T0020*S0601-T0120*S0802-T0130*S0601+T0230*S0802+T0240*S1301
     3-T0340*S1902
      TW2020=T0220*S0702
      TW2120=-T0331*S1002
      TW2220=T0230*S1002+T0442*S1502-T0340*S1502
      TW2520=T0230*S1302-T0340*S1902
      IF (LQMAX-2) 130,110,130
  130 CONTINUE
C     PCDD,DCPD
      FF3=FF2*FF1
      FF4=FF3*FF1
      ZZ7=ZZ6*ZZ1
      S3902=FP39*FF2
      S0402=FP04*FF2
      S2002=FP20*FF2
      S2102=FP21*FF2
      S2802=FP28*FF2
      S0503=FP05*FF3
      S0603=FP06*FF3
      S0703=FP07*FF3
      S0803=FP08*FF3
      S1003=FP10*FF3
      S1103=FP11*FF3
      S1203=FP12*FF3
      S1303=FP13*FF3
      S1403=FP14*FF3
      S1503=FP15*FF3
      S1603=FP16*FF3
      S1703=FP17*FF3
      S1903=FP19*FF3
      S2003=FP20*FF3
      S2203=FP22*FF3
      S2303=FP23*FF3
      S2403=FP24*FF3
      S2503=FP25*FF3
      S2603=FP26*FF3
      S2703=FP27*FF3
      S2803=FP28*FF3
      S2903=FP29*FF3
      S3003=FP30*FF3
      S3103=FP31*FF3
      S3203=FP32*FF3
      S1304=FP13*FF4
      S1904=FP19*FF4
      S2804=FP28*FF4
      S3004=FP30*FF4
      S3104=FP31*FF4
      S3204=FP32*FF4
      S4204=FP42*FF4
      S4404=FP44*FF4
      S4504=FP45*FF4
      T0311=FM03*EE1*ZZ1
      T0320=FM03*EE2
      T0422=FM04*EE2*ZZ2
      T0636=FM06*EE3*ZZ6
      T0644=FM06*EE4*ZZ4
      T0645=FM06*EE4*ZZ5
      T0747=FM07*EE4*ZZ7
      T0210=FM02*EE1
      T0330=FM03*EE3
      T0440=FM04*EE4
      T0201=FM02*ZZ1
      T0321=FM03*EE2*ZZ1
      T0431=FM04*EE3*ZZ1
      T0441=FM04*EE4*ZZ1
      T0312=FM03*EE1*ZZ2
      T0432=FM04*EE3*ZZ2
      T0542=FM05*EE4*ZZ2
      T0303=FM03*ZZ3
      T0423=FM04*EE2*ZZ3
      T0533=FM05*EE3*ZZ3
      T0543=FM05*EE4*ZZ3
      T0414=FM04*EE1*ZZ4
      T0534=FM05*EE3*ZZ4
      T0525=FM05*EE2*ZZ5
      TW0104=T0101*S0402+T0303*S0503-T0201*S0603
      TW0204=-T0212*S0602+T0110*S0602-T0414*S0703+T0312*S0603-T0210*S080
     33
      TW0304=T0111*S0602+T0313*S0703-T0211*S0803+T0323*S0802-T0221*S1402
     3+T0525*S1003-T0423*S1103+T0321*S1203
      TW0404=-T0222*S1402+T0120*S1402-T0424*S1303+T0322*S1403-T0220*S200
     33-T0434*S1302+T0332*S1402-T0230*S2002-T0636*S1503+T0534*S1603-T043
     42*S1703+T0330*S1603
      TW0504=T0121*S1402+T0323*S1303-T0221*S2003+T0333*S1402-T0231*S2102
     3+T0535*S1303-T0433*S2203+T0331*S2303+T0545*S1902-T0443*S1202+T0341
     4*S1702+T0747*S2403-T0645*S2503+T0543*S2603-T0441*S2603
      TW1004=T0111*S0602+T0313*S0703-T0211*S0803-T0221*S0802-T0423*S1003
     3+T0321*S1303
      TW1104=-T0222*S0802+T0120*S0802-T0424*S1003+T0322*S0803-T0220*S130
     33+T0332*S1302-T0230*S1302+T0534*S1503-T0432*S1303+T0330*S1903
      TW1204=T0121*S0802+T0323*S1003-T0221*S1303-T0231*S0602-T0433*S2703
     3+T0331*S2003+T0333*S1302+T0535*S1503-T0443*S1902+T0341*S2802-T0645
     4*S2403+T0543*S2903-T0441*S3003
      TW1504=T0121*S1402+T0323*S1303-T0221*S2003-T0231*S1402-T0433*S1303
     3+T0331*S2003+T0341*S2802+T0543*S3103-T0441*S3203
      TW3104=T0121*S0802+T0323*S1003-T0221*S1303-T0231*S0802-T0433*S1003
     3+T0331*S1303+T0341*S1902+T0543*S2403-T0441*S3103
      TW0608=T0110*S0502+T0312*S0703-T0210*S0703
      TW0708=-T0221*S0702-T0423*S1003+T0321*S1303
      TW0808=T0120*S0702+T0322*S1003-T0220*S1003+T0332*S1002-T0230*S1002
     3+T0534*S1503-T0432*S1303+T0330*S1903
      TW0908=-T0231*S1302-T0433*S1903+T0331*S2803-T0443*S1502+T0341*S190
     32-T0645*S2403+T0543*S2903-T0441*S3003
      TW1308=T0120*S0802+T0322*S1303-T0220*S1303-T0230*S1302-T0432*S1903
     3+T0330*S1903
      TW1408=-T0231*S1302-T0433*S1903+T0331*S2803+T0341*S1902+T0543*S310
     33-T0441*S3203
      TW2908=T0120*S0702+T0322*S1003-T0220*S1003-T0230*S1002-T0432*S1503
     3+T0330*S1503
      TW3008=-T0231*S1002-T0433*S1503+T0331*S1903+T0341*S1502+T0543*S240
     33-T0441*S3103
      TW0111=T0101*S0302-T0201*S0503
      TW0211=-T0212*S0502+T0110*S0502+T0312*S0703-T0210*S0703
      TW0311=T0111*S0502-T0211*S0703+T0323*S0702-T0221*S0802-T0423*S1003
     3+T0321*S1303
      TW0411=-T0222*S0802+T0120*S0802+T0322*S1303-T0220*S1303-T0434*S100
     32+T0332*S0802-T0230*S1302+T0534*S1503-T0432*S1303+T0330*S1903
      TW0511=T0121*S0802-T0221*S1303+T0333*S0802-T0231*S1402-T0433*S1303
     3+T0331*S2003+T0545*S1502-T0443*S3902+T0341*S1602-T0645*S2403+T0543
     4*S2903-T0441*S3003
      TW1011=T0111*S0502-T0211*S0703-T0221*S0702+T0321*S1303
      TW1111=-T0222*S0702+T0120*S0702+T0322*S1003-T0220*S1003+T0332*S100
     32-T0230*S1002-T0432*S1903+T0330*S1903
      TW1211=T0121*S0702-T0221*S1003-T0231*S0502+T0331*S1303+T0333*S1002
     3-T0433*S1503-T0443*S1502+T0341*S1902+T0543*S3103-T0441*S3203
      TW1511=T0121*S0802-T0221*S1303-T0231*S0802+T0331*S2003+T0341*S1902
     3-T0441*S3003
      TW2611=T0111*S0502-T0211*S0703-T0221*S0702+T0321*S1003
      TW2711=-T0222*S0702+T0120*S0702+T0322*S1003-T0220*S1003+T0332*S100
     32-T0230*S1002-T0432*S1503+T0330*S1503
      TW2811=T0121*S0702-T0221*S1003-T0231*S0502+T0331*S0703+T0333*S1002
     3-T0433*S1503-T0443*S1502+T0341*S1902+T0543*S2403-T0441*S3103
      TW3111=T0121*S0702-T0221*S1003-T0231*S0702+T0331*S0703+T0341*S1502
     3-T0441*S3103
      TW3511=T0121*S0802-T0221*S1303-T0231*S0802+T0331*S1303+T0341*S1902
     3-T0441*S3103
      TW0613=T0110*S0602-T0210*S0803
      TW0713=-T0221*S0802+T0321*S1303
      TW0813=T0120*S0802-T0220*S1303+T0332*S1302-T0230*S1302-T0432*S1903
     3+T0330*S1903
      TW0913=-T0231*S2002+T0331*S2803-T0443*S1902+T0341*S2802+T0543*S310
     33-T0441*S3203
      TW1313=T0120*S1402-T0220*S2003-T0230*S2002+T0330*S1603
      TW1413=-T0231*S2002+T0331*S2803+T0341*S2802-T0441*S3003
      TW2913=T0120*S0802-T0220*S1303-T0230*S1302+T0330*S1903
      TW3013=-T0231*S1302+T0331*S1903+T0341*S1902-T0441*S3103
      TW2021=T0321*S1003
      TW2121=-T0432*S1503+T0330*S1503
      TW2221=T0331*S1503+T0543*S2403-T0441*S3103
      TW2521=T0331*S1903-T0441*S3103
      TW1623=T0110*S0502-T0210*S0703
      TW1723=-T0221*S0702+T0321*S1003
      TW1823=T0120*S0702-T0220*S1003+T0332*S1002-T0230*S1002-T0432*S1503
     3+T0330*S1503
      TW1923=-T0231*S1302+T0331*S1903-T0443*S1502+T0341*S1902+T0543*S240
     33-T0441*S3103
      TW2323=T0120*S0702-T0220*S1003-T0230*S1002+T0330*S1903
      TW2423=-T0231*S1002+T0331*S1503+T0341*S1502-T0441*S3103
      TW3223=T0120*S0802-T0220*S1303-T0230*S1302+T0330*S1903
      TW3323=-T0231*S1302+T0331*S1903+T0341*S1902-T0441*S3103
      IF (LQMAX-3) 140,110,140
  140 CONTINUE
C     DCDD
      ZZ8=ZZ7*ZZ1
      S0303=FP03*FF3
      S0403=FP04*FF3
      S0903=FP09*FF3
      S1803=FP18*FF3
      S2103=FP21*FF3
      S3303=FP33*FF3
      S3403=FP34*FF3
      S4003=FP40*FF3
      S4103=FP41*FF3
      S4603=FP46*FF3
      S0504=FP05*FF4
      S0704=FP07*FF4
      S0604=FP06*FF4
      S0804=FP08*FF4
      S1004=FP10*FF4
      S1104=FP11*FF4
      S1204=FP12*FF4
      S1504=FP15*FF4
      S1604=FP16*FF4
      S1704=FP17*FF4
      S2004=FP20*FF4
      S2404=FP24*FF4
      S2504=FP25*FF4
      S2604=FP26*FF4
      S2904=FP29*FF4
      S3404=FP34*FF4
      S3504=FP35*FF4
      S3604=FP36*FF4
      S3704=FP37*FF4
      S3804=FP38*FF4
      S3904=FP39*FF4
      S4104=FP41*FF4
      S4304=FP43*FF4
      S4604=FP46*FF4
      T0302=FM03*ZZ2
      T0413=FM04*EE1*ZZ3
      T0404=FM04*ZZ4
      T0524=FM05*EE2*ZZ4
      T0515=FM05*EE1*ZZ5
      T0626=FM06*EE2*ZZ6
      T0635=FM06*EE3*ZZ5
      T0746=FM07*EE4*ZZ6
      T0737=FM07*EE3*ZZ7
      T0848=FM08*EE4*ZZ8
      TW0105=T0000*S0402+T0202*S0403-T0100*S0403+T0404*S0704-T0302*S0604
     3+T0200*S0804
      TW0205=-T0111*S0602-T0313*S0603+T0211*S0903-T0515*S1004+T0413*S110
     34-T0311*S1204
      TW0305=T0010*S0602+T0212*S0603-T0110*S0603+T0414*S1004-T0312*S0804
     3+T0210*S1304+T0222*S0802-T0120*S0802+T0424*S0803-T0322*S0903+T0220
     4*S1403+T0626*S1504-T0524*S1604+T0422*S1704-T0320*S1604
      TW0405=-T0121*S1402-T0323*S1403+T0221*S2103-T0525*S1904+T0423*S120
     34-T0321*S1704-T0333*S1302+T0231*S2002-T0535*S1303+T0433*S2203-T033
     41*S2303-T0737*S2404+T0635*S2504-T0533*S2604+T0431*S2604
      TW0505=T0020*S1402+T0222*S1403-T0120*S1403+T0424*S1904-T0322*S2004
     3+T0220*S2804+T0232*S1402-T0130*S1402+T0434*S1403-T0332*S3303+T0230
     4*S2103+T0636*S1904-T0534*S1704+T0432*S3404-T0330*S1704+T0444*S1902
     5-T0342*S2002+T0240*S2802+T0646*S1903-T0544*S1703+T0442*S3403-T0340
     6*S1703+T0848*S3504-T0746*S3604+T0644*S2604-T0542*S3704+T0440*S3804
      TW1005=T0010*S0602+T0212*S0603-T0110*S0603+T0414*S1004-T0312*S0804
     3+T0210*S1304-T0120*S0802-T0322*S0803+T0220*S0803-T0524*S1504+T0422
     4*S1304-T0320*S1904
      TW1105=-T0121*S0802-T0323*S0803+T0221*S1403-T0525*S1504+T0423*S390
     34-T0321*S1604+T0231*S1302+T0433*S1303-T0331*S2003+T0635*S2404-T053
     43*S2904+T0431*S3004
      TW1205=T0020*S0802+T0222*S0803-T0120*S0803+T0424*S1504-T0322*S1304
     3+T0220*S1904-T0130*S0802-T0332*S4003+T0230*S0603-T0534*S0504+T0432
     4*S4104-T0330*S2804+T0232*S1302+T0434*S1303+T0636*S2404-T0342*S1902
     5+T0240*S1902-T0544*S1903+T0442*S2003-T0340*S2803-T0746*S3504+T0644
     6*S4204-T0542*S4304+T0440*S4204
      TW1505=T0020*S1402+T0222*S1403-T0120*S1403+T0424*S1904-T0322*S2004
     3+T0220*S2804-T0130*S1402-T0332*S1403+T0230*S1403-T0534*S1904+T0432
     4*S2004-T0330*S2804+T0240*S2802+T0442*S2803-T0340*S2803+T0644*S4404
     5-T0542*S3204+T0440*S4504
      TW3105=T0020*S0802+T0222*S0803-T0120*S0803+T0424*S1504-T0322*S1304
     3+T0220*S1904-T0130*S0802-T0332*S0803+T0230*S0803-T0534*S1504+T0432
     4*S1304-T0330*S1904+T0240*S1902+T0442*S1903-T0340*S1903+T0644*S3504
     5-T0542*S3104+T0440*S4404
      TW0609=T0211*S0803+T0413*S1004-T0311*S1304
      TW0709=-T0322*S1303+T0220*S1303-T0524*S1504+T0422*S1304-T0320*S190
     34
      TW0809=T0221*S1303+T0423*S1504-T0321*S1904+T0433*S1903-T0331*S2803
     3+T0635*S2404-T0533*S2904+T0431*S3004
      TW0909=-T0332*S2803+T0230*S2803-T0534*S3104+T0432*S2804-T0330*S320
     34-T0544*S3103+T0442*S2803-T0340*S3203-T0746*S3504+T0644*S4204-T054
     42*S4304+T0440*S4204
      TW1309=T0221*S2003+T0423*S1904-T0321*S2804-T0331*S2803-T0533*S3104
     3+T0431*S3204
      TW1409=-T0332*S2803+T0230*S2803-T0534*S3104+T0432*S2804-T0330*S320
     34+T0442*S3203-T0340*S3203+T0644*S4404-T0542*S3204+T0440*S4504
      TW2909=T0221*S1303+T0423*S1504-T0321*S1904-T0331*S1903-T0533*S2404
     3+T0431*S3104
      TW3009=-T0332*S1903+T0230*S1903-T0534*S2404+T0432*S1904-T0330*S310
     34+T0442*S3103-T0340*S3103+T0644*S3504-T0542*S3104+T0440*S4404
      TW0112=T0000*S0302-T0100*S0303+T0202*S0503-T0302*S0704+T0200*S0704
      TW0212=-T0111*S0502+T0211*S0303-T0313*S0703+T0413*S1004-T0311*S130
     34
      TW0312=T0010*S0502-T0110*S0503+T0212*S0703-T0312*S1004+T0210*S1004
     3+T0222*S0702-T0120*S0702-T0322*S1803+T0220*S0503+T0424*S1003-T0524
     4*S1504+T0422*S1304-T0320*S1904
      TW0412=-T0121*S0802+T0221*S0603-T0323*S1303+T0423*S1904-T0321*S280
     34-T0333*S1002+T0231*S1302+T0433*S2703-T0331*S2003-T0535*S1503+T063
     45*S2404-T0533*S2904+T0431*S3004
      TW0512=T0020*S0802-T0120*S0803+T0222*S1303-T0322*S1904+T0220*S1904
     3+T0232*S0802-T0130*S0802-T0332*S4003+T0230*S0603+T0434*S1303-T0534
     4*S1904+T0432*S2004-T0330*S2804+T0444*S1502-T0342*S1302+T0240*S1902
     5-T0544*S0503+T0442*S4103-T0340*S2803+T0646*S2403-T0746*S3504+T0644
     6*S4204-T0542*S4304+T0440*S4204
      TW1012=T0010*S0502-T0110*S0503+T0212*S0703-T0312*S1004+T0210*S1004
     3-T0120*S0702+T0220*S0503-T0322*S1003+T0422*S1904-T0320*S1904
      TW1112=-T0121*S0702+T0221*S0503-T0323*S1003+T0423*S1504-T0321*S190
     34+T0231*S1002-T0331*S1303+T0433*S1503-T0533*S3104+T0431*S3204
      TW1212=T0020*S0702-T0120*S0703+T0222*S1003-T0322*S1504+T0220*S1504
     3-T0130*S0702+T0230*S0503-T0332*S0503+T0432*S3204-T0330*S1904+T0232
     4*S1002+T0434*S1503-T0534*S2404-T0342*S1502+T0240*S1502+T0442*S3203
     5-T0340*S1903-T0544*S2403+T0644*S4404-T0542*S3204+T0440*S4504
      TW1512=T0020*S0802-T0120*S0803+T0222*S1303-T0322*S1904+T0220*S1904
     3-T0130*S0802+T0230*S0603-T0332*S1303+T0432*S2804-T0330*S2804+T0240
     4*S1902-T0340*S2803+T0442*S3103-T0542*S4204+T0440*S4204
      TW2612=T0010*S0502-T0110*S0503+T0212*S0703-T0312*S1004+T0210*S1004
     3-T0120*S0702+T0220*S0703-T0322*S1003+T0422*S1504-T0320*S1504
      TW2712=-T0121*S0702+T0221*S0503-T0323*S1003+T0423*S1504-T0321*S190
     34+T0231*S1002-T0331*S0703+T0433*S1503-T0533*S2404+T0431*S3104
      TW2812=T0020*S0702-T0120*S0703+T0222*S1003-T0322*S1504+T0220*S1504
     3-T0130*S0702+T0230*S1303-T0332*S0503+T0432*S4604-T0330*S1004+T0232
     4*S1002+T0434*S1503-T0534*S2404-T0342*S1502+T0240*S1502+T0442*S4603
     5-T0340*S1003-T0544*S2403+T0644*S3504-T0542*S3104+T0440*S4404
      TW3112=T0020*S0702-T0120*S0703+T0222*S1003-T0322*S1504+T0220*S1504
     3-T0130*S0702+T0230*S1303-T0332*S1003+T0432*S1004-T0330*S1004+T0240
     4*S1502-T0340*S1003+T0442*S2403-T0542*S4404+T0440*S4404
      TW3512=T0020*S0802-T0120*S0803+T0222*S1303-T0322*S1904+T0220*S1904
     3-T0130*S0802+T0230*S0803-T0332*S1303+T0432*S1904-T0330*S1904+T0240
     4*S1902-T0340*S1903+T0442*S3103-T0542*S4404+T0440*S4404
      TW0614=T0211*S0803-T0311*S1304
      TW0714=-T0322*S1303+T0220*S1303+T0422*S1904-T0320*S1904
      TW0814=T0221*S1303-T0321*S1904+T0433*S1903-T0331*S2803-T0533*S3104
     3+T0431*S3204
      TW0914=-T0332*S2803+T0230*S2803+T0432*S3204-T0330*S3204-T0544*S310
     33+T0442*S2803-T0340*S3203+T0644*S4404-T0542*S3204+T0440*S4504
      TW1314=T0221*S2003-T0321*S2804-T0331*S2803+T0431*S3004
      TW1414=-T0332*S2803+T0230*S2803+T0432*S3204-T0330*S3204+T0442*S320
     33-T0340*S3203-T0542*S4204+T0440*S4204
      TW2914=T0221*S1303-T0321*S1904-T0331*S1903+T0431*S3104
      TW3014=-T0332*S1903+T0230*S1903+T0432*S3104-T0330*S3104+T0442*S310
     33-T0340*S3103-T0542*S4404+T0440*S4404
      TW0115=T0000*S0402-T0100*S0403+T0200*S0804
      TW0215=-T0111*S0602+T0211*S0603-T0311*S1304
      TW0315=T0010*S0602-T0110*S0603+T0210*S1304+T0222*S0802-T0120*S0802
     3-T0322*S0803+T0220*S0803+T0422*S1904-T0320*S1904
      TW0415=-T0121*S1402+T0221*S1403-T0321*S2804-T0333*S1302+T0231*S200
     32+T0433*S1303-T0331*S2003-T0533*S3104+T0431*S3204
      TW0515=T0020*S1402-T0120*S1403+T0220*S2804+T0232*S1402-T0130*S1402
     3-T0332*S1403+T0230*S1403+T0432*S2804-T0330*S2804+T0444*S1902-T0342
     4*S2002+T0240*S2802-T0544*S1903+T0442*S2003-T0340*S2803+T0644*S4404
     5-T0542*S3204+T0440*S4504
      TW1015=T0010*S0602-T0110*S0603+T0210*S1304-T0120*S0802+T0220*S1403
     3-T0320*S1604
      TW1115=-T0121*S0802+T0221*S0803-T0321*S1904+T0231*S1302-T0331*S200
     33+T0431*S3004
      TW1215=T0020*S0802-T0120*S0803+T0220*S1904-T0130*S0802+T0230*S0603
     3-T0330*S2804+T0232*S1302-T0332*S1303+T0432*S3104-T0342*S1902+T0240
     4*S1902+T0442*S2803-T0340*S2803-T0542*S4204+T0440*S4204
      TW1515=T0020*S1402-T0120*S1403+T0220*S2804-T0130*S1402+T0230*S2103
     3-T0330*S1704+T0240*S2802-T0340*S1703+T0440*S3804
      TW2615=T0010*S0602-T0110*S0603+T0210*S1304-T0120*S0802+T0220*S0803
     3-T0320*S1904
      TW2715=-T0121*S0802+T0221*S0803-T0321*S1904+T0231*S1302-T0331*S130
     33+T0431*S3104
      TW2815=T0020*S0802-T0120*S0803+T0220*S1904-T0130*S0802+T0230*S0803
     3-T0330*S1904+T0232*S1302-T0332*S1303+T0432*S3104-T0342*S1902+T0240
     4*S1902+T0442*S1903-T0340*S1903-T0542*S4404+T0440*S4404
      TW3115=T0020*S0802-T0120*S0803+T0220*S1904-T0130*S0802+T0230*S0603
     3-T0330*S2804+T0240*S1902-T0340*S2803+T0440*S4204
      TW3515=T0020*S1402-T0120*S1403+T0220*S2804-T0130*S1402+T0230*S1403
     3-T0330*S2804+T0240*S2802-T0340*S2803+T0440*S4504
      TW2022=T0220*S1003+T0422*S1504-T0320*S1504
      TW2122=-T0331*S1503-T0533*S2404+T0431*S3104
      TW2222=T0230*S1503+T0432*S2404-T0330*S2404+T0442*S2403-T0340*S2403
     3+T0644*S3504-T0542*S3104+T0440*S4404
      TW2522=T0230*S1903+T0432*S3104-T0330*S3104-T0340*S3103-T0542*S4404
     3+T0440*S4404
      TW1624=T0211*S0703-T0311*S1004
      TW1724=-T0322*S1003+T0220*S1003+T0422*S1504-T0320*S1504
      TW1824=T0221*S1003-T0321*S1504+T0433*S1503-T0331*S1903-T0533*S2404
     3+T0431*S3104
      TW1924=-T0332*S1903+T0230*S1903+T0432*S3104-T0330*S3104-T0544*S240
     33+T0442*S1903-T0340*S3103+T0644*S3504-T0542*S3104+T0440*S4404
      TW2324=T0221*S1003-T0321*S1504-T0331*S1503+T0431*S3104
      TW2424=-T0332*S1503+T0230*S1503+T0432*S2404-T0330*S2404+T0442*S240
     33-T0340*S2403-T0542*S4404+T0440*S4404
      TW3224=T0221*S1303-T0321*S1904-T0331*S1903+T0431*S3104
      TW3324=-T0332*S1903+T0230*S1903+T0432*S3104-T0330*S3104+T0442*S310
     33-T0340*S3103-T0542*S4404+T0440*S4404
      TW2025=T0220*S1303-T0320*S1904
      TW2125=-T0331*S1903+T0431*S3104
      TW2225=T0230*S1903-T0330*S3104+T0442*S3103-T0340*S3103-T0542*S4404
     3+T0440*S4404
      TW2525=T0230*S2803-T0330*S3204-T0340*S3203+T0440*S4204
      TW3425=T0230*S2803-T0330*S3204-T0340*S3203+T0440*S4504
      TW0131=T0000*S0302-T0100*S0303+T0200*S0704
      TW0231=-T0111*S0502+T0211*S0503-T0311*S1004
      TW0331=T0010*S0502-T0110*S0503+T0210*S1004+T0222*S0702-T0120*S0702
     3-T0322*S0703+T0220*S0703+T0422*S1504-T0320*S1504
      TW0431=-T0121*S0802+T0221*S0803-T0321*S1904-T0333*S1002+T0231*S130
     32+T0433*S1003-T0331*S1303-T0533*S2404+T0431*S3104
      TW0531=T0020*S0802-T0120*S0803+T0220*S1904+T0232*S0802-T0130*S0802
     3-T0332*S0803+T0230*S0803+T0432*S1904-T0330*S1904+T0444*S1502-T0342
     4*S1302+T0240*S1902-T0544*S1503+T0442*S1303-T0340*S1903+T0644*S3504
     5-T0542*S3104+T0440*S4404
      TW1031=T0010*S0502-T0110*S0503+T0210*S1004-T0120*S0702+T0220*S0503
     3-T0320*S1904
      TW1131=-T0121*S0702+T0221*S0703-T0321*S1504+T0231*S1002-T0331*S070
     33+T0431*S3104
      TW1231=T0020*S0702-T0120*S0703+T0220*S1504-T0130*S0702+T0230*S1303
     3-T0330*S1004+T0232*S1002-T0332*S1003+T0432*S2404-T0342*S1502+T0240
     4*S1502+T0442*S1003-T0340*S1003-T0542*S4404+T0440*S4404
      TW1531=T0020*S0802-T0120*S0803+T0220*S1904-T0130*S0802+T0230*S0603
     3-T0330*S2804+T0240*S1902-T0340*S2803+T0440*S4204
      TW3131=T0020*S0702-T0120*S0703+T0220*S1504-T0130*S0702+T0230*S0503
     3-T0330*S1904+T0240*S1502-T0340*S1903+T0440*S4504
      RETURN
      END
      SUBROUTINE SHLOUTd(LIMIT,GOUT,IGOUT)
C*
C     --------------
C     U OF T VERSION
C     SEPTEMBER 1980
C     --------------
C*
C     TWO ELECTRON INTEGRAL OUTPUT ROUTINE
C     THE TWO ELECTRON INTEGRALS ARE WRITTEN ON UNIT ITWOEL IN BLOCKS
C     OF 3200 WORDS
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER SHELLA,SHELLN,SHELLT,AOS,Q,R,SINDX,aon
c
      parameter (maxg=1000)
      parameter (maxp=2000)
      common/ihol/ihold(maxg),ihsh(maxg),icent
C*
      COMMON IOP(45),ICDUM1(37),CDUM(94),ICDUM2(131)
C*

      COMMON/B/EXX(maxp),C1(maxp),C2(maxp),C3(240),
     *C(maxp,3),JAN(80),SHELLA(maxp),SHELLN(maxp),
     *SHELLT(maxp),AOS(maxg),AON(20),NSHELL,MAXTYP

      COMMON/IO/IIN,IOUT,IPUNCH,IMAT,ITWOEL,IDUMIO(50)
      COMMON/SHLINF/IDUM1(8),DUM1(120),IDUM2(4),INEW,JNEW,KNEW,LNEW
     $ ,IEND,JEND,KEND,LEND
      COMMON/C304A/IXP(4),JXP(4),KXP(4),LXP(4),XXP(4),IX(3200)
      parameter (maxat=100)
      parameter (nmax=500)
      parameter (n128=500)

c     parameter (mmax=1 000 000)
c     parameter (mgmax=5 000 000)
c     common /large/aa(mmax),g(mgmax),z(mmax),gt(mgmax)
      common /pointer/ipoint(maxat),ijpoint(maxat,maxat),na(maxat)     
      common /hold/jhold(nmax),llim(n128)
C*
      DIMENSION GOUT(IGOUT)
C*
      EQUIVALENCE (Q,JN),(R,MINDX,KN),(SINDX,LN)
C*
      DATA TENM6/1.0D-6/
      DATA TEN/10.0D0/
C*
 1000 FORMAT(1X,4(I9,3I3,1PD14.6))
 1010 FORMAT('1TWO ELECTRON INTEGRALS'//)
 1020 FORMAT(//1X,I10,' TWO ELECTRON INTEGRALS WRITTEN OUT ON UNIT',I3)
 1030 FORMAT(1X,I10,' INTEGRALS WERE SPLIT')
C*
      itwoel=9
 611  format(24i3)
      IF(LIMIT)10,350,50
C     PRELIMINARY ENTRY
   10 CUTOFF=TENM6
      IF(IOP(15).NE.0)CUTOFF=TEN**(-IOP(15))
      IOP18=IOP(18)
      ICOUNT=1
      NSPLIT=0
      REWIND ITWOEL
      IQ=1
      IF(IOP18.NE.0) WRITE (IOUT,1010)
C     COUNT NUMBER OF TWO ELECTRON INTEGRALS WRITTEN TO UNIT ITWOEL
      NTINTS=0
      RETURN
C     NORMAL ENTRY
C     INTEGRALS IN ARRAY GOUT WAITING TO BE WRITTEN OUT
C     DETERMINE NUMBERS OF THE FIRST ATOMIC ORBITALS IN EACH OF THE FOUR
C     SHELLS
   50 IP=AOS(INEW)-1
      JP=AOS(JNEW)-1
      KP=AOS(KNEW)-1
      LP=AOS(LNEW)-1
      NCOUNT=0
C     LOOP OVER SET OF INTEGRALS DEFINED BY SHELLS INEW ...
      DO 340 I=1,IEND
      DO 340 J=1,JEND
      DO 340 K=1,KEND
      DO 340 L=1,LEND
      NCOUNT=NCOUNT+1
C     DECIDE WHETHER OR NOT A PARTICULAR INTEGRAL IS LARGE ENOUGH
C     TO WARRANT KEEPING
      gf=GOUT(NCOUNT)
c     IF(DABS(gf).LE.CUTOFF)GO TO 340
      if(dabs(gf).lt.1.d-10) goto 340
C     KEEP THE INTEGRAL
C     ORDER ATOMIC ORBITALS SUCH THAT
C     I GE J
C     K GE L
C     I GE K
C     IF I EQ K
C     THEN J GE L
C     INTEGRAL OVER ATOMIC ORBITALS  (IJ/KL)
      IN=IP+I
      JN=JP+J
      KN=KP+K
      LN=LP+L
 340  continue     
 350  RETURN
      END

      SUBROUTINE SHLOUTdgo(LIMIT,GOUT,IGOUT)
C*
C     --------------
C     U OF T VERSION
C     SEPTEMBER 1980
C     --------------
C*
C     TWO ELECTRON INTEGRAL OUTPUT ROUTINE
C     THE TWO ELECTRON INTEGRALS ARE WRITTEN ON UNIT ITWOEL IN BLOCKS
C     OF 3200 WORDS
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER SHELLA,SHELLN,SHELLT,AOS,Q,R,SINDX,aon
c
      parameter (maxg=1000)
      parameter (maxp=2000)
      common/ihol/ihold(maxg),ihsh(maxg),icent
C*
      COMMON IOP(45),ICDUM1(37),CDUM(94),ICDUM2(131)
C*

      COMMON/B/EXX(maxp),C1(maxp),C2(maxp),C3(240),
     *C(maxp,3),JAN(80),SHELLA(maxp),SHELLN(maxp),
     *SHELLT(maxp),AOS(maxg),AON(20),NSHELL,MAXTYP

      COMMON/IO/IIN,IOUT,IPUNCH,IMAT,ITWOEL,IDUMIO(50)
      COMMON/SHLINF/IDUM1(8),DUM1(120),IDUM2(4),INEW,JNEW,KNEW,LNEW
     $ ,IEND,JEND,KEND,LEND
      COMMON/C304A/IXP(4),JXP(4),KXP(4),LXP(4),XXP(4),IX(3200)
      parameter (maxat=100)
      parameter (nmax=500)
      parameter (ndeckl=500)
      parameter (n128=500)

c     parameter (mmax=5 000 000)
c     parameter (mgmax=10 000 000)
c     common /large/aa(mmax),g(mgmax),z(mmax),gt(mgmax)
c     common /pointer/ipoint(maxat),ijpoint(maxat,maxat),na(maxat)     
      common /hold/jhold(nmax),llim(n128)
      common /c/cdummy(ndeckl,ndeckl),p(ndeckl,ndeckl)
      common/comp/ecomp1(maxat,maxat)
      common/map/imap1(maxp),imaps(maxp)
      common/pab/pa(ndeckl,ndeckl),pb(ndeckl,ndeckl)
C*
      DIMENSION GOUT(IGOUT)
C*
      EQUIVALENCE (Q,JN),(R,MINDX,KN),(SINDX,LN)
C*
      DATA TENM6/1.0D-6/
      DATA TEN/10.0D0/
C*
 1000 FORMAT(1X,4(I9,3I3,1PD14.6))
 1010 FORMAT('1TWO ELECTRON INTEGRALS'//)
 1020 FORMAT(//1X,I10,' TWO ELECTRON INTEGRALS WRITTEN OUT ON UNIT',I3)
 1030 FORMAT(1X,I10,' INTEGRALS WERE SPLIT')
C*
      itwoel=9
 611  format(24i3)
c     print *,'limit=',limit
      IF(LIMIT)11,350,50
C     PRELIMINARY ENTRY
   11 CUTOFF=TENM6
      IF(IOP(15).NE.0)CUTOFF=TEN**(-IOP(15))
      IOP18=IOP(18)
      ICOUNT=1
      NSPLIT=0
      REWIND ITWOEL
      IQ=1
      IF(IOP18.NE.0) WRITE (IOUT,1010)
C     COUNT NUMBER OF TWO ELECTRON INTEGRALS WRITTEN TO UNIT ITWOEL
      NTINTS=0
      RETURN
C     NORMAL ENTRY
C     INTEGRALS IN ARRAY GOUT WAITING TO BE WRITTEN OUT
C     DETERMINE NUMBERS OF THE FIRST ATOMIC ORBITALS IN EACH OF THE FOUR
C     SHELLS
   50 IP=AOS(INEW)-1
      JP=AOS(JNEW)-1
      KP=AOS(KNEW)-1
      LP=AOS(LNEW)-1
      NCOUNT=0
C     LOOP OVER SET OF INTEGRALS DEFINED BY SHELLS INEW ...
      DO 340 I=1,IEND
      DO 340 J=1,JEND
      DO 340 K=1,KEND
      DO 340 L=1,LEND
      NCOUNT=NCOUNT+1
C     DECIDE WHETHER OR NOT A PARTICULAR INTEGRAL IS LARGE ENOUGH
C     TO WARRANT KEEPING
      gf=GOUT(NCOUNT)
c     IF(DABS(gf).LE.CUTOFF)GO TO 340
      if(dabs(gf).lt.1.d-10) goto 340
C     KEEP THE INTEGRAL
C     ORDER ATOMIC ORBITALS SUCH THAT
C     I GE J
C     K GE L
C     I GE K
C     IF I EQ K
C     THEN J GE L
C     INTEGRAL OVER ATOMIC ORBITALS  (IJ/KL)
      IN=IP+I
      JN=JP+J
      KN=KP+K
      LN=LP+L

c Itt van meg az integral (gout) es az indexek (in,jn,kn,ln)
      call code(in,kn,jn,ln,i1,i2,i3,i4,kulcs)
c     print *,gf,i1,i2,i3,i4,kulcs
       goto(1,1,1,4,4,4,7,7,7,10,10,12,13,14) kulcs 
    1  ip1=ihold(i1)
       ip2=ihold(i2)
       ip3=ihold(i3)
       ip4=ihold(i4)
       ppd=p(i3,i1)*p(i4,i2)-pa(i4,i1)*pa(i3,i2)-pb(i4,i1)*pb(i3,i2) 
       ppd1=p(i3,i1)*p(i4,i2)-pa(i4,i3)*pa(i1,i2)-pb(i4,i3)*pb(i1,i2) 
       if(ip3.le.ip4) ecomp1(ip3,ip4)=ecomp1(ip3,ip4)+ppd*gf         
       if(ip3.gt.ip4) ecomp1(ip4,ip3)=ecomp1(ip4,ip3)+ppd*gf         
       if(ip2.le.ip3) ecomp1(ip2,ip3)=ecomp1(ip2,ip3)+ppd1*gf         
       if(ip2.gt.ip3) ecomp1(ip3,ip2)=ecomp1(ip3,ip2)+ppd1*gf         
       ecomp1(ip1,ip4)=ecomp1(ip1,ip4)+ppd1*gf         
       ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd*gf        
c       print *,'ecomp-2o',ecomp1(ip1,ip2)
       goto 9999
    4  ip1=ihold(i1)
       ip2=ihold(i3)
       ip3=ihold(i4) 
       ppd=p(i3,i1)*p(i4,i1)-pa(i3,i1)*pa(i4,i1)-pb(i3,i1)*pb(i4,i1)
       ppd1=p(i3,i1)*p(i1,i4)-pa(i1,i1)*pa(i3,i4)-pb(i1,i1)*pb(i3,i4) 
       if(ip1.le.ip2) ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd1*gf        
       if(ip2.lt.ip1) ecomp1(ip2,ip1)=ecomp1(ip2,ip1)+ppd1*gf         
       if(ip1.le.ip3) ecomp1(ip1,ip3)=ecomp1(ip1,ip3)+ppd1*gf        
       if(ip3.lt.ip1) ecomp1(ip3,ip1)=ecomp1(ip3,ip1)+ppd1*gf         
       ecomp1(ip2,ip3)=ecomp1(ip2,ip3)+ppd*gf         
       ecomp1(ip1,ip1)=ecomp1(ip1,ip1)+ppd*gf         
       goto 9999
    7  ip1=ihold(i1)
       ip2=ihold(i2)
       ip3=ihold(i4)
       ppd=p(i1,i1)*p(i4,i2)-pa(i4,i1)*pa(i1,i2)-pb(i4,i1)*pb(i1,i2) 
       if(ip1.le.ip3) ecomp1(ip1,ip3)=ecomp1(ip1,ip3)+ppd*gf        
       if(ip3.lt.ip1) ecomp1(ip3,ip1)=ecomp1(ip3,ip1)+ppd*gf         
       if(ip1.le.ip2) ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd*gf        
       if(ip2.lt.ip1) ecomp1(ip2,ip1)=ecomp1(ip2,ip1)+ppd*gf         
       goto 9999
   10  ip1=ihold(i1)
       ip2=ihold(i4)
       ppd=p(i1,i1)*p(i4,i1)-pa(i1,i1)*pa(i4,i1)-pb(i1,i1)*pb(i4,i1)
       if(ip1.le.ip2) ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd*gf         
       if(ip2.lt.ip1) ecomp1(ip2,ip1)=ecomp1(ip2,ip1)+ppd*gf         
       ecomp1(ip1,ip1)=ecomp1(ip1,ip1)+ppd*gf         
       goto 9999
   12  ip1=ihold(i1)
       ppd=p(i1,i1)*p(i1,i1)-pa(i1,i1)*pa(i1,i1)-pb(i1,i1)*pb(i1,i1)    
       ecomp1(ip1,ip1)=ecomp1(ip1,ip1)+0.5d0*ppd*gf
       goto 9999
   13  ip1=ihold(i1)
       ip2=ihold(i2)
       ppd=p(i1,i1)*p(i2,i2)-pa(i2,i1)*pa(i1,i2)-pb(i2,i1)*pb(i1,i2) 
       ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd*gf
       goto 9999
   14  ip1=ihold(i1)
       ip2=ihold(i3)
       ppd=p(i3,i1)*p(i3,i1)-pa(i3,i1)*pa(i3,i1)-pb(i3,i1)*pb(i3,i1)
       ppd1=p(i1,i3)*p(i1,i3)-pa(i1,i1)*pa(i3,i3)-pb(i1,i1)*pb(i3,i3)
       ecomp1(ip1,ip1)=ecomp1(ip1,ip1)+0.5d0*ppd*gf
       ecomp1(ip2,ip2)=ecomp1(ip2,ip2)+0.5d0*ppd*gf
       ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd1*gf
       goto 9999

 9999 continue


      
 340  continue
 350  RETURN
 612  format(4i3,1pe20.10)
      END
