
      subroutine numintbypairs(nat0,irat,iarg)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (PI=3.141592653589793D0)
      PARAMETER (maxp=2000,maxg=1000,maxc=16,maxat=60) 
c     parameter (NMAX=100000)
      parameter (nmax=900)
      dimension Coul(maxat,maxat),Exch(maxat,maxat)
      dimension Epa(maxat,maxat)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)
      common /coord/ coord(3,maxat),zn(maxat)
      common /pr/iprint
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)
      common /c/ps(nmax,nmax),p(nmax,nmax),c(nmax,nmax)

      common/actual/iact,jat,icenter
      common/pipi/pir,pisqrt
      common /hold/ihold(nmax),illim(nmax)
      common/pha2/pha
      character*30 integ1,integ2
      dimension wp(:),wppha(:),chp(:,:),chp2(:,:),chp2pha(:,:)
      dimension scr(:),scr2(:),pcoordspha(:,:),pcoords(:,:)
      allocatable wp,wppha,chp,chp2,chp2pha,scr,scr2,pcoordspha,pcoords
      dimension sab(maxat,maxat)
      dimension irat(nat0)

      Pi1=dacos(-1.d0)
      pisqrt=dsqrt(pi)
      iul=ifiul(igr)
      call prepar

C PSS
      call getarg(iarg+1,integ1)
      call getarg(iarg+2,integ2)
      if(integ1.ne.' '.and.integ2.ne.' ') then
       read(integ1,'(i4)') Nrad        
       read(integ2,'(i4)') Nang        
      else
C PSS
       read(60,*,end=111,err=111) nrad,nang
      end if
       print *,' '
       print *,' '
       print *,' Radial points: ', nrad
c Possible values for Nang: 6,14,26,38,50,74,86,110,146,170,
c                   194,230,266,302,350,434,590,770,974'
       goto 112
 111   nrad=40
       nang=146
       print *,' Radial points: ', nrad
 112   call quad(Nrad,Nang) 
       if(Nrad.gt.100) then
       print *, 'The number of radial points per atom must not ',
     $ 'exceed 100' 
       stop
       else
       endif        

      iatps=Nang*NRad

      xmem=iatps*nat0*(igr+10+2*nocc)*8.0/(1024.0*1024)
      xmem0=(2000*24+3*maxat*maxat+3*nmax*nmax+5)*8/(1024.0*1024)
       print *,' '
      write(*,'(a32,f5.1)') 'Allocted memory used   (MB)',xmem
      write(*,'(a32,f5.1)') 'Non allocated memory   (MB)',xmem0
       print *,' '

      allocate(wp(iatps*nat0),chp(iatps*nat0,igr),pcoords(iatps*nat0,3))

c    Generating grid for AO, weigths, and coordinates
      pha=0.0d0
      do i=1,igr
       ipoint=1
       iact=i
       do jat0=1,nat0
        icenter=irat(jat0)
        call fpoints(nat0,ipoint,chp,Nang,NRad)
        ipoint=ipoint+iatps
       enddo
      end do  
      ipoints=ipoint-1
      print *,' Number of grid points:',ipoints         
       ipoint=1
       do jat0=1,nat0
        icenter=irat(jat0)
        call rpoints(nat0,ipoint,wp,Nang,NRad)
        ipoint=ipoint+iatps
       enddo
c   now wpoints is changed
       ipoint=1
       do jat0=1,nat0
        icenter=irat(jat0)
        call wpoints(nat0,ipoint,wp,Nang,NRad)
        ipoint=ipoint+iatps
       enddo
       ipoint=1
       do jat0=1,nat0
        icenter=irat(jat0)
        call distance(nat0,ipoint,pcoords,Nang,NRad)
        ipoint=ipoint+iatps
       enddo


C   DOING ENERGY PARTITION
C   ONE-ELECTRON PART
      do i=1,nat0
	do j=1,nat0
	 epa(i,j)=0.0d0
	end do
      end do

c to MO
      allocate(chp2(iatps*nat0,nocc))
       do j=1,nocc
        do k=1,ipoints
         xx=0.0d0
         do i=1,igr 
          xx=xx+c(i,j)*chp(k,i) 
	 end do
         chp2(k,j)=xx
        end do
       end do

c       write(*,*) 'electron-nuclei atraction integrals'
       xtot0=0.0d0
       do mu=1,nocc 
        xtot=0.0d0
       do iat0=1,nat0
        icenter=irat(iat0)
        do jat0=1,nat0
         jcenter=irat(jat0)
          x=0.0d0
          zz=zn(jcenter)
          dx0=coord(1,jcenter)
          dy0=coord(2,jcenter)
          dz0=coord(3,jcenter)
          do ifut=iatps*(iat0-1)+1,iatps*iat0
           distx=pcoords(ifut,1)-dx0
           disty=pcoords(ifut,2)-dy0
           distz=pcoords(ifut,3)-dz0
           rr=dsqrt(distx*distx+disty*disty+distz*distz)
           if(rr.gt.1.0d-12) then
            x=x+zz*wp(ifut)*chp2(ifut,mu)*chp2(ifut,mu)/rr
           end if
          end do
c          write(*,667) icenter,'<',mu,'|Z/r',jcenter,'|',mu,'>',x
          xtot=xtot+x
          epa(iat0,jat0)=epa(iat0,jat0)-2.0d0*x
         enddo
        enddo
  667    format(i2,a2,i2,a4,i2,a,i2,a,f22.12)
       enddo

c   kinetic 

c generating grid for 2on derivative over AOs
      do i=1,igr 
       ipoint=1
       iact=i
       do jat0=1,nat0
        icenter=irat(jat0)
        call dpoints(nat0,ipoint,chp,Nang,NRad)
        ipoint=ipoint+iatps
       enddo
      end do   
      ipoints=ipoint-1 

c now to MO and multiply by MOs AND SUM OVER MOs using scratch array
      allocate(scr(iatps*nat0))
      do k=1,ipoints
       x=0.0d0
       do j=1,nocc
        xx=0.0d0
        do i=1,igr 
          xx=xx+c(i,j)*chp(k,i) 
        end do
        x=x+chp2(k,j)*xx
       end do
       scr(k)=x
      end do

      xtot=0.0d0
      do iat0=1,nat0
       icenter=irat(iat0)
       ifut=iatps*(iat0-1)+1
       do kk=1,nrad
        do ii=1,nang
         do jat0=1,nat0
          jcenter=irat(jat0)
          x=wp(ifut)*scr(ifut)*www2(jcenter,ii,kk)
          epa(iat0,jat0)=epa(iat0,jat0)+x
          xtot=xtot+x
	 end do
	 ifut=ifut+1
        end do
       enddo
      enddo

c  nuclear repulsion
	xtot=0.0
	do i=1,nat0
	 do j=i+1,nat0
          dist=dsqrt((coord(1,irat(i))-coord(1,irat(j)))**2 
     1    +(coord(2,irat(i))-coord(2,irat(j)))**2+(coord(3,irat(i))
     1    -coord(3,irat(j)))**2)
          epa(i,j)=epa(i,j)+zn(irat(i))*zn(irat(j))/dist
	  xtot=xtot+zn(irat(i))*zn(irat(j))/dist
	 end do
	end do

	do i=1,nat0
	 etot=etot+epa(i,i)
	 do j=i+1,nat0
	  etot=etot+epa(i,j)+epa(j,i)
	 end do
	end do

C overlap!!!r
c now to MO and multiply by MOs AND SUM OVER MOs using scratch array
      do k=1,ipoints
       x=0.0d0
       do j=1,nocc
        x=x+chp2(k,j)*chp2(k,j)
       end do
       scr(k)=x
      end do

c	do i=1,nat0
c	 do j=1,nat0
c	 sab(i,j)=0.0d0
c	end do
c	end do

c      xtot=0.0d0
c      do iat0=1,nat0
c       icenter=irat(iat0)
c       ifut=iatps*(iat0-1)+1
c       do kk=1,nrad
c        do ii=1,nang
c         do jat0=1,nat0
c          jcenter=irat(jat0)
c          x=wp(ifut)*scr(ifut)*www2(jcenter,ii,kk)
c          sab(iat0,jat0)=sab(iat0,jat0)+x
c          xtot=xtot+x
c         end do
c         ifut=ifut+1
c        end do
c       enddo
c      enddo
c	do i=1,nat0
c	 sab(i,i)=2.0d0*sab(i,i)
c	 do j=i+1,nat0
c	 sab(i,j)=(sab(i,j)+sab(j,i))
c	 sab(j,i)=sab(i,j)
c	end do
c	end do
c        write(*,*) ''
c        write(*,*) 'OVERLAP DENSITY'
c        write(*,*) ''
c         write(*,'(a2,8(i3,a5))')'     ',(j,'     ',j=1,nat0)
c        do i=1,nat0
c         write(*,'(8f10.5)') (sab(i,j),j=1,nat0)
c        end do
c        write(*,*) ''
c
c two electron part. Double integration over rotated grids for better accuracy
       write(*,*) '##############################'
       write(*,*) ' Doing two-electron integrals'
       write(*,*) '##############################'
       call flush(6)

c   phase angle for phi...
      allocate(wppha(iatps*nat0),pcoordspha(iatps*nat0,3))
      pha=1.8d0         
c      write(*,*) 'Phase on phi for grid' ,pha
      do i=1,igr
       ipoint=1
       iact=i
       do jat0=1,nat0
        icenter=irat(jat0)
        call fpoints(nat0,ipoint,chp,Nang,NRad)
        ipoint=ipoint+iatps
       enddo
      end do
      ipoint=1
       do jat0=1,nat0
        icenter=irat(jat0)
       call rpoints(nat0,ipoint,wppha,Nang,NRad)
       ipoint=ipoint+iatps
      enddo
      ipoint=1
      do jat0=1,nat0
       icenter=irat(jat0)
       call wpoints(nat0,ipoint,wppha,Nang,NRad)
       ipoint=ipoint+iatps
      enddo
      ipoint=1
      do jat0=1,nat0
       icenter=irat(jat0)
       call distance(nat0,ipoint,pcoordspha,Nang,NRad)
       ipoint=ipoint+iatps
      enddo
c to MO
      allocate(chp2pha(iatps*nat0,nocc))
       do k=1,ipoints
        scr(k)=0.0d0
        do j=1,nocc
         xx=0.0d0
         do i=1,igr 
          xx=xx+c(i,j)*chp(k,i) 
	 end do
         chp2pha(k,j)=xx
         scr(k)=scr(k)+xx*xx
        end do
       end do
c make electron density
      allocate(scr2(iatps*nat0))
       do k=1,ipoints
        xx=0.0d0
        x=0.0d0
        do i=1,nocc    
         xx=xx+chp2(k,i)*chp2(k,i) 
	end do
        scr2(k)=xx
       end do

	  do i=1,nat0 
	   do j=1,nat0
	    coul(i,j)=0.0d0
	    exch(i,j)=0.0d0
	   end do
          end do

C Coulomb contribution. Using rho(k)!
c     scr(k) contains rho(k) for rotated grid
c     scr2(k) rho(k) for non-rotated grid  
c     chp2(k,j) the MO for non-rotated grid  
c     chp2pha(k,j) the MO for rotated grid  

	  f2=0.0d0
          do iat0=1,nat0
           icenter=irat(iat0)
           do ifut=iatps*(iat0-1)+1,iatps*iat0
            x0=wppha(ifut)
            dx0=pcoordspha(ifut,1)
            dy0=pcoordspha(ifut,2)
            dz0=pcoordspha(ifut,3)
            f2=f2+scr(ifut)*x0
C same center
            f3=0.0d0
            do jfut=iatps*(iat0-1)+1,iatps*iat0    
             x1=wp(jfut)
             dx1=pcoords(jfut,1)
             dy1=pcoords(jfut,2)
             dz1=pcoords(jfut,3)
             dist=dsqrt((dx0-dx1)**2+(dy0-dy1)**2+(dz0-dz1)**2)
             if(dist.gt.1.0d-8) then
              f3=f3+scr(ifut)*scr2(jfut)*x1*x0/dist
	     end if
	    end do
            coul(iat0,iat0)= coul(iat0,iat0)+ f3
C pairs of centers
	    do jat0=iat0+1,nat0
             f3=0.0d0
             do jfut=iatps*(jat0-1)+1,iatps*jat0
              x1=wp(jfut)
              dx1=pcoords(jfut,1)
              dy1=pcoords(jfut,2)
              dz1=pcoords(jfut,3)
              dist=dsqrt((dx0-dx1)**2+(dy0-dy1)**2+(dz0-dz1)**2)
              if(dist.gt.1.0d-8 ) then
               f3=f3+scr(ifut)*scr2(jfut)*x1*x0/dist
	      end if
	     end do
             coul(iat0,jat0)= coul(iat0,jat0)+ f3
            enddo

           enddo
          enddo

c check integration of rho
c        write(*,*) 'charge ',2.0d0*f2                
	coulen=0.0d0
	do i=1,nat0
	 coul(i,i)=2.0d0*coul(i,i)
	 coulen=coulen+coul(i,i)
         do j=i+1,nat0
	  coul(i,j)=2.0*coul(i,j)
	  coul(j,i)=coul(i,j)
	  coulen=coulen+coul(i,j)+coul(j,i)
	 end do
	end do

c Now Exchange part. BOTTLENECK!! shit...
c     scr(k) contains rho(k) for rotated grid
c     scr2(k) rho(k) for non-rotated grid  
c     chp2(k,j) the MO for non-rotated grid  
c     chp2pha(k,j) the MO for rotated grid  

          do iat0=1,nat0
           icenter=irat(iat0)
           do ifut=iatps*(iat0-1)+1,iatps*iat0
            x0=wppha(ifut)
            dx0=pcoordspha(ifut,1)
            dy0=pcoordspha(ifut,2)
            dz0=pcoordspha(ifut,3)
	    do i=1,nocc
             do j=i,nocc
               f2=x0*chp2pha(ifut,i)*chp2pha(ifut,j)
             if(i.ne.j) f2=2.0d0*f2
C same center
            f3=0.0d0
            do jfut=iatps*(iat0-1)+1,iatps*iat0
             x1=wp(jfut)
             dx1=pcoords(jfut,1)
             dy1=pcoords(jfut,2)
             dz1=pcoords(jfut,3)
             dist=dsqrt((dx0-dx1)**2+(dy0-dy1)**2+(dz0-dz1)**2)
             if(dist.gt.1.0d-8) then
              f3=f3+f2*x1*chp2(jfut,i)*chp2(jfut,j)/dist
	     end if
	    end do
            exch(iat0,iat0)= exch(iat0,iat0)- f3
C pairs of centers
	    do jat0=iat0+1,nat0
             f3=0.0d0
             do jfut=iatps*(jat0-1)+1,iatps*jat0
              x1=wp(jfut)
              dx1=pcoords(jfut,1)
              dy1=pcoords(jfut,2)
              dz1=pcoords(jfut,3)
              dist=dsqrt((dx0-dx1)**2+(dy0-dy1)**2+(dz0-dz1)**2)
              if(dist.gt.1.0d-8 ) then
               f3=f3+f2*x1*chp2(jfut,i)*chp2(jfut,j)/dist
	      end if
	     end do
             exch(iat0,jat0)= exch(iat0,jat0)- f3
c	   end if
            enddo
            enddo
            enddo
            enddo
            enddo

	exchen=0.0d0
	do i=1,nat0
	 exchen=exchen+exch(i,i)
         do j=i+1,nat0
	  exch(j,i)=exch(i,j)
	  exchen=exchen+exch(i,j)+exch(j,i)
	 end do
	end do
	
c 
        do i=1,nat0
         epa(i,i)=epa(i,i)+coul(i,i)+exch(i,i)
	 do j=i+1,nat0
          epa(i,j)=epa(i,j)+epa(j,i)+2.0d0*(coul(i,j)+exch(i,j))
          epa(j,i)=epa(i,j)
	 end do
	end do
c	write(*,*) ' '
c	write(*,*) '******************************'
c	write(*,*) '****FUZZY ENERGY PARTITION****'
c	write(*,*) '******************************'
c	write(*,*) ' '
c        write(*,'(8(a4,i2,a4))') ('    ',i,'    ',i=1,nat0)
c        do i=1,nat0
c         write(*,'(8F10.4)') (epa(j,i),j=1,i)
c	end do
        WRITE(*,6342)
 6342   FORMAT(1x,/21X,'"FUZZY ATOMS" ENERGY COMPONENTS'//)
        CALL Mprint2(epa,NAT0,maxat,irat)

      deallocate(wp,chp,pcoords,chp2pha,wppha,pcoordspha,scr,chp2,scr2)

      
      return
      end

      subroutine distance(nat0,ipoint,pcoords,N,Nrad)
      IMPLICIT REAL*8(A-H,O-Z)
      parameter (nmax=900,maxat=60)
      PARAMETER (PI=3.141592653589793D0)
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)
      common/actual/iact,jat,icenter
      common /coord/ coord(3,maxat),zn(maxat)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      dimension pcoords(n*nrad*nat0,3)
      common/pha2/pha

c	phase
      ii=ipoint
      do j=1,Nrad
       do i=1,n
        thx=th(i)
        fix=ph(i)+pha
        rr=xr(j)
        pcoords(ii,1)=rr*dsin(thx)*dcos(fix)+coord(1,icenter)
        pcoords(ii,2)=rr*dsin(thx)*dsin(fix)+coord(2,icenter) 
        pcoords(ii,3)=rr*dcos(thx)+coord(3,icenter)
        ii=ii+1
      end do
      end do
      return
      end


      subroutine rpoints(nat0,ipoint,wp,N,Nrad)
      IMPLICIT REAL*8(A-H,O-Z)
      parameter (nmax=900)
      PARAMETER (PI=3.141592653589793D0)
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)
      common/actual/iact,jat,icenter
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      dimension wp(n*nrad*nat0)

      irun=ipoint                                                                  
      do k=1,Nrad
       xxr=wr(k)*xr(k)*xr(k)
       do i=1,N
        wp(irun)=w(i)*xxr*4.d0*Pi
        irun=irun+1
       enddo
      enddo
      return
      end

      subroutine dpoints(nat0,ipoint,chp,N,Nrad)
      IMPLICIT REAL*8(A-H,O-Z)
      parameter (nmax=900)
      PARAMETER (PI=3.141592653589793D0)
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)
      common/actual/iact,jat,icenter
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      dimension chp(n*nrad*nat0,igr)
 
      irun=ipoint
      do k=1,Nrad
       do i=1,N
        chp(irun,iact)=dfunct(i,k)
        irun=irun+1
       enddo
      enddo
 
      return
      end
      


      subroutine fpoints(nat0,ipoint,chp,N,Nrad)
      IMPLICIT REAL*8(A-H,O-Z)
      parameter (nmax=900)
      PARAMETER (PI=3.141592653589793D0)
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)
      common/actual/iact,jat,icenter
      common/pha2/pha
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      dimension chp(n*nrad*nat0,igr)

      irun=ipoint                                                                  
      do k=1,Nrad
       do i=1,N
        chp(irun,iact)=funct(i,k)
        irun=irun+1
       enddo
      enddo
      
      return
      end

      subroutine wpoints(nat0,ipoint,omp,N,Nrad)
      IMPLICIT REAL*8(A-H,O-Z)
      parameter (nmax=900)
      PARAMETER (PI=3.141592653589793D0)
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)
      common/actual/iact,jat,icenter
      common/pha2/pha
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      dimension omp(n*nrad*nat0)

      irun=ipoint                                                                  
      do k=1,Nrad
       do i=1,N
        omp(irun)=omp(irun)*www(i,k)
        irun=irun+1
       enddo
      enddo
      return
      end

      function dfunct(i,k)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (PI=3.141592653589793D0)
      PARAMETER (maxp=2000,maxg=1000,maxc=16,maxat=60) 
      parameter (mgmax=10 000 000)
      parameter (nmax=900)
      common /nat/ nat,igr,ifg,idum(4)
      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)
      common /coord/ coord(3,maxat),zn(maxat)
      common /hold/ihold(nmax),illim(nmax)
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)
      common/actual/iact,jact,icenter
      common/pipi/pir,pisqrt
      
      iactat=ihold(iact)
      f=0.d0
      thx=th(i)
      fix=ph(i)
      rr=xr(k)
      xabs=rr*dsin(thx)*dcos(fix)+coord(1,icenter)
      yabs=rr*dsin(thx)*dsin(fix)+coord(2,icenter)
      zabs=rr*dcos(thx)+coord(3,icenter)
      x=xabs-coord(1,iactat)   
      y=yabs-coord(2,iactat)   
      z=zabs-coord(3,iactat)   
      rr=dsqrt(x**2+y**2+z**2)
      ngri=ifiul(iact)-ifill(iact)+1
      do ki=1,ngri
       ipr=ifill(iact)+ki-1
       nn=n(ipr)
       ll=l(ipr)
       mm=m(ipr)
       alpha=expp(ipr)
       alpha2=alpha*alpha
       dx2=4.0d0*alpha2*(x**(nn+2))-(2.0d0*alpha*(x**nn)*(2.0*nn+1.0))
       if(nn.ge.2) dx2=dx2+nn*(nn-1)*x**(nn-2)
       dx2=dx2*(y**ll)*(z**mm)

       dy2=4.0d0*alpha2*(y**(ll+2))-(2.0d0*alpha*(y**ll)*(2.0*ll+1.0))
       if(ll.ge.2) dy2=dy2+ll*(ll-1)*y**(ll-2)
       dy2=dy2*(x**nn)*(z**mm)

       dz2=4.0d0*alpha2*(z**(mm+2))-(2.0d0*alpha*(z**mm)*(2.0*mm+1.0))
       if(mm.ge.2) dz2=dz2+mm*(mm-1)*z**(mm-2)
       dz2=dz2*(x**nn)*(y**ll)

       dd=(dx2+dy2+dz2)*dexp(-expp(ipr)*(rr**2))
       f=f+dd*coeff(iact,ki)
      enddo

      dfunct=-f
      
      return
      end


      function funct(i,k)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (PI=3.141592653589793D0)
      PARAMETER (maxp=2000,maxg=1000,maxc=16,maxat=60) 
      parameter (mgmax=10 000 000)
      parameter (nmax=900)
      common /nat/ nat,igr,ifg,idum(4)
      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)
      common /coord/ coord(3,maxat),zn(maxat)
      common /hold/ihold(nmax),illim(nmax)
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)

      common/actual/iact,jact,icenter
      common/pipi/pir,pisqrt
      common/pha2/pha
      
      iactat=ihold(iact)
      f=0.d0
      thx=th(i)
      fix=ph(i)+pha
      rr=xr(k)
c     print *,th,fi,rr,f
      xabs=rr*dsin(thx)*dcos(fix)+coord(1,icenter)
      yabs=rr*dsin(thx)*dsin(fix)+coord(2,icenter)
      zabs=rr*dcos(thx)+coord(3,icenter)
      x=xabs-coord(1,iactat)   
      y=yabs-coord(2,iactat)   
      z=zabs-coord(3,iactat)   
      rr=dsqrt(x**2+y**2+z**2)
      ngri=ifiul(iact)-ifill(iact)+1
      do ki=1,ngri
      ipr=ifill(iact)+ki-1
      nn=n(ipr)
      ll=l(ipr)
      mm=m(ipr)
      f=f+(x**nn)*(y**ll)*(z**mm)*dexp(-expp(ipr)*(rr**2))
     $    *coeff(iact,ki)
      enddo

      funct=f
      
      return
      end

      function www(i,k)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (PI=3.141592653589793D0)
      PARAMETER (maxp=2000,maxg=1000,maxc=16,maxat=60) 
      parameter (nmax=900)
      common /nat/ nat,igr,ifg,idum(4)

      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)
      common /coord/ coord(3,maxat),zn(maxat)
      common /hold/ihold(nmax),illim(nmax)
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)

      common/actual/iact,jact,icenter
      common/pipi/pir,pisqrt
      common/pha2/pha
      
      iactat=ihold(iact)
      f=0.d0
      thx=th(i)
      fix=ph(i)+pha
      rr=xr(k)
      xabs=rr*dsin(thx)*dcos(fix)+coord(1,icenter)
      yabs=rr*dsin(thx)*dsin(fix)+coord(2,icenter)
      zabs=rr*dcos(thx)+coord(3,icenter)

      www=wat(icenter,xabs,yabs,zabs)    
      
      return
      end


      function www2(jcenter,i,k)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (PI=3.141592653589793D0)
      PARAMETER (maxp=2000,maxg=1000,maxc=16,maxat=60)
      parameter (nmax=900)
      common /nat/ nat,igr,ifg,idum(4)
 
      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)
      common /coord/ coord(3,maxat),zn(maxat)
      common /hold/ihold(nmax),illim(nmax)
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)
 
      common/actual/iact,jact,icenter
      common/pipi/pir,pisqrt
      common/pha2/pha
 
      iactat=ihold(iact)
      f=0.d0
      thx=th(i)
      fix=ph(i)+pha
      rr=xr(k)
      xabs=rr*dsin(thx)*dcos(fix)+coord(1,icenter)
      yabs=rr*dsin(thx)*dsin(fix)+coord(2,icenter)
      zabs=rr*dcos(thx)+coord(3,icenter)
 
      www2=wat(jcenter,xabs,yabs,zabs)
 
      return
      end



      
      subroutine prepar
      implicit real*8 (a-h,o-z)
      parameter (maxat=60)
      dimension atrad(92)
      common /atomrad/atr(maxat),dist(maxat,maxat)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      common /coord/ coord(3,maxat),zn(maxat)
      common /ia/iznuc(maxat),kop,megall
      RR(x,y,z)=dsqrt(x**2+y**2+z**2)

C Atomradiuszokat ertelmesen feltolteni!
      atrad(1)=.35d0/0.529177

      atrad(3)=1.45d0/0.529177
      atrad(4)=1.05d0/0.529177
      atrad(5)=.85d0/0.529177

      atrad(6)=.7d0/0.529177
      atrad(7)=.65d0/0.529177
      atrad(8)=.6d0/0.529177
      atrad(9)=.5d0/0.529177


      atrad(11)=1.8d0/0.529177
      atrad(12)=1.5d0/0.529177
      atrad(13)=1.25d0/0.529177
      atrad(14)=1.1d0/0.529177
      atrad(15)=1.d0/0.529177
      atrad(16)=1.d0/0.529177
      atrad(17)=1.d0/0.529177
      
      
      do i=1,nat
      ia=iznuc(i)
      atr(i)=atrad(ia)
      enddo
      
c     print *,'atr/prepar',(atr(i),i=1,nat)
C Atomradiuszokat ertelmesen feltolteni!
      

      do i=1,nat-1
      dist(i,i)=0.d0
      do j=i+1,nat
      dist(i,j)=RR(coord(1,i)-coord(1,j),coord(2,i)-coord(2,j),
     $   coord(3,i)-coord(3,j))
      dist(j,i)=dist(i,j)
      enddo
      enddo
      print *,' '
c     print *,' '
c     print *, "Distance matrix"
      print *,' '
      print *,' '
c     do i=1,nat
c     print *, (dist(i,j),j=1,nat)
c     enddo
c     print *,' '
c     print *,' '
      return
      end
      
      function pp(ii,x,y,z)
      implicit real*8 (a-h,o-z)
      parameter (maxat=60)
      common /atomrad/atr(maxat),dist(maxat,maxat)
      common /coord/ coord(3,maxat),zn(maxat)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      common /chi/chi

      dimension r(maxat)

      RR(x,y,z)=dsqrt(x**2+y**2+z**2)
      
c     print *, 'Entering pp',ii,x,y,z,nat,(atr(i),i=1,nat)
c     print *,'atr/pp',(atr(i),i=1,nat)
      do i=1,nat
      r(i)=RR(x-coord(1,i),y-coord(2,i),z-coord(3,i))
      enddo
      p=1.d0
      do 100 j=1,nat
      if(j.eq.ii)goto 100
      chi=atr(ii)/atr(j)
      amu=(r(ii)-r(j))/dist(ii,j)
c     print *, 'Calling sbecke', amu,chi
c     z=sbecke(amu)
c     print *,'sbecke',amu,sbecke(amu)
c     p=p*z
      p=p*sbecke(amu)
  100 continue     
      pp=p
c     print *,'pp',pp
      return
      end

      function wat(ii,x,y,z)
      implicit real*8 (a-h,o-z)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      sum=0.d0 
      do i=1,nat
      p=pp(i,x,y,z)
      sum=sum+p
      if(i.eq.ii)ww=p
      enddo
      wat=ww/sum
      return
      end

    
      function sbecke(amu)
      implicit real*8 (a-h,o-z)
      common /chi/chi
      p(x)=x*(1.5d0-.5d0*x**2)
c     print *,'chi/sbecke',chi
      k=3
      a=.25d0*(1.d0-chi**2)/chi
      if(a.gt.0.5d0)a=0.5d0
      if(a.lt.-.5d0)a=-.5d0
      anu=amu+a*(1.d0-amu**2)
      do i=1,k 
      anu=p(anu)
      enddo
c     print *,'anu',anu
      sbecke=0.5d0*(1.d0-anu)
c     print *,'anu,sbecke',anu,sbecke
      return
      end



      
      
              
