
      subroutine numint(iarg)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (PI=3.141592653589793D0)
      PARAMETER (maxp=2000,maxg=1000,maxc=16,maxat=60) 
c     parameter (NMAX=100000)
      parameter (nmax=900)
      dimension Coul(maxat,maxat),Exch(maxat,maxat)
      dimension Epa(maxat,maxat)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)
      common /coord/ coord(3,maxat),zn(maxat)
      common /pr/iprint
      common /quadrat/th(1000),ph(1000),w(1000),wr(100),Xr(100)
      common /c/ps(nmax,nmax),p(nmax,nmax),c(nmax,nmax)
      dimension sab(maxat,maxat)

      common/actual/iact,jat,icenter
      common/pipi/pir,pisqrt
      common /hold/ihold(nmax),illim(nmax)
      common/pha2/pha
      character*30 integ1,integ2
      dimension wp(:),wppha(:),chp(:,:),chp2(:,:),chp2pha(:,:)
      dimension scr(:),scr2(:),pcoordspha(:,:),pcoords(:,:)
      allocatable wp,wppha,chp,chp2,chp2pha,scr,scr2,pcoordspha,pcoords

      Pi1=dacos(-1.d0)
      pisqrt=dsqrt(pi)
      iul=ifiul(igr)
      call prepar

C PSS
      call getarg(iarg+1,integ1)
      call getarg(iarg+2,integ2)
      if(integ1.ne.' '.and.integ2.ne.' ') then
       read(integ1,'(i4)') Nrad        
       read(integ2,'(i4)') Nang        
      else
C PSS
       read(60,*,end=111,err=111) nrad,nang
      end if
       print *,' '
       print *,' '
       print *,' Radial points: ', nrad
c Possible values for Nang: 6,14,26,38,50,74,86,110,146,170,
c                   194,230,266,302,350,434,590,770,974'
       goto 112
 111   nrad=40
       nang=146
       print *,' Radial points: ', nrad
 112   call quad(Nrad,Nang) 
       if(Nrad.gt.100) then
       print *, 'The number of radial points per atom must not ',
     $ 'exceed 100' 
       stop
       else
       endif        

      iatps=Nang*NRad
      allocate (wp(iatps*nat),chp(iatps*nat,igr),pcoords(iatps*nat,3))

      xmem=iatps*nat*(igr+10+2*nocc)*8.0/(1024.0*1024)
      xmem0=(2000*24+3*maxat*maxat+3*nmax*nmax+5)*8/(1024.0*1024)
       print *,' '
      write(*,'(a32,f5.1)') 'Allocted memory used   (MB)',xmem
      write(*,'(a32,f5.1)') 'Non allocated memory   (MB)',xmem0
       print *,' '

c    Generating grid for AO, weigths, and coordinates
      pha=0.0d0
      do i=1,igr
       ipoint=1
       iact=i
       do jat=1,nat
        icenter=jat
        call fpoints(nat,ipoint,chp,Nang,NRad)
        ipoint=ipoint+iatps
       enddo
      end do  
      ipoints=ipoint-1
      print *,' Number of grid points:',ipoints         
       ipoint=1
       do icenter=1,nat
        call rpoints(nat,ipoint,wp,Nang,NRad)
        ipoint=ipoint+iatps
       enddo
c   now wpoints is changed
       ipoint=1
       do jat=1,nat
        icenter=jat
        call wpoints(nat,ipoint,wp,Nang,NRad)
        ipoint=ipoint+iatps
       enddo
       ipoint=1
       do jat=1,nat
        icenter=jat
        call distance(nat,ipoint,pcoords,Nang,NRad)
        ipoint=ipoint+iatps
       enddo


C   DOING ENERGY PARTITION
C   ONE-ELECTRON PART

	do i=1,nat
	 do j=1,nat
	  epa(i,j)=0.0d0
	 end do
	end do

c to MO
      allocate(chp2(iatps*nat,nocc))
       do j=1,nocc
        do k=1,ipoints
         xx=0.0d0
         do i=1,igr 
          xx=xx+c(i,j)*chp(k,i) 
	 end do
         chp2(k,j)=xx
        end do
       end do

c       write(*,*) 'electron-nuclei atraction integrals'
       xtot0=0.0d0
       do mu=1,nocc 
        xtot=0.0d0
        do icenter=1,nat
         do jcenter=1,nat
          x=0.0d0
          zz=zn(jcenter)
          dx0=coord(1,jcenter)
          dy0=coord(2,jcenter)
          dz0=coord(3,jcenter)
          do ifut=iatps*(icenter-1)+1,iatps*icenter
           distx=pcoords(ifut,1)-dx0
           disty=pcoords(ifut,2)-dy0
           distz=pcoords(ifut,3)-dz0
           rr=dsqrt(distx*distx+disty*disty+distz*distz)
           if(rr.gt.1.0d-12) then
            x=x+zz*wp(ifut)*chp2(ifut,mu)*chp2(ifut,mu)/rr
           end if
          end do
c          write(*,667) icenter,'<',mu,'|Z/r',jcenter,'|',mu,'>',x
          xtot=xtot+x
          epa(icenter,jcenter)=epa(icenter,jcenter)-2.0d0*x
         enddo
        enddo
  667    format(i2,a2,i2,a4,i2,a,i2,a,f22.12)
c        write(*,*) ''
c        write(*,*) 'Total int',xtot
c        write(*,*) ''
         xtot0=xtot0+xtot
       enddo

c	write(*,*) 'ENERGY components'
c         write(*,'(a5,3(i10,a5))')'     ',(j,'     ',j=1,nat)
c	do i=1,nat
c         write(*,'(3f20.12)') (epa(i,j),j=1,nat)
c	end do
c        write(*,*) ''
       write(*,*) 'Electron-nuclei energy : ',-xtot0*2.0d0
       etot_en=-xtot0*2.0d0
c 
c       write(*,*) 'kinetic energy integrals '           

c generating grid for 2on derivative over AOs
      do i=1,igr 
       ipoint=1
       iact=i
       do jat=1,nat
        icenter=jat
        call dpoints(nat,ipoint,chp,Nang,NRad)
        ipoint=ipoint+iatps
       enddo
      end do   
      ipoints=ipoint-1 

c now to MO and multiply by MOs AND SUM OVER MOs using scratch array
      allocate(scr(iatps*nat))
      do k=1,ipoints
       x=0.0d0
       do j=1,nocc
        xx=0.0d0
        do i=1,igr 
          xx=xx+c(i,j)*chp(k,i) 
        end do
        x=x+chp2(k,j)*xx
       end do
       scr(k)=x
      end do

      xtot=0.0d0
      do icenter=1,nat
       ifut=iatps*(icenter-1)+1
       do kk=1,nrad
        do ii=1,nang
         do jcenter=1,nat
          x=wp(ifut)*scr(ifut)*www2(jcenter,ii,kk)
          epa(icenter,jcenter)=epa(icenter,jcenter)+x
          xtot=xtot+x
	 end do
	 ifut=ifut+1
        end do
       enddo
      enddo
c        write(*,*) ''
c        write(*,*) 'Total int',xtot
c        write(*,*) ''
c	write(*,*) 'ENERGY components'
c         write(*,'(a5,3(i10,a5))')'     ',(j,'     ',j=1,nat)
c	do i=1,nat
c         write(*,'(3f20.12)') (epa(i,j),j=1,nat)
c	end do
c        write(*,*) ''
       write(*,*) 'Kinetic energy : ',xtot
       etot_k=xtot

c  nuclear repulsion
	xtot=0.0
	do i=1,nat
	 do j=i+1,nat
          dist=dsqrt((coord(1,i)-coord(1,j))**2 +(coord(2,i)-
     1    coord(2,j))**2+(coord(3,i)-coord(3,j))**2)
          epa(i,j)=epa(i,j)+zn(i)*zn(j)/dist
	  xtot=xtot+zn(i)*zn(j)/dist
	 end do
	end do
       write(*,*) 'Nuclear repulsion energy : ',xtot
       etot_rep=xtot

C After one electron terms
c	write(*,*) 'One-electron ENERGY components'
c        write(*,'(a5,3(i10,a5))')'     ',(j,'     ',j=1,nat)
c	do i=1,nat
c         write(*,'(3f20.12)') (epa(i,j),j=1,nat)
c	end do
c        write(*,*) ''
c        write(*,*) 'SUM OF THE TRIANGLE'
	etot=0.0
	do i=1,nat
	 etot=etot+epa(i,i)
	 do j=i+1,nat
	  etot=etot+epa(i,j)+epa(j,i)
	 end do
	end do
c	print *,etot,etot_en+etot_k+etot_rep,'Control: should be equal'

C overlap!!!r
c now to MO and multiply by MOs AND SUM OVER MOs using scratch array
      do k=1,ipoints
       x=0.0d0
       do j=1,nocc
        x=x+chp2(k,j)*chp2(k,j)
       end do
       scr(k)=x
      end do

c	do i=1,nat
c	 do j=1,nat
c	 sab(i,j)=0.0d0
c	end do
c	end do

c      xtot=0.0d0
c      do icenter=1,nat
c       ifut=iatps*(icenter-1)+1
c       do kk=1,nrad
c        do ii=1,nang
c         do jcenter=1,nat
c          x=wp(ifut)*scr(ifut)*www2(jcenter,ii,kk)
c          sab(icenter,jcenter)=sab(icenter,jcenter)+x
c          xtot=xtot+x
c         end do
c         ifut=ifut+1
c        end do
c       enddo
c      enddo
c	do i=1,nat
c	 sab(i,i)=2.0d0*sab(i,i)
c	 do j=i+1,nat
c	 sab(i,j)=(sab(i,j)+sab(j,i))
c	 sab(j,i)=sab(i,j)
c	end do
c	end do
c        write(*,*) ''
c        write(*,*) 'OVERLAP DENSITY'
c        write(*,*) ''
c         write(*,'(a2,8(i3,a5))')'     ',(j,'     ',j=1,nat)
c        do i=1,nat
c         write(*,'(8f10.5)') (sab(i,j),j=1,nat)
c        end do
c        write(*,*) ''
c	write(*,*) 'Electron density Charge: ' ,2.0d0*xtot

c two electron part. Double integration over rotated grids for better accuracy
	write(*,*) ' '
       write(*,*) '##############################'
       write(*,*) ' Doing two-electron integrals'
       write(*,*) '##############################'
	write(*,*) ' '
       call flush(6)

c   phase angle for phi...
      allocate(wppha(iatps*nat),pcoordspha(iatps*nat,3))
      pha=1.8d0         
c      write(*,*) 'Phase on phi for grid' ,pha
      do i=1,igr
       ipoint=1
       iact=i
       do jat=1,nat
        icenter=jat
        call fpoints(nat,ipoint,chp,Nang,NRad)
        ipoint=ipoint+iatps
       enddo
      end do
      ipoint=1
      do icenter=1,nat
       call rpoints(nat,ipoint,wppha,Nang,NRad)
       ipoint=ipoint+iatps
      enddo
      ipoint=1
      do jat=1,nat
       icenter=jat
       call wpoints(nat,ipoint,wppha,Nang,NRad)
       ipoint=ipoint+iatps
      enddo
      ipoint=1
      do jat=1,nat
       icenter=jat
       call distance(nat,ipoint,pcoordspha,Nang,NRad)
       ipoint=ipoint+iatps
      enddo
c to MO
      allocate(chp2pha(iatps*nat,nocc))
       do k=1,ipoints
        scr(k)=0.0d0
        do j=1,nocc
         xx=0.0d0
         do i=1,igr 
          xx=xx+c(i,j)*chp(k,i) 
	 end do
         chp2pha(k,j)=xx
         scr(k)=scr(k)+xx*xx
        end do
       end do
      deallocate (chp)
c make electron density
      allocate(scr2(iatps*nat))
       do k=1,ipoints
        xx=0.0d0
        x=0.0d0
        do i=1,nocc    
         xx=xx+chp2(k,i)*chp2(k,i) 
	end do
        scr2(k)=xx
       end do

	  do i=1,igr
	   do j=1,igr
	    coul(i,j)=0.0d0
	    exch(i,j)=0.0d0
	   end do
          end do

C Coulomb contribution. Using rho(k)!
c     scr(k) contains rho(k) for rotated grid
c     scr2(k) rho(k) for non-rotated grid  
c     chp2(k,j) the MO for non-rotated grid  
c     chp2pha(k,j) the MO for rotated grid  

	  f2=0.0d0
          do icenter=1,nat
           do ifut=iatps*(icenter-1)+1,iatps*icenter
            x0=wppha(ifut)
            dx0=pcoordspha(ifut,1)
            dy0=pcoordspha(ifut,2)
            dz0=pcoordspha(ifut,3)
            f2=f2+scr(ifut)*x0
C same center
            f3=0.0d0
            do jfut=iatps*(icenter-1)+1,iatps*icenter
             x1=wp(jfut)
             dx1=pcoords(jfut,1)
             dy1=pcoords(jfut,2)
             dz1=pcoords(jfut,3)
             dist=dsqrt((dx0-dx1)**2+(dy0-dy1)**2+(dz0-dz1)**2)
             if(dist.gt.1.0d-8) then
              f3=f3+scr(ifut)*scr2(jfut)*x1*x0/dist
	     end if
	    end do
            coul(icenter,icenter)= coul(icenter,icenter)+ f3
C pairs of centers
	    do jcenter=icenter+1,nat
             f3=0.0d0
             do jfut=iatps*(jcenter-1)+1,iatps*jcenter
              x1=wp(jfut)
              dx1=pcoords(jfut,1)
              dy1=pcoords(jfut,2)
              dz1=pcoords(jfut,3)
              dist=dsqrt((dx0-dx1)**2+(dy0-dy1)**2+(dz0-dz1)**2)
              if(dist.gt.1.0d-8 ) then
               f3=f3+scr(ifut)*scr2(jfut)*x1*x0/dist
	      end if
	     end do
             coul(icenter,jcenter)= coul(icenter,jcenter)+ f3
            enddo

           enddo
          enddo

c check integration of rho
        write(*,*) 'Integration of electron density : ',2.0d0*f2                
	coulen=0.0d0
	do i=1,nat
	 coul(i,i)=2.0d0*coul(i,i)
	 coulen=coulen+coul(i,i)
         do j=i+1,nat
	  coul(i,j)=2.0*coul(i,j)
	  coul(j,i)=coul(i,j)
	  coulen=coulen+coul(i,j)+coul(j,i)
	 end do
	end do
c	do i=1,nat
c         write(*,*) (coul(i,j),j=1,nat)
c	end do
	write(*,*) 'Coulombic energy : ',coulen
        call flush(6)

      deallocate(scr,scr2)
c Now Exchange part. BOTTLENECK!! shit...
c     scr(k) contains rho(k) for rotated grid
c     scr2(k) rho(k) for non-rotated grid  
c     chp2(k,j) the MO for non-rotated grid  
c     chp2pha(k,j) the MO for rotated grid  

          do icenter=1,nat
           do ifut=iatps*(icenter-1)+1,iatps*icenter
            x0=wppha(ifut)
            dx0=pcoordspha(ifut,1)
            dy0=pcoordspha(ifut,2)
            dz0=pcoordspha(ifut,3)
	    do i=1,nocc
             do j=i,nocc
               f2=x0*chp2pha(ifut,i)*chp2pha(ifut,j)
             if(i.ne.j) f2=2.0d0*f2
C same center
            f3=0.0d0
            do jfut=iatps*(icenter-1)+1,iatps*icenter
             x1=wp(jfut)
             dx1=pcoords(jfut,1)
             dy1=pcoords(jfut,2)
             dz1=pcoords(jfut,3)
             dist=dsqrt((dx0-dx1)**2+(dy0-dy1)**2+(dz0-dz1)**2)
             if(dist.gt.1.0d-8) then
              f3=f3+f2*x1*chp2(jfut,i)*chp2(jfut,j)/dist
	     end if
	    end do
            exch(icenter,icenter)= exch(icenter,icenter)- f3
C pairs of centers
	    do jcenter=icenter+1,nat
c distance to other center
c	     centdist=dsqrt((coord(1,icenter)-coord(1,jcenter))**2+
c     1	     (coord(2,icenter)-coord(2,jcenter))**2+
c     1	     (coord(3,icenter)-coord(3,jcenter))**2)
c	    if(centdist.lt.2.5) then
             f3=0.0d0
             do jfut=iatps*(jcenter-1)+1,iatps*jcenter
              x1=wp(jfut)
              dx1=pcoords(jfut,1)
              dy1=pcoords(jfut,2)
              dz1=pcoords(jfut,3)
              dist=dsqrt((dx0-dx1)**2+(dy0-dy1)**2+(dz0-dz1)**2)
              if(dist.gt.1.0d-8 ) then
               f3=f3+f2*x1*chp2(jfut,i)*chp2(jfut,j)/dist
	      end if
	     end do
             exch(icenter,jcenter)= exch(icenter,jcenter)- f3
c	   end if
            enddo
            enddo
            enddo
            enddo
            enddo

	exchen=0.0d0
	do i=1,nat
	 exchen=exchen+exch(i,i)
         do j=i+1,nat
	  exch(j,i)=exch(i,j)
	  exchen=exchen+exch(i,j)+exch(j,i)
	 end do
	end do
c	do i=1,nat
c         write(*,*) (exch(i,j),j=1,nat)
c	end do
	write(*,*) 'Exchange Energy : ',exchen
	write(*,*) 'Total energy : ',coulen+exchen+etot_en+etot_k+etot_rep
	
c 
        do i=1,nat
         epa(i,i)=epa(i,i)+coul(i,i)+exch(i,i)
	 do j=i+1,nat
          epa(i,j)=epa(i,j)+epa(j,i)+2.0d0*(coul(i,j)+exch(i,j))
          epa(j,i)=epa(i,j)
	 end do
	end do
c	write(*,*) ' '
c	write(*,*) '******************************'
c	write(*,*) '****FUZZY ENERGY PARTITION****'
c	write(*,*) '******************************'
c	write(*,*) ' '
c        write(*,'(8(a4,i2,a4))') ('    ',i,'    ',i=1,nat)
c        do i=1,nat
c         write(*,'(8F10.4)') (epa(j,i),j=1,i)
c	end do
        WRITE(*,6342)
 6342   FORMAT(1x,/21X,'"FUZZY ATOMS" ENERGY COMPONENTS'//)
        CALL Mprint(epa,NAT,maxat)
        write(*,*) ' '

c final check
c	ene=0.0d0
c        do i=1,nat
c	ene=ene+epa(i,i)
c         do j=i+1,nat
c	ene=ene+epa(i,j)
c	 end do
c	end do
c	write(*,*) ' '
c	write(*,*) 'Total energy ', ene

      
      return
      end

