      subroutine input  
      IMPLICIT REAL*8(A-H,O-Z)
      parameter (nmax=900)
      PARAMETER (maxp=2000,maxg=1000,maxc=16,maxat=60) 
      common iop(45)
c     common /fnutab/f(2505,13)
c     common /intertab/d1,d2,d3,d4
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      common /nat/ nat,nbasis,ifg,nocc,nalf,nb,iuhf
      common /c/ ccx(nmax,nmax),p(nmax,nmax),c(nmax,nmax)
      dimension clin(nmax**2)
      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/ coeff(maxg,maxc) 
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)     
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /opensh/ cb(nmax,nmax)   
      equivalence (clin(1),cb(1,1))
      common/map/imap(maxp)
      common /b/ expsh(maxp),c1(maxp),c2(maxp),cdummy(240),x(maxp),
     $  y(maxp),z(maxp),jan(80),ishella(maxp),mnsh(maxp),ishellt(maxp),
     $  iaos(maxg),iaon(20), ncshell,maxl
      common /ia/iznuc(maxat),kop,megall
      dimension msc(maxg),nsh(maxp),cc(7)
      dimension methodb(2),mdeco(1)  
      dimension ibe(20),methodu(2),methodr(2),numat(4),numel(4),
     $ numa(4),numb(4),numbf(4),numcs(4),nhang(4),ndegr(4),numps(6),
     $ numet(3),iatnm(3),nucch(4),icart(4),ishty(3),npons(6),mstat(4),
     $ nprex(4),ncncf(4),nspcf(4),ncosh(4),mocal(4),mocbe(4)
      dimension d1(2504,13),d2(2503,13),d3(2502,13),d4(2501,13)
      dimension mssh(maxg),iatsh(nmax),iatc(nmax)
      character*1 iii(8)
      equivalence (iii(1),ibe(1))
      data dc12 /2.449489743d0/
      data dc11 /1.095445115d0/
      data dc21 /0.866025403d0/
      data dc41 /0.790569415d0/
      data dc42 /1.060660172d0/
      

      data mdeco/'DEC.'/
      data methodr/'  RH','F   '/
      data methodu/'  UH','F   '/
c     data methodb/'  RB','3LYP'/
      data numat /'Numb','er o','f at','oms '/
      data numel/'Numb','er o','f el','ectr'/
      data numa /'Numb','er o','f al','pha '/
      data numb /'Numb','er o','f be','ta e'/
      data numbf /'Numb','er o','f ba','sis '/
      data numcs /'Numb','er o','f co','ntra'/
      data nhang /'High','est ','angu','lar '/
      data ndegr /'Larg','est ','degr','ee o'/
      data numps /'Numb','er o','f pr','imit','ive ','shel'/
      data numet /'SCF ','Ener','gy  '/
      data iatnm /'Atom','ic n','umbe'/
      data nucch /'Nucl','ear ','char','ges '/
      data icart /'Curr','ent ','cart','esia'/
      data ishty /'Shel','l ty','pes '/
      data npons /'Numb','er o','f pr','imit','ives',' per'/
      data mstat /'Shel','l to',' ato','m ma'/
      data nprex /'Prim','itiv','e ex','pone'/
      data ncncf /'Cont','ract','ion ','coef'/
      data nspcf /'P(S=','P) C','ontr','acti'/
      data ncosh /'Coor','dina','tes ','of e'/
      data mocal /'Alph','a MO',' coe','ffic'/
      data mocbe /'Beta',' MO ','coef','fici'/
      data itot  /'Tota'/
      data itot2 /'l SC'/
      data itot3 /'F De'/ 
      data ispin  /'Spin'/

      
       rewind 15
      read(15,150)ibe
      write(*,150)ibe
      if(ibe(1).eq.mdeco(1)) megall=1
c      print *,"megall=",megall
      print *,'   '
      read(15,150)ibe
 150  format(20a4) 
      iuhf=0
      irhf=0
      ienerg=0
c     if(ibe(3).eq.methodr(1).and.ibe(4).eq.methodr(2))irhf=1
      if(ibe(3).eq.methodr(1).and.ibe(4).eq.methodr(2))then
         irhf=1
         ienerg=1
      endif 
c     if(ibe(3).eq.methodu(1).and.ibe(4).eq.methodu(2))iuhf=1
      if(ibe(3).eq.methodu(1).and.ibe(4).eq.methodu(2))then
         iuhf=1
         ienerg=1
      endif
      if(ienerg.eq.0) then
      write(*,6721)
 6721 format(//,10x,'The calculation was other than plain RHF/UHF ',
     $ //, ' (In the DFT case the single determinant built up of',
     $ ' the Kohn-Sham orbitals',/,' will be used.)',//)
      endif
      if(iii(3).eq.'R') irhf=1
      if(iii(3).eq.'U') iuhf=1
c     if(iuhf.eq.1) then
c     write(*,*)'  The UHF wave function is used for',
c    $             ' calculations'
c     endif
c     if(iuhf.eq.0.and.ienerg.eq.1)then
c     write(*,*)'  The Kohn-Sham orbitals are used for',
c    $             ' calculations'
c     endif
c     if(iuhf.eq.0.and.irhf.eq.0)then
c     write(*,*)'  The program presently is applicable for the RHF',
c    $  ' and UHF cases only --- STOP'
c     stop 
c     endif
       rewind 15
 126    read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.numat(1).and.ibe(2).eq.numat(2).
     $ and.ibe(3).eq.numat(3).and.ibe(4).eq.numat(4)) then
      backspace 15
      read(15,151)nat
 151  format(55x,i6)   
      else 
      goto 126
      endif
       rewind 15
 127  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.numel(1).and.ibe(2).eq.numel(2).
     $ and.ibe(3).eq.numel(3).and.ibe(4).eq.numel(4)) then
      backspace 15
c nelectr   =the number of electrons in the system
      read(15,151)nelectr
      else 
      goto 127
      endif
       rewind 15
 128  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.numa(1).and.ibe(2).eq.numa(2).
     $ and.ibe(3).eq.numa(3).and.ibe(4).eq.numa(4)) then
      backspace 15
c      nalf      =number of alpha electrons
      read(15,151)nalf   
      else 
      goto 128
      endif
       rewind 15
 129  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.numb(1).and.ibe(2).eq.numb(2).
     $ and.ibe(3).eq.numb(3).and.ibe(4).eq.numb(4)) then
      backspace 15
c      nb        =number of beta electrons
      read(15,151)nb
      else 
      goto 129
      endif
      kop=0
      if(nalf.ne.nb)kop=1
       rewind 15
 130  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.numbf(1).and.ibe(2).eq.numbf(2).
     $ and.ibe(3).eq.numbf(3).and.ibe(4).eq.numbf(4)) then
      backspace 15
c      nbasis    =number of basis funcions
      read(15,151)nbasis
      else 
      goto 130
      endif
       rewind 15
 131  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.numcs(1).and.ibe(2).eq.numcs(2).
     $ and.ibe(3).eq.numcs(3).and.ibe(4).eq.numcs(4)) then
      backspace 15
c      ncshell   =number of contracted shells
      read(15,151)ncshell
      else 
      goto 131
      endif
       rewind 15
 132  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.nhang(1).and.ibe(2).eq.nhang(2).
     $ and.ibe(3).eq.nhang(3).and.ibe(4).eq.nhang(4)) then
      backspace 15
      read(15,151)maxl
      else 
      goto 132
      endif
       rewind 15
 133  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.ndegr(1).and.ibe(2).eq.ndegr(2).
     $ and.ibe(3).eq.ndegr(3).and.ibe(4).eq.ndegr(4)) then
      backspace 15
      read(15,151)maxk
      else 
      goto 133
      endif
       rewind 15
 134  read(15,150,end=1000)(ibe(i),i=1,6)
      if(ibe(1).eq.numps(1).and.ibe(2).eq.numps(2).
     $ and.ibe(3).eq.numps(3).and.ibe(4).eq.numps(4).
     $ and.ibe(5).eq.numps(5).and.ibe(6).eq.numps(6)) then
      backspace 15
c      npshell   =number of primitive shells
      read(15,151)npshell
c     print *,'Number of primitive shells:',npshell
      else 
      goto 134
      endif
       rewind 15
 135  read(15,150,end=1000)(ibe(i),i=1,3)
      if(ibe(1).eq.numet(1).and.ibe(2).eq.numet(2).
     $ and.ibe(3).eq.numet(3)) then
      backspace 15
      read(15,152)escf   
 152  format(45x,d30.10)
      else 
      goto 135
      endif
       rewind 15
 136  read(15,150,end=1000)(ibe(i),i=1,3)
      if(ibe(1).eq.iatnm(1).and.ibe(2).eq.iatnm(2).
     $  and.ibe(3).eq.iatnm(3)) then
c      iznuc     =atomic numbers
      read(15,*)(iznuc(i),i=1,nat)   
      else 
      goto 136
      endif
       rewind 15
 137  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.nucch(1).and.ibe(2).eq.nucch(2).
     $ and.ibe(3).eq.nucch(3).and.ibe(4).eq.nucch(4)) then
c      zn        =nuclear charges
      read(15,*)(zn(i),i=1,nat)
 153  format(10f5.2)
      else 
      goto 137
      endif
       rewind 15
 138  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.icart(1).and.ibe(2).eq.icart(2).
     $ and.ibe(3).eq.icart(3).and.ibe(4).eq.icart(4)) then
c      coord     =Cartesian coordinates
      read(15,*)(coord(1,i),coord(2,i),coord(3,i),i=1,nat)
      else 
      goto 138
      endif
       rewind 15
 139  read(15,150,end=1000)(ibe(i),i=1,3)
      if(ibe(1).eq.ishty(1).and.ibe(2).eq.ishty(2).
     $ and.ibe(3).eq.ishty(3)) then
c      mssh      =shell types (S=0; P=1; D=2; F=3; SP=-1; 5D=-2; 7F=-3)
      read(15,*)(mssh(i),i=1,ncshell)
      else 
      goto 139
      endif
       rewind 15
 140  read(15,150,end=1000)(ibe(i),i=1,6)
      if(ibe(1).eq.npons(1).and.ibe(2).eq.npons(2).
     $ and.ibe(3).eq.npons(3).and.ibe(4).eq.npons(4).
     $ and.ibe(5).eq.npons(5).and.ibe(6).eq.npons(6)) then
c      mnsh      =number of primitives/shell
      read(15,*)(mnsh(i),i=1,ncshell)
 154  format(10i3)
      else 
      goto 140
      endif
       rewind 15
 141  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.mstat(1).and.ibe(2).eq.mstat(2).     
     $ and.ibe(3).eq.mstat(3).and.ibe(4).eq.mstat(4)) then
c      iatsh     =shell to atom map
      read(15,*)(iatsh(i),i=1,ncshell)
      else 
      goto 141
      endif
       rewind 15
 142  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.nprex(1).and.ibe(2).eq.nprex(2).
     $ and.ibe(3).eq.nprex(3).and.ibe(4).eq.nprex(4)) then
      read(15,*)(expsh(i),i=1,npshell)
      else 
      goto 142
      endif
       rewind 15
 143  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.ncncf(1).and.ibe(2).eq.ncncf(2).
     $ and.ibe(3).eq.ncncf(3).and.ibe(4).eq.ncncf(4)) then
      read(15,*)(c1(i),i=1,npshell)
      else 
      goto 143
      endif

      do 1012 ii=1,ncshell
       if(mssh(ii).eq.-1) goto 1123
 1012 continue
      goto 122 
 1123  rewind 15
 144  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.nspcf(1).and.ibe(2).eq.nspcf(2).
     $ and.ibe(3).eq.nspcf(3).and.ibe(4).eq.nspcf(4)) then
      read(15,*)(c2(i),i=1,npshell)
      else 
      goto 144
      endif

 122   rewind 15
 145  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.ncosh(1).and.ibe(2).eq.ncosh(2).
     $ and.ibe(3).eq.ncosh(3).and.ibe(4).eq.ncosh(4)) then
      read(15,111)(x(i),y(i),z(i),i=1,ncshell)
      else 
      goto 145
      endif
       rewind 15
 146  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.mocal(1).and.ibe(2).eq.mocal(2).
     $ and.ibe(3).eq.mocal(3).and.ibe(4).eq.mocal(4)) then
      read(15,*,err=2003)((c(i,j),i=1,nbasis),j=1,nbasis)
 2003 continue    
      else 
      goto 146
      endif
       rewind 15
      if(iuhf.eq.1) then
 147  read(15,150,end=1000)(ibe(i),i=1,4)
      if(ibe(1).eq.mocbe(1).and.ibe(2).eq.mocbe(2).
     $ and.ibe(3).eq.mocbe(3).and.ibe(4).eq.mocbe(4)) then
      read(15,*,err=2013)((cb(i,j),i=1,nbasis),j=1,nbasis)
 2013 continue     
      else 
      goto 147
      endif

      endif

      print *, ' '
      print *,'Number of primitive shells:',npshell
      goto 400


 400  continue
c      nocc      =number of occupied orbitals
      
      nocc=nelectr/2

      ishella(1)=1
      ishellt(1)=iabs(mssh(1))
      do i=2,ncshell
       ishella(i)=ishella(i-1)+mnsh(i-1)
      ishellt(i)=iabs(mssh(i))
      enddo
      
      iaos(1)=1
      do i=2,ncshell
      nn=1
      if(mssh(i-1).eq.1)nn=3
      if(mssh(i-1).eq.-1)nn=4
      if(mssh(i-1).eq.2)nn=6
      if(mssh(i-1).eq.-2)nn=5
      if(mssh(i-1).eq.3)nn=10
      if(mssh(i-1).eq.-3)nn=7
c     if(mssh(i-1).eq.4)nn=15
c     if(mssh(i-1).eq.-4)nn=9
       
       iaos(i)=iaos(i-1)+nn
      
      enddo
      if(mssh(1).eq.1)then
      print *,' The first shell in the system must not be a pure p one'
      print *,'          PROGRAM STOPS'
      stop 4358
      endif
      do i=1,ncshell
      if(mssh(i).eq.1)iaos(i)=iaos(i)-1    
      enddo

      iaos(ncshell+1)=nbasis+1
      ic=1
      ireadsp=0

c      ncont(i)  =number of contractions in the i'th contracted shell


c      if(iabs(maxl).gt.2)then
c      print *,' The present version of the program does not handle ',
c     $ 'F (G...) orbitals'
c      print *,'          PROGRAM STOPS'
c      stop 4359

c      endif 
  
      if(iabs(maxl).ge.2)IOP(7)=1
      if(iabs(maxl).gt.2)IOP(7)=2

      do 420 i=1,ncshell
      ms=mssh(i)
      if(ms.eq.-1)ireadsp=1
      ccc=mnsh(i)
      ia=iatsh(i)
      if(ms.eq.0) then
      nsh(i)=1
      msc(ic)=ms
      ncont(ic)=ccc 
      iatc(ic)=ia
      ic=ic+1
      goto 420
      endif
      if(ms.eq.1)then
      nsh(i)=3
      msc(ic)=1
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=1
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=1
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia
      ic=ic+3
      goto 420
      endif
      if(ms.eq.2)then
      nsh(i)=6
      msc(ic)=2
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=2
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=2
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=2
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      msc(ic+4)=2
      ncont(ic+4)=ccc 
      iatc(ic+4)=ia

      msc(ic+5)=2
      ncont(ic+5)=ccc 
      iatc(ic+5)=ia
      ic=ic+6
      goto 420
      endif
      if(ms.eq.-1)then
      nsh(i)=4
      msc(ic)=0
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=1
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=1
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=1
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      ic=ic+4
      goto 420
      endif
      if(ms.eq.-2)then
      nsh(i)=5
      msc(ic)=-2
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=-2
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=-2
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=-2
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      msc(ic+4)=-2
      ncont(ic+4)=ccc 
      iatc(ic+4)=ia

      ic=ic+5
      goto 420
      endif

      if(ms.eq.3)then
      nsh(i)=10
      msc(ic)=3
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=3
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=3
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=3
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      msc(ic+4)=3
      ncont(ic+4)=ccc 
      iatc(ic+4)=ia

      msc(ic+5)=3
      ncont(ic+5)=ccc 
      iatc(ic+5)=ia

      msc(ic+6)=3
      ncont(ic+6)=ccc 
      iatc(ic+6)=ia

      msc(ic+7)=3
      ncont(ic+7)=ccc 
      iatc(ic+7)=ia

      msc(ic+8)=3
      ncont(ic+8)=ccc 
      iatc(ic+8)=ia

      msc(ic+9)=3
      ncont(ic+9)=ccc 
      iatc(ic+9)=ia
      ic=ic+10
      goto 420
      endif

      if(ms.eq.-3)then
      nsh(i)=7
      msc(ic)=-3
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=-3
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=-3
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=-3
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      msc(ic+4)=-3
      ncont(ic+4)=ccc 
      iatc(ic+4)=ia

      msc(ic+5)=-3
      ncont(ic+5)=ccc 
      iatc(ic+5)=ia

      msc(ic+6)=-3
      ncont(ic+6)=ccc 
      iatc(ic+6)=ia

      ic=ic+7
      goto 420
      endif

      write(*,*)' Unknown orbital type - STOP'
      stop
 420  continue
      ic=ic-1  
      if(ic.ne.nbasis) stop 968

      ipr=1
       inovel=0
      do 123 i=1,nbasis
      lim=ncont(i)
      ncia=ncont(i)
      if(msc(i).eq.-2) then
         if(inovel.eq.0) then
         lim=lim+ncia
         endif
       inovel=inovel+1
       if(inovel.eq.5)inovel=0
      endif
      if(msc(i).eq.-3) then
         if(inovel.eq.0) then
         lim=lim+3*ncia
         endif
       inovel=inovel+1
       if(inovel.eq.7)inovel=0
      endif
      do 123 j=1,lim
      iat(ipr)=iatc(i)
      ipr=ipr+1
 123  continue   
      ipr=ipr-1
 
      ifill(1)=1
      ifiul(1)=ncont(1)
      if(msc(1).eq.-2.or.msc(1).eq.-3)then
        print *,"The first shell must not be a pure D or F one!"
        stop
      endif
      inovel=0 
      do 423 i=2,nbasis
      if(msc(i).eq.-2) then
         iop(8)=1
         if(inovel.le.2) then
           ifill(i)=ifiul(i-1)+1
           ifiul(i)=ifill(i)+ncont(i)-1
           goto 441
         endif
         if(inovel.eq.3) then
           ifill(i)=ifiul(i-1)+1
           ifiul(i)=ifill(i)+2*ncont(i)-1
           goto 441
         endif
         if(inovel.eq.4) then
           ifill(i)=ifill(i-1)
           ifiul(i)=ifill(i)+3*ncont(i)-1 
           goto 441
         endif
 441   inovel=inovel+1
         if(inovel.eq.5)inovel=0
      goto 423
      endif
      if(msc(i).eq.-3) then 

        if(inovel.eq.0.or.inovel.eq.2.or.inovel.eq.4) then
          ifill(i)=ifiul(i-1)+1
          ifiul(i)=ifill(i)+3*ncont(i)-1
          goto 442
        endif
        if(inovel.eq.1.or.inovel.eq.3.or.inovel.eq.5) then
          ifill(i)=ifill(i-1)+1
          ifiul(i)=ifill(i)+2*ncont(i)-1
          goto 442
        endif
        if(inovel.eq.6) then
          ifill(i)=ifiul(i-1)+1
          ifiul(i)=ifill(i)+ncont(i)-1
          goto 442
        endif
 442     inovel=inovel+1
         if(inovel.eq.7) inovel=0
      goto 423 
      endif
      ifill(i)=ifiul(i-1)+1
      ifiul(i)=ifill(i)+ncont(i)-1
 423  continue   
      if(ifiul(nbasis).ne.ipr)stop 7865 

     
      iexp=1
      ipr=1
      do 124 i=1,ncshell
      if(mssh(i).eq.0)then
      do 427 ll=1,mnsh(i)
      do 425 j=1,nsh(i)  
      expp(ipr)=expsh(iexp)
 425  ipr=ipr+1
      iexp=iexp+1
 427  continue 
      goto 124
      endif

      if(mssh(i).eq.1.or.mssh(i).eq.-1.or.mssh(i).eq.2.or.
     $   mssh(i).eq.3)then

       isr=ipr
      do 1778 kk=1,mnsh(i)
      expa=expsh(iexp)
      do 1777 j=1,nsh(i)
 1777 expp(isr+(j-1)*mnsh(i))=expa
      isr=isr+1
      iexp=iexp+1
 1778  continue
      ipr=ipr+nsh(i)*mnsh(i)
      goto 124
      endif

      if(mssh(i).eq.-2) then    
       isr=ipr
       inovel=0
      do 2778 kk=1,mnsh(i)
      expa=expsh(iexp)
      lim=nsh(i)+1
         if(inovel.eq.0) then
c         lim=lim+1
         endif
       inovel=inovel+1
       if(inovel.eq.5)inovel=0
      do 2777 j=1,lim   
 2777 expp(isr+(j-1)*mnsh(i))=expa
      isr=isr+1   
      iexp=iexp+1
 2778  continue
      ipr=ipr+lim*mnsh(i)
      goto 124
      endif

      if(mssh(i).eq.-3) then    
       isr=ipr
       inovel=0
      do 3778 kk=1,mnsh(i)
      expa=expsh(iexp)
      lim=nsh(i)+3
         if(inovel.eq.0) then
c         lim=lim+3
         endif
       inovel=inovel+1
       if(inovel.eq.7)inovel=0
      do 3777 j=1,lim   
 3777 expp(isr+(j-1)*mnsh(i))=expa
      isr=isr+1   
      iexp=iexp+1
 3778  continue
      ipr=ipr+lim*mnsh(i)
      goto 124
      endif

      stop 2222
 124  continue
      ipr=ipr-1


      do 77 i=1,nat
      ivan=0
      do 78 k=1,nbasis
      if(iatc(k).eq.i) then
       if(ivan.eq.0)llim(i)=k
       ivan=1
      endif
      if(ivan.eq.1.and.iatc(k).ne.i)then
       iulim(i)=k-1
       ivan=0
      endif
   78 continue
   77 continue
      iulim(nat)=nbasis

      kk=1
      jj=1
      ipr=1
      do 224 i=1,ncshell
      mmm=mnsh(i)
      if(mssh(i).eq.0)then
      do 225 ll=1,mnsh(i)
      coeff(kk,ll)=c1(jj)
 225  jj=jj+1
      kk=kk+1
      ipr=ipr+mmm 
      goto 224
      endif

      if(mssh(i).eq.1)then
      do 223 ll=1,mnsh(i)
      mmm=mnsh(i)
      coeff(kk,ll)=c1(jj)
      coeff(kk+1,ll)=c1(jj)
      coeff(kk+2,ll)=c1(jj)
      n(ipr+ll-1)=1
      l(ipr+mmm+ll-1)=1
      m(ipr+2*mmm+ll-1)=1
 223  jj=jj+1
      kk=kk+3
      ipr=ipr+3*mmm
      goto 224
      endif

      if(mssh(i).eq.2)then
      do 323 ll=1,mnsh(i)
      mmm=mnsh(i)
      coeff(kk,ll)=c1(jj)
      coeff(kk+1,ll)=c1(jj)
      coeff(kk+2,ll)=c1(jj)
      coeff(kk+3,ll)=c1(jj)
      coeff(kk+4,ll)=c1(jj)
      coeff(kk+5,ll)=c1(jj)
      n(ipr+ll-1)=2
      l(ipr+mmm+ll-1)=2
      m(ipr+2*mmm+ll-1)=2
      n(ipr+3*mmm+ll-1)=1
      l(ipr+3*mmm+ll-1)=1
      n(ipr+4*mmm+ll-1)=1
      m(ipr+4*mmm+ll-1)=1
      l(ipr+5*mmm+ll-1)=1
      m(ipr+5*mmm+ll-1)=1
 323  jj=jj+1
      kk=kk+6
      ipr=ipr+6*mmm
      goto 224
      endif

      if(mssh(i).eq.3)then
      do 523 ll=1,mnsh(i)
      mmm=mnsh(i)
      coeff(kk,ll)=c1(jj)
      coeff(kk+1,ll)=c1(jj)
      coeff(kk+2,ll)=c1(jj)
      coeff(kk+3,ll)=c1(jj)
      coeff(kk+4,ll)=c1(jj)
      coeff(kk+5,ll)=c1(jj)
      coeff(kk+6,ll)=c1(jj)
      coeff(kk+7,ll)=c1(jj)
      coeff(kk+8,ll)=c1(jj)
      coeff(kk+9,ll)=c1(jj)
      n(ipr+ll-1)=3
      l(ipr+mmm+ll-1)=3
      m(ipr+2*mmm+ll-1)=3
      n(ipr+3*mmm+ll-1)=1
      l(ipr+3*mmm+ll-1)=2
      n(ipr+4*mmm+ll-1)=2
      l(ipr+4*mmm+ll-1)=1
      n(ipr+5*mmm+ll-1)=2
      m(ipr+5*mmm+ll-1)=1
      n(ipr+6*mmm+ll-1)=1
      m(ipr+6*mmm+ll-1)=2
      l(ipr+7*mmm+ll-1)=1
      m(ipr+7*mmm+ll-1)=2
      l(ipr+8*mmm+ll-1)=2
      m(ipr+8*mmm+ll-1)=1
      n(ipr+9*mmm+ll-1)=1
      l(ipr+9*mmm+ll-1)=1 
      m(ipr+9*mmm+ll-1)=1
 523  jj=jj+1
      kk=kk+10
      ipr=ipr+10*mmm
      goto 224
      endif

      if(mssh(i).eq.-1)then
      do 226 ll=1,mnsh(i)
      mmm=mnsh(i)
      coeff(kk,ll)=c1(jj)
      n(ipr+mmm+ll-1)=1
      l(ipr+2*mmm+ll-1)=1
      m(ipr+3*mmm+ll-1)=1
      coeff(kk+1,ll)=c2(jj)
      coeff(kk+2,ll)=c2(jj)
      coeff(kk+3,ll)=c2(jj)
 226  jj=jj+1
      kk=kk+4
      ipr=ipr+4*mmm
      goto 224
      endif

      if(mssh(i).eq.-2) then
       do 326 ll=1,mnsh(i)
       mmm=mnsh(i)
         coeff(kk,ll)=c1(jj)
         n(ipr+ll-1)=1
         m(ipr+ll-1)=1

         coeff(kk+1,ll)=c1(jj)
         l(ipr+mmm+ll-1)=1
         m(ipr+mmm+ll-1)=1

         coeff(kk+2,ll)=c1(jj)
         n(ipr+2*mmm+ll-1)=1
         l(ipr+2*mmm+ll-1)=1


         coeff(kk+3,ll)=c1(jj)
         coeff(kk+3,ll+mmm)=-c1(jj) 
         n(ipr+3*mmm+ll-1)=2

         coeff(kk+4,ll)=-c1(jj)/dsqrt(3.d0)
         coeff(kk+4,ll+mmm)=-c1(jj)/dsqrt(3.d0)
         coeff(kk+4,ll+2*mmm)=2.d0*c1(jj)/dsqrt(3.d0)
         l(ipr+4*mmm+ll-1)=2
         m(ipr+5*mmm+ll-1)=2

 326  jj=jj+1
      kk=kk+5
      ipr=ipr+6*mmm
      goto 224
       endif   

      if(mssh(i).eq.-3) then
       do 426 ll=1,mnsh(i)
       mmm=mnsh(i)
       coeff(kk,ll)=dc11*c1(jj)
       coeff(kk,ll+1)=-dc12/4.d0*c1(jj)
       coeff(kk,ll+2)=-dc11/4.d0*c1(jj)

       coeff(kk+1,ll)=dc41*c1(jj)
       coeff(kk+1,ll+1)=-dc42*c1(jj)

       coeff(kk+2,ll)=dc11*c1(jj)
       coeff(kk+2,ll+1)=-dc11/4.d0*c1(jj)
       coeff(kk+2,ll+2)=-dc12/4.d0*c1(jj)

       coeff(kk+3,ll)=dc42*c1(jj)
       coeff(kk+3,ll+1)=-dc41*c1(jj)

       coeff(kk+4,ll)=c1(jj)*dsqrt(5.d0)
       coeff(kk+4,ll+1)=-3.d0/2.d0*c1(jj)
       coeff(kk+4,ll+2)=-3.d0/2.d0*c1(jj)

       coeff(kk+5,ll)=-dc21*c1(jj)
       coeff(kk+5,ll+1)=dc21*c1(jj)

       coeff(kk+6,ll)=c1(jj)

      n(ipr+ll-1)=1
      m(ipr+ll-1)=2

      n(ipr+mmm+ll-1)=3

      n(ipr+2*mmm+ll-1)=1
      l(ipr+2*mmm+ll-1)=2

      l(ipr+3*mmm+ll-1)=1
      m(ipr+3*mmm+ll-1)=2

      n(ipr+4*mmm+ll-1)=2
      l(ipr+4*mmm+ll-1)=1

      l(ipr+5*mmm+ll-1)=3

      m(ipr+6*mmm+ll-1)=3

      l(ipr+7*mmm+ll-1)=2
      m(ipr+7*mmm+ll-1)=1

      n(ipr+8*mmm+ll-1)=2
      m(ipr+8*mmm+ll-1)=1

      n(ipr+9*mmm+ll-1)=1
      l(ipr+9*mmm+ll-1)=1 
      m(ipr+9*mmm+ll-1)=1

 426  jj=jj+1
      kk=kk+7
      ipr=ipr+10*mmm
      goto 224
      endif   

       stop 400
 224  continue
      
      ipr=ipr-1

 111  format(5E16.8)

      do j=1,nbasis
      imap(j)=j
      enddo

c     isajat=0
      isajat=1

      if(isajat.eq.1)then

      
      ktt=0
       do 13 j=1,nbasis
       i=1
 12    if(msc(i).eq.-2) then
c       print *,"msc",i,msc(i)
          cc(1)=c(i+1,j)
          cc(2)=c(i+2,j)
          cc(3)=c(i+4,j)
          cc(4)=c(i+3,j)
          cc(5)=c(i,j)
          do 14 k=1,5
 14       c(i+k-1,j)=cc(k)
          i=i+5
          if(i.gt.nbasis)goto 13	
          go to 12
          else
c       print *,"msc",i,msc(i)
          i=i+1
          if(i.gt.nbasis)goto 13	
          goto 12
           endif
  13      continue        

         endif

         if(isajat.eq.0)then
         do 213 j=1,ncshell
         if(mssh(j).eq.-2)then
         i=iaos(j)-1
         imap(i+1)=i+2
         imap(i+2)=i+3
         imap(i+3)=i+5
         imap(i+4)=i+4
         imap(i+5)=i+1
          endif
         continue
 213  continue
 613    format(25i3)
           endif

      ktt=0
       do 113 j=1,nbasis
       i=1
 112   if(msc(i).eq.-3) then
c       print *,"msc",i,msc(i)
          cc(1)=c(i+1,j)
          cc(2)=c(i+5,j)
          cc(3)=c(i+2,j)
          cc(4)=c(i+6,j)
          cc(5)=c(i,j)
          cc(6)=c(i+3,j)
          cc(7)=c(i+4,j)
          do 114 k=1,7
 114      c(i+k-1,j)=cc(k)
          i=i+7
          if(i.gt.nbasis)goto 113	
          go to 112
          else
c       print *,"msc",i,msc(i)
          i=i+1
          if(i.gt.nbasis)goto 113	
          goto 112
           endif
 113      continue        

      print *,'nocc:',nocc,'    nalpha:',nalf,'    nbeta:',nb 
      print *,' '
      if(nalf.ne.nb)then
      print *, '  ************************************************* '
      print *, '  THIS VERSION IS APPLICABLE FOR THE RHF CASE ONLY'
      print *, '  ************************************************* '
      stop
      else
      endif
      if(ienerg.eq.1) then
      print *,' E(SCF)=',escf
      else
      print *,' E(SCF/DFT)=',escf
      endif 
      print *,' '

 61   format(3D20.10)
 65   format(20i4)
 666  format(10f8.5)
       ifg=ipr
 617  format(45i2)
 618  format(4i4)

      kt=0
      do 15 i=1,ipr
      if(msc(i).ne.-2) goto 15   
      kt=kt+1
      if(kt.eq.4) ncont(i)=2*ncont(i)
      if(kt.eq.5) then 
        ncont(i)=3*ncont(i)
        kt=0
      endif 
 15   continue

      kt=0
      do 16 i=1,ipr
      if(msc(i).ne.-3) goto 16   
      kt=kt+1
      if(kt.eq.1.or.kt.eq.3.or.kt.eq.5) ncont(i)=3*ncont(i)
      if(kt.eq.2.or.kt.eq.4.or.kt.eq.6) ncont(i)=2*ncont(i)
      if(kt.eq.7) kt=0
 16   continue
      
      i=1
       do 712 ii=1,ncshell
      if(mssh(ii).eq.1) then
       do  k=1,mnsh(ii)
      c2(i)=c1(i)
      c1(i)=0.d0
       i=i+1
       enddo
       else
       i=i+mnsh(ii)
      endif
 712   continue

       ii=1
       do 711 i=1,ncshell
      msi=iabs(mssh(i))
       do j=1,mnsh(i)
      if(msi.le.1) c1(ii)=c1(ii)*anorm(0,0,0,expsh(ii))
      if(msi.eq.1) c2(ii)=c2(ii)*anorm(1,0,0,expsh(ii))
      if(msi.eq.2) c1(ii)=c1(ii)*anorm(2,0,0,expsh(ii))
       ii=ii+1
       enddo
 711   continue
c     print *,'    Nbasis=',nbasis
      return
 1000 stop 1000
      end
 

C
C
C
      subroutine start
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (PI=3.141592653589793D0)
      PARAMETER (maxp=2000,maxg=1000,maxc=16,maxat=60) 
      parameter (mgmax=10 000 000)
      parameter (nmax=900)
      common /stv/ sp(nmax,nmax),tt(nmax,nmax),
     $             vv(nmax,nmax,maxat)
      common /nat/ nat,igr,ifg,idum(4)
      common /fnutab/f(2505,13)
      common /intertab/d1,d2,d3,d4

      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /pr/iprint
      dimension d1(2504,13),d2(2503,13),d3(2502,13),d4(2501,13)
c      data bohr/0.52917715D+00/
c      data bohr/0.52917706D+00/


      PQ(iata,jatb,ipr,jpr,kcart)
     $ =(expp(ipr)*coord(kcart,iata)+
     $      expp(jpr)*coord(kcart,jatb))/(expp(ipr)+expp(jpr))
   
      call init
      call input


      print *,"Number of atoms:",nat
      print *,"Number of primitives:",ifg
      print *,"Number of basis functions:",igr

c the renormalization of contraction coefficients
         
       do 700 i=1,igr
       do 701 ic=1,ncont(i)
      ipr=ifill(i)+ic-1
      qi=anorm(n(ipr),l(ipr),m(ipr),expp(ipr))
      coeff(i,ic)=coeff(i,ic)*qi 
 701   continue
 700   continue


       do 400 i=1,igr
         if(ncont(i).eq.1) goto 444
        finorm=0.d0
       do 401 ic=1,ncont(i)
      ipr=ifill(i)+ic-1
        do 403 jc=1,ncont(i)
       jpr=ifill(i)+jc-1         
        finorm=finorm+
     $  coeff(i,ic)*S(n(ipr),l(ipr),m(ipr),n(jpr),l(jpr),m(jpr),
     $  expp(ipr),expp(jpr),0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0)*
     $  coeff(i,jc)
 403    continue
 401   continue
       do 404 ic=1,ncont(i)
 404       coeff(i,ic)=coeff(i,ic)/dsqrt(finorm)
 444   do 445 ic=1,ncont(i)
 445   continue       
 400   continue

      
       do 600 iatt=1,nat
      ncsi=iulim(iatt)-llim(iatt)+1
       do 601 jatt=1,nat
      ncsj =iulim(jatt)-llim(jatt)+1
       do 602 i=1,ncsi 
      igr=llim(iatt)+i-1 
      ngri=ifiul(igr)-ifill(igr)+1
       il=1
       if(iatt.eq.jatt)il=i
       do 603 j=il,ncsj
      atfed1=0.d0
      enkin1=0.d0
      jgr=llim(jatt)+j-1 
      ngrj=ifiul(jgr)-ifill(jgr)+1
       do 604 ki=1,ngri
      ipr=ifill(igr)+ki-1
       do 605 kj=1,ngrj
      jpr=ifill(jgr)+kj-1
      PAX=(coord(1,jatt)-coord(1,iatt))*expp(jpr)/
     $     (expp(ipr)+expp(jpr))        
      PBX=(coord(1,iatt)-coord(1,jatt))*expp(ipr)/
     $     (expp(jpr)+expp(ipr))        
      PAY=(coord(2,jatt)-coord(2,iatt))*expp(jpr)/
     $     (expp(ipr)+expp(jpr))        
      PBY=(coord(2,iatt)-coord(2,jatt))*expp(ipr)/
     $     (expp(jpr)+expp(ipr))        
      PAZ=(coord(3,jatt)-coord(3,iatt))*expp(jpr)/
     $     (expp(ipr)+expp(jpr))        
      PBZ=(coord(3,iatt)-coord(3,jatt))*expp(ipr)/
     $     (expp(jpr)+expp(ipr))        
      atfed=S(n(ipr),l(ipr),m(ipr),n(jpr),l(jpr),m(jpr),expp(ipr),
     $ expp(jpr),ab2(iatt,jatt),PAX,PBX,PAY,PBY,PAZ,PBZ)
      atfed1=atfed1+coeff(igr,ki)*atfed*coeff(jgr,kj)

c computation of the kinetic energy

      enkin=T(n(ipr),l(ipr),m(ipr),n(jpr),l(jpr),m(jpr),expp(ipr),
     $ expp(jpr),ab2(iatt,jatt),PAX,PBX,PAY,PBY,PAZ,PBZ)
      enkin1=enkin1+coeff(igr,ki)*enkin*coeff(jgr,kj)  
  605  continue 
  604  continue 
       sp(igr,jgr)=atfed1 
       sp(jgr,igr)=atfed1 
c      tt(igr,jgr)=enkin1
c      tt(jgr,igr)=enkin1 
  603  continue    
  602  continue    
  601  continue    
  600  continue    


c       do 802 katt=1,nat
c       do 800 ig=1,igr
c     ngri=ifiul(ig)-ifill(ig)+1
c       do 801 jg=ig,igr
c     ngrj=ifiul(jg)-ifill(jg)+1
c       enuc=0.d0
c       do 803 i=1,ngri
c       do 804 j=1,ngrj
c     ik=i+ifill(ig)-1
c     jk=j+ifill(jg)-1
c     enuc=enuc+coeff(ig,i)*vcore(ik,jk,katt)*coeff(jg,j)
c804    continue
c803    continue  
c     vv(ig,jg,katt)=enuc
c     vv(jg,ig,katt)=enuc 
c801    continue
c800    continue        
c802    continue

 3000 return       
      end 

       function Vcore(iafg,ibfg,katt)
      implicit real*8(a-h,o-z)
      PARAMETER (maxp=2000,maxg=1000,maxc=16,maxat=60)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      parameter (nmax=900)
      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)

      iatt=iat(iafg)
      jatt=iat(ibfg)        
      diff=0.d0  
   
      PAX=(coord(1,jatt)-coord(1,iatt))*expp(ibfg)/
     $     (expp(iafg)+expp(ibfg))   
      PBX=(coord(1,iatt)-coord(1,jatt))*expp(iafg)/
     $     (expp(ibfg)+expp(iafg))   
      PCX=PAX+coord(1,iatt)-coord(1,katt)        
      PAY=(coord(2,jatt)-coord(2,iatt))*expp(ibfg)/
     $     (expp(iafg)+expp(ibfg))   
      PBY=(coord(2,iatt)-coord(2,jatt))*expp(iafg)/
     $     (expp(ibfg)+expp(iafg))   
      PCY=PAY+coord(2,iatt)-coord(2,katt)        
      PAZ=(coord(3,jatt)-coord(3,iatt))*expp(ibfg)/
     $     (expp(iafg)+expp(ibfg))   
      PBZ=(coord(3,iatt)-coord(3,jatt))*expp(iafg)/
     $     (expp(ibfg)+expp(iafg))   
      PCZ=PAZ+coord(3,iatt)-coord(3,katt)        
     
      do kk=1,3
        diff=diff+
     $    ((expp(iafg)*coord(kk,iatt)+expp(ibfg)*coord(kk,jatt))
     $    /(expp(iafg)+expp(ibfg))-coord(kk,katt))**2   
      enddo
      pc2=diff
 
      vcore=V(n(iafg),l(iafg),m(iafg),n(ibfg),l(ibfg),m(ibfg),
     $       expp(iafg),expp(ibfg),ab2(iatt,jatt),pc2,
     $       PAX,PAY,PAZ,PBX,PBY,PBZ,PCX,PCY,PCZ)*(-zn(katt))
      return 
      end

      function AB2(iata,jatb)
      implicit real*8(a-h,o-z)
      PARAMETER (maxp=2000,maxg=1000,maxc=16,maxat=60)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      diff=0.d0
      do k=1,3
        diff=diff+(coord(k,iata)-coord(k,jatb))**2
      enddo
      AB2=diff
      return
      end

