c     
c-------------------------------------------------------------------------------
c
c                    Program EFF-AO, Version 1.00
c                   -----------------------------
c
c    Calculating:
c    ------------
c
c      A) Conventional (Hilbert space) bond orders and valences
c         (I. Mayer, Chem. Phys.Lett. 97, 270, 1983....)
c
c      B) Mulliken populations
c
c      C) "Effective AO"-s as atomic natural hybrids
c         (R. McWeeny, Rev. Mod. Phys. 32, 335, 1960; see also I. Mayer, 
c         Chem. Phys. Lett. 242, 499, 1995; J.Phys. Chem. 100, 6249, 1996).
c
c
c    Cite this program as:
c    ---------------------
c    I. Mayer, Program "EFF-AO", Version 1.00, Budapest, 2008.     
c
c-------------------------------------------------------------------------------
C  The program has been written by using parts of the pprogram APOST by
c  I. Mayer and A. Hamza, Budapest, 2000-2003.
c      
c
c                     
c          e-mail: mayer@chemres.hu
c
c ------------------------------------------------------------------------
c
c

      implicit real*8(a-h,o-z)
      common iop(45)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      
      parameter (nmax=500)
      parameter (ndeckl=500)
      parameter (maxat=20)
      parameter (maxat1=101)
      parameter (maxp=2000)
      common /lim/ llim(nmax),iulim(nmax)
      dimension ibe(20)
c     dimension sam(nmax,nmax)
      dimension h(nmax,nmax)
      dimension pmul(maxat)
      dimension sm12(ndeckl,ndeckl),sp12(ndeckl,ndeckl),
     $   strt(ndeckl,ndeckl),ptrt(ndeckl,ndeckl)
     $ , s23(ndeckl),s23m(ndeckl)
      common /c/ps(nmax,nmax),p(nmax,nmax)
      dimension c(nmax,nmax)   
      dimension clin(nmax**2)
      equivalence (clin(1),c(1,1))
      common /pointer/na(maxat)     
      common /hold/ihold(nmax),illim(nmax)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(nmax,nmax),t(nmax,nmax),
     $             sat(nmax,nmax,maxat)
      common /ia/iznuc(maxat),kop,megall
      common /achi/achi(maxat,maxat)

      common /map/imap(maxp),imap2(maxp),ireadp
      common /qat/qat(maxat,2)
      common /ovpop/op(maxat,maxat),totq
      common /lbl/msc(nmax)

      dimension mocal(4),ilab(40),ilabel(nmax)
      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    


      data itot  /'Tota'/
      data ispin  /'Spin'/
      data irohf1 /'  RO'/
      data irohf2 /'HF  '/
      data mocal /'Alph','a MO',' coe','ffic'/

      data ispace /'    '/
      data ilab(1)/'   S'/
      data ilab(2)/'  PX'/
      data ilab(3)/'  PY'/
      data ilab(4)/'  PZ'/
      data ilab(5)/'  XX'/
      data ilab(6)/'  YY'/
      data ilab(7)/'  ZZ'/
      data ilab(8)/'  XY'/
      data ilab(9)/'  XZ'/
      data ilab(10)/'  YZ'/
      data ilab(11)/' D 0'/
      data ilab(12)/' D+1'/
      data ilab(13)/' D-1'/
      data ilab(14)/' D+2'/
      data ilab(15)/' D-2'/
      data ilab(16)/' F 0'/
      data ilab(17)/' F+1'/
      data ilab(18)/' F-1'/
      data ilab(19)/' F+2'/
      data ilab(20)/' F-2'/
      data ilab(21)/' F+3'/
      data ilab(22)/' F-3'/
      data ilab(23)/'  F '/
      
      

      call kiir
      call start
 
      
      m=igr

      call getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      if(nat.ne.natoms) stop 7584
      if(m.ne.nbas) stop 7585
      
      call getsome(nmax,nbas,natoms,h)

      call denstest
      
      call inpint(natoms,llim,iulim)
c     print *, (msc(i),i=1,nbas)
c     print *,' Data:'
c     print 80,(ilab(i),i=1,4)
c     call flush
      i=1
  111 if(msc(i).eq.0) then
c     print *,i,msc(i)
      ilabel(i)=ilab(1)
c     write(*,80),ilabel(i)
      i=i+1
c     call flush
      if(i.gt.nbas)goto 112
      goto 111
      endif
      if(msc(i).eq.1)then
c     print *,i,msc(i)
      ilabel(i)=ilab(2)
      ilabel(i+1)=ilab(3)
      ilabel(i+2)=ilab(4)
c     write(*,80)ilabel(i),ilabel(i+1),ilabel(i+2)
      i=i+3
      if(i.gt.nbas)goto 112
      goto 111
      endif
      if(msc(i).eq.2)then
      ilabel(i)=ilab(5)
      ilabel(i+1)=ilab(6)
      ilabel(i+2)=ilab(7)
      ilabel(i+3)=ilab(8)
      ilabel(i+4)=ilab(9)
      ilabel(i+5)=ilab(10)
      i=i+6            
      if(i.gt.nbas)goto 112
      goto 111
      endif        
      if(msc(i).eq.-2)then
      ilabel(i)=ilab(11)
      ilabel(i+1)=ilab(12)
      ilabel(i+2)=ilab(13)
      ilabel(i+3)=ilab(14)
      ilabel(i+4)=ilab(15)
      i=i+5
      if(i.gt.nbas)goto 112
      goto 111
      endif

      if(msc(i).eq.-3)then
      ilabel(i)=ilab(16)
      ilabel(i+1)=ilab(17)
      ilabel(i+2)=ilab(18)
      ilabel(i+3)=ilab(19)
      ilabel(i+4)=ilab(20)
      ilabel(i+5)=ilab(21)
      ilabel(i+6)=ilab(22)
      i=i+7            
      if(i.gt.nbas)goto 112
      goto 111
      endif        
      if(msc(i).eq.3)then
      do k=i,i+9
      ilabel(k)=ilab(23)
      enddo
      i=i+10
      if(i.gt.nbas)goto 112
      goto 111
      endif
      ilabel(i)=ispace
      i=i+1
      if(i.gt.nbas)goto 112
      goto 111
c     call flush
 80   format(20a4)
      
 112  continue   
c112  write(*,80)(ilabel(i),i=1,nbas)
c     call numint
      if(ireadp.eq.1) call ordersat(nmax,nbas,natoms,h)
  
       tc1=0.d0
       tc2=0.d0
       do kat=1,nat
       x=0.d0
       do mu=1,igr
       do nu=1,igr
       x=x+p(mu,nu)*sat(mu,nu,kat)
       enddo
       enddo
       qat(kat,1)=x
       qat(kat,2)=0.d0
       enddo

       do mu=1,igr
       kat=ihold(mu)
       x=0.d0
       do itau=1,igr
       x=x+p(mu,itau)*s(itau,mu)
       enddo
       qat(kat,2)=qat(kat,2)+x
       enddo
       
      call border(P,ps,S,llim,iulim,natoms,nbas)
      print *,'  '
      print *,'  '
      print *,'    ELECTRON POPULATIONS'
      print *,'  '
      print *,'  Atom   Mulliken'
      print *,' -----------------'
      do i=1,nat
c     tc1=tc1+qat(i,1)
      tc2=tc2+qat(i,2)
      print 161, i,mend(iznuc(i)),qat(i,2)
 161  format(1x,i3,A4,2f10.6)      
      enddo
      print *,' -----------------'
      print 162, tc2
 162  format(1x,'  Sum  ',2f10.6)  
      print *,'  '
      print *,'  '
      print *,'    TOTAL ATOMIC CHARGES    '
      print *,'  '
      print *,'  Atom   Mulliken'
      print *,' -----------------'
      tc1=0.d0
      tc2=0.d0
      do i=1,nat
c     tc1=tc1-qat(i,1)+dfloat(iznuc(i))
      tc2=tc2-qat(i,2)+dfloat(iznuc(i))
      print 161, i,mend(iznuc(i)),
     $    dfloat(iznuc(i))-qat(i,2)
      enddo
      print *,' -----------------'
      print 162,  tc2
      print *,'  '
      print *,'  '
 667  format(1x,79(1h-))       
      
      print *," Mulliken's net atomic populations"
      print *,'    (=sum of natural occuppancies)'
        
      print *,' -----------------'
      qqnet=0.d0
      do i=1,natoms
      qnet=0.d0
      do mu=llim(i),iulim(i)
      do nu=llim(i),iulim(i)
      qnet=qnet+p(mu,nu)*s(nu,mu)
      enddo
      enddo
      print 161, i,mend(iznuc(i)),qnet     
c     print *,i, qnet
      qqnet=qqnet+qnet
      enddo
      print *,' -----------------'
      Print 162,qqnet
      do i=1,nbas
      do j=1,nbas
      strt(i,j)=s(i,j)
      ptrt(i,j)=p(i,j)
      enddo
      enddo
      
      do i=1,nbas
      do j=1,nbas
      s(i,j)=0.d0
      enddo
      enddo

      
      do iat=1,natoms
      do mu=llim(iat),iulim(iat)     
      do nu=llim(iat),iulim(iat)     
      s(mu,nu)=strt(mu,nu)
      enddo
      enddo
      enddo

c     print *, ' Blocked S matrix'
c     call mprint2(s,nbas,ndeckl)


      call sdiag(s,ndeckl,s23,nbas)
c     print *,' Eigenvalues of Blocked S'
c     print *, (s23(i),i=1,nbas)
      do i=1,nbas
      x=dsqrt(s23(i))
      s23(i)=x
      s23m(i)=1.d0/x
      enddo
c     print *, (s23(i),i=1,nbas)

      do i=1,nbas 
      do j=1,nbas 
      x=0.d0
      y=0.d0
      do k=1,nbas
      x=x+s(i,k)*s23(k)*s(j,k)
      y=y+s(i,k)*s23m(k)*s(j,k)
      enddo
      sp12(i,j)=x
      sm12(i,j)=y
      enddo
      enddo

c     print *, ' Blocked S^(-1/2) matrix'
c     call mprint2(sm12,nbas,ndeckl)

      do mu=1,nbas
      do nu=1,nbas
      x=0.d0
      y=0.d0
      do iro=1,nbas
      x=x+sp12(mu,iro)*ptrt(iro,nu)
      y=y+sm12(mu,iro)*strt(iro,nu)
      enddo
      c(mu,nu)=x
      t(mu,nu)=y
      enddo
      enddo


      do mu=1,nbas
      do nu=1,nbas
      x=0.d0
      y=0.d0
      do iro=1,nbas
      x=x+t(mu,iro)*sm12(iro,nu)
      y=y+c(mu,iro)*sp12(iro,nu)
      enddo
      s(mu,nu)=x
      p(mu,nu)=y
      enddo
      enddo



      
c     call pm(c,nocc,nbas,p,ndeckl)
c     call border(P,sam,S,llim,iulim,natoms,nbas)


      


      
c     print *,' '
c     print *, ' Mulliken populations'
c     print *,' '
c     q=0.d0
c     do iat=1,natoms
c     x=0.d0
c     do mu=llim(iat),iulim(iat)
c     do nu=1,nbas
c     x=x+P(mu,nu)*S(nu,mu)
c     enddo
c     enddo
c     q=q+x
c     print *, iat,x
c     print *,' -----------'
c     print *, q
c     enddo
      
      
      
c     print *," Mulliken's net atomic populations"
c     print *,' '
        
c     print *,' -----------------'
c     do i=1,natoms
c     qnet=0.d0
c     do mu=llim(i),iulim(i)
c     do nu=llim(i),iulim(i)
c     qnet=qnet+p(mu,nu)*s(nu,mu)
c     enddo
c     enddo
c     print *,i, qnet
c     enddo
c     print *,' -----------------'
      
      do i=1,nbas
      do j=1,nbas
      t(i,j)=0.d0
      enddo
      enddo


      print *,' '
      do iat=1,natoms
       print 667
      print *,' '
      print *,'     ATOM  ',iat
      print *,' '
      ishift=llim(iat)-1
      ibas=iulim(iat)-llim(iat)+1
      do mu=1,ibas  
      do nu=1,ibas  
      t(mu,nu)=p(mu+ishift,nu+ishift)
      enddo
      enddo

c     print *, ' Blocked P matrix'
c     call mprint2(t,ibas,ndeckl)

      do i=1,ibas
      s23(i)=0.d0
      enddo
      
      call sdiag(t,ndeckl,s23,ibas)
c     print *,' Natural occupancies '
c     print *, (s23(i),i=1,ibas)
      q=0.d0
      do i=1,ibas
      q=q+s23(i)
      enddo
      print *,' '
      print *,' Sum of natural occupancies= ',q
      print *,' '
      
c     print *, ' Eigenvectors'
c     call mprint2(t,ibas,ndeckl)
      
      do mu=1,ibas
      do nu=1,ibas
      x=0.d0
      do iro=1,ibas
      x=x+sm12(mu+ishift,iro+ishift)*t(iro,nu)
      enddo
      c(mu,nu)=x
      enddo
      enddo

      do i=1,ibas
      if(dabs(s23(i)).le.0.001) goto 122
      iveg=i
      enddo

 122  print *, ' Normalized hybrids with natural occupancies > 0.001'
      print *,' '
      istart=llim(iat)
      call mprint2(c,iveg,ibas,ndeckl,s23,ilabel(istart))
      
      enddo

 
        
      stop  
 1000 stop 1000     
      end 

      subroutine getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      implicit real*8(a-h,o-z)
      dimension llim(nmax),iulim(nmax),na(maxat)
      NATOMS=0
      NBAS=0
      DO 3 I=1,nmax
      IF(iulim(I).GT.0) NATOMS=I
  3   NBAS=iulim(natoms)
       if(natoms.gt.maxat)then
      write(*,*)'   TOO MANY ATOMS, STOP'
      stop
       endif
      if(natoms.eq.1) then
      write(*,*)'  ONLY ONE ATOM'
      stop  
      endif
      nnn=0
      do 4 i=1,natoms
      na(i)=iulim(i)-llim(i)+1
  4   nnn=nnn+na(i)
      if(nnn.ne.nbas)stop 1212
      nnab=(natoms*(natoms-1))/2
      if(nnab*2.ne.natoms*(natoms-1))stop 1213

      print *,'   '
      write(*,*)natoms,' ATOMS, ',nnab,' ATOMIC PAIRS'
      
      end

      subroutine getsome(ndeckl,nbas,natoms,h)
      implicit real*8(a-h,o-z)
      parameter (maxat=20)
      parameter (nmax=500) 
      parameter (maxp=2000)
      common /stv/ s(nmax,nmax),t(nmax,nmax),
     $   vv(nmax,nmax,maxat)   
      common /c/ps(nmax,nmax),p(nmax,nmax)
      dimension h(nmax,nmax)
      common /map/imap(maxp),imap2(maxp),ireadp
      m=nbas
       do 121 j=1,m
       jj=imap(j)
       do 121 i=1,m
        ii=imap(i)
  121  h(jj,ii)=s(j,i)
       do 131 i=1,m
       do 131 j=1,m
  131  s(j,i)=h(j,i)
       
       return
       end

      subroutine pm(c,nocc,m,p,ndeckl)  
      implicit real*8(a-h,o-z)
      dimension c(ndeckl,ndeckl),p(ndeckl,ndeckl)
       do 1 i=1,m
       do 1 j=1,m
       x=0.d0
       do 2 k=1,nocc
  2     x=x+c(i,k)*c(j,k)
  1    p(i,j)=2.d0*x

  61  format(1x,8f9.7)

       return
       end

      subroutine inpint(natoms,llim,iulim)
      IMPLICIT REAL*8 (A-H,O-Z)
      
      parameter (maxat=20)
      parameter (nmax=500)
c     dimension g(mgmax)
      dimension llim(nmax),iulim(nmax)
      common /pointer/na(maxat)     
      common /hold/ihold(nmax),illim(nmax)
      common /nat/ nat,igr,ifg,idum3(4)
      common iop(45)
     
      do i=1,natoms
      do mu=llim(i),iulim(i)
      ihold(mu)=i
      enddo
      enddo
   61 format(20i2)

      do i=1,natoms
      illim(i)=llim(i)
      enddo

c     call gamgen
c     do i=1,Natoms
c     call shellat(i,igr,natoms)
c     if(iop(7).ne.0)call unconat(i)
c     enddo
      
      return      
      end


      SUBROUTINE MPRINT(H,N,ndim)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION H(NDIM,NDIM)
      parameter (maxat=20)
      common /ia/ia(maxat),kkk,idummy

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
    
      K=8 
   65 FORMAT(1H0,40X,A4/)
      NMIN=1
      NMAX=MIN0(N,K)
   62 FORMAT(1X,I3,A4,8F9.4)
   1  PRINT 61, (I, mend(ia(i)),I=NMIN,NMAX)
   61 FORMAT(10X,8(1X,I3,A4,1X))
      PRINT 64
   64 FORMAT(1X)
      DO 2 I=1,N
      PRINT 62,I,mend(ia(i)),(H(I,J),J=NMIN,NMAX)
   2  CONTINUE
      NMIN=NMIN+8
      K=K+8
      NMAX=MIN0(N,K)
      IF(NMAX.GE.NMIN) GOTO 71
      RETURN
   71 PRINT 63
   63 FORMAT(1X///)
      GO TO 1
      END

      subroutine kiir
      implicit real*8(a-h,o-z)
      write(*,6670)
      write(*,6661)
 6661 format(/20x,'Program EFF-AO, Version 1.00')
      write(*,6662)
 6662 format(20x,28(1h-),/)
      write(*,6663)
      write(*,6660)
 6663 format(3x,'Calculating:')
 6660 format(3x,'------------',/)
      write(*,6664)
 6664 format(5x,2hA),' Conventional (Hilbert space) bond orders and'
     $ , ' valences'/'        (I. Mayer, Chem. Phys.'
     $,'Lett. 97, 270, 1983....)',/)
      write(*,6665)
 6665 format(5x,2hB)," Mulliken's  populations"/)
      write(*,6545)
 6545 format(5x,2hC),' "Effective AO"-s as atomic natural hybrids',/,
     $'        (R. McWeeny, Rev. Mod. Phys. 32, 335, 1960; see also I.'
     $,' Mayer',/, 
     $'         Chem. Phys. Lett. 242, 499, 1995; J.Phys. Chem. 100,', 
     $' 6249, 1996).',/)
 6666 format(3x,'for a wave function obtained in a Gaussian ',
     $ 'calculation (G92, G94, G98, G03...?)',//)
      write(*,6667)
      write(*,6668)
      write(*,6669)
 6667 format(2x,' Cite this program as:')
 6668 format(2x,' ---------------------')
 6669 format(' I. Mayer, Program "EFF-AO", Version 1.00,'
     $ ,' Budapest, 2008.',/)
 6670 format(1x,79(1h-))
      write(*,6670)
      end

      subroutine ordersat(ndeckl,nbas,natoms,h)
      implicit real*8(a-h,o-z)
      parameter (maxat=20)
      parameter (nmax=500) 
      parameter (maxp=2000)
      common /stv/ s(nmax,nmax),t(nmax,nmax),
     $   sat(nmax,nmax,maxat)   
      common /c/ps(nmax,nmax),p(nmax,nmax)
      dimension h(nmax,nmax)
      common /map/imap(maxp),imap2(maxp),ireadp
      m=nbas
c     print *, 'Ordersat'
c     print *,(imap2(i),i=1,nbas)
       do 1 kat=1,natoms
       do 121 j=1,m
       jj=imap2(j)
       do 121 i=1,m
        ii=imap2(i)
  121  h(jj,ii)=sat(j,i,kat)
       do 131 i=1,m
       do 131 j=1,m
  131  sat(j,i,kat)=h(j,i)
    1  continue 
       return
       end



      
      
      subroutine denstest
      implicit real*8(a-h,o-z)
      common iop(45)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      
      parameter (nmax=500)
      parameter (maxat=20)
      parameter (maxat1=101)
      parameter (maxp=2000)
      common /lim/ llim(nmax),iulim(nmax)
      dimension ibe(20)
c     dimension sam(nmax,nmax)
      dimension h(nmax,nmax)
      dimension pmul(maxat)
      common /c/ps(nmax,nmax),p(nmax,nmax)
      common /opensh/ cb(nmax,nmax)   
      dimension clin(nmax**2)
      equivalence (clin(1),cb(1,1))
      common /pointer/na(maxat)     
      common /hold/ihold(nmax),illim(nmax)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(nmax,nmax),t(nmax,nmax),
     $             sat(nmax,nmax,maxat)
      common /ia/iznuc(maxat),kop,megall
      common /achi/achi(maxat,maxat)

      common /map/imap(maxp),imap2(maxp),ireadp
      common /qat/qat(maxat,2)
      common /ovpop/op(maxat,maxat),totq

      dimension mocal(4)
    


      data itot  /'Tota'/
      data ispin  /'Spin'/
      data irohf1 /'  RO'/
      data irohf2 /'HF  '/
      data mocal /'Alph','a MO',' coe','ffic'/

      

 

      
      m=igr
      nbas=igr

c     call getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
c     if(nat.ne.natoms) stop 7584
c     if(m.ne.nbas) stop 7585
      
c     call getsome(nmax,nbas,natoms,h)

c     print *,' Checking the number of electrons'
       tc1=0.d0
       do mu=1,igr
c      kat=ihold(mu)
       x=0.d0
       do itau=1,igr
       x=x+p(mu,itau)*s(itau,mu)
       enddo
c      qat(kat,2)=qat(kat,2)+x
       tc1=tc1+x
       enddo

c      print *,'when calc',(qat(i,2),i=1,natoms)

c            print *,tc1,nalf,nb,nalf+nb
       if(dabs(tc1-dfloat(nalf+nb)).gt.0.1d0)then
      print *,' '
      Print *,' WRONG DENSITY  (Trace of DS=', tc1,')'
      rewind 15
      ntriang=(igr*(igr+1))/2
c     print *,' Ntriang',ntriang
      ndens=-1
 200  read(15,150,end=211)(ibe(i),i=1,4)
 150  format(20a4) 
      if(ibe(1).eq.itot)ndens=ndens+1
      goto 200
 211  rewind 15
 212  read(15,150,end=1711)(ibe(i),i=1,4)
      if(ibe(3).eq.irohf1.and.ibe(4).eq.irohf2)then 
      print *,' '
      Print *,' ROHF case'
      goto 2000
      else
      goto 212
      endif
 1711 print *, 'Different data order. Rereading the',  
     $   ndens,'-d/th density of the checkpoint file'   
      ncou=-1
      rewind 15
 220  read(15,150)(ibe(i),i=1,4)
      if(ibe(1).eq.itot)ncou=ncou+1
      if(ncou.eq.ndens) then
      read(15,*)(clin(i),i=1,ntriang)
c     print *, (clin(i),i=1,ntriang)
      goto 230
      else
      endif        
      goto 220

 230   ncou=1
      do j=1,i
      do i=j,igr
      p(i,j)=clin(ncou)
      p(j,i)=clin(ncou)
      ncou=ncou+1
      enddo
      enddo
      
      else
      endif


       tc1=0.d0
       do mu=1,igr
c      kat=ihold(mu)
       x=0.d0
       do itau=1,igr
       x=x+p(mu,itau)*s(itau,mu)
       enddo
c      qat(kat,2)=qat(kat,2)+x
       tc1=tc1+x
       enddo

c      print *,'when calc',(qat(i,2),i=1,natoms)

c              print *,tc1,nalf,nb,nalf+nb
       if(dabs(tc1-dfloat(nalf+nb)).gt.0.1d0)then
      Print *,' *** ', tc1
      print *,' WRONG DENSITY.  STOP. '
      STOP
      endif

      
c     do i=1,igr
c     print *,(p(i,j),j=1,i)
c     enddo
       
c     call pm(c,nocc,nbas,p,nmax)
c     print *,'after calling PM'
c     do i=1,igr
c     print 6230,(p(i,j),j=1,i)
c     enddo
c6230 format(5f10.5)    

      if(nalf.ne.nb)then
c      print *,' Checking the spin norm'
       tc1=0.d0
       do mu=1,igr
       x=0.d0
       do itau=1,igr
       x=x+ps(mu,itau)*s(itau,mu)
       enddo
       tc1=tc1+x
       enddo

c      print *,'when calc',(qat(i,2),i=1,natoms)

c             print *,tc1,nalf,nb,nalf-nb

      if(dabs(tc1-dfloat(nalf-nb)).gt.0.01d0)then
               
      rewind 15
      ntriang=(igr*(igr+1))/2
      print *,' Ntriang',ntriang
      nsdens=0
 1200 read(15,150,end=1211)(ibe(i),i=1,4)
 1150 format(20a4) 
      if(ibe(1).eq.ispin)nsdens=ndens+1
      goto 1200
 1211 if(nsdens.eq.0) goto 1500
      print *, 'Different data order. Rereading the',  
     $   nsdens,'-d/th s.density of the checkpoint file'   
      ncou=-1
      rewind 15
 1220 read(15,150)(ibe(i),i=1,4)
      if(ibe(1).eq.ispin)ncou=ncou+1
      if(ncou.eq.nsdens) then
      read(15,*)(clin(i),i=1,ntriang)
      goto 1230
      else
      endif        
      goto 1220

 1230 ncou=1
      do j=1,igr
      do i=j,igr
      ps(i,j)=clin(ncou)
      ps(j,i)=clin(ncou)
      ncou=ncou+1
      enddo
      enddo
      
      endif        
      endif
      goto 1510 
 1500 print *, ' No spin-density is present in the checkpoint file'      
      print *, ' In the ROHF case can be constructed '
      print *, ' In CAS (etc?) - not '
      stop
       
c       tc1=0.d0
c       do mu=1,igr
c       kat=ihold(mu)
c       x=0.d0
c       do itau=1,igr
c       x=x+p(mu,itau)*s(itau,mu)
c       enddo
c       qat(kat,2)=qat(kat,2)+x
c       tc1=tc1+x
c       enddo
cc      print *,'before calling border',(qat(i,2),i=1,natoms)

 1510  return    
  
       

 2000 print *,'Density and spin-density will be re-built by using' 
     $ ,  ' the MO-s'


       rewind 15
 146  read(15,150,end=1000)(ibe(i),i=1,4)

      if(ibe(1).eq.mocal(1).and.ibe(2).eq.mocal(2).
     $ and.ibe(3).eq.mocal(3).and.ibe(4).eq.mocal(4)) then
      read(15,*,err=2003)((cb(i,j),i=1,nbas),j=1,nbas)
 2003 continue    
      else 
      goto 146
      endif
        
      do mu=1,igr
      do nu=1,mu
      x=0.d0
      do i=1,nb
      x=x+cb(mu,i)*cb(nu,i)
      enddo
      p(mu,nu)=2.d0*x
      x=0.d0
      do j=nb+1,nalf
      x=x+cb(mu,i)*cb(nu,i)
      enddo
      p(mu,nu)=p(mu,nu)+x
      p(nu,mu)=p(mu,nu)
      ps(mu,nu)=x
      ps(nu,mu)=x
      enddo
      enddo
      
      T1=0.d0
      T2=0.d0
c     print *,t1,t2,igr
      do mu=1,igr
      do nu=1,igr
      t1=t1+p(mu,nu)*s(nu,mu)
      t2=t2+ps(mu,nu)*s(nu,mu)
      enddo
      enddo
c     print *, 'T1,T2', t1,t2,nalf+nb,nalf-nb
      print *,' '
      if(dabs(t1-dfloat(nalf+nb)).lt.0.01d0.and.
     $  dabs(t2-dfloat(nalf-nb)).lt.0.01d0)then
      print *, 'Now correct density and spin density  (Traces=', 
     $    t1,t2,')'
      else 
      print *, 'Irrecoverable case', t1,t2
      stop
      endif
      
      goto 1510



      
      

 
        
      stop  
 1000 stop 1000     
      end 

              
