      subroutine border(Pt,Ps,S,Illim,Iulim,Natoms,Nbasis)
      implicit real*8(a-h,o-z)
      parameter (maxat=20,nmax=500)
      dimension pt(nmax,nmax),ps(nmax,nmax),rindex(maxat,maxat)
      dimension tindex(maxat),diag(maxat),illim(nmax),iulim(nmax)
      dimension pas(nmax,nmax)
      dimension pss(nmax,nmax)
      dimension s(nmax,nmax) 
c     character*4 kiir1(4),kiir2(4) 
      dimension kiir1(4),kiir2(4) 
      common /ia/ia(maxat),kop,idummy 
      common /qat/qat(maxat,2)
      integer uli,ulj 

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ ' Fl ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
       data kiir1/'  AT','OM  ','VALE','NCE '/
       data kiir2/' ATO','M   ','VALE','NCE '/
c
C
c
C  CALCULATING CONVENTIONAL BOND-ORDER AND VALENCE INDICES ACCORDING TO
C  I. MAYER, CHEM.PHYS.LETT.97,270 (1983) and 117,396 (1985)
C  - see also TCA 67, 315 (1985), IJQC 29, 73,477 (1986)  
C
C  
C  Input parameters: Pt: Total electron density matrix;
c                    Ps: Spin density matrix;
c                    S: Overlap matrix; 
c                    Illim and Iulim: arrays of lower and upper limits of the 
c                                basis orbitals belonging to a given atom;
c                    Natoms: number of the atoms;
c                    Nbasis: number of basis orbitals.
c       
c
       print 667
 667   format(1x,79(1h-))      
       print *,' '
       print *,' '
       Print 666
 666  FORMAT(1H ,2X,'CONVENTIONAL (HILBERT SPACE) BOND ORDER AND'
     $  ,' VALENCE INDICES',/,
     $'       ACCORDING TO: I.MAYER, CHEM.PHYS.LETT. 97,270 (1983)'//,
     $' (MODIFIED ACCORDING TO I.MAYER, ibid. 117,396 (1985);',
     $' IJQC 29, 73 (1986)'/)
      IF(kop.EQ.0) WRITE (*,62)
      IF(kop.NE.0) WRITE (*,63)
  62  FORMAT(1X,'CLOSED-SHELL SYSTEM'/)
  63  FORMAT(1X,'OPEN-SHELL SYSTEM'/)
C
C
C  TAKE MATRIX PRODUCTS Pt*S, Ps*S
C
      DO 44 I=1,nbasis
      DO 44 J=1,nbasis
      X=0.0D0
      DO 205 K=1,nbasis
 205  X=X+Pt(I,K)*S(K,J)
  44  PAS(I,J)=X
      if(kop.ne.0)then
      DO 4 I=1,nbasis
      DO 4 J=1,nbasis
      X=0.0D0
      DO 105 K=1,nbasis
 105  X=X+Ps(I,K)*S(K,J)
  4   PSs(I,J)=X
      endif
c     Mulliken populations 
      do i=1,natoms
      q=0.d0
      do mu=illim(i),iulim(i)
      q=q+pas(mu,mu)
      enddo
      qat(i,2)=q
      enddo
      
 444  DO 6 I=1,NATOMS
      DO 6 J=I,NATOMS
      X=0.0D0
      LLI=ILLIM(I)
      ULI=IULIM(I)
      LLJ=ILLIM(J)
      ULJ=IULIM(J)
      DO 7 ILAM=LLI,ULI
      DO 7 IOM=LLJ,ULJ
  7   X=X+PAS(ILAM,IOM)*PAS(IOM,ILAM)
      rindex(I,J)=X
  6   rindex(J,I)=X
      DO 8 I=1,NATOMS
      DIAG(I)=rindex(I,I)
c     print *,'diag',diag(i)
  8   rindex(I,I)=0.0D0
c     CALL Mprint(rindex,NATOMS,maxat)
      if(kop.ne.0)then
      DO 78 I=1,NATOMS
      DO 76 J=I,NATOMS
      X=0.0D0
      LLI=ILLIM(I)
      ULI=IULIM(I)
      LLJ=ILLIM(J)
      ULJ=IULIM(J)
      DO 77 ILAM=LLI,ULI
      DO 77 IOM=LLJ,ULJ
  77  X=X+PSs(ILAM,IOM)*PSs(IOM,ILAM)
      rindex(I,J)=rindex(i,j)+X
  76  rindex(J,I)=rindex(i,j)
  78  rindex(i,i)=0.d0
      endif
      
c     GO TO 124
C
C  PRINTING THE MATRIX OF THE BOND ORDERS
C
  124 WRITE(*,6342)
 6342 FORMAT(1x,/11X,'CONVENTIONAL BOND ORDER MATRIX'//)
      CALL Mprint(rindex,NATOMS,maxat)
C
C CALCULATION OF THE VALENCE NUMBERS
C
      DO 9 I=1,NATOMS
      X=0.D0
      DO 10 J=1,NATOMS
  10  X=X+rindex(I,J)
  9   rindex(I,I)=X
      IF(kop.NE.0)then 
      do i=1,natoms 
      tindex(i)=rindex(i,i)
      enddo
      endif

      kmin1=min0(natoms,5)-1
 123  format(20A4)      
      do i=1,natoms
c     print *, 'qat,qiag',qat(i,2),diag(i)
      diag(i)=2.d0*qat(i,2)-diag(i)
      enddo
      
      WRITE(*,611)
      write(*,123)(kiir1(j),j=1,4),((kiir2(j),j=1,4),i=1,kmin1)
      write(*,640) (I,mend(ia(i)),diag(I),I=1,NATOMS)
      print  621
      write(*,640) (I,mend(ia(i)),rindex(I,I),I=1,NATOMS)
      print 612
      print *,' (In the closed shell RHF case should be zero)'
      print *,' '
      do i=1,i
      diag(i)=diag(i)-rindex(i,i)
      enddo
      write(*,640) (I,mend(ia(i)),diag(I),I=1,NATOMS)
 640  format(20(I3,A4,F8.5,4(I3,A4,1X,f8.5)/))
 611  FORMAT(//11X,'CONVENTIONAL TOTAL VALENCES'/)
 621  FORMAT(//11X,'VALENCES USED IN BONDS (SUM OF BOND ORDERS)'/)
 612  FORMAT(//11X,'FREE VALENCES',/)

      print *,' '
      print 667
      return
      end

