c        CRYSTALL VERSION, I. Mayer, Heidelberg, October 2000
C
c
C------------------------------------------------------------------------------
c
c
c
c
c
c                        Program APOST, Version 1.0
c                        ---------------------------
c
c                           I. Mayer and A. Hamza
c            Institute of Chemistry,  Chemical Research Center,
c    Hungarian Academy of Sciences, H-1515 Budapest, P.O.Box 17, Hungary
c
c          e-mails: hamza@occam.chemres.hu, mayer@cric.chemres.hu
c
c ------------------------------------------------------------------------
c
c   This program performs *a posteriori*
c
c       A) Bond order and valence analysis and
c
c       B) "Chemical Energy Component Analysis" (CECA)
c
c  of the ab initio SCF wave functions (RHF or UHF) produced by the
c  widely used "Gaussian" system (G92, G94, G98).
c
c
c  Bond order and valence indices represent LCAO counterparts of the
c  respective classical chemical parameters (I. Mayer, Chem. Phys. Lett.
c  97, 270 1983...) while "CECA" is a new tool permitting to express the
c  molecular energy -- approximately but to a good accuracy -- as a sum of
c  one- and diatomic energy components, the computation of which requires
c  one and two-center integrals only (I. Mayer, to be published); three-
c  and four-center effects are compressed to one- and two-center ones by
c  performing appropriate projections.
c
c
c

      implicit real*8(a-h,o-z)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
       
      common /range/llrange,iulrange,ncell,natc  
      
      parameter (nmax=800)
      parameter (maxat=100)
      parameter (maxat1=101)
      parameter (maxp=4000)
      parameter (ndeckl=800)
      parameter (mmax= 40 000 000)
      parameter (mgmax=12 000 000)
      common /lim/ llim(nmax),iulim(nmax)
      common /large/aa(mmax),gg(mgmax),z(mmax),gt(mgmax)  
      dimension sam(ndeckl,ndeckl)
      dimension ea(maxat),eab(maxat,maxat),h(ndeckl,ndeckl)
      common /c/c(ndeckl,ndeckl),p(ndeckl,ndeckl)
      common /pointer/ipoint(maxat),ijpoint(maxat,maxat),na(maxat)     
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(ndeckl,ndeckl),t(ndeckl,ndeckl),
     $             vv(ndeckl,ndeckl,maxat)
      common /ia/iznuc(maxat),kop

      common /map/imap(maxp)
c     data bohr/0.52917715D+00/
c     data bohr/0.52917706D+00/

      write(23)ndeckl    
      call kiir
c     print *,' start-ot hivja'
      call start
c     print *,' start utan'
 
      oneel=0.d0
      bsse=0.d0

      m=igr

      call getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      if(nat.ne.natoms) stop 7584
      if(m.ne.nbas) stop 7585
      nlength=natoms*nbas**2           
      if(nlength.gt.mmax)then
      write(*,*) nlength,' WORDS ARE REQUIRED FOR THE MATRIX Z/A'
      write(*,*) ' AVAILABLE ONLY:', mmax, '--  STOP'
      stop
      endif

      ng=0
      do i=1,natoms
      ipoint(i)=ng+1
      ng=ng+na(i)**4
      enddo
      ijpoint(1,2)=ng+1
      maxx=0
      do i=1,natoms-1
      do j=i+1,natoms
      maxx=max0(maxx,na(i)+na(j))
      enddo
      enddo
      ng=ng+maxx**4
      if(ng.gt.mgmax)then
      write(*,*) ng,' WORDS ARE REQUIRED FOR THE MATRIX G'
      write(*,*) ' AVAILABLE ONLY:', mgmax, '--  STOP'
      stop
      endif

      
      call getcore(z,ndeckl,nbas,natoms,h)

      if(iuhf.eq.1) then
      call enpo(na,ipoint,ijpoint) 
      stop
      endif

      call pm(c,nocc,nbas,p,ndeckl)
      call border(P,sam,S,llim,iulim,natoms,nbas)

      print *,'   '
      print 688
 688  format(80(1h-))
      print *,'   '
      nnab=(natoms*(natoms-1)/2)
c     write(*,*)natoms,' ATOMS, ',nnab,' ATOMIC PAIRS'
      call inpint(gg,mgmax,natoms,llim,iulim)
      eonec=0.d0
      do 100 i=1,natoms 
      ip=ipoint(i)
      call atomic(i,h,p,ndeckl,llim(i),na(i),sam,ea(i),
     $    z,nbas,natoms,gg(ip),aa)
c     write(*,*)' ATOM', i,' ATOMIC ENERGY COMPONENT ',ea(i) 
      if(i.ge.llrange.and.i.le.iulrange)eonec=eonec+ea(i)     
 100  continue
      write(*,*)' '
      write(*,*)' '
      write(*,*)' SUM OF THE ONE-CENTER ENERGY COMPONENTS', eonec

      nat1=natoms-1
      etwoc=0.d0
c     print *,'range',llrange,iulrange
      do 200 i=1,nat1
      i1=i+1
      do 200 j=i1,natoms
c     if(i.eq.j)goto 200
c     if(.not.(j.ge.llrange.and.j.le.iulrange))goto 200 
      if((.not.(j.ge.llrange.and.j.le.iulrange))
     $    .and.(.not.(i.ge.llrange.and.i.le.iulrange)))goto 200 
      nnn=na(i)+na(j)
      ip=ijpoint(1,2)
      ipi=ipoint(i)
      ipj=ipoint(j)

      call pairs(i,j,h,ndeckl,llim(i),na(i),llim(j),na(j),sam,
     $   nnn,eab(i,j),aa,p,z,m,natoms,gg(ip),gg(ipi),gg(ipj),gt)
c     write(*,*)' ATOMS', i,j,'TWO-CENTER EN. CONTRIBUTION ',eab(i,j) 
      eab(j,i)=eab(i,j)
c     if((j.ge.llrange.and.j.le.iulrange).and.i.ge.llrange.
c    $   and.i.le.iulrange)
      if(i.ge.llrange.and.i.le.iulrange) etwoc=etwoc+eab(i,j)  
 200  continue
      write(*,*)' '
      write(*,*)' SUM OF THE TWO-CENTER ENERGY COMPONENTS', etwoc
      econt=eonec+etwoc
      write(*,*)' '
      write(*,*)' '
      write(*,*)' SUM OF THE ONE AND TWO-CENTER COMPONENTS', econt
      do 66 i=1,natoms
  66  eab(i,i)=ea(i)

      write(*,*)' '
      write(*,*)' '
      Write(*,*)'          ENERGY COMPONENT MATRIX'
      write(*,*)' '
      call mprintb(eab,natoms,maxat)
c     call mprint(eab,natoms,maxat)
      end 

      subroutine getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      implicit real*8(a-h,o-z)
      parameter (n128=800)
      dimension llim(n128),iulim(n128),na(maxat)
      NATOMS=0
      NBAS=0
      DO 3 I=1,n128
      IF(iulim(I).GT.0) NATOMS=I
  3   NBAS=iulim(natoms)
       if(natoms.gt.maxat)then
      write(*,*)'   TOO MANY ATOMS, STOP'
      stop
       endif
      if(natoms.eq.1) then
      write(*,*)'  ONLY ONE ATOM'
      stop  
      endif
      nnn=0
      do 4 i=1,natoms
      na(i)=iulim(i)-llim(i)+1
  4   nnn=nnn+na(i)
      if(nnn.ne.nbas)stop 1212
      nnab=(natoms*(natoms-1))/2
      if(nnab*2.ne.natoms*(natoms-1))stop 1213

      print *,'   '
      write(*,*)natoms,' ATOMS, ',nnab,' ATOMIC PAIRS'
      
      end

      subroutine getcore(z,ndeckl,nbas,natoms,h)
      implicit real*8(a-h,o-z)
      parameter (maxat=100)
      parameter (ndeck=800) 
      parameter (maxp=4000)
      common /stv/ s(ndeck,ndeck),t(ndeck,ndeck),
     $   vv(ndeck,ndeck,maxat)   
      dimension h(ndeckl,ndeckl),z(nbas,nbas,natoms)
      common /map/imap(maxp)
      m=nbas

      do 1 iat=1,natoms
       do 11 j=1,m
       jj=imap(j)
       do 11 i=1,m
        ii=imap(i)
   11  z(jj,ii,iat)=vv(j,i,iat)
   1  continue
       do 21 j=1,m
       jj=imap(j)
       do 21 i=1,m
        ii=imap(i)
   21  h(jj,ii)=t(j,i)
       do 31 i=1,m
       do 31 j=1,m
   31  t(j,i)=h(j,i)
       
       do 121 j=1,m
       jj=imap(j)
       do 121 i=1,m
        ii=imap(i)
  121  h(jj,ii)=s(j,i)
       do 131 i=1,m
       do 131 j=1,m
  131  s(j,i)=h(j,i)
       
  61  format(1x,8f9.6)

       return
       end

      subroutine atomic(iat,h,p,ndeckl,llim,na,sam,ea,z,m,natoms,
     $ g,aa)
      implicit real*8(a-h,o-z)
      parameter (ndeck=800)
      parameter (maxat=100)
      common /stv/ s(ndeck,ndeck),t(ndeck,ndeck),
     $             vv(ndeck,ndeck,maxat)
      dimension h(ndeckl,ndeckl),sam(na,na)
      dimension p(ndeckl,ndeckl),z(m,m,natoms)
      dimension ha(ndeck,ndeck),a(ndeck,ndeck),b(ndeck,ndeck)
      dimension aa(m,m,natoms),g(na,na,na,na)
      common /oneel/oneel,bsse

      call invert1(s,ndeckl,sam,llim,na)
 613   format(10f8.4)
      do 1 i=1,m
      do 1 j=1,m
  1   ha(i,j)=t(i,j)+z(i,j,iat) 
       do 11 i=1,m
       do 11 j=1,m
       b(i,j)=0.d0
  11   a(j,i)=0.d0       


      do 2 lambda=1,m
      do 2 mu0=1,na
      mu=llim+mu0-1 
      x=0.d0
      do 3 isigm0=1,na
      isigm=isigm0+llim-1 
  3    x=x+s(lambda,isigm)*sam(isigm0,mu0)
   2  a(lambda,mu)=x
    
      do 18 i=1,m
      do 18 j=1,m
  18  aa(i,j,iat)=a(i,j)

      do 4  mu0=1,na
      mu=llim+mu0-1 
      do 4  nu0=1,na
      nu=llim+nu0-1 
      x=0.d0
      do 5 igam=1,m
  5   x=x+p(mu,igam)*a(igam,nu) 
  4   b(mu,nu)=x
 
      ea=0.d0
      do 6  mu0=1,na
      mu=llim+mu0-1 
      do 6  nu0=1,na
      nu=llim+nu0-1 
  6   ea=ea+b(nu,mu)*ha(mu,nu)
      oneel=oneel+ea
      et=0.d0
      do 7 kappa0=1,na
      kappa=llim+kappa0-1
      do 7 iro0=1,na
      iro=llim+iro0-1
      do 7 itau0=1,na
      itau=llim+itau0-1
      do 7 ieta0=1,na
      ieta=llim+ieta0-1
  7   et=et+g(itau0,ieta0,kappa0,iro0)*(b(kappa,itau)*b(iro,ieta)-
     $   0.5d0*b(kappa,ieta)*b(iro,itau)) 
       
      ea=ea+0.5d0*et
  
      return
      end
      subroutine pairs(ii,jj,h,ndeckl,llimi,ni,llimj,nj,sam,
     $   nnn,eabij,aa,p,z,m,natoms,gg,gi,gj,gt)
      implicit real*8(a-h,o-z) 
      parameter (maxat=100)
      parameter (ndeck=800)
      common /stv/ s(ndeck,ndeck),t(ndeck,ndeck),
     $             vv(ndeck,ndeck,maxat)
      dimension h(ndeckl,ndeckl),sam(nnn,nnn),
     $ p(ndeckl,ndeckl),aa(m,m,natoms), 
     $ z(m,m,natoms),a(ndeck,ndeck),b(ndeck,ndeck)
      dimension gg(nnn,nnn,nnn,nnn),gi(ni,ni,ni,ni),gj(nj,nj,nj,nj)          
      dimension gt(nnn,nnn,nnn,nnn) 
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /oneel/oneel,bsse
      common /nat/ idum1,nbasis,idum2(5)
      common iop(45)
c
C  Statement function to form combination with the exchange part:

      pp(i,j,k,l)=p(i,j)*p(k,l)-0.5d0*p(i,l)*p(k,j)
      bb(i,j,k,l)=b(i,j)*b(k,l)-0.5d0*b(i,l)*b(k,j)
c
c
      do 7171 i=1,nnn
      do 7171 j=1,nnn
      do 7171 k=1,nnn
      do 7171 l=1,nnn
 7171   gg(l,k,j,i)=0.d0
      call shellab(ii,jj,nbasis,natoms)
      if(iop(7).ne.0)call unconab(ii,jj)
      call invert2(s,ndeckl,sam,llimi,ni,llimj,nj,nnn)
       
   61 format(8f10.7)  
       do 11 i=1,m
       do 11 j=1,m
       b(i,j)=0.d0
  11   a(j,i)=0.d0

      iulimi=llimi+ni-1
      iulimj=llimj+nj-1

      ishift=llimi-1
      jshift=llimj-1-ni
      jshift0=llimj-1
       

      do 12 lambda=1,m
      do 12 mu0=1,ni
      mu=llimi+mu0-1
      x=0.d0
      do 13 isigm0=1,ni 
      isigm=isigm0+llimi-1
  13    x=x+s(lambda,isigm)*sam(isigm0,mu0)
      do 14 isigm0=1,nj
      isigm=isigm0+llimj-1
  14   x=x+s(lambda,isigm)*sam(isigm0+ni,mu0)
  12  a(lambda,mu)=x
      do 22 lambda=1,m
      do 22 mu0=1,nj
      mu=llimj+mu0-1
      x=0.d0
      do 23 isigm0=1,ni 
      isigm=isigm0+llimi-1
  23    x=x+s(lambda,isigm)*sam(isigm0,mu0+ni)
      do 24 isigm0=1,nj 
      isigm=isigm0+llimj-1
  24   x=x+s(lambda,isigm)*sam(isigm0+ni,mu0+ni)
  22  a(lambda,mu)=x

      do 32 mu=llimi,iulimi
      do 33 nu=llimi,iulimi
      x=0.d0
      do 34 igam=1,m
  34  x=x+p(mu,igam)*A(igam,nu)
  33  b(mu,nu)=x

      do 35 nu=llimj,iulimj
      x=0.d0
      do 36 igam=1,m
  36  x=x+p(mu,igam)*A(igam,nu)
  35  b(mu,nu)=x
  32  continue

 
      do 42 mu=llimj,iulimj
      do 43 nu=llimi,iulimi
      x=0.d0
      do 44 igam=1,m
  44  x=x+p(mu,igam)*A(igam,nu)
  43  b(mu,nu)=x

      do 45 nu=llimj,iulimj
      x=0.d0
      do 46 igam=1,m
  46  x=x+p(mu,igam)*A(igam,nu)
  45  b(mu,nu)=x
  42  continue
      
      eabij=zn(ii)*zn(jj)/dsqrt((coord(1,ii)-coord(1,jj))**2+
     $(coord(2,ii)-coord(2,jj))**2+(coord(3,ii)-coord(3,jj))**2)
      
      do 1 nu=llimi,iulimi
      do 1 mu=llimj,iulimj
       
      x=t(mu,nu)+z(mu,nu,ii) 
      y=t(mu,nu)+z(mu,nu,jj) 


      do 2 itau=llimi,iulimi
   2  x=x-aa(mu,itau,ii)*(t(itau,nu)+z(itau,nu,ii))

      do 3 itau=llimj,iulimj
   3  y=y-aa(nu,itau,jj)*(t(itau,mu)+z(itau,mu,jj))
      f=p(nu,mu)*(x+y)
      bsse=bsse+f
      oneel=oneel+f
   1  eabij=eabij+f  

      x=0.d0
      do 50 itau=llimi,iulimi
      do 51 mu=llimi,iulimi
 51   x=x+b(mu,itau)*z(itau,mu,jj)
      do 52 mu=llimj,iulimj
 52   x=x+b(mu,itau)*z(itau,mu,ii)
 50   continue 


      do 60 itau=llimj,iulimj
      do 64 mu=llimi,iulimi
 64   x=x+b(mu,itau)*z(itau,mu,jj)
      do 62 mu=llimj,iulimj
 62   x=x+b(mu,itau)*z(itau,mu,ii)
 60   continue 

      eabij=eabij+x
      oneel=oneel+x

      x=0.d0

      do 99 i=1,m
      do 99 j=1,m
   99 a(i,j)=aa(i,j,ii)

      do 100 kappa=llimi,iulimi
      kappa0=kappa-ishift
      do 100 iro=llimi,iulimi
      iro0=iro-ishift
      do 100 nu=llimj,iulimj
      nu0=nu-jshift
      do 100 itau=llimi,iulimi
      itau0=itau-ishift

      xx=0.d0
      do 128 ieta=llimi,iulimi
      ieta0=ieta-ishift
 128  xx=xx+a(nu,ieta)*gi(itau0,ieta0,kappa0,iro0)

 100  gt(itau0,nu0,kappa0,iro0)=xx

      do 400 kappa=llimi,iulimi
      kappa0=kappa-ishift
      do 400 iro=llimi,iulimi
      iro0=iro-ishift
      do 400 nu=llimi,iulimi
      nu0=nu-ishift
      do 400 itau=llimi,iulimi
      itau0=itau-ishift

      xx=0.d0
      do 428 ieta=llimi,iulimi
      ieta0=ieta-ishift
 428  xx=xx+a(nu,ieta)*gi(itau0,ieta0,kappa0,iro0)

 400  gt(itau0,nu0,kappa0,iro0)=xx


      do 101 kappa=llimi,iulimi
      kappa0=kappa-ishift
      do 101 iro=llimi,iulimi
      iro0=iro-ishift


      do 102 igam=llimi,iulimi
      igam0=igam-ishift
      do 102 nu=llimj,iulimj
      nu0=nu-jshift
          
      y=gg(igam0,nu0,kappa0,iro0)
      
      do 103 itau=llimi,iulimi
      itau0=itau-ishift
      y=y-a(igam,itau)*gt(itau0,nu0,kappa0,iro0)
  103 continue

      x=x+y*pp(kappa,igam,iro,nu)
  102 continue

      do 111 igam=llimj,iulimj
      igam0=igam-jshift
      do 111 nu=llimi,iulimi
      nu0=nu-ishift
          
      y=gg(igam0,nu0,kappa0,iro0)

      do 112 itau=llimi,iulimi
      itau0=itau-ishift
      y=y-a(igam,itau)*gt(itau0,nu0,kappa0,iro0)
  112 continue

      x=x+y*pp(kappa,igam,iro,nu)
  111 continue


      do 121 igam=llimj,iulimj
      igam0=igam-jshift
      do 121 nu=llimj,iulimj
      nu0=nu-jshift
          
      y=gg(igam0,nu0,kappa0,iro0)

      do 122 itau=llimi,iulimi
      itau0=itau-ishift
      y=y-a(igam,itau)*gt(itau0,nu0,kappa0,iro0)
  122 continue

      x=x+y*pp(kappa,igam,iro,nu)
  121 continue

  101 continue


      do 199 i=1,m
      do 199 j=1,m
  199 a(i,j)=aa(i,j,jj)


      do 600 kappa=llimj,iulimj
      kappa0=kappa-jshift
      kappa1=kappa-jshift0
      do 600 iro=llimj,iulimj
      iro0=iro-jshift
      iro1=iro-jshift0
      do 600 nu=llimi,iulimi
      nu0=nu-ishift
      do 600 itau=llimj,iulimj
      itau0=itau-jshift0

      xx=0.d0
      do 628 ieta=llimj,iulimj
      ieta0=ieta-jshift0
 628  xx=xx+a(nu,ieta)*gj(itau0,ieta0,kappa1,iro1)

 600  gt(itau0,nu0,kappa1,iro1)=xx

      do 700 kappa=llimj,iulimj
      kappa0=kappa-jshift
      kappa1=kappa-jshift0
      do 700 iro=llimj,iulimj
      iro0=iro-jshift
      iro1=iro-jshift0
      do 700 nu=llimj,iulimj
      nu0=nu-jshift
      do 700 itau=llimj,iulimj
      itau0=itau-jshift0

      xx=0.d0
      do 728 ieta=llimj,iulimj
      ieta0=ieta-jshift0
 728  xx=xx+a(nu,ieta)*gj(itau0,ieta0,kappa1,iro1)

 700  gt(itau0,nu0,kappa1,iro1)=xx


      do 200 kappa=llimj,iulimj
      kappa0=kappa-jshift
      do 200 iro=llimj,iulimj
      iro0=iro-jshift


      do 201 igam=llimj,iulimj
      igam0=igam-jshift
      do 201 nu=llimi,iulimi
      nu0=nu-ishift
          
      y=gg(igam0,nu0,kappa0,iro0)

      kappa1=kappa-jshift0
      iro1=iro-jshift0

      do 202 itau=llimj,iulimj
      itau0=itau-jshift0
      y=y-a(igam,itau)*gt(itau0,nu0,kappa1,iro1)
  202 continue

      x=x+y*pp(kappa,igam,iro,nu)
  201 continue


      do 211 igam=llimi,iulimi
      igam0=igam-ishift
      do 211 nu=llimj,iulimj
      nu0=nu-jshift
          
      y=gg(igam0,nu0,kappa0,iro0)

      do 212 itau=llimj,iulimj
      itau0=itau-jshift0
      y=y-a(igam,itau)*gt(itau0,nu0,kappa1,iro1)
  212 continue

      x=x+y*pp(kappa,igam,iro,nu)
  211 continue



      do 221 igam=llimi,iulimi
      igam0=igam-ishift
      do 221 nu=llimi,iulimi
      nu0=nu-ishift
          
      y=gg(igam0,nu0,kappa0,iro0)

      do 222 itau=llimj,iulimj
      itau0=itau-jshift0
      y=y-a(igam,itau)*gt(itau0,nu0,kappa1,iro1)
  222 continue

      x=x+y*pp(kappa,igam,iro,nu)
  221 continue

  200 continue

      eabij=eabij+0.5d0*x

      x=0.d0

      do 300 kappa=llimi,iulimi
      kappa0=kappa-ishift
      do 300 iro=llimj,iulimj
      iro0=iro-jshift
      
      do 310 itau=llimi,iulimi
      itau0=itau-ishift
      do 310 ieta=llimi,iulimi
      ieta0=ieta-ishift
  310 x=x+bb(kappa,itau,iro,ieta)*gg(kappa0,iro0,itau0,ieta0)  

     
      do 320 itau=llimi,iulimi
      itau0=itau-ishift
      do 320 ieta=llimj,iulimj
      ieta0=ieta-jshift
  320 x=x+bb(kappa,itau,iro,ieta)*gg(kappa0,iro0,itau0,ieta0)  


      do 330 itau=llimj,iulimj
      itau0=itau-jshift
      do 330 ieta=llimi,iulimi
      ieta0=ieta-ishift
  330 x=x+bb(kappa,itau,iro,ieta)*gg(kappa0,iro0,itau0,ieta0)  


      do 340 itau=llimj,iulimj
      itau0=itau-jshift
      do 340 ieta=llimj,iulimj
      ieta0=ieta-jshift
  340 x=x+bb(kappa,itau,iro,ieta)*gg(kappa0,iro0,itau0,ieta0)  

  300 continue
      eabij=eabij+x

      return
      end


      subroutine invert1(sao,ndeckl,s,llim,m)        
      implicit real*8(a-h,o-z)
      dimension sao(ndeckl,ndeckl),s(m,m)

      do 1 i=1,m
      ieltol=llim+i-1 
      do 1 j=1,m
      jeltol=llim+j-1 
   1  s(j,i)=sao(jeltol,ieltol)
      
  61  format(1x,7f10.7)
      call inv1(s,m)
      return
      end



      subroutine invert2(sao,ndeckl,s,llima,ma,llimb,mb,m)
      implicit real*8(a-h,o-z)
      dimension sao(ndeckl,ndeckl),s(m,m)
 
      data isor/0/
      isor=isor+1

 
      do 1 i=1,ma
      ieltol=llima+i-1 
      do 1 j=1,ma
      jeltol=llima+j-1 
   1  s(j,i)=sao(jeltol,ieltol)
      do 2 i=1,mb
      ieltol=llimb+i-1 
      do 2 j=1,mb
      jeltol=llimb+j-1 
   2  s(ma+j,ma+i)=sao(jeltol,ieltol)
      do 3 i=1,mb
      ieltol=llimb+i-1 
      do 3 j=1,ma
      jeltol=llima+j-1 
   3  s(j,ma+i)=sao(jeltol,ieltol)
      do 4 i=1,ma
      ieltol=llima+i-1 
      do 4 j=1,mb
      jeltol=llimb+j-1 
   4  s(ma+j,i)=sao(jeltol,ieltol)
  61  format(1x,7f10.7)
      call inv1(s,m)
      return
      end
      subroutine pm(c,nocc,m,p,ndeckl)  
      implicit real*8(a-h,o-z)
      dimension c(ndeckl,ndeckl),p(ndeckl,ndeckl)
c      do 1 i=1,m
c      do 1 j=1,m
c      x=0.d0
c      do 2 k=1,nocc
c 2     x=x+c(i,k)*c(j,k)
c 1    p(i,j)=2.d0*x

c 61  format(1x,8f9.7)
    
       call readp(p,m,ndeckl)

       return
       end
      
      subroutine readp(P,m,ndeckl)
            implicit real*8(a-h,o-z)
      dimension P(ndeckl,ndeckl),ipbe(42) 

      open (18,file='Cryst.Pmatr')
          rewind 18
         read(18,61,end=1100)((p(i,j),i=1,m),j=1,m)
c        write(*,61)((p(i,j),i=1,28),j=1,28)
c        write(*,611)i,(p(i,j),j=1,28)
 61     format(5f16.12)
 611     format(i4,28f6.3)
  2      continue
 100  do i=1,m-1
      do j=i+1,m
      if(dabs(p(i,j)-p(j,i)).gt.1.d-7)goto 1103
      enddo
      enddo
        return
 1100 print *, 'Error: no density matrix found or it is corrupt: STOP'
      stop 5973
 1103 print *,'  Indices:',i,j
      print *, '  Matrix elements:',p(i,j),p(j,i)
      print *,'  Error: non-Hermitian P-matrix: STOP'
      stop 5976
      return
         end
   
c     implicit real*8(a-h,o-z)
c     dimension P(ndeckl,ndeckl),ipbe(42) 
c     open (18,file='Cryst.Pmatr')
c     print *, ' readp-ben m=',m
c     llim=1
c     iupl=10
c     rewind 16
c 1   read(16,61,end=1000)ipbe
c61   format(50A4)
c     write(18,61)ipbe
c     goto 1 
c1000 rewind 18    
c     do 2 i=1,m 
c     read(18,61)((p(i,j),i=1,m),j=1,m)
c     write(*,611)i,(p(i,j),j=1,m)
c  2  continue  
c     
c61   format(5f16.12)
c611  format(i4,28f6.3)
c     if(.not.(ipbe(1).eq.' DEN'.and.ipbe(2).eq.'SITY'))goto 2
c     print 61,ipbe
c 3   read(18,61,end=1101)ipbe
c     if(ipbe(1).eq.'    '.and.ipbe(2).eq.'    ')goto 3
c     backspace 18
c     iup=imin1(iupl,m)
c     if(llim.gt.m) goto 100
c     ilo=llim
c     print *,ilo,iup
c     do i=1,m
c     read(18,*) ii,(p(i,j),j=ilo,iup)
c     if(ii.ne.i)goto 1102
c     enddo  
c     
c     llim=llim+10
c     iupl=iupl+10
c     goto 3
c100  do i=1,m-1
c     do j=i+1,m
c     if(dabs(p(i,j)-p(j,i)).gt.1.d-7)goto 1103
c     enddo
c     enddo
c     return 
c1100 print *, 'Error: no density matrix found or it is corrupt: STOP'
c     stop 5973
c1101 print *, 'Error: the density matrix iis corrupt: STOP'
c     stop 5974
c1102 print *, 'Error: inconsistent data structure: STOP'
c     stop 5975
c1103 print *,'  Indices:',i,j
c     print *, '  Matrix elements:',p(i,j),p(j,i)
c     print *,'  Error: non-Hermitian P-matrix: STOP'
c     stop 5976
c     return
c     end

    
     


   
      SUBROUTINE INV1(S,M)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (NMAX=800)
      DIMENSION S(m,m),S23(NMAX),SM(nmax,nmax)
C INVERSION OF A REAL SYMMETRIC MATRIX BY DIAGONALIZATION
C  DIAGONALIZE S, BUILD S**(-1) - and put it in S !!!!
      CALL SDIAGI(S,M,S23)
      DO 4 I=1,M
      IF(S23(I).LE.1.D-25) STOP 1925
  4   S23(I)=1.D0/S23(I)
      DO 5 I=1,M
      DO 5 J=1,M
      Y=0.D0
      DO 6 K=1,M
  6   Y=Y+S(I,K)*S23(K)*S(J,K)
      SM(I,J)=Y
  5   SM(J,I)=Y
      do 7 j=1,m
      do 7 i=1,m
  7   s(i,j)=sm(i,j)
      RETURN
      END
      SUBROUTINE SDIAGI(X,n,D)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (NMAX=800)
C DIAGONALIZATION OF THE REAL SYMMETRIC MATRIX X. IN D THE EIGENVALUES.
      DIMENSION D(n)
      DIMENSION E(NMAX),X(n,n)
      EPS=5.D-15
      TOL=5.D-40
      IF(N.EQ.1) GOTO 400
    5 DO 150 NI=2,N
      II=N+2-NI
      DO 150 I=II,II
      L=I-2
      H=0.0D0
      G=X(I,I-1)
      IF(L)140,140,20
   20 DO 30 K=1,L
   30 H=H+X(I,K)*X(I,K)
      S=H+G*G
      IF(S.GE.TOL) GOTO 50
   40 H=0.0D0
      GO TO 140
   50 IF(H)140,140,60
   60 L=L+1
      F=G
      G=DSQRT(S)
      IF(F)75,75,70
   70 G=-G
   75 H=S-F*G
      X(I,I-1)=F-G
      F=0.0D0
      DO 110 J=1,L
      X(J,I)=X(I,J)/H
      S=0.0D0
      DO 80 K=1,J
   80 S=S+X(J,K)*X(I,K)
      J1=J+1
      IF(J1.GT.L) GOTO 100
   85 DO 90 K=J1,L
   90 S=S+X(K,J)*X(I,K)
  100 E(J)=S/H
  110 F=F+S*X(J,I)
      F=F/(H+H)
      DO 120 J=1,L
  120 E(J)=E(J)-F*X(I,J)
      DO 130 J=1,L
      F=X(I,J)
      S=E(J)
      DO 130 K=1,J
  130 X(J,K)=X(J,K)-F*E(K)-X(I,K)*S
  140 D(I)=H
  150 E(I-1)=G
  160 D(1)=X(1,1)
      X(1,1)=1.0D0
      DO 220 I=2,N
      L=I-1
      IF(D(I))200,200,170
  170 DO 190 J=1,L
      S=0.0D0
      DO 180 K=1,L
  180 S=S+X(I,K)*X(K,J)
      DO 190 K=1,L
  190 X(K,J)=X(K,J)-S*X(K,I)
  200 D(I)=X(I,I)
      X(I,I)=1.0D0
  210 DO 220 J=1,L
      X(I,J)=0.0D0
  220 X(J,I)=0.0D0
      B=0.0D0
      F=0.0D0
      E(N)=0.0D0
      DO 340 L=1,N
      H=EPS*(DABS(D(L))+DABS(E(L)))
      IF(H.GT.B) B=H
  235 DO 240 J=L,N
      IF(DABS(E(J)).LE.B) GO TO 250
  240 CONTINUE
  250 IF(J.EQ.L) GOTO 340
  260 P=(D(L+1)-D(L))*.50D0/E(L)
      R=DSQRT(P*P+1.0D0)
      IF(P)270,280,280
  270 P=P-R
      GO TO 290
  280 P=P+R
  290 H=D(L)-E(L)/P
      DO 300 I=L,N
  300 D(I)=D(I)-H
      F=F+H
      P=D(J)
      C=1.0D0
      S=0.0D0
      J1=J-1
      DO 330 NI=L,J1
      II=L+J1-NI
      DO 330 I=II,II
      G=C*E(I)
      G=C*E(I)
      H=C*P
      IF(DABS(P).LT.DABS(E(I))) GO TO 310
  305 C=E(I)/P
      R=DSQRT(C*C+1.0D0)
      E(I+1)=S*P*R
      S=C/R
      C=1.0D0/R
      GO TO 320
  310 C=P/E(I)
      R=DSQRT(C*C+1.0D0)
      E(I+1)=S*E(I)*R
      S=1.0D0/R
      C=C/R
  320 P=C*D(I)-S*G
      D(I+1)=H+S*(C*G+S*D(I))
      DO 330 K=1,N
      H=X(K,I+1)
      X(K,I+1)=X(K,I)*S+H*C
  330 X(K,I)=X(K,I)*C-H*S
      E(L)=S*P
      D(L)=C*P
      IF(DABS(E(L)).GT.B) GO TO 260
  340 D(L)=D(L)+F
      NI=N-1
  350 DO 380 I=1,NI
      K=I
      P=D(I)
      J1=I+1
      DO 360 J=J1,N
      IF(D(J).LE.P) GOTO 360
  355 K=J
      P=D(J)
  360 CONTINUE
      IF(K.EQ.I) GOTO 380
  365 D(K)=D(I)
      D(I)=P
      DO 370 J=1,N
      P=X(J,I)
      X(J,I)=X(J,K)
  370 X(J,K)=P
  380 CONTINUE
  390 GO TO 410
  400 D(1)=X(1,1)
      X(1,1)=1.0D0
  410 RETURN
      END
      subroutine inpint(g,mgmax,natoms,llim,iulim)
      IMPLICIT REAL*8 (A-H,O-Z)
      
      parameter (maxat=100)
      parameter (nmax=800)
      parameter (n128=800)
      dimension g(mgmax)
      dimension llim(n128),iulim(n128)
      common /pointer/ipoint(maxat),ijpoint(maxat,maxat),na(maxat)     
      common /hold/ihold(nmax),illim(n128)
      common /nat/ nat,igr,ifg,idum3(4)
      common iop(45)
c     print *,'entering inpint'
     
      do i=1,natoms
      do mu=llim(i),iulim(i)
      ihold(mu)=i
      enddo
      enddo
   61 format(20i2)
     
c      print *,'inpi 1'       
 
       do i=1,natoms
       illim(i)=llim(i)
       enddo
c      print *,'inpi 2'       

      call gamgen
c      print *,'inpi 3'       
       do i=1,Natoms
      call shellat(i,igr,natoms)
      if(iop(7).ne.0)call unconat(i)
      enddo
c     print *,'leaving inpint'
        return      
      end

      subroutine bepack1(gf,ii,jj,kk,ll,llim,g,mi,ihold)
      implicit real*8(a-h,o-z)
      parameter (maxat=100,maxg=800)
      dimension llim(maxg),g(mi,mi,mi,mi),ihold(maxg)
c     print *,'entering bepack1'
      ih=ihold(ii)
      ishift=llim(ih)-1
      i=ii-ishift
      j=jj-ishift
      k=kk-ishift
      l=ll-ishift
c     print *,ih,ishift,i,j,k,l,mi
      g(i,j,k,l)=gf
      g(j,i,l,k)=gf
      g(k,l,i,j)=gf
      g(l,k,j,i)=gf
      g(i,l,k,j)=gf
      g(l,i,j,k)=gf
      g(k,j,i,l)=gf
      g(j,k,l,i)=gf
c     print *,'leaving bepack1'
      return
      end
      subroutine bepack2(gf,ii,jj,kk,ll,llim,g,mi,ihold,na)
      implicit real*8(a-h,o-z)
      parameter (maxat=100,maxg=800)
      dimension llim(maxg),g(mi,mi,mi,mi),ihold(maxg)
      dimension na(maxat)
      
      ih=ihold(ii)
      jh=ihold(jj)
      kh=ihold(kk)
      lh=ihold(ll)
      iat=min0(ih,jh,kh,lh)
      jat=max0(ih,jh,kh,lh)
      ni=na(iat)

      ishift=llim(ih)-1
      if(ih.eq.jat)ishift=ishift-ni

      jshift=llim(jh)-1
      if(jh.eq.jat)jshift=jshift-ni

      kshift=llim(kh)-1
      if(kh.eq.jat)kshift=kshift-ni

      lshift=llim(lh)-1
      if(lh.eq.jat)lshift=lshift-ni
     
      i=ii-ishift
      j=jj-jshift
      k=kk-kshift
      l=ll-lshift
      g(i,j,k,l)=gf
      g(j,i,l,k)=gf
      g(k,l,i,j)=gf
      g(l,k,j,i)=gf
      g(i,l,k,j)=gf
      g(l,i,j,k)=gf
      g(k,j,i,l)=gf
      g(j,k,l,i)=gf
      return
      end

      SUBROUTINE MPRINT(H,N,ndim)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION H(NDIM,NDIM)
      parameter (maxat=100)
      common /ia/ia(maxat),kkk

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ ' Fl ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
    
      K=8 
   65 FORMAT(1H0,40X,A4/)
      NMIN=1
      NMAX=MIN0(N,K)
   62 FORMAT(1X,I3,A4,8F9.4)
   1  PRINT 61, (I, mend(ia(i)),I=NMIN,NMAX)
   61 FORMAT(10X,8(1X,I3,A4,1X))
      PRINT 64
   64 FORMAT(1X)
      DO 2 I=1,N
      PRINT 62,I,mend(ia(i)),(H(I,J),J=NMIN,NMAX)
   2  CONTINUE
      NMIN=NMIN+8
      K=K+8
      NMAX=MIN0(N,K)
      IF(NMAX.GE.NMIN) GOTO 71
      RETURN
   71 PRINT 63
   63 FORMAT(1X///)
      GO TO 1
      END

      SUBROUTINE MPRINTb(H,N,ndim)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION H(NDIM,NDIM)
      parameter (maxat=100)
      common /ia/ia(maxat),kkk
      common /range/llrange,iulrange,ncell,natc

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ ' Fl ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
      ishift=(ncell/2)*natc   
      K=llrange+7 
   65 FORMAT(1H0,40X,A4/)
      NMIN=llrange
      NMAX=MIN0(iulrange,K)
   62 FORMAT(2I3,A4,8F9.4)
   1  PRINT 61, (I-ishift, mend(ia(i)),I=NMIN,NMAX)
   61 FORMAT(' Ref.cell:  ',8(1X,I3,A4,1X))
      PRINT 64
      print *,'Cell,at.'
   64 FORMAT(1X,79(1h-))
      DO 2 I=1,N
      icell=(i-1)/natc-ncell/2
      jpr=mod(i-1,natc)+1
      jshift=icell*natc
      PRINT 62,icell,jpr,mend(ia(i)),(H(I,J),J=NMIN,NMAX)
      if(mod(i,natc).eq.0)print *,'  '
   2  CONTINUE
      NMIN=NMIN+8
      K=K+8
      NMAX=MIN0(iulrange,K)
      IF(NMAX.GE.NMIN) GOTO 71
      RETURN
   71 PRINT 63
   63 FORMAT(1X///)
      GO TO 1
      END

      subroutine kiir
      implicit real*8(a-h,o-z)

      print *,'                          CRYSTAL VERSION'
      print *,' ' 
      print *, '                  I. Mayer,  Heidelberg, Ocober 2000.'        
      print *,' ' 
      print *,' ' 
   
      print 6670 



      write(*,6670)
      write(*,6661)
 6661 format(/20x,'Program APOST, Version 1.0')
      write(*,6662)
 6662 format(20x,27(1h-),/)
      write(*,6663)
      write(*,6660)
 6663 format(3x,'Calculating:')
 6660 format(3x,'------------',/)
      write(*,6664)
 6664 format(5x,2hA),' Bond orders and valences (I. Mayer, Chem. Phys.'
     $,'Lett. 97, 270, 1983....)',/)
      write(*,6665)
 6665 format(5x,2hB),' Chemical Energy Component Analysis (I. Mayer,'
     $,' to be published)',/)
      write(*,6666)
 6666 format(3x,'for a wave function obtained in a Gaussian ',
     $ 'calculation (G92, G94, G98, ...?)',//)
      write(*,6667)
      write(*,6668)
      write(*,6669)
 6667 format(2x,'Cite this program as:')
 6668 format(2x,'---------------------')
 6669 format(1x,'I. Mayer and A. Hamza, Program "APOST", Version 1.0'
     $ ,' (Institute of Chemistry,'/1x,'Chemical Research Center,'
     $ ,' Hungarian Academy of Sciences), Budapest, April 2000.'/)
 6670 format(1x,79(1h-))
      write(*,6670)
      return
      end
