
c     
C
c           CRYSTALL VERSION, I. Mayer, Heidelberg, October 2000
C
c
c         A sub-version calculating bond orders only - to be used
c         for large systems for which full calculations cannot
c         be performed.
c
C------------------------------------------------------------------------------
c
c
c
c
c
c                        Program APOST, Version 1.0
c                        ---------------------------
c
c                           I. Mayer and A. Hamza
c            Institute of Chemistry,  Chemical Research Center,
c    Hungarian Academy of Sciences, H-1515 Budapest, P.O.Box 17, Hungary
c
c          e-mails: hamza@occam.chemres.hu, mayer@cric.chemres.hu
c
c ------------------------------------------------------------------------
c
c   This program performs *a posteriori*
c
c       A) Bond order and valence analysis and
c
c       B) "Chemical Energy Component Analysis" (CECA)
c
c  of the ab initio SCF wave functions (RHF or UHF) produced by the
c  widely used "Gaussian" system (G92, G94, G98).
c
c
c  Bond order and valence indices represent LCAO counterparts of the
c  respective classical chemical parameters (I. Mayer, Chem. Phys. Lett.
c  97, 270 1983...) while "CECA" is a new tool permitting to express the
c  molecular energy -- approximately but to a good accuracy -- as a sum of
c  one- and diatomic energy components, the computation of which requires
c  one and two-center integrals only (I. Mayer, to be published); three-
c  and four-center effects are compressed to one- and two-center ones by
c  performing appropriate projections.
c
c
c

      implicit real*8(a-h,o-z)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
       
      common /range/llrange,iulrange,ncell,natc  
      
      parameter (nmax=1000)
      parameter (maxat=200)
      parameter (maxat1=201)
      parameter (maxp=4000)
      parameter (ndeckl=882)
c     parameter (mmax= 115 000 000)
c     parameter (mgmax=1 000 000)
      common /lim/ llim(nmax),iulim(nmax)
c     common /large/aa(mmax),gg(mgmax),z(mmax),gt(mgmax)  
      dimension sam(ndeckl,ndeckl)
      dimension h(ndeckl,ndeckl)
      common /c/c(ndeckl,ndeckl),p(ndeckl,ndeckl)
      common /pointer/ipoint(maxat),ijpoint(maxat,maxat),na(maxat)     
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(ndeckl,ndeckl)
C                   ,t(ndeckl,ndeckl) 
c    $         ,    vv(ndeckl,ndeckl,maxat)
      common /ia/iznuc(maxat),kop

      common /map/imap(maxp)
c     data bohr/0.52917715D+00/
c     data bohr/0.52917706D+00/

      call kiir
c     print *,' start-ot hivja'
      call start
c     print *,' start utan'
 
      oneel=0.d0
      bsse=0.d0

      m=igr

      call getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      if(nat.ne.natoms) stop 7584
      if(m.ne.nbas) stop 7585
      nlength=natoms*nbas**2           
c     if(nlength.gt.mmax)then
c     write(*,*) nlength,' WORDS ARE REQUIRED FOR THE MATRIX Z/A'
c     write(*,*) ' AVAILABLE ONLY:', mmax, '--  STOP'
c     stop
c     endif

      ng=0
      do i=1,natoms
      ipoint(i)=ng+1
      ng=ng+na(i)**4
      enddo
      ijpoint(1,2)=ng+1
      maxx=0
      do i=1,natoms-1
      do j=i+1,natoms
      maxx=max0(maxx,na(i)+na(j))
      enddo
      enddo
c     ng=ng+maxx**4
c     if(ng.gt.mgmax)then
c     write(*,*) ng,' WORDS ARE REQUIRED FOR THE MATRIX G'
c     write(*,*) ' AVAILABLE ONLY:', mgmax, '--  STOP'
c     stop
c     endif

      
      call getcore(z,ndeckl,nbas,natoms,h)

      if(iuhf.eq.1) then
      Print *, ' This version works for RHF case only. STOP.'
c     call enpo(na,ipoint,ijpoint) 
      stop
      endif

      call pm(c,nocc,nbas,p,ndeckl)
      call border(P,sam,S,llim,iulim,natoms,nbas)
      stop
      end 

      subroutine getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      implicit real*8(a-h,o-z)
      parameter (n128=1000)
      dimension llim(n128),iulim(n128),na(maxat)
      NATOMS=0
      NBAS=0
      DO 3 I=1,n128
      IF(iulim(I).GT.0) NATOMS=I
  3   NBAS=iulim(natoms)
      print *, natoms,maxat
       if(natoms.gt.maxat)then
      write(*,*)'   TOO MANY ATOMS, STOP'
      stop
       endif
      if(natoms.eq.1) then
      write(*,*)'  ONLY ONE ATOM'
      stop  
      endif
      nnn=0
      do 4 i=1,natoms
      na(i)=iulim(i)-llim(i)+1
  4   nnn=nnn+na(i)
      if(nnn.ne.nbas)stop 1212
      nnab=(natoms*(natoms-1))/2
      if(nnab*2.ne.natoms*(natoms-1))stop 1213

      print *,'   '
      write(*,*)natoms,' ATOMS, ',nnab,' ATOMIC PAIRS'
      
      end

      subroutine getcore(z,ndeckl,nbas,natoms,h)
      implicit real*8(a-h,o-z)
      parameter (maxat=200)
      parameter (ndeck=882) 
      parameter (maxp=4000)
      common /stv/ s(ndeck,ndeck)
c   ,t(ndeck,ndeck) 
c    $   ,vv(ndeck,ndeck,maxat)   
      dimension h(ndeckl,ndeckl)
c    $  ,z(nbas,nbas,natoms)
      common /map/imap(maxp)
      m=nbas

c     do 1 iat=1,natoms
c      do 11 j=1,m
c      jj=imap(j)
c      do 11 i=1,m
c       ii=imap(i)
c  11  z(jj,ii,iat)=vv(j,i,iat)
c  1  continue
c      do 21 j=1,m
c      jj=imap(j)
c      do 21 i=1,m
c       ii=imap(i)
c  21  h(jj,ii)=t(j,i)
c      do 31 i=1,m
c      do 31 j=1,m
c  31  t(j,i)=h(j,i)
       
       do 121 j=1,m
       jj=imap(j)
       do 121 i=1,m
        ii=imap(i)
  121  h(jj,ii)=s(j,i)
       do 131 i=1,m
       do 131 j=1,m
  131  s(j,i)=h(j,i)
       
  61  format(1x,8f9.6)

       return
       end

      subroutine pm(c,nocc,m,p,ndeckl)  
      implicit real*8(a-h,o-z)
      dimension c(ndeckl,ndeckl),p(ndeckl,ndeckl)
c      do 1 i=1,m
c      do 1 j=1,m
c      x=0.d0
c      do 2 k=1,nocc
c 2     x=x+c(i,k)*c(j,k)
c 1    p(i,j)=2.d0*x

c 61  format(1x,8f9.7)
    
       call readp(p,m,ndeckl)

       return
       end
      
      subroutine readp(P,m,ndeckl)
            implicit real*8(a-h,o-z)
      dimension P(ndeckl,ndeckl),ipbe(42) 

      open (18,file='Cryst.Pmatr')
          rewind 18
         read(18,61,end=1100)((p(i,j),i=1,m),j=1,m)
c        write(*,61)((p(i,j),i=1,28),j=1,28)
c        write(*,611)i,(p(i,j),j=1,28)
 61     format(5f16.12)
 611     format(i4,28f6.3)
  2      continue
 100  do i=1,m-1
      do j=i+1,m
      if(dabs(p(i,j)-p(j,i)).gt.1.d-7)goto 1103
      enddo
      enddo
        return
 1100 print *, 'Error: no density matrix found or it is corrupt: STOP'
      stop 5973
 1103 print *,'  Indices:',i,j
      print *, '  Matrix elements:',p(i,j),p(j,i)
      print *,'  Error: non-Hermitian P-matrix: STOP'
      stop 5976
      return
         end
   
c     implicit real*8(a-h,o-z)
c     dimension P(ndeckl,ndeckl),ipbe(42) 
c     open (18,file='Cryst.Pmatr')
c     print *, ' readp-ben m=',m
c     llim=1
c     iupl=10
c     rewind 16
c 1   read(16,61,end=1000)ipbe
c61   format(50A4)
c     write(18,61)ipbe
c     goto 1 
c1000 rewind 18    
c     do 2 i=1,m 
c     read(18,61)((p(i,j),i=1,m),j=1,m)
c     write(*,611)i,(p(i,j),j=1,m)
c  2  continue  
c     
c61   format(5f16.12)
c611  format(i4,28f6.3)
c     if(.not.(ipbe(1).eq.' DEN'.and.ipbe(2).eq.'SITY'))goto 2
c     print 61,ipbe
c 3   read(18,61,end=1101)ipbe
c     if(ipbe(1).eq.'    '.and.ipbe(2).eq.'    ')goto 3
c     backspace 18
c     iup=imin1(iupl,m)
c     if(llim.gt.m) goto 100
c     ilo=llim
c     print *,ilo,iup
c     do i=1,m
c     read(18,*) ii,(p(i,j),j=ilo,iup)
c     if(ii.ne.i)goto 1102
c     enddo  
c     
c     llim=llim+10
c     iupl=iupl+10
c     goto 3
c100  do i=1,m-1
c     do j=i+1,m
c     if(dabs(p(i,j)-p(j,i)).gt.1.d-7)goto 1103
c     enddo
c     enddo
c     return 
c1100 print *, 'Error: no density matrix found or it is corrupt: STOP'
c     stop 5973
c1101 print *, 'Error: the density matrix iis corrupt: STOP'
c     stop 5974
c1102 print *, 'Error: inconsistent data structure: STOP'
c     stop 5975
c1103 print *,'  Indices:',i,j
c     print *, '  Matrix elements:',p(i,j),p(j,i)
c     print *,'  Error: non-Hermitian P-matrix: STOP'
c     stop 5976
c     return
c     end

    
     


      SUBROUTINE MPRINT(H,N,ndim)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION H(NDIM,NDIM)
      parameter (maxat=200)
      common /ia/ia(maxat),kkk

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ ' Fl ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
    
      K=8 
   65 FORMAT(1H0,40X,A4/)
      NMIN=1
      NMAX=MIN0(N,K)
   62 FORMAT(1X,I3,A4,8F9.4)
   1  PRINT 61, (I, mend(ia(i)),I=NMIN,NMAX)
   61 FORMAT(10X,8(1X,I3,A4,1X))
      PRINT 64
   64 FORMAT(1X)
      DO 2 I=1,N
      PRINT 62,I,mend(ia(i)),(H(I,J),J=NMIN,NMAX)
   2  CONTINUE
      NMIN=NMIN+8
      K=K+8
      NMAX=MIN0(N,K)
      IF(NMAX.GE.NMIN) GOTO 71
      RETURN
   71 PRINT 63
   63 FORMAT(1X///)
      GO TO 1
      END

      SUBROUTINE MPRINTb(H,N,ndim)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION H(NDIM,NDIM)
      parameter (maxat=200)
      common /ia/ia(maxat),kkk
      common /range/llrange,iulrange,ncell,natc

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ ' Fl ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
      ishift=(ncell/2)*natc   
      K=llrange+7 
   65 FORMAT(1H0,40X,A4/)
      NMIN=llrange
      NMAX=MIN0(iulrange,K)
   62 FORMAT(2I3,A4,8F9.4)
   1  PRINT 61, (I-ishift, mend(ia(i)),I=NMIN,NMAX)
   61 FORMAT(' Ref.cell:  ',8(1X,I3,A4,1X))
      PRINT 64
      print *,'Cell,at.'
   64 FORMAT(1X,79(1h-))
      DO 2 I=1,N
      icell=(i-1)/natc-ncell/2
      jpr=mod(i-1,natc)+1
      jshift=icell*natc
      PRINT 62,icell,jpr,mend(ia(i)),(H(I,J),J=NMIN,NMAX)
      if(mod(i,natc).eq.0)print *,'  '
   2  CONTINUE
      NMIN=NMIN+8
      K=K+8
      NMAX=MIN0(iulrange,K)
      IF(NMAX.GE.NMIN) GOTO 71
      RETURN
   71 PRINT 63
   63 FORMAT(1X///)
      GO TO 1
      END

      subroutine kiir
      implicit real*8(a-h,o-z)

      print *,'                      *** BOND ORDERS ONLY! *** ' 
      print *,' ' 
      print *,'                          CRYSTAL VERSION'
      print *,' ' 
      print *, '       I. Mayer,  Heidelberg, Ocober 2000/August 2003.'        
      print *,' ' 
      print *,' ' 
   
      print 6670 



      write(*,6670)
      write(*,6661)
 6661 format(/20x,'Program APOST, Version 1.0')
      write(*,6662)
 6662 format(20x,27(1h-),/)
      write(*,6663)
      write(*,6660)
 6663 format(3x,'Calculating:')
 6660 format(3x,'------------',/)
      write(*,6664)
 6664 format(5x,2hA),' Bond orders and valences (I. Mayer, Chem. Phys.'
     $,'Lett. 97, 270, 1983....)',/)
      write(*,6665)
 6665 format(5x,2hB),' Chemical Energy Component Analysis (I. Mayer,'
     $,' to be published)',/)
      write(*,6666)
 6666 format(3x,'for a wave function obtained in a Gaussian ',
     $ 'calculation (G92, G94, G98, ...?)',//)
      write(*,6667)
      write(*,6668)
      write(*,6669)
 6667 format(2x,'Cite this program as:')
 6668 format(2x,'---------------------')
 6669 format(1x,'I. Mayer and A. Hamza, Program "APOST", Version 1.0'
     $ ,' (Institute of Chemistry,'/1x,'Chemical Research Center,'
     $ ,' Hungarian Academy of Sciences), Budapest, April 2000.'/)
 6670 format(1x,79(1h-))
      write(*,6670)
      return
      end
      subroutine border(PA,PB,S,illim,iulim,natoms,nbasis)
      implicit real*8(a-h,o-z)
      parameter (maxat=200,ndeck=882)
      dimension pa(ndeck,ndeck),pb(ndeck,ndeck),rindex(maxat,maxat)
      dimension tindex(maxat),diag(maxat),illim(ndeck),iulim(ndeck)
      dimension pas(ndeck,ndeck),pbs(ndeck,ndeck),ps(ndeck,ndeck)
      dimension s(ndeck,ndeck) 
c     character*4 kiir1(4),kiir2(4) 
      dimension kiir1(4),kiir2(4) 
      EQUIVALENCE(PS(1,1),PAS(1,1))
       common /range/llrange,iulrange,ncell,natc
      common /ia/ia(maxat),kop
      integer uli,ulj 

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ ' Fl ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
       data kiir1/'  AT','OM  ','VALE','NCE '/
       data kiir2/' ATO','M   ','VALE','NCE '/
c
C
c
C  CALCULATING BOND-ORDER AND VALENCE INDICES ACCORDING TO
C  I. MAYER, CHEM.PHYS.LETT.97,270 (1983) and 117,396 (1985)
C  - see also TCA 67, 315 (1985), IJQC 29, 73,477 (1986)  
C
C
c
 666  FORMAT(1H1,5X,'CALCULATION OF BOND ORDER AND VALENCE INDICES ',
     $'ACCORDING TO: I.MAYER, CHEM.PHYS.LETT. 97,270 (1983)'//
     $' (MODIFIED ACCORDING TO I.MAYER, ibid. 117,396 (1985)'//)
      IF(kop.EQ.0) WRITE (*,62)
      IF(kop.NE.0) WRITE (*,63)
  62  FORMAT(1X,'CLOSED-SHELL SYSTEM'/)
  63  FORMAT(1X,'OPEN-SHELL SYSTEM'/)
      IF(kop.EQ.0) GOTO 22
      GO TO 222
C
C
C  TAKE MATRIX PRODUCT P*S
C
  22  DO 4 I=1,nbasis
      DO 4 J=1,nbasis
      X=0.0D0
      DO 105 K=1,nbasis
 105  X=X+PA(I,K)*S(K,J)
  4   PS(I,J)=X
c          i=73
c     do 1 j=7,154,11
c 1         print *,j,i,' ',pa(j,i),' ', s(j,i)
c          i=i+11
c          j=j+11
c          if(j.gt.nbasis) goto 777
c          goto 1
c777     continue  
      GO TO 444
C
C  OPEN SHELL CASE: TAKE MATRIX PRODUCTS PA*S, PB*S
C
 222  DO 441 I=1,nbasis
      DO 441 J=1,nbasis
      X=0.0D0
      Y=0.0D0
      DO 551 K=1,nbasis
      X=X+PA(I,K)*S(K,J)
  551 Y=Y+PB(I,K)*S(K,J)
      PBS(I,J)=Y
  441 PAS(I,J)=X
      GOTO 555
C  BOND-ORDER INDICES
C   JAV. DEFINICIO!!
C     NA1=NATOMS-1
 444  DO 6 I=1,NATOMS
      DO 6 J=I,NATOMS
      X=0.0D0
      LLI=ILLIM(I)
      ULI=IULIM(I)
      LLJ=ILLIM(J)
      ULJ=IULIM(J)
      DO 7 ILAM=LLI,ULI
      DO 7 IOM=LLJ,ULJ
  7   X=X+PS(ILAM,IOM)*PS(IOM,ILAM)
      rindex(I,J)=X
  6   rindex(J,I)=X
      DO 8 I=1,NATOMS
      DIAG(I)=rindex(I,I)
  8   rindex(I,I)=0.0D0
      GO TO 124
C
 555  DO 16 I=1,NATOMS
      DO 16 J=I,NATOMS
      X=0.0D0
      LLI=ILLIM(I)
      ULI=IULIM(I)
      LLJ=ILLIM(J)
      ULJ=IULIM(J)
      IF(I.EQ.J) GOTO 143
      DO 17 ILAM=LLI,ULI
      DO 17 IOM=LLJ,ULJ
  17   X=X+PAS(ILAM,IOM)*PAS(IOM,ILAM)+PBS(ILAM,IOM)*PBS(IOM,ILAM)
      X=X+X
      GOTO 147
 143  DO 756 ILAM=LLI,ULI
      DO 756 IOM=LLI,ULI
 756  X=X+(PAS(ILAM,IOM)+PBS(ILAM,IOM))*(PAS(IOM,ILAM)
     $   +PBS(IOM,ILAM))
 147  rindex(I,J)=X
  16  rindex(J,I)=X
      DO 18 I=1,NATOMS
      DIAG(I)=rindex(I,I)
  18  rindex(I,I)=0.0D0
C
C  PRINTING THE MATRIX OF THE BOND ORDERS
C
  124 WRITE(*,6342)
 6342 FORMAT(1x,/20X,'BOND ORDER MATRIX'//)
      CALL Mprintb(rindex,NATOMS,maxat)
C
C CALCULATION OF THE VALENCE NUMBERS
C
      DO 9 I=1,NATOMS
      X=0.D0
      DO 10 J=1,NATOMS
  10  X=X+rindex(I,J)
  9   rindex(I,I)=X
      IF(kop.NE.0)then 
      do i=1,natoms 
      tindex(i)=rindex(i,i)
      enddo
      endif

      ishift=(ncell/2)*natc

      kmin1=min0(natc,5)-1
 123  format(20A4)      

      WRITE(*,621)
      IF(kop.EQ.0)then 
      write(*,123)(kiir1(j),j=1,4),((kiir2(j),j=1,4),i=1,kmin1)
      write(*,640) (I-ishift,mend(ia(i)),rindex(I,I),I=llrange,iulrange)
      endif
  64  FORMAT(//25X,'ACTUALLY USED IN BONDS',/)
 640  format(20(I3,A4,F8.5,4(I3,A4,1X,f8.5)/))
 611  FORMAT(//20X,'VALENCE NUMBERS: TOTAL ACTUAL VALUES'/)
 621  FORMAT(//35X,'VALENCES'/)
 612  FORMAT(//30X,'FREE VALENCES',/)
      IF(kop.EQ.0) goto 1234
      DO 32 I=1,NATOMS
      X=0.0D0
      ILI=ILLIM(I)
      ULI=IULIM(I)
      DO 33 J=ILI,ULI
  33  X=X+PAS(J,J)+PBS(J,J)
  32  DIAG(I)=2.D0*X-DIAG(I)
      WRITE(*,611)
      write(*,123)(kiir1(j),j=1,4),((kiir2(j),j=1,4),i=1,kmin1)
      write(*,640)(I-ishift,mend(ia(i)),DIAG(I),I=llrange,iulrange)
      WRITE(*,64) 
      write(*,123)(kiir1(j),j=1,4),((kiir2(j),j=1,4),i=1,kmin1)
      Write(*,640)  (i-ishift,mend(ia(i)),tindex(I),I=llrange,iulrange)
      DO 34 I=1,NATOMS
  34  DIAG(I)=DIAG(I)-tindex(I)
      WRITE(*,612) 
      write(*,123)(kiir1(j),j=1,4),((kiir2(j),j=1,4),i=1,kmin1)
      write(*,640) (I-ishift,mend(ia(i)),DIAG(I),I=llrange,iulrange)

 1234 continue
      return
      end

      subroutine init
      implicit real*8(a-h,o-z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
c     common /fnutab/f(2505,13)
c     common /intertab/d1,d2,d3,d4
      COMMON/C40/CFILL(80),tol,rp2
c     print *,'entering init'
      call fmtset
c     print *,'after fmtset'
      call binom
c     print *,'after binom'
      pisqh=dsqrt(datan(1.d0)*4.d0)/2.d0    
c     print *,'after pisqh'
c     print *,'leaving init'
      return
      end 

      subroutine binom
      implicit real*8(a-h,o-z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
          
      do 1 k=1,30
      bin(k,1)=1.d0
      bin(k,2)=k
  1   bin(k,k+1)=1.d0
      do 2 k=2,30
      do 2 j=2,k
  2   bin(k,j)=bin(k-1,j-1)+bin(k-1,j)

      bifac(1)=1.d0
      do 7 i=3,23,2
      bifac(i)=bifac(i-2)*dfloat(i-2)
  7   continue
      
      fact(1)=1.d0
      do 8 i=2,31
  8   fact(i)=fact(i-1)*dfloat(i-1)
          
      return
      end

      function fi(i,n1,n2,a,b)
      implicit real*8(a-h,o-z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      fi=0.d0
      if(i.gt.n1+n2)return
      if(n1.eq.0.or.n2.eq.0)goto 100
      t=0.d0
      lim=min(i,n1)
      llim=max(0,i-n2)
      do 1 k=llim,lim
  1   t=t+bin(n1,k+1)*a**(n1-k)*bin(n2,i-k+1)*B**(n2-i+k)
      fi=t
      return
 100  if(n1.eq.0.and.n2.eq.0.and.i.ne.0) return
      if(n1.eq.0.and.n2.eq.0.and.i.eq.0) then
      fi=1.d0
      return
      endif
      if(n1.eq.0.and.i.le.n2) fi=bin(n2,i+1)*b**(n2-i)
      if(n2.eq.0.and.i.le.n1) fi=bin(n1,i+1)*a**(n1-i)
       return
      end

      subroutine FMTSET
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/C40/FMZERO(40),GA(40),tol,rpitwo
C*
      DATA HALF/0.5D0/,ONE/1.0D0/,TWO/2.0D0/,TENM9/1.0D-9/
      DATA PI/3.14159265358979D0/,TEN/10.0D0/
C*
C*
C     SET VALUES IN GA AND FMZERO.
      TOL=HALF
      GA(1)=DSQRT(PI)
      RPITWO=GA(1)*HALF
      DO 200 I=2,40
      GA(I)=GA(I-1)*TOL
  200 TOL=TOL+ONE
      TOL=ONE
      FMZERO(1)=ONE
      DO 210 I=2,40
      TOL=TOL+TWO
  210 FMZERO(I)=ONE/TOL
      TOL=TENM9
C     DON'T WORRY ABOUT CHANGING THE CUT-OFFS - GAMGEN IS ONLY CALLED
C     ONCE AT THE VERY START OF THE CALCULATION.
c     IF(KOP1.NE.0)CUT0S=TEN**(-2*KOP1)
c     IF(KOP2.NE.0)TOL=TEN**(-6-KOP2)
      RETURN
      END

      subroutine FMT(T,M,f)
C*
C     ----------------
C     QCPE GAUSSIAN 76
C     U OF T VERSION
C     NOVEMBER 1978
C     ----------------
C*
      IMPLICIT REAL*8 (A-H,O-Z)
C*
      COMMON/C40/FMZERO(40),GA(40),tol,rpitwo
      dimension f(40)
C*
      DATA ZERO/0.0D0/,HALF/0.5D0/,ONE/1.0D0/,TWO/2.0D0/
c     DATA PI/3.14159265358979D0/,TEN/10.0D0/
      DATA CUT0S/0.0D0/,CUTSM/10.0D0/,CUTML/42.0D0/
 
C*
 1000 FORMAT('0FAILURE IN FMTGEN FOR T =',1PD16.8,'  $$ STOP $$')
C*
C     TEST FOR TYPE OF ALGORITHM.
      DT=DABS(T)
      IF(DT.GT.CUT0S)GO TO 20
C     ARGUMENT OF ZERO.
      do 10 i=1,m
   10 F(i)=FMZERO(i)
      RETURN
C     TEST FOR EVALUATION OF THE EXPONENTIAL.
   20 MM1=M-1
      TEXP=ZERO
      IF(DT.GE.CUTML)GO TO 100
      TEXP=DEXP(-T)
      IF(DT.GE.CUTSM)GO TO 50
C     0.0 < T < 10.0.
      A=DFLOAT(MM1)+HALF
      TERM=ONE/A
      SUM=TERM
      DO 30 IX=2,200
      A=A+ONE
      TERM=TERM*T/A
      SUM=SUM+TERM
      IF(DABS(TERM/SUM).LT.TOL)GO TO 40
   30 CONTINUE
      WRITE(*,1000)T
      STOP
   40 F(m)=HALF*SUM*TEXP
      GO TO 110
C     10.0 <= T < 42.0.
   50 A=DFLOAT(MM1)
      B=A+HALF
      A=A-HALF
      TX=ONE/T
      APPROX=RPITWO*DSQRT(TX)*(TX**MM1)
      IF(MM1.EQ.0)GO TO 70
      DO 60 IX=1,MM1
      B=B-ONE
   60 APPROX=APPROX*B
   70 FIMULT=HALF*TEXP*TX
      SUM=ZERO
      IF(FIMULT.EQ.ZERO)GO TO 90
      FIPROP=FIMULT/APPROX
      TERM=ONE
      SUM=ONE
      NOTRMS=IDINT(T)+MM1
      DO 80 IX=2,NOTRMS
      TERM=TERM*A*TX
      SUM=SUM+TERM
      IF(DABS(TERM*FIPROP/SUM).LE.TOL)GO TO 90
   80 A=A-ONE
      WRITE(*,1000)T
      STOP
   90 F(m)=APPROX-FIMULT*SUM
      GO TO 110
C     T >= 42.0.
  100 TX=DFLOAT(M)-HALF
      F(m)=HALF*GA(M)/(T**TX)
C     RECUR DOWNWARDS TO F(1)
  110 IF(MM1.EQ.0)RETURN
      TX=T+T
      SUM=DFLOAT(M+M-3)
      DO 120 IX=1,MM1
      F(M-IX)=(TX*F(M-IX+1)+TEXP)/SUM
  120 SUM=SUM-TWO
      RETURN
      end 
      FUNCTION S(N1,L1,M1,N2,L2,M2,A,B,AB2,PAX,PBX,PAY,PBY,PAZ,PBZ)
       IMPLICIT REAL*8(A-H,O-Z)  
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      PARAMETER (PI=3.141592653589793d0)
      parameter (pi3=31.0062766802998d0)      
       AB=A+B
       ALFA=A*B/AB
       AB3=AB**3 
       COEF=DSQRT(PI3/AB3)
       S=COEF*DEXP(-ALFA*AB2)*SK(N1,N2,A,B,PAX,PBX)*
     $   SK(L1,L2,A,B,PAY,PBY)*SK(M1,M2,A,B,PAZ,PBZ)  
       RETURN
       END


      FUNCTION SK(N1,N2,A,B,PA,PB)
      IMPLICIT REAL*8(A-H,O-Z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      xxx=0.d0
      N=(N1+N2)/2
      AB=2*(A+B)
      DO 10 I=0,N
        xxx=xxx+FI(2*I,N1,N2,PA,PB)*BIFAC(2*I+1)/AB**I
 10   CONTINUE 
       sk=xxx
      RETURN 
      END

      function ANORM(n,l,m,a)
      implicit real*8(a-h,o-z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)   
      PARAMETER (PI=3.141592653589793d0)
      parameter (pi3=31.0062766802998d0)      
      rl=1.d0/bifac(2*l+1)
      rm=1.d0/bifac(2*m+1)
      rn=1.d0/bifac(2*n+1)
      nlm=n+l+m
      coef=8.d0*a*a*a/PI3      
      coef=dsqrt(coef)
      coef1=(4.d0*a)**nlm
      anorm=coef*coef1*rn*rl*rm
      anorm=dsqrt(anorm)
      return
      end


      FUNCTION T(N1,L1,M1,N2,L2,M2,a,b,ab2,pax,pbx,pay,pby,paz,pbz)
      IMPLICIT REAL*8(A-H,O-Z)
      aNLM2=B*(2*(N2+L2+M2)+3)
      NN=N2*(N2-1)
      LL=L2*(L2-1)
      MM=M2*(M2-1)
      SP2=2*B**2*(
     $    S(N1,L1,M1,N2+2,L2,M2,a,b,ab2,pax,pbx,pay,pby,paz,pbz)+
     $    S(N1,L1,M1,N2,L2+2,M2,a,b,ab2,pax,pbx,pay,pby,paz,pbz)+
     $    S(N1,L1,M1,N2,L2,M2+2,a,b,ab2,pax,pbx,pay,pby,paz,pbz))
      if (nn.eq.0.and.ll.eq.0.and.mm.eq.0) then
         sm2=0.d0
      else 
      SM2=NN*S(N1,L1,M1,N2-2,L2,M2,a,b,ab2,pax,pbx,pay,pby,paz,pbz)+
     $    LL*S(N1,L1,M1,N2,L2-2,M2,a,b,ab2,pax,pbx,pay,pby,paz,pbz)+ 
     $    MM*S(N1,L1,M1,N2,L2,M2-2,a,b,ab2,pax,pbx,pay,pby,paz,pbz) 
      endif    
      T=aNLM2*S(N1,L1,M1,N2,L2,M2,a,b,ab2,pax,pbx,pay,pby,paz,pbz)-
     $   SP2-SM2/2.d0
      RETURN
      END


      FUNCTION V(N1,L1,M1,N2,L2,M2,a,b,ab2,pc2,PAX,PAY,PAZ,
     $           PBX,PBY,PBZ,PCX,PCY,PCZ)
      IMPLICIT REAL*8(A-H,O-Z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      dimension fff(100)
      PARAMETER (PI=3.141592653589793d0)
      ALFA=A*B/(A+B)
      VCOEF=2.d0*PI/(A+B)*EXP(-ALFA*AB2) 
      ARGF=(A+B)*PC2 
      NN1=N1+N2+L1+L2+M1+M2
      call fmt(argf,nn1+1,fff)
      v1=0.d0
      DO 20 NU=0,NN1
      v0=0.d0
      DO 30 I=0,N1+N2
      DO 40 J=0,L1+L2
      DO 50 K=0,M1+M2 
        IF((I+J+K).EQ.NU) THEN 
        V0=V0+VG(I,N1,N2,a,b,PAX,PBX,PCX)*
     $        VG(J,L1,L2,a,b,PAY,PBY,PCY)*
     $        VG(K,M1,M2,a,b,PAZ,PBZ,PCZ)
        ENDIF
 50   CONTINUE
 40   CONTINUE 
 30   CONTINUE
      v1=v1+v0*fff(nu+1)
 20   CONTINUE 
      V=V1*VCOEF 
      RETURN
      END


      FUNCTION VG(II,N1,N2,a,b,pax,pbx,pcx)
      IMPLICIT REAL*8(A-H,O-Z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      VGAB0=1.d0/(4.d0*(A+B))
      vg=0.d0 
      DO 60 I=0,N1+N2
      DO 70 J=0,I/2
      DO 80 K=0,(I-2*J)/2
        IF((I-2*J-K).EQ.II) THEN
        VG=VG+(-1)**I*(-1)**K*FI(I,N1,N2,PAX,PBX)*
     $  FACT(I+1)/(FACT(J+1)*FACT(K+1)*FACT(I-2*J-2*K+1))*
     $  VGAB0**(J+K)*PCX**(I-2*J-2*K)
        ENDIF
 80   CONTINUE
 70   CONTINUE
 60   CONTINUE 
      RETURN
      END   

       function TIntg(n1,l1,m1,n2,l2,m2,n3,l3,m3,n4,l4,m4,a,b,c,d,
     $            ab2,cd2,pq2,ax,bx,cx,dx,ay,by,cy,dy,az,bz,cz,dz,
     $            pqx,pqy,pqz) 
        implicit real*8(a-h,o-z) 
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      dimension dii(250),dij(250),dik(250),fff(100)
      PARAMETER (PI=3.141592653589793d0)
      parameter (pi3=31.0062766802998d0)   
      parameter (pi52=34.98683665524973d0)   
       alfa=a*b/(a+b)
       gamma=c*d/(c+d)
       delta=(a+b+c+d)/(4.d0*(a+b)*(c+d))
       n12=n1+n2+n3+n4+l1+l2+l3+l4+m1+m2+m3+m4 
       argf=pq2/(4.d0*delta)    
       coef=pi52*dsqrt(1.d0/(a+b+c+d))*
     $   exp(-alfa*ab2-gamma*cd2)/((a+b)*(c+d))  
        TIntg=0.d0
        call dfill(n1,n2,n3,n4,a,b,c,d,ax,bx,cx,dx,pqx,dii)      
        call dfill(l1,l2,l3,l4,a,b,c,d,ay,by,cy,dy,pqy,dij)      
        call dfill(m1,m2,m3,m4,a,b,c,d,az,bz,cz,dz,pqz,dik)      
        call fmt(argf,n12+1,fff)
        do 100 nu=0,n12
        TIntg0=0.d0
       do 101 i=0,n1+n2+n3+n4
           diix=dii(i+1)
          if (diix.eq.0.d0) goto 101
       do 102 j=0,l1+l2+l3+l4
           dijy=dij(j+1)
          if (dijy.eq.0.d0)goto 102
       do 103 k=0,m1+m2+m3+m4
      if((i+j+k).eq.nu) then
       TIntg0=TIntg0+diix*dijy*dik(k+1)
      endif
 103    continue
 102    continue
 101    continue
       TIntg=TIntg+TIntg0*fff(nu+1)
 100    continue
       TIntg=coef*TIntg
       return
       end

      subroutine dfill(n1,n2,n3,n4,a,b,c,d,ax,bx,cx,dx,pqx,dd)
        implicit real*8(a-h,o-z)
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)        
      dimension hs(250),ht(250)
      dimension dd(1)
      delta=(a+b+c+d)/(4.d0*(a+b)*(c+d))
      nn1=n1+n2
      nn2=n3+n4
      nn=nn1+nn2
      call hfill(n1,n2,ax,bx,a+b,hs) 
      call hfill(n3,n4,cx,dx,c+d,ht) 
      if(nn.eq.0) then 
         his=hs(1)
         hit=ht(1)
         dd(1)=his*hit
         return
       endif

        do 140 i=0,nn
        dd(i+1)=0.d0
 140    continue  
        do 150 is=0,nn1
        do 151 it=0,nn2
        ist=(is+it)/2
        do 152 iu=0,ist
         i=is+it-iu
        dd(i+1)=dd(i+1)+(-1)**(iu+it)*fact(is+it+1)*
     $  (-pqx)**(i-iu)/(fact(iu+1)*fact(i-iu+1)*delta**i)*
     $  hs(is+1)*ht(it+1)
 152    continue
 151    continue
 150    continue
      return        
      end     

      subroutine hfill(n1,n2,a,b,ex,h)
      implicit real*8(a-h,o-z)
      dimension ef(20),h(100)
      common /bin/bin(30,31),bifac(23),pisqh,fac(31)
      nn=n1+n2

      if(nn.eq.0) then
         h(1)=1.d0
         return
      endif

      eh=0.25d0/ex

      if(n1.lt.3.and.n2.lt.3) then
        h(nn+1)= eh**nn

        if(n1.ge.n2)then
        ah=a
        bh=b
        else
        ah=b
        bh=a
        endif

        if(nn.eq.1) then
        h(1)=ah
        else
        ed=0.5d0/ex
        rd=ah*bh
        rh=ah+bh
           if(nn.eq.2) then
              if(n1.eq.1) then
              h(1)=rd+ed
              h(2)=rh*eh
              else
              h(1)=ah**2+ed
              h(2)=ah*ed
              endif
           else
           ru=ah**2
           rv=bh**2
           rw=eh**2

              if(nn.eq.3) then
              h(1)=ru*bh+(ah+rh)*ed
              h(2)=(2.d0*rd+ru)*eh+6.d0*rw
              h(3)=(ah+rh)*rw
              else
              rt=2.d0*rw*eh
              ro=ru+rv+4.d0*rd
              h(1)=rd**2+ro*ed+12.d0*rw
              h(2)=rh*(rd*ed+12.d0*rw)
              h(3)=ro*rw+6.d0*rt
              h(4)=rh*rt
              endif
      endif
      endif
       else
         do 11 n6=0,nn-1
         h(n6+1)=0
         ef(n6+1)=fi(n6,n1,n2,a,b)
 11      continue
         ef(nn+1)=1.d0
         do 12 n4=0,nn
         nlim=n4/2
         do 12 n5=0,nlim
         n6=n4-2*n5
         if(n6.eq.nn)then
         h(n6+1)=eh**nn
         else
         h(n6+1)=h(n6+1)+fac(n4+1)*ef(n4+1)/fac(n5+1)/fac(n6+1)
     $         *eh**(n4-n5)
         endif
  12    continue

      endif

      return
      end


      subroutine input  
      IMPLICIT REAL*8(A-H,O-Z)
      parameter (ndeckl=882)
      parameter (nmax=1000)
      PARAMETER (maxp=4000,maxg=1000,maxc=16,maxat=200) 
      common iop(45)
c     common /fnutab/f(2505,13)
c     common /intertab/d1,d2,d3,d4
      common /bin/bin(30,31),bifac(23),pisqh,fact(31)
      common /nat/ nat,nbasis,ifg,nocc,nalf,nb,iuhf
      common /c/ c(ndeckl,ndeckl),p(ndeckl,ndeckl)
      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/ coeff(maxg,maxc) 
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)     
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /opensh/ cb(ndeckl,ndeckl)   
      common/map/imap(maxp)
      common /b/ expsh(maxp),c1(maxp),c2(maxp),cdummy(240),x(maxp),
     $  y(maxp),z(maxp),jan(80),ishella(maxp),mnsh(maxp),ishellt(maxp),
     $  iaos(maxg),iaon(20), ncshell,maxl
      common /ia/izn(maxat),kop
      common /nps/npshell
      common/range/llrange,iulrange,ncell,natc
      dimension msc(maxp),nsh(maxp),cc(7)
      dimension ibe(20),methodu(2),methodr(2),numat(4),numel(4),
     $ numa(4),numb(4),numbf(4),numcs(4),nhang(4),ndegr(4),numps(6),
     $ numet(3),iatnm(3),nucch(4),icart(4),ishty(3),npons(6),mstat(4),
     $ nprex(4),ncncf(4),nspcf(4),ncosh(4),mocal(4),mocbe(4)
c     dimension d1(2504,13),d2(2503,13),d3(2502,13),d4(2501,13)
      dimension mssh(maxg),iatsh(nmax),iatc(nmax)
   
      dimension ILABEL(30),ITYP(30,30),PEXP(30,30),PCS(30,30),
     $  PCP(30,30),PCD(30,30),IATTYPE(maxat),ICONT(30,30),
     $  NCSHELLAT(30)

       equivalence (natoms,nat)

      data dc12 /2.449489743d0/
      data dc11 /1.095445115d0/
      data dc21 /0.866025403d0/
      data dc41 /0.790569415d0/
      data dc42 /1.060660172d0/

      data methodr/'  RH','F   '/
      data methodu/'  UH','F   '/
      data numat /'Numb','er o','f at','oms '/
      data numel/'Numb','er o','f el','ectr'/
      data numa /'Numb','er o','f al','pha '/
      data numb /'Numb','er o','f be','ta e'/
      data numbf /'Numb','er o','f ba','sis '/
      data numcs /'Numb','er o','f co','ntra'/
      data nhang /'High','est ','angu','lar '/
      data ndegr /'Larg','est ','degr','ee o'/
      data numps /'Numb','er o','f pr','imit','ive ','shel'/
      data numet /'SCF ','Ener','gy  '/
      data iatnm /'Atom','ic n','umbe'/
      data nucch /'Nucl','ear ','char','ges '/
      data icart /'Curr','ent ','cart','esia'/
      data ishty /'Shel','l ty','pes '/
      data npons /'Numb','er o','f pr','imit','ives',' per'/
      data mstat /'Shel','l to',' ato','m ma'/
      data nprex /'Prim','itiv','e ex','pone'/
      data ncncf /'Cont','ract','ion ','coef'/
      data nspcf /'P(S=','P) C','ontr','acti'/
      data ncosh /'Coor','dina','tes ','of e'/
      data mocal /'Alph','a MO',' coe','ffic'/
      data mocbe /'Beta',' MO ','coef','fici'/


c     data IATOM1 /' ATO'/,IATOM2/'M AT'/
      data IATOM1 /' N. '/,IATOM2/'ATOM'/

      data iblank /'    '/
      data ISTAR1 /' ***'/,ISTAR2/'****'/ 
      data IATOM3/'   A'/IATOM4/'TOM '/

      data ILATTIC1/' LAT'/,ILATTIC2/'TICE'/


      data iSchar/'S   '/
      data iSPchar/'SP  '/
      data iDchar/'D   '/
      data iPchar/'P   '/
      
c     open (14,file='Test.FChk')
c     open (15,file='Tmp')

c     print*,'1'
      open (16,file='Cryst.interf')
c     print*,'2'
      open (17,file='CTmp')
c     print*,'3'
  
      
      I6D=0
c If calculation with 6d basis orbitals (Cartesian d orbitals) is desired, 
C     set  I6D=1  . (Not tested !!!) 

      
      NCELL=7
c     print*,'4'


c     i=0
c 1   read(14,150,end=100)ibe
 150  format(20a4) 
c     i=i+1
c     write(15,150)ibe
c     goto 1
c9999 print *,' The required input file (Test.FChk) is missing. STOP'      
c     stop 9999
c100  if(i.le.5)goto 9999
      i=0
  11  read(16,150,end=200)ibe
      i=i+1
      write(17,150)ibe
      goto 11
 9998 print *,' The required input file (Cryst.interf) is missing. STOP'      
      stop 9998
 200  if(i.le.5)goto 9998
c      rewind 15
c     read(15,150)ibe
c     write(*,150)ibe
c     print *,'   '
c     read(15,150)ibe
c     iuhf=0
c     irhf=0
c     if(ibe(3).eq.methodr(1).and.ibe(4).eq.methodr(2))irhf=1
c     if(ibe(3).eq.methodu(1).and.ibe(4).eq.methodu(2))iuhf=1
c     if(iuhf.eq.0.and.irhf.eq.0)then
c     write(*,*)'  The program presently is applicable for the RHF',
c    $  ' and UHF cases only --- STOP'
c     stop 
c     endif
c      rewind 15
c126    read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.numat(1).and.ibe(2).eq.numat(2).
c    $ and.ibe(3).eq.numat(3).and.ibe(4).eq.numat(4)) then
c     backspace 15
c     read(15,151)nat
 151  format(55x,i6)   
c     else 
c     goto 126
c     endif
c      rewind 15
c127  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.numel(1).and.ibe(2).eq.numel(2).
c    $ and.ibe(3).eq.numel(3).and.ibe(4).eq.numel(4)) then
c     backspace 15
c nelectr   =the number of electrons in the system
c     read(15,151)nelectr
c     else 
c     goto 127
c     endif
c      rewind 15
c128  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.numa(1).and.ibe(2).eq.numa(2).
c    $ and.ibe(3).eq.numa(3).and.ibe(4).eq.numa(4)) then
c     backspace 15
c      nalf      =number of alpha electrons
c     read(15,151)nalf   
c     else 
c     goto 128
c     endif
c      rewind 15
c129  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.numb(1).and.ibe(2).eq.numb(2).
c    $ and.ibe(3).eq.numb(3).and.ibe(4).eq.numb(4)) then
c     backspace 15
c      nb        =number of beta electrons
c     read(15,151)nb
c     else 
c     goto 129
c     endif
c     kop=0
c     if(nalf.ne.nb)kop=1
c      rewind 15
c130  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.numbf(1).and.ibe(2).eq.numbf(2).
c    $ and.ibe(3).eq.numbf(3).and.ibe(4).eq.numbf(4)) then
c     backspace 15
c      nbasis    =number of basis funcions
c     read(15,151)nbasis
c     else 
c     goto 130
c     endif
c      rewind 15
c131  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.numcs(1).and.ibe(2).eq.numcs(2).
c    $ and.ibe(3).eq.numcs(3).and.ibe(4).eq.numcs(4)) then
c     backspace 15
c      ncshell   =number of contracted shells
c     read(15,151)ncshell
c     else 
c     goto 131
c     endif
c      rewind 15
c132  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.nhang(1).and.ibe(2).eq.nhang(2).
c    $ and.ibe(3).eq.nhang(3).and.ibe(4).eq.nhang(4)) then
c     backspace 15
c     read(15,151)maxl
c     else 
c     goto 132
c     endif
c      rewind 15
c133  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.ndegr(1).and.ibe(2).eq.ndegr(2).
c    $ and.ibe(3).eq.ndegr(3).and.ibe(4).eq.ndegr(4)) then
c     backspace 15
c     read(15,151)maxk
c     else 
c     goto 133
c     endif
c      rewind 15
c134  read(15,150,end=1000)(ibe(i),i=1,6)
c     if(ibe(1).eq.numps(1).and.ibe(2).eq.numps(2).
c    $ and.ibe(3).eq.numps(3).and.ibe(4).eq.numps(4).
c    $ and.ibe(5).eq.numps(5).and.ibe(6).eq.numps(6)) then
c     backspace 15
c      npshell   =number of primitive shells
c     read(15,151)npshell
c     else 
c     goto 134
c     endif
c      rewind 15
c135  read(15,150,end=1000)(ibe(i),i=1,3)
c     if(ibe(1).eq.numet(1).and.ibe(2).eq.numet(2).
c    $ and.ibe(3).eq.numet(3)) then
c     backspace 15
c     read(15,152)escf   
c152  format(45x,d30.10)
c     else 
c     goto 135
c     endif
c      rewind 15
c136  read(15,150,end=1000)(ibe(i),i=1,3)
c     if(ibe(1).eq.iatnm(1).and.ibe(2).eq.iatnm(2).
c    $  and.ibe(3).eq.iatnm(3)) then
c      iznuc     =atomic numbers
c     read(15,*)(iznuc(i),i=1,nat)   
c     else 
c     goto 136
c     endif
c      rewind 15
c137  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.nucch(1).and.ibe(2).eq.nucch(2).
c    $ and.ibe(3).eq.nucch(3).and.ibe(4).eq.nucch(4)) then
c      zn        =nuclear charges
c     read(15,*)(zn(i),i=1,nat)
c153  format(10f5.2)
c     else 
c     goto 137
c     endif
c      rewind 15
c538  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.icart(1).and.ibe(2).eq.icart(2).
c    $ and.ibe(3).eq.icart(3).and.ibe(4).eq.icart(4)) then
c      coord     =Cartesian coordinates
c     read(15,*)(coord(1,i),coord(2,i),coord(3,i),i=1,nat)
c     else 
c     goto 538
c     endif
       rewind 17
  338  read(17,150,end=1000)(ibe(i),i=1,2)
      if(.not.((ibe(1).eq.ILATTIC1).and.(ibe(2).eq.ILATTIC2)))goto 338  
      backspace 17
      read(17,6338)rlattice
 6338 format(51x,f20.10)
      print *, 'Lattice vector along axis X: ',rlattice

       
        write(*,*)'  '
        write(*,*)' Atomic numbers and coord.s of the elementary cell:'
        write(*,*)'  '
       nelectr=0
       rewind 17
  138 read(17,150,end=1000)(ibe(i),i=1,2)     
      if(ibe(1).eq.IATOM1.and.ibe(2).eq.IATOM2)then
  239 read(17,150,end=1000)(ibe(i),i=1,2)
      if(ibe(1).eq.istar1.and.ibe(2).eq.istar2)goto 177
      if(.not.((ibe(1).eq.IBLANK).and.(ibe(2).eq.IBLANK)))then
 178  backspace 17
      read(17,6111)i,izn(i),coord(1,i),coord(2,i),coord(3,i)
 6111 format(i4,10x,i3,5x,3E19.10)
      nelectr=nelectr+izn(i)
      write(*,6110)i,izn(i),coord(1,i),coord(2,i),coord(3,i)
 6110 format(2i4,1p3e20.12)
       else
      read(17,150,end=1000)(ibe(i),i=1,2)
      if(ibe(1).eq.istar1.and.ibe(2).eq.istar2)goto 177
      if(.not.((ibe(1).eq.IBLANK).and.(ibe(2).eq.IBLANK)))then
      backspace 17
      read(17,6111)i,izn(i),coord(1,i),coord(2,i),coord(3,i)
      nelectr=nelectr+izn(i)
      write(*,6110)i,izn(i),coord(1,i),coord(2,i),coord(3,i)
      endif
c     goto 177
      endif
      ii=i
      goto 239  
      else 
      goto 138
       endif
  177 nat=ii       
      natc=nat  



      nalf=nelectr/2
      if(2*nalf.ne.nelectr)then
      print *, 'A subunit with odd number of electrons has been
     $  has been defined - STOP'
       stop 9871
       endif
       nb=nalf
      
      nelectr=ncell*nelectr
      nalf=ncell*nalf
      nb=ncell*nb

       do i=nat+1,ncell*nat
       k=(i-1)/nat
c      print *,i,k
       izn(i)=izn(i-nat)
       coord(1,i)=coord(1,i-nat)+rlattice
       coord(2,i)=coord(2,i-nat)
       coord(3,i)=coord(3,i-nat)
       enddo
 
       k=ncell/2
       eltol=dfloat(k)*rlattice
c      print *,'k, eltol',k,eltol
       do i=1,ncell*nat
       coord(1,i)=coord(1,i)-eltol
        enddo


       print *,'  Atomic numbers and coordinates of the overall cluster'
       do i=1,ncell*nat
      write(*,6110)i,izn(i),coord(1,i),coord(2,i),coord(3,i)
      enddo


       llrange=nat*(ncell/2)+1
       iulrange=nat*(ncell/2+1)
        print *,'  '
       write(*,6114) 
        print *,'  '
       print *,' Reference cell:  atoms',llrange,' to',iulrange

       call prdist(coord,ncell*nat,nat,llrange,iulrange)	

       do i=1,ncell*nat
       zn(i)=dfloat(izn(i))
        do j=1,3
c      coord(j,i)=coord(j,i)/0.52917725d0
       coord(j,i)=coord(j,i)/0.529177d0
       enddo
       enddo


      rewind 17
  240 read(17,150,end=1000)(ibe(i),i=1,2)
      if(.not.(ibe(1).eq.ISTAR1.and.ibe(2).eq.ISTAR2)) goto 240
  241 read(17,150,end=1000)(ibe(i),i=1,2) 
      if(.not.(ibe(1).eq.IATOM3.and.ibe(2).eq.IATOM4))  goto 240
      read(17,150)(ibe(i),i=1,5)
      write(*,*)'  '
      write(*,*)' Atomic basis sets:'
      write(*,*)'  '
      write(*,6114)
 6114 format(1x,70(1h*))  
 6116  format(5A4)
C First atom
      ilab=1 
      read(17,6117)jat,ilabel(ilab),xx,yy,zz        
 6117 format(i4,a3,3f7.4,'               Type=',i4)
 6118 format(4x,i4,10x,a4)

      print 6117,jat,ilabel(ilab),xx,yy,zz,ilab
C  IATTYPE(jat) contains the atomtype of atom JAT  
      iattype(jat)=ilab
C  initialization for counting the primitive and contracted shells of the atom: 
      ipshell=1
      icshell=0
 1250 read(17,150)ibe
c     print 150,ibe
      if(ibe(1).ne.iblank.or.ibe(2).ne.iblank) goto 1333  
      ib=0
      do k=1,6
      if(ibe(k).ne.iblank)ib=1
      enddo 
c     print *, '  ib,ilab,icshell=',ib,ilab,icshell
      if(ib.eq.0) then
      icshell=icshell+1
      if(icshell.le.30)go to 1543
      print *, ' No more than 30 different contracted shells',
     $ ' per atom admitted' 
       stop 1543
 1543  ncshellat(ilab)=icshell
c      print *, ilab,' ncshellat(',ilab,')',ncshellat(ilab)
      ityp(ilab,icshell)=ibe(10) 
      print 6118,icshell,ityp(ilab,icshell) 

      read(17,6878)pexp(ilab,ipshell),pcs(ilab,ipshell),
     $  pcp(ilab,ipshell),pcd(ilab,ipshell)
c       print *, 'ipshell=',ipshell
      print 6119,pexp(ilab,ipshell),pcs(ilab,ipshell),
     $  pcp(ilab,ipshell),pcd(ilab,ipshell)
      icont(ilab,icshell)=1
      ipshell=ipshell+1
 6119 format(1p4e18.10)
 6878 format(8x,1p4e18.11)  
      goto 1250
       else
c      print 6118,ilab,icshell,ityp(ilab,icshell) 
       backspace 17
      read(17,6878)pexp(ilab,ipshell),pcs(ilab,ipshell),
     $  pcp(ilab,ipshell),pcd(ilab,ipshell)
c       print *, 'ipshell=',ipshell
      print 6119,pexp(ilab,ipshell),pcs(ilab,ipshell),
     $  pcp(ilab,ipshell),pcd(ilab,ipshell)
       icont(ilab,icshell)=icont(ilab,icshell)+1
      ipshell=ipshell+1
        goto 1250 

       endif
 
 1333  print *,' '
C Check whether of new type 
      backspace 17 
       read(17,6117)jat,ilabx,xx,yy,zz
      do i=1,ilab
      if(ilabx.eq.ilabel(i)) then
      jtype=i
      goto 5512
      endif
      enddo
C  New type
      ilab=ilab+1
      if(ilab.le.30)go to 542
      print *, ' No more than 30 different types of atoms admitted'
       stop 542

 542  ilabel(ilab)=ilabx
      jtype=ilab
      goto 5513
C  Not of a new type:
 5512 iattype(jat)=jtype
      print 6117,jat,ilabx,xx,yy,zz,jtype
      goto 5514
 5513 print 6117,jat,ilabx,xx,yy,zz,jtype
      iattype(jat)=ilab
C  initialization for counting the primitive and contracted shells of the atom: 
 5514 ipshell=1
      icshell=0
  250 read(17,150)ibe
c     print 150,ibe
      if(ibe(1).eq.istar1.and.ibe(2).eq.istar2)goto 777
      if(ibe(1).ne.iblank.or.ibe(2).ne.iblank) goto 1333  
      ib=0
      do k=1,6
      if(ibe(k).ne.iblank)ib=1
      enddo 
c     print *, '  ib,ilab,icshell=',ib,ilab,icshell
      if(ib.eq.0) then
      icshell=icshell+1
      if(icshell.le.30)goto 543
      print *, ' No more than 30 different contracted shells',
     $ ' per atom admitted' 
       stop 543
 543  ncshellat(ilab)=icshell
c      print *, ilab,' ncshellat(',ilab,')',ncshellat(ilab)
      ityp(ilab,icshell)=ibe(10) 
      print 6118,icshell,ityp(ilab,icshell) 

      read(17,6878)pexp(ilab,ipshell),pcs(ilab,ipshell),
     $  pcp(ilab,ipshell),pcd(ilab,ipshell)
c       print *, 'ipshell=',ipshell
      print 6119,pexp(ilab,ipshell),pcs(ilab,ipshell),
     $  pcp(ilab,ipshell),pcd(ilab,ipshell)
      icont(ilab,icshell)=1
      ipshell=ipshell+1
      goto 250
       else
c      print 6118,ilab,icshell,ityp(ilab,icshell) 
       backspace 17
      read(17,6878)pexp(ilab,ipshell),pcs(ilab,ipshell),
     $  pcp(ilab,ipshell),pcd(ilab,ipshell)
c       print *, 'ipshell=',ipshell
      print 6119,pexp(ilab,ipshell),pcs(ilab,ipshell),
     $  pcp(ilab,ipshell),pcd(ilab,ipshell)
       icont(ilab,icshell)=icont(ilab,icshell)+1
      ipshell=ipshell+1
        goto 250 

       endif
 






c      endif 
c      goto 240
c      endif

  777 continue
      print 6114    
c     natoms=jat
c     nattypes=ilab
c6712 format(/,'  Number of atoms', i4,5x, 'Number of types', i4,/)
c     print 6712, natoms,   nattypes
c     print *,' Types=',(iattype(i),i=1,natoms)
c     ita=ityp=
c     do i=1,nattypes
c     print *, 'atom prim.     ',i,'-th type at.,' ,ncshellat(i),
c    $' contracted shells'
c     ifut=1
 
c     do j=1,ncshellat(i)
c     print 6666,i,j, ityp(i,j),icont(i,j)
c6666 format(2i4,4x,a4,i4)
c     do li=1,icont(i,j)
c     print 6656, i,ifut,pexp(i,ifut),pcs(i,ifut),pcp(i,ifut),
c    $   pcd(i,ifut) 
c6656 format(2i4,4x,1p4e14.7)
c     ifut=ifut+1
c     enddo
      


      do i=nat+1,ncell*nat
      iattype(i)=iattype(i-nat)
      enddo


      natoms=ncell*natoms



      print 6114    
c     natoms=jat
      nattypes=ilab
 6712 format(/,'  Number of atoms', i4,5x, 'Number of types', i4,/)
      print 6712, natoms,   nattypes
      print *,' Types:'
      print 6713 ,(iattype(i),i=1,natoms)
 6713 format(25i3)
c     ita=ityp=
      do i=1,nattypes
      print *, 'atom prim.     ',i,'-th type at.,' ,ncshellat(i),
     $' contracted shells'
      ifut=1
 
      do j=1,ncshellat(i)
      print 6666,i,j, ityp(i,j),icont(i,j)
 6666 format(2i4,4x,a4,i4)
      do li=1,icont(i,j)
      print 6656, i,ifut,pexp(i,ifut),pcs(i,ifut),pcp(i,ifut),
     $   pcd(i,ifut) 
 6656 format(2i4,4x,1p4e14.7)
      ifut=ifut+1
      enddo
      enddo

      enddo


      print 6114
      print *, '  '
      print *, '  '
 
c     enddo  
       maxl=0
      ibasf=0
      iprim=1
      isfut=1
      do 861 ii=1,natoms
      ita=iattype(ii)
c     print *,' atom',ii,'type',ita
      ifut=1
      jj=ncshellat(ita)
       do 862 j=1,jj
       iii=ityp(ita,j)
c     print 6612,iii
 6612 format(10x,'|',a4,'|')
      kudi=0
      if(iii.eq.iSchar    )kudi=1
      if(iii.eq.iSPchar   )kudi=2
      if(iii.eq.iDchar    )kudi=3
      if(iii.eq.iPchar    )kudi=4

c     if(iii.eq.4hS     )kudi=1
c     if(iii.eq.4hSP    )kudi=2
c     if(iii.eq.4hD     )kudi=3
c     if(iii.eq.4hP     )kudi=4
c     print *,ii,ita,j,' kudi=',kudi
      if(kudi.eq.1)mssh(isfut)=0
      if(kudi.eq.2)mssh(isfut)=-1
      if(kudi.eq.3)mssh(isfut)=-2
      if(kudi.eq.3.and.i6d.eq.1)mssh(isfut)=2
c
c    By default the case of 5D orbitals is assumed. If the 
C
c    basis contains 6D (cartesian d-s), set i6d=1!
c    (Not tested !!!!)
c
      if(kudi.eq.4)mssh(isfut)=1      
      if(kudi.eq.1)ibasf=ibasf+1
      if(kudi.eq.2)ibasf=ibasf+4
      if(kudi.eq.3)ibasf=ibasf+5
c
      if(kudi.eq.3.and.i6d.eq.1)ibasf=ibasf+1
      if(kudi.eq.4)ibasf=ibasf+3
c
c    The case of 5D orbitals is assumed, except if 
c              i6d=1 is set !!!!!
c
      
      if(kudi.eq.2)maxl=max0(maxl,1)
      if(kudi.eq.3)maxl=max0(maxl,2)
      if(kudi.eq.4)maxl=max0(maxl,1)
c
c
      mnsh(isfut)=icont(ita,j)
      iatsh(isfut)=ii 
      x(isfut)=coord(1,ii)
      y(isfut)=coord(2,ii)
      z(isfut)=coord(3,ii)


      isfut=isfut+1
c     print *,' isfut',isfut
c
c
       if(kudi.eq.0)stop 765
c      if(kudi.eq.1.or.kudi.eq.2)then
      do 864 li=1,icont(ita,j)
c     print *,iprim,pexp(ita,ifut),pcs(ita,ifut) 
      expsh(iprim)=pexp(ita,ifut) 
      if(kudi.eq.1)c1(iprim)=pcs(ita,ifut)        
      if(kudi.eq.3)c1(iprim)=pcd(ita,ifut)  
      if(kudi.eq.2)then
      c1(iprim)=pcs(ita,ifut)
      c2(iprim)=pcp(ita,ifut)
       endif
      if(kudi.eq.4)c1(iprim)=pcp(ita,ifut)
c
c    The case of 5D orbitals is assumed!!!!!
c
c     if(kudi.eq.4)mssh(isfut)=1      
c

     
      ifut=ifut+1
      iprim=iprim+1 
 864  continue
c     enddo
 862  continue
 861  continue
      iprim=iprim-1
      print *,'iprim=',iprim,' (number of primitive shells)'
      npshell=iprim
      print *,'Number of primitive shells',npshell
c     print *,(c1(i),i=1,iprim)
c     do i=1,iprim
c     print *,expsh(i),c1(i),c2(i)
c     enddo  
      isfut=isfut-1
      print *, 'isfut vege',isfut,' (number of contracted shells)'
      ncshell=isfut
      print *, 'ibasf',ibasf,' (number of basis functions)'
      nbasis=ibasf

 
c      rewind 15
c139  read(15,150,end=1000)(ibe(i),i=1,3)
c     if(ibe(1).eq.ishty(1).and.ibe(2).eq.ishty(2).
c    $ and.ibe(3).eq.ishty(3)) then
c      mssh      =shell types (S=0; P=1; D=2; F=3; SP=-1; 5D=-2; 7F=-3)
c     read(15,*)(mssh(i),i=1,ncshell)
c     else 
c     goto 139
c     endif
c      rewind 15
c140  read(15,150,end=1000)(ibe(i),i=1,6)
c     if(ibe(1).eq.npons(1).and.ibe(2).eq.npons(2).
c    $ and.ibe(3).eq.npons(3).and.ibe(4).eq.npons(4).
c    $ and.ibe(5).eq.npons(5).and.ibe(6).eq.npons(6)) then
c      mnsh      =number of primitives/shell
c     read(15,*)(mnsh(i),i=1,ncshell)
c     print 154,(mnsh(i),i=1,ncshell )
 154  format(10i3)
c     else 
c     goto 140
c     endif
c      rewind 15
c141  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.mstat(1).and.ibe(2).eq.mstat(2).     
c    $ and.ibe(3).eq.mstat(3).and.ibe(4).eq.mstat(4)) then
c      iatsh     =shell to atom map
c     read(15,*)(iatsh(i),i=1,ncshell)
c     else 
c     goto 141
c     endif
c      rewind 15
c142  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.nprex(1).and.ibe(2).eq.nprex(2).
c    $ and.ibe(3).eq.nprex(3).and.ibe(4).eq.nprex(4)) then
c     read(15,*)(expsh(i),i=1,npshell)
c     else 
c     goto 142
c     endif
c      rewind 15
c143  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.ncncf(1).and.ibe(2).eq.ncncf(2).
c    $ and.ibe(3).eq.ncncf(3).and.ibe(4).eq.ncncf(4)) then
c     read(15,*)(c1(i),i=1,npshell)
c                 continue
c     else 
c     goto 143
c     endif

c     do 1012 ii=1,ncshell
c      if(mssh(ii).eq.-1) goto 1123
c1012 continue
c     goto 122 
c1123  rewind 15
c144  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.nspcf(1).and.ibe(2).eq.nspcf(2).
c    $ and.ibe(3).eq.nspcf(3).and.ibe(4).eq.nspcf(4)) then
c     read(15,*)(c2(i),i=1,npshell)
c     else 
c     goto 144
c     endif


 122   rewind 15
c145  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.ncosh(1).and.ibe(2).eq.ncosh(2).
c    $ and.ibe(3).eq.ncosh(3).and.ibe(4).eq.ncosh(4)) then
c     read(15,111)(x(i),y(i),z(i),i=1,ncshell)
c     else 
c     goto 145
c     endif
c      rewind 15
c146  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.mocal(1).and.ibe(2).eq.mocal(2).
c    $ and.ibe(3).eq.mocal(3).and.ibe(4).eq.mocal(4)) then
c     read(15,*)((c(i,j),i=1,nbasis),j=1,nbasis)
c     else 
c     goto 146
c     endif
c      rewind 15
c     if(iuhf.eq.1) then
c147  read(15,150,end=1000)(ibe(i),i=1,4)
c     if(ibe(1).eq.mocbe(1).and.ibe(2).eq.mocbe(2).
c    $ and.ibe(3).eq.mocbe(3).and.ibe(4).eq.mocbe(4)) then
c     read(15,*)((cb(i,j),i=1,nbasis),j=1,nbasis)
c     else 
c     goto 147
c     endif

c     endif
c      nocc      =number of occupied orbitals
      
      nocc=nelectr/2

      ishella(1)=1
      ishellt(1)=iabs(mssh(1))
      do i=2,ncshell
       ishella(i)=ishella(i-1)+mnsh(i-1)
      ishellt(i)=iabs(mssh(i))
      enddo
      
      iaos(1)=1
      do i=2,ncshell
      nn=1
      if(mssh(i-1).eq.1)nn=3
      if(mssh(i-1).eq.-1)nn=4
      if(mssh(i-1).eq.2)nn=6
      if(mssh(i-1).eq.-2)nn=5
      if(mssh(i-1).eq.3)nn=10
      if(mssh(i-1).eq.-3)nn=7
c     if(mssh(i-1).eq.4)nn=15
c     if(mssh(i-1).eq.-4)nn=9
       
       iaos(i)=iaos(i-1)+nn
      
      enddo
      if(mssh(1).eq.1)then
      print *,' The first shell in the system must not be a pure p one'
      print *,'          PROGRAM STOPS'
      stop 4358
      endif
      do i=1,ncshell
      if(mssh(i).eq.1)iaos(i)=iaos(i)-1    
      enddo

      iaos(ncshell+1)=nbasis+1
      ic=1
      ireadsp=0

c      ncont(i)  =number of contractions in the i'th contracted shell

      print *, 'maxl',maxl
      if(iabs(maxl).gt.2)then
      print *,' The present version of the program does not handle ',
     $ 'F (G...) orbitals'
      print *,'          PROGRAM STOPS'
      stop 4359

      endif 
  
      if(iabs(maxl).ge.2)IOP(7)=1

      do 420 i=1,ncshell
      ms=mssh(i)
      if(ms.eq.-1)ireadsp=1
      ccc=mnsh(i)
      ia=iatsh(i)
      if(ms.eq.0) then
      nsh(i)=1
      msc(ic)=ms
      ncont(ic)=ccc 
      iatc(ic)=ia
      ic=ic+1
      goto 420
      endif
      if(ms.eq.1)then
      nsh(i)=3
      msc(ic)=1
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=1
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=1
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia
      ic=ic+3
      goto 420
      endif
      if(ms.eq.2)then
      nsh(i)=6
      msc(ic)=2
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=2
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=2
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=2
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      msc(ic+4)=2
      ncont(ic+4)=ccc 
      iatc(ic+4)=ia

      msc(ic+5)=2
      ncont(ic+5)=ccc 
      iatc(ic+5)=ia
      ic=ic+6
      goto 420
      endif
      if(ms.eq.-1)then
      nsh(i)=4
      msc(ic)=0
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=1
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=1
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=1
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      ic=ic+4
      goto 420
      endif
      if(ms.eq.-2)then
      nsh(i)=5
      msc(ic)=-2
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=-2
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=-2
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=-2
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      msc(ic+4)=-2
      ncont(ic+4)=ccc 
      iatc(ic+4)=ia

      ic=ic+5
      goto 420
      endif

      if(ms.eq.3)then
      nsh(i)=10
      msc(ic)=3
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=3
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=3
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=3
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      msc(ic+4)=3
      ncont(ic+4)=ccc 
      iatc(ic+4)=ia

      msc(ic+5)=3
      ncont(ic+5)=ccc 
      iatc(ic+5)=ia

      msc(ic+6)=3
      ncont(ic+6)=ccc 
      iatc(ic+6)=ia

      msc(ic+7)=3
      ncont(ic+7)=ccc 
      iatc(ic+7)=ia

      msc(ic+8)=3
      ncont(ic+8)=ccc 
      iatc(ic+8)=ia

      msc(ic+9)=3
      ncont(ic+9)=ccc 
      iatc(ic+9)=ia
      ic=ic+10
      goto 420
      endif

      if(ms.eq.-3)then
      nsh(i)=7
      msc(ic)=-3
      ncont(ic)=ccc 
      iatc(ic)=ia

      msc(ic+1)=-3
      ncont(ic+1)=ccc 
      iatc(ic+1)=ia

      msc(ic+2)=-3
      ncont(ic+2)=ccc 
      iatc(ic+2)=ia

      msc(ic+3)=-3
      ncont(ic+3)=ccc 
      iatc(ic+3)=ia

      msc(ic+4)=-3
      ncont(ic+4)=ccc 
      iatc(ic+4)=ia

      msc(ic+5)=-3
      ncont(ic+5)=ccc 
      iatc(ic+5)=ia

      msc(ic+6)=-3
      ncont(ic+6)=ccc 
      iatc(ic+6)=ia

      ic=ic+7
      goto 420
      endif

      write(*,*)' Unknown orbital type - STOP'
      stop
 420  continue
      ic=ic-1  
      if(ic.ne.nbasis) stop 968

      ipr=1
       inovel=0
      do 123 i=1,nbasis
      lim=ncont(i)
      ncia=ncont(i)
      if(msc(i).eq.-2) then
         if(inovel.eq.0) then
         lim=lim+ncia
         endif
       inovel=inovel+1
       if(inovel.eq.5)inovel=0
      endif
      if(msc(i).eq.-3) then
         if(inovel.eq.0) then
         lim=lim+3*ncia
         endif
       inovel=inovel+1
       if(inovel.eq.7)inovel=0
      endif
      do 123 j=1,lim
      iat(ipr)=iatc(i)
      ipr=ipr+1
 123  continue   
      ipr=ipr-1
 
      ifill(1)=1
      ifiul(1)=ncont(1)
      if(msc(1).eq.-2.or.msc(1).eq.-3)then
        print *,"The first shell must not be a pure D or F one!"
        stop
      endif
      inovel=0 
      do 423 i=2,nbasis
      if(msc(i).eq.-2) then
         iop(8)=1
         if(inovel.le.2) then
           ifill(i)=ifiul(i-1)+1
           ifiul(i)=ifill(i)+ncont(i)-1
           goto 441
         endif
         if(inovel.eq.3) then
           ifill(i)=ifiul(i-1)+1
           ifiul(i)=ifill(i)+2*ncont(i)-1
           goto 441
         endif
         if(inovel.eq.4) then
           ifill(i)=ifill(i-1)
           ifiul(i)=ifill(i)+3*ncont(i)-1 
           goto 441
         endif
 441   inovel=inovel+1
         if(inovel.eq.5)inovel=0
      goto 423
      endif
      if(msc(i).eq.-3) then 

        if(inovel.eq.0.or.inovel.eq.2.or.inovel.eq.4) then
          ifill(i)=ifiul(i-1)+1
          ifiul(i)=ifill(i)+3*ncont(i)-1
          goto 442
        endif
        if(inovel.eq.1.or.inovel.eq.3.or.inovel.eq.5) then
          ifill(i)=ifill(i-1)+1
          ifiul(i)=ifill(i)+2*ncont(i)-1
          goto 442
        endif
        if(inovel.eq.6) then
          ifill(i)=ifiul(i-1)+1
          ifiul(i)=ifill(i)+ncont(i)-1
          goto 442
        endif
 442     inovel=inovel+1
         if(inovel.eq.7) inovel=0
      goto 423 
      endif
      ifill(i)=ifiul(i-1)+1
      ifiul(i)=ifill(i)+ncont(i)-1
 423  continue   
      if(ifiul(nbasis).ne.ipr)stop 7865 

     
      iexp=1
      ipr=1
      do 124 i=1,ncshell
      if(mssh(i).eq.0)then
      do 427 ll=1,mnsh(i)
      do 425 j=1,nsh(i)  
      expp(ipr)=expsh(iexp)
 425  ipr=ipr+1
      iexp=iexp+1
 427  continue 
      goto 124
      endif

      if(mssh(i).eq.1.or.mssh(i).eq.-1.or.mssh(i).eq.2.or.
     $   mssh(i).eq.3)then

       isr=ipr
      do 1778 kk=1,mnsh(i)
      expa=expsh(iexp)
      do 1777 j=1,nsh(i)
 1777 expp(isr+(j-1)*mnsh(i))=expa
      isr=isr+1
      iexp=iexp+1
 1778  continue
      ipr=ipr+nsh(i)*mnsh(i)
      goto 124
      endif

      if(mssh(i).eq.-2) then    
       isr=ipr
       inovel=0
      do 2778 kk=1,mnsh(i)
      expa=expsh(iexp)
      lim=nsh(i)+1
         if(inovel.eq.0) then
c         lim=lim+1
         endif
       inovel=inovel+1
       if(inovel.eq.5)inovel=0
      do 2777 j=1,lim   
 2777 expp(isr+(j-1)*mnsh(i))=expa
      isr=isr+1   
      iexp=iexp+1
 2778  continue
      ipr=ipr+lim*mnsh(i)
      goto 124
      endif

      if(mssh(i).eq.-3) then    
       isr=ipr
       inovel=0
      do 3778 kk=1,mnsh(i)
      expa=expsh(iexp)
      lim=nsh(i)+3
         if(inovel.eq.0) then
c         lim=lim+3
         endif
       inovel=inovel+1
       if(inovel.eq.7)inovel=0
      do 3777 j=1,lim   
 3777 expp(isr+(j-1)*mnsh(i))=expa
      isr=isr+1   
      iexp=iexp+1
 3778  continue
      ipr=ipr+lim*mnsh(i)
      goto 124
      endif

      stop 2222
 124  continue
      ipr=ipr-1


      do 77 i=1,nat
      ivan=0
      do 78 k=1,nbasis
      if(iatc(k).eq.i) then
       if(ivan.eq.0)llim(i)=k
       ivan=1
      endif
      if(ivan.eq.1.and.iatc(k).ne.i)then
       iulim(i)=k-1
       ivan=0
      endif
   78 continue
   77 continue
      iulim(nat)=nbasis

      kk=1
      jj=1
      ipr=1
      do 224 i=1,ncshell
      mmm=mnsh(i)
      if(mssh(i).eq.0)then
      do 225 ll=1,mnsh(i)
      coeff(kk,ll)=c1(jj)
 225  jj=jj+1
      kk=kk+1
      ipr=ipr+mmm 
      goto 224
      endif

      if(mssh(i).eq.1)then
      do 223 ll=1,mnsh(i)
      mmm=mnsh(i)
      coeff(kk,ll)=c1(jj)
      coeff(kk+1,ll)=c1(jj)
      coeff(kk+2,ll)=c1(jj)
      n(ipr+ll-1)=1
      l(ipr+mmm+ll-1)=1
      m(ipr+2*mmm+ll-1)=1
 223  jj=jj+1
      kk=kk+3
      ipr=ipr+3*mmm
      goto 224
      endif

      if(mssh(i).eq.2)then
      do 323 ll=1,mnsh(i)
      mmm=mnsh(i)
      coeff(kk,ll)=c1(jj)
      coeff(kk+1,ll)=c1(jj)
      coeff(kk+2,ll)=c1(jj)
      coeff(kk+3,ll)=c1(jj)
      coeff(kk+4,ll)=c1(jj)
      coeff(kk+5,ll)=c1(jj)
      n(ipr+ll-1)=2
      l(ipr+mmm+ll-1)=2
      m(ipr+2*mmm+ll-1)=2
      n(ipr+3*mmm+ll-1)=1
      l(ipr+3*mmm+ll-1)=1
      n(ipr+4*mmm+ll-1)=1
      m(ipr+4*mmm+ll-1)=1
      l(ipr+5*mmm+ll-1)=1
      m(ipr+5*mmm+ll-1)=1
 323  jj=jj+1
      kk=kk+6
      ipr=ipr+6*mmm
      goto 224
      endif

      if(mssh(i).eq.3)then
      do 523 ll=1,mnsh(i)
      mmm=mnsh(i)
      coeff(kk,ll)=c1(jj)
      coeff(kk+1,ll)=c1(jj)
      coeff(kk+2,ll)=c1(jj)
      coeff(kk+3,ll)=c1(jj)
      coeff(kk+4,ll)=c1(jj)
      coeff(kk+5,ll)=c1(jj)
      coeff(kk+6,ll)=c1(jj)
      coeff(kk+7,ll)=c1(jj)
      coeff(kk+8,ll)=c1(jj)
      coeff(kk+9,ll)=c1(jj)
      n(ipr+ll-1)=3
      l(ipr+mmm+ll-1)=3
      m(ipr+2*mmm+ll-1)=3
      n(ipr+3*mmm+ll-1)=1
      l(ipr+3*mmm+ll-1)=2
      n(ipr+4*mmm+ll-1)=2
      l(ipr+4*mmm+ll-1)=1
      n(ipr+5*mmm+ll-1)=2
      m(ipr+5*mmm+ll-1)=1
      n(ipr+6*mmm+ll-1)=1
      m(ipr+6*mmm+ll-1)=2
      l(ipr+7*mmm+ll-1)=1
      m(ipr+7*mmm+ll-1)=2
      l(ipr+8*mmm+ll-1)=2
      m(ipr+8*mmm+ll-1)=1
      n(ipr+9*mmm+ll-1)=1
      l(ipr+9*mmm+ll-1)=1 
      m(ipr+9*mmm+ll-1)=1
 523  jj=jj+1
      kk=kk+10
      ipr=ipr+10*mmm
      goto 224
      endif

      if(mssh(i).eq.-1)then
      do 226 ll=1,mnsh(i)
      mmm=mnsh(i)
      coeff(kk,ll)=c1(jj)
      n(ipr+mmm+ll-1)=1
      l(ipr+2*mmm+ll-1)=1
      m(ipr+3*mmm+ll-1)=1
      coeff(kk+1,ll)=c2(jj)
      coeff(kk+2,ll)=c2(jj)
      coeff(kk+3,ll)=c2(jj)
 226  jj=jj+1
      kk=kk+4
      ipr=ipr+4*mmm
      goto 224
      endif

      if(mssh(i).eq.-2) then
       do 326 ll=1,mnsh(i)
       mmm=mnsh(i)
         coeff(kk,ll)=c1(jj)
         n(ipr+ll-1)=1
         m(ipr+ll-1)=1

         coeff(kk+1,ll)=c1(jj)
         l(ipr+mmm+ll-1)=1
         m(ipr+mmm+ll-1)=1

         coeff(kk+2,ll)=c1(jj)
         n(ipr+2*mmm+ll-1)=1
         l(ipr+2*mmm+ll-1)=1


         coeff(kk+3,ll)=c1(jj)
         coeff(kk+3,ll+mmm)=-c1(jj) 
         n(ipr+3*mmm+ll-1)=2

         coeff(kk+4,ll)=-c1(jj)/dsqrt(3.d0)
         coeff(kk+4,ll+mmm)=-c1(jj)/dsqrt(3.d0)
         coeff(kk+4,ll+2*mmm)=2.d0*c1(jj)/dsqrt(3.d0)
         l(ipr+4*mmm+ll-1)=2
         m(ipr+5*mmm+ll-1)=2

 326  jj=jj+1
      kk=kk+5
      ipr=ipr+6*mmm
      goto 224
       endif   

      if(mssh(i).eq.-3) then
       do 426 ll=1,mnsh(i)
       mmm=mnsh(i)
       coeff(kk,ll)=dc11*c1(jj)
       coeff(kk,ll+1)=-dc12/4.d0*c1(jj)
       coeff(kk,ll+2)=-dc11/4.d0*c1(jj)

       coeff(kk+1,ll)=dc41*c1(jj)
       coeff(kk+1,ll+1)=-dc42*c1(jj)

       coeff(kk+2,ll)=dc11*c1(jj)
       coeff(kk+2,ll+1)=-dc11/4.d0*c1(jj)
       coeff(kk+2,ll+2)=-dc12/4.d0*c1(jj)

       coeff(kk+3,ll)=dc42*c1(jj)
       coeff(kk+3,ll+1)=-dc41*c1(jj)

       coeff(kk+4,ll)=c1(jj)*dsqrt(5.d0)
       coeff(kk+4,ll+1)=-3.d0/2.d0*c1(jj)
       coeff(kk+4,ll+2)=-3.d0/2.d0*c1(jj)

       coeff(kk+5,ll)=-dc21*c1(jj)
       coeff(kk+5,ll+1)=dc21*c1(jj)

       coeff(kk+6,ll)=c1(jj)

      n(ipr+ll-1)=1
      m(ipr+ll-1)=2

      n(ipr+mmm+ll-1)=3

      n(ipr+2*mmm+ll-1)=1
      l(ipr+2*mmm+ll-1)=2

      l(ipr+3*mmm+ll-1)=1
      m(ipr+3*mmm+ll-1)=2

      n(ipr+4*mmm+ll-1)=2
      l(ipr+4*mmm+ll-1)=1

      l(ipr+5*mmm+ll-1)=3

      m(ipr+6*mmm+ll-1)=3

      l(ipr+7*mmm+ll-1)=2
      m(ipr+7*mmm+ll-1)=1

      n(ipr+8*mmm+ll-1)=2
      m(ipr+8*mmm+ll-1)=1

      n(ipr+9*mmm+ll-1)=1
      l(ipr+9*mmm+ll-1)=1 
      m(ipr+9*mmm+ll-1)=1

 426  jj=jj+1
      kk=kk+7
      ipr=ipr+10*mmm
      goto 224
      endif   

       stop 400
 224  continue
      
      ipr=ipr-1

 111  format(5E16.8)

      do j=1,nbasis
      imap(j)=j
      enddo

      isajat=0

      if(isajat.eq.1)then

      
      ktt=0
       do 13 j=1,nbasis
       i=1
 12    if(msc(i).eq.-2) then
c       print *,"msc",i,msc(i)
          cc(1)=c(i+1,j)
          cc(2)=c(i+2,j)
          cc(3)=c(i+4,j)
          cc(4)=c(i+3,j)
          cc(5)=c(i,j)
          do 14 k=1,5
 14       c(i+k-1,j)=cc(k)
          i=i+5
          if(i.gt.nbasis)goto 13	
          go to 12
          else
c       print *,"msc",i,msc(i)
          i=i+1
          if(i.gt.nbasis)goto 13	
          goto 12
           endif
  13      continue        

         endif

         if(isajat.eq.0)then
         do 213 j=1,ncshell
         if(mssh(j).eq.-2)then
         i=iaos(j)-1
         imap(i+1)=i+2
         imap(i+2)=i+3
         imap(i+3)=i+5
         imap(i+4)=i+4
         imap(i+5)=i+1
          endif
         continue
 213  continue
 613    format(25i3)
           endif

      ktt=0
       do 113 j=1,nbasis
       i=1
 112   if(msc(i).eq.-3) then
c       print *,"msc",i,msc(i)
          cc(1)=c(i+1,j)
          cc(2)=c(i+5,j)
          cc(3)=c(i+2,j)
          cc(4)=c(i+6,j)
          cc(5)=c(i,j)
          cc(6)=c(i+3,j)
          cc(7)=c(i+4,j)
          do 114 k=1,7
 114      c(i+k-1,j)=cc(k)
          i=i+7
          if(i.gt.nbasis)goto 113	
          go to 112
          else
c       print *,"msc",i,msc(i)
          i=i+1
          if(i.gt.nbasis)goto 113	
          goto 112
           endif
 113      continue        

      print *,'nocc',nocc,'    nalpha',nalf,'    nbeta',nb
      print *,' '
c     print *,' E(SCF)=',escf
      print *,' '

 61   format(3D20.10)
 65   format(20i4)
 666  format(10f8.5)
       ifg=ipr
 617  format(45i2)
 618  format(4i4)
c     print *,'5'
     
      print *,' ipr=',ipr
c     print *,' msc',(msc(i),i=1,ipr)

      kt=0
      do 15 i=1,ipr
      if(msc(i).ne.-2) goto 15   
      kt=kt+1
      if(kt.eq.4) ncont(i)=2*ncont(i)
      if(kt.eq.5) then 
        ncont(i)=3*ncont(i)
        kt=0
      endif 
 15   continue

c     print *,'6'
      kt=0
      do 16 i=1,ipr
      if(msc(i).ne.-3) goto 16   
      kt=kt+1
      if(kt.eq.1.or.kt.eq.3.or.kt.eq.5) ncont(i)=3*ncont(i)
      if(kt.eq.2.or.kt.eq.4.or.kt.eq.6) ncont(i)=2*ncont(i)
      if(kt.eq.7) kt=0
 16   continue
      
c     print *,'7'
      i=1
       do 712 ii=1,ncshell
      if(mssh(ii).eq.1) then
       do  k=1,mnsh(ii)
      c2(i)=c1(i)
      c1(i)=0.d0
       i=i+1
       enddo
       else
       i=i+mnsh(ii)
      endif
 712   continue
c     print *,'8'

c      ii=1
c      do 711 i=1,ncshell
c     msi=iabs(mssh(i))
c      do j=1,mnsh(i)
c     if(msi.eq.2) c1(ii)=c1(ii)*anorm(2,0,0,expsh(ii))
c      ii=ii+1
c      enddo
c711   continue
      ii=1
       do 711 i=1,ncshell
      msi=iabs(mssh(i))
       do j=1,mnsh(i)
      if(msi.le.1) c1(ii)=c1(ii)*anorm(0,0,0,expsh(ii))
      if(msi.eq.1) c2(ii)=c2(ii)*anorm(1,0,0,expsh(ii))
      if(msi.eq.2) c1(ii)=c1(ii)*anorm(2,0,0,expsh(ii))
c     if(msi.eq.2) print *, ' d-re',anorm(2,0,0,expsh(ii))
       ii=ii+1
       enddo
 711   continue
c     print *,'9'

      print *,'    Nbasis=',nbasis
      return
 1000 stop 1000
      end
 

C
C
C
      subroutine start
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (maxp=4000,maxg=1000,maxc=16,maxat=200) 
      parameter (ndeckl=882)
      parameter (mgmax=1 000 000)
      parameter (nmax=1000)
      data PI/3.141592653589793D0/
      common /stv/ sp(ndeckl,ndeckl)
c    ,tt(ndeckl,ndeckl)
c    $    ,         vv(ndeckl,ndeckl,maxat)
      common /nat/ nat,igr,ifg,idum(4)
c     common /fnutab/f(2505,13)
c     common /intertab/d1,d2,d3,d4

      common /data/expp(maxp),n(maxp),l(maxp),m(maxp),iat(maxp),
     $   ifill(maxg),ifiul(maxg)
      common /coeff/coeff(maxg,maxc)
      common /lim/ llim(nmax),iulim(nmax)
      common /cont/ ncont(maxg)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      common /pr/iprint
      common/npsh/npshell
c     dimension d1(2504,13),d2(2503,13),d3(2502,13),d4(2501,13)
c      data bohr/0.52917715D+00/
c      data bohr/0.52917706D+00/


      PQ(iata,jatb,ipr,jpr,kcart)
     $ =(expp(ipr)*coord(kcart,iata)+
     $      expp(jpr)*coord(kcart,jatb))/(expp(ipr)+expp(jpr))
   
      print *,' init-et hivja'
      call init
      print *,' input-ot hivja'
      call input


      print *,"Number of atoms:",nat
      print *,"Number of primitives:",ifg
      print *,"Number of basis functions:",igr

c the renormalization of contraction coefficients
         
       do 700 i=1,igr
       do 701 ic=1,ncont(i)
      ipr=ifill(i)+ic-1
      qi=anorm(n(ipr),l(ipr),m(ipr),expp(ipr))
c      print *,qi
      coeff(i,ic)=coeff(i,ic)*qi 
 701   continue
 700   continue


c      print *,'  sajat reszben'
       do 400 i=1,igr
c        if(ncont(i).eq.1) goto 444
        finorm=0.d0
       do 401 ic=1,ncont(i)
      ipr=ifill(i)+ic-1
        do 403 jc=1,ncont(i)
       jpr=ifill(i)+jc-1         
        finorm=finorm+
     $  coeff(i,ic)*S(n(ipr),l(ipr),m(ipr),n(jpr),l(jpr),m(jpr),
     $  expp(ipr),expp(jpr),0.d0,0.d0,0.d0,0.d0,0.d0,0.d0,0.d0)*
     $  coeff(i,jc)
 403    continue
 401   continue
       do 404 ic=1,ncont(i)
c      print *,' finorm', finorm
 404       coeff(i,ic)=coeff(i,ic)/dsqrt(finorm)
c404   print *,i,ic,coeff(i,ic) 
c444   do 445 ic=1,ncont(i)
c445   continue       
 400   continue

      
       do 600 iatt=1,nat
      ncsi=iulim(iatt)-llim(iatt)+1
       do 601 jatt=1,nat
      ncsj =iulim(jatt)-llim(jatt)+1
       do 602 i=1,ncsi 
      igr=llim(iatt)+i-1 
      ngri=ifiul(igr)-ifill(igr)+1
       il=1
       if(iatt.eq.jatt)il=i
       do 603 j=il,ncsj
      atfed1=0.d0
      enkin1=0.d0
      jgr=llim(jatt)+j-1 
      ngrj=ifiul(jgr)-ifill(jgr)+1
       do 604 ki=1,ngri
      ipr=ifill(igr)+ki-1
       do 605 kj=1,ngrj
      jpr=ifill(jgr)+kj-1
      PAX=(coord(1,jatt)-coord(1,iatt))*expp(jpr)/
     $     (expp(ipr)+expp(jpr))        
      PBX=(coord(1,iatt)-coord(1,jatt))*expp(ipr)/
     $     (expp(jpr)+expp(ipr))        
      PAY=(coord(2,jatt)-coord(2,iatt))*expp(jpr)/
     $     (expp(ipr)+expp(jpr))        
      PBY=(coord(2,iatt)-coord(2,jatt))*expp(ipr)/
     $     (expp(jpr)+expp(ipr))        
      PAZ=(coord(3,jatt)-coord(3,iatt))*expp(jpr)/
     $     (expp(ipr)+expp(jpr))        
      PBZ=(coord(3,iatt)-coord(3,jatt))*expp(ipr)/
     $     (expp(jpr)+expp(ipr))        
      atfed=S(n(ipr),l(ipr),m(ipr),n(jpr),l(jpr),m(jpr),expp(ipr),
     $ expp(jpr),ab2(iatt,jatt),PAX,PBX,PAY,PBY,PAZ,PBZ)
      atfed1=atfed1+coeff(igr,ki)*atfed*coeff(jgr,kj)

c computation of the kinetic energy

c     enkin=T(n(ipr),l(ipr),m(ipr),n(jpr),l(jpr),m(jpr),expp(ipr),
c    $ expp(jpr),ab2(iatt,jatt),PAX,PBX,PAY,PBY,PAZ,PBZ)
c     enkin1=enkin1+coeff(igr,ki)*enkin*coeff(jgr,kj)  
  605  continue 
  604  continue 
       sp(igr,jgr)=atfed1 
       sp(jgr,igr)=atfed1 
c      tt(igr,jgr)=enkin1
c      tt(jgr,igr)=enkin1 
  603  continue    
  602  continue    
  601  continue    
  600  continue    



 3000 return       
      end 


      function AB2(iata,jatb)
      implicit real*8(a-h,o-z)
      PARAMETER (maxp=4000,maxg=1000,maxc=16,maxat=200)
      common /coord/ coord(3,maxat),zn(maxat),iatf(maxat)
      diff=0.d0
      do k=1,3
        diff=diff+(coord(k,iata)-coord(k,jatb))**2
      enddo
      AB2=diff
      return
      end

       subroutine prdist(c,n,nacel,il,iu)
       implicit real*8(a-h,o-z)
       parameter (maxat=200)
       dimension c(3,maxat),dist(maxat,maxat)
c      if(nacel.gt.8)return
       print *,'  '
       print *,'  '
       print *,'       DISTANCE MATRIX'
       print *,'  '
c       print *, 'tot. N',n
c      write(*,62)(ii,ii=il,iu)
  62   format(3x,8i9)
c      print *,' xxxx '
       do 1 j=1,n
       do 2 i=il,iu
  2    dist(j,i)=dsqrt((c(1,i)-c(1,j))**2+
     $ (c(2,i)-c(2,j))**2+(c(3,i)-c(3,j))**2)
c      write(*,61)j,(dist(j,i),i=il,iu)
c 61   format(i4,8f9.4)

   1    continue
       call mprintb(dist,n,maxat)
        return
       end
