      subroutine border(PA,PB,S,illim,iulim,natoms,nbasis)
      implicit real*8(a-h,o-z)
      parameter (maxat=100,ndeck=2000)
      dimension pa(ndeck,ndeck),pb(ndeck,ndeck),rindex(maxat,maxat)
      dimension tindex(maxat),diag(maxat),illim(ndeck),iulim(ndeck)
      dimension pas(ndeck,ndeck),pbs(ndeck,ndeck),ps(ndeck,ndeck)
      dimension s(ndeck,ndeck),spin(maxat) 
c     character*4 kiir1(4),kiir2(4) 
      dimension kiir1(4),kiir2(4),kisp1(4),kisp2(4) 
      EQUIVALENCE(PS(1,1),PAS(1,1))
      common /ia/ia(maxat),kop,idummy 
      integer uli,ulj 

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
       data kiir1/'  AT','OM  ','VALE','NCE '/
       data kiir2/' ATO','M   ','VALE','NCE '/
       data kisp1/'  AT','OM  ','SPIN',' D. '/
       data kisp2/' ATO','M   ','SPIN',' D. '/
c
C
c
C  CALCULATING BOND-ORDER AND VALENCE INDICES ACCORDING TO
C  I. MAYER, CHEM.PHYS.LETT.97,270 (1983) and 117,396 (1985)
C  - see also TCA 67, 315 (1985), IJQC 29, 73,477 (1986)  
C
C
c
 666  FORMAT(1H1,5X,'CALCULATION OF BOND ORDER AND VALENCE INDICES ',
     $'ACCORDING TO: I.MAYER, CHEM.PHYS.LETT. 97,270 (1983)'//
     $' (MODIFIED ACCORDING TO I.MAYER, ibid. 117,396 (1985)'//)
      IF(kop.EQ.0) WRITE (*,62)
      IF(kop.NE.0) WRITE (*,63)
  62  FORMAT(1X,'CLOSED-SHELL SYSTEM'/)
  63  FORMAT(1X,'OPEN-SHELL SYSTEM'/)
      IF(kop.EQ.0) GOTO 22
      GO TO 222
C
C
C  TAKE MATRIX PRODUCT P*S
C
  22  DO 4 I=1,nbasis
      DO 4 J=1,nbasis
      X=0.0D0
      DO 105 K=1,nbasis
 105  X=X+PA(I,K)*S(K,J)
  4   PS(I,J)=X
      GO TO 444
C
C  OPEN SHELL CASE: TAKE MATRIX PRODUCTS PA*S, PB*S
C
 222  DO 441 I=1,nbasis
      DO 441 J=1,nbasis
      X=0.0D0
      Y=0.0D0
      DO 551 K=1,nbasis
      X=X+PA(I,K)*S(K,J)
  551 Y=Y+PB(I,K)*S(K,J)
      PBS(I,J)=Y
  441 PAS(I,J)=X
      GOTO 555
C  BOND-ORDER INDICES
C   JAV. DEFINICIO!!
C     NA1=NATOMS-1
 444  DO 6 I=1,NATOMS
      DO 6 J=I,NATOMS
      X=0.0D0
      LLI=ILLIM(I)
      ULI=IULIM(I)
      LLJ=ILLIM(J)
      ULJ=IULIM(J)
      DO 7 ILAM=LLI,ULI
      DO 7 IOM=LLJ,ULJ
  7   X=X+PS(ILAM,IOM)*PS(IOM,ILAM)
      rindex(I,J)=X
  6   rindex(J,I)=X
      DO 8 I=1,NATOMS
      DIAG(I)=rindex(I,I)
  8   rindex(I,I)=0.0D0
      GO TO 124
C
 555  DO 16 I=1,NATOMS
      DO 16 J=I,NATOMS
      X=0.0D0
      LLI=ILLIM(I)
      ULI=IULIM(I)
      LLJ=ILLIM(J)
      ULJ=IULIM(J)
      IF(I.EQ.J) GOTO 143
      DO 17 ILAM=LLI,ULI
      DO 17 IOM=LLJ,ULJ
  17   X=X+PAS(ILAM,IOM)*PAS(IOM,ILAM)+PBS(ILAM,IOM)*PBS(IOM,ILAM)
      X=X+X
      GOTO 147
 143  DO 756 ILAM=LLI,ULI
      DO 756 IOM=LLI,ULI
 756  X=X+(PAS(ILAM,IOM)+PBS(ILAM,IOM))*(PAS(IOM,ILAM)
     $   +PBS(IOM,ILAM))
 147  rindex(I,J)=X
  16  rindex(J,I)=X
      DO 18 I=1,NATOMS
      DIAG(I)=rindex(I,I)
  18  rindex(I,I)=0.0D0
C
C  PRINTING THE MATRIX OF THE BOND ORDERS
C
  124 WRITE(*,6342)
 6342 FORMAT(1x,/20X,'BOND ORDER MATRIX'//)
      CALL Mprint(rindex,NATOMS,maxat)
C
C CALCULATION OF THE VALENCE NUMBERS
C
      DO 9 I=1,NATOMS
      X=0.D0
      DO 10 J=1,NATOMS
  10  X=X+rindex(I,J)
  9   rindex(I,I)=X
      IF(kop.NE.0)then 
      do i=1,natoms 
      tindex(i)=rindex(i,i)
      enddo
      endif

      kmin1=min0(natoms,5)-1
 123  format(20A4)      

      WRITE(*,621)
      IF(kop.EQ.0)then 
      write(*,123)(kiir1(j),j=1,4),((kiir2(j),j=1,4),i=1,kmin1)
      write(*,640) (I,mend(ia(i)),rindex(I,I),I=1,NATOMS)
      endif
  64  FORMAT(//25X,'ACTUALLY USED IN BONDS',/)
 640  format(20(I3,A4,F8.5,4(I3,A4,1X,f8.5)/))
 611  FORMAT(//20X,'VALENCE NUMBERS: TOTAL ACTUAL VALUES'/)
 621  FORMAT(//35X,'VALENCES'/)
 612  FORMAT(//30X,'FREE VALENCES',/)
      IF(kop.EQ.0) goto 1234
      DO 32 I=1,NATOMS
      X=0.0D0
      ILI=ILLIM(I)
      ULI=IULIM(I)
      DO 33 J=ILI,ULI
  33  X=X+PAS(J,J)+PBS(J,J)
  32  DIAG(I)=2.D0*X-DIAG(I)
      WRITE(*,611)
      write(*,123)(kiir1(j),j=1,4),((kiir2(j),j=1,4),i=1,kmin1)
      write(*,640)(I,mend(ia(i)),DIAG(I),I=1,NATOMS)
      WRITE(*,64) 
      write(*,123)(kiir1(j),j=1,4),((kiir2(j),j=1,4),i=1,kmin1)
      Write(*,640)  (I,mend(ia(i)),tindex(I),I=1,NATOMS)
      DO 34 I=1,NATOMS
  34  DIAG(I)=DIAG(I)-tindex(I)
      WRITE(*,612) 
      write(*,123)(kiir1(j),j=1,4),((kiir2(j),j=1,4),i=1,kmin1)
      write(*,640) (I,mend(ia(i)),DIAG(I),I=1,NATOMS)
      do i=1,natoms
      x=0.d0
      do mu=illim(i),iulim(i)
      do nu=illim(i),iulim(i)
      x=x+(pas(mu,nu)-pbs(mu,nu))*(pas(nu,mu)-pbs(nu,mu))
      enddo
      enddo
      tindex(i)=x-diag(i)
      enddo
      print *,' '
      print *,' '
      print *,' '
      print *,' Control - should be zeros for single determinants'
      print *,' '
      write(*,123)(kiir1(j),j=1,4),((kiir2(j),j=1,4),i=1,kmin1)
      write(*,640) (I,mend(ia(i)),tindex(I),I=1,NATOMS)
      print *,' '
      print *,' '
      print *,' Trace alpha, beta:'
      x=0.d0
      y=0.d0
      do mu=1,nbasis
      x=x+pas(mu,mu)
      y=y+pbs(mu,mu)
      enddo
      print 71, x, y
 71   format(2f15.5)
      print *,' '
      Print *,' The following part is valid for single determinants ',
     $ '(HF or KS), only!'
      print *,' '
      y=0.d0
      do i=1,natoms
      x=0.d0
      do mu=illim(i),iulim(i)
      x=x+(pas(mu,mu)-pbs(mu,mu))
      enddo
      spin(i)=x
      y=y+x
      enddo
      

      print *,' Atomic spin densities:'
      print *,' '
      write(*,123)(kisp1(j),j=1,4),((kisp2(j),j=1,4),i=1,kmin1)
      write(*,640) (I,mend(ia(i)),spin(I),I=1,NATOMS)
      print *,' '
      print *, ' Sum=',y      
      print *,' '
      print *,' Decomposition of <S^2> :'
      print *,' (according to I. Mayer, Chem.Phys.Lett. 440, 357, 2007)'
      print *,' '
      do i=1,natoms
      rindex(i,i)=0.5d0*diag(i)+0.25d0*spin(i)**2
      do j=1,natoms
      if(i.ne.j)then
      x=0.d0
      do mu=illim(i),iulim(i)
      do nu=illim(j),iulim(j)
      x=x+(pas(mu,nu)-pbs(mu,nu))*(pas(nu,mu)-pbs(nu,mu))
      enddo
      enddo
      rindex(i,j)=0.5d0*x+0.25d0*spin(i)*spin(j)
       endif     
      enddo
      enddo

      CALL Mprint(rindex,NATOMS,maxat)
      x=0.d0
      do i=1,natoms
      do j=1,natoms
      x=x+rindex(i,j)
      enddo
      enddo
      print *,' '
      print *, ' <S^2>=',x



 1234 continue
      return
      end

