c     
c     
c                        Program BO-SPIN Version 1.01
c                        ----------------------------
c
c                                I. Mayer 
c            Chemical Research Center, Hungarian Academy of Sciences
c                    H-1515 Budapest, P.O.Box 17, Hungary
c
c             e-mail: mayer@chemres.hu
c
c ------------------------------------------------------------------------
c   This program performs decomposition of the spin-square expectation
c   value <S^2> for single determinant wave function in accord with
c   
c   This program is a special large dimensions version of the programs by 
C   I. Mayer and A. Hamza performing *a posteriori* analysis of the single 
C   determinant Hartree-Fock ab initio wave wave functions produced by the 
c   widely used "Gaussian" system G92, G94, G98, G03. (For DFT-type wave 
c   functions - actulally B3LYP - the HF-like energy of the single determinant 
c   built up of the Kohn-Sham orbitals can be considered.) 
c
c   This version performs only
c
c   Bond order and valence analysis (I. Mayer, Chem. Phys. Lett. 97, 270 
c   1983; addendum for open shells: Chem. Phys. Lett. 117, 396, 1985, etc.);
c   
c   This program is applicable up to 2000 basis orbitals. It is easily
c   be extended further, by increasing all the "parameters" which are = 2000 
c   to some larger value. The parameters set =10000 should be increased 
c   proportionally.
c   
c
c   For other programs of the suite, performing also energy partitioning
c   and "fyzzy atoms" analysis see the web-site
c
c             http://occam.chemres.hu/programs
c
c   This program uses routines from the program APOST by I. Mayer and
c   A. Hamza - see the web-site indicated. 
c
C   The basic bond order routine used here was written in 1982/83 by I. Mayer.
c
c  
c
c
      implicit real*8(a-h,o-z)
      common iop(45)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      
      parameter (nmax=2000)
      parameter (maxat=100)
      parameter (maxat1=101)
      parameter (maxp=10000)
      parameter (ndeckl=2000)
      common /lim/ llim(nmax),iulim(nmax)
      dimension sam(ndeckl,ndeckl)
      dimension h(ndeckl,ndeckl)
c     dimension pmul(maxat)
      common /c/c(ndeckl,ndeckl),p(ndeckl,ndeckl)
      common /pointer/ipoint(maxat),ijpoint(maxat,maxat),na(maxat)     
      common /coord/ coord(3,maxat),zn(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(ndeckl,ndeckl),t(ndeckl,ndeckl)
c    $             ,vv(ndeckl,ndeckl,maxat)
      common /ia/iznuc(maxat),kop,megall

      common/comp/ecomp1(maxat,maxat)
      common /map/imap(maxp),imapsav(maxp)


      call kiir
      call start
 

      m=igr

      call getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      if(nat.ne.natoms) stop 7584
      if(m.ne.nbas) stop 7585

      ng=0
      do i=1,natoms
      ipoint(i)=ng+1
      ng=ng+na(i)**4
      enddo
      ijpoint(1,2)=ng+1
      maxx=0
      do i=1,natoms-1
      do j=i+1,natoms
      maxx=max0(maxx,na(i)+na(j))
      enddo
      enddo

      
      call getcore(ndeckl,nbas,natoms,h)
      

      Print *, 'IUHF=',iuhf


      if(nalf.ne.nb.or.iuhf.eq.1) then
      kop=1

c      write(42,41)((s(i,j),i=1,igr),j=1,igr)
c 41   format(6f12.9)
      call enpo(na,ipoint,ijpoint) 
      stop
      endif


      call pm(c,nocc,nbas,p,ndeckl)
      call border(P,sam,S,llim,iulim,natoms,nbas)
      stop


      end 

      subroutine getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      implicit real*8(a-h,o-z)
      parameter (n128=2000)
      dimension llim(n128),iulim(n128),na(maxat)
      NATOMS=0
      NBAS=0
      DO 3 I=1,n128
      IF(iulim(I).GT.0) NATOMS=I
  3   NBAS=iulim(natoms)
       if(natoms.gt.maxat)then
      write(*,*)'   TOO MANY ATOMS, STOP'
      stop
       endif
      if(natoms.eq.1) then
      write(*,*)'  ONLY ONE ATOM'
      stop  
      endif
      nnn=0
      do 4 i=1,natoms
      na(i)=iulim(i)-llim(i)+1
  4   nnn=nnn+na(i)
      if(nnn.ne.nbas)stop 1212
      nnab=(natoms*(natoms-1))/2
      if(nnab*2.ne.natoms*(natoms-1))stop 1213

      print *,'   '
      write(*,*)natoms,' ATOMS, ',nnab,' ATOMIC PAIRS'
      
      end

      subroutine getcore(ndeckl,nbas,natoms,h)
      implicit real*8(a-h,o-z)
      parameter (maxat=100)
      parameter (ndeck=2000) 
      parameter (maxp=10000)
      common /stv/ s(ndeck,ndeck),t(ndeck,ndeck) 
      dimension h(ndeckl,ndeckl)
      common /map/imap(maxp),imapsav(maxp)
      m=nbas

c     write(*,51)(imap(i),i=1,m)
c 51  format(15i3)
     
      do i=1,m
      imapsav(i)=imap(i)
      enddo
      
       do 21 j=1,m
       jj=imap(j)
       do 21 i=1,m
        ii=imap(i)
   21  h(jj,ii)=t(j,i)
       do 31 i=1,m
       do 31 j=1,m
   31  t(j,i)=h(j,i)
       
       do 121 j=1,m
       jj=imap(j)
       do 121 i=1,m
        ii=imap(i)
  121  h(jj,ii)=s(j,i)
       do 131 i=1,m
       do 131 j=1,m
  131  s(j,i)=h(j,i)
       
  61  format(1x,8f9.6)

       return
       end


      subroutine pm(c,nocc,m,p,ndeckl)  
      implicit real*8(a-h,o-z)
      dimension c(ndeckl,ndeckl),p(ndeckl,ndeckl)
       do 1 i=1,m
       do 1 j=1,m
       x=0.d0
       do 2 k=1,nocc
  2     x=x+c(i,k)*c(j,k)
  1    p(i,j)=2.d0*x

  61  format(1x,8f9.7)

       return
       end


   
      SUBROUTINE MPRINT(H,N,ndim)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION H(NDIM,NDIM)
      parameter (maxat=100)
      common /ia/ia(maxat),kkk,idummy

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
    
      K=8 
   65 FORMAT(1H0,40X,A4/)
      NMIN=1
      NMAX=MIN0(N,K)
   62 FORMAT(1X,I3,A4,8F9.4)
   1  PRINT 61, (I, mend(ia(i)),I=NMIN,NMAX)
   61 FORMAT(10X,8(1X,I3,A4,1X))
      PRINT 64
   64 FORMAT(1X)
      DO 2 I=1,N
      PRINT 62,I,mend(ia(i)),(H(I,J),J=NMIN,NMAX)
   2  CONTINUE
      NMIN=NMIN+8
      K=K+8
      NMAX=MIN0(N,K)
      IF(NMAX.GE.NMIN) GOTO 71
      RETURN
   71 PRINT 63
   63 FORMAT(1X///)
      GO TO 1
      END

      subroutine kiir
      implicit real*8(a-h,o-z)
      write(*,6670)
      write(*,6661)
 6661 format(/20x,'Program BO-SPIN, Version 1.01')
      write(*,6662)
 6662 format(20x,28(1h-),/)
      write(*,6663)
      write(*,6660)
 6663 format(3x,'Calculating:')
 6660 format(3x,'------------',/)
      write(*,6664)
 6664 format(5x,2hA),' Bond orders and valences (I. Mayer, Chem. Phys.'
     $,'Lett. 97, 270, 1983;',/,
     $ '        (for open shells see IJQC 26, 73, 1986)...',/,  
     $  5x,2hB)' the decomposition of <S^2>',  
     $' (I. Mayer, CPL 440, 357, 2007)'  )
 
c     write(*,6665)
c6665 format(5x,2hB),' Chemical Energy Component Analysis (I. Mayer, '
c    $,'332, 381, 2000)',/)
      write(*,6666)
 6666 format(18x,'for a single determinant ' 
     $      'wave function'/,'        obtained in a Gaussian ',
     $ 'calculation (G92, ..., G03, ...?)',//)
      write(*,6667)
      write(*,6668)
      write(*,6669)
 6667 format(2x,'Cite this program as:')
 6668 format(2x,'---------------------')
 6669 format(1x,'I. Mayer Program "BO-SPIN,", Version 1.01'
     $ ,' (Chemical Research Center,',/,
     $ ' Hungarian Academy of Sciences), Budapest, 2008.'/)
 6670 format(1x,79(1h-))
      write(*,6670)
      end
