c----------------------------------------------------

      SUBROUTINE GAMGEN
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
c       Modified April, 2000
C     --------------
C*
C     COMPUTES AND TABULATES F0(X) TO F4(X)
C   - can be used (at least) up to F12 by changing the dimensions
C     IN RANGE
C     X=-0.10 TO X=20.05
C     IN UNITS OF X=0.05
C     USED BY THE ONE ELECTRON ROUTINE AUXG AND BY THE SP SERIES OF TWO
C     ELECTRON INTEGRAL ROUTINES
C     THE TABLE IS GENERATED ONLY ONCE FOR EACH ENTRY INTO EITHER LINK 1
C     OR LINK 2 AND IS STORED ON DRUM FILE 3
C
C   Can be used (at least) up to F12 by changing the number of the
c   columns of matrix C and the upper limit of the cycle for MM.
c
c   With the present settings the maximal RELATIVE error remains
c   less than 4*10**(-12) eveywhere (for nu=0...12)
C*
      IMPLICIT REAL*8 (A-H,O-Z)
C*
      common /table/ C(1200,5)
C*
       DIMENSION Y(500)
C*
      DATA PT05/0.05D0/,PT15/0.15D0/,PT184/0.184D0/,PT5/0.5D0/,
     *PT886/0.88622692545275801D0/,ONE/1.0D0/,TWO/2.0D0/,
     $FOUR/4.0D0/,
     *SIX/6.0D0/,xtwelve/12.25d0/,tenm11/1.0d-11/
C*
      Q=-ONE
      DO 30 MM=1,5
      xtwelve=12.20d0
      if(mm.gt.10)xtwelve=12.45d0
      M=MM-1
      Q=Q+ONE
      X=-PT15
      DO 20 I=1,403
      X=X+PT05
      A=Q
      IF(X-xtwelve)1,1,10
    1 A=A+PT5
      TERM=ONE/A
      PTLSUM=TERM
      DO 2 L=2,50
      A=A+ONE
      TERM=TERM*X/A
      PTLSUM=PTLSUM+TERM
      IF(DABS(TERM/PTLSUM)-tenm11)3,2,2
    2 CONTINUE
    3 Y(I)=PT5*PTLSUM*DEXP(-X)
      GO TO 20
   10 B=A+PT5
      A=A-PT5
      APPROX=PT886/(DSQRT(X)*X**M)
      IF(M)11,13,11
   11 DO 12 L=1,M
      B=B-ONE
   12 APPROX=APPROX*B
   13 FIMULT=PT5*DEXP(-X)/X
      FIPROP=FIMULT/APPROX
      TERM=ONE
      PTLSUM=TERM
      NOTRMS=X
      NOTRMS=NOTRMS+M
      DO 14 L=2,NOTRMS
      TERM=TERM*A/X
      PTLSUM=PTLSUM+TERM
      IF(DABS(TERM*FIPROP/PTLSUM)-TENM9)15,15,14
   14 A=A-ONE
   15 Y(I)=APPROX-FIMULT*PTLSUM
   20 CONTINUE
      DO 30 I=1,400
      J=I+2
      C(I,MM)=Y(J)
      C(I+400,MM)=Y(J+1)-Y(J)
      TEMP1=-TWO*Y(J)+Y(J+1)+Y(J-1)
      TEMP2=SIX*Y(J)-FOUR*Y(J+1)-FOUR*Y(J-1)+Y(J-2)+Y(J+2)
   30 C(I+800 ,MM)=(TEMP1-PT184*TEMP2)/SIX
C     WRITE OUT INTERPOLATION TABLE
      RETURN
      END

      SUBROUTINE FILMAX
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     FINDS MAXIMUM VALUE OF S AND P COEFFICIENTS
C     ALSO SETS LIMITS DETERMINING HOW ACCURATELY A SET OF INTEGRALS
C     NEED BE EVALUATED IN ORDER TO GUARANTEE AN OVERALL INTEGRAL
C     ACCURACY OF 10**-6
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER SHELLA,SHELLN,SHELLT,AOS,AON
      parameter (maxp=2000)
      parameter (maxg=1000)
      parameter (mxc=16)
      parameter (maxc2=225)
C*
      COMMON/AUXVAR/AUXVAR,VAR1,VAR2
      COMMON/B/EXX(maxp),C1(maxp),C2(maxp),C3(240),
     *X(maxp),Y(maxp),Z(maxp),JAN(80),SHELLA(maxp),SHELLN(maxp),
     *SHELLT(maxp),AOS(maxg),AON(20),NSHELL,MAXTYP
      COMMON/MAXC/CMAX(maxp),CMAXA(mxc),CMAXB(mxc),CMAXC(mxc),
     $ CMAXD(mxc),
     *ISMLP(maxc2),ISMLQ,ISML,ERROR1,ERROR2
C*
      DATA FIVE/5.0D0/,FIFTEN/15.0D0/
      DATA PT0001/1.0D-4/
C*
      DO 10 I=1,NSHELL
      L=SHELLA(I)
      N=L+SHELLN(I)-1
      DO 10 J=L,N
      A1=DABS(C1(J))
      A2=DABS(C2(J))
      CMAX(J)=DMAX1(A1,A2)
   10 CONTINUE
      ERROR1=PT0001/fiften
c The errot limit has been reduced 15 times! (225 times its square)
      VAR1=FIFTEN
      VAR2=FIVE
      ERROR2=ERROR1*ERROR1
      RETURN
      END

      SUBROUTINE SINFO
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     OBTAINS INFORMATION ABOUT SHELLS INEW,KNEW,JNEW,LNEW
C     COORDINATES OF ABCD GO INTO COMMON GEOM
C     NUMBER OF GAUSSIANS GO INTO NGA,... IN COMMON SHLINF
C     SHELL ANGULAR QUANTUM NUMBERS LA,... GO INTO COMMON SHLINF
C     GAUSSIAN EXPONENTS GO INTO ARRAYS AG,BG,CG,DG IN COMMON SHLINF
C     GAUSSIAN COEFFICIENTS GO INTO ARRAYS CSA,CPA,... IN COMMON SHLINF
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER SHELLA,SHELLN,SHELLT,AOS,AON
      parameter (maxp=2000)
      parameter (maxg=1000)
      parameter (mxc=16)
      parameter (maxc2=225)
C*
      COMMON/SHLNOS/ISHELL,JSHELL,KSHELL,LSHELL,INEW,JNEW,KNEW,LNEW
      COMMON/SHLINF/NGA,LA,AG(10),CSA(10),CPA(10),NGB,LB,BG(10),CSB(10),
     *CPB(10),NGC,LC,CG(10),CSC(10),CPC(10),NGD,LD,DG(10),
     *CSD(10),CPD(10)
      COMMON/MISC/MAB,MCD,NGANGB
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/MAXC/CMAX(maxp),CMAXA(mxc),CMAXB(mxc),CMAXC(mxc),
     $  CMAXD(mxc),
     *ISMLP(maxc2),ISMLQ,ISML,ERROR1,ERROR2
      COMMON/B/EXX(maxp),C1(maxp),C2(maxp),C3(240),
     *X(maxp),Y(maxp),Z(maxp),JAN(80),SHELLA(maxp),SHELLN(maxp),
     *SHELLT(maxp),AOS(maxg),AON(20),NSHELL,MAXTYP
C*
C     STARTING LOCATIONS OF SHELLS INEW JNEW KNEW AND LNEW IN LIST
C     OF GAUSSIAN FUNCTIONS
      I=SHELLA(INEW)
      J=SHELLA(JNEW)
      K=SHELLA(KNEW)
      L=SHELLA(LNEW)
C     NUMBERS OF GAUSSIAN FUNCTIONS IN SHELLS INEW JNEW KNEW AND LNEW
      NGA=SHELLN(INEW)
      NGB=SHELLN(JNEW)
      NGC=SHELLN(KNEW)
      NGD=SHELLN(LNEW)
C     COORDINATES OF ATOMS ASSOCIATED WITH SHELLS INEW JNEW KNEW
C     AND LNEW
      AX=X(INEW)
      AY=Y(INEW)
      AZ=Z(INEW)
      BX=X(JNEW)
      BY=Y(JNEW)
      BZ=Z(JNEW)
      CX=X(KNEW)
      CY=Y(KNEW)
      CZ=Z(KNEW)
      DX=X(LNEW)
      DY=Y(LNEW)
      DZ=Z(LNEW)
C     LOOP OVER GAUSSIANS IN EACH SHELL
C     FIRST SHELL INEW
      DO 10 NI=1,NGA
      N=I-1+NI
C     MAXIMUM COEFFICIENT ASSOCIATED WITH SHELL
C     USED TO DETERMINE IF ANY OF THE INTEGRALS ASSOCIATED WITH A SET
C     OF SHELLS IS LAGGE ENOUGH TO WARRANT EVALUATION OF THE ENTIRE SET
      CMAXA(NI)=CMAX(N)
C     GAUSSIAN EXPONENTS
      AG(NI)=EXX(N)
C     S COEFFICIENTS
      CSA(NI)=C1(N)
C     P COEFFICIENTS
   10 CPA(NI)=C2(N)
C     REPEAT PROCEDURE FOR SHELLS JNEW KNEW AND LNEW
      DO 20 NJ=1,NGB
      N=J-1+NJ
      CMAXB(NJ)=CMAX(N)
      BG(NJ)=EXX(N)
      CSB(NJ)=C1(N)
   20 CPB(NJ)=C2(N)
      DO 30 NK=1,NGC
      N=K-1+NK
      CMAXC(NK)=CMAX(N)
      CG(NK)=EXX(N)
      CSC(NK)=C1(N)
   30 CPC(NK)=C2(N)
      DO 40 NL=1,NGD
      N=L-1+NL
      CMAXD(NL)=CMAX(N)
      DG(NL)=EXX(N)
      CSD(NL)=C1(N)
   40 CPD(NL)=C2(N)
C     FILL COMMON MISC
      MAB=LA+LB-1
      MCD=LC+LD-1
      NGANGB=NGA*NGB
      RETURN
      END

      SUBROUTINE SGEOM
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     FINDS DIRECTION COSINES OF PENULTIMATE AXES FROM COORDINATES OF AB
C     P11,P12,....ARE DIRECTION COSINES OF AXES AT P.  Z-AXIS ALONG AB
C     Q11,Q12,....ARE DIRECTION COSINES OF AXES AT Q.  Z-AXIS ALONG CD
C*
      IMPLICIT REAL*8 (A-H,O-Z)
C*
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/TYPE/ITYPE,JTYPE
      COMMON/QGEOM/ACX,ACY,ACZ,ACY2,COSG,SING,AQX,AQZ,QPERP,QPERP2
C*
      DATA ZERO/0.0D0/,PT0001/1.0D-4/,CRIT/5.0D-4/,ONE/1.0D0/
C*
C     CAUTION ... THE VARIABLE CRIT MAY BE MACHINE SENSITIVE.  THE
C     PRESENT VALUE IS SUITABLE FOR A 72 BIT WORD.
C     FIND RAB ETC.
      ABX=BX-AX
      ABY=BY-AY
      ABZ=BZ-AZ
      RABSQ=ABX**2+ABY**2+ABZ**2
      RAB=DSQRT(RABSQ)
      CDX=DX-CX
      CDY=DY-CY
      CDZ=DZ-CZ
      RCDSQ=CDX**2+CDY**2+CDZ**2
      RCD=DSQRT(RCDSQ)
C     FIND DIRECTION COSINES OF AB AND CD. THESE ARE LOCAL Z-AXES.
C     IF INDETERMINATE TAKE ALONG SPACE Z-AXIS
   10 IF(RAB)20,30,20
   20 P31=ABX/RAB
      P32=ABY/RAB
      P33=ABZ/RAB
      GO TO 40
   30 P31=ZERO
      P32=ZERO
      P33=ONE
   40 IF(RCD)50,60,50
   50 Q31=CDX/RCD
      Q32=CDY/RCD
      Q33=CDZ/RCD
      GO TO 70
   60 Q31=ZERO
      Q32=ZERO
      Q33=ONE
C     FIND LOCAL Y-AXIS AS COMMON PERPENDICULAR TO AB AND CD
C     IF INDETERMINATE TAKE PERPENDICULAR TO AB AND SPACE Z-AXIS
C     IF STILL INDETERMINATE TAKE PERPENDICULAR TO AB AND SPACE X-AXIS
   70 COSG=P31*Q31+P32*Q32+P33*Q33
      COSG=DMIN1(ONE,COSG)
      COSG=DMAX1(-ONE,COSG)
      SING=DSQRT(ONE-COSG*COSG)
      IF(SING-CRIT)90,90,80
   80 P21=(P32*Q33-P33*Q32)/SING
      P22=(P33*Q31-P31*Q33)/SING
      P23=(P31*Q32-P32*Q31)/SING
      GO TO 120
   90 P3333=P33*P33
      P3333=DMIN1(ONE,P3333)
      SINP=DSQRT(ONE-P3333)
      IF(SINP-CRIT)110,110,100
  100 P21=P32/SINP
      P22=-P31/SINP
      P23=ZERO
      GO TO 120
  110 P3131=P31*P31
      P3131=DMIN1(ONE,P3131)
      SINP=DSQRT(ONE-P3131)
      P21=ZERO
      P22=P33/SINP
      P23=-P32/SINP
  120 Q21=P21
      Q22=P22
      Q23=P23
C     FIND DIRECTION COSINES OF LOCAL X-AXES
      P11=P22*P33-P23*P32
      P12=P23*P31-P21*P33
      P13=P21*P32-P22*P31
      Q11=Q22*Q33-Q23*Q32
      Q12=Q23*Q31-Q21*Q33
      Q13=Q21*Q32-Q22*Q31
C     FIND COORDINATES OF C RELATIVE TO LOCAL AXES AT A
      ACX=(CX-AX)*P11+(CY-AY)*P12+(CZ-AZ)*P13
      ACY=(CX-AX)*P21+(CY-AY)*P22+(CZ-AZ)*P23
C     SET ACY=0  IF CLOSE
      IF(DABS(ACY)-PT0001)130,130,140
  130 ACY=ZERO
  140 CONTINUE
      ACZ=(CX-AX)*P31+(CY-AY)*P32+(CZ-AZ)*P33
      ACY2=ACY*ACY
C     *****************************************************************
C     DIRECTION COSINES OF CD LOCAL AXES WITH RESPECT TO AB LOCAL AXES
C     (COSG,0,-SING)  (0,1,0)  (SING,0,COSG)
C     *****************************************************************
      RETURN
      END

      SUBROUTINE PINF
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     FILLS PGEOM WITH INFORMATION ABOUT P IN PRELIMINARY P-LOOP
C*
      IMPLICIT REAL*8 (A-H,O-Z)
     
      parameter (maxp=2000)
      parameter (mxc=16)
      parameter (maxc2=225)
C*
      COMMON/CONST/CONST,conp(maxc2)
      COMMON/SHLINF/NGA,LA,AG(10),CSA(10),CPA(10),NGB,LB,BG(10),CSB(10),
     *CPB(10),NGC,LC,CG(10),CSC(10),CPC(10),NGD,LD,DG(10),
     *CSD(10),CPD(10)
      COMMON/MISC/MAB,MCD,NGANGB
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/PGEOM/GP(maxc2),EP(maxc2),DP00P(maxc2),DP01P(maxc2),
     $  DP10P(maxc2),DP11P(maxc2),APP(maxc2),BPP(maxc2)
      COMMON/GINF/GA,GB,GC,GD,SA,SB,SC,SD,PA,PB,PC,PD,GAB,GCD
      COMMON/TYPE/ITYPE,JTYPE
      COMMON/MAXC/CMAX(maxp),CMAXA(mxc),CMAXB(mxc),CMAXC(mxc),
     $  CMAXD(mxc),
     *ISMLP(maxc2),ISMLQ,ISML,ERROR1,ERROR2
C*
      DATA ZERO/0.0D0/,ONE/1.0D0/,SIXTY/60.0D0/
C*
      IND=0
      DO 100 I=1,NGA
      GA=AG(I)
      CSAI=CSA(I)
      CPAI=CPA(I)
      DO 90 J=1,NGB
      IND =IND+1
      GB=BG(J)
      GAB=GA+GB
      GP(IND)=GAB
      EAB=ONE/GAB
      EP(IND)=EAB
      GBEAB=GB*EAB
      APP(IND)=GBEAB*RAB
      BPP(IND)=APP(IND)-RAB
      XQQ=GA*GBEAB*RABSQ
      IF(XQQ-SIXTY)4,4,2
    2 ISMLP(IND)=2
      DP00P(IND)=ZERO
      IF(JTYPE-3)90,90,110
  110 DP01P(IND)=ZERO
      CONP(IND)=ZERO
      IF(JTYPE-5)120,120,130
  120 BPP(IND)=BPP(IND)*GAB
      GO TO 90
  130 DP10P(IND)=ZERO
      DP11P(IND)=ZERO
      GO TO 90
    4 XX=DEXP(-XQQ)*EAB
      XXTEST=CMAXA(I)*CMAXB(J)*XX
      IF(XXTEST-ERROR1)20,20,10
   10 ISMLP(IND)=0
      GO TO 50
   20 IF(XXTEST-ERROR2)40,40,30
   30 ISMLP(IND)=1
      GO TO 50
   40 ISMLP(IND)=2
   50 X=34.98683666D0*XX
      DP00P(IND)=X*CSAI*CSB(J)
C     FOR TYPES 0000,0001,0011 ONLY DP00 NEEDED
      IF (JTYPE-3) 90,90,60
   60 DP01P(IND)=X*CSAI*CPB(J)
      IF (JTYPE-5) 70,70,80
   70 CONP(IND)=DP01P(IND)*EAB
      DP00P(IND)=DP00P(IND)*GAB/DP01P(IND)
      BPP(IND)=BPP(IND)*GAB
      GO TO 90
   80 DP10P(IND)=X*CPAI*CSB(J)
      DP11P(IND)=X*CPAI*CPB(J)
      CONP(IND)=DP11P(IND)
      DP00P(IND)=DP00P(IND)/DP11P(IND)
      DP01P(IND)=DP01P(IND)/DP11P(IND)
      DP10P(IND)=DP10P(IND)/DP11P(IND)
   90 CONTINUE
  100 CONTINUE
      RETURN
      END

      SUBROUTINE SP0000
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     SPECIAL FAST ROUTINE FOR P LOOP FOR 0000
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      parameter (maxp=2000)
      parameter (mxc=16)
      parameter (maxc2=225)
C*
      COMMON/ASTORE/QQ,THETA,N
      COMMON/TABLE/
     *A0(400),B0(400),C0(400),
     *A1(400),B1(400),C1(400),
     *A2(400),B2(400),C2(400),
     *A3(400),B3(400),C3(400),
     *A4(400),B4(400),C4(400)
      COMMON/AUXVAR/AUXVAR,VAR1,VAR2
      COMMON/MISC/MAB,MCD,NGANGB
      COMMON/GINF/GA,GB,GC,GD,SA,SB,SC,SD,PA,PB,PC,PD,GAB,GCD
      COMMON/PQGEOM/AP,BP,CQ,DQ,PX,PY,PZ,QX,QY,QZ,RPQ,RPQSQ,PQ1,PQ2,PQ3,
     *C11,C12,C13,C21,C22,C23,C31,C32,C33
      COMMON/EABECD/EAB,ECD
      COMMON/H/H0000,H0001,H0002,H0003,H(156)
      COMMON/PGEOM/GP(maxc2),EP(maxc2),DP00P(maxc2),DP01P(maxc2),
     $  DP10P(maxc2),DP11P(maxc2),APP(maxc2),BPP(maxc2)
      COMMON/SHLINF/NGA,LA,AG(10),CSA(10),CPA(10),NGB,LB,BG(10),CSB(10),
     *CPB(10),NGC,LC,CG(10),CSC(10),CPC(10),NGD,LD,DG(10),
     *CSD(10),CPD(10)
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/DPQ/DP00,DP01,DP10,DP11,DQ00,DQ01,DQ10,DQ11
      COMMON/G/G0000,G(159)
      COMMON/GOUT/GOUT(256)
      COMMON/QGEOM/ACX,ACY,ACZ,ACY2,COSG,SING,AQX,AQZ,QPERP,QPERP2
      COMMON/MAXC/CMAX(maxp),CMAXA(mxc),CMAXB(mxc),CMAXC(mxc),
     $  CMAXD(mxc),
     *ISMLP(maxc2),ISMLQ,ISML,ERROR1,ERROR2
C*
      DATA ZERO/0.0D0/,ONE/1.0D0/,TWO/2.0D0/,TWENTY/20.0D0/
      DATA SIXTY/60.0D0/
      DATA PT7853/0.7853981633974483D0/
C*
      G0000=ZERO
      DO 120 K=1,NGC
      GC=CG(K)
      CSCK=CSC(K)
      GCRCDS=GC*RCDSQ
      DO 120 L=1,NGD
      GD=DG(L)
      GCD=GC+GD
      ECD=ONE/GCD
      GDECD=GD*ECD
      XQQ=GDECD*GCRCDS
      IF(XQQ-SIXTY)4,4,2
    2 XX=ZERO
      GO TO 6
    4 XX=DEXP(-XQQ)*ECD
    6 XXTEST=XX*CMAXC(K)*CMAXD(L)
      IF(XXTEST-ERROR1)20,20,10
   10 ISMLQ=0
      GO TO 40
   20 IF(XXTEST-ERROR2)120,120,30
   30 ISMLQ=1
   40 CQ=GDECD*RCD
      AQX=ACX+SING*CQ
      AQZ=ACZ+COSG*CQ
      QPERP2=AQX*AQX+ACY2
      H0000=ZERO
      DO 110 I=1,NGANGB
      ISML=ISMLQ+ISMLP(I)
      IF(ISML-2)50,110,110
   50 IF(ISML-1)60,70,70
   60 AUXVAR=VAR1
      GO TO 80
   70 AUXVAR=VAR2
   80 X=((AQZ-APP(I))**2+QPERP2)/(EP(I)+ECD)
      IF(X-AUXVAR)100,100,90
   90 H0000=H0000+DP00P(I)*DSQRT(PT7853/(X*(GP(I)+GCD)))
      GO TO 110
  100 QQ=X*TWENTY
      N=QQ
      THETA=QQ-N
      THETA2=THETA*(THETA-ONE)
      THETA3=THETA2*(THETA-TWO)
      THETA4=THETA2*(THETA+ONE)
      F0=A0(N+1)+THETA*B0(N+1)-THETA3*C0(N+1)+THETA4*C0(N+2)
      H0000=H0000+DP00P(I)*F0/DSQRT(GP(I)+GCD)
  110 CONTINUE
      G0000=G0000+H0000*CSCK*CSD(L)*XX
  120 CONTINUE
      GOUT(1)=G0000
      RETURN
      END
      SUBROUTINE SP0001
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     SPECIAL FAST ROUTINE FOR P LOOP FOR 0001
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      parameter (maxp=2000)
      parameter (mxc=16)
      parameter (maxc2=225)
C*
      COMMON/PQGEOM/AP,BP,CQ,DQ,PX,PY,PZ,QX,QY,QZ,RPQ,RPQSQ,PQ1,PQ2,PQ3,
     *C11,C12,C13,C21,C22,C23,C31,C32,C33
      COMMON/ASTORE/QQ,THETA,N
      COMMON/TABLE/
     *A0(400),B0(400),C0(400),
     *A1(400),B1(400),C1(400),
     *A2(400),B2(400),C2(400),
     *A3(400),B3(400),C3(400),
     *A4(400),B4(400),C4(400)
      COMMON/AUXVAR/AUXVAR,VAR1,VAR2
      COMMON/MISC/MAB,MCD,NGANGB
      COMMON/EABECD/EAB,ECD
      COMMON/H/H0000,H0001,H0002,H0003,H(156)
      COMMON/GINF/GA,GB,GC,GD,SA,SB,SC,SD,PA,PB,PC,PD,GAB,GCD
      COMMON/PGEOM/GP(maxc2),EP(maxc2),DP00P(maxc2),DP01P(maxc2),
     $  DP10P(maxc2),DP11P(maxc2),APP(maxc2),BPP(maxc2)
      COMMON/QGEOM/ACX,ACY,ACZ,ACY2,COSG,SING,AQX,AQZ,QPERP,QPERP2
      COMMON/G/G0000,G0001,G0002,G0003,GG(156)
      COMMON/PHI/COSP,SINP
      COMMON/MAXC/CMAX(maxp),CMAXA(mxc),CMAXB(mxc),CMAXC(mxc),
     $  CMAXD(mxc),
     *ISMLP(maxc2),ISMLQ,ISML,ERROR1,ERROR2
      COMMON/GOUT/GOUT1,GOUT2,GOUT3,GOUT4,GX(252)
      COMMON/DPQ/DP00,DP01,DP10,DP11,DQ00,DQ01,DQ10,DQ11
C*
      DATA ZERO/0.0D0/,PT5/0.5D0/,ONE/1.0D0/,TWO/2.0D0/,TWENTY/20.0D0/
c     DATA PT7853/0.7853981625D0/
      DATA PT7853/0.7853981633974483D0/
C*
      H0000=ZERO
      H0001=ZERO
      H0003=ZERO
      DO 80 I=1,NGANGB
      ISML=ISMLQ+ISMLP(I)
      IF(ISML-2)10,80,80
   10 IF(ISML-1)20,30,30
   20 AUXVAR=VAR1
      GO TO 40
   30 AUXVAR=VAR2
   40 PQAB=AQZ-APP(I)
      G=ONE/(EP(I)+ECD)
      X=(PQAB*PQAB+QPERP2)*G
      IF(X-AUXVAR)60,60,50
   50 Y0=DP00P(I)*DSQRT(PT7853/(X*(GP(I)+GCD)))
      Y1=PT5*Y0/X
      GO TO 70
   60 Y=DP00P(I)/DSQRT(GP(I)+GCD)
      QQ=X*TWENTY
      N=QQ
      THETA=QQ-N
      THETA2=THETA*(THETA-ONE)
      THETA3=THETA2*(THETA-TWO)
      THETA4=THETA2*(THETA+ONE)
      Y0=(A0(N+1)+THETA*B0(N+1)-THETA3*C0(N+1)+THETA4*C0(N+2))*Y
      Y1=(A1(N+1)+THETA*B1(N+1)-THETA3*C1(N+1)+THETA4*C1(N+2))*Y
   70 U=G*Y1
      H0000=H0000+Y0
      H0001=H0001+U
      H0003=H0003-U*PQAB
   80 CONTINUE
      H0001=H0001*ECD*QPERP
      H0003=H0003*ECD
      X=DQ*H0000
      G0001=H0001*COSP+X*SING
      G0002=H0001*SINP
      G0003=H0003+X*COSG
      GOUT1=GOUT1+DQ00*H0000
      GOUT2=GOUT2+DQ01*G0001
      GOUT3=GOUT3+DQ01*G0002
      GOUT4=GOUT4+DQ01*G0003
      RETURN
      END
      SUBROUTINE SP0011
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     SPECIAL FAST ROUTINE FOR P LOOP FOR 0011
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      parameter (maxp=2000)
      parameter (mxc=16)
      parameter (maxc2=225)
C*
      COMMON/MISC/MAB,MCD,NGANGB
      COMMON/PQGEOM/AP,BP,CQ,DQ,PX,PY,PZ,QX,QY,QZ,RPQ,RPQSQ,PQ1,PQ2,PQ3,
     *C11,C12,C13,C21,C22,C23,C31,C32,C33
      COMMON/EABECD/EAB,ECD
      COMMON/H/
     *H0000,H0001,H0002,H0003,H0011,H0012,H0013,H0022,H0023,H0033,
     *H(150)
      COMMON/GINF/GA,GB,GC,GD,SA,SB,SC,SD,PA,PB,PC,PD,GAB,GCD
      COMMON/PGEOM/GP(maxc2),EP(maxc2),DP00P(maxc2),DP01P(maxc2),
     $  DP10P(maxc2),DP11P(maxc2),APP(maxc2),BPP(maxc2)
      COMMON/COS/C
      COMMON/QGEOM/ACX,ACY,ACZ,ACY2,COSG,SING,AQX,AQZ,QPERP,QPERP2
      COMMON/ASTORE/QQ,THETA,N
      COMMON/TABLE/
     *A0(400),B0(400),C0(400),
     *A1(400),B1(400),C1(400),
     *A2(400),B2(400),C2(400),
     *A3(400),B3(400),C3(400),
     *A4(400),B4(400),C4(400)
      COMMON/AUXVAR/AUXVAR,VAR1,VAR2
      COMMON/MAXC/CMAX(maxp),CMAXA(mxc),CMAXB(mxc),CMAXC(mxc),
     $  CMAXD(mxc),
     *ISMLP(maxc2),ISMLQ,ISML,ERROR1,ERROR2
C*
      DATA ZERO/0.0D0/,PT5/0.5D0/,ONE/1.0D0/,ONEPT5/1.5D0/,TWO/2.0D0/,
     *TWENTY/20.0D0/
c     DATA PT7853/0.7853981625D0/
      DATA PT7853/0.7853981633974483D0/
C*
      H0000=ZERO
      H0001=ZERO
      H0003=ZERO
      H0011=ZERO
      H0013=ZERO
      H0033=ZERO
      DO 80 I=1,NGANGB
      ISML=ISMLQ+ISMLP(I)
      IF(ISML-2)10,80,80
   10 IF(ISML-1)20,30,30
   20 AUXVAR=VAR1
      GO TO 40
   30 AUXVAR=VAR2
   40 PQAB=AQZ-APP(I)
      PQAB2=PQAB*PQAB
      G=ONE/(EP(I)+ECD)
      X=G*(PQAB2+QPERP2)
      G=G*ECD
      IF(X-AUXVAR)60,60,50
   50 F0=DP00P(I)*DSQRT(PT7853/(X*(GP(I)+GCD)))
      GTX=G/X
      F1=PT5*F0*GTX
      F2=ONEPT5*F1*GTX
      GO TO 70
   60 Y=DP00P(I)/DSQRT(GP(I)+GCD)
      GY=G*Y
      GGY=G*GY
      QQ=X*TWENTY
      N=QQ
      THETA=QQ-N
      THETA2=THETA*(THETA-ONE)
      THETA3=THETA2*(THETA-TWO)
      THETA4=THETA2*(THETA+ONE)
      F0=(A0(N+1)+THETA*B0(N+1)-THETA3*C0(N+1)+THETA4*C0(N+2))*Y
      F1=(A1(N+1)+THETA*B1(N+1)-THETA3*C1(N+1)+THETA4*C1(N+2))*GY
      F2=(A2(N+1)+THETA*B2(N+1)-THETA3*C2(N+1)+THETA4*C2(N+2))*GGY
   70 H0000=H0000+F0
      H0001=H0001+F1
      H0003=H0003-F1*PQAB
      H0011=H0011+F2
      H0013=H0013-F2*PQAB
      H0033=H0033+F2*PQAB2
   80 CONTINUE
      H0022=PT5*ECD*(H0000-H0001)
      H0001=H0001*QPERP
      H0011=H0011*QPERP2+H0022
      H0013=H0013*QPERP
      H0033=H0033+H0022
      RETURN
      END
      SUBROUTINE SP0101
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     SPECIAL FAST ROUTINE FOR P LOOP FOR 0101
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      parameter (maxp=2000)
      parameter (mxc=16)
      parameter (maxc2=225)
C*
      COMMON/ASTORE/QQ,THETA,N
      COMMON/SHLINF/NGA,LA,AG(10),CSA(10),CPA(10),NGB,LB,BG(10),CSB(10),
     *CPB(10),NGC,LC,CG(10),CSC(10),CPC(10),NGD,LD,DG(10),
     *CSD(10),CPD(10)
      COMMON/TABLE/
     *A0(400),B0(400),C0(400),
     *A1(400),B1(400),C1(400),
     *A2(400),B2(400),C2(400),
     *A3(400),B3(400),C3(400),
     *A4(400),B4(400),C4(400)
      COMMON/AUXVAR/AUXVAR,VAR1,VAR2
      COMMON/MISC/MAB,MCD,NGANGB
      COMMON/PQGEOM/AP,BP,CQ,DQ,PX,PY,PZ,QX,QY,QZ,RPQ,RPQSQ,PQ1,PQ2,PQ3,
     *C11,C12,C13,C21,C22,C23,C31,C32,C33
      COMMON/EABECD/EAB,ECD
      COMMON/H/
     *H0000,H0001,H0002,H0003,H0011,H0012,H0013,H0022,H0023,H0033,
     *H0100,H0101,H0102,H0103,H0111,H0112,H0113,H0122,H0123,H0133,
     *H0200,H0201,H0202,H0203,H0211,H0212,H0213,H0222,H0223,H0233,
     *H0300,H0301,H0302,H0303,H0311,H0312,H0313,H0322,H0323,H0333,
     *H(120)
      COMMON/GINF/GA,GB,GC,GD,SA,SB,SC,SD,PA,PB,PC,PD,GAB,GCD
      COMMON/PGEOM/GP(maxc2),EP(maxc2),DP00P(maxc2),DP01P(maxc2),
     $  DP10P(maxc2),DP11P(maxc2),APP(maxc2),BPP(maxc2)
      COMMON/COS/C
      COMMON/QGEOM/ACX,ACY,ACZ,ACY2,COSG,SING,AQX,AQZ,QPERP,QPERP2
      COMMON/MAXC/CMAX(maxp),CMAXA(mxc),CMAXB(mxc),CMAXC(mxc),
     $  CMAXD(mxc),
     *ISMLP(maxc2),ISMLQ,ISML,ERROR1,ERROR2
      COMMON/CONST/CONST,conp(maxc2)
C*
      DATA ZERO/0.0D0/,PT5/0.5D0/,ONE/1.0D0/,ONEPT5/1.5D0/,TWO/2.0D0/,
     *TWENTY/20.0D0/
c     DATA PT7853/0.7853981625D0/
      DATA PT7853/0.7853981633974483D0/
C*
      H0000=ZERO
      H0001=ZERO
      H0003=ZERO
      H0100=ZERO
      H0101=ZERO
      H0103=ZERO
      H0300=ZERO
      H0301=ZERO
      H0303=ZERO
C     BEGIN P LOOP
      DO 80 I=1,NGANGB
      ISML=ISMLQ+ISMLP(I)
      IF(ISML-2)10,80,80
   10 IF(ISML-1)20,30,30
   20 AUXVAR=VAR1
      GO TO 40
   30 AUXVAR=VAR2
   40 EAB=EP(I)
      DP00=DP00P(I)
      BP=BPP(I)
      PQAB=AQZ-APP(I)
      PQAB2=PQAB*PQAB
      G=ONE/(EP(I)+ECD)
      X=(PQAB2+QPERP2)*G
      IF(X-AUXVAR)60,60,50
   50 F0=CONP(I)*DSQRT(PT7853/(X*(GP(I)+GCD)))
      GTX=G/X
      F1=PT5*F0*GTX
      F2=ONEPT5*F1*GTX
      GO TO 70
   60 Y=CONP(I)/DSQRT(GP(I)+GCD)
      GY=G*Y
      GGY=G*GY
      QQ=X*TWENTY
      N=QQ
      THETA=QQ-N
      THETA2=THETA*(THETA-ONE)
      THETA3=THETA2*(THETA-TWO)
      THETA4=THETA2*(THETA+ONE)
      F0=(A0(N+1)+THETA*B0(N+1)-THETA3*C0(N+1)+THETA4*C0(N+2))*Y
      F1=(A1(N+1)+THETA*B1(N+1)-THETA3*C1(N+1)+THETA4*C1(N+2))*GY
      F2=(A2(N+1)+THETA*B2(N+1)-THETA3*C2(N+1)+THETA4*C2(N+2))*GGY
   70 CONTINUE
      G03=-PQAB*F1
      H0000=H0000+F0 *DP00
      H0001=H0001+F1 *DP00
      H0003=H0003+G03*DP00
      H0100=H0100-F1
      H0101=H0101-F2
      H0103=H0103+PQAB*F2
      H0300=H0300-G03+BP*F0
      H0301=H0301+BP*F1
      H0303=H0303-PQAB2*F2+BP*G03
   80 CONTINUE
      X=QPERP*ECD
      H0001=H0001*X
      H0003=H0003*ECD
      H0202=-PT5*ECD*H0100
      H0100=H0100*QPERP
      H0101=H0101*QPERP2*ECD
      H0103=H0103*X
      H0301=H0301*X
      H0303=H0303*ECD
      H0301=H0301+H0103
      H0101=H0101+H0202
      H0303=H0303+H0202
      RETURN
      END
      SUBROUTINE SP0111
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     SPECIAL FAST ROUTINE FOR P LOOP FOR 0111
C*
      IMPLICIT REAL*8 (A-H,O-Z)
C*
      parameter (maxp=2000)
      parameter (mxc=16)
      parameter (maxc2=225)

      COMMON/SHLINF/NGA,LA,AG(10),CSA(10),CPA(10),NGB,LB,BG(10),CSB(10),
     *CPB(10),NGC,LC,CG(10),CSC(10),CPC(10),NGD,LD,DG(10),
     *CSD(10),CPD(10)
      COMMON/MISC/MAB,MCD,NGANGB
      COMMON/PQGEOM/AP,BP,CQ,DQ,PX,PY,PZ,QX,QY,QZ,RPQ,RPQSQ,PQ1,PQ2,PQ3,
     *C11,C12,C13,C21,C22,C23,C31,C32,C33
      COMMON/EABECD/EAB,ECD
      COMMON/H/
     *H0000,H0001,H0002,H0003,H0011,H0012,H0013,H0022,H0023,H0033,
     *H0100,H0101,H0102,H0103,H0111,H0112,H0113,H0122,H0123,H0133,
     *H0200,H0201,H0202,H0203,H0211,H0212,H0213,H0222,H0223,H0233,
     *H0300,H0301,H0302,H0303,H0311,H0312,H0313,H0322,H0323,H0333,
     *H(120)
      COMMON/GINF/GA,GB,GC,GD,SA,SB,SC,SD,PA,PB,PC,PD,GAB,GCD
      COMMON/PGEOM/GP(maxc2),EP(maxc2),DP00P(maxc2),DP01P(maxc2),
     $  DP10P(maxc2),DP11P(maxc2),APP(maxc2),BPP(maxc2)
      COMMON/COS/C
      COMMON/QGEOM/ACX,ACY,ACZ,ACY2,COSG,SING,AQX,AQZ,QPERP,QPERP2
      COMMON/MAXC/CMAX(maxp),CMAXA(mxc),CMAXB(mxc),CMAXC(mxc),
     $  CMAXD(mxc),
     *ISMLP(maxc2),ISMLQ,ISML,ERROR1,ERROR2
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/CONST/CONST,conp(maxc2)
      COMMON/ASTORE/QQ,THETA,N
      COMMON/TABLE/
     *A0(400),B0(400),C0(400),
     *A1(400),B1(400),C1(400),
     *A2(400),B2(400),C2(400),
     *A3(400),B3(400),C3(400),
     *A4(400),B4(400),C4(400)
      COMMON/AUXVAR/AUXVAR,VAR1,VAR2
C*
      EQUIVALENCE(E1,EAB)
C*
      DATA ZERO/0.0D0/,PT5/0.5D0/,ONE/1.0D0/,ONEPT5/1.5D0/,TWO/2.0D0/,
     *TWOPT5/2.5D0/,TWENTY/20.0D0/
c     DATA PT7853/0.7853981625D0/
      DATA PT7853/0.7853981633974483D0/
C*
      X1=ZERO
      X2=ZERO
      X3=ZERO
      X4=ZERO
      X5=ZERO
      X6=ZERO
      Y1=ZERO
      Y2=ZERO
      Y3=ZERO
      Y4=ZERO
      Y5=ZERO
      Y6=ZERO
      Z1=ZERO
      Z2=ZERO
      Z3=ZERO
      Z4=ZERO
      Z5=ZERO
      Z6=ZERO
      Z7=ZERO
      Z8=ZERO
      Z9=ZERO
C     BEGIN P LOOP
      DO 80 I=1,NGANGB
      ISML=ISMLQ+ISMLP(I)
      IF(ISML-2)10,80,80
   10 IF(ISML-1)20,30,30
   20 AUXVAR=VAR1
      GO TO 40
   30 AUXVAR=VAR2
   40 EAB=EP(I)
      DP00=DP00P(I)
      BP=BPP(I)
      PQAB=AQZ-APP(I)
      PQAB2=PQAB*PQAB
      G=ONE/(EAB+ECD)
      X=G*(PQAB2+QPERP2)
      IF(X-AUXVAR)60,60,50
   50 F0=CONP(I)*DSQRT(PT7853/(X*(GP(I)+GCD)))
      GTX=G/X
      F1=PT5*F0*GTX
      F2=ONEPT5*F1*GTX
      F3=TWOPT5*F2*GTX
      GO TO 70
   60 Y=CONP(I)/DSQRT(GP(I)+GCD)
      GY=G*Y
      GGY=G*GY
      GGGY=G*GGY
      QQ=X*TWENTY
      N=QQ
      THETA=QQ-N
      THETA2=THETA*(THETA-ONE)
      THETA3=THETA2*(THETA-TWO)
      THETA4=THETA2*(THETA+ONE)
      F0=(A0(N+1)+THETA*B0(N+1)-THETA3*C0(N+1)+THETA4*C0(N+2))*Y
      F1=(A1(N+1)+THETA*B1(N+1)-THETA3*C1(N+1)+THETA4*C1(N+2))*GY
      F2=(A2(N+1)+THETA*B2(N+1)-THETA3*C2(N+1)+THETA4*C2(N+2))*GGY
      F3=(A3(N+1)+THETA*B3(N+1)-THETA3*C3(N+1)+THETA4*C3(N+2))*GGGY
   70 CONTINUE
      F1PQAB=F1*PQAB
      F2PQAB=F2*PQAB
      F3PQAB=F3*PQAB
      F2PQA2=F2*PQAB2
      X1=X1+F0    *DP00
      X2=X2+F1    *DP00
      X3=X3+F2    *DP00
      X4=X4+F1PQAB*DP00
      X5=X5+F2PQAB*DP00
      X6=X6+F2PQA2*DP00
      Y1=Y1+F0    *BP
      Y2=Y2+F1    *BP
      Y3=Y3+F2    *BP
      Y4=Y4+F1PQAB*BP
      Y5=Y5+F2PQAB*BP
      Y6=Y6+F2PQA2*BP
      Z1=Z1+F1
      Z2=Z2+F2
      Z3=Z3+F3
      Z4=Z4+F1PQAB
      Z5=Z5+F2PQAB
      Z6=Z6+F3PQAB
      Z7=Z7+F2PQA2
      Z8=Z8+F3*PQAB2
      Z9=Z9+F3PQAB*PQAB2
   80 CONTINUE
      HECD=PT5*ECD
      ECD2=ECD*ECD
      QECD=QPERP*ECD
      QECD2=QPERP*ECD2
      Q2ECD=QPERP2*ECD
      Q2ECD2=QPERP2*ECD2
      H0000=X1
      H0001=QECD*X2
      H0003=-ECD*X4
      H0022=HECD*(X1-ECD*X2)
      H0011=H0022+Q2ECD2*X3
      H0013=-QECD2*X5
      H0033=H0022+ECD2*X6
      H0100=-QPERP*Z1
      H0300=Z4+Y1
      H0202=HECD*Z1
      H0101=H0202-Q2ECD*Z2
      H0103=QECD*Z5
      H0301=H0103+QECD*Y2
      H0303=H0202-ECD*Z7-ECD*Y4
      H0212=PT5*QECD2*Z2
      H0223=-PT5*ECD2*Z5
      H0122=H0212-QPERP*H0202
      H0322=H0223+HECD*(H0300-ECD*Y2)
      H0113=H0223+Q2ECD2*Z6
      H0313=H0212-QECD2*(Z8+Y5)
      H0111=H0122+H0212+H0212-Q2ECD2*QPERP*Z3
      H0133=H0122-QECD2*Z8
      H0311=H0322+Q2ECD2*(Z6+Y3)
      H0333=H0322+H0223+H0223+ECD2*(Z9+Y6)
      RETURN
      END
      SUBROUTINE SP1111
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      parameter (maxp=2000)
      parameter (mxc=16)
      parameter (maxc2=225)
C*
      COMMON/MISC/MAB,MCD,NGANGB
      COMMON/SHLINF/NGA,LA,AG(10),CSA(10),CPA(10),NGB,LB,BG(10),CSB(10),
     *CPB(10),NGC,LC,CG(10),CSC(10),CPC(10),NGD,LD,DG(10),
     *CSD(10),CPD(10)
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/PGEOM/GP(maxc2),EP(maxc2),DP00P(maxc2),DP01P(maxc2),
     $  DP10P(maxc2),DP11P(maxc2),APP(maxc2),BPP(maxc2)
      COMMON/PQGEOM/AP,BP,CQ,DQ,PX,PY,PZ,QX,QY,QZ,RPQ,RPQSQ,PQ1,PQ2,PQ3,
     *C11,C12,C13,C21,C22,C23,C31,C32,C33
      COMMON/GINF/GA,GB,GC,GD,SA,SB,SC,SD,PA,PB,PC,PD,GAB,GCD
      COMMON/EABECD/EAB,ECD
      COMMON/DPQ/DP00,DP01,DP10,DP11,DQ00,DQ01,DQ10,DQ11
      COMMON/QGEOM/ACX,ACY,ACZ,ACY2,COSG,SING,AQX,AQZ,QPERP,QPERP2
      COMMON/CONST/CONST,conp(maxc2)
      COMMON/MAXC/CMAX(maxp),CMAXA(mxc),CMAXB(mxc),CMAXC(mxc),
     $  CMAXD(mxc),
     *ISMLP(maxc2),ISMLQ,ISML,ERROR1,ERROR2
      COMMON/ASTORE/QQ,THETA,N
      COMMON/TABLE/
     *AA(400),BA(400),CA(400),
     *AB(400),BB(400),CB(400),
     *AC(400),BC(400),CC(400),
     *AD(400),BD(400),CD(400),
     *AE(400),BE(400),CE(400)
      COMMON/AUXVAR/AUXVAR,VAR1,VAR2
      COMMON/H/
     *H0000,H0001,H0002,H0003,H0011,H0012,H0013,H0022,H0023,H0033,
     *H0100,H0101,H0102,H0103,H0111,H0112,H0113,H0122,H0123,H0133,
     *H0200,H0201,H0202,H0203,H0211,H0212,H0213,H0222,H0223,H0233,
     *H0300,H0301,H0302,H0303,H0311,H0312,H0313,H0322,H0323,H0333,
     *H1000,H1001,H1002,H1003,H1011,H1012,H1013,H1022,H1023,H1033,
     *H1100,H1101,H1102,H1103,H1111,H1112,H1113,H1122,H1123,H1133,
     *H1200,H1201,H1202,H1203,H1211,H1212,H1213,H1222,H1223,H1233,
     *H1300,H1301,H1302,H1303,H1311,H1312,H1313,H1322,H1323,H1333,
     *H2000,H2001,H2002,H2003,H2011,H2012,H2013,H2022,H2023,H2033,
     *H2100,H2101,H2102,H2103,H2111,H2112,H2113,H2122,H2123,H2133,
     *H2200,H2201,H2202,H2203,H2211,H2212,H2213,H2222,H2223,H2233,
     *H2300,H2301,H2302,H2303,H2311,H2312,H2313,H2322,H2323,H2333,
     *H3000,H3001,H3002,H3003,H3011,H3012,H3013,H3022,H3023,H3033,
     *H3100,H3101,H3102,H3103,H3111,H3112,H3113,H3122,H3123,H3133,
     *H3200,H3201,H3202,H3203,H3211,H3212,H3213,H3222,H3223,H3233,
     *H3300,H3301,H3302,H3303,H3311,H3312,H3313,H3322,H3323,H3333
C*
      DATA ZERO/0.0D0/,PT25/0.25D0/,PT5/0.5D0/,ONE/1.0D0/,ONEPT5/1.5D0/,
     *TWO/2.0D0/,TWOPT5/2.5D0/,THREE/3.0D0/,THRPT5/3.5D0/,TWENTY/20.0D0/
c     DATA PT7853/0.7853981625D0/
      DATA PT7853/0.7853981633974483D0/
C*
      X1=ZERO
      X2=ZERO
      X3=ZERO
      X4=ZERO
      X5=ZERO
      X6=ZERO
      Y1=ZERO
      Y2=ZERO
      Y3=ZERO
      Y4=ZERO
      Y5=ZERO
      Y6=ZERO
      Z1=ZERO
      Z2=ZERO
      Z3=ZERO
      Z4=ZERO
      Z5=ZERO
      Z6=ZERO
      Z7=ZERO
      Z8=ZERO
      Z9=ZERO
      V1=ZERO
      V2=ZERO
      V3=ZERO
      V4=ZERO
      V5=ZERO
      V6=ZERO
      W1=ZERO
      W2=ZERO
      W3=ZERO
      W4=ZERO
      W5=ZERO
      W6=ZERO
      W7=ZERO
      W8=ZERO
      W9=ZERO
      S1=ZERO
      S2=ZERO
      S3=ZERO
      S4=ZERO
      S5=ZERO
      S6=ZERO
      S7=ZERO
      S8=ZERO
      S9=ZERO
      S10=ZERO
      S11=ZERO
      S12=ZERO
      S13=ZERO
      S14=ZERO
      T1=ZERO
      T2=ZERO
      T3=ZERO
      T4=ZERO
      T5=ZERO
      T6=ZERO
      T7=ZERO
      T8=ZERO
      T9=ZERO
      T10=ZERO
      T11=ZERO
      T12=ZERO
      T13=ZERO
      T14=ZERO
      C1=ZERO
      C2=ZERO
      C3=ZERO
      C4=ZERO
      C5=ZERO
      C6=ZERO
      DO 90  IND=1,NGANGB
      ISML=ISMLQ+ISMLP(IND)
      IF(ISML-2)10,90,90
   10 IF(ISML-1)20,30,30
   20 AUXVAR=VAR1
      GO TO 40
   30 AUXVAR=VAR2
   40 EAB=EP(IND)
      DP00=DP00P(IND)
      DP01=DP01P(IND)
      DP10=DP10P(IND)
      AP=APP(IND)
      BP=BPP(IND)
      PQAB=AQZ-AP
      PQAB2=PQAB*PQAB
      G=ONE/(EAB+ECD)
      X=G*(QPERP2+PQAB2)
      IF(X-AUXVAR)60,60,50
   50 F0=DSQRT(PT7853/(X*(GP(IND)+GCD)))*CONP(IND)
      GTX=G/X
      F1=PT5*F0*GTX
      F2=ONEPT5*F1*GTX
      F3=TWOPT5*F2*GTX
      F4=THRPT5*F3*GTX
      GO TO 70
   60 Y=CONP(IND)/DSQRT(GP(IND)+GCD)
      GY=G*Y
      GGY=G*GY
      GGGY=G*GGY
      QQ=X*TWENTY
      N=QQ
      THETA=QQ-N
      THETA2=THETA*(THETA-ONE)
      THETA3=THETA2*(THETA-TWO)
      THETA4=THETA2*(THETA+ONE)
      F0=(AA(N+1)+THETA*BA(N+1)-THETA3*CA(N+1)+THETA4*CA(N+2))*Y
      F1=(AB(N+1)+THETA*BB(N+1)-THETA3*CB(N+1)+THETA4*CB(N+2))*GY
      F2=(AC(N+1)+THETA*BC(N+1)-THETA3*CC(N+1)+THETA4*CC(N+2))*GGY
      F3=(AD(N+1)+THETA*BD(N+1)-THETA3*CD(N+1)+THETA4*CD(N+2))*GGGY
      F4=(AE(N+1)+THETA*BE(N+1)-THETA3*CE(N+1)+THETA4*CE(N+2))*GGGY*G
   70 APBP=AP*BP
      EAB2=EAB*EAB
      BPDP01=BP*DP01
      APDP10=AP*DP10
      EDP01=EAB*DP01
      EDP10=EAB*DP10
      F1PQAB=F1*PQAB
      F2PQAB=F2*PQAB
      F3PQAB=F3*PQAB
      F4PQAB=F4*PQAB
      F1PQA2=F1*PQAB2
      F2PQA2=F2*PQAB2
      F3PQA2=F3*PQAB2
      F4PQA2=F4*PQAB2
      F2PQA3=F2PQA2*PQAB
      F3PQA3=F3PQA2*PQAB
      F4PQA3=F4PQA2*PQAB
      X1=X1+F0    *DP00
      X2=X2+F1    *DP00
      X3=X3+F2    *DP00
      X4=X4+F1PQAB*DP00
      X5=X5+F2PQAB*DP00
      X6=X6+F2PQA2*DP00
      Z1=Z1+F1          *EDP01
      Z2=Z2+F2          *EDP01
      Z3=Z3+F3          *EDP01
      Z4=Z4+F1PQAB      *EDP01
      Z5=Z5+F2PQAB      *EDP01
      Z6=Z6+F3PQAB      *EDP01
      Z7=Z7+F2PQA2      *EDP01
      Z8=Z8+F3PQA2      *EDP01
      Z9=Z9+F3PQA3      *EDP01
      W1=W1+F1          *EDP10
      W2=W2+F2          *EDP10
      W3=W3+F3          *EDP10
      W4=W4+F1PQAB      *EDP10
      W5=W5+F2PQAB      *EDP10
      W6=W6+F3PQAB      *EDP10
      W7=W7+F2PQA2      *EDP10
      W8=W8+F3PQA2      *EDP10
      W9=W9+F3PQA3      *EDP10
      S1=S1+F0    *EAB
      S2=S2+F1    *EAB
      S3=S3+F2    *EAB
      S4=S4+F3    *EAB
      S6=S6+F1PQAB*EAB
      S7=S7+F2PQAB*EAB
      S8=S8+F3PQAB*EAB
      S9=S9+F1PQA2*EAB
      S10=S10+F2PQA2*EAB
      S11=S11+F3PQA2*EAB
      S12=S12+F2PQA3*EAB
      S13=S13+F3PQA3*EAB
      S14=S14+F3PQA3*PQAB*EAB
      T1=T1+F0    *EAB2
      T2=T2+F1    *EAB2
      T3=T3+F2    *EAB2
      T4=T4+F3    *EAB2
      T5=T5+F4    *EAB2
      T6=T6+F2PQAB*EAB2
      T7=T7+F3PQAB*EAB2
      T8=T8+F4PQAB*EAB2
      T9=T9+F2PQA2*EAB2
      T10=T10+F3PQA2*EAB2
      T11=T11+F4PQA2*EAB2
      T12=T12+F3PQA3*EAB2
      T13=T13+F4PQA3*EAB2
      T14=T14+F4PQA3*PQAB*EAB2
      IF (RABSQ) 80,90,80
   80 CONTINUE
      Y1=Y1+F0    *BPDP01
      Y2=Y2+F1    *BPDP01
      Y3=Y3+F2    *BPDP01
      Y4=Y4+F1PQAB*BPDP01
      Y5=Y5+F2PQAB*BPDP01
      Y6=Y6+F2PQA2*BPDP01
      V1=V1+F0    *APDP10
      V2=V2+F1    *APDP10
      V3=V3+F2    *APDP10
      V4=V4+F1PQAB*APDP10
      V5=V5+F2PQAB*APDP10
      V6=V6+F2PQA2*APDP10
      C1=C1+F0    *APBP
      C2=C2+F1    *APBP
      C3=C3+F2    *APBP
      C4=C4+F1PQAB*APBP
      C5=C5+F2PQAB*APBP
      C6=C6+F2PQA2*APBP
   90 CONTINUE
      A1=AQZ*S2-S6
      A2=AQZ*S3-S7
      A3=AQZ*S4-S8
      A4=AQZ*S6-S9
      A5=AQZ*S7-S10
      A6=AQZ*S8-S11
      A8=AQZ*S10-S12
      A9=AQZ*S11-S13
      A10=AQZ*S13-S14
      BQZ=AQZ-RAB
      B1=BQZ*S2-S6
      B2=BQZ*S3-S7
      B3=BQZ*S4-S8
      B4=BQZ*S6-S9
      B5=BQZ*S7-S10
      B6=BQZ*S8-S11
      B8=BQZ*S10-S12
      B9=BQZ*S11-S13
      B10=BQZ*S13-S14
      HECD=PT5*ECD
      ECD2=ECD*ECD
      HECD2=PT5*ECD2
      QECD=QPERP*ECD
      HQECD=PT5*QECD
      QECD2=QPERP*ECD2
      HQECD2=PT5*QECD2
      Q2ECD=QPERP2*ECD
      Q3ECD=QPERP*Q2ECD
      Q2ECD2=QPERP2*ECD2
      Q3ECD2=Q2ECD2*QPERP
      H0000=X1
      H0001=QECD*X2
      H0003=-ECD*X4
      H0022=HECD*(X1-ECD*X2)
      H0011=H0022+Q2ECD2*X3
      H0013=-QECD2*X5
      H0033=H0022+ECD2*X6
      H0100=-QPERP*Z1
      H0300=Z4+Y1
      H0202=HECD*Z1
      H0101=H0202-Q2ECD*Z2
      H0103=QECD*Z5
      H0301=H0103+QECD*Y2
      H0303=H0202-ECD*Z7-ECD*Y4
      H0212=HQECD2*Z2
      H0223=-HECD2*Z5
      H0122=H0212-QPERP*H0202
      H0322=H0223+HECD*(H0300-ECD*Y2)
      H0113=H0223+Q2ECD2*Z6
      H0313=H0212-QECD2*(Z8+Y5)
      H0111=H0122+H0212+H0212-Q3ECD2*Z3
      H0133=H0122-QECD2*Z8
      H0311=H0322+Q2ECD2*(Z6+Y3)
      H0333=H0322+H0223+H0223+ECD2*(Z9+Y6)
      H1000=-QPERP*W1
      H3000=W4+V1
      H2002=HECD*W1
      H1001=H2002-Q2ECD*W2
      H1003=QECD*W5
      H3001=H1003+QECD*V2
      H3003=H2002-ECD*W7-ECD*V4
      H2012=HQECD2*W2
      H2023=-HECD2*W5
      H1022=H2012-QPERP*H2002
      H3022=H2023+HECD*(H3000-ECD*V2)
      H1013=H2023+Q2ECD2*W6
      H3013=H2012-QECD2*(W8+V5)
      H1011=H1022+H2012+H2012-Q3ECD2*W3
      H1033=H1022-QECD2*W8
      H3011=H3022+Q2ECD2*(W6+V3)
      H3033=H3022+H2023+H2023+ECD2*(W9+V6)
      H2200=PT5*(S1-T2)
      H1100=H2200+QPERP2*T3
      H1300=-QPERP*(T6+B1)
      H3100=-QPERP*(T6+A1)
      H3300=H2200+T9+A4+B4+C1
      H2201=HQECD*(S2-T3)
      H1101=H2201-QECD*T3+Q3ECD*T4
      TEMP =HECD*T6-Q2ECD*T7
      H1301=TEMP+HECD*B1-Q2ECD*B2
      H3101=TEMP+HECD*A1-Q2ECD*A2
      H3301=H2201+QECD*(T10+A5+B5+C2)
      H1202=-HQECD*T3
      H2102=H1202
      H2302=HECD*(T6+B1)
      H3202=HECD*(T6+A1)
      H2203=HECD*(T6-S6)
      H1103=H2203-Q2ECD*T7
      TEMP =-HQECD*T3+QECD*T10
      H1303=TEMP+QECD*B5
      H3103=TEMP+QECD*A5
      H3303=H2203+ECD*(T6-T12-A8-B8-C4)+HECD*(A1+B1)
      H1212=PT25*ECD2*T3-PT5*Q2ECD2*T4
      H2112=H1212
      H2312=HQECD2*(T7+B2)
      H3212=HQECD2*(T7+A2)
      H1223=HQECD2*T7
      H2123=H1223
      H2323=HECD2*(PT5*T3-T10-B5)
      H3223=HECD2*(PT5*T3-T10-A5)
      HXXYY=PT25*(ECD*(S1-T2)-ECD2*(S2-T3))
      H2222=HXXYY+HECD2*T3
      H1122=HXXYY+PT5*(Q2ECD*T3-Q2ECD2*T4)
      TEMP =HQECD*(ECD*T7-T6)
      H1322=TEMP+HQECD*(ECD*B2-B1)
      H3122=TEMP+HQECD*(ECD*A2-A1)
      H3322=HXXYY+HECD*(T9+A4+B4+C1)-HECD2*(T10+A5+B5+C2)
      H2211=HXXYY+PT5*Q2ECD2*(S3-T4)
      H1111=HXXYY+(HECD2+PT5*Q2ECD)*T3+Q2ECD2*(-THREE*T4+PT5*S3+QPERP2*T
     15)
      H1311=ONEPT5*QECD2*(T7+B2)-HQECD*(T6+B1)-Q3ECD2*(B3+T8)
      H3111=ONEPT5*QECD2*(T7+A2)-HQECD*(T6+A1)-Q3ECD2*(A3+T8)
      H3311=HXXYY-HECD2*(QPERP2*T4+T10+A5+B5)+HECD*(T9+A4+B4+C1-ECD*C2)+
     1Q2ECD2*(T11+PT5*S3+A6+B6+C3)
      H2213=HQECD2*(T7-S7)
      H1113=ONEPT5*QECD2*T7-HQECD2*S7-Q3ECD2*T8
      TEMP =HECD2*(PT5*T3-T10)+Q2ECD2*(T11-PT5*T4)
      H1313=TEMP-HECD2*B5+Q2ECD2*B6
      H3113=TEMP-HECD2*A5+Q2ECD2*A6
      H3313=QECD2*(ONEPT5*T7-T13-A9-B9-C5)-HQECD2*(S7-A2-B2)
      H2233=HXXYY+HECD2*(S10-T10)
      H1133=HXXYY-HECD2*(QPERP2*T4+T10-S10)+PT5*Q2ECD*T3+Q2ECD2*T11
      H1333=QECD2*(ONEPT5*T7-T13-B9)-HQECD*(T6+B1)+HQECD2*B2
      H3133=QECD2*(ONEPT5*T7-T13-A9)-HQECD*(T6+A1)+HQECD2*A2
      H3333=HXXYY+HECD2*(-THREE*(A5+B5)+T3+S10-C2)+ECD2*(-THREE*T10+T14+
     1A10+  B10+C6)+HECD*(T9+A4+B4+C1)
      RETURN
      END
      SUBROUTINE ROT2
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
      IMPLICIT REAL*8 (A-H,O-Z)
C*
      COMMON/MISC/MAB,MCD,NGANGB
      COMMON/PHI/COSP,SINP
      COMMON/G/
     *G0000,G0001,G0002,G0003,G0011,G0012,G0013,G0022,G0023,G0033,
     *G0100,G0101,G0102,G0103,G0111,G0112,G0113,G0122,G0123,G0133,
     *G0200,G0201,G0202,G0203,G0211,G0212,G0213,G0222,G0223,G0233,
     *G0300,G0301,G0302,G0303,G0311,G0312,G0313,G0322,G0323,G0333,
     *G1000,G1001,G1002,G1003,G1011,G1012,G1013,G1022,G1023,G1033,
     *G1100,G1101,G1102,G1103,G1111,G1112,G1113,G1122,G1123,G1133,
     *G1200,G1201,G1202,G1203,G1211,G1212,G1213,G1222,G1223,G1233,
     *G1300,G1301,G1302,G1303,G1311,G1312,G1313,G1322,G1323,G1333,
     *G2000,G2001,G2002,G2003,G2011,G2012,G2013,G2022,G2023,G2033,
     *G2100,G2101,G2102,G2103,G2111,G2112,G2113,G2122,G2123,G2133,
     *G2200,G2201,G2202,G2203,G2211,G2212,G2213,G2222,G2223,G2233,
     *G2300,G2301,G2302,G2303,G2311,G2312,G2313,G2322,G2323,G2333,
     *G3000,G3001,G3002,G3003,G3011,G3012,G3013,G3022,G3023,G3033,
     *G3100,G3101,G3102,G3103,G3111,G3112,G3113,G3122,G3123,G3133,
     *G3200,G3201,G3202,G3203,G3211,G3212,G3213,G3222,G3223,G3233,
     *G3300,G3301,G3302,G3303,G3311,G3312,G3313,G3322,G3323,G3333
      COMMON/H/
     *H0000,H0001,H0002,H0003,H0011,H0012,H0013,H0022,H0023,H0033,
     *H0100,H0101,H0102,H0103,H0111,H0112,H0113,H0122,H0123,H0133,
     *H0200,H0201,H0202,H0203,H0211,H0212,H0213,H0222,H0223,H0233,
     *H0300,H0301,H0302,H0303,H0311,H0312,H0313,H0322,H0323,H0333,
     *H1000,H1001,H1002,H1003,H1011,H1012,H1013,H1022,H1023,H1033,
     *H1100,H1101,H1102,H1103,H1111,H1112,H1113,H1122,H1123,H1133,
     *H1200,H1201,H1202,H1203,H1211,H1212,H1213,H1222,H1223,H1233,
     *H1300,H1301,H1302,H1303,H1311,H1312,H1313,H1322,H1323,H1333,
     *H2000,H2001,H2002,H2003,H2011,H2012,H2013,H2022,H2023,H2033,
     *H2100,H2101,H2102,H2103,H2111,H2112,H2113,H2122,H2123,H2133,
     *H2200,H2201,H2202,H2203,H2211,H2212,H2213,H2222,H2223,H2233,
     *H2300,H2301,H2302,H2303,H2311,H2312,H2313,H2322,H2323,H2333,
     *H3000,H3001,H3002,H3003,H3011,H3012,H3013,H3022,H3023,H3033,
     *H3100,H3101,H3102,H3103,H3111,H3112,H3113,H3122,H3123,H3133,
     *H3200,H3201,H3202,H3203,H3211,H3212,H3213,H3222,H3223,H3233,
     *H3300,H3301,H3302,H3303,H3311,H3312,H3313,H3322,H3323,H3333
C*
      EQUIVALENCE(U11,COSP)
      EQUIVALENCE(U22,COSP)
      EQUIVALENCE(U21,SINP)
      EQUIVALENCE(V11,U11)
      EQUIVALENCE(V12,U12)
      EQUIVALENCE(V21,U21)
      EQUIVALENCE(V22,U22)
C*
      DATA ZERO/0.0D0/,ONE/1.0D0/
C*
C     NO ROTATION IF ABCD COPLANAR
      IF (SINP) 20,10,20
   10 IF (COSP) 460,20,420
   20 CONTINUE
      U12=-SINP
      IF (MCD) 40,40,30
   30 V44=V11*V11
      V77=V44
      V47=ONE-V44
      V74=V47
      V54=V11*V21
      V57=-V54
      V45=V57+V57
      V55=V44-V47
   40 IF (MCD) 130,90,50
   50 IF (MAB) 80,70,60
   60 G1011=V44*H1011+V47*H1022
      G1012=V54*H1011+V57*H1022
      G1022=V74*H1011+V77*H1022
      G1013=V11*H1013
      G1023=V21*H1013
      G1033=H1033
      G1111=V44*H1111+V47*H1122
      G1112=V54*H1111+V57*H1122
      G1122=V74*H1111+V77*H1122
      G1113=V11*H1113
      G1123=V21*H1113
      G1133=H1133
      G1211=V45*H1212
      G1212=V55*H1212
      G1222=-G1211
      G1213=V12*H1223
      G1223=V22*H1223
      G1233=ZERO
      G1311=V44*H1311+V47*H1322
      G1312=V54*H1311+V57*H1322
      G1322=V74*H1311+V77*H1322
      G1313=V11*H1313
      G1323=V21*H1313
      G1333=H1333
      G2011=V45*H2012
      G2012=V55*H2012
      G2022=-G2011
      G2013=V12*H2023
      G2023=V22*H2023
      G2033=ZERO
      G2111=V45*H2112
      G2112=V55*H2112
      G2122=-G2111
      G2113=V12*H2123
      G2123=V22*H2123
      G2133=ZERO
      G2211=V44*H2211+V47*H2222
      G2212=V54*H2211+V57*H2222
      G2222=V74*H2211+V77*H2222
      G2213=V11*H2213
      G2223=V21*H2213
      G2233=H2233
      G2311=V45*H2312
      G2312=V55*H2312
      G2322=-G2311
      G2313=V12*H2323
      G2323=V22*H2323
      G2333=ZERO
      G3011=V44*H3011+V47*H3022
      G3012=V54*H3011+V57*H3022
      G3022=V74*H3011+V77*H3022
      G3013=V11*H3013
      G3023=V21*H3013
      G3033=H3033
      G3111=V44*H3111+V47*H3122
      G3112=V54*H3111+V57*H3122
      G3122=V74*H3111+V77*H3122
      G3113=V11*H3113
      G3123=V21*H3113
      G3133=H3133
      G3211=V45*H3212
      G3212=V55*H3212
      G3222=-G3211
      G3213=V12*H3223
      G3223=V22*H3223
      G3233=ZERO
      G3311=V44*H3311+V47*H3322
      G3312=V54*H3311+V57*H3322
      G3322=V74*H3311+V77*H3322
      G3313=V11*H3313
      G3323=V21*H3313
      G3333=H3333
   70 G0111=V44*H0111+V47*H0122
      G0112=V54*H0111+V57*H0122
      G0122=V74*H0111+V77*H0122
      G0113=V11*H0113
      G0123=V21*H0113
      G0133=H0133
      G0211=V45*H0212
      G0212=V55*H0212
      G0222=-G0211
      G0213=V12*H0223
      G0223=V22*H0223
      G0233=ZERO
      G0311=V44*H0311+V47*H0322
      G0312=V54*H0311+V57*H0322
      G0322=V74*H0311+V77*H0322
      G0313=V11*H0313
      G0323=V21*H0313
      G0333=H0333
   80 G0011=V44*H0011+V47*H0022
      G0012=V54*H0011+V57*H0022
      G0022=V74*H0011+V77*H0022
      G0013=V11*H0013
      G0023=V21*H0013
      G0033=H0033
   90 IF (MAB) 120,110,100
  100 G1001=V11*H1001
      G1002=V21*H1001
      G1003=H1003
      G1101=V11*H1101
      G1102=V21*H1101
      G1103=H1103
      G1201=V12*H1202
      G1202=V22*H1202
      G1203=ZERO
      G1301=V11*H1301
      G1302=V21*H1301
      G1303=H1303
      G2001=V12*H2002
      G2002=V22*H2002
      G2003=ZERO
      G2101=V12*H2102
      G2102=V22*H2102
      G2103=ZERO
      G2201=V11*H2201
      G2202=V21*H2201
      G2203=H2203
      G2301=V12*H2302
      G2302=V22*H2302
      G2303=ZERO
      G3001=V11*H3001
      G3002=V21*H3001
      G3003=H3003
      G3101=V11*H3101
      G3102=V21*H3101
      G3103=H3103
      G3201=V12*H3202
      G3202=V22*H3202
      G3203=ZERO
      G3301=V11*H3301
      G3302=V21*H3301
      G3303=H3303
  110 G0101=V11*H0101
      G0102=V21*H0101
      G0103=H0103
      G0201=V12*H0202
      G0202=V22*H0202
      G0203=ZERO
      G0301=V11*H0301
      G0302=V21*H0301
      G0303=H0303
  120 G0001=V11*H0001
      G0002=V21*H0001
      G0003=H0003
  130 IF (MAB) 160,150,140
  140 G1000=H1000
      G1100=H1100
      G1200=ZERO
      G1300=H1300
      G2000=ZERO
      G2100=ZERO
      G2200=H2200
      G2300=ZERO
      G3000=H3000
      G3100=H3100
      G3200=ZERO
      G3300=H3300
  150 G0100=H0100
      G0200=ZERO
      G0300=H0300
  160 G0000=H0000
  170 IF(MCD) 260,220,180
  180 IF (MAB) 210,200,190
  190 H1011=U11*G1011+U12*G2011
      H1012=U11*G1012+U12*G2012
      H1013=U11*G1013+U12*G2013
      H1022=U11*G1022+U12*G2022
      H1023=U11*G1023+U12*G2023
      H1033=U11*G1033+U12*G2033
      H1111=U11*G1111+U12*G2111
      H1112=U11*G1112+U12*G2112
      H1113=U11*G1113+U12*G2113
      H1122=U11*G1122+U12*G2122
      H1123=U11*G1123+U12*G2123
      H1133=U11*G1133+U12*G2133
      H1211=U11*G1211+U12*G2211
      H1212=U11*G1212+U12*G2212
      H1213=U11*G1213+U12*G2213
      H1222=U11*G1222+U12*G2222
      H1223=U11*G1223+U12*G2223
      H1233=U11*G1233+U12*G2233
      H1311=U11*G1311+U12*G2311
      H1312=U11*G1312+U12*G2312
      H1313=U11*G1313+U12*G2313
      H1322=U11*G1322+U12*G2322
      H1323=U11*G1323+U12*G2323
      H1333=U11*G1333+U12*G2333
      H2011=U21*G1011+U22*G2011
      H2012=U21*G1012+U22*G2012
      H2013=U21*G1013+U22*G2013
      H2022=U21*G1022+U22*G2022
      H2023=U21*G1023+U22*G2023
      H2033=U21*G1033+U22*G2033
      H2111=U21*G1111+U22*G2111
      H2112=U21*G1112+U22*G2112
      H2113=U21*G1113+U22*G2113
      H2122=U21*G1122+U22*G2122
      H2123=U21*G1123+U22*G2123
      H2133=U21*G1133+U22*G2133
      H2211=U21*G1211+U22*G2211
      H2212=U21*G1212+U22*G2212
      H2213=U21*G1213+U22*G2213
      H2222=U21*G1222+U22*G2222
      H2223=U21*G1223+U22*G2223
      H2233=U21*G1233+U22*G2233
      H2311=U21*G1311+U22*G2311
      H2312=U21*G1312+U22*G2312
      H2313=U21*G1313+U22*G2313
      H2322=U21*G1322+U22*G2322
      H2323=U21*G1323+U22*G2323
      H2333=U21*G1333+U22*G2333
      H3011=G3011
      H3012=G3012
      H3013=G3013
      H3022=G3022
      H3023=G3023
      H3033=G3033
      H3111=G3111
      H3112=G3112
      H3113=G3113
      H3122=G3122
      H3123=G3123
      H3133=G3133
      H3211=G3211
      H3212=G3212
      H3213=G3213
      H3222=G3222
      H3223=G3223
      H3233=G3233
      H3311=G3311
      H3312=G3312
      H3313=G3313
      H3322=G3322
      H3323=G3323
      H3333=G3333
  200 H0111=G0111
      H0112=G0112
      H0113=G0113
      H0122=G0122
      H0123=G0123
      H0133=G0133
      H0211=G0211
      H0212=G0212
      H0213=G0213
      H0222=G0222
      H0223=G0223
      H0233=G0233
      H0311=G0311
      H0312=G0312
      H0313=G0313
      H0322=G0322
      H0323=G0323
      H0333=G0333
  210 H0011=G0011
      H0012=G0012
      H0013=G0013
      H0022=G0022
      H0023=G0023
      H0033=G0033
  220 IF (MAB) 250,240,230
  230 H1001=U11*G1001+U12*G2001
      H1002=U11*G1002+U12*G2002
      H1003=U11*G1003+U12*G2003
      H1101=U11*G1101+U12*G2101
      H1102=U11*G1102+U12*G2102
      H1103=U11*G1103+U12*G2103
      H1201=U11*G1201+U12*G2201
      H1202=U11*G1202+U12*G2202
      H1203=U11*G1203+U12*G2203
      H1301=U11*G1301+U12*G2301
      H1302=U11*G1302+U12*G2302
      H1303=U11*G1303+U12*G2303
      H2001=U21*G1001+U22*G2001
      H2002=U21*G1002+U22*G2002
      H2003=U21*G1003+U22*G2003
      H2101=U21*G1101+U22*G2101
      H2102=U21*G1102+U22*G2102
      H2103=U21*G1103+U22*G2103
      H2201=U21*G1201+U22*G2201
      H2202=U21*G1202+U22*G2202
      H2203=U21*G1203+U22*G2203
      H2301=U21*G1301+U22*G2301
      H2302=U21*G1302+U22*G2302
      H2303=U21*G1303+U22*G2303
      H3001=G3001
      H3002=G3002
      H3003=G3003
      H3101=G3101
      H3102=G3102
      H3103=G3103
      H3201=G3201
      H3202=G3202
      H3203=G3203
      H3301=G3301
      H3302=G3302
      H3303=G3303
  240 H0101=G0101
      H0102=G0102
      H0103=G0103
      H0201=G0201
      H0202=G0202
      H0203=G0203
      H0301=G0301
      H0302=G0302
      H0303=G0303
  250 H0001=G0001
      H0002=G0002
      H0003=G0003
  260 IF (MAB) 290,280,270
  270 H1000=U11*G1000+U12*G2000
      H1100=U11*G1100+U12*G2100
      H1200=U11*G1200+U12*G2200
      H1300=U11*G1300+U12*G2300
      H2000=U21*G1000+U22*G2000
      H2100=U21*G1100+U22*G2100
      H2200=U21*G1200+U22*G2200
      H2300=U21*G1300+U22*G2300
      H3000=G3000
      H3100=G3100
      H3200=G3200
      H3300=G3300
  280 H0100=G0100
      H0200=G0200
      H0300=G0300
  290 H0000=G0000
C*
      IF (MCD) 380,340,300
  300 IF (MAB) 330,320,310
  310 G1011=H1011
      G1012=H1012
      G1013=H1013
      G1022=H1022
      G1023=H1023
      G1033=H1033
      G1111=U11*H1111+U12*H1211
      G1112=U11*H1112+U12*H1212
      G1113=U11*H1113+U12*H1213
      G1122=U11*H1122+U12*H1222
      G1123=U11*H1123+U12*H1223
      G1133=U11*H1133+U12*H1233
      G1211=U21*H1111+U22*H1211
      G1212=U21*H1112+U22*H1212
      G1213=U21*H1113+U22*H1213
      G1222=U21*H1122+U22*H1222
      G1223=U21*H1123+U22*H1223
      G1233=U21*H1133+U22*H1233
      G1311=H1311
      G1312=H1312
      G1313=H1313
      G1322=H1322
      G1323=H1323
      G1333=H1333
      G2011=H2011
      G2012=H2012
      G2013=H2013
      G2022=H2022
      G2023=H2023
      G2033=H2033
      G2111=U11*H2111+U12*H2211
      G2112=U11*H2112+U12*H2212
      G2113=U11*H2113+U12*H2213
      G2122=U11*H2122+U12*H2222
      G2123=U11*H2123+U12*H2223
      G2133=U11*H2133+U12*H2233
      G2211=U21*H2111+U22*H2211
      G2212=U21*H2112+U22*H2212
      G2213=U21*H2113+U22*H2213
      G2222=U21*H2122+U22*H2222
      G2223=U21*H2123+U22*H2223
      G2233=U21*H2133+U22*H2233
      G2311=H2311
      G2312=H2312
      G2313=H2313
      G2322=H2322
      G2323=H2323
      G2333=H2333
      G3011=H3011
      G3012=H3012
      G3013=H3013
      G3022=H3022
      G3023=H3023
      G3033=H3033
      G3111=U11*H3111+U12*H3211
      G3112=U11*H3112+U12*H3212
      G3113=U11*H3113+U12*H3213
      G3122=U11*H3122+U12*H3222
      G3123=U11*H3123+U12*H3223
      G3133=U11*H3133+U12*H3233
      G3211=U21*H3111+U22*H3211
      G3212=U21*H3112+U22*H3212
      G3213=U21*H3113+U22*H3213
      G3222=U21*H3122+U22*H3222
      G3223=U21*H3123+U22*H3223
      G3233=U21*H3133+U22*H3233
      G3311=H3311
      G3312=H3312
      G3313=H3313
      G3322=H3322
      G3323=H3323
      G3333=H3333
  320 G0111=U11*H0111+U12*H0211
      G0112=U11*H0112+U12*H0212
      G0113=U11*H0113+U12*H0213
      G0122=U11*H0122+U12*H0222
      G0123=U11*H0123+U12*H0223
      G0133=U11*H0133+U12*H0233
      G0211=U21*H0111+U22*H0211
      G0212=U21*H0112+U22*H0212
      G0213=U21*H0113+U22*H0213
      G0222=U21*H0122+U22*H0222
      G0223=U21*H0123+U22*H0223
      G0233=U21*H0133+U22*H0233
      G0311=H0311
      G0312=H0312
      G0313=H0313
      G0322=H0322
      G0323=H0323
      G0333=H0333
  330 G0011=H0011
      G0012=H0012
      G0013=H0013
      G0022=H0022
      G0023=H0023
      G0033=H0033
  340 IF (MAB) 370,360,350
  350 G1001=H1001
      G1002=H1002
      G1003=H1003
      G1101=U11*H1101+U12*H1201
      G1102=U11*H1102+U12*H1202
      G1103=U11*H1103+U12*H1203
      G1201=U21*H1101+U22*H1201
      G1202=U21*H1102+U22*H1202
      G1203=U21*H1103+U22*H1203
      G1301=H1301
      G1302=H1302
      G1303=H1303
      G2001=H2001
      G2002=H2002
      G2003=H2003
      G2101=U11*H2101+U12*H2201
      G2102=U11*H2102+U12*H2202
      G2103=U11*H2103+U12*H2203
      G2201=U21*H2101+U22*H2201
      G2202=U21*H2102+U22*H2202
      G2203=U21*H2103+U22*H2203
      G2301=H2301
      G2302=H2302
      G2303=H2303
      G3001=H3001
      G3002=H3002
      G3003=H3003
      G3101=U11*H3101+U12*H3201
      G3102=U11*H3102+U12*H3202
      G3103=U11*H3103+U12*H3203
      G3201=U21*H3101+U22*H3201
      G3202=U21*H3102+U22*H3202
      G3203=U21*H3103+U22*H3203
      G3301=H3301
      G3302=H3302
      G3303=H3303
  360 G0101=U11*H0101+U12*H0201
      G0102=U11*H0102+U12*H0202
      G0103=U11*H0103+U12*H0203
      G0201=U21*H0101+U22*H0201
      G0202=U21*H0102+U22*H0202
      G0203=U21*H0103+U22*H0203
      G0301=H0301
      G0302=H0302
      G0303=H0303
  370 G0001=H0001
      G0002=H0002
      G0003=H0003
  380 IF (MAB) 410,400,390
  390 G1000=H1000
      G1100=U11*H1100+U12*H1200
      G1200=U21*H1100+U22*H1200
      G1300=H1300
      G2000=H2000
      G2100=U11*H2100+U12*H2200
      G2200=U21*H2100+U22*H2200
      G2300=H2300
      G3000=H3000
      G3100=U11*H3100+U12*H3200
      G3200=U21*H3100+U22*H3200
      G3300=H3300
  400 G0100=U11*H0100+U12*H0200
      G0200=U21*H0100+U22*H0200
      G0300=H0300
  410 G0000=H0000
      RETURN
  420 IF (MAB) 450,440,430
  430 G1000=H1000
      G1001=H1001
      G1002=ZERO
      G1003=H1003
      G1011=H1011
      G1012=ZERO
      G1013=H1013
      G1022=H1022
      G1023=ZERO
      G1033=H1033
      G1100=H1100
      G1101=H1101
      G1102=ZERO
      G1103=H1103
      G1111=H1111
      G1112=ZERO
      G1113=H1113
      G1122=H1122
      G1123=ZERO
      G1133=H1133
      G1200=ZERO
      G1201=ZERO
      G1202=H1202
      G1203=ZERO
      G1211=ZERO
      G1212=H1212
      G1213=ZERO
      G1222=ZERO
      G1223=H1223
      G1233=ZERO
      G1300=H1300
      G1301=H1301
      G1302=ZERO
      G1303=H1303
      G1311=H1311
      G1312=ZERO
      G1313=H1313
      G1322=H1322
      G1323=ZERO
      G1333=H1333
      G2000=ZERO
      G2001=ZERO
      G2002=H2002
      G2003=ZERO
      G2011=ZERO
      G2012=H2012
      G2013=ZERO
      G2022=ZERO
      G2023=H2023
      G2033=ZERO
      G2100=ZERO
      G2101=ZERO
      G2102=H2102
      G2103=ZERO
      G2111=ZERO
      G2112=H2112
      G2113=ZERO
      G2122=ZERO
      G2123=H2123
      G2133=ZERO
      G2200=H2200
      G2201=H2201
      G2202=ZERO
      G2203=H2203
      G2211=H2211
      G2212=ZERO
      G2213=H2213
      G2222=H2222
      G2223=ZERO
      G2233=H2233
      G2300=ZERO
      G2301=ZERO
      G2302=H2302
      G2303=ZERO
      G2311=ZERO
      G2312=H2312
      G2313=ZERO
      G2322=ZERO
      G2323=H2323
      G2333=ZERO
      G3000=H3000
      G3001=H3001
      G3002=ZERO
      G3003=H3003
      G3011=H3011
      G3012=ZERO
      G3013=H3013
      G3022=H3022
      G3023=ZERO
      G3033=H3033
      G3100=H3100
      G3101=H3101
      G3102=ZERO
      G3103=H3103
      G3111=H3111
      G3112=ZERO
      G3113=H3113
      G3122=H3122
      G3123=ZERO
      G3133=H3133
      G3200=ZERO
      G3201=ZERO
      G3202=H3202
      G3203=ZERO
      G3211=ZERO
      G3212=H3212
      G3213=ZERO
      G3222=ZERO
      G3223=H3223
      G3233=ZERO
      G3300=H3300
      G3301=H3301
      G3302=ZERO
      G3303=H3303
      G3311=H3311
      G3312=ZERO
      G3313=H3313
      G3322=H3322
      G3323=ZERO
      G3333=H3333
  440 G0100=H0100
      G0101=H0101
      G0102=ZERO
      G0103=H0103
      G0111=H0111
      G0112=ZERO
      G0113=H0113
      G0122=H0122
      G0123=ZERO
      G0133=H0133
      G0200=ZERO
      G0201=ZERO
      G0202=H0202
      G0203=ZERO
      G0211=ZERO
      G0212=H0212
      G0213=ZERO
      G0222=ZERO
      G0223=H0223
      G0233=ZERO
      G0300=H0300
      G0301=H0301
      G0302=ZERO
      G0303=H0303
      G0311=H0311
      G0312=ZERO
      G0313=H0313
      G0322=H0322
      G0323=ZERO
      G0333=H0333
  450 G0000=H0000
      G0001=H0001
      G0002=ZERO
      G0003=H0003
      G0011=H0011
      G0012=ZERO
      G0013=H0013
      G0022=H0022
      G0023=ZERO
      G0033=H0033
      RETURN
  460 IF(MAB)490,480,470
  470 G1000=-H1000
      G1001=H1001
      G1002=ZERO
      G1003=-H1003
      G1011=-H1011
      G1012=ZERO
      G1013=H1013
      G1022=-H1022
      G1023=ZERO
      G1033=-H1033
      G1100=H1100
      G1101=-H1101
      G1102=ZERO
      G1103=H1103
      G1111=H1111
      G1112=ZERO
      G1113=-H1113
      G1122=H1122
      G1123=ZERO
      G1133=H1133
      G1200=ZERO
      G1201=ZERO
      G1202=-H1202
      G1203=ZERO
      G1211=ZERO
      G1212=H1212
      G1213=ZERO
      G1222=ZERO
      G1223=-H1223
      G1233=ZERO
      G1300=-H1300
      G1301=H1301
      G1302=ZERO
      G1303=-H1303
      G1311=-H1311
      G1312=ZERO
      G1313=H1313
      G1322=-H1322
      G1323=ZERO
      G1333=-H1333
      G2000=ZERO
      G2001=ZERO
      G2002=H2002
      G2003=ZERO
      G2011=ZERO
      G2012=-H2012
      G2013=ZERO
      G2022=ZERO
      G2023=H2023
      G2033=ZERO
      G2100=ZERO
      G2101=ZERO
      G2102=-H2102
      G2103=ZERO
      G2111=ZERO
      G2112=H2112
      G2113=ZERO
      G2122=ZERO
      G2123=-H2123
      G2133=ZERO
      G2200=H2200
      G2201=-H2201
      G2202=ZERO
      G2203=H2203
      G2211=H2211
      G2212=ZERO
      G2213=-H2213
      G2222=H2222
      G2223=ZERO
      G2233=H2233
      G2300=ZERO
      G2301=ZERO
      G2302=H2302
      G2303=ZERO
      G2311=ZERO
      G2312=-H2312
      G2313=ZERO
      G2322=ZERO
      G2323=H2323
      G2333=ZERO
      G3000=H3000
      G3001=-H3001
      G3002=ZERO
      G3003=H3003
      G3011=H3011
      G3012=ZERO
      G3013=-H3013
      G3022=H3022
      G3023=ZERO
      G3033=H3033
      G3100=-H3100
      G3101=H3101
      G3102=ZERO
      G3103=-H3103
      G3111=-H3111
      G3112=ZERO
      G3113=H3113
      G3122=-H3122
      G3123=ZERO
      G3133=-H3133
      G3200=ZERO
      G3201=ZERO
      G3202=H3202
      G3203=ZERO
      G3211=ZERO
      G3212=-H3212
      G3213=ZERO
      G3222=ZERO
      G3223=H3223
      G3233=ZERO
      G3300=H3300
      G3301=-H3301
      G3302=ZERO
      G3303=H3303
      G3311=H3311
      G3312=ZERO
      G3313=-H3313
      G3322=H3322
      G3323=ZERO
      G3333=H3333
  480 G0100=-H0100
      G0101=H0101
      G0102=ZERO
      G0103=-H0103
      G0111=-H0111
      G0112=ZERO
      G0113=H0113
      G0122=-H0122
      G0123=ZERO
      G0133=-H0133
      G0200=ZERO
      G0201=ZERO
      G0202=H0202
      G0203=ZERO
      G0211=ZERO
      G0212=-H0212
      G0213=ZERO
      G0222=ZERO
      G0223=H0223
      G0233=ZERO
      G0300=H0300
      G0301=-H0301
      G0302=ZERO
      G0303=H0303
      G0311=H0311
      G0312=ZERO
      G0313=-H0313
      G0322=H0322
      G0323=ZERO
      G0333=H0333
  490 G0000=H0000
      G0001=-H0001
      G0002=ZERO
      G0003=H0003
      G0011=H0011
      G0012=ZERO
      G0013=-H0013
      G0022=H0022
      G0023=ZERO
      G0033=H0033
      RETURN
      END
      SUBROUTINE TQ0101
C*
C     --------------
C     QCPE VERSION
C    DECEMBER 1971
C     --------------
C*
C     TRANSLATES UP TO 160 INTEGRALS ON A B AND Q TO UP TO 256 INTEGRALS
C     ON A B C AND D
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/G/
     *G0000,G0001,G0002,G0003,G0011,G0012,G0013,G0022,G0023,G0033,
     *G0100,G0101,G0102,G0103,G0111,G0112,G0113,G0122,G0123,G0133,
     *G0200,G0201,G0202,G0203,G0211,G0212,G0213,G0222,G0223,G0233,
     *G0300,G0301,G0302,G0303,G0311,G0312,G0313,G0322,G0323,G0333,
     *G1000,G1001,G1002,G1003,G1011,G1012,G1013,G1022,G1023,G1033,
     *G1100,G1101,G1102,G1103,G1111,G1112,G1113,G1122,G1123,G1133,
     *G1200,G1201,G1202,G1203,G1211,G1212,G1213,G1222,G1223,G1233,
     *G1300,G1301,G1302,G1303,G1311,G1312,G1313,G1322,G1323,G1333,
     *G2000,G2001,G2002,G2003,G2011,G2012,G2013,G2022,G2023,G2033,
     *G2100,G2101,G2102,G2103,G2111,G2112,G2113,G2122,G2123,G2133,
     *G2200,G2201,G2202,G2203,G2211,G2212,G2213,G2222,G2223,G2233,
     *G2300,G2301,G2302,G2303,G2311,G2312,G2313,G2322,G2323,G2333,
     *G3000,G3001,G3002,G3003,G3011,G3012,G3013,G3022,G3023,G3033,
     *G3100,G3101,G3102,G3103,G3111,G3112,G3113,G3122,G3123,G3133,
     *G3200,G3201,G3202,G3203,G3211,G3212,G3213,G3222,G3223,G3233,
     *G3300,G3301,G3302,G3303,G3311,G3312,G3313,G3322,G3323,G3333
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/PQGEOM/AP,BP,CQ,DQ,PX,PY,PZ,QX,QY,QZ,RPQ,RPQSQ,PQ1,PQ2,PQ3,
     *C11,C12,C13,C21,C22,C23,C31,C32,C33
      COMMON/QGEOM/ACX,ACY,ACZ,ACY2,COSG,SING,AQX,AQZ,QPERP,QPERP2
      COMMON/DPQ/DP00,DP01,DP10,DP11,DQ00,DQ01,DQ10,DQ11
      COMMON/GOUT/GOUT(256)
C*
C     R13=COMPONENT OF CQ ALONG PENULTIMATE X-AXIS
C     R33=COMPONENT OF CQ ALONF PENULTIMATE Z-AXIS
C     R14=COMPONENT OF DQ ALONG PENULTIMATE X-AXIS
C     R34=COMPONENT OF DQ ALONG PENULTIMATE Z-AXIS
      R14=DQ*SING
      R34=DQ*COSG
      IF (RCDSQ) 2,2,1
    1 CONTINUE
      G0001=G0001+R14*G0000
      G0101=G0101+R14*G0100
      G0201=G0201+R14*G0200
      G0301=G0301+R14*G0300
      G0003=G0003+R34*G0000
      G0103=G0103+R34*G0100
      G0203=G0203+R34*G0200
      G0303=G0303+R34*G0300
    2 CONTINUE
      GOUT(  1)=GOUT(  1)+G0000*DQ00
      GOUT(  2)=GOUT(  2)+G0001*DQ01
      GOUT(  3)=GOUT(  3)+G0002*DQ01
      GOUT(  4)=GOUT(  4)+G0003*DQ01
      GOUT( 17)=GOUT( 17)+G0100*DQ00
      GOUT( 18)=GOUT( 18)+G0101*DQ01
      GOUT( 19)=GOUT( 19)+G0102*DQ01
      GOUT( 20)=GOUT( 20)+G0103*DQ01
      GOUT( 33)=GOUT( 33)+G0200*DQ00
      GOUT( 34)=GOUT( 34)+G0201*DQ01
      GOUT( 35)=GOUT( 35)+G0202*DQ01
      GOUT( 36)=GOUT( 36)+G0203*DQ01
      GOUT( 49)=GOUT( 49)+G0300*DQ00
      GOUT( 50)=GOUT( 50)+G0301*DQ01
      GOUT( 51)=GOUT( 51)+G0302*DQ01
      GOUT( 52)=GOUT( 52)+G0303*DQ01
      RETURN
      END
      SUBROUTINE TQ0011
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     TRANSLATES UP TO 160 INTEGRALS ON A B AND Q TO UP TO 256 INTEGRALS
C     ON A B C AND D
C*
      IMPLICIT REAL*8 (A-H,O-Z)
C*
      COMMON/G/
     *G0000,G0001,G0002,G0003,G0011,G0012,G0013,G0022,G0023,G0033,
     *G0100,G0101,G0102,G0103,G0111,G0112,G0113,G0122,G0123,G0133,
     *G0200,G0201,G0202,G0203,G0211,G0212,G0213,G0222,G0223,G0233,
     *G0300,G0301,G0302,G0303,G0311,G0312,G0313,G0322,G0323,G0333,
     *G1000,G1001,G1002,G1003,G1011,G1012,G1013,G1022,G1023,G1033,
     *G1100,G1101,G1102,G1103,G1111,G1112,G1113,G1122,G1123,G1133,
     *G1200,G1201,G1202,G1203,G1211,G1212,G1213,G1222,G1223,G1233,
     *G1300,G1301,G1302,G1303,G1311,G1312,G1313,G1322,G1323,G1333,
     *G2000,G2001,G2002,G2003,G2011,G2012,G2013,G2022,G2023,G2033,
     *G2100,G2101,G2102,G2103,G2111,G2112,G2113,G2122,G2123,G2133,
     *G2200,G2201,G2202,G2203,G2211,G2212,G2213,G2222,G2223,G2233,
     *G2300,G2301,G2302,G2303,G2311,G2312,G2313,G2322,G2323,G2333,
     *G3000,G3001,G3002,G3003,G3011,G3012,G3013,G3022,G3023,G3033,
     *G3100,G3101,G3102,G3103,G3111,G3112,G3113,G3122,G3123,G3133,
     *G3200,G3201,G3202,G3203,G3211,G3212,G3213,G3222,G3223,G3233,
     *G3300,G3301,G3302,G3303,G3311,G3312,G3313,G3322,G3323,G3333
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/PQGEOM/AP,BP,CQ,DQ,PX,PY,PZ,QX,QY,QZ,RPQ,RPQSQ,PQ1,PQ2,PQ3,
     *C11,C12,C13,C21,C22,C23,C31,C32,C33
      COMMON/QGEOM/ACX,ACY,ACZ,ACY2,COSG,SING,AQX,AQZ,QPERP,QPERP2
      COMMON/DPQ/DP00,DP01,DP10,DP11,DQ00,DQ01,DQ10,DQ11
      COMMON/GOUT/GOUT(256)
C*
C     R13=COMPONENT OF CQ ALONG PENULTIMATE X-AXIS
C     R33=COMPONENT OF CQ ALONG PENULTIMATE Z-AXIS
C     R14=COMPONENT OF DQ ALONG PENULTIMATE X-AXIS
C     R34=COMPONENT OF DQ ALONG PENULTIMATE Z-AXIS
      R13=CQ*SING
      R33=CQ*COSG
      R14=DQ*SING
      R34=DQ*COSG
      G0010=G0001
      G0020=G0002
      G0021=G0012
      G0030=G0003
      G0031=G0013
      G0032=G0023
      IF (RCDSQ) 2,2,1
    1 CONTINUE
      G0010=G0010+R13*G0000
      G0011=G0011+R13*G0001
      G0012=G0012+R13*G0002
      G0013=G0013+R13*G0003
      G0030=G0030+R33*G0000
      G0031=G0031+R33*G0001
      G0032=G0032+R33*G0002
      G0033=G0033+R33*G0003
      G0001=G0001+R14*G0000
      G0011=G0011+R14*G0010
      G0021=G0021+R14*G0020
      G0031=G0031+R14*G0030
      G0003=G0003+R34*G0000
      G0013=G0013+R34*G0010
      G0023=G0023+R34*G0020
      G0033=G0033+R34*G0030
    2 CONTINUE
      GOUT(  1)=GOUT(  1)+G0000*DQ00
      GOUT(  2)=GOUT(  2)+G0001*DQ01
      GOUT(  3)=GOUT(  3)+G0002*DQ01
      GOUT(  4)=GOUT(  4)+G0003*DQ01
      GOUT(  5)=GOUT(  5)+G0010*DQ10
      GOUT(  6)=GOUT(  6)+G0011*DQ11
      GOUT(  7)=GOUT(  7)+G0012*DQ11
      GOUT(  8)=GOUT(  8)+G0013*DQ11
      GOUT(  9)=GOUT(  9)+G0020*DQ10
      GOUT( 10)=GOUT( 10)+G0021*DQ11
      GOUT( 11)=GOUT( 11)+G0022*DQ11
      GOUT( 12)=GOUT( 12)+G0023*DQ11
      GOUT( 13)=GOUT( 13)+G0030*DQ10
      GOUT( 14)=GOUT( 14)+G0031*DQ11
      GOUT( 15)=GOUT( 15)+G0032*DQ11
      GOUT( 16)=GOUT( 16)+G0033*DQ11
      RETURN
      END
      SUBROUTINE TQ0111
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     TRANSLATES UP TO 160 INTEGRALS ON A B AND Q TO UP TO 256 INTEGRALS
C     ON A B C AND D
C*
      IMPLICIT REAL*8 (A-H,O-Z)
C*
      COMMON/G/
     *G0000,G0001,G0002,G0003,G0011,G0012,G0013,G0022,G0023,G0033,
     *G0100,G0101,G0102,G0103,G0111,G0112,G0113,G0122,G0123,G0133,
     *G0200,G0201,G0202,G0203,G0211,G0212,G0213,G0222,G0223,G0233,
     *G0300,G0301,G0302,G0303,G0311,G0312,G0313,G0322,G0323,G0333,
     *G1000,G1001,G1002,G1003,G1011,G1012,G1013,G1022,G1023,G1033,
     *G1100,G1101,G1102,G1103,G1111,G1112,G1113,G1122,G1123,G1133,
     *G1200,G1201,G1202,G1203,G1211,G1212,G1213,G1222,G1223,G1233,
     *G1300,G1301,G1302,G1303,G1311,G1312,G1313,G1322,G1323,G1333,
     *G2000,G2001,G2002,G2003,G2011,G2012,G2013,G2022,G2023,G2033,
     *G2100,G2101,G2102,G2103,G2111,G2112,G2113,G2122,G2123,G2133,
     *G2200,G2201,G2202,G2203,G2211,G2212,G2213,G2222,G2223,G2233,
     *G2300,G2301,G2302,G2303,G2311,G2312,G2313,G2322,G2323,G2333,
     *G3000,G3001,G3002,G3003,G3011,G3012,G3013,G3022,G3023,G3033,
     *G3100,G3101,G3102,G3103,G3111,G3112,G3113,G3122,G3123,G3133,
     *G3200,G3201,G3202,G3203,G3211,G3212,G3213,G3222,G3223,G3233,
     *G3300,G3301,G3302,G3303,G3311,G3312,G3313,G3322,G3323,G3333
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/PQGEOM/AP,BP,CQ,DQ,PX,PY,PZ,QX,QY,QZ,RPQ,RPQSQ,PQ1,PQ2,PQ3,
     *C11,C12,C13,C21,C22,C23,C31,C32,C33
      COMMON/QGEOM/ACX,ACY,ACZ,ACY2,COSG,SING,AQX,AQZ,QPERP,QPERP2
      COMMON/DPQ/DP00,DP01,DP10,DP11,DQ00,DQ01,DQ10,DQ11
      COMMON/GOUT/GOUT(256)
C*
C     R13=COMPONENT OF CQ ALONG PENULTIMATE X-AXIS
C     R33=COMPONENT OF CQ ALONG PENULTIMATE Z-AXIS
C     R14=COMPONENT OF DQ ALONG PENULTIMATE X-AXIS
C     R34=COMPONENT OF DQ ALONG PENULTIMATE Z-AXIS
C*
      R13=CQ*SING
      R33=CQ*COSG
      R14=DQ*SING
      R34=DQ*COSG
      G0010=G0001
      G0020=G0002
      G0021=G0012
      G0030=G0003
      G0031=G0013
      G0032=G0023
      G0110=G0101
      G0120=G0102
      G0121=G0112
      G0130=G0103
      G0131=G0113
      G0132=G0123
      G0210=G0201
      G0220=G0202
      G0221=G0212
      G0230=G0203
      G0231=G0213
      G0232=G0223
      G0310=G0301
      G0320=G0302
      G0321=G0312
      G0330=G0303
      G0331=G0313
      G0332=G0323
      IF (RCDSQ) 2,2,1
    1 CONTINUE
      G0010=G0010+R13*G0000
      G0011=G0011+R13*G0001
      G0012=G0012+R13*G0002
      G0013=G0013+R13*G0003
      G0110=G0110+R13*G0100
      G0111=G0111+R13*G0101
      G0112=G0112+R13*G0102
      G0113=G0113+R13*G0103
      G0210=G0210+R13*G0200
      G0211=G0211+R13*G0201
      G0212=G0212+R13*G0202
      G0213=G0213+R13*G0203
      G0310=G0310+R13*G0300
      G0311=G0311+R13*G0301
      G0312=G0312+R13*G0302
      G0313=G0313+R13*G0303
      G0030=G0030+R33*G0000
      G0031=G0031+R33*G0001
      G0032=G0032+R33*G0002
      G0033=G0033+R33*G0003
      G0130=G0130+R33*G0100
      G0131=G0131+R33*G0101
      G0132=G0132+R33*G0102
      G0133=G0133+R33*G0103
      G0230=G0230+R33*G0200
      G0231=G0231+R33*G0201
      G0232=G0232+R33*G0202
      G0233=G0233+R33*G0203
      G0330=G0330+R33*G0300
      G0331=G0331+R33*G0301
      G0332=G0332+R33*G0302
      G0333=G0333+R33*G0303
      G0001=G0001+R14*G0000
      G0011=G0011+R14*G0010
      G0021=G0021+R14*G0020
      G0031=G0031+R14*G0030
      G0101=G0101+R14*G0100
      G0111=G0111+R14*G0110
      G0121=G0121+R14*G0120
      G0131=G0131+R14*G0130
      G0201=G0201+R14*G0200
      G0211=G0211+R14*G0210
      G0221=G0221+R14*G0220
      G0231=G0231+R14*G0230
      G0301=G0301+R14*G0300
      G0311=G0311+R14*G0310
      G0321=G0321+R14*G0320
      G0331=G0331+R14*G0330
      G0003=G0003+R34*G0000
      G0013=G0013+R34*G0010
      G0023=G0023+R34*G0020
      G0033=G0033+R34*G0030
      G0103=G0103+R34*G0100
      G0113=G0113+R34*G0110
      G0123=G0123+R34*G0120
      G0133=G0133+R34*G0130
      G0203=G0203+R34*G0200
      G0213=G0213+R34*G0210
      G0223=G0223+R34*G0220
      G0233=G0233+R34*G0230
      G0303=G0303+R34*G0300
      G0313=G0313+R34*G0310
      G0323=G0323+R34*G0320
      G0333=G0333+R34*G0330
    2 CONTINUE
      GOUT(  1)=GOUT(  1)+G0000*DQ00
      GOUT(  2)=GOUT(  2)+G0001*DQ01
      GOUT(  3)=GOUT(  3)+G0002*DQ01
      GOUT(  4)=GOUT(  4)+G0003*DQ01
      GOUT(  5)=GOUT(  5)+G0010*DQ10
      GOUT(  6)=GOUT(  6)+G0011*DQ11
      GOUT(  7)=GOUT(  7)+G0012*DQ11
      GOUT(  8)=GOUT(  8)+G0013*DQ11
      GOUT(  9)=GOUT(  9)+G0020*DQ10
      GOUT( 10)=GOUT( 10)+G0021*DQ11
      GOUT( 11)=GOUT( 11)+G0022*DQ11
      GOUT( 12)=GOUT( 12)+G0023*DQ11
      GOUT( 13)=GOUT( 13)+G0030*DQ10
      GOUT( 14)=GOUT( 14)+G0031*DQ11
      GOUT( 15)=GOUT( 15)+G0032*DQ11
      GOUT( 16)=GOUT( 16)+G0033*DQ11
      GOUT( 17)=GOUT( 17)+G0100*DQ00
      GOUT( 18)=GOUT( 18)+G0101*DQ01
      GOUT( 19)=GOUT( 19)+G0102*DQ01
      GOUT( 20)=GOUT( 20)+G0103*DQ01
      GOUT( 21)=GOUT( 21)+G0110*DQ10
      GOUT( 22)=GOUT( 22)+G0111*DQ11
      GOUT( 23)=GOUT( 23)+G0112*DQ11
      GOUT( 24)=GOUT( 24)+G0113*DQ11
      GOUT( 25)=GOUT( 25)+G0120*DQ10
      GOUT( 26)=GOUT( 26)+G0121*DQ11
      GOUT( 27)=GOUT( 27)+G0122*DQ11
      GOUT( 28)=GOUT( 28)+G0123*DQ11
      GOUT( 29)=GOUT( 29)+G0130*DQ10
      GOUT( 30)=GOUT( 30)+G0131*DQ11
      GOUT( 31)=GOUT( 31)+G0132*DQ11
      GOUT( 32)=GOUT( 32)+G0133*DQ11
      GOUT( 33)=GOUT( 33)+G0200*DQ00
      GOUT( 34)=GOUT( 34)+G0201*DQ01
      GOUT( 35)=GOUT( 35)+G0202*DQ01
      GOUT( 36)=GOUT( 36)+G0203*DQ01
      GOUT( 37)=GOUT( 37)+G0210*DQ10
      GOUT( 38)=GOUT( 38)+G0211*DQ11
      GOUT( 39)=GOUT( 39)+G0212*DQ11
      GOUT( 40)=GOUT( 40)+G0213*DQ11
      GOUT( 41)=GOUT( 41)+G0220*DQ10
      GOUT( 42)=GOUT( 42)+G0221*DQ11
      GOUT( 43)=GOUT( 43)+G0222*DQ11
      GOUT( 44)=GOUT( 44)+G0223*DQ11
      GOUT( 45)=GOUT( 45)+G0230*DQ10
      GOUT( 46)=GOUT( 46)+G0231*DQ11
      GOUT( 47)=GOUT( 47)+G0232*DQ11
      GOUT( 48)=GOUT( 48)+G0233*DQ11
      GOUT( 49)=GOUT( 49)+G0300*DQ00
      GOUT( 50)=GOUT( 50)+G0301*DQ01
      GOUT( 51)=GOUT( 51)+G0302*DQ01
      GOUT( 52)=GOUT( 52)+G0303*DQ01
      GOUT( 53)=GOUT( 53)+G0310*DQ10
      GOUT( 54)=GOUT( 54)+G0311*DQ11
      GOUT( 55)=GOUT( 55)+G0312*DQ11
      GOUT( 56)=GOUT( 56)+G0313*DQ11
      GOUT( 57)=GOUT( 57)+G0320*DQ10
      GOUT( 58)=GOUT( 58)+G0321*DQ11
      GOUT( 59)=GOUT( 59)+G0322*DQ11
      GOUT( 60)=GOUT( 60)+G0323*DQ11
      GOUT( 61)=GOUT( 61)+G0330*DQ10
      GOUT( 62)=GOUT( 62)+G0331*DQ11
      GOUT( 63)=GOUT( 63)+G0332*DQ11
      GOUT( 64)=GOUT( 64)+G0333*DQ11
      RETURN
      END
      SUBROUTINE TQ1111
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     TRANSLATES UP TO 160 INTEGRALS ON A B AND Q TO UP TO 256 INTEGRALS
C     ON A B C AND D
C*
      IMPLICIT REAL*8 (A-H,O-Z)
C*
      COMMON/G/
     *G0000,G0001,G0002,G0003,G0011,G0012,G0013,G0022,G0023,G0033,
     *G0100,G0101,G0102,G0103,G0111,G0112,G0113,G0122,G0123,G0133,
     *G0200,G0201,G0202,G0203,G0211,G0212,G0213,G0222,G0223,G0233,
     *G0300,G0301,G0302,G0303,G0311,G0312,G0313,G0322,G0323,G0333,
     *G1000,G1001,G1002,G1003,G1011,G1012,G1013,G1022,G1023,G1033,
     *G1100,G1101,G1102,G1103,G1111,G1112,G1113,G1122,G1123,G1133,
     *G1200,G1201,G1202,G1203,G1211,G1212,G1213,G1222,G1223,G1233,
     *G1300,G1301,G1302,G1303,G1311,G1312,G1313,G1322,G1323,G1333,
     *G2000,G2001,G2002,G2003,G2011,G2012,G2013,G2022,G2023,G2033,
     *G2100,G2101,G2102,G2103,G2111,G2112,G2113,G2122,G2123,G2133,
     *G2200,G2201,G2202,G2203,G2211,G2212,G2213,G2222,G2223,G2233,
     *G2300,G2301,G2302,G2303,G2311,G2312,G2313,G2322,G2323,G2333,
     *G3000,G3001,G3002,G3003,G3011,G3012,G3013,G3022,G3023,G3033,
     *G3100,G3101,G3102,G3103,G3111,G3112,G3113,G3122,G3123,G3133,
     *G3200,G3201,G3202,G3203,G3211,G3212,G3213,G3222,G3223,G3233,
     *G3300,G3301,G3302,G3303,G3311,G3312,G3313,G3322,G3323,G3333
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/PQGEOM/AP,BP,CQ,DQ,PX,PY,PZ,QX,QY,QZ,RPQ,RPQSQ,PQ1,PQ2,PQ3,
     *C11,C12,C13,C21,C22,C23,C31,C32,C33
      COMMON/QGEOM/ACX,ACY,ACZ,ACY2,COSG,SING,AQX,AQZ,QPERP,QPERP2
      COMMON/DPQ/DP00,DP01,DP10,DP11,DQ00,DQ01,DQ10,DQ11
      COMMON/GOUT/GOUT(256)
C*
C     R13=COMPONENT OF CQ ALONG PENULTIMATE X-AXIS
C     R33=COMPONENT OF CQ ALONG PENULTIMATE Z-AXIS
C     R14=COMPONENT OF DQ ALONG PENULTIMATE X-AXIS
C     R34=COMPONENT OF DQ ALONG PENULTIMATE Z-AXIS
      R13=CQ*SING
      R33=CQ*COSG
      R14=DQ*SING
      R34=DQ*COSG
      G0010=G0001
      G0020=G0002
      G0021=G0012
      G0030=G0003
      G0031=G0013
      G0032=G0023
      G0110=G0101
      G0120=G0102
      G0121=G0112
      G0130=G0103
      G0131=G0113
      G0132=G0123
      G0210=G0201
      G0220=G0202
      G0221=G0212
      G0230=G0203
      G0231=G0213
      G0232=G0223
      G0310=G0301
      G0320=G0302
      G0321=G0312
      G0330=G0303
      G0331=G0313
      G0332=G0323
      G1010=G1001
      G1020=G1002
      G1021=G1012
      G1030=G1003
      G1031=G1013
      G1032=G1023
      G1110=G1101
      G1120=G1102
      G1121=G1112
      G1130=G1103
      G1131=G1113
      G1132=G1123
      G1210=G1201
      G1220=G1202
      G1221=G1212
      G1230=G1203
      G1231=G1213
      G1232=G1223
      G1310=G1301
      G1320=G1302
      G1321=G1312
      G1330=G1303
      G1331=G1313
      G1332=G1323
      G2010=G2001
      G2020=G2002
      G2021=G2012
      G2030=G2003
      G2031=G2013
      G2032=G2023
      G2110=G2101
      G2120=G2102
      G2121=G2112
      G2130=G2103
      G2131=G2113
      G2132=G2123
      G2210=G2201
      G2220=G2202
      G2221=G2212
      G2230=G2203
      G2231=G2213
      G2232=G2223
      G2310=G2301
      G2320=G2302
      G2321=G2312
      G2330=G2303
      G2331=G2313
      G2332=G2323
      G3010=G3001
      G3020=G3002
      G3021=G3012
      G3030=G3003
      G3031=G3013
      G3032=G3023
      G3110=G3101
      G3120=G3102
      G3121=G3112
      G3130=G3103
      G3131=G3113
      G3132=G3123
      G3210=G3201
      G3220=G3202
      G3221=G3212
      G3230=G3203
      G3231=G3213
      G3232=G3223
      G3310=G3301
      G3320=G3302
      G3321=G3312
      G3330=G3303
      G3331=G3313
      G3332=G3323
      IF (RCDSQ) 2,2,1
    1 CONTINUE
      G0010=G0010+R13*G0000
      G0011=G0011+R13*G0001
      G0012=G0012+R13*G0002
      G0013=G0013+R13*G0003
      G0110=G0110+R13*G0100
      G0111=G0111+R13*G0101
      G0112=G0112+R13*G0102
      G0113=G0113+R13*G0103
      G0210=G0210+R13*G0200
      G0211=G0211+R13*G0201
      G0212=G0212+R13*G0202
      G0213=G0213+R13*G0203
      G0310=G0310+R13*G0300
      G0311=G0311+R13*G0301
      G0312=G0312+R13*G0302
      G0313=G0313+R13*G0303
      G1010=G1010+R13*G1000
      G1011=G1011+R13*G1001
      G1012=G1012+R13*G1002
      G1013=G1013+R13*G1003
      G1110=G1110+R13*G1100
      G1111=G1111+R13*G1101
      G1112=G1112+R13*G1102
      G1113=G1113+R13*G1103
      G1210=G1210+R13*G1200
      G1211=G1211+R13*G1201
      G1212=G1212+R13*G1202
      G1213=G1213+R13*G1203
      G1310=G1310+R13*G1300
      G1311=G1311+R13*G1301
      G1312=G1312+R13*G1302
      G1313=G1313+R13*G1303
      G2010=G2010+R13*G2000
      G2011=G2011+R13*G2001
      G2012=G2012+R13*G2002
      G2013=G2013+R13*G2003
      G2110=G2110+R13*G2100
      G2111=G2111+R13*G2101
      G2112=G2112+R13*G2102
      G2113=G2113+R13*G2103
      G2210=G2210+R13*G2200
      G2211=G2211+R13*G2201
      G2212=G2212+R13*G2202
      G2213=G2213+R13*G2203
      G2310=G2310+R13*G2300
      G2311=G2311+R13*G2301
      G2312=G2312+R13*G2302
      G2313=G2313+R13*G2303
      G3010=G3010+R13*G3000
      G3011=G3011+R13*G3001
      G3012=G3012+R13*G3002
      G3013=G3013+R13*G3003
      G3110=G3110+R13*G3100
      G3111=G3111+R13*G3101
      G3112=G3112+R13*G3102
      G3113=G3113+R13*G3103
      G3210=G3210+R13*G3200
      G3211=G3211+R13*G3201
      G3212=G3212+R13*G3202
      G3213=G3213+R13*G3203
      G3310=G3310+R13*G3300
      G3311=G3311+R13*G3301
      G3312=G3312+R13*G3302
      G3313=G3313+R13*G3303
      G0030=G0030+R33*G0000
      G0031=G0031+R33*G0001
      G0032=G0032+R33*G0002
      G0033=G0033+R33*G0003
      G0130=G0130+R33*G0100
      G0131=G0131+R33*G0101
      G0132=G0132+R33*G0102
      G0133=G0133+R33*G0103
      G0230=G0230+R33*G0200
      G0231=G0231+R33*G0201
      G0232=G0232+R33*G0202
      G0233=G0233+R33*G0203
      G0330=G0330+R33*G0300
      G0331=G0331+R33*G0301
      G0332=G0332+R33*G0302
      G0333=G0333+R33*G0303
      G1030=G1030+R33*G1000
      G1031=G1031+R33*G1001
      G1032=G1032+R33*G1002
      G1033=G1033+R33*G1003
      G1130=G1130+R33*G1100
      G1131=G1131+R33*G1101
      G1132=G1132+R33*G1102
      G1133=G1133+R33*G1103
      G1230=G1230+R33*G1200
      G1231=G1231+R33*G1201
      G1232=G1232+R33*G1202
      G1233=G1233+R33*G1203
      G1330=G1330+R33*G1300
      G1331=G1331+R33*G1301
      G1332=G1332+R33*G1302
      G1333=G1333+R33*G1303
      G2030=G2030+R33*G2000
      G2031=G2031+R33*G2001
      G2032=G2032+R33*G2002
      G2033=G2033+R33*G2003
      G2130=G2130+R33*G2100
      G2131=G2131+R33*G2101
      G2132=G2132+R33*G2102
      G2133=G2133+R33*G2103
      G2230=G2230+R33*G2200
      G2231=G2231+R33*G2201
      G2232=G2232+R33*G2202
      G2233=G2233+R33*G2203
      G2330=G2330+R33*G2300
      G2331=G2331+R33*G2301
      G2332=G2332+R33*G2302
      G2333=G2333+R33*G2303
      G3030=G3030+R33*G3000
      G3031=G3031+R33*G3001
      G3032=G3032+R33*G3002
      G3033=G3033+R33*G3003
      G3130=G3130+R33*G3100
      G3131=G3131+R33*G3101
      G3132=G3132+R33*G3102
      G3133=G3133+R33*G3103
      G3230=G3230+R33*G3200
      G3231=G3231+R33*G3201
      G3232=G3232+R33*G3202
      G3233=G3233+R33*G3203
      G3330=G3330+R33*G3300
      G3331=G3331+R33*G3301
      G3332=G3332+R33*G3302
      G3333=G3333+R33*G3303
      G0001=G0001+R14*G0000
      G0011=G0011+R14*G0010
      G0021=G0021+R14*G0020
      G0031=G0031+R14*G0030
      G0101=G0101+R14*G0100
      G0111=G0111+R14*G0110
      G0121=G0121+R14*G0120
      G0131=G0131+R14*G0130
      G0201=G0201+R14*G0200
      G0211=G0211+R14*G0210
      G0221=G0221+R14*G0220
      G0231=G0231+R14*G0230
      G0301=G0301+R14*G0300
      G0311=G0311+R14*G0310
      G0321=G0321+R14*G0320
      G0331=G0331+R14*G0330
      G1001=G1001+R14*G1000
      G1011=G1011+R14*G1010
      G1021=G1021+R14*G1020
      G1031=G1031+R14*G1030
      G1101=G1101+R14*G1100
      G1111=G1111+R14*G1110
      G1121=G1121+R14*G1120
      G1131=G1131+R14*G1130
      G1201=G1201+R14*G1200
      G1211=G1211+R14*G1210
      G1221=G1221+R14*G1220
      G1231=G1231+R14*G1230
      G1301=G1301+R14*G1300
      G1311=G1311+R14*G1310
      G1321=G1321+R14*G1320
      G1331=G1331+R14*G1330
      G2001=G2001+R14*G2000
      G2011=G2011+R14*G2010
      G2021=G2021+R14*G2020
      G2031=G2031+R14*G2030
      G2101=G2101+R14*G2100
      G2111=G2111+R14*G2110
      G2121=G2121+R14*G2120
      G2131=G2131+R14*G2130
      G2201=G2201+R14*G2200
      G2211=G2211+R14*G2210
      G2221=G2221+R14*G2220
      G2231=G2231+R14*G2230
      G2301=G2301+R14*G2300
      G2311=G2311+R14*G2310
      G2321=G2321+R14*G2320
      G2331=G2331+R14*G2330
      G3001=G3001+R14*G3000
      G3011=G3011+R14*G3010
      G3021=G3021+R14*G3020
      G3031=G3031+R14*G3030
      G3101=G3101+R14*G3100
      G3111=G3111+R14*G3110
      G3121=G3121+R14*G3120
      G3131=G3131+R14*G3130
      G3201=G3201+R14*G3200
      G3211=G3211+R14*G3210
      G3221=G3221+R14*G3220
      G3231=G3231+R14*G3230
      G3301=G3301+R14*G3300
      G3311=G3311+R14*G3310
      G3321=G3321+R14*G3320
      G3331=G3331+R14*G3330
      G0003=G0003+R34*G0000
      G0013=G0013+R34*G0010
      G0023=G0023+R34*G0020
      G0033=G0033+R34*G0030
      G0103=G0103+R34*G0100
      G0113=G0113+R34*G0110
      G0123=G0123+R34*G0120
      G0133=G0133+R34*G0130
      G0203=G0203+R34*G0200
      G0213=G0213+R34*G0210
      G0223=G0223+R34*G0220
      G0233=G0233+R34*G0230
      G0303=G0303+R34*G0300
      G0313=G0313+R34*G0310
      G0323=G0323+R34*G0320
      G0333=G0333+R34*G0330
      G1003=G1003+R34*G1000
      G1013=G1013+R34*G1010
      G1023=G1023+R34*G1020
      G1033=G1033+R34*G1030
      G1103=G1103+R34*G1100
      G1113=G1113+R34*G1110
      G1123=G1123+R34*G1120
      G1133=G1133+R34*G1130
      G1203=G1203+R34*G1200
      G1213=G1213+R34*G1210
      G1223=G1223+R34*G1220
      G1233=G1233+R34*G1230
      G1303=G1303+R34*G1300
      G1313=G1313+R34*G1310
      G1323=G1323+R34*G1320
      G1333=G1333+R34*G1330
      G2003=G2003+R34*G2000
      G2013=G2013+R34*G2010
      G2023=G2023+R34*G2020
      G2033=G2033+R34*G2030
      G2103=G2103+R34*G2100
      G2113=G2113+R34*G2110
      G2123=G2123+R34*G2120
      G2133=G2133+R34*G2130
      G2203=G2203+R34*G2200
      G2213=G2213+R34*G2210
      G2223=G2223+R34*G2220
      G2233=G2233+R34*G2230
      G2303=G2303+R34*G2300
      G2313=G2313+R34*G2310
      G2323=G2323+R34*G2320
      G2333=G2333+R34*G2330
      G3003=G3003+R34*G3000
      G3013=G3013+R34*G3010
      G3023=G3023+R34*G3020
      G3033=G3033+R34*G3030
      G3103=G3103+R34*G3100
      G3113=G3113+R34*G3110
      G3123=G3123+R34*G3120
      G3133=G3133+R34*G3130
      G3203=G3203+R34*G3200
      G3213=G3213+R34*G3210
      G3223=G3223+R34*G3220
      G3233=G3233+R34*G3230
      G3303=G3303+R34*G3300
      G3313=G3313+R34*G3310
      G3323=G3323+R34*G3320
      G3333=G3333+R34*G3330
    2 CONTINUE
      GOUT(  1)=GOUT(  1)+G0000*DQ00
      GOUT(  2)=GOUT(  2)+G0001*DQ01
      GOUT(  3)=GOUT(  3)+G0002*DQ01
      GOUT(  4)=GOUT(  4)+G0003*DQ01
      GOUT(  5)=GOUT(  5)+G0010*DQ10
      GOUT(  6)=GOUT(  6)+G0011*DQ11
      GOUT(  7)=GOUT(  7)+G0012*DQ11
      GOUT(  8)=GOUT(  8)+G0013*DQ11
      GOUT(  9)=GOUT(  9)+G0020*DQ10
      GOUT( 10)=GOUT( 10)+G0021*DQ11
      GOUT( 11)=GOUT( 11)+G0022*DQ11
      GOUT( 12)=GOUT( 12)+G0023*DQ11
      GOUT( 13)=GOUT( 13)+G0030*DQ10
      GOUT( 14)=GOUT( 14)+G0031*DQ11
      GOUT( 15)=GOUT( 15)+G0032*DQ11
      GOUT( 16)=GOUT( 16)+G0033*DQ11
      GOUT( 17)=GOUT( 17)+G0100*DQ00
      GOUT( 18)=GOUT( 18)+G0101*DQ01
      GOUT( 19)=GOUT( 19)+G0102*DQ01
      GOUT( 20)=GOUT( 20)+G0103*DQ01
      GOUT( 21)=GOUT( 21)+G0110*DQ10
      GOUT( 22)=GOUT( 22)+G0111*DQ11
      GOUT( 23)=GOUT( 23)+G0112*DQ11
      GOUT( 24)=GOUT( 24)+G0113*DQ11
      GOUT( 25)=GOUT( 25)+G0120*DQ10
      GOUT( 26)=GOUT( 26)+G0121*DQ11
      GOUT( 27)=GOUT( 27)+G0122*DQ11
      GOUT( 28)=GOUT( 28)+G0123*DQ11
      GOUT( 29)=GOUT( 29)+G0130*DQ10
      GOUT( 30)=GOUT( 30)+G0131*DQ11
      GOUT( 31)=GOUT( 31)+G0132*DQ11
      GOUT( 32)=GOUT( 32)+G0133*DQ11
      GOUT( 33)=GOUT( 33)+G0200*DQ00
      GOUT( 34)=GOUT( 34)+G0201*DQ01
      GOUT( 35)=GOUT( 35)+G0202*DQ01
      GOUT( 36)=GOUT( 36)+G0203*DQ01
      GOUT( 37)=GOUT( 37)+G0210*DQ10
      GOUT( 38)=GOUT( 38)+G0211*DQ11
      GOUT( 39)=GOUT( 39)+G0212*DQ11
      GOUT( 40)=GOUT( 40)+G0213*DQ11
      GOUT( 41)=GOUT( 41)+G0220*DQ10
      GOUT( 42)=GOUT( 42)+G0221*DQ11
      GOUT( 43)=GOUT( 43)+G0222*DQ11
      GOUT( 44)=GOUT( 44)+G0223*DQ11
      GOUT( 45)=GOUT( 45)+G0230*DQ10
      GOUT( 46)=GOUT( 46)+G0231*DQ11
      GOUT( 47)=GOUT( 47)+G0232*DQ11
      GOUT( 48)=GOUT( 48)+G0233*DQ11
      GOUT( 49)=GOUT( 49)+G0300*DQ00
      GOUT( 50)=GOUT( 50)+G0301*DQ01
      GOUT( 51)=GOUT( 51)+G0302*DQ01
      GOUT( 52)=GOUT( 52)+G0303*DQ01
      GOUT( 53)=GOUT( 53)+G0310*DQ10
      GOUT( 54)=GOUT( 54)+G0311*DQ11
      GOUT( 55)=GOUT( 55)+G0312*DQ11
      GOUT( 56)=GOUT( 56)+G0313*DQ11
      GOUT( 57)=GOUT( 57)+G0320*DQ10
      GOUT( 58)=GOUT( 58)+G0321*DQ11
      GOUT( 59)=GOUT( 59)+G0322*DQ11
      GOUT( 60)=GOUT( 60)+G0323*DQ11
      GOUT( 61)=GOUT( 61)+G0330*DQ10
      GOUT( 62)=GOUT( 62)+G0331*DQ11
      GOUT( 63)=GOUT( 63)+G0332*DQ11
      GOUT( 64)=GOUT( 64)+G0333*DQ11
      GOUT( 65)=GOUT( 65)+G1000*DQ00
      GOUT( 66)=GOUT( 66)+G1001*DQ01
      GOUT( 67)=GOUT( 67)+G1002*DQ01
      GOUT( 68)=GOUT( 68)+G1003*DQ01
      GOUT( 69)=GOUT( 69)+G1010*DQ10
      GOUT( 70)=GOUT( 70)+G1011*DQ11
      GOUT( 71)=GOUT( 71)+G1012*DQ11
      GOUT( 72)=GOUT( 72)+G1013*DQ11
      GOUT( 73)=GOUT( 73)+G1020*DQ10
      GOUT( 74)=GOUT( 74)+G1021*DQ11
      GOUT( 75)=GOUT( 75)+G1022*DQ11
      GOUT( 76)=GOUT( 76)+G1023*DQ11
      GOUT( 77)=GOUT( 77)+G1030*DQ10
      GOUT( 78)=GOUT( 78)+G1031*DQ11
      GOUT( 79)=GOUT( 79)+G1032*DQ11
      GOUT( 80)=GOUT( 80)+G1033*DQ11
      GOUT( 81)=GOUT( 81)+G1100*DQ00
      GOUT( 82)=GOUT( 82)+G1101*DQ01
      GOUT( 83)=GOUT( 83)+G1102*DQ01
      GOUT( 84)=GOUT( 84)+G1103*DQ01
      GOUT( 85)=GOUT( 85)+G1110*DQ10
      GOUT( 86)=GOUT( 86)+G1111*DQ11
      GOUT( 87)=GOUT( 87)+G1112*DQ11
      GOUT( 88)=GOUT( 88)+G1113*DQ11
      GOUT( 89)=GOUT( 89)+G1120*DQ10
      GOUT( 90)=GOUT( 90)+G1121*DQ11
      GOUT( 91)=GOUT( 91)+G1122*DQ11
      GOUT( 92)=GOUT( 92)+G1123*DQ11
      GOUT( 93)=GOUT( 93)+G1130*DQ10
      GOUT( 94)=GOUT( 94)+G1131*DQ11
      GOUT( 95)=GOUT( 95)+G1132*DQ11
      GOUT( 96)=GOUT( 96)+G1133*DQ11
      GOUT( 97)=GOUT( 97)+G1200*DQ00
      GOUT( 98)=GOUT( 98)+G1201*DQ01
      GOUT( 99)=GOUT( 99)+G1202*DQ01
      GOUT(100)=GOUT(100)+G1203*DQ01
      GOUT(101)=GOUT(101)+G1210*DQ10
      GOUT(102)=GOUT(102)+G1211*DQ11
      GOUT(103)=GOUT(103)+G1212*DQ11
      GOUT(104)=GOUT(104)+G1213*DQ11
      GOUT(105)=GOUT(105)+G1220*DQ10
      GOUT(106)=GOUT(106)+G1221*DQ11
      GOUT(107)=GOUT(107)+G1222*DQ11
      GOUT(108)=GOUT(108)+G1223*DQ11
      GOUT(109)=GOUT(109)+G1230*DQ10
      GOUT(110)=GOUT(110)+G1231*DQ11
      GOUT(111)=GOUT(111)+G1232*DQ11
      GOUT(112)=GOUT(112)+G1233*DQ11
      GOUT(113)=GOUT(113)+G1300*DQ00
      GOUT(114)=GOUT(114)+G1301*DQ01
      GOUT(115)=GOUT(115)+G1302*DQ01
      GOUT(116)=GOUT(116)+G1303*DQ01
      GOUT(117)=GOUT(117)+G1310*DQ10
      GOUT(118)=GOUT(118)+G1311*DQ11
      GOUT(119)=GOUT(119)+G1312*DQ11
      GOUT(120)=GOUT(120)+G1313*DQ11
      GOUT(121)=GOUT(121)+G1320*DQ10
      GOUT(122)=GOUT(122)+G1321*DQ11
      GOUT(123)=GOUT(123)+G1322*DQ11
      GOUT(124)=GOUT(124)+G1323*DQ11
      GOUT(125)=GOUT(125)+G1330*DQ10
      GOUT(126)=GOUT(126)+G1331*DQ11
      GOUT(127)=GOUT(127)+G1332*DQ11
      GOUT(128)=GOUT(128)+G1333*DQ11
      GOUT(129)=GOUT(129)+G2000*DQ00
      GOUT(130)=GOUT(130)+G2001*DQ01
      GOUT(131)=GOUT(131)+G2002*DQ01
      GOUT(132)=GOUT(132)+G2003*DQ01
      GOUT(133)=GOUT(133)+G2010*DQ10
      GOUT(134)=GOUT(134)+G2011*DQ11
      GOUT(135)=GOUT(135)+G2012*DQ11
      GOUT(136)=GOUT(136)+G2013*DQ11
      GOUT(137)=GOUT(137)+G2020*DQ10
      GOUT(138)=GOUT(138)+G2021*DQ11
      GOUT(139)=GOUT(139)+G2022*DQ11
      GOUT(140)=GOUT(140)+G2023*DQ11
      GOUT(141)=GOUT(141)+G2030*DQ10
      GOUT(142)=GOUT(142)+G2031*DQ11
      GOUT(143)=GOUT(143)+G2032*DQ11
      GOUT(144)=GOUT(144)+G2033*DQ11
      GOUT(145)=GOUT(145)+G2100*DQ00
      GOUT(146)=GOUT(146)+G2101*DQ01
      GOUT(147)=GOUT(147)+G2102*DQ01
      GOUT(148)=GOUT(148)+G2103*DQ01
      GOUT(149)=GOUT(149)+G2110*DQ10
      GOUT(150)=GOUT(150)+G2111*DQ11
      GOUT(151)=GOUT(151)+G2112*DQ11
      GOUT(152)=GOUT(152)+G2113*DQ11
      GOUT(153)=GOUT(153)+G2120*DQ10
      GOUT(154)=GOUT(154)+G2121*DQ11
      GOUT(155)=GOUT(155)+G2122*DQ11
      GOUT(156)=GOUT(156)+G2123*DQ11
      GOUT(157)=GOUT(157)+G2130*DQ10
      GOUT(158)=GOUT(158)+G2131*DQ11
      GOUT(159)=GOUT(159)+G2132*DQ11
      GOUT(160)=GOUT(160)+G2133*DQ11
      GOUT(161)=GOUT(161)+G2200*DQ00
      GOUT(162)=GOUT(162)+G2201*DQ01
      GOUT(163)=GOUT(163)+G2202*DQ01
      GOUT(164)=GOUT(164)+G2203*DQ01
      GOUT(165)=GOUT(165)+G2210*DQ10
      GOUT(166)=GOUT(166)+G2211*DQ11
      GOUT(167)=GOUT(167)+G2212*DQ11
      GOUT(168)=GOUT(168)+G2213*DQ11
      GOUT(169)=GOUT(169)+G2220*DQ10
      GOUT(170)=GOUT(170)+G2221*DQ11
      GOUT(171)=GOUT(171)+G2222*DQ11
      GOUT(172)=GOUT(172)+G2223*DQ11
      GOUT(173)=GOUT(173)+G2230*DQ10
      GOUT(174)=GOUT(174)+G2231*DQ11
      GOUT(175)=GOUT(175)+G2232*DQ11
      GOUT(176)=GOUT(176)+G2233*DQ11
      GOUT(177)=GOUT(177)+G2300*DQ00
      GOUT(178)=GOUT(178)+G2301*DQ01
      GOUT(179)=GOUT(179)+G2302*DQ01
      GOUT(180)=GOUT(180)+G2303*DQ01
      GOUT(181)=GOUT(181)+G2310*DQ10
      GOUT(182)=GOUT(182)+G2311*DQ11
      GOUT(183)=GOUT(183)+G2312*DQ11
      GOUT(184)=GOUT(184)+G2313*DQ11
      GOUT(185)=GOUT(185)+G2320*DQ10
      GOUT(186)=GOUT(186)+G2321*DQ11
      GOUT(187)=GOUT(187)+G2322*DQ11
      GOUT(188)=GOUT(188)+G2323*DQ11
      GOUT(189)=GOUT(189)+G2330*DQ10
      GOUT(190)=GOUT(190)+G2331*DQ11
      GOUT(191)=GOUT(191)+G2332*DQ11
      GOUT(192)=GOUT(192)+G2333*DQ11
      GOUT(193)=GOUT(193)+G3000*DQ00
      GOUT(194)=GOUT(194)+G3001*DQ01
      GOUT(195)=GOUT(195)+G3002*DQ01
      GOUT(196)=GOUT(196)+G3003*DQ01
      GOUT(197)=GOUT(197)+G3010*DQ10
      GOUT(198)=GOUT(198)+G3011*DQ11
      GOUT(199)=GOUT(199)+G3012*DQ11
      GOUT(200)=GOUT(200)+G3013*DQ11
      GOUT(201)=GOUT(201)+G3020*DQ10
      GOUT(202)=GOUT(202)+G3021*DQ11
      GOUT(203)=GOUT(203)+G3022*DQ11
      GOUT(204)=GOUT(204)+G3023*DQ11
      GOUT(205)=GOUT(205)+G3030*DQ10
      GOUT(206)=GOUT(206)+G3031*DQ11
      GOUT(207)=GOUT(207)+G3032*DQ11
      GOUT(208)=GOUT(208)+G3033*DQ11
      GOUT(209)=GOUT(209)+G3100*DQ00
      GOUT(210)=GOUT(210)+G3101*DQ01
      GOUT(211)=GOUT(211)+G3102*DQ01
      GOUT(212)=GOUT(212)+G3103*DQ01
      GOUT(213)=GOUT(213)+G3110*DQ10
      GOUT(214)=GOUT(214)+G3111*DQ11
      GOUT(215)=GOUT(215)+G3112*DQ11
      GOUT(216)=GOUT(216)+G3113*DQ11
      GOUT(217)=GOUT(217)+G3120*DQ10
      GOUT(218)=GOUT(218)+G3121*DQ11
      GOUT(219)=GOUT(219)+G3122*DQ11
      GOUT(220)=GOUT(220)+G3123*DQ11
      GOUT(221)=GOUT(221)+G3130*DQ10
      GOUT(222)=GOUT(222)+G3131*DQ11
      GOUT(223)=GOUT(223)+G3132*DQ11
      GOUT(224)=GOUT(224)+G3133*DQ11
      GOUT(225)=GOUT(225)+G3200*DQ00
      GOUT(226)=GOUT(226)+G3201*DQ01
      GOUT(227)=GOUT(227)+G3202*DQ01
      GOUT(228)=GOUT(228)+G3203*DQ01
      GOUT(229)=GOUT(229)+G3210*DQ10
      GOUT(230)=GOUT(230)+G3211*DQ11
      GOUT(231)=GOUT(231)+G3212*DQ11
      GOUT(232)=GOUT(232)+G3213*DQ11
      GOUT(233)=GOUT(233)+G3220*DQ10
      GOUT(234)=GOUT(234)+G3221*DQ11
      GOUT(235)=GOUT(235)+G3222*DQ11
      GOUT(236)=GOUT(236)+G3223*DQ11
      GOUT(237)=GOUT(237)+G3230*DQ10
      GOUT(238)=GOUT(238)+G3231*DQ11
      GOUT(239)=GOUT(239)+G3232*DQ11
      GOUT(240)=GOUT(240)+G3233*DQ11
      GOUT(241)=GOUT(241)+G3300*DQ00
      GOUT(242)=GOUT(242)+G3301*DQ01
      GOUT(243)=GOUT(243)+G3302*DQ01
      GOUT(244)=GOUT(244)+G3303*DQ01
      GOUT(245)=GOUT(245)+G3310*DQ10
      GOUT(246)=GOUT(246)+G3311*DQ11
      GOUT(247)=GOUT(247)+G3312*DQ11
      GOUT(248)=GOUT(248)+G3313*DQ11
      GOUT(249)=GOUT(249)+G3320*DQ10
      GOUT(250)=GOUT(250)+G3321*DQ11
      GOUT(251)=GOUT(251)+G3322*DQ11
      GOUT(252)=GOUT(252)+G3323*DQ11
      GOUT(253)=GOUT(253)+G3330*DQ10
      GOUT(254)=GOUT(254)+G3331*DQ11
      GOUT(255)=GOUT(255)+G3332*DQ11
      GOUT(256)=GOUT(256)+G3333*DQ11
      RETURN
      END
      SUBROUTINE R30001
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
      IMPLICIT REAL*8 (A-H,O-Z)
C*
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/GOUT/X1,X2,X3,X4,X(252)
C*
      T1=X2
      T2=X3
      T3=X4
      X2=P11*T1+P21*T2+P31*T3
      X3=P12*T1+P22*T2+P32*T3
      X4=P13*T1+P23*T2+P33*T3
      RETURN
      END
      SUBROUTINE R30011
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     ROTATES UP TO 256 INTEGRALS TO SPACE FIXED AXES
C     INCOMING AND OUTGOING INTEGRALS IN COMMON GOUT
C     INDICES IN ORDER 0000,0001,0002,...0010,0011,...0100,0101,...ETC.
C     P11,...ARE DIRECTION COSINES OF SPACE FIXED AXES WRT AXES AT P
C     Q11,...ARE DIRECTION COSINES OF SPACE FIXED AXES WRT AXES AT Q
C     APPLIES TO CASE 0011
C*
      IMPLICIT REAL*8 (A-H,O-Z)
C*
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/GOUT/X(256)
C*
      IND=0
      DO 3 L=1,4
      IND=IND+1
      I1=4+IND
      I2=8+IND
      I3=12+IND
      T1=X(I1)
      T2=X(I2)
      T3=X(I3)
      X(I1     )=P11*T1+P21*T2+P31*T3
      X(I2     )=P12*T1+P22*T2+P32*T3
      X(I3     )=P13*T1+P23*T2+P33*T3
    3 CONTINUE
      IND=-3
      DO 4 K=1,4
      IND=IND+4
      I1=1+IND
      I2=2+IND
      I3=3+IND
      T1=X(I1)
      T2=X(I2)
      T3=X(I3)
      X(I3     )=P13*T1+P23*T2+P33*T3
      X(I1     )=P11*T1+P21*T2+P31*T3
      X(I2     )=P12*T1+P22*T2+P32*T3
    4 CONTINUE
      RETURN
      END
      SUBROUTINE R30101
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     ROTATES UP TO 256 INTEGRALS TO SPACE FIXED AXES
C     INCOMING AND OUTGOING INTEGRALS IN COMMON GOUT
C     INDICES IN ORDER 0000,0001,0002,...0010,0011,...0100,0101,...ETC.
C     P11,...ARE DIRECTION COSINES OF SPACE FIXED AXES WRT AXES AT P
C     Q11,...ARE DIRECTION COSINES OF SPACE FIXED AXES WRT AXES AT Q
C     APPLIES TO CASE 0101
C*
      IMPLICIT REAL*8 (A-H,O-Z)
C*
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
C*
      COMMON/GOUT/X(256)
C*
      IND=0
      DO 2 L=1,4
      DO 2 K=1,4
      IND=IND+1
      I1=16+IND
      I2=32+IND
      I3=48+IND
      T1=X(I1)
      T2=X(I2)
      T3=X(I3)
      X(I1     )=P11*T1+P21*T2+P31*T3
      X(I2     )=P12*T1+P22*T2+P32*T3
      X(I3     )=P13*T1+P23*T2+P33*T3
    2 CONTINUE
      IND=-15
      DO 4 J=1,4
      IND=IND+16
      I1=1+IND
      I2=2+IND
      I3=3+IND
      T1=X(I1)
      T2=X(I2)
      T3=X(I3)
      X(I1     )=P11*T1+P21*T2+P31*T3
      X(I2     )=P12*T1+P22*T2+P32*T3
      X(I3     )=P13*T1+P23*T2+P33*T3
    4 CONTINUE
      RETURN
      END
      SUBROUTINE R30111
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     ROTATES UP TO 256 INTEGRALS TO SPACE FIXED AXES
C     INCOMING AND OUTGOING INTEGRALS IN COMMON GOUT
C     INDICES IN ORDER 0000,0001,0002,...0010,0011,...0100,0101,...ETC.
C     P11,...ARE DIRECTION COSINES OF SPACE FIXED AXES WRT AXES AT P
C     Q11,...ARE DIRECTION COSINES OF SPACE FIXED AXES WRT AXES AT Q
C     APPLIES TO CASE 0111
C*
      IMPLICIT REAL*8 (A-H,O-Z)
C*
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/GOUT/X(256)
C*
      IND=0
      DO 2 K=1,4
      DO 2 L=1,4
      IND=IND+1
      I1=16+IND
      I2=32+IND
      I3=48+IND
      T1=X(I1)
      T2=X(I2)
      T3=X(I3)
      X(I1     )=P11*T1+P21*T2+P31*T3
      X(I2     )=P12*T1+P22*T2+P32*T3
      X(I3     )=P13*T1+P23*T2+P33*T3
    2 CONTINUE
      IND=-12
      DO 3 J=1,4
      IND=IND+12
      DO 3 L=1,4
      IND=IND+1
      I1=4+IND
      I2=8+IND
      I3=12+IND
      T1=X(I1)
      T2=X(I2)
      T3=X(I3)
      X(I1     )=P11*T1+P21*T2+P31*T3
      X(I2     )=P12*T1+P22*T2+P32*T3
      X(I3     )=P13*T1+P23*T2+P33*T3
    3 CONTINUE
      IND=-3
      DO 4 J=1,4
      DO 4 K=1,4
      IND=IND+4
      I1=1+IND
      I2=2+IND
      I3=3+IND
      T1=X(I1)
      T2=X(I2)
      T3=X(I3)
      X(I1     )=P11*T1+P21*T2+P31*T3
      X(I2     )=P12*T1+P22*T2+P32*T3
      X(I3     )=P13*T1+P23*T2+P33*T3
    4 CONTINUE
      RETURN
      END
      SUBROUTINE R31111
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     ROTATES UP TO 256 INTEGRALS TO SPACE FIXED AXES
C     INCOMING AND OUTGOING INTEGRALS IN COMMON GOUT
C     INDICES IN ORDER 0000,0001,0002,...0010,0011,...0100,0101,...ETC.
C     P11,...ARE DIRECTION COSINES OF SPACE FIXED AXES WRT AXES AT P
C     Q11,...ARE DIRECTION COSINES OF SPACE FIXED AXES WRT AXES AT Q
C     APPLIES TO CASE 1111
C*
      IMPLICIT REAL*8 (A-H,O-Z)
C*
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/GOUT/X(256)
C*
      I1=64
      I2=128
      I3=192
      DO 1 J=1,4
      DO 1 K=1,4
      DO 1 L=1,4
      I1=I1+1
      I2=I2+1
      I3=I3+1
      T1=X(I1)
      T2=X(I2)
      T3=X(I3)
      X(I1     )=P11*T1+P21*T2+P31*T3
      X(I2     )=P12*T1+P22*T2+P32*T3
      X(I3     )=P13*T1+P23*T2+P33*T3
    1 CONTINUE
      IND=-48
      DO 2 I=1,4
      IND=IND+48
      DO 2 K=1,4
      DO 2 L=1,4
      IND=IND+1
      I1=16+IND
      I2=32+IND
      I3=48+IND
      T1=X(I1)
      T2=X(I2)
      T3=X(I3)
      X(I1     )=P11*T1+P21*T2+P31*T3
      X(I2     )=P12*T1+P22*T2+P32*T3
      X(I3     )=P13*T1+P23*T2+P33*T3
    2 CONTINUE
      IND=-12
      DO 3 I=1,4
      DO 3 J=1,4
      IND=IND+12
      DO 3 L=1,4
      IND=IND+1
      I1=4+IND
      I2=8+IND
      I3=12+IND
      T1=X(I1)
      T2=X(I2)
      T3=X(I3)
      X(I1     )=P11*T1+P21*T2+P31*T3
      X(I2     )=P12*T1+P22*T2+P32*T3
      X(I3     )=P13*T1+P23*T2+P33*T3
    3 CONTINUE
      IND=-3
      DO 4 I=1,4
      DO 4 J=1,4
      DO 4 K=1,4
      IND=IND+4
      I1=1+IND
      I2=2+IND
      I3=3+IND
      T1=X(I1)
      T2=X(I2)
      T3=X(I3)
      X(I1     )=P11*T1+P21*T2+P31*T3
      X(I2     )=P12*T1+P22*T2+P32*T3
      X(I3     )=P13*T1+P23*T2+P33*T3
    4 CONTINUE
      RETURN
      END
      SUBROUTINE SHLOUT(LIMIT)
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     TWO ELECTRON INTEGRAL OUTPUT ROUTINE
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER SHELLA,SHELLN,SHELLT,AOS,AON
      parameter (maxp=2000)
      parameter (maxg=1000)
      parameter (mmax=10 000 000)
      parameter (mgmax=12 000 000)
      common /large/aa(mmax),g(mgmax),zzzz(mmax)
      parameter (maxat=100)
      parameter (nmax=256)
      parameter (n128=128)
      common /pointer/ipoint(maxat),ijpoint(maxat,maxat),na(maxat)     
      dimension llim(n128)
      common /hold/jhold(nmax),llim
C*
      COMMON IOP(52)
      COMMON NATOMS,ICHARG,MULTIP,IAN(35),NAE,NBE,NE,NBASIS,C(35,3)
      COMMON IUNIT(20),INFO(5)
C*
      COMMON/B/EXX(maxp),C1(maxp),C2(maxp),C3(240),
     *X(maxp),Y(maxp),Z(maxp),JAN(80),SHELLA(maxp),SHELLN(maxp),
     *SHELLT(maxp),AOS(maxg),AON(20),NSHELL,MAXTYP
      COMMON/SHLNOS/ISHELL,JSHELL,KSHELL,LSHELL,INEW,JNEW,KNEW,LNEW
      COMMON/PACKED/IN,JN,KN,LN,IJKL,JA
      COMMON/GOUT/GOUT(256)
      COMMON/IO/IIN,IOUT,IPUNCH
      COMMON/ICOUNT/ICOUNT
      COMMON/IQ/IQ
      common/ihol/ihold(maxg),ihsh(maxg),icent
c
      EQUIVALENCE (IUNIT(11),INTAPE)
C*
c     DIMENSION IX(3200)
c     DIMENSION XXP(4),IXP(4),JXP(4),KXP(4),LXP(4)
C*
      DATA CUTOFF/1.0D-12/
      DATA TEN/10.0D0/
C*
 1000 FORMAT(4(I9,3I3,G12.6))
 1010 FORMAT(1H1,20X,'TWO ELECTRON INTEGRALS',//)
C*
      IF(LIMIT)10,345,50
C     PRELIMINARY ENTRY
   10 IF(IOP(12))20,30,20
   20 CUTOFF=TEN**(-IOP(12))
   30 ICOUNT=1
c     REWIND INTAPE
      IQ=1
      IF(IOP(14).NE.0) WRITE (IOUT,1010)
      RETURN
C     NORMAL ENTRY
C     INTEGRALS IN COMMON /GOUT/ WAITING TO BE WRITTEN OUT
C     DETERMINE NUMBERS OF THE FIRST ATOMIC ORBITALS IN EACH OF THE FOUR
C     SHELLS
   50 IP=AOS(INEW)-1
      JP=AOS(JNEW)-1
      KP=AOS(KNEW)-1
      LP=AOS(LNEW)-1
      NCOUNT=0
      DO 340 I=1,4
      DO 340 J=1,4
      DO 340 K=1,4
      DO 340 L=1,4
      NCOUNT=NCOUNT+1
C     TEST FOR END OF COMMON /GOUT/
      IF(LIMIT-NCOUNT) 345,60,60
C     DECIDE WHETHER OR NOT A PARTICULAR INTEGRAL IS LARGE ENOUGH
C     TO WARRANT KEEPING
   60 IF(DABS(GOUT(NCOUNT))-CUTOFF) 340,340,70
C     KEEP THE INTEGRAL
C     ORDER ATOMIC ORBITALS SUCH THAT
C     I GE J
C     K GE L
C     I GE K
C     IF I EQ K
C     THEN J GE L
C     INTEGRAL OVER ATOMIC ORBITALS  (IJ/KL)
   70 IN=IP+I
      JN=JP+J
      KN=KP+K
      LN=LP+L
      gf=GOUT(NCOUNT)
c Itt van meg az integral (out) es az indexek (in,jn,kn,ln)
      if(icent.eq.1)then
      ih=jhold(in)
      ipo=ipoint(ih)
      if(dabs(gf).lt.1.d-10) goto 3400
      ii=in
      jj=jn
      kk=kn
      ll=ln 
      call bepack1(gf,ii,kk,jj,ll,llim,g(ipo),na(ih),jhold)
      goto 3400 
      endif
      if(icent.eq.2)then
 122   ih=jhold(in)
      jh=jhold(jn)
      ih3=jhold(kn)
      ih4=jhold(ln)
      if(ih.eq.jh)jh=ih3
      if(ih.eq.jh)jh=ih4
        if(ih.eq.jh)stop 4657
 5234  format(10i3)
   
       if(ih.eq.0)then 
       stop 1234
        endif
       if(jh.eq.0) then
        stop 1235
        endif
       
       ip1=ih
       ip2=jh
       if(ih.gt.jh)then
       ip1=jh
       ip2=ih
       endif
      ipo=ijpoint(1,2)
       nn=na(ih)+na(jh)
      if(dabs(gf).lt.1.d-10) goto 3400
      ii=in
      jj=jn
      kk=kn
      ll=ln 
      call bepack2(gf,ii,kk,jj,ll,llim,g(ipo),nn,jhold,na)
      endif
 1612 format(e15.8,4i3)
 3400 CONTINUE
  340 CONTINUE
  345 RETURN
      END


      SUBROUTINE SHELLat(iat,nbas,natoms)

c Computes one-center two-electron integrals for S and P orbitals.

C     LINK 303
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     GAUSSIAN TWO ELECTRON INTEGRAL PACKAGE
C     MAIN LOOP OVER SHELLS ... SEE EXPLANATION IN PROGRAM GINPUT ...
C     LINK 301
C      ACCEPTS NUMBERS OF FOUR SHELLS
C     ISHELL  JSHELL  KSHELL  LSHELL
C     FINDS THEIR ANGULAR QUANTUM NUMBERS
C     AND
C     BASED ON THIS ORDERS SHELLS IN A STANDARD MANNER
C     INEW  JNEW  KNEW  LNEW
C     ONLY POSSIBILITIES ALLOWED FOR ANGULAR QUANTUM NUMBERS ARE THEN
C     0000  0001  0011  0101  0111  1111
C     DETERMINES TYPE OF INTEGRAL SET BASED ON THE ABOVE NUMBERS
C     CALLS THE FOLLOWING ROUTINES IN THE ORDER GIVEN
C     SHLOUT
C     FIRST TIME TO PRESET OUTPUT ROUTINES
C     FILMAX
C     TO PRESET INTEGRAL ACCURCY LIMITS
C     SINFO
C     OBTAINS GEOMETRICAL INFORMATION ABOUT THE FOUR CENTERS
C     FINDS TWO SETS OF LOCAL AXES
C     FOR CENTERS
C     A AND B  P SET
C     C AND D  Q SET
C     PINF
C     OBTAINS INFORMATION ABOUT GAUSSIAN FUNCTIONS CONNECTED WITH THE P
C     SET OF AXES
C     AT THIS POINT
C     SHELL OBTAINS INFORMATION ABOUT THE GAUSSIAN FUNCTIONS CONNECTED
C     WITH THE Q SET OF AXES
C     SP0000 TO SP1111
C     OBTAINS UP TO 88 INTEGRALS REFERRED TO AXES A B AND Q
C     ROT2
C     ROTATES THESE INTEGRALS TO UP TO 160 INTEGRALS ON A B AND Q
C     TQ0011 TO TQ1111
C     TRANSLATES THESE INTEGRALS ON A B AND Q TO UP TO 256 INTEGRALS ON
C     A B C AND D
C     R30001 TO R31111
C     ROTATES UP TO 256 INTEGRALS ON A B C AND D TO THE SAME NUMBER
C     REFERRED TO THE FIXED SPACE AXES
C     SHELL DETECTS SHELL COINCIDENCES AND ELIMINATES DUPLICATES
C     INTEGRALS ARE TRANSFERRED TO ROUTINE SHLOUT TO BE PUT ON DRUM
C     OR TAPE
C     A FINAL CALL TO SHLOUT CLOSES THE OUTPUT BUFFER
C*
C     ******************************************************************
C     OPTIONS ... IOP( )     SEE PROGRAM GINPUT ... SEGMENT 301
C     *****************************************************************
C*
      IMPLICIT REAL*8 (A-H,O-Z)

      parameter (maxat=100)
      parameter (maxg=1000)
      parameter (maxp=2000)
      parameter (mxc=16)
      parameter (maxc2=225)
C*
      INTEGER SHELLA,SHELLN,SHELLT,AOS,AON
C*
      COMMON IOP(52)
      COMMON iNATOMS,ICHARG,MULTIP,IAN(35),NAE,NBE,NE,NBASIS,CO(35,3)
      COMMON IUNIT(20),INFO(5)
C*
      COMMON/CONST/CONST,conp(maxc2)
      COMMON/SHLNOS/ISHELL,JSHELL,KSHELL,LSHELL,INEW,JNEW,KNEW,LNEW
      COMMON/SHLINF/NGA,LA,AG(10),CSA(10),CPA(10),NGB,LB,BG(10),CSB(10),
     *CPB(10),NGC,LC,CG(10),CSC(10),CPC(10),NGD,LD,DG(10),
     *CSD(10),CPD(10)
      COMMON/LT/LAT,LBT,LCT,LDT
      COMMON/MISC/MAB,MCD,NGANGB
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/PQGEOM/AP,BP,CQ,DQ,PX,PY,PZ,QX,QY,QZ,RPQ,RPQSQ,PQ1,PQ2,PQ3,
     *C11,C12,C13,C21,C22,C23,C31,C32,C33
      COMMON/GINF/GA,GB,GC,GD,SA,SB,SC,SD,PA,PB,PC,PD,GAB,GCD
      COMMON/H/H(160)
      COMMON/TYPE/ITYPE,JTYPE
      COMMON/GOUT/GOUT(256)
      COMMON/PGEOM/GP(maxc2),EP(maxc2),DP00P(maxc2),DP01P(maxc2),
     $  DP10P(maxc2),DP11P(maxc2),APP(maxc2),BPP(maxc2)
      COMMON/EABECD/EAB,ECD
      COMMON/DPQ/DP00,DP01,DP10,DP11,DQ00,DQ01,DQ10,DQ11
      COMMON/COS/C
      COMMON/PHI/COSP,SINP
      COMMON/QGEOM/ACX,ACY,ACZ,ACY2,COSG,SING,AQX,AQZ,QPERP,QPERP2
      COMMON/MAXC/CMAX(maxp),CMAXA(mxc),CMAXB(mxc),CMAXC(mxc),
     $  CMAXD(mxc),
     *ISMLP(maxc2),ISMLQ,ISML,ERROR1,ERROR2
      COMMON/B/EXX(maxp),C1(maxp),C2(maxp),C3(240),
     *X(maxp),Y(maxp),Z(maxp),JAN(80),SHELLA(maxp),SHELLN(maxp),
     *SHELLT(maxp),AOS(maxg),AON(20),NSHELL,MAXTYP
      common/ihol/ihold(maxg),ihsh(maxg),icent
      COMMON/AUXVAR/AUXVAR,VAR1,VAR2
      COMMON/TABLE/TTT(6000)
      COMMON/IO/IN,IOUT,IPUNCH
       COMMON/IQ/ IFALQ
      common /limits/llsh(maxg),iulsh(maxg),ist
      DATA ZERO/0.0D0/,ONE/1.0D0/
      DATA SIXTY/60.0D0/
      DATA P00005/5.0D-5/
      data istart/0/
      if(istart.gt.0)goto 123
      nbasis=nbas
 613   format(1p5e15.7)
      istart=istart+1
      ist=istart

       ialim=aos(2)-1
      do 1600 i=1,aos(2)-1
 1600 ihold(i)=1
      ih=1
      ihs=1
      ihsh(1)=1
      llsh(1)=1
      do 1601 ksh=2,nshell
      if(x(ksh).ne.x(ksh-1).or.y(ksh).ne.y(ksh-1).or.
     $ z(ksh).ne.z(ksh-1))then
      ih=ih+1
      ihs=ihs+1
      iulsh(ihs-1)=ksh-1
      llsh(ihs)=ksh
      endif
      ihsh(ksh)=ihs
      do 1602 i=aos(ksh),aos(ksh+1)-1
 1602 ihold(i)=ih
 1601 continue
      iulsh(natoms)=nshell
  611 format(10i3)

      CALL SHLOUT(-1)
C     FILL COMMON MAXC ... USED IN DISCARDING SMALL (LESS THAN 10**-6)
C     INTEGRALS BEFORE THEY ARE FULLY EVALUATED
      CALL FILMAX
 123  continue
      llima=llsh(iat)
      iulima=iulsh(iat)

C   The cycles run on the orbitals of atom A

      DO 730 ISHELL=llima,iulima
      DO 720 JSHELL=llima,ISHELL
      DO 710 KSHELL=llima,ISHELL
      IF(ISHELL-KSHELL)50,60,50
   50 MAXL=KSHELL
      GO TO 70
   60 MAXL=JSHELL
   70 DO 700 LSHELL=llima,MAXL

      icent=1
      LAT=SHELLT(ISHELL)
      LBT=SHELLT(JSHELL)
      LCT=SHELLT(KSHELL)
      LDT=SHELLT(LSHELL)
      ndtyp=lat/2+lbt/2+lct/2+ldt/2
      if(ndtyp.gt.0)goto 700
      ITYPE=8*LAT+4*LBT+2*LCT+LDT+1
      GO TO (110,110,130,110,140,110,130,110,160,120,150,120,140,140,170
     *,110),ITYPE
C     TYPES 0000,0001,0101,0011,0111,1111 ARE UNALTERED
  110 INEW=ISHELL
      JNEW=JSHELL
      KNEW=KSHELL
      LNEW=LSHELL
      LA=LAT
      LB=LBT
      LC=LCT
      LD=LDT
      GO TO 180
C     TYPES 1001,1011 HAVE IJ SWITCHED
  120 INEW=JSHELL
      JNEW=ISHELL
      KNEW=KSHELL
      LNEW=LSHELL
      LA=LBT
      LB=LAT
      LC=LCT
      LD=LDT
      GO TO 180
C     TYPES 0010,0110 HAVE KL SWITCHED
  130 INEW=ISHELL
      JNEW=JSHELL
      KNEW=LSHELL
      LNEW=KSHELL
      LA=LAT
      LB=LBT
      LC=LDT
      LD=LCT
      GO TO 180
C     TYPES 0100,1100,1101 HAVE PAIRS IJ AND KL SWITCHED
  140 INEW=KSHELL
      JNEW=LSHELL
      KNEW=ISHELL
      LNEW=JSHELL
      LA=LCT
      LB=LDT
      LC=LAT
      LD=LBT
      GO TO 180
C     TYPE 1010 HAS IJ SWITCHED AND KL SWITCHED
  150 INEW=JSHELL
      JNEW=ISHELL
      KNEW=LSHELL
      LNEW=KSHELL
      LA=LBT
      LB=LAT
      LC=LDT
      LD=LCT
      GO TO 180
C     TYPE HAS PAIRS IJ AND KL SWITCHED FOLLOWED BY KL SWITCH
  160 INEW=KSHELL
      JNEW=LSHELL
      KNEW=JSHELL
      LNEW=ISHELL
      LA=LCT
      LB=LDT
      LC=LBT
      LD=LAT
      GO TO 180
C     TYPE 1110 HAS PAIRS IJ AND KL SWITCHED FOLLOWED BY IJ SWITCH
  170 INEW=LSHELL
      JNEW=KSHELL
      KNEW=ISHELL
      LNEW=JSHELL
      LA=LDT
      LB=LCT
      LC=LAT
      LD=LBT
  180 CONTINUE
C     ONLY 6 STANDARD TYPES REMAIN. 0000,0001,0011,0101,0111,1111
C     SPECIFY THESE BY JTYPE
      GO TO (190,200,200,210,200,220,220,230,200,220,220,230,210,230,230
     *,240),ITYPE
  190 JTYPE=1
      NGOUT=1
      GO TO 250
  200 JTYPE=2
      NGOUT=4
      GO TO 250
  210 JTYPE=3
      NGOUT=16
      GO TO 250
  220 JTYPE=4
      NGOUT=64
      GO TO 250
  230 JTYPE=5
      NGOUT=64
      GO TO 250
  240 JTYPE=6
      NGOUT=256
  250 CONTINUE
C     EMPTY COMMON GOUT
      DO 260 I=1,NGOUT
  260 GOUT(I)=ZERO
      CALL SINFO
      CALL SGEOM
C     PRELIMINARY P LOOP
      CALL PINF
C     IF 0000 USE SPECIAL ROUTINE
      IF (JTYPE-1) 270,270,280
  270 CALL SP0000
      GO TO 690
C     BEGIN Q LOOP
  280 DO 490 K =1,NGC
      GC=CG(K)
      DO 490 L =1,NGD
      GD=DG(L)
      GCD=GC+GD
      ECD=ONE/GCD
      CQ=GD*ECD*RCD
      DQ=CQ-RCD
      XQQ=CQ*DQ*GCD
      IF(XQQ+SIXTY)182,184,184
  182 V=ZERO
      GO TO 186
  184 V=DEXP(XQQ)*ECD
  186 XXTEST=CMAXC(K)*CMAXD(L)*V
      IF(XXTEST-ERROR1)300,300,290
  290 ISMLQ=0
      GO TO 320
  300 IF(XXTEST-ERROR2)490,490,310
  310 ISMLQ=1
  320 SC=CSC(K)
      SD=CSD(L)
      PC=CPC(K)
      PD=CPD(L)
      DQ00=SC*SD*V
      DQ01=SC*PD*V
      DQ10=PC*SD*V
      DQ11=PC*PD*V
C     FIND COORDINATES OF Q RELATIVE TO AXES AT A
C     QPERP IS PERPENDICULAR FROM Q TO AB
      AQX=ACX+SING*CQ
      AQZ=ACZ+COSG*CQ
      QPERP2=AQX*AQX+ACY2
      QPERP=DSQRT(QPERP2)
C     PHI IS 180 - AZIMUTHAL ANGLE FOR AQ IN AB LOCAL AXIS SYSTEM
      IF(QPERP-P00005)340,340,330
  330 COSP=-AQX/QPERP
      SINP=-ACY/QPERP
      GO TO 350
  340 COSP=ONE
      SINP=ZERO
C     USE SPECIAL FAST ROUTINE FER INNER LOOP FOR 0101
  350 IF(JTYPE-4)370,360,370
  360 CALL SP0101
      GO TO 430
  370 IF(JTYPE-5)390,380,390
  380 CALL SP0111
      GO TO 430
  390 CONTINUE
C     BEGIN P LOOP
C     USE SPECIAL FAST ROUTINES FOR INNER LOOPS FOR 0001 AND 0011
      IF (JTYPE-3) 400,410,420
  400 CALL SP0001
      GO TO 490
  410 CALL SP0011
      GO TO 430
  420 CALL SP1111
  430 CALL ROT2
  440 GO TO (490,490,450,460,470,480),JTYPE
  450 CONTINUE
      CALL TQ0011
      GO TO 490
  460 CALL TQ0101
      GO TO 490
  470 CALL TQ0111
      GO TO 490
  480 CALL TQ1111
  490 CONTINUE
      GO TO (550,500,510,520,530,540),JTYPE
  500 CALL R30001
      GO TO 550
  510 CALL R30011
      GO TO 550
  520 CALL R30101
      GO TO 550
  530 CALL R30111
      GO TO 550
  540 CALL R31111
C     TEST FOR SHELL COINCIDENCES AND ELIMINATE DUPLICATES
  550 IF (JNEW-INEW) 600,560,600
  560 DO 570 I=17,64
  570 GOUT(I)=ZERO
      DO 580 I=97,128
  580 GOUT(I)=ZERO
      DO 590 I=177,192
  590 GOUT(I)=ZERO
  600 IF (LNEW-KNEW) 630,610,630
  610 DO 620 I=1,16
      GOUT(16*I-14)=ZERO
      GOUT(16*I-13)=ZERO
      GOUT(16*I-12)=ZERO
      GOUT(16*I- 9)=ZERO
      GOUT(16*I- 8)=ZERO
  620 GOUT(16*I- 4)=ZERO
  630 IF (KNEW-INEW) 690,640,690
  640 IF (LNEW-JNEW) 690,650,690
  650 IND=0
      DO 680 I=1,4
      DO 680 J=1,4
      DO 680 K=1,4
      DO 680 L=1,4
      IND=IND+1
      IF (I-K) 670,660,680
  660 IF (J-L) 670,680,680
  670 GOUT(IND)=ZERO
  680 CONTINUE
  690 CALL SHLOUT(NGOUT)
  700 CONTINUE
  710 CONTINUE
  720 CONTINUE
  730 CONTINUE
C     RESET OUTPUT ROUTINE
      CALL SHLOUT(0)

      return
      END

      SUBROUTINE SHELLab(iat,jat,nbas,natoms)

c Computes two-center two-electron integrals for S and P orbitals.

C     LINK 303
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     GAUSSIAN TWO ELECTRON INTEGRAL PACKAGE
C     MAIN LOOP OVER SHELLS ... SEE EXPLANATION IN PROGRAM GINPUT ...
C     LINK 301
C      ACCEPTS NUMBERS OF FOUR SHELLS
C     ISHELL  JSHELL  KSHELL  LSHELL
C     FINDS THEIR ANGULAR QUANTUM NUMBERS
C     AND
C     BASED ON THIS ORDERS SHELLS IN A STANDARD MANNER
C     INEW  JNEW  KNEW  LNEW
C     ONLY POSSIBILITIES ALLOWED FOR ANGULAR QUANTUM NUMBERS ARE THEN
C     0000  0001  0011  0101  0111  1111
C     DETERMINES TYPE OF INTEGRAL SET BASED ON THE ABOVE NUMBERS
C     CALLS THE FOLLOWING ROUTINES IN THE ORDER GIVEN
C     SHLOUT
C     FIRST TIME TO PRESET OUTPUT ROUTINES
C     FILMAX
C     TO PRESET INTEGRAL ACCURCY LIMITS
C     SINFO
C     OBTAINS GEOMETRICAL INFORMATION ABOUT THE FOUR CENTERS
C     FINDS TWO SETS OF LOCAL AXES
C     FOR CENTERS
C     A AND B  P SET
C     C AND D  Q SET
C     PINF
C     OBTAINS INFORMATION ABOUT GAUSSIAN FUNCTIONS CONNECTED WITH THE P
C     SET OF AXES
C     AT THIS POINT
C     SHELL OBTAINS INFORMATION ABOUT THE GAUSSIAN FUNCTIONS CONNECTED
C     WITH THE Q SET OF AXES
C     SP0000 TO SP1111
C     OBTAINS UP TO 88 INTEGRALS REFERRED TO AXES A B AND Q
C     ROT2
C     ROTATES THESE INTEGRALS TO UP TO 160 INTEGRALS ON A B AND Q
C     TQ0011 TO TQ1111
C     TRANSLATES THESE INTEGRALS ON A B AND Q TO UP TO 256 INTEGRALS ON
C     A B C AND D
C     R30001 TO R31111
C     ROTATES UP TO 256 INTEGRALS ON A B C AND D TO THE SAME NUMBER
C     REFERRED TO THE FIXED SPACE AXES
C     SHELL DETECTS SHELL COINCIDENCES AND ELIMINATES DUPLICATES
C     INTEGRALS ARE TRANSFERRED TO ROUTINE SHLOUT TO BE PUT ON DRUM
C     OR TAPE
C     A FINAL CALL TO SHLOUT CLOSES THE OUTPUT BUFFER
C*
C     ******************************************************************
C     OPTIONS ... IOP( )     SEE PROGRAM GINPUT ... SEGMENT 301
C     *****************************************************************
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER SHELLA,SHELLN,SHELLT,AOS,AON

      parameter (maxat=100)
      parameter (maxg=1000)
      parameter (maxp=2000)
      parameter (mxc=16)
      parameter (maxc2=225)
C*
C*
      COMMON IOP(52)
      COMMON iNATOMS,ICHARG,MULTIP,IAN(35),NAE,NBE,NE,NBASIS,CO(35,3)
      COMMON IUNIT(20),INFO(5)
C*
      COMMON/CONST/CONST,conp(maxc2)
      COMMON/SHLNOS/ISHELL,JSHELL,KSHELL,LSHELL,INEW,JNEW,KNEW,LNEW
      COMMON/SHLINF/NGA,LA,AG(10),CSA(10),CPA(10),NGB,LB,BG(10),CSB(10),
     *CPB(10),NGC,LC,CG(10),CSC(10),CPC(10),NGD,LD,DG(10),
     *CSD(10),CPD(10)
      COMMON/LT/LAT,LBT,LCT,LDT
      COMMON/MISC/MAB,MCD,NGANGB
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/PQGEOM/AP,BP,CQ,DQ,PX,PY,PZ,QX,QY,QZ,RPQ,RPQSQ,PQ1,PQ2,PQ3,
     *C11,C12,C13,C21,C22,C23,C31,C32,C33
      COMMON/GINF/GA,GB,GC,GD,SA,SB,SC,SD,PA,PB,PC,PD,GAB,GCD
      COMMON/H/H(160)
      COMMON/TYPE/ITYPE,JTYPE
      COMMON/GOUT/GOUT(256)
      COMMON/PGEOM/GP(maxc2),EP(maxc2),DP00P(maxc2),DP01P(maxc2),
     $  DP10P(maxc2),DP11P(maxc2),APP(maxc2),BPP(maxc2)
      COMMON/EABECD/EAB,ECD
      COMMON/DPQ/DP00,DP01,DP10,DP11,DQ00,DQ01,DQ10,DQ11
      COMMON/COS/C
      COMMON/PHI/COSP,SINP
      COMMON/QGEOM/ACX,ACY,ACZ,ACY2,COSG,SING,AQX,AQZ,QPERP,QPERP2
      COMMON/MAXC/CMAX(maxp),CMAXA(mxc),CMAXB(mxc),CMAXC(mxc),
     $  CMAXD(mxc),
     *ISMLP(maxc2),ISMLQ,ISML,ERROR1,ERROR2
      COMMON/B/EXX(maxp),C1(maxp),C2(maxp),C3(240),
     *X(maxp),Y(maxp),Z(maxp),JAN(80),SHELLA(maxp),SHELLN(maxp),
     *SHELLT(maxp),AOS(maxg),AON(20),NSHELL,MAXTYP
      common/ihol/ihold(maxg),ihsh(maxg),icent
      common /limits/llsh(maxg),iulsh(maxg),ist
      common/map/ imap(maxp)
      COMMON/AUXVAR/AUXVAR,VAR1,VAR2
      COMMON/TABLE/TTT(6000)
      COMMON/IO/IN,IOUT,IPUNCH
      COMMON/IQ/ IFALQ
 
      DATA ZERO/0.0D0/,ONE/1.0D0/
      DATA SIXTY/60.0D0/
      DATA P00005/5.0D-5/
      if(ist.ne.0)goto 123
       nbasis=nbas
      iunit(2)=5
      iunit(3)=6
      iunit(4)=7
      iunit(11)=9
      in=5
      iout=6
      ipunch=7

      do 1600 i=1,aos(2)-1
 1600 ihold(i)=1
      ih=1
      ihs=1
      ihsh(1)=1
      llsh(1)=1
      do 1601 ksh=2,nshell
      if(x(ksh).ne.x(ksh-1).or.y(ksh).ne.y(ksh-1).or.
     $ z(ksh).ne.z(ksh-1))then
      ih=ih+1
      ihs=ihs+1
      iulsh(ihs-1)=ksh-1
      llsh(ihs)=ksh
      endif
      ihsh(ksh)=ihs
      do 1602 i=aos(ksh),aos(ksh+1)-1
 1602 ihold(i)=ih
 1601 continue
      iulsh(natoms)=nshell
 611  format(10i3)
 123  ma=iulsh(iat)-llsh(iat)+1
      mb=iulsh(jat)-llsh(jat)+1
      mab=ma+mb
      do 121 i=1,ma
 121  imap(i)=llsh(iat)+i-1
      do 122 i=1,mb
 122  imap(ma+i)=llsh(jat)+i-1

c     This "mapping" provides that only integrals involving centers
C     A and B will be calculated

      CALL FILMAX
      DO 730 ifut=1,mab
      ishell=imap(ifut)
      DO 720 jfut=1,ifut
      jshell=imap(jfut)
      DO 710 kfut=1,ifut
      kshell=imap(kfut)
      IF(ifut-kfut)50,60,50
   50 MAXL=kfut
      GO TO 70
   60 MAXL=jfut
   70 DO 700 lfut=1,MAXL
      lshell=imap(lfut)
      ih1=ihsh(ishell)
      icent=1
      if(ihsh(jshell).ne.ih1)then
      icent=2
      ih2=ihsh(jshell)
      endif

      goto (101,102),icent
  101 if(ihsh(kshell).ne.ih1)then
      icent=2
      ih2=ihsh(kshell)
      endif
      goto 103
  102 if(ihsh(kshell).ne.ih1.and.ihsh(kshell).ne.ih2) stop 700

  103 goto (203,202),icent
  202 if(ihsh(lshell).ne.ih1.and.ihsh(lshell).ne.ih2) stop 701
  203 if(ihsh(lshell).ne.ih1) icent=2
      if(icent.eq.1)goto 700

      LAT=SHELLT(ISHELL)
      LBT=SHELLT(JSHELL)
      LCT=SHELLT(KSHELL)
      LDT=SHELLT(LSHELL)
      ndtyp=lat/2+lbt/2+lct/2+ldt/2
      if(ndtyp.gt.0)goto 700

      ITYPE=8*LAT+4*LBT+2*LCT+LDT+1
      GO TO (110,110,130,110,140,110,130,110,160,120,150,120,140,140,170
     *,110),ITYPE
C     TYPES 0000,0001,0101,0011,0111,1111 ARE UNALTERED
  110 INEW=ISHELL
      JNEW=JSHELL
      KNEW=KSHELL
      LNEW=LSHELL
      LA=LAT
      LB=LBT
      LC=LCT
      LD=LDT
      GO TO 180
C     TYPES 1001,1011 HAVE IJ SWITCHED
  120 INEW=JSHELL
      JNEW=ISHELL
      KNEW=KSHELL
      LNEW=LSHELL
      LA=LBT
      LB=LAT
      LC=LCT
      LD=LDT
      GO TO 180
C     TYPES 0010,0110 HAVE KL SWITCHED
  130 INEW=ISHELL
      JNEW=JSHELL
      KNEW=LSHELL
      LNEW=KSHELL
      LA=LAT
      LB=LBT
      LC=LDT
      LD=LCT
      GO TO 180
C     TYPES 0100,1100,1101 HAVE PAIRS IJ AND KL SWITCHED
  140 INEW=KSHELL
      JNEW=LSHELL
      KNEW=ISHELL
      LNEW=JSHELL
      LA=LCT
      LB=LDT
      LC=LAT
      LD=LBT
      GO TO 180
C     TYPE 1010 HAS IJ SWITCHED AND KL SWITCHED
  150 INEW=JSHELL
      JNEW=ISHELL
      KNEW=LSHELL
      LNEW=KSHELL
      LA=LBT
      LB=LAT
      LC=LDT
      LD=LCT
      GO TO 180
C     TYPE HAS PAIRS IJ AND KL SWITCHED FOLLOWED BY KL SWITCH
  160 INEW=KSHELL
      JNEW=LSHELL
      KNEW=JSHELL
      LNEW=ISHELL
      LA=LCT
      LB=LDT
      LC=LBT
      LD=LAT
      GO TO 180
C     TYPE 1110 HAS PAIRS IJ AND KL SWITCHED FOLLOWED BY IJ SWITCH
  170 INEW=LSHELL
      JNEW=KSHELL
      KNEW=ISHELL
      LNEW=JSHELL
      LA=LDT
      LB=LCT
      LC=LAT
      LD=LBT
  180 CONTINUE
C     ONLY 6 STANDARD TYPES REMAIN. 0000,0001,0011,0101,0111,1111
C     SPECIFY THESE BY JTYPE
      GO TO (190,200,200,210,200,220,220,230,200,220,220,230,210,230,230
     *,240),ITYPE
  190 JTYPE=1
      NGOUT=1
      GO TO 250
  200 JTYPE=2
      NGOUT=4
      GO TO 250
  210 JTYPE=3
      NGOUT=16
      GO TO 250
  220 JTYPE=4
      NGOUT=64
      GO TO 250
  230 JTYPE=5
      NGOUT=64
      GO TO 250
  240 JTYPE=6
      NGOUT=256
  250 CONTINUE
C     EMPTY COMMON GOUT
      DO 260 I=1,NGOUT
  260 GOUT(I)=ZERO
      CALL SINFO
      CALL SGEOM
C     PRELIMINARY P LOOP
      CALL PINF
C     IF 0000 USE SPECIAL ROUTINE
      IF (JTYPE-1) 270,270,280
  270 CALL SP0000
      GO TO 690
C     BEGIN Q LOOP
  280 DO 490 K =1,NGC
      GC=CG(K)
      DO 490 L =1,NGD
      GD=DG(L)
      GCD=GC+GD
      ECD=ONE/GCD
      CQ=GD*ECD*RCD
      DQ=CQ-RCD
      XQQ=CQ*DQ*GCD
      IF(XQQ+SIXTY)182,184,184
  182 V=ZERO
      GO TO 186
  184 V=DEXP(XQQ)*ECD
  186 XXTEST=CMAXC(K)*CMAXD(L)*V
      IF(XXTEST-ERROR1)300,300,290
  290 ISMLQ=0
      GO TO 320
  300 IF(XXTEST-ERROR2)490,490,310
  310 ISMLQ=1
  320 SC=CSC(K)
      SD=CSD(L)
      PC=CPC(K)
      PD=CPD(L)
      DQ00=SC*SD*V
      DQ01=SC*PD*V
      DQ10=PC*SD*V
      DQ11=PC*PD*V
C     FIND COORDINATES OF Q RELATIVE TO AXES AT A
C     QPERP IS PERPENDICULAR FROM Q TO AB
      AQX=ACX+SING*CQ
      AQZ=ACZ+COSG*CQ
      QPERP2=AQX*AQX+ACY2
      QPERP=DSQRT(QPERP2)
C     PHI IS 180 - AZIMUTHAL ANGLE FOR AQ IN AB LOCAL AXIS SYSTEM
      IF(QPERP-P00005)340,340,330
  330 COSP=-AQX/QPERP
      SINP=-ACY/QPERP
      GO TO 350
  340 COSP=ONE
      SINP=ZERO
C     USE SPECIAL FAST ROUTINE FER INNER LOOP FOR 0101
  350 IF(JTYPE-4)370,360,370
  360 CALL SP0101
      GO TO 430
  370 IF(JTYPE-5)390,380,390
  380 CALL SP0111
      GO TO 430
  390 CONTINUE
C     BEGIN P LOOP
C     USE SPECIAL FAST ROUTINES FOR INNER LOOPS FOR 0001 AND 0011
      IF (JTYPE-3) 400,410,420
  400 CALL SP0001
      GO TO 490
  410 CALL SP0011
      GO TO 430
  420 CALL SP1111
  430 CALL ROT2
  440 GO TO (490,490,450,460,470,480),JTYPE
  450 CONTINUE
      CALL TQ0011
      GO TO 490
  460 CALL TQ0101
      GO TO 490
  470 CALL TQ0111
      GO TO 490
  480 CALL TQ1111
  490 CONTINUE
      GO TO (550,500,510,520,530,540),JTYPE
  500 CALL R30001
      GO TO 550
  510 CALL R30011
      GO TO 550
  520 CALL R30101
      GO TO 550
  530 CALL R30111
      GO TO 550
  540 CALL R31111
C     TEST FOR SHELL COINCIDENCES AND ELIMINATE DUPLICATES
  550 IF (JNEW-INEW) 600,560,600
  560 DO 570 I=17,64
  570 GOUT(I)=ZERO
      DO 580 I=97,128
  580 GOUT(I)=ZERO
      DO 590 I=177,192
  590 GOUT(I)=ZERO
  600 IF (LNEW-KNEW) 630,610,630
  610 DO 620 I=1,16
      GOUT(16*I-14)=ZERO
      GOUT(16*I-13)=ZERO
      GOUT(16*I-12)=ZERO
      GOUT(16*I- 9)=ZERO
      GOUT(16*I- 8)=ZERO
  620 GOUT(16*I- 4)=ZERO
  630 IF (KNEW-INEW) 690,640,690
  640 IF (LNEW-JNEW) 690,650,690
  650 IND=0
      DO 680 I=1,4
      DO 680 J=1,4
      DO 680 K=1,4
      DO 680 L=1,4
      IND=IND+1
      IF (I-K) 670,660,680
  660 IF (J-L) 670,680,680
  670 GOUT(IND)=ZERO
  680 CONTINUE
  690 CALL SHLOUT(NGOUT)
  700 CONTINUE
  710 CONTINUE
  720 CONTINUE
  730 CONTINUE
C     RESET OUTPUT ROUTINE
      CALL SHLOUT(0)

      return
      END
