c     
c                        Program APEX4, Version 1.0
c                        --------------------------
c
c                         I. Mayer and A. Hamza
c            Chemical Research Center, Hungarian Academy of Sciences
c                    H-1515 Budapest, P.O.Box 17, Hungary
c
c             e-mails: mayer@chemres.hu,  hamza@chemres.hu
c
c ------------------------------------------------------------------------
c
c   This program performs *a posteriori* analysis of the single determinant 
c   Hartree-Fock ab initio wave wave functions produced by the widely used 
c   "Gaussian" system G92, G94, G98, G03. (For DFT-type wave functions
c   - actulally B3LYP - the HF-like energy of the single determinant built 
c   up of the Kohn-Sham orbitals can be considered.) 
c
c  The analyses performed:
c
c  A) Bond order and valence analysis (I. Mayer, Chem. Phys. Lett. 97, 270 
c     1983; addendum for open shells: Chem. Phys. Lett. 117, 396, 1985, etc.);
c
c  B) "Chemical Energy Component Analysis" (CECA), introduced in I. Mayer, 
c     Chem. Phys. Lett. 332, 381, 2000. CECA permits to express the
c     molecular energy  -- approximately but to a good accuracy -- as a sum of
c     one- and diatomic energy components, the computation of which requires
c     one and two-center integrals only; three- and four-center effects are 
c     compressed to one- and two-center ones by performing appropriate 
c     projections; 
c
c  C) The decomposition of the two-center energy components into terms
c     of different physical origin, as defined in I. Mayer and A. Hamza
c     Theor. Chem. Accounts 109, 92, 2003.
c
c  D) The "Exact Energy Decomposition" as defined in I. Mayer, Chem. Phys.
c     Lett. 382, 265 (2003). It differs from CECA by the absence of
c     approximations and a different treatment of the kinetic energy
c     and the two-center finite basis corrections. 
c
c  In fact, four different energy decomposition matrices are computed,
c  two approximate and two exact. They differ in the approximate or
c  exact treatment of the the 3- and 4-center integrals from one side, 
c  and in the treatment of kinetic energy integrals and (two-center)
c  finite basis corrections from the other. One type of decompositions 
c  (the approximate CECA and the exact "CECA + 3- and 4-center terms") 
c  contain kinetic energy mainly in the atomic terms (and in the finite 
c  basis corrections) while the "CECA/T" and "exact" decomposition contain 
c  both one-and two-centyer kinetic energy contributions and there is no 
c  need in the finite basis correction terms. Only two of these four have 
c  been described in publications as yet: see CECA in A) and "exact" in D)
c  above. The diatomic components printed are essentially those in C).
c  (Plus the kinetic energy is printed).
c
c  The "approximate" and "exact" schemes become identical for diatomics.
c
c  The CECA-type quantities are good indicators of different interactions, 
c  but are not on the "chemical scale": there arelarge atomic promotions and 
c  large (in absolute value) two-center binding components. The CECA/T and 
c  "exact" schemes give much more "chemical" values, but should be used only 
c  at the equilibrium molecular geometries.
c
c
c  
c
      implicit real*8(a-h,o-z)
      common iop(45)
      common /nat/ nat,igr,ifg,nocc,nalf,nb,iuhf
      
      parameter (nmax=500)
      parameter (maxat=100)
      parameter (maxat1=101)
      parameter (maxp=2000)
      parameter (ndeckl=500)
      parameter (mmax=5 000 000)
      parameter (mgmax=20 000 000)
      common /lim/ llim(nmax),iulim(nmax)
      common /large/aa(mmax),gg(mgmax),z(mmax),gt(mgmax)  
      dimension sam(ndeckl,ndeckl)
      dimension ea(maxat),eab(maxat,maxat),h(ndeckl,ndeckl)
      dimension epoint(maxat,maxat),epent(maxat,maxat),exch(maxat,maxat)
      dimension efin(maxat,maxat),eover(maxat,maxat)   
      dimension elect(maxat,maxat),eaa(maxat,maxat), et(maxat,maxat)
      dimension pmul(maxat)
      common /c/c(ndeckl,ndeckl),p(ndeckl,ndeckl)
      common /pointer/ipoint(maxat),ijpoint(maxat,maxat),na(maxat)     
      common /coord/ coord(3,maxat),zn(maxat)
      common /oneel/oneel,bsse
      common /stv/ s(ndeckl,ndeckl),t(ndeckl,ndeckl),
     $             vv(ndeckl,ndeckl,maxat)
      common /ia/iznuc(maxat),kop,megall

      common/comp/ecomp1(maxat,maxat)
      common /map/imap(maxp),imapsav(maxp)

c     data bohr/0.52917715D+00/
c     data bohr/0.52917706D+00/

      call kiir
      call start
 
      oneel=0.d0
      bsse=0.d0

      m=igr


      call getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      if(nat.ne.natoms) stop 7584
      if(m.ne.nbas) stop 7585
      nlength=natoms*nbas**2           
      if(nlength.gt.mmax)then
      write(*,*) nlength,' WORDS ARE REQUIRED FOR THE MATRIX Z/A'
      write(*,*) ' AVAILABLE ONLY:', mmax, '--  STOP'
      stop
      endif

      ng=0
      do i=1,natoms
      ipoint(i)=ng+1
      ng=ng+na(i)**4
      enddo
      ijpoint(1,2)=ng+1
      maxx=0
      do i=1,natoms-1
      do j=i+1,natoms
      maxx=max0(maxx,na(i)+na(j))
      enddo
      enddo
      ng=ng+maxx**4
      if(ng.gt.mgmax)then
      write(*,*) ng,' WORDS ARE REQUIRED FOR THE MATRIX G'
      write(*,*) ' AVAILABLE ONLY:', mgmax, '--  STOP'
      stop
      endif

      
      call getcore(z,ndeckl,nbas,natoms,h)

      if(iuhf.eq.1) then
      kop=1
      call enpo(na,ipoint,ijpoint) 
      stop
      endif

      call pm(c,nocc,nbas,p,ndeckl)
      call border(P,sam,S,llim,iulim,natoms,nbas)
     
      if(iop(7).eq.2)then
      print *,' '
      print *,' '
      print *,' '
      print *,' '
      print *,'The present program does not perform energy', 
     $ ' partitioning',
     $ ' for F (G...) orbitals'
      print *,' '
      print *,'          PROGRAM STOPS'
      stop 4359
      endif

      print *,'   '
      print 688
 688  format(80(1h-))
      print *,'   '
      nnab=(natoms*(natoms-1)/2)
      write(*,*)natoms,' ATOMS, ',nnab,' ATOMIC PAIRS'
      call inpint(gg,mgmax,natoms,llim,iulim)
      eonec=0.d0
      eoneca=0.d0
      do 100 i=1,natoms 
      ip=ipoint(i)
      call atomic(i,h,p,ndeckl,llim(i),na(i),sam,ea(i),
     $    z,nbas,natoms,gg(ip),aa,eaa(i,i))
c     write(*,*)' ATOM', i,' ATOMIC ENERGY COMPONENT ',ea(i) 
      eoneca=eoneca+eaa(i,i)
 100  eonec=eonec+ea(i)     
      write(*,*)' '
      write(*,*)' '
      write(*,*)' SUM OF THE ONE-CENTER ENERGY COMPONENTS-CECA  ',eonec
      write(*,*)' SUM OF THE ONE-CENTER ENERGY COMPONENTS-CECA/T',eoneca

      do 400 i=1,natoms
      x=0.d0
      do 401 nu=llim(i),iulim(i) 
      do 402 igamma=1,m
 402  x=x+p(nu,igamma)*s(igamma,nu)  
 401  continue
 400  pmul(i)=x
      

      nat1=natoms-1
      etwoc=0.d0
      etwoca=0.d0
      sum0=0.d0
      sum01=0.d0
      sum1=0.d0
      sum2=0.d0
      sum3=0.d0
      sum4=0.d0
      do 200 i=1,nat1 
      i1=i+1
      do 200 j=i1,natoms
      nnn=na(i)+na(j)
      ip=ijpoint(1,2)
      ipi=ipoint(i)
      ipj=ipoint(j)

      call pairs(i,j,h,ndeckl,llim(i),na(i),llim(j),na(j),sam,
     $   nnn,eab(i,j),aa,p,z,m,natoms,gg(ip),gg(ipi),gg(ipj),gt,
     $   epoint(i,j),epent(i,j),exch(i,j),efin(i,j),eover(i,j),
     $   elect(i,j),pmul,eaa(i,j),ecorri,ecorrj,et(i,j))
c     write(*,*)' ATOMS', i,j,'TWO-CENTER EN. CONTRIBUTION ',eab(i,j) 
      eab(j,i)=eab(i,j)
      eaa(j,i)=eaa(i,j)
      eaa(i,i)=eaa(i,i)+ecorri
      eaa(j,j)=eaa(j,j)+ecorrj
      epoint(j,i)=epoint(i,j)
      epent(j,i)=epent(i,j) 
      exch(j,i)=exch(i,j) 
      efin(j,i)=efin(i,j) 
      eover(j,i)=eover(i,j) 
      elect(j,i)=elect(i,j) 
      et(j,i)=et(i,j)
      sum01=sum01+elect(i,j)
      sum0=sum0+epoint(i,j) 
      sum1=sum1+epent(i,j)
      sum2=sum2+exch(i,j)
      sum3=sum3+efin(i,j)
      sum4=sum4+eover(i,j)
      etwoca=etwoca+eaa(i,j)  
      eoneca=eoneca+ecorri+ecorrj
 200  etwoc=etwoc+eab(i,j)  
      write(*,*)' '
      write(*,*)' SUM OF THE TWO-CENTER ENERGY COMPONENTS-CECA  ',etwoc
      write(*,*)' SUM OF THE TWO-CENTER ENERGY COMPONENTS-CECA/T',etwoca
      econt=eonec+etwoc
      econta=eoneca+etwoca
      write(*,*)' '
      write(*,*)' '
      write(*,*)' SUM OF THE ONE AND TWO-CENTER COMPONENTS-CECA  ',econt
      write(*,*)' SUM OF THE ONE AND TWO-CENTER COMPONENTS-CECA/T',econta
      do 66 i=1,natoms
  66  eab(i,i)=ea(i)

      write(*,*)' '
      write(*,*)' '
      Write(*,*)'          ENERGY COMPONENT MATRIX - CECA'
      write(*,*)' '
      call mprint(eab,natoms,maxat)
      write(*,*)' '
      write(*,*)' '
      Write(*,*)'          ENERGY COMPONENT MATRIX - CECA/T'
      write(*,*)' '
      call mprint(eaa,natoms,maxat)
      write(*,*)' '
      write(*,*)' '
c     if(megall.eq.0) return
      write(*,*)' '
      write(*,*)' TWO-CENTER COMPONENTS ---- DECOMPOSITION'
      write(*,*)' '
c     write(*,*)' ELECTROSTATIC',sum01
c     write(*,*)' '
c     write(*,*)' POINT-CHARGE',sum0
c     write(*,*)' '
c     write(*,*)' DEVIATION FROM POINT-CH.',sum1
c     write(*,*)' '
c     write(*,*)' EXCHANGE',sum2
c     write(*,*)' '
c     write(*,*)' OVERLAP-EFFECTS',sum4
c     write(*,*)' '
c     write(*,*)' FINITE-BASIS',sum3
c     write(*,*)' '
      sum=sum0+sum1+sum2+sum3+sum4
c     write(*,*)' SUM OF THE TWO-CENTER TERMS', sum 
c     write(*,*)' '
c     write(*,*)' ERROR',etwoc-sum
      write(*,*)' '
      write(*,*)'  ELECTROSTATIC CONTRIBUTIONS  '
      call mprint(elect,natoms,maxat)
      write(*,*)' '
      write(*,*)'  ELECTROSTATICS: POINT-CHARGE APPROXIMATION  '
      call mprint(epoint,natoms,maxat)
      write(*,*)' '
      write(*,*)'  ELECTROSTATICS: DEVIATION FROM P.-CH. APPROIMATION  '
      call mprint(epent,natoms,maxat)
      write(*,*)' '
      write(*,*)'  EXCHANGE CONTRIBUTIONS  '
      call mprint(exch,natoms,maxat)
      write(*,*)' '
      write(*,*)'  OVERLAP CONTRIBUTIONS  '
      call mprint(eover,natoms,maxat)
      write(*,*)' '
      write(*,*)'  FINITE-BASIS CORRECTIONS (CECA) '
      call mprint(efin,natoms,maxat)
      write(*,*)' '
      write(*,*)'  KINETIC ENERGY (CECA/T)  '
      call mprint(et,natoms,maxat)

c     call mprint(t,igr,ndeckl)
      
      do i=1,natoms
      do j=i,natoms
      xx=0.d0
      do mu=llim(i),iulim(i)
c     mmu=imapsav(mu)
      do nu=llim(j),iulim(j)
c     mnu=imapsav(nu)
      xx=xx+p(mu,nu)*t(nu,mu)
      enddo
      enddo
      ecomp1(i,j)=2.d0*xx
      if(i.eq.j)ecomp1(i,j)=xx
      enddo
      enddo
c     write(*,*)' '
c     write(*,*)'  Kinetic energy (exact)  '
c     call mprint(et,natoms,maxat)


      
      do i=1,natoms
      xx=0.d0
      do mu=llim(i),iulim(i)
      do nu=1,m
      xx=xx+p(mu,nu)*vv(nu,mu,i)
      enddo
      enddo
      ecomp1(i,i)=ecomp1(i,i)+xx
      enddo
      
      do i=1,natoms-1
      do j=i+1,natoms
      
      
      xx=zn(i)*zn(j)/dsqrt((coord(1,i)-coord(1,j))**2
     $   + (coord(2,i)-coord(2,j))**2+(coord(3,i)-coord(3,j))**2)
      do mu=llim(i),iulim(i)
      do nu=1,m
      xx=xx+p(mu,nu)*vv(nu,mu,j)
      enddo
      enddo
      ecomp1(i,j)=ecomp1(i,j)+xx


      xx=0.d0
      do mu=llim(j),iulim(j)
      do nu=1,m
      xx=xx+p(mu,nu)*vv(nu,mu,i)
      enddo
      enddo
      ecomp1(i,j)=ecomp1(i,j)+xx

      enddo
      enddo

      
c     write(*,*)' '
c     write(*,*)'  Exact energy decomposition matrix (one el.)'
c     call mprint(ecomp1,natoms,maxat)
      

      call shellgen(igr,natoms)
c     print *, 'iop(7)=',iop(7)
c     write(*,*)' '
c     write(*,*)'   Uncon elott'
c     call mprint(ecomp1,natoms,maxat)

      if(iop(7).ne.0)call uncongen

      e1e=0.d0
      e2e=0.d0
      do i=1,natoms
      e1e=e1e+ecomp1(i,i)
      do j=i+1,natoms
      e2e=e2e+ecomp1(i,j)
      ecomp1(j,i)=ecomp1(i,j)
      enddo
      enddo

      do i=1,natoms
      do j=1,natoms
      eaa(j,i)=ecomp1(j,i)-eaa(j,i)
      enddo
      enddo
      write(*,*)' '
      write(*,*)' Remaining 3- and 4-center contributions'
      call mprint(eaa,natoms,maxat)

      do i=1,natoms
      do j=1,natoms
      eaa(j,i)=eab(j,i)+eaa(j,i)
      enddo
      enddo
c     write(*,*)' '
c     write(*,*)' CECA + 3- and 4-center contributions'
c     call mprint(eaa,natoms,maxat)
      ec341=0.d0
      ec342=0.d0
      do i=1,natoms
      ec341=ec341+eaa(i,i)
      enddo
      do i=1,natoms
      do j=i+1,natoms
      ec342=ec342+eaa(i,j)
      enddo
      enddo 
      


      
      write(*,*)' '
      print *,' Sum of CECA+3/4 one center energy components',ec341
      print *,'  Sum of "exact" one center energy components',e1e
      write(*,*)' '
      print *,' Sum of CECA+3/4 two center energy components',ec342
      print *,'  Sum of "exact" two center energy components',e2e
      write(*,*)' '
      print *,' Sum of CECA+3/4 one and two center energy components',
     $  ec341+ec342
      print *,'  Sum of "exact" one and two center energy components',
     $  e1e+e2e

      write(*,*)' '
      write(*,*)' CECA + 3- and 4-center contributions '
      write(*,*)'  (Also sums to the exact energy)'
      write(*,*)' '
      call mprint(eaa,natoms,maxat)
      
      write(*,*)' '
      write(*,*)'  "Exact" energy decomposition matrix'
      call mprint(ecomp1,natoms,maxat)


      end 

      subroutine getparm(llim,iulim,natoms,nbas,na,nmax,maxat)
      implicit real*8(a-h,o-z)
      parameter (n128=500)
      dimension llim(n128),iulim(n128),na(maxat)
      NATOMS=0
      NBAS=0
      DO 3 I=1,n128
      IF(iulim(I).GT.0) NATOMS=I
  3   NBAS=iulim(natoms)
       if(natoms.gt.maxat)then
      write(*,*)'   TOO MANY ATOMS, STOP'
      stop
       endif
      if(natoms.eq.1) then
      write(*,*)'  ONLY ONE ATOM'
      stop  
      endif
      nnn=0
      do 4 i=1,natoms
      na(i)=iulim(i)-llim(i)+1
  4   nnn=nnn+na(i)
      if(nnn.ne.nbas)stop 1212
      nnab=(natoms*(natoms-1))/2
      if(nnab*2.ne.natoms*(natoms-1))stop 1213

      print *,'   '
      write(*,*)natoms,' ATOMS, ',nnab,' ATOMIC PAIRS'
      
      end

      subroutine getcore(z,ndeckl,nbas,natoms,h)
      implicit real*8(a-h,o-z)
      parameter (maxat=100)
      parameter (ndeck=500) 
      parameter (maxp=2000)
      common /stv/ s(ndeck,ndeck),t(ndeck,ndeck),
     $   vv(ndeck,ndeck,maxat)   
      dimension h(ndeckl,ndeckl),z(nbas,nbas,natoms)
      common /map/imap(maxp),imapsav(maxp)
      m=nbas

      do i=1,m
      imapsav(i)=imap(i)
      enddo
      
      do 1 iat=1,natoms
       do 11 j=1,m
       jj=imap(j)
       do 11 i=1,m
        ii=imap(i)
   11  z(jj,ii,iat)=vv(j,i,iat)
       do 12 j=1,m
       do 12 i=1,m
   12  vv(j,i,iat)=z(j,i,iat)
   1  continue
       do 21 j=1,m
       jj=imap(j)
       do 21 i=1,m
        ii=imap(i)
   21  h(jj,ii)=t(j,i)
       do 31 i=1,m
       do 31 j=1,m
   31  t(j,i)=h(j,i)
       
       do 121 j=1,m
       jj=imap(j)
       do 121 i=1,m
        ii=imap(i)
  121  h(jj,ii)=s(j,i)
       do 131 i=1,m
       do 131 j=1,m
  131  s(j,i)=h(j,i)
       
  61  format(1x,8f9.6)

       return
       end

      subroutine atomic(iat,h,p,ndeckl,llim,na,sam,ea,z,m,natoms,
     $ g,aa,eaa)
      implicit real*8(a-h,o-z)
      parameter (ndeck=500)
      parameter (maxat=100)
      common /stv/ s(ndeck,ndeck),t(ndeck,ndeck),
     $             vv(ndeck,ndeck,maxat)
      dimension h(ndeckl,ndeckl),sam(na,na)
      dimension p(ndeckl,ndeckl),z(m,m,natoms)
      dimension ha(ndeck,ndeck),a(ndeck,ndeck),b(ndeck,ndeck)
      dimension aa(m,m,natoms),g(na,na,na,na)
      common /oneel/oneel,bsse

      call invert1(s,ndeckl,sam,llim,na)
 613   format(10f8.4)
      do 1 i=1,m
      do 1 j=1,m
  1   ha(i,j)=t(i,j)+z(i,j,iat) 
       do 11 i=1,m
       do 11 j=1,m
       b(i,j)=0.d0
  11   a(j,i)=0.d0       


      do 2 lambda=1,m
      do 2 mu0=1,na
      mu=llim+mu0-1 
      x=0.d0
      do 3 isigm0=1,na
      isigm=isigm0+llim-1 
  3    x=x+s(lambda,isigm)*sam(isigm0,mu0)
   2  a(lambda,mu)=x
    
      do 18 i=1,m
      do 18 j=1,m
  18  aa(i,j,iat)=a(i,j)

      do 4  mu0=1,na
      mu=llim+mu0-1 
      do 4  nu0=1,na
      nu=llim+nu0-1 
      x=0.d0
      do 5 igam=1,m
  5   x=x+p(mu,igam)*a(igam,nu) 
  4   b(mu,nu)=x
 
      ea=0.d0
      eaa=0.d0
      do 6  mu0=1,na
      mu=llim+mu0-1 
      do 6  nu0=1,na
      nu=llim+nu0-1 
      eaa=eaa+p(nu,mu)*t(mu,nu)
c     eaa=eaa+b(nu,mu)*z(mu,nu,iat)
c     eaa=eaa+p(nu,mu)*ha(mu,nu)
  6   ea=ea+b(nu,mu)*ha(mu,nu)


      do 161  mu=1,m
c     mu=llim+mu0-1 
      do 161  nu0=1,na
      nu=llim+nu0-1 
 161  eaa=eaa+p(mu,nu)*z(nu,mu,iat)
      
      oneel=oneel+ea
      et=0.d0
      do 7 kappa0=1,na
      kappa=llim+kappa0-1
      do 7 iro0=1,na
      iro=llim+iro0-1
      do 7 itau0=1,na
      itau=llim+itau0-1
      do 7 ieta0=1,na
      ieta=llim+ieta0-1
  7   et=et+g(itau0,ieta0,kappa0,iro0)*(b(kappa,itau)*b(iro,ieta)-
     $   0.5d0*b(kappa,ieta)*b(iro,itau)) 
       
      ea=ea+0.5d0*et
      eaa=eaa+0.5d0*et
c     print *,iat,ea,eaa
      return
      end
      subroutine pairs(ii,jj,h,ndeckl,llimi,ni,llimj,nj,sam,
     $   nnn,eabij,aa,p,z,m,natoms,gg,gi,gj,gt,eabpoint,eabpent,
     $   eabexch,eabfin,eabover,eabelect,popm,eabija,ecorri,ecorrj,
     $    eabta)
      implicit real*8(a-h,o-z) 
      parameter (maxat=100)
      parameter (ndeck=500)
      common /stv/ s(ndeck,ndeck),t(ndeck,ndeck),
     $             vv(ndeck,ndeck,maxat)
      dimension h(ndeckl,ndeckl),sam(nnn,nnn),
     $ p(ndeckl,ndeckl),aa(m,m,natoms), 
     $ z(m,m,natoms),a(ndeck,ndeck),b(ndeck,ndeck)
      dimension gg(nnn,nnn,nnn,nnn),gi(ni,ni,ni,ni),gj(nj,nj,nj,nj)          
      dimension gt(nnn,nnn,nnn,nnn) 
      dimension bba(ndeck,ndeck),bbb(ndeck,ndeck)
      dimension popm(maxat)
      common /coord/ coord(3,maxat),zn(maxat)
      common /oneel/oneel,bsse
      common /nat/ idum1,nbasis,idum2(5)
      common iop(45)
c
C  Statement function to form combination with the exchange part:

      pp(i,j,k,l)=p(i,j)*p(k,l)-0.5d0*p(i,l)*p(k,j)
      bb(i,j,k,l)=b(i,j)*b(k,l)-0.5d0*b(i,l)*b(k,j)
      bab(i,j,k,l)=bba(i,j)*bbb(k,l)
      cba(i,j,k,l)=-0.5d0*bbb(i,l)*bba(k,j)
      bcab(i,j,k,l)=bba(i,j)*bbb(k,l)-0.5d0*bbb(i,l)*bba(k,j)
c
c
      do 7171 i=1,nnn
      do 7171 j=1,nnn
      do 7171 k=1,nnn
      do 7171 l=1,nnn
 7171   gg(l,k,j,i)=0.d0
      call shellab(ii,jj,nbasis,natoms)
      if(iop(7).ne.0)call unconab(ii,jj)
      call invert2(s,ndeckl,sam,llimi,ni,llimj,nj,nnn)

   61 format(8f10.7)  
       do 11 i=1,m
       do 11 j=1,m
       b(i,j)=0.d0
  11   a(j,i)=0.d0

      iulimi=llimi+ni-1
      iulimj=llimj+nj-1

      ishift=llimi-1
      jshift=llimj-1-ni
      jshift0=llimj-1
       

      do 12 lambda=1,m
      do 12 mu0=1,ni
      mu=llimi+mu0-1
      x=0.d0
      do 13 isigm0=1,ni 
      isigm=isigm0+llimi-1
  13    x=x+s(lambda,isigm)*sam(isigm0,mu0)
      do 14 isigm0=1,nj
      isigm=isigm0+llimj-1
  14   x=x+s(lambda,isigm)*sam(isigm0+ni,mu0)
  12  a(lambda,mu)=x
      do 22 lambda=1,m
      do 22 mu0=1,nj
      mu=llimj+mu0-1
      x=0.d0
      do 23 isigm0=1,ni 
      isigm=isigm0+llimi-1
  23    x=x+s(lambda,isigm)*sam(isigm0,mu0+ni)
      do 24 isigm0=1,nj 
      isigm=isigm0+llimj-1
  24   x=x+s(lambda,isigm)*sam(isigm0+ni,mu0+ni)
  22  a(lambda,mu)=x

      do 32 mu=llimi,iulimi
      do 33 nu=llimi,iulimi
      x=0.d0
      xa=0.d0 
      do 34 igam=1,m
c 34  x=x+p(mu,igam)*A(igam,nu)
      x=x+p(mu,igam)*A(igam,nu)
  34  xa=xa+p(mu,igam)*aa(igam,nu,ii)
c 33  b(mu,nu)=x
      b(mu,nu)=x
      bba(mu,nu)=xa
  33  continue

      do 35 nu=llimj,iulimj
      x=0.d0
      xb=0.d0 
      do 36 igam=1,m
c 36  x=x+p(mu,igam)*A(igam,nu)
      x=x+p(mu,igam)*A(igam,nu)
  36  xb=xb+p(mu,igam)*aa(igam,nu,jj)
c 35  b(mu,nu)=x
      b(mu,nu)=x    
      bbb(mu,nu)=xb
  35  continue
  32  continue


      do 42 mu=llimj,iulimj
      do 43 nu=llimi,iulimi
      x=0.d0
      xa=0.d0
      do 44 igam=1,m
      xa=xa+p(mu,igam)*aa(igam,nu,ii)
  44  x=x+p(mu,igam)*A(igam,nu)
      bba(mu,nu)=xa
  43  b(mu,nu)=x

      do 45 nu=llimj,iulimj
      x=0.d0
      xb=0.d0 
      do 46 igam=1,m
      xb=xb+p(mu,igam)*aa(igam,nu,jj)
  46  x=x+p(mu,igam)*A(igam,nu)
      bbb(mu,nu)=xb
  45  b(mu,nu)=x
  42  continue
      
      eabfin=0.d0
       
      eabij=zn(ii)*zn(jj)/dsqrt((coord(1,ii)-coord(1,jj))**2+
     $(coord(2,ii)-coord(2,jj))**2+(coord(3,ii)-coord(3,jj))**2)


      eabpoint=(zn(ii)-popm(ii))*(zn(jj)-popm(jj))/
     $dsqrt((coord(1,ii)-coord(1,jj))**2+
     $(coord(2,ii)-coord(2,jj))**2+(coord(3,ii)-coord(3,jj))**2)

      eabpent=zn(ii)*zn(jj)/dsqrt((coord(1,ii)-coord(1,jj))**2+
     $(coord(2,ii)-coord(2,jj))**2+(coord(3,ii)-coord(3,jj))**2)
     $ -eabpoint
              
      do 1 nu=llimi,iulimi
      do 1 mu=llimj,iulimj
       
      x=t(mu,nu)+z(mu,nu,ii) 
      y=t(mu,nu)+z(mu,nu,jj) 

      do 2 itau=llimi,iulimi
   2  x=x-aa(mu,itau,ii)*(t(itau,nu)+z(itau,nu,ii))

      do 3 itau=llimj,iulimj
   3  y=y-aa(nu,itau,jj)*(t(itau,mu)+z(itau,mu,jj))
      f=p(nu,mu)*(x+y)
      bsse=bsse+f
      oneel=oneel+f
      eabfin=eabfin+f
   1  eabij=eabij+f  

      x=0.d0
      do 50 itau=llimi,iulimi
      do 51 mu=llimi,iulimi
 51   x=x+b(mu,itau)*z(itau,mu,jj)
      do 52 mu=llimj,iulimj
 52   x=x+b(mu,itau)*z(itau,mu,ii)
 50   continue 


      do 60 itau=llimj,iulimj
      do 64 mu=llimi,iulimi
 64   x=x+b(mu,itau)*z(itau,mu,jj)
      do 62 mu=llimj,iulimj
 62   x=x+b(mu,itau)*z(itau,mu,ii)
 60   continue 

      xaaa=0.d0
      do 160 itau=llimj,iulimj
      do 164 mu=llimi,iulimi
 164   xaaa=xaaa+p(mu,itau)*t(itau,mu)*2.d0
 160   continue 
      eabij=eabij+x
      oneel=oneel+x
      eabover=x
      

      xa=0.d0
      do 950 itau=llimi,iulimi
      do 950 mu=llimi,iulimi
 950  xa=xa+bba(mu,itau)*z(itau,mu,jj)

      xb=0.d0  
      do 960 itau=llimj,iulimj
      do 960 mu=llimj,iulimj
 960  xb=xb+bbb(mu,itau)*z(itau,mu,ii)

      eabpent=eabpent+xa+xb
      eabover=eabover-xa-xb

      x=0.d0

      do 99 i=1,m
      do 99 j=1,m
   99 a(i,j)=aa(i,j,ii)

      do 100 kappa=llimi,iulimi
      kappa0=kappa-ishift
      do 100 iro=llimi,iulimi
      iro0=iro-ishift
      do 100 nu=llimj,iulimj
      nu0=nu-jshift
      do 100 itau=llimi,iulimi
      itau0=itau-ishift

      xx=0.d0
      do 128 ieta=llimi,iulimi
      ieta0=ieta-ishift
 128  xx=xx+a(nu,ieta)*gi(itau0,ieta0,kappa0,iro0)

 100  gt(itau0,nu0,kappa0,iro0)=xx

      do 400 kappa=llimi,iulimi
      kappa0=kappa-ishift
      do 400 iro=llimi,iulimi
      iro0=iro-ishift
      do 400 nu=llimi,iulimi
      nu0=nu-ishift
      do 400 itau=llimi,iulimi
      itau0=itau-ishift

      xx=0.d0
      do 428 ieta=llimi,iulimi
      ieta0=ieta-ishift
 428  xx=xx+a(nu,ieta)*gi(itau0,ieta0,kappa0,iro0)

 400  gt(itau0,nu0,kappa0,iro0)=xx


      do 101 kappa=llimi,iulimi
      kappa0=kappa-ishift
      do 101 iro=llimi,iulimi
      iro0=iro-ishift


      do 102 igam=llimi,iulimi
      igam0=igam-ishift
      do 102 nu=llimj,iulimj
      nu0=nu-jshift
          
      y=gg(igam0,nu0,kappa0,iro0)
      
      do 103 itau=llimi,iulimi
      itau0=itau-ishift
      y=y-a(igam,itau)*gt(itau0,nu0,kappa0,iro0)
  103 continue

      x=x+y*pp(kappa,igam,iro,nu)
  102 continue

      do 111 igam=llimj,iulimj
      igam0=igam-jshift
      do 111 nu=llimi,iulimi
      nu0=nu-ishift
          
      y=gg(igam0,nu0,kappa0,iro0)

      do 112 itau=llimi,iulimi
      itau0=itau-ishift
      y=y-a(igam,itau)*gt(itau0,nu0,kappa0,iro0)
  112 continue

      x=x+y*pp(kappa,igam,iro,nu)
  111 continue


      do 121 igam=llimj,iulimj
      igam0=igam-jshift
      do 121 nu=llimj,iulimj
      nu0=nu-jshift
          
      y=gg(igam0,nu0,kappa0,iro0)

      do 122 itau=llimi,iulimi
      itau0=itau-ishift
      y=y-a(igam,itau)*gt(itau0,nu0,kappa0,iro0)
  122 continue

      x=x+y*pp(kappa,igam,iro,nu)
  121 continue

  101 continue


      do 199 i=1,m
      do 199 j=1,m
  199 a(i,j)=aa(i,j,jj)


      do 600 kappa=llimj,iulimj
      kappa0=kappa-jshift
      kappa1=kappa-jshift0
      do 600 iro=llimj,iulimj
      iro0=iro-jshift
      iro1=iro-jshift0
      do 600 nu=llimi,iulimi
      nu0=nu-ishift
      do 600 itau=llimj,iulimj
      itau0=itau-jshift0

      xx=0.d0
      do 628 ieta=llimj,iulimj
      ieta0=ieta-jshift0
 628  xx=xx+a(nu,ieta)*gj(itau0,ieta0,kappa1,iro1)

 600  gt(itau0,nu0,kappa1,iro1)=xx

      do 700 kappa=llimj,iulimj
      kappa0=kappa-jshift
      kappa1=kappa-jshift0
      do 700 iro=llimj,iulimj
      iro0=iro-jshift
      iro1=iro-jshift0
      do 700 nu=llimj,iulimj
      nu0=nu-jshift
      do 700 itau=llimj,iulimj
      itau0=itau-jshift0

      xx=0.d0
      do 728 ieta=llimj,iulimj
      ieta0=ieta-jshift0
 728  xx=xx+a(nu,ieta)*gj(itau0,ieta0,kappa1,iro1)

 700  gt(itau0,nu0,kappa1,iro1)=xx


      ecorri=x*0.5d0


      x2=0.d0
      do 200 kappa=llimj,iulimj
      kappa0=kappa-jshift
      do 200 iro=llimj,iulimj
      iro0=iro-jshift


      do 201 igam=llimj,iulimj
      igam0=igam-jshift
      do 201 nu=llimi,iulimi
      nu0=nu-ishift
          
      y=gg(igam0,nu0,kappa0,iro0)

      kappa1=kappa-jshift0
      iro1=iro-jshift0

      do 202 itau=llimj,iulimj
      itau0=itau-jshift0
      y=y-a(igam,itau)*gt(itau0,nu0,kappa1,iro1)
  202 continue

      x2=x2+y*pp(kappa,igam,iro,nu)
  201 continue
      

      do 211 igam=llimi,iulimi
      igam0=igam-ishift
      do 211 nu=llimj,iulimj
      nu0=nu-jshift
          
      y=gg(igam0,nu0,kappa0,iro0)

      do 212 itau=llimj,iulimj
      itau0=itau-jshift0
      y=y-a(igam,itau)*gt(itau0,nu0,kappa1,iro1)
  212 continue

      x2=x2+y*pp(kappa,igam,iro,nu)
  211 continue



      do 221 igam=llimi,iulimi
      igam0=igam-ishift
      do 221 nu=llimi,iulimi
      nu0=nu-ishift
          
      y=gg(igam0,nu0,kappa0,iro0)

      do 222 itau=llimj,iulimj
      itau0=itau-jshift0
      y=y-a(igam,itau)*gt(itau0,nu0,kappa1,iro1)
  222 continue

      x2=x2+y*pp(kappa,igam,iro,nu)
  221 continue

  200 continue

      eabij=eabij+0.5d0*(x+x2)
      eabfin=eabfin+0.5d0*(x+x2) 
  
      ecorrj=x2*0.5d0
      
      x=0.d0
      xbc=0.d0
      xov=0.d0
      xex=0.d0

      do 300 kappa=llimi,iulimi
      kappa0=kappa-ishift
      do 300 iro=llimj,iulimj
      iro0=iro-jshift
      
      do 310 itau=llimi,iulimi
      itau0=itau-ishift
      do 310 ieta=llimi,iulimi
      ieta0=ieta-ishift
  310 x=x+bb(kappa,itau,iro,ieta)*gg(kappa0,iro0,itau0,ieta0)  
     
      do 320 itau=llimi,iulimi
      itau0=itau-ishift
      do 320 ieta=llimj,iulimj
      ieta0=ieta-jshift
c 320 x=x+bb(kappa,itau,iro,ieta)*gg(kappa0,iro0,itau0,ieta0)  
      x=x+bb(kappa,itau,iro,ieta)*gg(kappa0,iro0,itau0,ieta0)  
      xbc=xbc+bcab(kappa,itau,iro,ieta)*gg(kappa0,iro0,itau0,ieta0)  
      xov=xov+bab(kappa,itau,iro,ieta)*gg(kappa0,iro0,itau0,ieta0)  
      xex=xex+cba(kappa,itau,iro,ieta)*gg(kappa0,iro0,itau0,ieta0)  
  320 continue     


      do 330 itau=llimj,iulimj
      itau0=itau-jshift
      do 330 ieta=llimi,iulimi
      ieta0=ieta-ishift
  330 x=x+bb(kappa,itau,iro,ieta)*gg(kappa0,iro0,itau0,ieta0)  


      do 340 itau=llimj,iulimj
      itau0=itau-jshift
      do 340 ieta=llimj,iulimj
      ieta0=ieta-jshift
  340 x=x+bb(kappa,itau,iro,ieta)*gg(kappa0,iro0,itau0,ieta0)  

  300 continue
      eabij=eabij+x
      eabover=eabover+x-xbc
      eabpent=eabpent+xov
      eabexch=xex
      eabelect=eabpoint+eabpent
      
      eabta=xaaa
      eabija=eabij+xaaa-eabfin
c     print *,i,j,eabfin

      return
      end


      subroutine invert1(sao,ndeckl,s,llim,m)        
      implicit real*8(a-h,o-z)
      dimension sao(ndeckl,ndeckl),s(m,m)

      do 1 i=1,m
      ieltol=llim+i-1 
      do 1 j=1,m
      jeltol=llim+j-1 
   1  s(j,i)=sao(jeltol,ieltol)
      
  61  format(1x,7f10.7)
      call inv1(s,m)
      return
      end



      subroutine invert2(sao,ndeckl,s,llima,ma,llimb,mb,m)
      implicit real*8(a-h,o-z)
      dimension sao(ndeckl,ndeckl),s(m,m)
 
      data isor/0/
      isor=isor+1

 
      do 1 i=1,ma
      ieltol=llima+i-1 
      do 1 j=1,ma
      jeltol=llima+j-1 
   1  s(j,i)=sao(jeltol,ieltol)
      do 2 i=1,mb
      ieltol=llimb+i-1 
      do 2 j=1,mb
      jeltol=llimb+j-1 
   2  s(ma+j,ma+i)=sao(jeltol,ieltol)
      do 3 i=1,mb
      ieltol=llimb+i-1 
      do 3 j=1,ma
      jeltol=llima+j-1 
   3  s(j,ma+i)=sao(jeltol,ieltol)
      do 4 i=1,ma
      ieltol=llima+i-1 
      do 4 j=1,mb
      jeltol=llimb+j-1 
   4  s(ma+j,i)=sao(jeltol,ieltol)
  61  format(1x,7f10.7)
      call inv1(s,m)
      return
      end
      subroutine pm(c,nocc,m,p,ndeckl)  
      implicit real*8(a-h,o-z)
      dimension c(ndeckl,ndeckl),p(ndeckl,ndeckl)
       do 1 i=1,m
       do 1 j=1,m
       x=0.d0
       do 2 k=1,nocc
  2     x=x+c(i,k)*c(j,k)
  1    p(i,j)=2.d0*x

  61  format(1x,8f9.7)

       return
       end


   
      SUBROUTINE INV1(S,M)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (NMAX=500)
      DIMENSION S(m,m),S23(NMAX),SM(nmax,nmax)
C INVERSION OF A REAL SYMMETRIC MATRIX BY DIAGONALIZATION
C  DIAGONALIZE S, BUILD S**(-1) - and put it in S !!!!
      CALL SDIAGI(S,M,S23)
      DO 4 I=1,M
      IF(S23(I).LE.1.D-25) STOP 1925
  4   S23(I)=1.D0/S23(I)
      DO 5 I=1,M
      DO 5 J=1,M
      Y=0.D0
      DO 6 K=1,M
  6   Y=Y+S(I,K)*S23(K)*S(J,K)
      SM(I,J)=Y
  5   SM(J,I)=Y
      do 7 j=1,m
      do 7 i=1,m
  7   s(i,j)=sm(i,j)
      RETURN
      END
      SUBROUTINE SDIAGI(X,n,D)
      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (NMAX=500)
C DIAGONALIZATION OF THE REAL SYMMETRIC MATRIX X. IN D THE EIGENVALUES.
      DIMENSION D(n)
      DIMENSION E(NMAX),X(n,n)
      EPS=5.D-15
      TOL=5.D-40
      IF(N.EQ.1) GOTO 400
    5 DO 150 NI=2,N
      II=N+2-NI
      DO 150 I=II,II
      L=I-2
      H=0.0D0
      G=X(I,I-1)
      IF(L)140,140,20
   20 DO 30 K=1,L
   30 H=H+X(I,K)*X(I,K)
      S=H+G*G
      IF(S.GE.TOL) GOTO 50
   40 H=0.0D0
      GO TO 140
   50 IF(H)140,140,60
   60 L=L+1
      F=G
      G=DSQRT(S)
      IF(F)75,75,70
   70 G=-G
   75 H=S-F*G
      X(I,I-1)=F-G
      F=0.0D0
      DO 110 J=1,L
      X(J,I)=X(I,J)/H
      S=0.0D0
      DO 80 K=1,J
   80 S=S+X(J,K)*X(I,K)
      J1=J+1
      IF(J1.GT.L) GOTO 100
   85 DO 90 K=J1,L
   90 S=S+X(K,J)*X(I,K)
  100 E(J)=S/H
  110 F=F+S*X(J,I)
      F=F/(H+H)
      DO 120 J=1,L
  120 E(J)=E(J)-F*X(I,J)
      DO 130 J=1,L
      F=X(I,J)
      S=E(J)
      DO 130 K=1,J
  130 X(J,K)=X(J,K)-F*E(K)-X(I,K)*S
  140 D(I)=H
  150 E(I-1)=G
  160 D(1)=X(1,1)
      X(1,1)=1.0D0
      DO 220 I=2,N
      L=I-1
      IF(D(I))200,200,170
  170 DO 190 J=1,L
      S=0.0D0
      DO 180 K=1,L
  180 S=S+X(I,K)*X(K,J)
      DO 190 K=1,L
  190 X(K,J)=X(K,J)-S*X(K,I)
  200 D(I)=X(I,I)
      X(I,I)=1.0D0
  210 DO 220 J=1,L
      X(I,J)=0.0D0
  220 X(J,I)=0.0D0
      B=0.0D0
      F=0.0D0
      E(N)=0.0D0
      DO 340 L=1,N
      H=EPS*(DABS(D(L))+DABS(E(L)))
      IF(H.GT.B) B=H
  235 DO 240 J=L,N
      IF(DABS(E(J)).LE.B) GO TO 250
  240 CONTINUE
  250 IF(J.EQ.L) GOTO 340
  260 P=(D(L+1)-D(L))*.50D0/E(L)
      R=DSQRT(P*P+1.0D0)
      IF(P)270,280,280
  270 P=P-R
      GO TO 290
  280 P=P+R
  290 H=D(L)-E(L)/P
      DO 300 I=L,N
  300 D(I)=D(I)-H
      F=F+H
      P=D(J)
      C=1.0D0
      S=0.0D0
      J1=J-1
      DO 330 NI=L,J1
      II=L+J1-NI
      DO 330 I=II,II
      G=C*E(I)
      G=C*E(I)
      H=C*P
      IF(DABS(P).LT.DABS(E(I))) GO TO 310
  305 C=E(I)/P
      R=DSQRT(C*C+1.0D0)
      E(I+1)=S*P*R
      S=C/R
      C=1.0D0/R
      GO TO 320
  310 C=P/E(I)
      R=DSQRT(C*C+1.0D0)
      E(I+1)=S*E(I)*R
      S=1.0D0/R
      C=C/R
  320 P=C*D(I)-S*G
      D(I+1)=H+S*(C*G+S*D(I))
      DO 330 K=1,N
      H=X(K,I+1)
      X(K,I+1)=X(K,I)*S+H*C
  330 X(K,I)=X(K,I)*C-H*S
      E(L)=S*P
      D(L)=C*P
      IF(DABS(E(L)).GT.B) GO TO 260
  340 D(L)=D(L)+F
      NI=N-1
  350 DO 380 I=1,NI
      K=I
      P=D(I)
      J1=I+1
      DO 360 J=J1,N
      IF(D(J).LE.P) GOTO 360
  355 K=J
      P=D(J)
  360 CONTINUE
      IF(K.EQ.I) GOTO 380
  365 D(K)=D(I)
      D(I)=P
      DO 370 J=1,N
      P=X(J,I)
      X(J,I)=X(J,K)
  370 X(J,K)=P
  380 CONTINUE
  390 GO TO 410
  400 D(1)=X(1,1)
      X(1,1)=1.0D0
  410 RETURN
      END
      subroutine inpint(g,mgmax,natoms,llim,iulim)
      IMPLICIT REAL*8 (A-H,O-Z)
      
      parameter (maxat=100)
      parameter (nmax=500)
      parameter (n128=500)
      dimension g(mgmax)
      dimension llim(n128),iulim(n128)
      common /pointer/ipoint(maxat),ijpoint(maxat,maxat),na(maxat)     
      common /hold/ihold(nmax),illim(n128)
      common /nat/ nat,igr,ifg,idum3(4)
      common iop(45)
     
      do i=1,natoms
      do mu=llim(i),iulim(i)
      ihold(mu)=i
      enddo
      enddo
   61 format(20i2)

       do i=1,natoms
       illim(i)=llim(i)
       enddo

      call gamgen
       do i=1,Natoms
      call shellat(i,igr,natoms)
      if(iop(7).ne.0)call unconat(i)
      enddo
        return      
      end

      subroutine bepack1(gf,ii,jj,kk,ll,llim,g,mi,ihold)
      implicit real*8(a-h,o-z)
      parameter (maxat=100)
      dimension llim(maxat),g(mi,mi,mi,mi),ihold(maxat)
      ih=ihold(ii)
      ishift=llim(ih)-1
      i=ii-ishift
      j=jj-ishift
      k=kk-ishift
      l=ll-ishift
      g(i,j,k,l)=gf
      g(j,i,l,k)=gf
      g(k,l,i,j)=gf
      g(l,k,j,i)=gf
      g(i,l,k,j)=gf
      g(l,i,j,k)=gf
      g(k,j,i,l)=gf
      g(j,k,l,i)=gf
      return
      end
      subroutine bepack2(gf,ii,jj,kk,ll,llim,g,mi,ihold,na)
      implicit real*8(a-h,o-z)
      parameter (maxat=100)
      dimension llim(maxat),g(mi,mi,mi,mi),ihold(maxat)
      dimension na(maxat)
      
      ih=ihold(ii)
      jh=ihold(jj)
      kh=ihold(kk)
      lh=ihold(ll)
      iat=min0(ih,jh,kh,lh)
      jat=max0(ih,jh,kh,lh)
      ni=na(iat)

      ishift=llim(ih)-1
      if(ih.eq.jat)ishift=ishift-ni

      jshift=llim(jh)-1
      if(jh.eq.jat)jshift=jshift-ni

      kshift=llim(kh)-1
      if(kh.eq.jat)kshift=kshift-ni

      lshift=llim(lh)-1
      if(lh.eq.jat)lshift=lshift-ni
     
      i=ii-ishift
      j=jj-jshift
      k=kk-kshift
      l=ll-lshift
      g(i,j,k,l)=gf
      g(j,i,l,k)=gf
      g(k,l,i,j)=gf
      g(l,k,j,i)=gf
      g(i,l,k,j)=gf
      g(l,i,j,k)=gf
      g(k,j,i,l)=gf
      g(j,k,l,i)=gf
      return
      end

      SUBROUTINE MPRINT(H,N,ndim)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION H(NDIM,NDIM)
      parameter (maxat=100)
      common /ia/ia(maxat),kkk,idummy

      Dimension mend(92)
      data mend/'  H ',' He ',' Li ',' Be ','  B ','  C ','  N ','  O ',
     $ '  F ',' Ne ',' Na ',' Mg ',' Al ',' Si ','  P ','  S ',' Cl ',
     $ ' Ar ','  K ',' Ca ',' Sc ',' Ti ','  V ',' Cr ',' Mn ',' Fe ',
     $ ' Co ',' Ni ',' Cu ',' Zn ',' Ga ',' Ge ',' As ',' Se ',' Br ',
     $ ' Kr ',' Rb ',' Sr ','  Y ',' Zr ',' Nb ',' Mo ',' Tc ',' Ru ',
     $ ' Rh ',' Pd ',' Ag ',' Cd ',' In ',' Sn ',' Sb ',' Te ','  I ',
     $ ' Xe ',' Cs ',' Ba ',' La ',' Ce ',' Pr ',' Nd ',' Pm ',' Sn ',
     $ ' Eu ',' Gd ',' Tb ',' Dy ',' Ho ',' Er ',' Tm ',' Yb ',' Lu ', 
     $ ' Hf ',' Ta ','  W ',' Re ',' Os ',' Ir ',' Pt ',' Au ',' Hg ',
     $ ' Tl ',' Pb ',' Bi ',' Po ',' At ',' Rn ',' Fr ',' Ra ',' Ac ',
     $ ' Th ',' Pa ','  U '  /
    
    
      K=8 
   65 FORMAT(1H0,40X,A4/)
      NMIN=1
      NMAX=MIN0(N,K)
   62 FORMAT(1X,I3,A4,8F9.4)
   1  PRINT 61, (I, mend(ia(i)),I=NMIN,NMAX)
   61 FORMAT(10X,8(1X,I3,A4,1X))
      PRINT 64
   64 FORMAT(1X)
      DO 2 I=1,N
      PRINT 62,I,mend(ia(i)),(H(I,J),J=NMIN,NMAX)
   2  CONTINUE
      NMIN=NMIN+8
      K=K+8
      NMAX=MIN0(N,K)
      IF(NMAX.GE.NMIN) GOTO 71
      RETURN
   71 PRINT 63
   63 FORMAT(1X///)
      GO TO 1
      END

      subroutine kiir
      implicit real*8(a-h,o-z)
      write(*,6670)
      write(*,6661)
 6661 format(/20x,'Program APOST, Version 1.05')
      write(*,6662)
 6662 format(20x,28(1h-),/)
      write(*,6663)
      write(*,6660)
 6663 format(3x,'Calculating:')
 6660 format(3x,'------------',/)
      write(*,6664)
 6664 format(5x,2hA),' Bond orders and valences (I. Mayer, Chem. Phys.'
     $,'Lett. 97, 270, 1983....)',/)
      write(*,6665)
 6665 format(5x,2hB),' Chemical Energy Component Analysis (I. Mayer, '
     $,'332, 381, 2000)',/)
      write(*,6666)
 6666 format(3x,'for a wave function obtained in a Gaussian ',
     $ 'calculation (G92, G94, G98, ...?)',//)
      write(*,6667)
      write(*,6668)
      write(*,6669)
 6667 format(2x,'Cite this program as:')
 6668 format(2x,'---------------------')
 6669 format(1x,'I. Mayer and A. Hamza, Program "APOST", Version 1.05'
     $ ,' (Chemical Research Center,',/,
     $ ' Hungarian Academy of Sciences), Budapest, January 2003.'/)
 6670 format(1x,79(1h-))
      write(*,6670)
      end
