      SUBROUTINE SHELLgen(nbas,natoms)

c Computes one-center two-electron integrals for S and P orbitals.

C     LINK 303
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     GAUSSIAN TWO ELECTRON INTEGRAL PACKAGE
C     MAIN LOOP OVER SHELLS ... SEE EXPLANATION IN PROGRAM GINPUT ...
C     LINK 301
C      ACCEPTS NUMBERS OF FOUR SHELLS
C     ISHELL  JSHELL  KSHELL  LSHELL
C     FINDS THEIR ANGULAR QUANTUM NUMBERS
C     AND
C     BASED ON THIS ORDERS SHELLS IN A STANDARD MANNER
C     INEW  JNEW  KNEW  LNEW
C     ONLY POSSIBILITIES ALLOWED FOR ANGULAR QUANTUM NUMBERS ARE THEN
C     0000  0001  0011  0101  0111  1111
C     DETERMINES TYPE OF INTEGRAL SET BASED ON THE ABOVE NUMBERS
C     CALLS THE FOLLOWING ROUTINES IN THE ORDER GIVEN
C     SHLOUT
C     FIRST TIME TO PRESET OUTPUT ROUTINES
C     FILMAX
C     TO PRESET INTEGRAL ACCURCY LIMITS
C     SINFO
C     OBTAINS GEOMETRICAL INFORMATION ABOUT THE FOUR CENTERS
C     FINDS TWO SETS OF LOCAL AXES
C     FOR CENTERS
C     A AND B  P SET
C     C AND D  Q SET
C     PINF
C     OBTAINS INFORMATION ABOUT GAUSSIAN FUNCTIONS CONNECTED WITH THE P
C     SET OF AXES
C     AT THIS POINT
C     SHELL OBTAINS INFORMATION ABOUT THE GAUSSIAN FUNCTIONS CONNECTED
C     WITH THE Q SET OF AXES
C     SP0000 TO SP1111
C     OBTAINS UP TO 88 INTEGRALS REFERRED TO AXES A B AND Q
C     ROT2
C     ROTATES THESE INTEGRALS TO UP TO 160 INTEGRALS ON A B AND Q
C     TQ0011 TO TQ1111
C     TRANSLATES THESE INTEGRALS ON A B AND Q TO UP TO 256 INTEGRALS ON
C     A B C AND D
C     R30001 TO R31111
C     ROTATES UP TO 256 INTEGRALS ON A B C AND D TO THE SAME NUMBER
C     REFERRED TO THE FIXED SPACE AXES
C     SHELL DETECTS SHELL COINCIDENCES AND ELIMINATES DUPLICATES
C     INTEGRALS ARE TRANSFERRED TO ROUTINE SHLOUT TO BE PUT ON DRUM
C     OR TAPE
C     A FINAL CALL TO SHLOUT CLOSES THE OUTPUT BUFFER
C*
C     ******************************************************************
C     OPTIONS ... IOP( )     SEE PROGRAM GINPUT ... SEGMENT 301
C     *****************************************************************
C*
      IMPLICIT REAL*8 (A-H,O-Z)

      parameter (maxat=100)
      parameter (maxg=1000)
      parameter (maxp=2000)
      parameter (mxc=16)
      parameter (maxc2=225)
C*
      INTEGER SHELLA,SHELLN,SHELLT,AOS,AON
C*
      COMMON IOP(52)
      COMMON iNATOMS,ICHARG,MULTIP,IAN(35),NAE,NBE,NE,NBASIS,CO(35,3)
      COMMON IUNIT(20),INFO(5)
C*
      COMMON/CONST/CONST,conp(maxc2)
      COMMON/SHLNOS/ISHELL,JSHELL,KSHELL,LSHELL,INEW,JNEW,KNEW,LNEW
      COMMON/SHLINF/NGA,LA,AG(10),CSA(10),CPA(10),NGB,LB,BG(10),CSB(10),
     *CPB(10),NGC,LC,CG(10),CSC(10),CPC(10),NGD,LD,DG(10),
     *CSD(10),CPD(10)
      COMMON/LT/LAT,LBT,LCT,LDT
      COMMON/MISC/MAB,MCD,NGANGB
      COMMON/GEOM/AX,AY,AZ,BX,BY,BZ,CX,CY,CZ,DX,DY,DZ,RAB,RABSQ,RCD,
     *RCDSQ,P11,P12,P13,P21,P22,P23,P31,P32,P33,Q11,Q12,Q13,
     *Q21,Q22,Q23,Q31,Q32,Q33
      COMMON/PQGEOM/AP,BP,CQ,DQ,PX,PY,PZ,QX,QY,QZ,RPQ,RPQSQ,PQ1,PQ2,PQ3,
     *C11,C12,C13,C21,C22,C23,C31,C32,C33
      COMMON/GINF/GA,GB,GC,GD,SA,SB,SC,SD,PA,PB,PC,PD,GAB,GCD
      COMMON/H/H(160)
      COMMON/TYPE/ITYPE,JTYPE
      COMMON/GOUT/GOUT(256)
      COMMON/PGEOM/GP(maxc2),EP(maxc2),DP00P(maxc2),DP01P(maxc2),
     $  DP10P(maxc2),DP11P(maxc2),APP(maxc2),BPP(maxc2)
      COMMON/EABECD/EAB,ECD
      COMMON/DPQ/DP00,DP01,DP10,DP11,DQ00,DQ01,DQ10,DQ11
      COMMON/COS/C
      COMMON/PHI/COSP,SINP
      COMMON/QGEOM/ACX,ACY,ACZ,ACY2,COSG,SING,AQX,AQZ,QPERP,QPERP2
      COMMON/MAXC/CMAX(maxp),CMAXA(mxc),CMAXB(mxc),CMAXC(mxc),
     $  CMAXD(mxc),
     *ISMLP(maxc2),ISMLQ,ISML,ifal,ERROR1,ERROR2
      COMMON/B/EXX(maxp),C1(maxp),C2(maxp),C3(240),
     *X(maxp),Y(maxp),Z(maxp),JAN(80),SHELLA(maxp),SHELLN(maxp),
     *SHELLT(maxp),AOS(maxg),AON(20),NSHELL,MAXTYP
      common/ihol/ihold(maxg),ihsh(maxg),icent
      COMMON/AUXVAR/AUXVAR,VAR1,VAR2
      COMMON/TABLE/TTT(6000)
      COMMON/IO/IN,IOUT,IPUNCH
       COMMON/IQ/ IFALQ
      common /limits/llsh(maxg),iulsh(maxg),ist
      DATA ZERO/0.0D0/,ONE/1.0D0/
      DATA SIXTY/60.0D0/
      DATA P00005/5.0D-5/
      data istart/0/
      if(istart.gt.0)goto 123
      nbasis=nbas
 613   format(1p5e15.7)
      istart=istart+1
      ist=istart

       ialim=aos(2)-1
      do 1600 i=1,aos(2)-1
 1600 ihold(i)=1
      ih=1
      ihs=1
      ihsh(1)=1
      llsh(1)=1
      do 1601 ksh=2,nshell
      if(x(ksh).ne.x(ksh-1).or.y(ksh).ne.y(ksh-1).or.
     $ z(ksh).ne.z(ksh-1))then
      ih=ih+1
      ihs=ihs+1
      iulsh(ihs-1)=ksh-1
      llsh(ihs)=ksh
      endif
      ihsh(ksh)=ihs
      do 1602 i=aos(ksh),aos(ksh+1)-1
 1602 ihold(i)=ih
 1601 continue
      iulsh(natoms)=nshell
  611 format(10i3)

      CALL SHLOUTg(-1)
C     FILL COMMON MAXC ... USED IN DISCARDING SMALL (LESS THAN 10**-6)
C     INTEGRALS BEFORE THEY ARE FULLY EVALUATED
      CALL FILMAX

 123  continue


      DO 730 ISHELL=1,nshell
      DO 720 JSHELL=1,ISHELL
      DO 710 KSHELL=1,ISHELL
      IF(ISHELL-KSHELL)50,60,50
   50 MAXL=KSHELL
      GO TO 70
   60 MAXL=JSHELL
   70 DO 700 LSHELL=1,MAXL

      icent=1
      LAT=SHELLT(ISHELL)
      LBT=SHELLT(JSHELL)
      LCT=SHELLT(KSHELL)
      LDT=SHELLT(LSHELL)
      ndtyp=lat/2+lbt/2+lct/2+ldt/2
      if(ndtyp.gt.0)goto 700
      ITYPE=8*LAT+4*LBT+2*LCT+LDT+1
      GO TO (110,110,130,110,140,110,130,110,160,120,150,120,140,140,170
     *,110),ITYPE
C     TYPES 0000,0001,0101,0011,0111,1111 ARE UNALTERED
  110 INEW=ISHELL
      JNEW=JSHELL
      KNEW=KSHELL
      LNEW=LSHELL
      LA=LAT
      LB=LBT
      LC=LCT
      LD=LDT
      GO TO 180
C     TYPES 1001,1011 HAVE IJ SWITCHED
  120 INEW=JSHELL
      JNEW=ISHELL
      KNEW=KSHELL
      LNEW=LSHELL
      LA=LBT
      LB=LAT
      LC=LCT
      LD=LDT
      GO TO 180
C     TYPES 0010,0110 HAVE KL SWITCHED
  130 INEW=ISHELL
      JNEW=JSHELL
      KNEW=LSHELL
      LNEW=KSHELL
      LA=LAT
      LB=LBT
      LC=LDT
      LD=LCT
      GO TO 180
C     TYPES 0100,1100,1101 HAVE PAIRS IJ AND KL SWITCHED
  140 INEW=KSHELL
      JNEW=LSHELL
      KNEW=ISHELL
      LNEW=JSHELL
      LA=LCT
      LB=LDT
      LC=LAT
      LD=LBT
      GO TO 180
C     TYPE 1010 HAS IJ SWITCHED AND KL SWITCHED
  150 INEW=JSHELL
      JNEW=ISHELL
      KNEW=LSHELL
      LNEW=KSHELL
      LA=LBT
      LB=LAT
      LC=LDT
      LD=LCT
      GO TO 180
C     TYPE HAS PAIRS IJ AND KL SWITCHED FOLLOWED BY KL SWITCH
  160 INEW=KSHELL
      JNEW=LSHELL
      KNEW=JSHELL
      LNEW=ISHELL
      LA=LCT
      LB=LDT
      LC=LBT
      LD=LAT
      GO TO 180
C     TYPE 1110 HAS PAIRS IJ AND KL SWITCHED FOLLOWED BY IJ SWITCH
  170 INEW=LSHELL
      JNEW=KSHELL
      KNEW=ISHELL
      LNEW=JSHELL
      LA=LDT
      LB=LCT
      LC=LAT
      LD=LBT
  180 CONTINUE
C     ONLY 6 STANDARD TYPES REMAIN. 0000,0001,0011,0101,0111,1111
C     SPECIFY THESE BY JTYPE
      GO TO (190,200,200,210,200,220,220,230,200,220,220,230,210,230,230
     *,240),ITYPE
  190 JTYPE=1
      NGOUT=1
      GO TO 250
  200 JTYPE=2
      NGOUT=4
      GO TO 250
  210 JTYPE=3
      NGOUT=16
      GO TO 250
  220 JTYPE=4
      NGOUT=64
      GO TO 250
  230 JTYPE=5
      NGOUT=64
      GO TO 250
  240 JTYPE=6
      NGOUT=256
  250 CONTINUE
C     EMPTY COMMON GOUT
      DO 260 I=1,NGOUT
  260 GOUT(I)=ZERO
      CALL SINFO
      CALL SGEOM
C     PRELIMINARY P LOOP
      CALL PINF
C     IF 0000 USE SPECIAL ROUTINE
      IF (JTYPE-1) 270,270,280
  270 CALL SP0000
      GO TO 690
C     BEGIN Q LOOP
  280 DO 490 K =1,NGC
      GC=CG(K)
      DO 490 L =1,NGD
      GD=DG(L)
      GCD=GC+GD
      ECD=ONE/GCD
      CQ=GD*ECD*RCD
      DQ=CQ-RCD
      XQQ=CQ*DQ*GCD
      IF(XQQ+SIXTY)182,184,184
  182 V=ZERO
      GO TO 186
  184 V=DEXP(XQQ)*ECD
  186 XXTEST=CMAXC(K)*CMAXD(L)*V
      IF(XXTEST-ERROR1)300,300,290
  290 ISMLQ=0
      GO TO 320
  300 IF(XXTEST-ERROR2)490,490,310
  310 ISMLQ=1
  320 SC=CSC(K)
      SD=CSD(L)
      PC=CPC(K)
      PD=CPD(L)
      DQ00=SC*SD*V
      DQ01=SC*PD*V
      DQ10=PC*SD*V
      DQ11=PC*PD*V
C     FIND COORDINATES OF Q RELATIVE TO AXES AT A
C     QPERP IS PERPENDICULAR FROM Q TO AB
      AQX=ACX+SING*CQ
      AQZ=ACZ+COSG*CQ
      QPERP2=AQX*AQX+ACY2
      QPERP=DSQRT(QPERP2)
C     PHI IS 180 - AZIMUTHAL ANGLE FOR AQ IN AB LOCAL AXIS SYSTEM
      IF(QPERP-P00005)340,340,330
  330 COSP=-AQX/QPERP
      SINP=-ACY/QPERP
      GO TO 350
  340 COSP=ONE
      SINP=ZERO
C     USE SPECIAL FAST ROUTINE FER INNER LOOP FOR 0101
  350 IF(JTYPE-4)370,360,370
  360 CALL SP0101
      GO TO 430
  370 IF(JTYPE-5)390,380,390
  380 CALL SP0111
      GO TO 430
  390 CONTINUE
C     BEGIN P LOOP
C     USE SPECIAL FAST ROUTINES FOR INNER LOOPS FOR 0001 AND 0011
      IF (JTYPE-3) 400,410,420
  400 CALL SP0001
      GO TO 490
  410 CALL SP0011
      GO TO 430
  420 CALL SP1111
  430 CALL ROT2
  440 GO TO (490,490,450,460,470,480),JTYPE
  450 CONTINUE
      CALL TQ0011
      GO TO 490
  460 CALL TQ0101
      GO TO 490
  470 CALL TQ0111
      GO TO 490
  480 CALL TQ1111
  490 CONTINUE
      GO TO (550,500,510,520,530,540),JTYPE
  500 CALL R30001
      GO TO 550
  510 CALL R30011
      GO TO 550
  520 CALL R30101
      GO TO 550
  530 CALL R30111
      GO TO 550
  540 CALL R31111
C     TEST FOR SHELL COINCIDENCES AND ELIMINATE DUPLICATES
  550 IF (JNEW-INEW) 600,560,600
  560 DO 570 I=17,64
  570 GOUT(I)=ZERO
      DO 580 I=97,128
  580 GOUT(I)=ZERO
      DO 590 I=177,192
  590 GOUT(I)=ZERO
  600 IF (LNEW-KNEW) 630,610,630
  610 DO 620 I=1,16
      GOUT(16*I-14)=ZERO
      GOUT(16*I-13)=ZERO
      GOUT(16*I-12)=ZERO
      GOUT(16*I- 9)=ZERO
      GOUT(16*I- 8)=ZERO
  620 GOUT(16*I- 4)=ZERO
  630 IF (KNEW-INEW) 690,640,690
  640 IF (LNEW-JNEW) 690,650,690
  650 IND=0
      DO 680 I=1,4
      DO 680 J=1,4
      DO 680 K=1,4
      DO 680 L=1,4
      IND=IND+1
      IF (I-K) 670,660,680
  660 IF (J-L) 670,680,680
  670 GOUT(IND)=ZERO
  680 CONTINUE
  690 CALL SHLOUTg(NGOUT)
  700 CONTINUE
  710 CONTINUE
  720 CONTINUE
  730 CONTINUE
C     RESET OUTPUT ROUTINE
      CALL SHLOUTg(0)

      return
      END
      SUBROUTINE SHLOUTg(LIMIT)
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     TWO ELECTRON INTEGRAL OUTPUT ROUTINE
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER SHELLA,SHELLN,SHELLT,AOS,AON
      parameter (maxp=2000)
      parameter (maxg=1000)
      parameter (maxat=100)
      parameter (nmax=500)
      parameter (ndeckl=500)
      parameter (n128=500)
c     common /pointer/ipoint(maxat),ijpoint(maxat,maxat),na(maxat)     
      dimension llim(n128)
      common /hold/jhold(nmax),llim
C*
      COMMON IOP(52)
      COMMON NATOMS,ICHARG,MULTIP,IAN(35),NAE,NBE,NE,NBASIS,C(35,3)
      COMMON IUNIT(20),INFO(5)
C*
      COMMON/B/EXX(maxp),C1(maxp),C2(maxp),C3(240),
     *X(maxp),Y(maxp),Z(maxp),JAN(80),SHELLA(maxp),SHELLN(maxp),
     *SHELLT(maxp),AOS(maxg),AON(20),NSHELL,MAXTYP
      COMMON/SHLNOS/ISHELL,JSHELL,KSHELL,LSHELL,INEW,JNEW,KNEW,LNEW
      COMMON/PACKED/IN,JN,KN,LN,IJKL,JA
      COMMON/GOUT/GOUT(256)
      COMMON/IO/IIN,IOUT,IPUNCH
      COMMON/ICOUNT/ICOUNT
      COMMON/IQ/IQ
      common/ihol/ihold(maxg),ihsh(maxg),icent
      common/comp/ecomp1(maxat,maxat)
      common /c/cdummy(ndeckl,ndeckl),p(ndeckl,ndeckl)
      common /ia/ia(maxat),kop,idummy
c
      EQUIVALENCE (IUNIT(11),INTAPE)
C*
c     DIMENSION IX(3200)
c     DIMENSION XXP(4),IXP(4),JXP(4),KXP(4),LXP(4)
C*
      DATA CUTOFF/1.0D-12/
      DATA TEN/10.0D0/
C*
 1000 FORMAT(4(I9,3I3,G12.6))
 1010 FORMAT(1H1,20X,'TWO ELECTRON INTEGRALS',//)
C*
      if(kop.ne.0)then
      call shloutgo(limit)
      return
      endif
      IF(LIMIT)11,345,50
C     PRELIMINARY ENTRY
   11 IF(IOP(12))20,30,20
   20 CUTOFF=TEN**(-IOP(12))
   30 ICOUNT=1
c     REWIND INTAPE
      IQ=1
      IF(IOP(14).NE.0) WRITE (IOUT,1010)
      RETURN
C     NORMAL ENTRY
C     INTEGRALS IN COMMON /GOUT/ WAITING TO BE WRITTEN OUT
C     DETERMINE NUMBERS OF THE FIRST ATOMIC ORBITALS IN EACH OF THE FOUR
C     SHELLS
   50 IP=AOS(INEW)-1
      JP=AOS(JNEW)-1
      KP=AOS(KNEW)-1
      LP=AOS(LNEW)-1
      NCOUNT=0
      DO 340 I=1,4
      DO 340 J=1,4
      DO 340 K=1,4
      DO 340 L=1,4
      NCOUNT=NCOUNT+1
C     TEST FOR END OF COMMON /GOUT/
      IF(LIMIT-NCOUNT) 345,60,60
C     DECIDE WHETHER OR NOT A PARTICULAR INTEGRAL IS LARGE ENOUGH
C     TO WARRANT KEEPING
   60 IF(DABS(GOUT(NCOUNT))-CUTOFF) 340,340,70
C     KEEP THE INTEGRAL
C     ORDER ATOMIC ORBITALS SUCH THAT
C     I GE J
C     K GE L
C     I GE K
C     IF I EQ K
C     THEN J GE L
C     INTEGRAL OVER ATOMIC ORBITALS  (IJ/KL)
   70 IN=IP+I
      JN=JP+J
      KN=KP+K
      LN=LP+L
      gf=GOUT(NCOUNT)
c Itt van meg az integral (gout) es az indexek (in,jn,kn,ln)
      call code(in,kn,jn,ln,i1,i2,i3,i4,kulcs)
      goto(1,1,1,4,4,4,7,7,7,10,10,12,13,14) kulcs 
    1 ip1=ihold(i1)
      ip2=ihold(i2)
      ip3=ihold(i3)
      ip4=ihold(i4)
      ppd=p(i3,i1)*p(i4,i2)-0.5d0*p(i4,i1)*p(i3,i2) 
      ppd1=p(i3,i1)*p(i4,i2)-0.5d0*p(i4,i3)*p(i1,i2) 
      if(ip3.le.ip4) ecomp1(ip3,ip4)=ecomp1(ip3,ip4)+ppd*gf         
      if(ip3.gt.ip4) ecomp1(ip4,ip3)=ecomp1(ip4,ip3)+ppd*gf         
      if(ip2.le.ip3) ecomp1(ip2,ip3)=ecomp1(ip2,ip3)+ppd1*gf         
      if(ip2.gt.ip3) ecomp1(ip3,ip2)=ecomp1(ip3,ip2)+ppd1*gf         
      ecomp1(ip1,ip4)=ecomp1(ip1,ip4)+ppd1*gf         
      ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd*gf        
      goto 9999
    4 ip1=ihold(i1)
      ip2=ihold(i3)
      ip3=ihold(i4) 
      ppd=0.5d0*p(i3,i1)*p(i4,i1)
      ppd1=p(i3,i1)*p(i1,i4)-0.5d0*p(i1,i1)*p(i3,i4) 
      if(ip1.le.ip2) ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd1*gf        
      if(ip2.lt.ip1) ecomp1(ip2,ip1)=ecomp1(ip2,ip1)+ppd1*gf         
      if(ip1.le.ip3) ecomp1(ip1,ip3)=ecomp1(ip1,ip3)+ppd1*gf        
      if(ip3.lt.ip1) ecomp1(ip3,ip1)=ecomp1(ip3,ip1)+ppd1*gf         
      ecomp1(ip2,ip3)=ecomp1(ip2,ip3)+ppd*gf         
      ecomp1(ip1,ip1)=ecomp1(ip1,ip1)+ppd*gf         
      goto 9999
    7 ip1=ihold(i1)
      ip2=ihold(i2)
      ip3=ihold(i4)
      ppd=p(i1,i1)*p(i4,i2)-0.5d0*p(i4,i1)*p(i1,i2) 
      if(ip1.le.ip3) ecomp1(ip1,ip3)=ecomp1(ip1,ip3)+ppd*gf        
      if(ip3.lt.ip1) ecomp1(ip3,ip1)=ecomp1(ip3,ip1)+ppd*gf         
      if(ip1.le.ip2) ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd*gf        
      if(ip2.lt.ip1) ecomp1(ip2,ip1)=ecomp1(ip2,ip1)+ppd*gf         
      goto 9999
   10 ip1=ihold(i1)
      ip2=ihold(i4)
      ppd=0.5d0*p(i1,i1)*p(i4,i1)
      if(ip1.le.ip2) ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd*gf         
      if(ip2.lt.ip1) ecomp1(ip2,ip1)=ecomp1(ip2,ip1)+ppd*gf         
      ecomp1(ip1,ip1)=ecomp1(ip1,ip1)+ppd*gf         
      goto 9999
   12 ip1=ihold(i1)
      ppd=0.5d0*p(i1,i1)*p(i1,i1)    
      ecomp1(ip1,ip1)=ecomp1(ip1,ip1)+0.5d0*ppd*gf
      goto 9999
   13 ip1=ihold(i1)
      ip2=ihold(i2)
      ppd=p(i1,i1)*p(i2,i2)-0.5d0*p(i2,i1)*p(i1,i2) 
      ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd*gf
      goto 9999
   14 ip1=ihold(i1)
      ip2=ihold(i3)
      ppd=0.5d0*p(i3,i1)*p(i3,i1)
      ppd1=p(i1,i3)*p(i1,i3)-0.5d0*p(i1,i1)*p(i3,i3)
      ecomp1(ip1,ip1)=ecomp1(ip1,ip1)+0.5d0*ppd*gf
      ecomp1(ip2,ip2)=ecomp1(ip2,ip2)+0.5d0*ppd*gf
      ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd1*gf
      goto 9999
 9999 continue
 3400 CONTINUE
  340 CONTINUE
  345 RETURN
      END
      SUBROUTINE CODE(K1,K2,K3,K4,I1,I2,I3,I4,KULCS)
      IMPLICIT REAL*8 (A-H,O-Z)
      J1=K1
      J2=K2
      J3=K3
      J4=K4
      IF(J1.EQ.J3) GO TO 200
      IF(J2.EQ.J4) GO TO 100
C THIS ROUTINE DETERMINES THE TYPE OF THE TWO-ELECTRON INTEGRAL ACCORDIN
C TO WHICH IT IS TO BE USED IN FMATR AND TRANSFORMS THE ORDER OF THE
C INDICES INTO THE REQUIRED ONE.(CLASSIFICATION INTO THE 14 POSSIBLE
C CLASSES. WRITTEN BY I. MAYER, BUDAPEST 1974/75)
C
C  KULCS=1  IF I1.LT.I2.LT.I3.LT.I4
C  KULCS=2  IF I1.LT.I2.LT.I4.LT.I3
C  KULCS=3  IF I1.LT.I3.LT.I2.LT.I4
C  KULCS=4  IF I1=I2.LT.I3.LT.I4
C  KULCS=5  IF I1=I2 AND I3.LT.I1.LT.I4
C  KULCS=6  IF I1=I2 AND I3.LT.I4.LT.I1
C  KULCS=7  IF I1=I3 AND I1.LT.I2.LT.I4
C  KULCS=8  IF I1=I3 AND I2.LT.I1.LT.I4
C  KULCS=9  IF I1=I3 AND I2.LT.I4.LT.I3
C  KULCS=10 IF I1=I2=I3.LT.I4
C  KULCS=11 IF I1=I2=I3.GT.I4
C  KULCS=12 IF I1=I2=I3=I4
C  KULCS=13 IF I1=I3.LT.I2=I4
C  KULCS=14 IF I1=I2.LT.I3=I4
C   ...NOTE THAT THE CONVENTION (12/12) IS USED FOR THE INTEGRALS
C      (I1,I2 IN THE BRA, I3,I4 IN THE KET)
      IF(J1-J2) 601,600,601
  601 IF(J1-J4) 602,620,602
  602 IF(J2-J3) 603,621,603
  603 IF(J3-J4) 700,604,700
  620 JT=J2
      J2=J4
      J4=JT
      GO TO 600
  621 J3=J1
      J1=J2
      GO TO 600
  604 J3=J1
      J1=J4
      J4=J2
      J2=J1
  600 IF(J3-J4) 605,606,607
  607 JT=J4
      J4=J3
      J3=JT
  605 IF(J1-J3) 609,504,608
  504 STOP 05
  609 KULCS=4
      GO TO 1000
  608 IF(J1-J4) 610,505,611
  505 STOP 06
  610 KULCS=5
      GO TO 1000
  611 KULCS=6
      GO TO 1000
  606 IF(J1-J3) 612,506,613
  506 STOP 07
  613 J1=J3
      J3=J2
      J2=J1
      J4=J3
  612 KULCS=14
      GO TO 1000
  507 STOP 10
  508 STOP 11
  509 STOP 12
  510 STOP 13
  511 STOP 14
  700 IF(J1-J3) 701,507,702
  702 JT=J1
      J1=J3
      J3=JT
  701 IF(J2-J4) 703,508,704
  704 JT=J2
      J2=J4
      J4=JT
  703 IF(J1-J2) 705,509,706
  706 JT=J1
      J1=J2
      J2=JT
      JT=J3
      J3=J4
      J4=JT
  705 IF(J3-J2) 707,510,708
  707 KULCS=3
      GO TO 1000
  708 IF(J3-J4) 709,511,710
  709 KULCS=1
      GO TO 1000
  710 KULCS=2
      GO TO 1000
  100 JT=J1
      J1=J2
      J2=JT
      JT=J3
      J3=J4
      J4=JT
      GO TO 210
  200 IF(J2.EQ.J4) GO TO 300
  210 IF(J2-J1) 212,211,212
  213 JT=J2
      J2=J4
      J4=JT
  211 IF(J1-J4) 214,215,216
  212 IF(J4-J1) 400,213,400
  300 IF(J1-J2) 301,302,303
  214 KULCS=10
      GO TO 1000
  215 STOP 01
  216 KULCS=11
      GO TO 1000
  303 J1=J2
      J2=J3
      J3=J1
      J4=J2
  301 KULCS=13
      GO TO 1000
  302 KULCS=12
      GO TO 1000
  400 IF(J2-J4) 401,501,402
  501 STOP 02
  402 JT=J4
      J4=J2
      J2=JT
  401 IF(J1-J2) 403,502,404
  502 STOP 03
  403 KULCS=7
      GO TO 1000
  404 IF(J1-J4) 405,503,406
  503 STOP 04
  405 KULCS=8
      GO TO 1000
  406 KULCS=9
 1000 I1=J1
      I2=J2
      I3=J3
      I4=J4
      RETURN
      END
      SUBROUTINE SHLOUTgo(LIMIT)
C*
C     --------------
C     QCPE VERSION
C     DECEMBER 1971
C     --------------
C*
C     TWO ELECTRON INTEGRAL OUTPUT ROUTINE
C*
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER SHELLA,SHELLN,SHELLT,AOS,AON
      parameter (maxp=2000)
      parameter (maxg=1000)
      parameter (maxat=100)
      parameter (nmax=500)
      parameter (ndeckl=500)
      parameter (n128=500)
c     common /pointer/ipoint(maxat),ijpoint(maxat,maxat),na(maxat)     
      dimension llim(n128)
      common /hold/jhold(nmax),llim
C*
      COMMON IOP(52)
      COMMON NATOMS,ICHARG,MULTIP,IAN(35),NAE,NBE,NE,NBASIS,C(35,3)
      COMMON IUNIT(20),INFO(5)
C*
      COMMON/B/EXX(maxp),C1(maxp),C2(maxp),C3(240),
     *X(maxp),Y(maxp),Z(maxp),JAN(80),SHELLA(maxp),SHELLN(maxp),
     *SHELLT(maxp),AOS(maxg),AON(20),NSHELL,MAXTYP
      COMMON/SHLNOS/ISHELL,JSHELL,KSHELL,LSHELL,INEW,JNEW,KNEW,LNEW
      COMMON/PACKED/IN,JN,KN,LN,IJKL,JA
      COMMON/GOUT/GOUT(256)
      COMMON/IO/IIN,IOUT,IPUNCH
      COMMON/ICOUNT/ICOUNT
      COMMON/IQ/IQ
      common/ihol/ihold(maxg),ihsh(maxg),icent
      common/comp/ecomp1(maxat,maxat)
      common /c/ca(ndeckl,ndeckl),p(ndeckl,ndeckl)
      common/pab/pa(ndeckl,ndeckl),pb(ndeckl,ndeckl)
c
      EQUIVALENCE (IUNIT(11),INTAPE)
C*
c     DIMENSION IX(3200)
c     DIMENSION XXP(4),IXP(4),JXP(4),KXP(4),LXP(4)
C*
      DATA CUTOFF/1.0D-12/
      DATA TEN/10.0D0/

      
C*
 1000 FORMAT(4(I9,3I3,G12.6))
 1010 FORMAT(1H1,20X,'TWO ELECTRON INTEGRALS',//)
C*
      IF(LIMIT)11,345,50
C     PRELIMINARY ENTRY
   11 IF(IOP(12))20,30,20
   20 CUTOFF=TEN**(-IOP(12))
   30 ICOUNT=1
c     REWIND INTAPE
      IQ=1
      IF(IOP(14).NE.0) WRITE (IOUT,1010)
      RETURN
C     NORMAL ENTRY
C     INTEGRALS IN COMMON /GOUT/ WAITING TO BE WRITTEN OUT
C     DETERMINE NUMBERS OF THE FIRST ATOMIC ORBITALS IN EACH OF THE FOUR
C     SHELLS
   50 IP=AOS(INEW)-1
      JP=AOS(JNEW)-1
      KP=AOS(KNEW)-1
      LP=AOS(LNEW)-1
      NCOUNT=0
      DO 340 I=1,4
      DO 340 J=1,4
      DO 340 K=1,4
      DO 340 L=1,4
      NCOUNT=NCOUNT+1
C     TEST FOR END OF COMMON /GOUT/
      IF(LIMIT-NCOUNT) 345,60,60
C     DECIDE WHETHER OR NOT A PARTICULAR INTEGRAL IS LARGE ENOUGH
C     TO WARRANT KEEPING
   60 IF(DABS(GOUT(NCOUNT))-CUTOFF) 340,340,70
C     KEEP THE INTEGRAL
C     ORDER ATOMIC ORBITALS SUCH THAT
C     I GE J
C     K GE L
C     I GE K
C     IF I EQ K
C     THEN J GE L
C     INTEGRAL OVER ATOMIC ORBITALS  (IJ/KL)
   70 IN=IP+I
      JN=JP+J
      KN=KP+K
      LN=LP+L
      gf=GOUT(NCOUNT)
c Itt van meg az integral (gout) es az indexek (in,i2n,kn,ln)
      call code(in,kn,jn,ln,i1,i2,i3,i4,kulcs)
       goto(1,1,1,4,4,4,7,7,7,10,10,12,13,14) kulcs 
    1  ip1=ihold(i1)
       ip2=ihold(i2)
       ip3=ihold(i3)
       ip4=ihold(i4)
       ppd=p(i3,i1)*p(i4,i2)-pa(i4,i1)*pa(i3,i2)-pb(i4,i1)*pb(i3,i2) 
       ppd1=p(i3,i1)*p(i4,i2)-pa(i4,i3)*pa(i1,i2)-pb(i4,i3)*pb(i1,i2) 
       if(ip3.le.ip4) ecomp1(ip3,ip4)=ecomp1(ip3,ip4)+ppd*gf         
       if(ip3.gt.ip4) ecomp1(ip4,ip3)=ecomp1(ip4,ip3)+ppd*gf         
       if(ip2.le.ip3) ecomp1(ip2,ip3)=ecomp1(ip2,ip3)+ppd1*gf         
       if(ip2.gt.ip3) ecomp1(ip3,ip2)=ecomp1(ip3,ip2)+ppd1*gf         
       ecomp1(ip1,ip4)=ecomp1(ip1,ip4)+ppd1*gf         
       ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd*gf        
c       print *,'ecomp-2o',ecomp1(ip1,ip2)
       goto 9999
    4  ip1=ihold(i1)
       ip2=ihold(i3)
       ip3=ihold(i4) 
       ppd=p(i3,i1)*p(i4,i1)-pa(i3,i1)*pa(i4,i1)-pb(i3,i1)*pb(i4,i1)
       ppd1=p(i3,i1)*p(i1,i4)-pa(i1,i1)*pa(i3,i4)-pb(i1,i1)*pb(i3,i4) 
       if(ip1.le.ip2) ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd1*gf        
       if(ip2.lt.ip1) ecomp1(ip2,ip1)=ecomp1(ip2,ip1)+ppd1*gf         
       if(ip1.le.ip3) ecomp1(ip1,ip3)=ecomp1(ip1,ip3)+ppd1*gf        
       if(ip3.lt.ip1) ecomp1(ip3,ip1)=ecomp1(ip3,ip1)+ppd1*gf         
       ecomp1(ip2,ip3)=ecomp1(ip2,ip3)+ppd*gf         
       ecomp1(ip1,ip1)=ecomp1(ip1,ip1)+ppd*gf         
       goto 9999
    7  ip1=ihold(i1)
       ip2=ihold(i2)
       ip3=ihold(i4)
       ppd=p(i1,i1)*p(i4,i2)-pa(i4,i1)*pa(i1,i2)-pb(i4,i1)*pb(i1,i2) 
       if(ip1.le.ip3) ecomp1(ip1,ip3)=ecomp1(ip1,ip3)+ppd*gf        
       if(ip3.lt.ip1) ecomp1(ip3,ip1)=ecomp1(ip3,ip1)+ppd*gf         
       if(ip1.le.ip2) ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd*gf        
       if(ip2.lt.ip1) ecomp1(ip2,ip1)=ecomp1(ip2,ip1)+ppd*gf         
       goto 9999
   10  ip1=ihold(i1)
       ip2=ihold(i4)
       ppd=p(i1,i1)*p(i4,i1)-pa(i1,i1)*pa(i4,i1)-pb(i1,i1)*pb(i4,i1)
       if(ip1.le.ip2) ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd*gf         
       if(ip2.lt.ip1) ecomp1(ip2,ip1)=ecomp1(ip2,ip1)+ppd*gf         
       ecomp1(ip1,ip1)=ecomp1(ip1,ip1)+ppd*gf         
       goto 9999
   12  ip1=ihold(i1)
       ppd=p(i1,i1)*p(i1,i1)-pa(i1,i1)*pa(i1,i1)-pb(i1,i1)*pb(i1,i1)    
       ecomp1(ip1,ip1)=ecomp1(ip1,ip1)+0.5d0*ppd*gf
       goto 9999
   13  ip1=ihold(i1)
       ip2=ihold(i2)
       ppd=p(i1,i1)*p(i2,i2)-pa(i2,i1)*pa(i1,i2)-pb(i2,i1)*pb(i1,i2) 
       ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd*gf
       goto 9999
   14  ip1=ihold(i1)
       ip2=ihold(i3)
       ppd=p(i3,i1)*p(i3,i1)-pa(i3,i1)*pa(i3,i1)-pb(i3,i1)*pb(i3,i1)
       ppd1=p(i1,i3)*p(i1,i3)-pa(i1,i1)*pa(i3,i3)-pb(i1,i1)*pb(i3,i3)
       ecomp1(ip1,ip1)=ecomp1(ip1,ip1)+0.5d0*ppd*gf
       ecomp1(ip2,ip2)=ecomp1(ip2,ip2)+0.5d0*ppd*gf
       ecomp1(ip1,ip2)=ecomp1(ip1,ip2)+ppd1*gf
       goto 9999

 9999 continue

  340 CONTINUE
  345 RETURN
      END
